/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.UnreachableCodeLightTreeHelperKt;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\u001a\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002\u001a<\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\b\b\u0002\u0010\u0011\u001a\u00020\b\u001aB\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u0011\u001a\u00020\b\u001a<\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u0011\u001a\u00020\b\u001a\f\u0010\u0016\u001a\u00020\u0006*\u00020\bH\u0000\u001a\u001a\u0010\u0017\u001a\u00020\b*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002\u001a\u001a\u0010\u0018\u001a\u00020\b*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0000\"\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"DOC_AND_COMMENT_TOKENS", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "FILLER_TOKENS", "hasSyntaxErrors", "", "node", "Lcom/intellij/lang/LighterASTNode;", "tree", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "markElement", "", "Lcom/intellij/openapi/util/TextRange;", "startOffset", "", "endOffset", "originalNode", "markRange", "from", "to", "markSingleElement", "isFiller", "nonFillerFirstChildOrSelf", "nonFillerLastChildOrSelf", "frontend.common-psi"})
public final class LightTreePositioningStrategyKt {
    @NotNull
    private static final Set<IElementType> DOC_AND_COMMENT_TOKENS;
    @NotNull
    private static final Set<IElementType> FILLER_TOKENS;

    @NotNull
    public static final List<TextRange> markElement(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, @NotNull LighterASTNode originalNode) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(tree, "tree");
        Intrinsics.checkNotNullParameter(originalNode, "originalNode");
        return LightTreePositioningStrategyKt.markRange(node, node, startOffset, endOffset, tree, originalNode);
    }

    public static /* synthetic */ List markElement$default(LighterASTNode lighterASTNode2, int n, int n2, FlyweightCapableTreeStructure flyweightCapableTreeStructure, LighterASTNode lighterASTNode3, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            lighterASTNode3 = lighterASTNode2;
        }
        return LightTreePositioningStrategyKt.markElement(lighterASTNode2, n, n2, flyweightCapableTreeStructure, lighterASTNode3);
    }

    @NotNull
    public static final List<TextRange> markRange(@NotNull LighterASTNode from2, @NotNull LighterASTNode to, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, @NotNull LighterASTNode originalNode) {
        Intrinsics.checkNotNullParameter(from2, "from");
        Intrinsics.checkNotNullParameter(to, "to");
        Intrinsics.checkNotNullParameter(tree, "tree");
        Intrinsics.checkNotNullParameter(originalNode, "originalNode");
        return CollectionsKt.listOf(LightTreePositioningStrategyKt.markSingleElement(from2, to, startOffset, endOffset, tree, originalNode));
    }

    @NotNull
    public static final TextRange markSingleElement(@NotNull LighterASTNode from2, @NotNull LighterASTNode to, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, @NotNull LighterASTNode originalNode) {
        Intrinsics.checkNotNullParameter(from2, "from");
        Intrinsics.checkNotNullParameter(to, "to");
        Intrinsics.checkNotNullParameter(tree, "tree");
        Intrinsics.checkNotNullParameter(originalNode, "originalNode");
        LighterASTNode betterFrom = LightTreePositioningStrategyKt.nonFillerFirstChildOrSelf(from2, tree);
        LighterASTNode betterTo = LightTreePositioningStrategyKt.nonFillerLastChildOrSelf(to, tree);
        int startDelta = tree.getStartOffset(betterFrom) - tree.getStartOffset(originalNode);
        int endDelta = tree.getEndOffset(betterTo) - tree.getEndOffset(originalNode);
        return new TextRange(startDelta + startOffset, endDelta + endOffset);
    }

    private static final LighterASTNode nonFillerFirstChildOrSelf(LighterASTNode $this$nonFillerFirstChildOrSelf, FlyweightCapableTreeStructure<LighterASTNode> tree) {
        LighterASTNode lighterASTNode2;
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = UnreachableCodeLightTreeHelperKt.getChildren($this$nonFillerFirstChildOrSelf, tree);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                LighterASTNode it = (LighterASTNode)element$iv;
                boolean bl = false;
                if (!(!LightTreePositioningStrategyKt.isFiller(it))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((lighterASTNode2 = (LighterASTNode)v0) == null) {
            lighterASTNode2 = $this$nonFillerFirstChildOrSelf;
        }
        return lighterASTNode2;
    }

    @NotNull
    public static final LighterASTNode nonFillerLastChildOrSelf(@NotNull LighterASTNode $this$nonFillerLastChildOrSelf, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
        LighterASTNode lighterASTNode2;
        LighterASTNode lighterASTNode3;
        block2: {
            Intrinsics.checkNotNullParameter($this$nonFillerLastChildOrSelf, "<this>");
            Intrinsics.checkNotNullParameter(tree, "tree");
            List<LighterASTNode> $this$lastOrNull$iv = UnreachableCodeLightTreeHelperKt.getChildren($this$nonFillerLastChildOrSelf, tree);
            boolean $i$f$lastOrNull = false;
            ListIterator<LighterASTNode> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                LighterASTNode element$iv;
                LighterASTNode it = element$iv = iterator$iv.previous();
                boolean bl = false;
                if (!(!LightTreePositioningStrategyKt.isFiller(it))) continue;
                lighterASTNode3 = element$iv;
                break block2;
            }
            lighterASTNode3 = null;
        }
        if ((lighterASTNode2 = (LighterASTNode)lighterASTNode3) == null) {
            lighterASTNode2 = $this$nonFillerLastChildOrSelf;
        }
        return lighterASTNode2;
    }

    public static final boolean isFiller(@NotNull LighterASTNode $this$isFiller) {
        Intrinsics.checkNotNullParameter($this$isFiller, "<this>");
        return FILLER_TOKENS.contains($this$isFiller.getTokenType());
    }

    private static final boolean hasSyntaxErrors(LighterASTNode node, FlyweightCapableTreeStructure<LighterASTNode> tree) {
        boolean bl;
        LighterASTNode lighterASTNode2;
        block5: {
            if (Intrinsics.areEqual(node.getTokenType(), TokenType.ERROR_ELEMENT)) {
                return true;
            }
            Ref<T[]> childrenRef = new Ref<T[]>();
            tree.getChildren(node, childrenRef);
            LighterASTNode[] lighterASTNodeArray = (LighterASTNode[])childrenRef.get();
            if (lighterASTNodeArray == null) {
                return false;
            }
            LighterASTNode[] children2 = lighterASTNodeArray;
            List<LighterASTNode> $this$lastOrNull$iv = ArraysKt.filterNotNull(children2);
            boolean $i$f$lastOrNull = false;
            ListIterator<LighterASTNode> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                LighterASTNode element$iv;
                LighterASTNode it = element$iv = iterator$iv.previous();
                boolean bl2 = false;
                IElementType tokenType = it.getTokenType();
                if (!(!(tokenType instanceof KtSingleValueToken) && !DOC_AND_COMMENT_TOKENS.contains(tokenType))) continue;
                lighterASTNode2 = element$iv;
                break block5;
            }
            lighterASTNode2 = null;
        }
        LighterASTNode lighterASTNode3 = lighterASTNode2;
        if (lighterASTNode3 != null) {
            LighterASTNode it = lighterASTNode3;
            boolean bl3 = false;
            bl = LightTreePositioningStrategyKt.hasSyntaxErrors(it, tree);
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean access$hasSyntaxErrors(LighterASTNode node, FlyweightCapableTreeStructure tree) {
        return LightTreePositioningStrategyKt.hasSyntaxErrors(node, tree);
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.WHITE_SPACE, KtTokens.IDENTIFIER, KtTokens.EOL_COMMENT, KtTokens.BLOCK_COMMENT, KtTokens.SHEBANG_COMMENT, KtTokens.DOC_COMMENT};
        DOC_AND_COMMENT_TOKENS = SetsKt.setOf(iElementTypeArray);
        iElementTypeArray = new IElementType[]{KtTokens.WHITE_SPACE, KtTokens.EOL_COMMENT, KtTokens.BLOCK_COMMENT, KtTokens.SHEBANG_COMMENT, KtTokens.DOC_COMMENT};
        FILLER_TOKENS = SetsKt.setOf(iElementTypeArray);
    }
}

