/*
 * Copyright (c) 2018-2020, Andreas Kling <kling@serenityos.org>
 *
 * SPDX-License-Identifier: BSD-2-Clause
 */

#pragma once

#include <Kernel/Devices/CharacterDevice.h>

namespace Kernel {

class RandomDevice final : public CharacterDevice {
    friend class DeviceManagement;

public:
    static NonnullLockRefPtr<RandomDevice> must_create();
    virtual ~RandomDevice() override;

private:
    RandomDevice();

    // ^CharacterDevice
    virtual ErrorOr<size_t> read(OpenFileDescription&, u64, UserOrKernelBuffer&, size_t) override;
    virtual ErrorOr<size_t> write(OpenFileDescription&, u64, UserOrKernelBuffer const&, size_t) override;
    virtual bool can_read(OpenFileDescription const&, u64) const override;
    virtual bool can_write(OpenFileDescription const&, u64) const override { return true; }
    virtual StringView class_name() const override { return "RandomDevice"sv; }
};

}
