/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.osmand.PlatformUtil;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.ui.OsmBitmapPanel;
import org.apache.commons.logging.Log;

public class OffRoadUIThread
implements Runnable {
    protected static final Log log = PlatformUtil.getLog(OffRoadUIThread.class);
    protected OffRoadUIThread mNextThread = null;
    private boolean hasFinished = false;
    protected boolean mShouldContinue = false;
    protected OsmBitmapPanel mOsmBitmapPanel;
    private Set<OffRoadUIThreadListener> mListeners = new HashSet<OffRoadUIThreadListener>();
    protected String mName;

    public String toString() {
        return "OffRoadUIThread [" + this.getClass().getName() + "]";
    }

    public OffRoadUIThread(OsmBitmapPanel pOsmBitmapPanel, String pName) {
        this.mOsmBitmapPanel = pOsmBitmapPanel;
        this.mName = pName;
    }

    public void addListener(OffRoadUIThreadListener pListener) {
        this.mListeners.add(pListener);
    }

    public void removeListener(OffRoadUIThreadListener pListener) {
        this.mListeners.remove(pListener);
    }

    public void setNextThread(OffRoadUIThread pNextThread) {
        this.mNextThread = pNextThread;
    }

    public void shouldContinue() {
        this.mShouldContinue = true;
    }

    public void runInBackground() {
    }

    public void runAfterThreadsBeforeHaveFinished() throws InvocationTargetException, InterruptedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            for (OffRoadUIThreadListener listener : this.mListeners) {
                listener.threadStarted(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.runInBackground();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.waitForThreadBeforeHaveFinished();
        try {
            this.runAfterThreadsBeforeHaveFinished();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Iterator<OffRoadUIThreadListener> iterator = this;
        synchronized (iterator) {
            log.debug((Object)("THREAD:" + this + " Notify next threads..."));
            if (this.mNextThread != null) {
                this.mNextThread.shouldContinue();
            }
            this.hasFinished = true;
        }
        for (OffRoadUIThreadListener listener : this.mListeners) {
            listener.threadFinished(this);
        }
    }

    protected void waitForThreadBeforeHaveFinished() {
        while (!this.mShouldContinue) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        log.debug((Object)("THREAD:" + this + " should continue."));
    }

    public boolean hasFinished() {
        return this.hasFinished;
    }

    protected boolean findSuccessor(Class<? extends OffRoadUIThread> pTypeOfSuccessor) {
        if (this.mNextThread == null) {
            return false;
        }
        if (pTypeOfSuccessor.isAssignableFrom(this.mNextThread.getClass())) {
            return true;
        }
        return this.mNextThread.findSuccessor(pTypeOfSuccessor);
    }

    protected String printQueue() {
        String ret = this.getName() + ", ";
        if (this.mNextThread != null) {
            ret = ret + this.mNextThread.printQueue();
        }
        return ret;
    }

    protected OsmWindow getContext() {
        return this.mOsmBitmapPanel.getContext();
    }

    public String getName() {
        return this.mName;
    }

    public static interface OffRoadUIThreadListener {
        public void threadStarted(OffRoadUIThread var1);

        public void threadFinished(OffRoadUIThread var1);
    }
}

