/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.main;

import org.opensearch.Build;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.action.ActionListener;
import org.opensearch.action.main.MainRequest;
import org.opensearch.action.main.MainResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.node.Node;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TransportMainAction
extends HandledTransportAction<MainRequest, MainResponse> {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(TransportMainAction.class);
    public static final String OVERRIDE_MAIN_RESPONSE_VERSION_KEY = "compatibility.override_main_response_version";
    public static final Setting<Boolean> OVERRIDE_MAIN_RESPONSE_VERSION = Setting.boolSetting("compatibility.override_main_response_version", false, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final String OVERRIDE_MAIN_RESPONSE_VERSION_DEPRECATION_MESSAGE = "overriding main response version number will be removed in a future version";
    private final String nodeName;
    private final ClusterService clusterService;
    private volatile String responseVersion;

    @Inject
    public TransportMainAction(Settings settings, TransportService transportService, ActionFilters actionFilters, ClusterService clusterService) {
        super("cluster:monitor/main", transportService, actionFilters, MainRequest::new);
        this.nodeName = Node.NODE_NAME_SETTING.get(settings);
        this.clusterService = clusterService;
        this.setResponseVersion(OVERRIDE_MAIN_RESPONSE_VERSION.get(settings));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(OVERRIDE_MAIN_RESPONSE_VERSION, this::setResponseVersion);
    }

    private void setResponseVersion(boolean isResponseVersionOverrideEnabled) {
        if (isResponseVersionOverrideEnabled) {
            DEPRECATION_LOGGER.deprecate(OVERRIDE_MAIN_RESPONSE_VERSION.getKey(), OVERRIDE_MAIN_RESPONSE_VERSION_DEPRECATION_MESSAGE, new Object[0]);
            this.responseVersion = LegacyESVersion.V_7_10_2.toString();
        } else {
            this.responseVersion = Build.CURRENT.getQualifiedVersion();
        }
    }

    @Override
    protected void doExecute(Task task, MainRequest request, ActionListener<MainResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        listener.onResponse(new MainResponse(this.nodeName, Version.CURRENT, clusterState.getClusterName(), clusterState.metadata().clusterUUID(), Build.CURRENT, this.responseVersion));
    }
}

