/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.WriteableSetting;
import org.opensearch.extensions.AcknowledgedResponse;
import org.opensearch.extensions.AddSettingsUpdateConsumerRequest;
import org.opensearch.extensions.DiscoveryExtensionNode;
import org.opensearch.extensions.UpdateSettingsRequest;
import org.opensearch.extensions.UpdateSettingsResponseHandler;
import org.opensearch.transport.TransportResponse;
import org.opensearch.transport.TransportService;

public class AddSettingsUpdateConsumerRequestHandler {
    private static final Logger logger = LogManager.getLogger(AddSettingsUpdateConsumerRequestHandler.class);
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final String updateSettingsRequestType;

    public AddSettingsUpdateConsumerRequestHandler(ClusterService clusterService, TransportService transportService, String updateSettingsRequestType) {
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.updateSettingsRequestType = updateSettingsRequestType;
    }

    TransportResponse handleAddSettingsUpdateConsumerRequest(AddSettingsUpdateConsumerRequest addSettingsUpdateConsumerRequest) throws Exception {
        boolean status = true;
        List<WriteableSetting> extensionComponentSettings = addSettingsUpdateConsumerRequest.getComponentSettings();
        DiscoveryExtensionNode extensionNode = addSettingsUpdateConsumerRequest.getExtensionNode();
        try {
            for (WriteableSetting extensionComponentSetting : extensionComponentSettings) {
                Setting<?> setting = extensionComponentSetting.getSetting();
                WriteableSetting.SettingType settingType = extensionComponentSetting.getType();
                this.clusterService.getClusterSettings().addSettingsUpdateConsumer(setting, data -> {
                    logger.debug("Sending extension request type: " + this.updateSettingsRequestType);
                    UpdateSettingsResponseHandler updateSettingsResponseHandler = new UpdateSettingsResponseHandler();
                    this.transportService.sendRequest(extensionNode, this.updateSettingsRequestType, new UpdateSettingsRequest(settingType, setting, data), updateSettingsResponseHandler);
                });
            }
        }
        catch (IllegalArgumentException e) {
            logger.error(e.toString());
            status = false;
        }
        return new AcknowledgedResponse(status);
    }
}

