/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.node;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SNIHostName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.SetOnce;
import org.opensearch.Assertions;
import org.opensearch.Build;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchTimeoutException;
import org.opensearch.Version;
import org.opensearch.action.ActionModule;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.cluster.snapshots.status.TransportNodesSnapshotsStatus;
import org.opensearch.action.search.SearchExecutionStatsCollector;
import org.opensearch.action.search.SearchPhaseController;
import org.opensearch.action.search.SearchTransportService;
import org.opensearch.action.support.TransportAction;
import org.opensearch.action.update.UpdateHelper;
import org.opensearch.bootstrap.BootstrapCheck;
import org.opensearch.bootstrap.BootstrapContext;
import org.opensearch.client.Client;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.ClusterInfoService;
import org.opensearch.cluster.ClusterModule;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateObserver;
import org.opensearch.cluster.InternalClusterInfoService;
import org.opensearch.cluster.NodeConnectionsService;
import org.opensearch.cluster.action.index.MappingUpdatedAction;
import org.opensearch.cluster.metadata.AliasValidator;
import org.opensearch.cluster.metadata.Manifest;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.MetadataCreateDataStreamService;
import org.opensearch.cluster.metadata.MetadataCreateIndexService;
import org.opensearch.cluster.metadata.MetadataIndexUpgradeService;
import org.opensearch.cluster.metadata.SystemIndexMetadataUpgradeService;
import org.opensearch.cluster.metadata.TemplateUpgradeService;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodeRole;
import org.opensearch.cluster.routing.BatchedRerouteService;
import org.opensearch.cluster.routing.RerouteService;
import org.opensearch.cluster.routing.allocation.AwarenessReplicaBalance;
import org.opensearch.cluster.routing.allocation.DiskThresholdMonitor;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.StopWatch;
import org.opensearch.common.breaker.CircuitBreaker;
import org.opensearch.common.component.Lifecycle;
import org.opensearch.common.component.LifecycleComponent;
import org.opensearch.common.inject.Injector;
import org.opensearch.common.inject.Key;
import org.opensearch.common.inject.Module;
import org.opensearch.common.inject.ModulesBuilder;
import org.opensearch.common.io.stream.NamedWriteableRegistry;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.logging.HeaderWarning;
import org.opensearch.common.logging.NodeAndClusterIdStateListener;
import org.opensearch.common.network.NetworkAddress;
import org.opensearch.common.network.NetworkModule;
import org.opensearch.common.network.NetworkService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.ConsistentSettingsService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.SettingUpgrader;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsModule;
import org.opensearch.common.transport.BoundTransportAddress;
import org.opensearch.common.transport.TransportAddress;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.FeatureFlags;
import org.opensearch.common.util.PageCacheRecycler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.core.internal.io.IOUtils;
import org.opensearch.discovery.Discovery;
import org.opensearch.discovery.DiscoveryModule;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.env.NodeMetadata;
import org.opensearch.extensions.ExtensionsManager;
import org.opensearch.extensions.NoopExtensionsManager;
import org.opensearch.gateway.GatewayAllocator;
import org.opensearch.gateway.GatewayMetaState;
import org.opensearch.gateway.GatewayModule;
import org.opensearch.gateway.GatewayService;
import org.opensearch.gateway.MetaStateService;
import org.opensearch.gateway.PersistedClusterStateService;
import org.opensearch.http.HttpServerTransport;
import org.opensearch.index.IndexModule;
import org.opensearch.index.IndexingPressureService;
import org.opensearch.index.analysis.AnalysisRegistry;
import org.opensearch.index.store.RemoteSegmentStoreDirectoryFactory;
import org.opensearch.indices.IndicesModule;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.ShardLimitValidator;
import org.opensearch.indices.SystemIndexDescriptor;
import org.opensearch.indices.SystemIndices;
import org.opensearch.indices.analysis.AnalysisModule;
import org.opensearch.indices.breaker.BreakerSettings;
import org.opensearch.indices.breaker.CircuitBreakerService;
import org.opensearch.indices.breaker.HierarchyCircuitBreakerService;
import org.opensearch.indices.breaker.NoneCircuitBreakerService;
import org.opensearch.indices.cluster.IndicesClusterStateService;
import org.opensearch.indices.recovery.PeerRecoverySourceService;
import org.opensearch.indices.recovery.PeerRecoveryTargetService;
import org.opensearch.indices.recovery.RecoverySettings;
import org.opensearch.indices.replication.SegmentReplicationSourceFactory;
import org.opensearch.indices.replication.SegmentReplicationSourceService;
import org.opensearch.indices.replication.SegmentReplicationTargetService;
import org.opensearch.indices.store.IndicesStore;
import org.opensearch.ingest.IngestService;
import org.opensearch.monitor.MonitorService;
import org.opensearch.monitor.fs.FsHealthService;
import org.opensearch.monitor.jvm.JvmInfo;
import org.opensearch.node.NodeService;
import org.opensearch.node.NodeValidationException;
import org.opensearch.node.ResponseCollectorService;
import org.opensearch.persistent.PersistentTasksClusterService;
import org.opensearch.persistent.PersistentTasksExecutor;
import org.opensearch.persistent.PersistentTasksExecutorRegistry;
import org.opensearch.persistent.PersistentTasksService;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.AnalysisPlugin;
import org.opensearch.plugins.CircuitBreakerPlugin;
import org.opensearch.plugins.ClusterPlugin;
import org.opensearch.plugins.DiscoveryPlugin;
import org.opensearch.plugins.EnginePlugin;
import org.opensearch.plugins.IndexStorePlugin;
import org.opensearch.plugins.IngestPlugin;
import org.opensearch.plugins.MapperPlugin;
import org.opensearch.plugins.MetadataUpgrader;
import org.opensearch.plugins.NetworkPlugin;
import org.opensearch.plugins.PersistentTaskPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.PluginsService;
import org.opensearch.plugins.RepositoryPlugin;
import org.opensearch.plugins.ScriptPlugin;
import org.opensearch.plugins.SearchPlugin;
import org.opensearch.plugins.SystemIndexPlugin;
import org.opensearch.repositories.RepositoriesModule;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.RestController;
import org.opensearch.script.ScriptContext;
import org.opensearch.script.ScriptEngine;
import org.opensearch.script.ScriptModule;
import org.opensearch.script.ScriptService;
import org.opensearch.search.SearchModule;
import org.opensearch.search.SearchService;
import org.opensearch.search.aggregations.support.AggregationUsageService;
import org.opensearch.search.backpressure.SearchBackpressureService;
import org.opensearch.search.backpressure.settings.SearchBackpressureSettings;
import org.opensearch.search.fetch.FetchPhase;
import org.opensearch.search.query.QueryPhase;
import org.opensearch.snapshots.InternalSnapshotsInfoService;
import org.opensearch.snapshots.RestoreService;
import org.opensearch.snapshots.SnapshotShardsService;
import org.opensearch.snapshots.SnapshotsInfoService;
import org.opensearch.snapshots.SnapshotsService;
import org.opensearch.tasks.TaskCancellationService;
import org.opensearch.tasks.TaskResourceTrackingService;
import org.opensearch.tasks.TaskResultsService;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.RunnableTaskExecutionListener;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.RemoteClusterService;
import org.opensearch.transport.Transport;
import org.opensearch.transport.TransportInterceptor;
import org.opensearch.transport.TransportService;
import org.opensearch.usage.UsageService;
import org.opensearch.watcher.ResourceWatcherService;

public class Node
implements Closeable {
    public static final Setting<Boolean> WRITE_PORTS_FILE_SETTING = Setting.boolSetting("node.portsfile", false, Setting.Property.NodeScope);
    private static final Setting<Boolean> NODE_DATA_SETTING = Setting.boolSetting("node.data", true, Setting.Property.Deprecated, Setting.Property.NodeScope);
    private static final Setting<Boolean> NODE_MASTER_SETTING = Setting.boolSetting("node.master", true, Setting.Property.Deprecated, Setting.Property.NodeScope);
    private static final Setting<Boolean> NODE_INGEST_SETTING = Setting.boolSetting("node.ingest", true, Setting.Property.Deprecated, Setting.Property.NodeScope);
    private static final Setting<Boolean> NODE_REMOTE_CLUSTER_CLIENT = Setting.boolSetting("node.remote_cluster_client", RemoteClusterService.ENABLE_REMOTE_CLUSTERS, Setting.Property.Deprecated, Setting.Property.NodeScope);
    public static final Setting<Boolean> NODE_LOCAL_STORAGE_SETTING = Setting.boolSetting("node.local_storage", true, Setting.Property.Deprecated, Setting.Property.NodeScope);
    public static final Setting<String> NODE_NAME_SETTING = Setting.simpleString("node.name", Setting.Property.NodeScope);
    public static final Setting.AffixSetting<String> NODE_ATTRIBUTES = Setting.prefixKeySetting("node.attr.", key -> new Setting<String>((String)key, "", value -> {
        if (value.length() > 0 && (Character.isWhitespace(value.charAt(0)) || Character.isWhitespace(value.charAt(value.length() - 1)))) {
            throw new IllegalArgumentException(key + " cannot have leading or trailing whitespace [" + value + "]");
        }
        if (value.length() > 0 && "node.attr.server_name".equals(key)) {
            try {
                new SNIHostName((String)value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("invalid node.attr.server_name [" + value + "]", e);
            }
        }
        return value;
    }, Setting.Property.NodeScope));
    public static final Setting<String> BREAKER_TYPE_KEY = new Setting<String>("indices.breaker.type", "hierarchy", s -> {
        switch (s) {
            case "hierarchy": 
            case "none": {
                return s;
            }
        }
        throw new IllegalArgumentException("indices.breaker.type must be one of [hierarchy, none] but was: " + s);
    }, Setting.Property.NodeScope);
    private static final String CLIENT_TYPE = "node";
    private final Lifecycle lifecycle = new Lifecycle();
    private final Logger logger = LogManager.getLogger(Node.class);
    private final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(Node.class);
    private final Injector injector;
    private final Environment environment;
    private final NodeEnvironment nodeEnvironment;
    private final PluginsService pluginsService;
    private final ExtensionsManager extensionsManager;
    private final NodeClient client;
    private final Collection<LifecycleComponent> pluginLifecycleComponents;
    private final LocalNodeFactory localNodeFactory;
    private final NodeService nodeService;
    final NamedWriteableRegistry namedWriteableRegistry;
    private final AtomicReference<RunnableTaskExecutionListener> runnableTaskListener;

    public Node(Environment environment) {
        this(environment, Collections.emptyList(), true);
    }

    protected Node(Environment initialEnvironment, Collection<Class<? extends Plugin>> classpathPlugins, boolean forbidPrivateIndexSettings) {
        ArrayList<Closeable> resourcesToClose = new ArrayList<Closeable>();
        boolean success = false;
        try {
            Settings tmpSettings = Settings.builder().put(initialEnvironment.settings()).put(Client.CLIENT_TYPE_SETTING_S.getKey(), CLIENT_TYPE).put(NODE_ATTRIBUTES.getKey() + "shard_indexing_pressure_enabled", "true").build();
            JvmInfo jvmInfo = JvmInfo.jvmInfo();
            this.logger.info("version[{}], pid[{}], build[{}/{}/{}], OS[{}/{}/{}], JVM[{}/{}/{}/{}]", new Object[]{Build.CURRENT.getQualifiedVersion(), jvmInfo.pid(), Build.CURRENT.type().displayName(), Build.CURRENT.hash(), Build.CURRENT.date(), Constants.OS_NAME, Constants.OS_VERSION, Constants.OS_ARCH, Constants.JVM_VENDOR, Constants.JVM_NAME, Constants.JAVA_VERSION, Constants.JVM_VERSION});
            if (jvmInfo.getBundledJdk()) {
                this.logger.info("JVM home [{}], using bundled JDK [{}]", (Object)System.getProperty("java.home"), (Object)jvmInfo.getUsingBundledJdk());
            } else {
                this.logger.info("JVM home [{}]", (Object)System.getProperty("java.home"));
                this.deprecationLogger.deprecate("no-jdk", "no-jdk distributions that do not bundle a JDK are deprecated and will be removed in a future release", new Object[0]);
            }
            this.logger.info("JVM arguments {}", (Object)Arrays.toString(jvmInfo.getInputArguments()));
            if (!Build.CURRENT.isProductionRelease()) {
                this.logger.warn("version [{}] is a pre-release version of OpenSearch and is not suitable for production", (Object)Build.CURRENT.getQualifiedVersion());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("using config [{}], data [{}], logs [{}], plugins [{}]", (Object)initialEnvironment.configFile(), (Object)Arrays.toString(initialEnvironment.dataFiles()), (Object)initialEnvironment.logsFile(), (Object)initialEnvironment.pluginsFile());
            }
            this.pluginsService = new PluginsService(tmpSettings, initialEnvironment.configFile(), initialEnvironment.modulesFile(), initialEnvironment.pluginsFile(), classpathPlugins);
            this.extensionsManager = FeatureFlags.isEnabled("opensearch.experimental.feature.extensions.enabled") ? new ExtensionsManager(tmpSettings, initialEnvironment.extensionDir()) : new NoopExtensionsManager();
            Settings settings = this.pluginsService.updatedSettings();
            Set<DiscoveryNodeRole> additionalRoles = this.pluginsService.filterPlugins(Plugin.class).stream().map(Plugin::getRoles).flatMap(Collection::stream).collect(Collectors.toSet());
            DiscoveryNode.setAdditionalRoles(additionalRoles);
            DiscoveryNode.setDeprecatedMasterRole();
            this.environment = new Environment(settings, initialEnvironment.configFile(), NODE_LOCAL_STORAGE_SETTING.get(settings));
            Environment.assertEquivalent(initialEnvironment, this.environment);
            this.nodeEnvironment = new NodeEnvironment(tmpSettings, this.environment);
            this.logger.info("node name [{}], node ID [{}], cluster name [{}], roles {}", (Object)NODE_NAME_SETTING.get(tmpSettings), (Object)this.nodeEnvironment.nodeId(), (Object)ClusterName.CLUSTER_NAME_SETTING.get(tmpSettings).value(), (Object)DiscoveryNode.getRolesFromSettings(settings).stream().map(DiscoveryNodeRole::roleName).collect(Collectors.toCollection(LinkedHashSet::new)));
            resourcesToClose.add(this.nodeEnvironment);
            this.localNodeFactory = new LocalNodeFactory(settings, this.nodeEnvironment.nodeId());
            List<ExecutorBuilder<?>> executorBuilders = this.pluginsService.getExecutorBuilders(settings);
            this.runnableTaskListener = new AtomicReference();
            ThreadPool threadPool = new ThreadPool(settings, this.runnableTaskListener, executorBuilders.toArray(new ExecutorBuilder[0]));
            resourcesToClose.add(() -> ThreadPool.terminate(threadPool, 10L, TimeUnit.SECONDS));
            ResourceWatcherService resourceWatcherService = new ResourceWatcherService(settings, threadPool);
            resourcesToClose.add(resourceWatcherService);
            HeaderWarning.setThreadContext(threadPool.getThreadContext());
            resourcesToClose.add(() -> HeaderWarning.removeThreadContext(threadPool.getThreadContext()));
            ArrayList additionalSettings = new ArrayList();
            additionalSettings.add(NODE_DATA_SETTING);
            additionalSettings.add(NODE_INGEST_SETTING);
            additionalSettings.add(NODE_MASTER_SETTING);
            additionalSettings.add(NODE_REMOTE_CLUSTER_CLIENT);
            additionalSettings.addAll(this.pluginsService.getPluginSettings());
            ArrayList<String> additionalSettingsFilter = new ArrayList<String>(this.pluginsService.getPluginSettingsFilter());
            for (ExecutorBuilder builder : threadPool.builders()) {
                additionalSettings.addAll(builder.getRegisteredSettings());
            }
            this.client = new NodeClient(settings, threadPool);
            ScriptModule scriptModule = new ScriptModule(settings, this.pluginsService.filterPlugins(ScriptPlugin.class));
            ScriptService scriptService = this.newScriptService(settings, scriptModule.engines, scriptModule.contexts);
            AnalysisModule analysisModule = new AnalysisModule(this.environment, this.pluginsService.filterPlugins(AnalysisPlugin.class));
            Set<SettingUpgrader<?>> settingsUpgraders = this.pluginsService.filterPlugins(Plugin.class).stream().map(Plugin::getSettingUpgraders).flatMap(Collection::stream).collect(Collectors.toSet());
            SettingsModule settingsModule = new SettingsModule(settings, additionalSettings, additionalSettingsFilter, settingsUpgraders);
            scriptModule.registerClusterSettingsListeners(scriptService, settingsModule.getClusterSettings());
            NetworkService networkService = new NetworkService(this.getCustomNameResolvers(this.pluginsService.filterPlugins(DiscoveryPlugin.class)));
            List<ClusterPlugin> clusterPlugins = this.pluginsService.filterPlugins(ClusterPlugin.class);
            ClusterService clusterService = new ClusterService(settings, settingsModule.getClusterSettings(), threadPool);
            clusterService.addStateApplier(scriptService);
            resourcesToClose.add(clusterService);
            Set<Setting<?>> consistentSettings = settingsModule.getConsistentSettings();
            if (!consistentSettings.isEmpty()) {
                clusterService.addLocalNodeMasterListener(new ConsistentSettingsService(settings, clusterService, consistentSettings).newHashPublisher());
            }
            IngestService ingestService = new IngestService(clusterService, threadPool, this.environment, scriptService, analysisModule.getAnalysisRegistry(), this.pluginsService.filterPlugins(IngestPlugin.class), this.client);
            SetOnce repositoriesServiceReference = new SetOnce();
            ClusterInfoService clusterInfoService = this.newClusterInfoService(settings, clusterService, threadPool, this.client);
            UsageService usageService = new UsageService();
            ModulesBuilder modules = new ModulesBuilder();
            for (Module pluginModule : this.pluginsService.createGuiceModules()) {
                modules.add(pluginModule);
            }
            MonitorService monitorService = new MonitorService(settings, this.nodeEnvironment, threadPool);
            FsHealthService fsHealthService = new FsHealthService(settings, clusterService.getClusterSettings(), threadPool, this.nodeEnvironment);
            SetOnce rerouteServiceReference = new SetOnce();
            InternalSnapshotsInfoService snapshotsInfoService = new InternalSnapshotsInfoService(settings, clusterService, () -> ((SetOnce)repositoriesServiceReference).get(), () -> ((SetOnce)rerouteServiceReference).get());
            ClusterModule clusterModule = new ClusterModule(settings, clusterService, clusterPlugins, clusterInfoService, snapshotsInfoService, threadPool.getThreadContext());
            modules.add(clusterModule);
            IndicesModule indicesModule = new IndicesModule(this.pluginsService.filterPlugins(MapperPlugin.class));
            modules.add(indicesModule);
            SearchModule searchModule = new SearchModule(settings, this.pluginsService.filterPlugins(SearchPlugin.class));
            List<BreakerSettings> pluginCircuitBreakers = this.pluginsService.filterPlugins(CircuitBreakerPlugin.class).stream().map(plugin -> plugin.getCircuitBreaker(settings)).collect(Collectors.toList());
            CircuitBreakerService circuitBreakerService = Node.createCircuitBreakerService(settingsModule.getSettings(), pluginCircuitBreakers, settingsModule.getClusterSettings());
            this.pluginsService.filterPlugins(CircuitBreakerPlugin.class).forEach(plugin -> {
                CircuitBreaker breaker = circuitBreakerService.getBreaker(plugin.getCircuitBreaker(settings).getName());
                plugin.setCircuitBreaker(breaker);
            });
            resourcesToClose.add(circuitBreakerService);
            modules.add(new GatewayModule());
            PageCacheRecycler pageCacheRecycler = this.createPageCacheRecycler(settings);
            BigArrays bigArrays = this.createBigArrays(pageCacheRecycler, circuitBreakerService);
            modules.add(settingsModule);
            List<NamedWriteableRegistry.Entry> namedWriteables = Stream.of(NetworkModule.getNamedWriteables().stream(), indicesModule.getNamedWriteables().stream(), searchModule.getNamedWriteables().stream(), this.pluginsService.filterPlugins(Plugin.class).stream().flatMap(p -> p.getNamedWriteables().stream()), ClusterModule.getNamedWriteables().stream()).flatMap(Function.identity()).collect(Collectors.toList());
            NamedWriteableRegistry namedWriteableRegistry = new NamedWriteableRegistry(namedWriteables);
            NamedXContentRegistry xContentRegistry = new NamedXContentRegistry(Stream.of(NetworkModule.getNamedXContents().stream(), IndicesModule.getNamedXContents().stream(), searchModule.getNamedXContents().stream(), this.pluginsService.filterPlugins(Plugin.class).stream().flatMap(p -> p.getNamedXContent().stream()), ClusterModule.getNamedXWriteables().stream()).flatMap(Function.identity()).collect(Collectors.toList()));
            MetaStateService metaStateService = new MetaStateService(this.nodeEnvironment, xContentRegistry);
            PersistedClusterStateService lucenePersistedStateFactory = new PersistedClusterStateService(this.nodeEnvironment, xContentRegistry, bigArrays, clusterService.getClusterSettings(), threadPool::relativeTimeInMillis);
            List<EnginePlugin> enginePlugins = this.pluginsService.filterPlugins(EnginePlugin.class);
            Collection engineFactoryProviders = enginePlugins.stream().map(plugin -> plugin::getEngineFactory).collect(Collectors.toList());
            Map<String, IndexStorePlugin.DirectoryFactory> builtInDirectoryFactories = IndexModule.createBuiltInDirectoryFactories(() -> ((SetOnce)repositoriesServiceReference).get(), threadPool);
            HashMap<String, IndexStorePlugin.DirectoryFactory> directoryFactories = new HashMap<String, IndexStorePlugin.DirectoryFactory>();
            this.pluginsService.filterPlugins(IndexStorePlugin.class).stream().map(IndexStorePlugin::getDirectoryFactories).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).forEach((k, v) -> {
                if (builtInDirectoryFactories.containsKey(k)) {
                    throw new IllegalStateException("registered index store type [" + k + "] conflicts with a built-in type");
                }
                directoryFactories.put((String)k, (IndexStorePlugin.DirectoryFactory)v);
            });
            directoryFactories.putAll(builtInDirectoryFactories);
            Map<String, IndexStorePlugin.RecoveryStateFactory> recoveryStateFactories = this.pluginsService.filterPlugins(IndexStorePlugin.class).stream().map(IndexStorePlugin::getRecoveryStateFactories).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Map<String, Collection<SystemIndexDescriptor>> systemIndexDescriptorMap = Collections.unmodifiableMap(this.pluginsService.filterPlugins(SystemIndexPlugin.class).stream().collect(Collectors.toMap(plugin -> plugin.getClass().getSimpleName(), plugin -> plugin.getSystemIndexDescriptors(settings))));
            SystemIndices systemIndices = new SystemIndices(systemIndexDescriptorMap);
            BatchedRerouteService rerouteService = new BatchedRerouteService(clusterService, clusterModule.getAllocationService()::reroute);
            rerouteServiceReference.set((Object)rerouteService);
            clusterService.setRerouteService(rerouteService);
            RemoteSegmentStoreDirectoryFactory remoteDirectoryFactory = new RemoteSegmentStoreDirectoryFactory(() -> ((SetOnce)repositoriesServiceReference).get());
            IndicesService indicesService = FeatureFlags.isEnabled("opensearch.experimental.feature.extensions.enabled") ? new IndicesService(settings, this.pluginsService, this.extensionsManager, this.nodeEnvironment, xContentRegistry, analysisModule.getAnalysisRegistry(), clusterModule.getIndexNameExpressionResolver(), indicesModule.getMapperRegistry(), namedWriteableRegistry, threadPool, settingsModule.getIndexScopedSettings(), circuitBreakerService, bigArrays, scriptService, clusterService, this.client, metaStateService, engineFactoryProviders, Map.copyOf(directoryFactories), searchModule.getValuesSourceRegistry(), recoveryStateFactories, remoteDirectoryFactory, () -> ((SetOnce)repositoriesServiceReference).get()) : new IndicesService(settings, this.pluginsService, this.nodeEnvironment, xContentRegistry, analysisModule.getAnalysisRegistry(), clusterModule.getIndexNameExpressionResolver(), indicesModule.getMapperRegistry(), namedWriteableRegistry, threadPool, settingsModule.getIndexScopedSettings(), circuitBreakerService, bigArrays, scriptService, clusterService, this.client, metaStateService, engineFactoryProviders, Map.copyOf(directoryFactories), searchModule.getValuesSourceRegistry(), recoveryStateFactories, remoteDirectoryFactory, () -> ((SetOnce)repositoriesServiceReference).get());
            AliasValidator aliasValidator = new AliasValidator();
            ShardLimitValidator shardLimitValidator = new ShardLimitValidator(settings, clusterService, systemIndices);
            AwarenessReplicaBalance awarenessReplicaBalance = new AwarenessReplicaBalance(settings, clusterService.getClusterSettings());
            MetadataCreateIndexService metadataCreateIndexService = new MetadataCreateIndexService(settings, clusterService, indicesService, clusterModule.getAllocationService(), aliasValidator, shardLimitValidator, this.environment, settingsModule.getIndexScopedSettings(), threadPool, xContentRegistry, systemIndices, forbidPrivateIndexSettings, awarenessReplicaBalance);
            this.pluginsService.filterPlugins(Plugin.class).forEach(p -> p.getAdditionalIndexSettingProviders().forEach(metadataCreateIndexService::addAdditionalIndexSettingProvider));
            MetadataCreateDataStreamService metadataCreateDataStreamService = new MetadataCreateDataStreamService(threadPool, clusterService, metadataCreateIndexService);
            Collection pluginComponents = this.pluginsService.filterPlugins(Plugin.class).stream().flatMap(p -> p.createComponents(this.client, clusterService, threadPool, resourceWatcherService, scriptService, xContentRegistry, this.environment, this.nodeEnvironment, namedWriteableRegistry, clusterModule.getIndexNameExpressionResolver(), () -> ((SetOnce)repositoriesServiceReference).get()).stream()).collect(Collectors.toList());
            ActionModule actionModule = new ActionModule(settings, clusterModule.getIndexNameExpressionResolver(), settingsModule.getIndexScopedSettings(), settingsModule.getClusterSettings(), settingsModule.getSettingsFilter(), threadPool, this.pluginsService.filterPlugins(ActionPlugin.class), this.client, circuitBreakerService, usageService, systemIndices);
            modules.add(actionModule);
            RestController restController = actionModule.getRestController();
            NetworkModule networkModule = new NetworkModule(settings, this.pluginsService.filterPlugins(NetworkPlugin.class), threadPool, bigArrays, pageCacheRecycler, circuitBreakerService, namedWriteableRegistry, xContentRegistry, networkService, restController, clusterService.getClusterSettings());
            Collection indexTemplateMetadataUpgraders = this.pluginsService.filterPlugins(Plugin.class).stream().map(Plugin::getIndexTemplateMetadataUpgrader).collect(Collectors.toList());
            MetadataUpgrader metadataUpgrader = new MetadataUpgrader(indexTemplateMetadataUpgraders);
            MetadataIndexUpgradeService metadataIndexUpgradeService = new MetadataIndexUpgradeService(settings, xContentRegistry, indicesModule.getMapperRegistry(), settingsModule.getIndexScopedSettings(), systemIndices, scriptService);
            if (DiscoveryNode.isClusterManagerNode(settings)) {
                clusterService.addListener(new SystemIndexMetadataUpgradeService(systemIndices, clusterService));
            }
            new TemplateUpgradeService(this.client, clusterService, threadPool, indexTemplateMetadataUpgraders);
            Transport transport = networkModule.getTransportSupplier().get();
            Set<String> taskHeaders = Stream.concat(this.pluginsService.filterPlugins(ActionPlugin.class).stream().flatMap(p -> p.getTaskHeaders().stream()), Stream.of("X-Opaque-Id")).collect(Collectors.toSet());
            TransportService transportService = this.newTransportService(settings, transport, threadPool, networkModule.getTransportInterceptor(), this.localNodeFactory, settingsModule.getClusterSettings(), taskHeaders);
            if (FeatureFlags.isEnabled("opensearch.experimental.feature.extensions.enabled")) {
                this.extensionsManager.initializeServicesAndRestHandler(restController, settingsModule, transportService, clusterService, this.environment.settings(), this.client);
            }
            GatewayMetaState gatewayMetaState = new GatewayMetaState();
            ResponseCollectorService responseCollectorService = new ResponseCollectorService(clusterService);
            SearchTransportService searchTransportService = new SearchTransportService(transportService, SearchExecutionStatsCollector.makeWrapper(responseCollectorService));
            HttpServerTransport httpServerTransport = this.newHttpTransport(networkModule);
            IndexingPressureService indexingPressureService = new IndexingPressureService(settings, clusterService);
            clusterService.setIndexingPressureService(indexingPressureService);
            TaskResourceTrackingService taskResourceTrackingService = new TaskResourceTrackingService(settings, clusterService.getClusterSettings(), threadPool);
            SearchBackpressureSettings searchBackpressureSettings = new SearchBackpressureSettings(settings, clusterService.getClusterSettings());
            SearchBackpressureService searchBackpressureService = new SearchBackpressureService(searchBackpressureSettings, taskResourceTrackingService, threadPool);
            RecoverySettings recoverySettings = new RecoverySettings(settings, settingsModule.getClusterSettings());
            RepositoriesModule repositoriesModule = new RepositoriesModule(this.environment, this.pluginsService.filterPlugins(RepositoryPlugin.class), transportService, clusterService, threadPool, xContentRegistry, recoverySettings);
            RepositoriesService repositoryService = repositoriesModule.getRepositoryService();
            repositoriesServiceReference.set((Object)repositoryService);
            SnapshotsService snapshotsService = new SnapshotsService(settings, clusterService, clusterModule.getIndexNameExpressionResolver(), repositoryService, transportService, actionModule.getActionFilters());
            SnapshotShardsService snapshotShardsService = new SnapshotShardsService(settings, clusterService, repositoryService, transportService, indicesService);
            TransportNodesSnapshotsStatus nodesSnapshotsStatus = new TransportNodesSnapshotsStatus(threadPool, clusterService, transportService, snapshotShardsService, actionModule.getActionFilters());
            RestoreService restoreService = new RestoreService(clusterService, repositoryService, clusterModule.getAllocationService(), metadataCreateIndexService, metadataIndexUpgradeService, clusterService.getClusterSettings(), shardLimitValidator);
            DiskThresholdMonitor diskThresholdMonitor = new DiskThresholdMonitor(settings, clusterService::state, clusterService.getClusterSettings(), this.client, threadPool::relativeTimeInMillis, rerouteService);
            clusterInfoService.addListener(diskThresholdMonitor::onNewInfo);
            DiscoveryModule discoveryModule = new DiscoveryModule(settings, threadPool, transportService, namedWriteableRegistry, networkService, clusterService.getClusterManagerService(), clusterService.getClusterApplierService(), clusterService.getClusterSettings(), this.pluginsService.filterPlugins(DiscoveryPlugin.class), clusterModule.getAllocationService(), this.environment.configFile(), gatewayMetaState, rerouteService, fsHealthService);
            this.nodeService = new NodeService(settings, threadPool, monitorService, discoveryModule.getDiscovery(), transportService, indicesService, this.pluginsService, circuitBreakerService, scriptService, httpServerTransport, ingestService, clusterService, settingsModule.getSettingsFilter(), responseCollectorService, searchTransportService, indexingPressureService, searchModule.getValuesSourceRegistry().getUsageService(), searchBackpressureService);
            SearchService searchService = this.newSearchService(clusterService, indicesService, threadPool, scriptService, bigArrays, searchModule.getQueryPhase(), searchModule.getFetchPhase(), responseCollectorService, circuitBreakerService, searchModule.getIndexSearcherExecutor(threadPool));
            List<PersistentTasksExecutor<?>> tasksExecutors = this.pluginsService.filterPlugins(PersistentTaskPlugin.class).stream().map(p -> p.getPersistentTasksExecutor(clusterService, threadPool, this.client, settingsModule, clusterModule.getIndexNameExpressionResolver())).flatMap(Collection::stream).collect(Collectors.toList());
            PersistentTasksExecutorRegistry registry = new PersistentTasksExecutorRegistry(tasksExecutors);
            PersistentTasksClusterService persistentTasksClusterService = new PersistentTasksClusterService(settings, registry, clusterService, threadPool);
            resourcesToClose.add(persistentTasksClusterService);
            PersistentTasksService persistentTasksService = new PersistentTasksService(clusterService, threadPool, this.client);
            modules.add(b -> {
                b.bind(Node.class).toInstance(this);
                b.bind(NodeService.class).toInstance(this.nodeService);
                b.bind(NamedXContentRegistry.class).toInstance(xContentRegistry);
                b.bind(PluginsService.class).toInstance(this.pluginsService);
                b.bind(Client.class).toInstance(this.client);
                b.bind(NodeClient.class).toInstance(this.client);
                b.bind(Environment.class).toInstance(this.environment);
                if (FeatureFlags.isEnabled("opensearch.experimental.feature.extensions.enabled")) {
                    b.bind(ExtensionsManager.class).toInstance(this.extensionsManager);
                }
                b.bind(ThreadPool.class).toInstance(threadPool);
                b.bind(NodeEnvironment.class).toInstance(this.nodeEnvironment);
                b.bind(ResourceWatcherService.class).toInstance(resourceWatcherService);
                b.bind(CircuitBreakerService.class).toInstance(circuitBreakerService);
                b.bind(BigArrays.class).toInstance(bigArrays);
                b.bind(PageCacheRecycler.class).toInstance(pageCacheRecycler);
                b.bind(ScriptService.class).toInstance(scriptService);
                b.bind(AnalysisRegistry.class).toInstance(analysisModule.getAnalysisRegistry());
                b.bind(IngestService.class).toInstance(ingestService);
                b.bind(IndexingPressureService.class).toInstance(indexingPressureService);
                b.bind(TaskResourceTrackingService.class).toInstance(taskResourceTrackingService);
                b.bind(SearchBackpressureService.class).toInstance(searchBackpressureService);
                b.bind(UsageService.class).toInstance(usageService);
                b.bind(AggregationUsageService.class).toInstance(searchModule.getValuesSourceRegistry().getUsageService());
                b.bind(NamedWriteableRegistry.class).toInstance(namedWriteableRegistry);
                b.bind(MetadataUpgrader.class).toInstance(metadataUpgrader);
                b.bind(MetaStateService.class).toInstance(metaStateService);
                b.bind(PersistedClusterStateService.class).toInstance(lucenePersistedStateFactory);
                b.bind(IndicesService.class).toInstance(indicesService);
                b.bind(AliasValidator.class).toInstance(aliasValidator);
                b.bind(MetadataCreateIndexService.class).toInstance(metadataCreateIndexService);
                b.bind(AwarenessReplicaBalance.class).toInstance(awarenessReplicaBalance);
                b.bind(MetadataCreateDataStreamService.class).toInstance(metadataCreateDataStreamService);
                b.bind(SearchService.class).toInstance(searchService);
                b.bind(SearchTransportService.class).toInstance(searchTransportService);
                b.bind(SearchPhaseController.class).toInstance(new SearchPhaseController(namedWriteableRegistry, searchService::aggReduceContextBuilder));
                b.bind(Transport.class).toInstance(transport);
                b.bind(TransportService.class).toInstance(transportService);
                b.bind(NetworkService.class).toInstance(networkService);
                b.bind(UpdateHelper.class).toInstance(new UpdateHelper(scriptService));
                b.bind(MetadataIndexUpgradeService.class).toInstance(metadataIndexUpgradeService);
                b.bind(ClusterInfoService.class).toInstance(clusterInfoService);
                b.bind(SnapshotsInfoService.class).toInstance(snapshotsInfoService);
                b.bind(GatewayMetaState.class).toInstance(gatewayMetaState);
                b.bind(Discovery.class).toInstance(discoveryModule.getDiscovery());
                this.processRecoverySettings(settingsModule.getClusterSettings(), recoverySettings);
                b.bind(PeerRecoverySourceService.class).toInstance(new PeerRecoverySourceService(transportService, indicesService, recoverySettings));
                b.bind(PeerRecoveryTargetService.class).toInstance(new PeerRecoveryTargetService(threadPool, transportService, recoverySettings, clusterService));
                if (FeatureFlags.isEnabled("opensearch.experimental.feature.replication_type.enabled")) {
                    b.bind(SegmentReplicationTargetService.class).toInstance(new SegmentReplicationTargetService(threadPool, recoverySettings, transportService, new SegmentReplicationSourceFactory(transportService, recoverySettings, clusterService)));
                    b.bind(SegmentReplicationSourceService.class).toInstance(new SegmentReplicationSourceService(indicesService, transportService, recoverySettings));
                } else {
                    b.bind(SegmentReplicationTargetService.class).toInstance(SegmentReplicationTargetService.NO_OP);
                    b.bind(SegmentReplicationSourceService.class).toInstance(SegmentReplicationSourceService.NO_OP);
                }
                b.bind(HttpServerTransport.class).toInstance(httpServerTransport);
                pluginComponents.stream().forEach(p -> b.bind(p.getClass()).toInstance(p));
                b.bind(PersistentTasksService.class).toInstance(persistentTasksService);
                b.bind(PersistentTasksClusterService.class).toInstance(persistentTasksClusterService);
                b.bind(PersistentTasksExecutorRegistry.class).toInstance(registry);
                b.bind(RepositoriesService.class).toInstance(repositoryService);
                b.bind(SnapshotsService.class).toInstance(snapshotsService);
                b.bind(SnapshotShardsService.class).toInstance(snapshotShardsService);
                b.bind(TransportNodesSnapshotsStatus.class).toInstance(nodesSnapshotsStatus);
                b.bind(RestoreService.class).toInstance(restoreService);
                b.bind(RerouteService.class).toInstance(rerouteService);
                b.bind(ShardLimitValidator.class).toInstance(shardLimitValidator);
                b.bind(FsHealthService.class).toInstance(fsHealthService);
                b.bind(SystemIndices.class).toInstance(systemIndices);
            });
            this.injector = modules.createInjector();
            clusterModule.setExistingShardsAllocators(this.injector.getInstance(GatewayAllocator.class));
            List pluginLifecycleComponents = pluginComponents.stream().filter(p -> p instanceof LifecycleComponent).map(p -> (LifecycleComponent)p).collect(Collectors.toList());
            pluginLifecycleComponents.addAll(this.pluginsService.getGuiceServiceClasses().stream().map(this.injector::getInstance).collect(Collectors.toList()));
            resourcesToClose.addAll(pluginLifecycleComponents);
            resourcesToClose.add(this.injector.getInstance(PeerRecoverySourceService.class));
            this.pluginLifecycleComponents = Collections.unmodifiableList(pluginLifecycleComponents);
            this.client.initialize(this.injector.getInstance(new Key<Map<ActionType, TransportAction>>(){}), () -> clusterService.localNode().getId(), transportService.getRemoteClusterService(), namedWriteableRegistry);
            this.namedWriteableRegistry = namedWriteableRegistry;
            this.logger.debug("initializing HTTP handlers ...");
            actionModule.initRestHandlers(() -> clusterService.state().nodes());
            this.logger.info("initialized");
            success = true;
        }
        catch (IOException ex) {
            throw new OpenSearchException("failed to bind service", (Throwable)ex, new Object[0]);
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException(resourcesToClose);
            }
        }
    }

    protected TransportService newTransportService(Settings settings, Transport transport, ThreadPool threadPool, TransportInterceptor interceptor, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, ClusterSettings clusterSettings, Set<String> taskHeaders) {
        return new TransportService(settings, transport, threadPool, interceptor, localNodeFactory, clusterSettings, taskHeaders);
    }

    protected void processRecoverySettings(ClusterSettings clusterSettings, RecoverySettings recoverySettings) {
    }

    public Settings settings() {
        return this.environment.settings();
    }

    public Client client() {
        return this.client;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public NodeEnvironment getNodeEnvironment() {
        return this.nodeEnvironment;
    }

    public Node start() throws NodeValidationException {
        GatewayMetaState gatewayMetaState;
        TransportService transportService;
        Discovery discovery;
        ClusterService clusterService;
        block19: {
            if (!this.lifecycle.moveToStarted()) {
                return this;
            }
            this.logger.info("starting ...");
            this.pluginLifecycleComponents.forEach(LifecycleComponent::start);
            this.injector.getInstance(MappingUpdatedAction.class).setClient(this.client);
            this.injector.getInstance(IndicesService.class).start();
            this.injector.getInstance(IndicesClusterStateService.class).start();
            this.injector.getInstance(SnapshotsService.class).start();
            this.injector.getInstance(SnapshotShardsService.class).start();
            this.injector.getInstance(RepositoriesService.class).start();
            this.injector.getInstance(SearchService.class).start();
            this.injector.getInstance(FsHealthService.class).start();
            this.nodeService.getMonitorService().start();
            this.nodeService.getSearchBackpressureService().start();
            clusterService = this.injector.getInstance(ClusterService.class);
            NodeConnectionsService nodeConnectionsService = this.injector.getInstance(NodeConnectionsService.class);
            nodeConnectionsService.start();
            clusterService.setNodeConnectionsService(nodeConnectionsService);
            this.injector.getInstance(GatewayService.class).start();
            discovery = this.injector.getInstance(Discovery.class);
            clusterService.getClusterManagerService().setClusterStatePublisher(discovery::publish);
            transportService = this.injector.getInstance(TransportService.class);
            transportService.getTaskManager().setTaskResultsService(this.injector.getInstance(TaskResultsService.class));
            transportService.getTaskManager().setTaskCancellationService(new TaskCancellationService(transportService));
            TaskResourceTrackingService taskResourceTrackingService = this.injector.getInstance(TaskResourceTrackingService.class);
            transportService.getTaskManager().setTaskResourceTrackingService(taskResourceTrackingService);
            this.runnableTaskListener.set(taskResourceTrackingService);
            transportService.start();
            assert (this.localNodeFactory.getNode() != null);
            assert (transportService.getLocalNode().equals(this.localNodeFactory.getNode())) : "transportService has a different local node than the factory provided";
            this.injector.getInstance(PeerRecoverySourceService.class).start();
            if (FeatureFlags.isEnabled("opensearch.experimental.feature.replication_type.enabled")) {
                this.injector.getInstance(SegmentReplicationSourceService.class).start();
            }
            gatewayMetaState = this.injector.getInstance(GatewayMetaState.class);
            gatewayMetaState.start(this.settings(), transportService, clusterService, this.injector.getInstance(MetaStateService.class), this.injector.getInstance(MetadataIndexUpgradeService.class), this.injector.getInstance(MetadataUpgrader.class), this.injector.getInstance(PersistedClusterStateService.class));
            if (Assertions.ENABLED) {
                try {
                    assert (((Manifest)this.injector.getInstance(MetaStateService.class).loadFullState().v1()).isEmpty());
                    NodeMetadata nodeMetadata = NodeMetadata.FORMAT.loadLatestState(this.logger, NamedXContentRegistry.EMPTY, this.nodeEnvironment.nodeDataPaths());
                    assert (nodeMetadata != null);
                    assert (nodeMetadata.nodeVersion().equals(Version.CURRENT));
                    assert (nodeMetadata.nodeId().equals(this.localNodeFactory.getNode().getId()));
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block19;
                    throw new AssertionError((Object)e);
                }
            }
        }
        Metadata onDiskMetadata = gatewayMetaState.getPersistedState().getLastAcceptedState().metadata();
        assert (onDiskMetadata != null) : "metadata is null but shouldn't";
        this.validateNodeBeforeAcceptingRequests(new BootstrapContext(this.environment, onDiskMetadata), transportService.boundAddress(), this.pluginsService.filterPlugins(Plugin.class).stream().flatMap(p -> p.getBootstrapChecks().stream()).collect(Collectors.toList()));
        clusterService.addStateApplier(transportService.getTaskManager());
        discovery.start();
        clusterService.start();
        assert (clusterService.localNode().equals(this.localNodeFactory.getNode())) : "clusterService has a different local node than the factory provided";
        transportService.acceptIncomingRequests();
        if (FeatureFlags.isEnabled("opensearch.experimental.feature.extensions.enabled")) {
            this.extensionsManager.initialize();
        }
        discovery.startInitialJoin();
        final TimeValue initialStateTimeout = DiscoverySettings.INITIAL_STATE_TIMEOUT_SETTING.get(this.settings());
        this.configureNodeAndClusterIdStateListener(clusterService);
        if (initialStateTimeout.millis() > 0L) {
            ThreadPool thread = this.injector.getInstance(ThreadPool.class);
            ClusterState clusterState = clusterService.state();
            ClusterStateObserver observer = new ClusterStateObserver(clusterState, clusterService, null, this.logger, thread.getThreadContext());
            if (clusterState.nodes().getClusterManagerNodeId() == null) {
                this.logger.debug("waiting to join the cluster. timeout [{}]", (Object)initialStateTimeout);
                final CountDownLatch latch = new CountDownLatch(1);
                observer.waitForNextChange(new ClusterStateObserver.Listener(){

                    @Override
                    public void onNewClusterState(ClusterState state) {
                        latch.countDown();
                    }

                    @Override
                    public void onClusterServiceClose() {
                        latch.countDown();
                    }

                    @Override
                    public void onTimeout(TimeValue timeout) {
                        Node.this.logger.warn("timed out while waiting for initial discovery state - timeout: {}", (Object)initialStateTimeout);
                        latch.countDown();
                    }
                }, state -> state.nodes().getClusterManagerNodeId() != null, initialStateTimeout);
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new OpenSearchTimeoutException("Interrupted while waiting for initial discovery state", new Object[0]);
                }
            }
        }
        this.injector.getInstance(HttpServerTransport.class).start();
        if (WRITE_PORTS_FILE_SETTING.get(this.settings()).booleanValue()) {
            TransportService transport = this.injector.getInstance(TransportService.class);
            this.writePortsFile("transport", transport.boundAddress());
            HttpServerTransport http = this.injector.getInstance(HttpServerTransport.class);
            this.writePortsFile("http", http.boundAddress());
        }
        this.logger.info("started");
        this.pluginsService.filterPlugins(ClusterPlugin.class).forEach(ClusterPlugin::onNodeStarted);
        return this;
    }

    protected void configureNodeAndClusterIdStateListener(ClusterService clusterService) {
        NodeAndClusterIdStateListener.getAndSetNodeIdAndClusterId(clusterService, this.injector.getInstance(ThreadPool.class).getThreadContext());
    }

    private Node stop() {
        if (!this.lifecycle.moveToStopped()) {
            return this;
        }
        this.logger.info("stopping ...");
        this.injector.getInstance(ResourceWatcherService.class).close();
        this.injector.getInstance(HttpServerTransport.class).stop();
        this.injector.getInstance(SnapshotsService.class).stop();
        this.injector.getInstance(SnapshotShardsService.class).stop();
        this.injector.getInstance(RepositoriesService.class).stop();
        this.injector.getInstance(IndicesClusterStateService.class).stop();
        this.injector.getInstance(Discovery.class).stop();
        this.injector.getInstance(ClusterService.class).stop();
        this.injector.getInstance(NodeConnectionsService.class).stop();
        this.injector.getInstance(FsHealthService.class).stop();
        this.nodeService.getMonitorService().stop();
        this.nodeService.getSearchBackpressureService().stop();
        this.injector.getInstance(GatewayService.class).stop();
        this.injector.getInstance(SearchService.class).stop();
        this.injector.getInstance(TransportService.class).stop();
        this.pluginLifecycleComponents.forEach(LifecycleComponent::stop);
        this.injector.getInstance(IndicesService.class).stop();
        this.logger.info("stopped");
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        Lifecycle lifecycle = this.lifecycle;
        synchronized (lifecycle) {
            if (this.lifecycle.started()) {
                this.stop();
            }
            if (!this.lifecycle.moveToClosed()) {
                return;
            }
        }
        this.logger.info("closing ...");
        ArrayList<Closeable> toClose = new ArrayList<Closeable>();
        StopWatch stopWatch = new StopWatch("node_close");
        toClose.add(() -> stopWatch.start("node_service"));
        toClose.add(this.nodeService);
        toClose.add(() -> stopWatch.stop().start("http"));
        toClose.add(this.injector.getInstance(HttpServerTransport.class));
        toClose.add(() -> stopWatch.stop().start("snapshot_service"));
        toClose.add(this.injector.getInstance(SnapshotsService.class));
        toClose.add(this.injector.getInstance(SnapshotShardsService.class));
        toClose.add(this.injector.getInstance(RepositoriesService.class));
        toClose.add(() -> stopWatch.stop().start("client"));
        Releasables.close((Releasable)this.injector.getInstance(Client.class));
        toClose.add(() -> stopWatch.stop().start("indices_cluster"));
        toClose.add(this.injector.getInstance(IndicesClusterStateService.class));
        toClose.add(() -> stopWatch.stop().start("indices"));
        toClose.add(this.injector.getInstance(IndicesService.class));
        toClose.add(this.injector.getInstance(IndicesStore.class));
        toClose.add(this.injector.getInstance(PeerRecoverySourceService.class));
        if (FeatureFlags.isEnabled("opensearch.experimental.feature.replication_type.enabled")) {
            toClose.add(this.injector.getInstance(SegmentReplicationSourceService.class));
        }
        toClose.add(() -> stopWatch.stop().start("cluster"));
        toClose.add(this.injector.getInstance(ClusterService.class));
        toClose.add(() -> stopWatch.stop().start("node_connections_service"));
        toClose.add(this.injector.getInstance(NodeConnectionsService.class));
        toClose.add(() -> stopWatch.stop().start("discovery"));
        toClose.add(this.injector.getInstance(Discovery.class));
        toClose.add(() -> stopWatch.stop().start("monitor"));
        toClose.add(this.nodeService.getMonitorService());
        toClose.add(this.nodeService.getSearchBackpressureService());
        toClose.add(() -> stopWatch.stop().start("fsHealth"));
        toClose.add(this.injector.getInstance(FsHealthService.class));
        toClose.add(() -> stopWatch.stop().start("gateway"));
        toClose.add(this.injector.getInstance(GatewayService.class));
        toClose.add(() -> stopWatch.stop().start("search"));
        toClose.add(this.injector.getInstance(SearchService.class));
        toClose.add(() -> stopWatch.stop().start("transport"));
        toClose.add(this.injector.getInstance(TransportService.class));
        for (LifecycleComponent plugin : this.pluginLifecycleComponents) {
            toClose.add(() -> stopWatch.stop().start("plugin(" + plugin.getClass().getName() + ")"));
            toClose.add(plugin);
        }
        toClose.addAll(this.pluginsService.filterPlugins(Plugin.class));
        toClose.add(() -> stopWatch.stop().start("script"));
        toClose.add(this.injector.getInstance(ScriptService.class));
        toClose.add(() -> stopWatch.stop().start("thread_pool"));
        toClose.add(() -> this.injector.getInstance(ThreadPool.class).shutdown());
        toClose.add(() -> stopWatch.stop().start("gateway_meta_state"));
        toClose.add(this.injector.getInstance(GatewayMetaState.class));
        toClose.add(() -> stopWatch.stop().start("node_environment"));
        toClose.add(this.injector.getInstance(NodeEnvironment.class));
        toClose.add(stopWatch::stop);
        if (this.logger.isTraceEnabled()) {
            toClose.add(() -> this.logger.trace("Close times for each service:\n{}", (Object)stopWatch.prettyPrint()));
        }
        IOUtils.close(toClose);
        this.logger.info("closed");
    }

    public synchronized boolean awaitClose(long timeout, TimeUnit timeUnit) throws InterruptedException {
        if (!this.lifecycle.closed()) {
            throw new IllegalStateException("Call close() first");
        }
        ThreadPool threadPool = this.injector.getInstance(ThreadPool.class);
        boolean terminated = ThreadPool.terminate(threadPool, timeout, timeUnit);
        if (terminated && !this.nodeService.awaitClose(0L, TimeUnit.MILLISECONDS)) {
            throw new IllegalStateException("Some shards are still open after the threadpool terminated. Something is leaking index readers or store references.");
        }
        return terminated;
    }

    public boolean isClosed() {
        return this.lifecycle.closed();
    }

    public Injector injector() {
        return this.injector;
    }

    protected void validateNodeBeforeAcceptingRequests(BootstrapContext context, BoundTransportAddress boundTransportAddress, List<BootstrapCheck> bootstrapChecks) throws NodeValidationException {
    }

    private void writePortsFile(String type, BoundTransportAddress boundAddress) {
        Path tmpPortsFile = this.environment.logsFile().resolve(type + ".ports.tmp");
        try (BufferedWriter writer = Files.newBufferedWriter(tmpPortsFile, Charset.forName("UTF-8"), new OpenOption[0]);){
            for (TransportAddress address : boundAddress.boundAddresses()) {
                InetAddress inetAddress = InetAddress.getByName(address.getAddress());
                writer.write(NetworkAddress.format(new InetSocketAddress(inetAddress, address.getPort())) + "\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write ports file", e);
        }
        Path portsFile = this.environment.logsFile().resolve(type + ".ports");
        try {
            Files.move(tmpPortsFile, portsFile, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to rename ports file", e);
        }
    }

    protected PluginsService getPluginsService() {
        return this.pluginsService;
    }

    public static CircuitBreakerService createCircuitBreakerService(Settings settings, List<BreakerSettings> breakerSettings, ClusterSettings clusterSettings) {
        String type = BREAKER_TYPE_KEY.get(settings);
        if (type.equals("hierarchy")) {
            return new HierarchyCircuitBreakerService(settings, breakerSettings, clusterSettings);
        }
        if (type.equals("none")) {
            return new NoneCircuitBreakerService();
        }
        throw new IllegalArgumentException("Unknown circuit breaker type [" + type + "]");
    }

    BigArrays createBigArrays(PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService) {
        return new BigArrays(pageCacheRecycler, circuitBreakerService, "request");
    }

    PageCacheRecycler createPageCacheRecycler(Settings settings) {
        return new PageCacheRecycler(settings);
    }

    protected SearchService newSearchService(ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ScriptService scriptService, BigArrays bigArrays, QueryPhase queryPhase, FetchPhase fetchPhase, ResponseCollectorService responseCollectorService, CircuitBreakerService circuitBreakerService, Executor indexSearcherExecutor) {
        return new SearchService(clusterService, indicesService, threadPool, scriptService, bigArrays, queryPhase, fetchPhase, responseCollectorService, circuitBreakerService, indexSearcherExecutor);
    }

    protected ScriptService newScriptService(Settings settings, Map<String, ScriptEngine> engines, Map<String, ScriptContext<?>> contexts) {
        return new ScriptService(settings, engines, contexts);
    }

    private List<NetworkService.CustomNameResolver> getCustomNameResolvers(List<DiscoveryPlugin> discoveryPlugins) {
        ArrayList<NetworkService.CustomNameResolver> customNameResolvers = new ArrayList<NetworkService.CustomNameResolver>();
        for (DiscoveryPlugin discoveryPlugin : discoveryPlugins) {
            NetworkService.CustomNameResolver customNameResolver = discoveryPlugin.getCustomNameResolver(this.settings());
            if (customNameResolver == null) continue;
            customNameResolvers.add(customNameResolver);
        }
        return customNameResolvers;
    }

    protected ClusterInfoService newClusterInfoService(Settings settings, ClusterService clusterService, ThreadPool threadPool, NodeClient client) {
        InternalClusterInfoService service = new InternalClusterInfoService(settings, clusterService, threadPool, client);
        if (DiscoveryNode.isClusterManagerNode(settings)) {
            clusterService.addListener(service);
        }
        return service;
    }

    protected HttpServerTransport newHttpTransport(NetworkModule networkModule) {
        return networkModule.getHttpServerTransportSupplier().get();
    }

    private static class LocalNodeFactory
    implements Function<BoundTransportAddress, DiscoveryNode> {
        private final SetOnce<DiscoveryNode> localNode = new SetOnce();
        private final String persistentNodeId;
        private final Settings settings;

        private LocalNodeFactory(Settings settings, String persistentNodeId) {
            this.persistentNodeId = persistentNodeId;
            this.settings = settings;
        }

        @Override
        public DiscoveryNode apply(BoundTransportAddress boundTransportAddress) {
            this.localNode.set((Object)DiscoveryNode.createLocal(this.settings, boundTransportAddress.publishAddress(), this.persistentNodeId));
            return (DiscoveryNode)this.localNode.get();
        }

        DiscoveryNode getNode() {
            assert (this.localNode.get() != null);
            return (DiscoveryNode)this.localNode.get();
        }
    }

    public static class DiscoverySettings {
        public static final Setting<TimeValue> INITIAL_STATE_TIMEOUT_SETTING = Setting.positiveTimeSetting("discovery.initial_state_timeout", TimeValue.timeValueSeconds((long)30L), Setting.Property.NodeScope);
    }
}

