/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.xcontent;

import java.util.Locale;
import java.util.Map;
import org.opensearch.common.xcontent.MediaType;
import org.opensearch.common.xcontent.MediaTypeParser;
import org.opensearch.common.xcontent.XContent;
import org.opensearch.common.xcontent.cbor.CborXContent;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.common.xcontent.smile.SmileXContent;
import org.opensearch.common.xcontent.yaml.YamlXContent;

public enum XContentType implements MediaType
{
    JSON(0){

        @Override
        public String mediaTypeWithoutParameters() {
            return "application/json";
        }

        @Override
        public String mediaType() {
            return "application/json; charset=UTF-8";
        }

        @Override
        public String subtype() {
            return "json";
        }

        @Override
        public XContent xContent() {
            return JsonXContent.jsonXContent;
        }
    }
    ,
    SMILE(1){

        @Override
        public String mediaTypeWithoutParameters() {
            return "application/smile";
        }

        @Override
        public String subtype() {
            return "smile";
        }

        @Override
        public XContent xContent() {
            return SmileXContent.smileXContent;
        }
    }
    ,
    YAML(2){

        @Override
        public String mediaTypeWithoutParameters() {
            return "application/yaml";
        }

        @Override
        public String subtype() {
            return "yaml";
        }

        @Override
        public XContent xContent() {
            return YamlXContent.yamlXContent;
        }
    }
    ,
    CBOR(3){

        @Override
        public String mediaTypeWithoutParameters() {
            return "application/cbor";
        }

        @Override
        public String subtype() {
            return "cbor";
        }

        @Override
        public XContent xContent() {
            return CborXContent.cborXContent;
        }
    };

    private static final MediaTypeParser<XContentType> MEDIA_TYPE_PARSER;
    private int index;

    public static MediaTypeParser getMediaTypeParser() {
        return MEDIA_TYPE_PARSER;
    }

    public static XContentType fromFormat(String mediaType) {
        return MEDIA_TYPE_PARSER.fromFormat(mediaType);
    }

    public static XContentType fromMediaType(String mediaTypeHeaderValue) {
        mediaTypeHeaderValue = XContentType.removeVersionInMediaType(mediaTypeHeaderValue);
        return MEDIA_TYPE_PARSER.fromMediaType(mediaTypeHeaderValue);
    }

    private static String removeVersionInMediaType(String mediaType) {
        if (mediaType != null && (mediaType = mediaType.toLowerCase(Locale.ROOT)).contains("vnd.opensearch")) {
            return mediaType.replaceAll("vnd.opensearch\\+", "").replaceAll("\\s*;\\s*compatible-with=\\d+", "");
        }
        return mediaType;
    }

    private XContentType(int index) {
        this.index = index;
    }

    public int index() {
        return this.index;
    }

    public String mediaType() {
        return this.mediaTypeWithoutParameters();
    }

    public abstract XContent xContent();

    public abstract String mediaTypeWithoutParameters();

    @Override
    public String type() {
        return "application";
    }

    @Override
    public String format() {
        return this.subtype();
    }

    static {
        MEDIA_TYPE_PARSER = new MediaTypeParser((MediaType[])XContentType.values(), Map.of("application/*", JSON, "application/x-ndjson", JSON));
    }
}

