"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sampleVisualizations = exports.sampleQueries = void 0;

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const sampleVisualizations = [{
  name: '[Logs] Daily average bytes',
  description: '',
  query: 'source = opensearch_dashboards_sample_data_logs | stats avg(bytes) by span(timestamp,1d)',
  type: 'line',
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Daily count for error response codes',
  description: '',
  query: "source = opensearch_dashboards_sample_data_logs | where response='503' or response='404' | stats count() by span(timestamp,1d)",
  type: 'bar',
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Average ram usage by operating systems',
  description: '',
  query: 'source = opensearch_dashboards_sample_data_logs |  stats avg(machine.ram) by machine.os',
  type: 'horizontal_bar',
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Average ram usage per day by apple os',
  description: '',
  query: "source = opensearch_dashboards_sample_data_logs | where machine.os='osx' or  machine.os='ios' |  stats avg(machine.ram) by span(timestamp,1d)",
  type: 'line',
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Average ram usage per day by windows os ',
  description: '',
  query: "source = opensearch_dashboards_sample_data_logs | where match(machine.os,'win')  |  stats avg(machine.ram) by span(timestamp,1d)",
  type: 'line',
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Count requests from US to CN, IN and JP',
  description: '',
  query: "source = opensearch_dashboards_sample_data_logs | where geo.src='US' | where geo.dest='JP' or geo.dest='CN' or geo.dest='IN' | stats count() by geo.dest",
  type: 'bar',
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Count total requests by tags ',
  description: '',
  query: 'source = opensearch_dashboards_sample_data_logs | stats count() by tags',
  type: 'bar',
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Max and average bytes by host',
  description: '',
  query: 'source = opensearch_dashboards_sample_data_logs | stats max(bytes), avg(bytes) by host',
  type: 'line',
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}];
exports.sampleVisualizations = sampleVisualizations;
const sampleQueries = [{
  name: '[Flights] Show all flights sorted by most delayed',
  description: '',
  query: 'source=opensearch_dashboards_sample_data_flights  | sort -FlightDelayMin',
  selected_date_range: {
    start: 'now/M',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: [{
      name: 'Carrier',
      type: 'string'
    }, {
      name: 'Dest',
      type: 'string'
    }, {
      name: 'DestAirportID',
      type: 'string'
    }, {
      name: 'FlightDelayMin',
      type: 'integer'
    }, {
      name: 'OriginAirportID',
      type: 'string'
    }]
  }
}, {
  name: '[Logs] Show all logs lines where error code is 404 or 503',
  description: '',
  query: "source=opensearch_dashboards_sample_data_logs | where response='503' or response='404'",
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Show all logs lines where error code is 404 or 503 and deduplicate consecutive entries only',
  description: '',
  query: "source=opensearch_dashboards_sample_data_logs | where response='503' or response='404' | dedup host consecutive=true",
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Show all hosts with errors  aggregated by response, count of ips and tags',
  description: '',
  query: "source=opensearch_dashboards_sample_data_logs |  where response='503' or response='404' |  stats count() as ip_count by response , host , tags",
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Flights] Show the count of flights by Destination and Country',
  description: '',
  query: 'source=opensearch_dashboards_sample_data_flights  | stats count() by DestCountry , Dest',
  selected_date_range: {
    start: 'now/M',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Flights] Show all Carriers sorted by average delay',
  description: '',
  query: 'source=opensearch_dashboards_sample_data_flights |where FlightDelayMin > 0 | stats sum(FlightDelayMin) as total_delay_min, count() as total_delayed by Carrier |eval avg_delay=total_delay_min / total_delayed | sort - avg_delay',
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Show errors sorted by list of hostnames and average bytes per ip',
  description: '',
  query: "source=opensearch_dashboards_sample_data_logs  | where response='503' or response='404' |      stats count() as ip_count, sum(bytes)       as sum_bytes by host, response |       rename response as resp_code |       sort - ip_count, + sum_bytes |       eval per_ip_bytes=sum_bytes/ip_count",
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Show errors sorted by list of hostnames, by summation of bytes',
  description: '',
  query: "source=opensearch_dashboards_sample_data_logs | where response='503' or response='404' |      stats count() as ip_count, sum(bytes)      as sum_bytes by host, response | sort -sum_bytes",
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Show errors sorted by list of hostnames, by summation of bytes and complex evals',
  description: '',
  query: "source=opensearch_dashboards_sample_data_logs | where response='503' or response='404' |      stats count() as ip_count, sum(bytes)      as sum_bytes by host, response |      rename response as resp_code |      sort - ip_count, + sum_bytes |      eval per_ip_bytes=sum_bytes/ip_count,       double_per_ip_bytes = 2 * per_ip_bytes",
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Show all logs where request matches filebeat',
  description: '',
  query: "source = opensearch_dashboards_sample_data_logs | where match(request,'filebeat')",
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: [{
      name: 'message',
      type: 'string'
    }]
  }
}];
exports.sampleQueries = sampleQueries;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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