"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerTraceAnalyticsDslRouter = registerTraceAnalyticsDslRouter;

var _configSchema = require("@osd/config-schema");

var _trace_analytics = require("../../common/constants/trace_analytics");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function registerTraceAnalyticsDslRouter(router) {
  router.post({
    path: _trace_analytics.TRACE_ANALYTICS_INDICES_ROUTE,
    validate: false
  }, async (context, request, response) => {
    const params = {
      index: [_trace_analytics.DATA_PREPPER_INDEX_NAME, _trace_analytics.DATA_PREPPER_SERVICE_INDEX_NAME],
      allow_no_indices: false
    };

    try {
      const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('indices.exists', params);
      return response.ok({
        body: resp
      });
    } catch (error) {
      console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
  router.post({
    path: _trace_analytics.TRACE_ANALYTICS_DSL_ROUTE,
    validate: {
      body: _configSchema.schema.object({
        index: _configSchema.schema.maybe(_configSchema.schema.string()),
        from: _configSchema.schema.maybe(_configSchema.schema.number()),
        size: _configSchema.schema.number(),
        query: _configSchema.schema.maybe(_configSchema.schema.object({
          bool: _configSchema.schema.object({
            filter: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            }))),
            must: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            }))),
            should: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            }))),
            must_not: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            }))),
            minimum_should_match: _configSchema.schema.maybe(_configSchema.schema.number()),
            adjust_pure_negative: _configSchema.schema.maybe(_configSchema.schema.boolean()),
            boost: _configSchema.schema.maybe(_configSchema.schema.any())
          })
        })),
        aggs: _configSchema.schema.maybe(_configSchema.schema.any()),
        aggregations: _configSchema.schema.maybe(_configSchema.schema.any()),
        sort: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.any())),
        _source: _configSchema.schema.maybe(_configSchema.schema.object({
          includes: _configSchema.schema.arrayOf(_configSchema.schema.string())
        })),
        script_fields: _configSchema.schema.maybe(_configSchema.schema.any())
      })
    }
  }, async (context, request, response) => {
    const {
      index,
      size,
      ...rest
    } = request.body;
    const params = {
      index: index || _trace_analytics.DATA_PREPPER_INDEX_NAME,
      size,
      body: rest
    };

    try {
      const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('search', params);
      return response.ok({
        body: resp
      });
    } catch (error) {
      if (error.statusCode !== 404) console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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