/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.transport;

import java.io.IOException;
import org.opensearch.action.ActionResponse;
import org.opensearch.common.Nullable;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;

public class DeleteModelResponse
extends ActionResponse
implements ToXContentObject {
    public static final String RESULT = "result";
    public static final String ERROR_MSG = "error";
    private final String modelID;
    private final String result;
    private final String errorMessage;

    public DeleteModelResponse(String modelID, String result, @Nullable String errorMessage) {
        this.modelID = modelID;
        this.result = result;
        this.errorMessage = errorMessage;
    }

    public DeleteModelResponse(StreamInput in) throws IOException {
        super(in);
        this.modelID = in.readString();
        this.result = in.readString();
        this.errorMessage = in.readOptionalString();
    }

    public String getModelID() {
        return this.modelID;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getResult() {
        return this.result;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("model_id", this.getModelID());
        builder.field(RESULT, this.getResult());
        if (Strings.hasText((String)this.errorMessage)) {
            builder.field(ERROR_MSG, this.getErrorMessage());
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput output) throws IOException {
        output.writeString(this.modelID);
        output.writeString(this.getResult());
        output.writeOptionalString(this.getErrorMessage());
    }
}

