/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.load;

import java.io.IOException;
import java.util.List;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.ml.common.transport.load.LoadModelNodeResponse;

public class LoadModelNodesResponse
extends BaseNodesResponse<LoadModelNodeResponse>
implements ToXContentObject {
    public LoadModelNodesResponse(StreamInput in) throws IOException {
        super(new ClusterName(in), in.readList(LoadModelNodeResponse::readStats), in.readList(FailedNodeException::new));
    }

    public LoadModelNodesResponse(ClusterName clusterName, List<LoadModelNodeResponse> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
    }

    public void writeNodesTo(StreamOutput out, List<LoadModelNodeResponse> nodes) throws IOException {
        out.writeList(nodes);
    }

    public List<LoadModelNodeResponse> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(LoadModelNodeResponse::readStats);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (LoadModelNodeResponse loadStats : this.getNodes()) {
            DiscoveryNode node = loadStats.getNode();
            String nodeId = node.getId();
            builder.startObject(nodeId);
            loadStats.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }
}

