/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.transport;

import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.notifications.core.client.DestinationClientPool;
import org.opensearch.notifications.core.client.DestinationSesClient;
import org.opensearch.notifications.core.transport.DestinationTransport;
import org.opensearch.notifications.core.utils.HelpersKt;
import org.opensearch.notifications.core.utils.OpenForTesting;
import org.opensearch.notifications.spi.model.DestinationMessageResponse;
import org.opensearch.notifications.spi.model.MessageContent;
import org.opensearch.notifications.spi.model.destination.SesDestination;
import org.opensearch.rest.RestStatus;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u000f\b\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/opensearch/notifications/core/transport/SesDestinationTransport;", "Lorg/opensearch/notifications/core/transport/DestinationTransport;", "Lorg/opensearch/notifications/spi/model/destination/SesDestination;", "()V", "destinationSesClient", "Lorg/opensearch/notifications/core/client/DestinationSesClient;", "(Lorg/opensearch/notifications/core/client/DestinationSesClient;)V", "destinationEmailClient", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "sendMessage", "Lorg/opensearch/notifications/spi/model/DestinationMessageResponse;", "destination", "message", "Lorg/opensearch/notifications/spi/model/MessageContent;", "referenceId", "", "opensearch-notifications-core"})
public final class SesDestinationTransport
implements DestinationTransport<SesDestination> {
    @NotNull
    private final Lazy log$delegate;
    @NotNull
    private final DestinationSesClient destinationEmailClient;

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        return (Logger)lazy.getValue();
    }

    public SesDestinationTransport() {
        this.log$delegate = HelpersKt.logger(SesDestinationTransport.class);
        this.destinationEmailClient = DestinationClientPool.INSTANCE.getSesClient();
    }

    @OpenForTesting
    public SesDestinationTransport(@NotNull DestinationSesClient destinationSesClient) {
        Intrinsics.checkNotNullParameter((Object)destinationSesClient, (String)"destinationSesClient");
        this.log$delegate = HelpersKt.logger(SesDestinationTransport.class);
        this.destinationEmailClient = destinationSesClient;
    }

    @Override
    @NotNull
    public DestinationMessageResponse sendMessage(@NotNull SesDestination destination, @NotNull MessageContent message, @NotNull String referenceId) {
        DestinationMessageResponse destinationMessageResponse;
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        try {
            destinationMessageResponse = this.destinationEmailClient.execute(destination, message, referenceId);
        }
        catch (AddressException addressException) {
            this.getLog().error("Error sending Email: recipient parsing failed with status:" + addressException.getMessage());
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.BAD_REQUEST.getStatus(), "recipient parsing failed with status:" + addressException.getMessage());
        }
        catch (MessagingException messagingException) {
            this.getLog().error("Error sending Email: Email message creation failed with status:" + messagingException.getMessage());
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.FAILED_DEPENDENCY.getStatus(), "Email message creation failed with status:" + messagingException.getMessage());
        }
        catch (IOException ioException) {
            this.getLog().error("Error sending Email: Email message creation failed with status:" + ioException.getMessage());
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.FAILED_DEPENDENCY.getStatus(), "Email message creation failed with status:" + ioException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.getLog().error("Error sending Email: Email message creation failed with status:" + illegalArgumentException.getMessage());
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.BAD_REQUEST.getStatus(), "Email message creation failed with status:" + illegalArgumentException.getMessage());
        }
        return destinationMessageResponse;
    }
}

