/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.api.summaries.temperature;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.protobuf.GeneratedMessageV3;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SelectJoinStep;
import org.jooq.impl.DSL;
import org.opensearch.performanceanalyzer.grpc.FlowUnitMessage;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.temperature.CompactClusterLevelNodeSummary;
import org.opensearch.performanceanalyzer.rca.framework.core.GenericSummary;
import org.opensearch.performanceanalyzer.rca.framework.core.temperature.HeatZoneAssigner;
import org.opensearch.performanceanalyzer.rca.framework.core.temperature.TemperatureDimension;
import org.opensearch.performanceanalyzer.rca.framework.core.temperature.TemperatureVector;
import org.opensearch.performanceanalyzer.rca.framework.util.SQLiteQueryUtils;
import org.opensearch.performanceanalyzer.rca.store.rca.temperature.dimension.CpuUtilDimensionTemperatureRca;

public class ClusterDimensionalSummary
extends GenericSummary {
    private static final Logger LOG = LogManager.getLogger(ClusterDimensionalSummary.class);
    public static final String TABLE_NAME = ClusterDimensionalSummary.class.getSimpleName();
    public static final String ZONE_PROFILE_TABLE_NAME = ZoneSummary.class.getSimpleName();
    private static final String DIM_KEY = "dimension";
    private static final String MEAN_KEY = "mean";
    private static final String TOTAL_KEY = "total";
    private static final String NUM_NODES_KEY = "numNodes";
    private final TemperatureDimension profileForDimension;
    private TemperatureVector.NormalizedValue meanTemperature;
    private double totalUsage;
    private int numberOfNodes;
    private final ZoneSummary[] zoneProfiles;

    public ClusterDimensionalSummary(TemperatureDimension profileForDimension) {
        this.profileForDimension = profileForDimension;
        this.zoneProfiles = new ZoneSummary[HeatZoneAssigner.Zone.values().length];
        for (int i = 0; i < this.zoneProfiles.length; ++i) {
            this.zoneProfiles[i] = new ZoneSummary(HeatZoneAssigner.Zone.values()[i]);
        }
    }

    public void setMeanTemperature(TemperatureVector.NormalizedValue meanTemperature) {
        this.meanTemperature = meanTemperature;
    }

    public void setTotalUsage(double totalUsage) {
        this.totalUsage = totalUsage;
    }

    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public void setNumberOfNodes(int numberOfNodes) {
        this.numberOfNodes = numberOfNodes;
    }

    public void addNodeToZone(CompactClusterLevelNodeSummary nodeSummary) {
        HeatZoneAssigner.Zone zone = HeatZoneAssigner.assign(nodeSummary.getTemperatureForDimension(this.profileForDimension), this.meanTemperature, CpuUtilDimensionTemperatureRca.THRESHOLD_NORMALIZED_VAL_FOR_HEAT_ZONE_ASSIGNMENT);
        ZoneSummary profile = this.zoneProfiles[zone.ordinal()];
        profile.addNode(nodeSummary);
        ++this.numberOfNodes;
    }

    public TemperatureVector.NormalizedValue getMeanTemperature() {
        return this.meanTemperature;
    }

    public TemperatureDimension getProfileForDimension() {
        return this.profileForDimension;
    }

    public double getTotalUsage() {
        return this.totalUsage;
    }

    @Override
    public <T extends GeneratedMessageV3> T buildSummaryMessage() {
        throw new IllegalArgumentException("This should not be called.");
    }

    @Override
    public void buildSummaryMessageAndAddToFlowUnit(FlowUnitMessage.Builder messageBuilder) {
        throw new IllegalArgumentException("This should not be called.");
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    @Override
    public List<GenericSummary> getNestedSummaryList() {
        ArrayList<GenericSummary> zoneSummaries = new ArrayList<GenericSummary>();
        for (ZoneSummary zone : this.zoneProfiles) {
            zoneSummaries.add(zone);
        }
        return zoneSummaries;
    }

    public static List<Field<?>> getCols() {
        ArrayList schema = new ArrayList();
        schema.add(DSL.field((Name)DSL.name((String)DIM_KEY), String.class));
        schema.add(DSL.field((Name)DSL.name((String)MEAN_KEY), Short.class));
        schema.add(DSL.field((Name)DSL.name((String)TOTAL_KEY), Double.class));
        schema.add(DSL.field((Name)DSL.name((String)NUM_NODES_KEY), Integer.class));
        return schema;
    }

    @Override
    public List<Field<?>> getSqlSchema() {
        return ClusterDimensionalSummary.getCols();
    }

    @Override
    public List<Object> getSqlValue() {
        ArrayList<Object> row = new ArrayList<Object>();
        row.add(this.getProfileForDimension().NAME);
        row.add(this.getMeanTemperature().getPOINTS());
        row.add(this.getTotalUsage());
        row.add(this.getNumberOfNodes());
        return row;
    }

    @Override
    public JsonElement toJson() {
        JsonObject summaryObj = new JsonObject();
        summaryObj.addProperty(DIM_KEY, this.getProfileForDimension().NAME);
        summaryObj.addProperty(MEAN_KEY, (Number)this.getMeanTemperature().getPOINTS());
        summaryObj.addProperty(TOTAL_KEY, (Number)this.getTotalUsage());
        summaryObj.addProperty(NUM_NODES_KEY, (Number)this.getNumberOfNodes());
        JsonArray arr = new JsonArray();
        for (ZoneSummary zone : this.zoneProfiles) {
            arr.add(zone.toJson());
        }
        summaryObj.add(ZONE_PROFILE_TABLE_NAME, (JsonElement)arr);
        return summaryObj;
    }

    public static ClusterDimensionalSummary build(Record record, DSLContext context) {
        String dimensionName = (String)record.get(DIM_KEY, String.class);
        TemperatureVector.NormalizedValue meanTemp = new TemperatureVector.NormalizedValue((Short)record.get(MEAN_KEY, Short.class));
        double total = (Double)record.get(TOTAL_KEY, Double.class);
        int numNodes = (Integer)record.get(NUM_NODES_KEY, Integer.class);
        int dimSummaryId = (Integer)record.get(SQLiteQueryUtils.getPrimaryKeyColumnName(TABLE_NAME), Integer.class);
        ClusterDimensionalSummary summary = new ClusterDimensionalSummary(TemperatureDimension.valueOf(dimensionName));
        summary.setTotalUsage(total);
        summary.setMeanTemperature(meanTemp);
        summary.setNumberOfNodes(numNodes);
        Field foreignKeyForDimensionalTable = DSL.field((String)SQLiteQueryUtils.getPrimaryKeyColumnName(TABLE_NAME), Integer.class);
        SelectJoinStep<Record> rcaQuery = SQLiteQueryUtils.buildSummaryQuery(context, ZONE_PROFILE_TABLE_NAME, dimSummaryId, (Field<Integer>)foreignKeyForDimensionalTable);
        Result recordList = rcaQuery.fetch();
        for (Record zoneSummary : recordList) {
            ClusterDimensionalSummary.buildZoneProfile(zoneSummary, summary, context);
        }
        return summary;
    }

    private static void buildZoneProfile(Record record, ClusterDimensionalSummary summary, DSLContext context) {
        String zoneName = (String)record.get("zone", String.class);
        ZoneSummary zone = summary.zoneProfiles[HeatZoneAssigner.Zone.valueOf(zoneName).ordinal()];
        String allNodesStr = (String)record.get("all_nodes", String.class);
        if (!allNodesStr.isEmpty()) {
            JsonArray json = new JsonParser().parse(allNodesStr).getAsJsonArray();
            for (int i = 0; i < json.getAsJsonArray().size(); ++i) {
                JsonObject obj = json.get(i).getAsJsonObject();
                String hostIp = obj.get("host_address").getAsString();
                String nodeId = obj.get("node_id").getAsString();
                CompactClusterLevelNodeSummary nodeSummary = new CompactClusterLevelNodeSummary(nodeId, hostIp);
                zone.addNode(nodeSummary);
            }
        }
    }

    public class ZoneSummary
    extends GenericSummary {
        private static final String ZONE_KEY = "zone";
        private static final String MIN_KEY = "min";
        private static final String MAX_KEY = "max";
        private static final String ALL_NODES_KEY = "all_nodes";
        private final HeatZoneAssigner.Zone myZone;
        List<CompactClusterLevelNodeSummary> nodeProfileSummaries;
        CompactClusterLevelNodeSummary minNode;
        CompactClusterLevelNodeSummary maxNode;

        ZoneSummary(HeatZoneAssigner.Zone myZone) {
            this.myZone = myZone;
            this.nodeProfileSummaries = new ArrayList<CompactClusterLevelNodeSummary>();
        }

        void addNode(@Nonnull CompactClusterLevelNodeSummary node) {
            this.nodeProfileSummaries.add(node);
            if (this.minNode == null) {
                this.minNode = node;
            } else if (this.getMinTemperature().isGreaterThan(node.getTemperatureForDimension(ClusterDimensionalSummary.this.profileForDimension))) {
                this.minNode = node;
            }
            if (this.maxNode == null) {
                this.maxNode = node;
            } else if (node.getTemperatureForDimension(ClusterDimensionalSummary.this.profileForDimension).isGreaterThan(this.getMaxTemperature())) {
                this.maxNode = node;
            }
        }

        @Nullable
        TemperatureVector.NormalizedValue getMinTemperature() {
            if (this.minNode != null) {
                return this.minNode.getTemperatureForDimension(ClusterDimensionalSummary.this.profileForDimension);
            }
            return null;
        }

        @Nullable
        TemperatureVector.NormalizedValue getMaxTemperature() {
            if (this.maxNode != null) {
                return this.maxNode.getTemperatureForDimension(ClusterDimensionalSummary.this.profileForDimension);
            }
            return null;
        }

        @Override
        public <T extends GeneratedMessageV3> T buildSummaryMessage() {
            throw new IllegalArgumentException("");
        }

        @Override
        public void buildSummaryMessageAndAddToFlowUnit(FlowUnitMessage.Builder messageBuilder) {
            throw new IllegalArgumentException("");
        }

        @Override
        public String getTableName() {
            return ZONE_PROFILE_TABLE_NAME;
        }

        private List<Field<?>> getColumns() {
            ArrayList schema = new ArrayList();
            schema.add(DSL.field((Name)DSL.name((String)ZONE_KEY), String.class));
            schema.add(DSL.field((Name)DSL.name((String)MIN_KEY), String.class));
            schema.add(DSL.field((Name)DSL.name((String)MAX_KEY), String.class));
            schema.add(DSL.field((Name)DSL.name((String)ALL_NODES_KEY), String.class));
            return schema;
        }

        @Override
        public List<Field<?>> getSqlSchema() {
            return this.getColumns();
        }

        private JsonObject getNodeJson(CompactClusterLevelNodeSummary nodeSummary) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("host_address", nodeSummary.getHostAddress());
            jsonObject.addProperty("node_id", nodeSummary.getNodeId());
            return jsonObject;
        }

        private JsonArray getAllNodesJson() {
            JsonArray jsonArray = new JsonArray();
            for (CompactClusterLevelNodeSummary nodeSummary : this.nodeProfileSummaries) {
                jsonArray.add((JsonElement)this.getNodeJson(nodeSummary));
            }
            return jsonArray;
        }

        private String getAllNodesString(JsonArray json) {
            StringBuilder sb = new StringBuilder();
            String delim = "[";
            for (JsonElement elem : json) {
                JsonObject obj = elem.getAsJsonObject();
                sb.append(delim).append(obj);
                delim = ",";
            }
            if (sb.length() > 0) {
                sb.append("]");
            }
            return sb.toString();
        }

        @Override
        public List<Object> getSqlValue() {
            ArrayList<Object> values = new ArrayList<Object>();
            values.add(this.myZone.name());
            values.add(this.minNode == null ? "" : this.minNode.getHostAddress());
            values.add(this.maxNode == null ? "" : this.maxNode.getHostAddress());
            JsonArray allNodes = this.getAllNodesJson();
            String allNodesStr = this.getAllNodesString(allNodes);
            values.add(allNodesStr);
            return values;
        }

        @Override
        public JsonElement toJson() {
            JsonObject summaryObj = new JsonObject();
            summaryObj.addProperty(ZONE_KEY, this.myZone.name());
            if (this.minNode == this.maxNode) {
                summaryObj.add(MIN_KEY, null);
                summaryObj.add(MAX_KEY, null);
            } else {
                summaryObj.add(MIN_KEY, this.minNode == null ? null : this.getNodeJson(this.minNode));
                summaryObj.add(MAX_KEY, this.maxNode == null ? null : this.getNodeJson(this.maxNode));
            }
            summaryObj.add(ALL_NODES_KEY, (JsonElement)this.getAllNodesJson());
            return summaryObj;
        }
    }
}

