/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.store.collector;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.opensearch.performanceanalyzer.grpc.Resource;
import org.opensearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;

public class NodeConfigCache {
    private static final int CACHE_TTL = 10;
    private final Cache<NodeConfigKey, Double> nodeConfigCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();

    public void put(NodeKey nodeKey, Resource config, double value) {
        this.nodeConfigCache.put((Object)new NodeConfigKey(nodeKey, config), (Object)value);
    }

    public double get(NodeKey nodeKey, Resource config) throws IllegalArgumentException {
        Double ret = (Double)this.nodeConfigCache.getIfPresent((Object)new NodeConfigKey(nodeKey, config));
        if (ret == null) {
            throw new IllegalArgumentException();
        }
        return ret;
    }

    private static class NodeConfigKey {
        private final NodeKey nodeKey;
        private final Resource resource;

        public NodeConfigKey(NodeKey nodeKey, Resource resource) {
            this.nodeKey = nodeKey;
            this.resource = resource;
        }

        public NodeKey getNodeKey() {
            return this.nodeKey;
        }

        public Resource getResource() {
            return this.resource;
        }

        public boolean equals(Object obj) {
            if (obj instanceof NodeConfigKey) {
                NodeConfigKey key = (NodeConfigKey)obj;
                return this.nodeKey.equals(key.getNodeKey()) && this.resource.equals(key.getResource());
            }
            return false;
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append(this.nodeKey.hashCode()).append(this.resource.hashCode()).toHashCode();
        }
    }
}

