/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.store.rca.admissioncontrol.model;

public class HeapMetric {
    private final double usedHeap;
    private final double maxHeap;

    public HeapMetric(double usedHeap, double maxHeap) {
        this.usedHeap = usedHeap;
        this.maxHeap = maxHeap;
    }

    public double getUsedHeap() {
        return this.usedHeap;
    }

    public double getMaxHeap() {
        return this.maxHeap;
    }

    public double getHeapPercent() {
        if (this.getMaxHeap() == 0.0) {
            return 0.0;
        }
        return 100.0 * this.getUsedHeap() / this.getMaxHeap();
    }

    public boolean hasValues() {
        return this.getUsedHeap() != 0.0 && this.getMaxHeap() != 0.0;
    }

    public String toString() {
        return "HeapMetric{usedHeap=" + this.usedHeap + ", maxHeap=" + this.maxHeap + "}";
    }
}

