/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.util.range;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.opensearch.performanceanalyzer.util.range.Range;
import org.opensearch.performanceanalyzer.util.range.RangeConfiguration;

public class RequestSizeHeapRangeConfiguration
implements RangeConfiguration {
    private final Collection<Range> DEFAULT_RANGE_CONFIGURATION = Collections.unmodifiableList(Arrays.asList(new Range(0.0, 80.0, 15.0), new Range(81.0, 90.0, 10.0), new Range(91.0, 100.0, 5.0)));
    private Collection<Range> rangeConfiguration = this.DEFAULT_RANGE_CONFIGURATION;

    @Override
    public Range getRange(double value) {
        return this.rangeConfiguration.stream().filter(range -> range.contains(value)).findFirst().orElse(null);
    }

    @Override
    public boolean hasRangeChanged(double previousValue, double currentValue) {
        Range previousRange = this.getRange(previousValue);
        Range currentRange = this.getRange(currentValue);
        if (previousRange == null || currentRange == null) {
            return false;
        }
        return !previousRange.equals(currentRange);
    }

    @Override
    public void setRangeConfiguration(Collection<Range> rangeConfiguration) {
        this.rangeConfiguration = rangeConfiguration;
    }
}

