/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.collectors;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.opensearch.cluster.service.ClusterApplierService;
import org.opensearch.performanceanalyzer.OpenSearchResources;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerApp;
import org.opensearch.performanceanalyzer.collectors.MetricStatus;
import org.opensearch.performanceanalyzer.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.config.PerformanceAnalyzerController;
import org.opensearch.performanceanalyzer.config.overrides.ConfigOverridesWrapper;
import org.opensearch.performanceanalyzer.metrics.MetricsConfiguration;
import org.opensearch.performanceanalyzer.metrics.MetricsProcessor;
import org.opensearch.performanceanalyzer.metrics.PerformanceAnalyzerMetrics;
import org.opensearch.performanceanalyzer.rca.framework.metrics.ExceptionsAndErrors;
import org.opensearch.performanceanalyzer.rca.framework.metrics.WriterMetrics;
import org.opensearch.performanceanalyzer.rca.stats.measurements.MeasurementSet;

public class ClusterApplierServiceStatsCollector
extends PerformanceAnalyzerMetricsCollector
implements MetricsProcessor {
    public static final int SAMPLING_TIME_INTERVAL = ((MetricsConfiguration.MetricConfig)MetricsConfiguration.CONFIG_MAP.get(ClusterApplierServiceStatsCollector.class)).samplingInterval;
    private static final int KEYS_PATH_LENGTH = 0;
    private static final Logger LOG = LogManager.getLogger(ClusterApplierServiceStatsCollector.class);
    private static final String GET_CLUSTER_APPLIER_SERVICE_STATS_METHOD_NAME = "getStats";
    private static final ObjectMapper mapper;
    private static volatile ClusterApplierServiceStats prevClusterApplierServiceStats;
    private final StringBuilder value = new StringBuilder();
    private final PerformanceAnalyzerController controller;
    private final ConfigOverridesWrapper configOverridesWrapper;

    public ClusterApplierServiceStatsCollector(PerformanceAnalyzerController controller, ConfigOverridesWrapper configOverridesWrapper) {
        super(SAMPLING_TIME_INTERVAL, ClusterApplierServiceStatsCollector.class.getSimpleName());
        this.controller = controller;
        this.configOverridesWrapper = configOverridesWrapper;
    }

    public void collectMetrics(long startTime) {
        if (!this.controller.isCollectorEnabled(this.configOverridesWrapper, this.getCollectorName())) {
            return;
        }
        try {
            long mCurrT = System.currentTimeMillis();
            if (OpenSearchResources.INSTANCE.getClusterService() == null || OpenSearchResources.INSTANCE.getClusterService().getClusterApplierService() == null) {
                return;
            }
            ClusterApplierServiceStats currentClusterApplierServiceStats = null;
            try {
                currentClusterApplierServiceStats = (ClusterApplierServiceStats)mapper.readValue(mapper.writeValueAsString(this.getClusterApplierServiceStats()), ClusterApplierServiceStats.class);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                LOG.warn("No method found to get cluster state applier thread stats. Skipping ClusterApplierServiceStatsCollector");
                return;
            }
            ClusterApplierServiceMetrics clusterApplierServiceMetrics = new ClusterApplierServiceMetrics(this.computeLatency(currentClusterApplierServiceStats), this.computeFailure(currentClusterApplierServiceStats));
            this.value.setLength(0);
            this.value.append(PerformanceAnalyzerMetrics.getJsonCurrentMilliSeconds()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
            this.value.append(clusterApplierServiceMetrics.serialize());
            this.saveMetricValues(this.value.toString(), startTime, new String[0]);
            prevClusterApplierServiceStats = currentClusterApplierServiceStats;
            PerformanceAnalyzerApp.WRITER_METRICS_AGGREGATOR.updateStat((MeasurementSet)WriterMetrics.CLUSTER_APPLIER_SERVICE_STATS_COLLECTOR_EXECUTION_TIME, "", (Number)(System.currentTimeMillis() - mCurrT));
        }
        catch (Exception ex) {
            PerformanceAnalyzerApp.ERRORS_AND_EXCEPTIONS_AGGREGATOR.updateStat((MeasurementSet)ExceptionsAndErrors.CLUSTER_APPLIER_SERVICE_STATS_COLLECTOR_ERROR, "", (Number)1);
            LOG.debug("Exception in Collecting Cluster Applier Service Metrics: {} for startTime {}", new Supplier[]{() -> ex.toString(), () -> startTime});
        }
    }

    @VisibleForTesting
    public void resetPrevClusterApplierServiceStats() {
        prevClusterApplierServiceStats = new ClusterApplierServiceStats();
    }

    @VisibleForTesting
    public Object getClusterApplierServiceStats() throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Method method = ClusterApplierService.class.getMethod(GET_CLUSTER_APPLIER_SERVICE_STATS_METHOD_NAME, new Class[0]);
        return method.invoke((Object)OpenSearchResources.INSTANCE.getClusterService().getClusterApplierService(), new Object[0]);
    }

    private double computeLatency(ClusterApplierServiceStats currentMetrics) {
        double rate = this.computeRate(currentMetrics.totalCount);
        if (rate == 0.0) {
            return 0.0;
        }
        return (double)(currentMetrics.timeTakenInMillis - ClusterApplierServiceStatsCollector.prevClusterApplierServiceStats.timeTakenInMillis) / rate;
    }

    private double computeRate(double currentTotalCount) {
        return currentTotalCount - (double)ClusterApplierServiceStatsCollector.prevClusterApplierServiceStats.totalCount;
    }

    private double computeFailure(ClusterApplierServiceStats currentMetrics) {
        return currentMetrics.failedCount - ClusterApplierServiceStatsCollector.prevClusterApplierServiceStats.failedCount;
    }

    public String getMetricsPath(long startTime, String ... keysPath) {
        if (keysPath.length != 0) {
            throw new RuntimeException("keys length should be 0");
        }
        return PerformanceAnalyzerMetrics.generatePath((long)startTime, (String[])new String[]{"cluster_applier_service"});
    }

    static {
        prevClusterApplierServiceStats = new ClusterApplierServiceStats();
        mapper = new ObjectMapper();
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public static class ClusterApplierServiceMetrics
    extends MetricStatus {
        private double clusterStateAppliedFailedCount;
        private double clusterStateAppliedTimeInMillis;

        public ClusterApplierServiceMetrics(double clusterApplierServiceLatency, double clusterApplierServiceFailed) {
            this.clusterStateAppliedTimeInMillis = clusterApplierServiceLatency;
            this.clusterStateAppliedFailedCount = clusterApplierServiceFailed;
        }

        @JsonProperty(value="ClusterApplierService_Latency")
        public double getClusterApplierServiceLatency() {
            return this.clusterStateAppliedTimeInMillis;
        }

        @JsonProperty(value="ClusterApplierService_Failure")
        public double getClusterApplierServiceFailed() {
            return this.clusterStateAppliedFailedCount;
        }
    }

    public static class ClusterApplierServiceStats {
        private long totalCount;
        private long timeTakenInMillis;
        private long failedCount;
        private long elapsedTimeCurrentInMillis;

        @VisibleForTesting
        public ClusterApplierServiceStats(long totalCount, long timeTakenInMillis, long failedCount, long elapsedTimeCurrentInMillis) {
            this.totalCount = totalCount;
            this.timeTakenInMillis = timeTakenInMillis;
            this.failedCount = failedCount;
            this.elapsedTimeCurrentInMillis = elapsedTimeCurrentInMillis;
        }

        public ClusterApplierServiceStats() {
        }
    }
}

