/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.atom;

import java.awt.Color;
import java.awt.image.BufferedImage;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.creole.atom.AbstractAtom;
import net.sourceforge.plantuml.creole.atom.Atom;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.math.ScientificEquationSafe;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UImageSvg;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSimple;

public class AtomMath
extends AbstractAtom
implements Atom {
    private final ScientificEquationSafe math;
    private final HColor foreground;
    private final HColor background;
    private XDimension2D dim;

    public AtomMath(ScientificEquationSafe math, HColor foreground, HColor background) {
        this.math = math;
        this.foreground = foreground;
        this.background = background;
    }

    private XDimension2D calculateDimensionSlow(StringBounder stringBounder) {
        BufferedImage image = this.math.getImage(Color.BLACK, Color.WHITE).withScale(1.0).getImage();
        return new XDimension2D(image.getWidth(), image.getHeight());
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        if (this.dim == null) {
            this.dim = this.calculateDimensionSlow(stringBounder);
        }
        return this.dim;
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        ColorMapper colorMapper = ug.getColorMapper();
        boolean isSvg = ug.matchesProperty("SVG");
        Color back = this.background == null ? null : this.getColor(colorMapper, this.background, Color.WHITE);
        Color fore = this.getColor(colorMapper, this.foreground, Color.BLACK);
        if (isSvg) {
            UImageSvg svg = this.math.getSvg(1.0, fore, back);
            ug.draw(svg);
        } else {
            UImage image = new UImage(this.math.getImage(fore, back)).withFormula(this.math.getFormula());
            ug.draw(image);
        }
    }

    private Color getColor(ColorMapper colorMapper, HColor color, Color defaultValue) {
        if (color instanceof HColorSimple) {
            return color.toColor(colorMapper);
        }
        return defaultValue;
    }
}

