# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
CDM module, see official documentation at
https://www.opencascade.com/doc/occt-7.6.0/refman/html/package_cdm.html
"""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _CDM
else:
    import _CDM

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _CDM.delete_SwigPyIterator

    def value(self) -> "PyObject *":
        return _CDM.SwigPyIterator_value(self)

    def incr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _CDM.SwigPyIterator_incr(self, n)

    def decr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _CDM.SwigPyIterator_decr(self, n)

    def distance(self, x: "SwigPyIterator") -> "ptrdiff_t":
        return _CDM.SwigPyIterator_distance(self, x)

    def equal(self, x: "SwigPyIterator") -> "bool":
        return _CDM.SwigPyIterator_equal(self, x)

    def copy(self) -> "swig::SwigPyIterator *":
        return _CDM.SwigPyIterator_copy(self)

    def next(self) -> "PyObject *":
        return _CDM.SwigPyIterator_next(self)

    def __next__(self) -> "PyObject *":
        return _CDM.SwigPyIterator___next__(self)

    def previous(self) -> "PyObject *":
        return _CDM.SwigPyIterator_previous(self)

    def advance(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _CDM.SwigPyIterator_advance(self, n)

    def __eq__(self, x: "SwigPyIterator") -> "bool":
        return _CDM.SwigPyIterator___eq__(self, x)

    def __ne__(self, x: "SwigPyIterator") -> "bool":
        return _CDM.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _CDM.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _CDM.SwigPyIterator___isub__(self, n)

    def __add__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _CDM.SwigPyIterator___add__(self, n)

    def __sub__(self, *args) -> "ptrdiff_t":
        return _CDM.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _CDM:
_CDM.SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error: "Standard_Failure", method_name: "std::string", class_name: "std::string") -> "void":
    return _CDM.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.Message
import OCC.Core.OSD
import OCC.Core.Resource

from enum import IntEnum
from OCC.Core.Exception import *

CDM_CCS_OK = _CDM.CDM_CCS_OK
CDM_CCS_NotOpen = _CDM.CDM_CCS_NotOpen
CDM_CCS_UnstoredReferenced = _CDM.CDM_CCS_UnstoredReferenced
CDM_CCS_ModifiedReferenced = _CDM.CDM_CCS_ModifiedReferenced
CDM_CCS_ReferenceRejection = _CDM.CDM_CCS_ReferenceRejection


class CDM_CanCloseStatus(IntEnum):
	CDM_CCS_OK = 0
	CDM_CCS_NotOpen = 1
	CDM_CCS_UnstoredReferenced = 2
	CDM_CCS_ModifiedReferenced = 3
	CDM_CCS_ReferenceRejection = 4
CDM_CCS_OK = CDM_CanCloseStatus.CDM_CCS_OK
CDM_CCS_NotOpen = CDM_CanCloseStatus.CDM_CCS_NotOpen
CDM_CCS_UnstoredReferenced = CDM_CanCloseStatus.CDM_CCS_UnstoredReferenced
CDM_CCS_ModifiedReferenced = CDM_CanCloseStatus.CDM_CCS_ModifiedReferenced
CDM_CCS_ReferenceRejection = CDM_CanCloseStatus.CDM_CCS_ReferenceRejection


def Handle_CDM_Application_Create() -> "opencascade::handle< CDM_Application >":
    return _CDM.Handle_CDM_Application_Create()

def Handle_CDM_Application_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< CDM_Application >":
    return _CDM.Handle_CDM_Application_DownCast(t)

def Handle_CDM_Application_IsNull(t: "opencascade::handle< CDM_Application > const &") -> "bool":
    return _CDM.Handle_CDM_Application_IsNull(t)

def Handle_CDM_Document_Create() -> "opencascade::handle< CDM_Document >":
    return _CDM.Handle_CDM_Document_Create()

def Handle_CDM_Document_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< CDM_Document >":
    return _CDM.Handle_CDM_Document_DownCast(t)

def Handle_CDM_Document_IsNull(t: "opencascade::handle< CDM_Document > const &") -> "bool":
    return _CDM.Handle_CDM_Document_IsNull(t)

def Handle_CDM_MetaData_Create() -> "opencascade::handle< CDM_MetaData >":
    return _CDM.Handle_CDM_MetaData_Create()

def Handle_CDM_MetaData_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< CDM_MetaData >":
    return _CDM.Handle_CDM_MetaData_DownCast(t)

def Handle_CDM_MetaData_IsNull(t: "opencascade::handle< CDM_MetaData > const &") -> "bool":
    return _CDM.Handle_CDM_MetaData_IsNull(t)

def Handle_CDM_Reference_Create() -> "opencascade::handle< CDM_Reference >":
    return _CDM.Handle_CDM_Reference_Create()

def Handle_CDM_Reference_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< CDM_Reference >":
    return _CDM.Handle_CDM_Reference_DownCast(t)

def Handle_CDM_Reference_IsNull(t: "opencascade::handle< CDM_Reference > const &") -> "bool":
    return _CDM.Handle_CDM_Reference_IsNull(t)
class CDM_DocumentHasher(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def HashCode(theKey: "opencascade::handle< CDM_Document > const &", theUpperBound: "Standard_Integer const") -> "Standard_Integer":
        return _CDM.CDM_DocumentHasher_HashCode(theKey, theUpperBound)

    @staticmethod
    def IsEqual(theKey1: "opencascade::handle< CDM_Document > const &", theKey2: "opencascade::handle< CDM_Document > const &") -> "Standard_Boolean":
        return _CDM.CDM_DocumentHasher_IsEqual(theKey1, theKey2)

    def __init__(self):
        _CDM.CDM_DocumentHasher_swiginit(self, _CDM.new_CDM_DocumentHasher())
    __swig_destroy__ = _CDM.delete_CDM_DocumentHasher

# Register CDM_DocumentHasher in _CDM:
_CDM.CDM_DocumentHasher_swigregister(CDM_DocumentHasher)

def CDM_DocumentHasher_HashCode(theKey: "opencascade::handle< CDM_Document > const &", theUpperBound: "Standard_Integer const") -> "Standard_Integer":
    return _CDM.CDM_DocumentHasher_HashCode(theKey, theUpperBound)

def CDM_DocumentHasher_IsEqual(theKey1: "opencascade::handle< CDM_Document > const &", theKey2: "opencascade::handle< CDM_Document > const &") -> "Standard_Boolean":
    return _CDM.CDM_DocumentHasher_IsEqual(theKey1, theKey2)

class CDM_ListIteratorOfListOfDocument(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _CDM.CDM_ListIteratorOfListOfDocument_swiginit(self, _CDM.new_CDM_ListIteratorOfListOfDocument(*args))

    def More(self) -> "Standard_Boolean":
        return _CDM.CDM_ListIteratorOfListOfDocument_More(self)

    def Next(self) -> "void":
        return _CDM.CDM_ListIteratorOfListOfDocument_Next(self)

    def Value(self) -> "opencascade::handle< CDM_Document > const &":
        return _CDM.CDM_ListIteratorOfListOfDocument_Value(self)

    def ChangeValue(self) -> "opencascade::handle< CDM_Document > &":
        return _CDM.CDM_ListIteratorOfListOfDocument_ChangeValue(self)
    __swig_destroy__ = _CDM.delete_CDM_ListIteratorOfListOfDocument

# Register CDM_ListIteratorOfListOfDocument in _CDM:
_CDM.CDM_ListIteratorOfListOfDocument_swigregister(CDM_ListIteratorOfListOfDocument)

class CDM_ListIteratorOfListOfReferences(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _CDM.CDM_ListIteratorOfListOfReferences_swiginit(self, _CDM.new_CDM_ListIteratorOfListOfReferences(*args))

    def More(self) -> "Standard_Boolean":
        return _CDM.CDM_ListIteratorOfListOfReferences_More(self)

    def Next(self) -> "void":
        return _CDM.CDM_ListIteratorOfListOfReferences_Next(self)

    def Value(self) -> "opencascade::handle< CDM_Reference > const &":
        return _CDM.CDM_ListIteratorOfListOfReferences_Value(self)

    def ChangeValue(self) -> "opencascade::handle< CDM_Reference > &":
        return _CDM.CDM_ListIteratorOfListOfReferences_ChangeValue(self)
    __swig_destroy__ = _CDM.delete_CDM_ListIteratorOfListOfReferences

# Register CDM_ListIteratorOfListOfReferences in _CDM:
_CDM.CDM_ListIteratorOfListOfReferences_swigregister(CDM_ListIteratorOfListOfReferences)

class CDM_ListOfDocument(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self) -> "NCollection_List< opencascade::handle< CDM_Document > >::iterator":
        return _CDM.CDM_ListOfDocument_begin(self)

    def end(self) -> "NCollection_List< opencascade::handle< CDM_Document > >::iterator":
        return _CDM.CDM_ListOfDocument_end(self)

    def cbegin(self) -> "NCollection_List< opencascade::handle< CDM_Document > >::const_iterator":
        return _CDM.CDM_ListOfDocument_cbegin(self)

    def cend(self) -> "NCollection_List< opencascade::handle< CDM_Document > >::const_iterator":
        return _CDM.CDM_ListOfDocument_cend(self)

    def __init__(self, *args):
        _CDM.CDM_ListOfDocument_swiginit(self, _CDM.new_CDM_ListOfDocument(*args))

    def Size(self) -> "Standard_Integer":
        return _CDM.CDM_ListOfDocument_Size(self)

    def Assign(self, theOther: "CDM_ListOfDocument") -> "NCollection_List< opencascade::handle< CDM_Document > > &":
        return _CDM.CDM_ListOfDocument_Assign(self, theOther)

    def Set(self, theOther: "CDM_ListOfDocument") -> "NCollection_List< opencascade::handle< CDM_Document > > &":
        return _CDM.CDM_ListOfDocument_Set(self, theOther)

    def Clear(self, theAllocator: "opencascade::handle< NCollection_BaseAllocator > const &"=0) -> "void":
        return _CDM.CDM_ListOfDocument_Clear(self, theAllocator)

    def First(self) -> "opencascade::handle< CDM_Document > const &":
        return _CDM.CDM_ListOfDocument_First(self)

    def Last(self) -> "opencascade::handle< CDM_Document > const &":
        return _CDM.CDM_ListOfDocument_Last(self)

    def Append(self, *args) -> "void":
        return _CDM.CDM_ListOfDocument_Append(self, *args)

    def Prepend(self, *args) -> "void":
        return _CDM.CDM_ListOfDocument_Prepend(self, *args)

    def RemoveFirst(self) -> "void":
        return _CDM.CDM_ListOfDocument_RemoveFirst(self)

    def Remove(self, theIter: "CDM_ListIteratorOfListOfDocument") -> "void":
        return _CDM.CDM_ListOfDocument_Remove(self, theIter)

    def InsertBefore(self, *args) -> "void":
        return _CDM.CDM_ListOfDocument_InsertBefore(self, *args)

    def InsertAfter(self, *args) -> "void":
        return _CDM.CDM_ListOfDocument_InsertAfter(self, *args)

    def Reverse(self) -> "void":
        return _CDM.CDM_ListOfDocument_Reverse(self)
    __swig_destroy__ = _CDM.delete_CDM_ListOfDocument

    def __len__(self):
        return self.Size()


# Register CDM_ListOfDocument in _CDM:
_CDM.CDM_ListOfDocument_swigregister(CDM_ListOfDocument)

class CDM_ListOfReferences(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self) -> "NCollection_List< opencascade::handle< CDM_Reference > >::iterator":
        return _CDM.CDM_ListOfReferences_begin(self)

    def end(self) -> "NCollection_List< opencascade::handle< CDM_Reference > >::iterator":
        return _CDM.CDM_ListOfReferences_end(self)

    def cbegin(self) -> "NCollection_List< opencascade::handle< CDM_Reference > >::const_iterator":
        return _CDM.CDM_ListOfReferences_cbegin(self)

    def cend(self) -> "NCollection_List< opencascade::handle< CDM_Reference > >::const_iterator":
        return _CDM.CDM_ListOfReferences_cend(self)

    def __init__(self, *args):
        _CDM.CDM_ListOfReferences_swiginit(self, _CDM.new_CDM_ListOfReferences(*args))

    def Size(self) -> "Standard_Integer":
        return _CDM.CDM_ListOfReferences_Size(self)

    def Assign(self, theOther: "CDM_ListOfReferences") -> "NCollection_List< opencascade::handle< CDM_Reference > > &":
        return _CDM.CDM_ListOfReferences_Assign(self, theOther)

    def Set(self, theOther: "CDM_ListOfReferences") -> "NCollection_List< opencascade::handle< CDM_Reference > > &":
        return _CDM.CDM_ListOfReferences_Set(self, theOther)

    def Clear(self, theAllocator: "opencascade::handle< NCollection_BaseAllocator > const &"=0) -> "void":
        return _CDM.CDM_ListOfReferences_Clear(self, theAllocator)

    def First(self) -> "opencascade::handle< CDM_Reference > const &":
        return _CDM.CDM_ListOfReferences_First(self)

    def Last(self) -> "opencascade::handle< CDM_Reference > const &":
        return _CDM.CDM_ListOfReferences_Last(self)

    def Append(self, *args) -> "void":
        return _CDM.CDM_ListOfReferences_Append(self, *args)

    def Prepend(self, *args) -> "void":
        return _CDM.CDM_ListOfReferences_Prepend(self, *args)

    def RemoveFirst(self) -> "void":
        return _CDM.CDM_ListOfReferences_RemoveFirst(self)

    def Remove(self, theIter: "CDM_ListIteratorOfListOfReferences") -> "void":
        return _CDM.CDM_ListOfReferences_Remove(self, theIter)

    def InsertBefore(self, *args) -> "void":
        return _CDM.CDM_ListOfReferences_InsertBefore(self, *args)

    def InsertAfter(self, *args) -> "void":
        return _CDM.CDM_ListOfReferences_InsertAfter(self, *args)

    def Reverse(self) -> "void":
        return _CDM.CDM_ListOfReferences_Reverse(self)
    __swig_destroy__ = _CDM.delete_CDM_ListOfReferences

    def __len__(self):
        return self.Size()


# Register CDM_ListOfReferences in _CDM:
_CDM.CDM_ListOfReferences_swigregister(CDM_ListOfReferences)

class CDM_MapOfDocument(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def cbegin(self) -> "NCollection_Map< opencascade::handle< CDM_Document >,CDM_DocumentHasher >::const_iterator":
        return _CDM.CDM_MapOfDocument_cbegin(self)

    def cend(self) -> "NCollection_Map< opencascade::handle< CDM_Document >,CDM_DocumentHasher >::const_iterator":
        return _CDM.CDM_MapOfDocument_cend(self)

    def __init__(self, *args):
        _CDM.CDM_MapOfDocument_swiginit(self, _CDM.new_CDM_MapOfDocument(*args))

    def Exchange(self, theOther: "CDM_MapOfDocument") -> "void":
        return _CDM.CDM_MapOfDocument_Exchange(self, theOther)

    def Assign(self, theOther: "CDM_MapOfDocument") -> "NCollection_Map< opencascade::handle< CDM_Document >,CDM_DocumentHasher > &":
        return _CDM.CDM_MapOfDocument_Assign(self, theOther)

    def Set(self, theOther: "CDM_MapOfDocument") -> "NCollection_Map< opencascade::handle< CDM_Document >,CDM_DocumentHasher > &":
        return _CDM.CDM_MapOfDocument_Set(self, theOther)

    def ReSize(self, N: "Standard_Integer const") -> "void":
        return _CDM.CDM_MapOfDocument_ReSize(self, N)

    def Add(self, K: "opencascade::handle< CDM_Document > const &") -> "Standard_Boolean":
        return _CDM.CDM_MapOfDocument_Add(self, K)

    def Added(self, K: "opencascade::handle< CDM_Document > const &") -> "opencascade::handle< CDM_Document > const &":
        return _CDM.CDM_MapOfDocument_Added(self, K)

    def Remove(self, K: "opencascade::handle< CDM_Document > const &") -> "Standard_Boolean":
        return _CDM.CDM_MapOfDocument_Remove(self, K)

    def Clear(self, *args) -> "void":
        return _CDM.CDM_MapOfDocument_Clear(self, *args)
    __swig_destroy__ = _CDM.delete_CDM_MapOfDocument

    def Size(self) -> "Standard_Integer":
        return _CDM.CDM_MapOfDocument_Size(self)

    def IsEqual(self, theOther: "CDM_MapOfDocument") -> "Standard_Boolean":
        return _CDM.CDM_MapOfDocument_IsEqual(self, theOther)

    def Contains(self, *args) -> "Standard_Boolean":
        return _CDM.CDM_MapOfDocument_Contains(self, *args)

    def Union(self, theLeft: "CDM_MapOfDocument", theRight: "CDM_MapOfDocument") -> "void":
        return _CDM.CDM_MapOfDocument_Union(self, theLeft, theRight)

    def Unite(self, theOther: "CDM_MapOfDocument") -> "Standard_Boolean":
        return _CDM.CDM_MapOfDocument_Unite(self, theOther)

    def HasIntersection(self, theMap: "CDM_MapOfDocument") -> "Standard_Boolean":
        return _CDM.CDM_MapOfDocument_HasIntersection(self, theMap)

    def Intersection(self, theLeft: "CDM_MapOfDocument", theRight: "CDM_MapOfDocument") -> "void":
        return _CDM.CDM_MapOfDocument_Intersection(self, theLeft, theRight)

    def Intersect(self, theOther: "CDM_MapOfDocument") -> "Standard_Boolean":
        return _CDM.CDM_MapOfDocument_Intersect(self, theOther)

    def Subtraction(self, theLeft: "CDM_MapOfDocument", theRight: "CDM_MapOfDocument") -> "void":
        return _CDM.CDM_MapOfDocument_Subtraction(self, theLeft, theRight)

    def Subtract(self, theOther: "CDM_MapOfDocument") -> "Standard_Boolean":
        return _CDM.CDM_MapOfDocument_Subtract(self, theOther)

    def Difference(self, theLeft: "CDM_MapOfDocument", theRight: "CDM_MapOfDocument") -> "void":
        return _CDM.CDM_MapOfDocument_Difference(self, theLeft, theRight)

    def Differ(self, theOther: "CDM_MapOfDocument") -> "Standard_Boolean":
        return _CDM.CDM_MapOfDocument_Differ(self, theOther)

# Register CDM_MapOfDocument in _CDM:
_CDM.CDM_MapOfDocument_swigregister(CDM_MapOfDocument)

class CDM_MetaDataLookUpTable(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self) -> "NCollection_DataMap< TCollection_ExtendedString,opencascade::handle< CDM_MetaData >,TCollection_ExtendedString >::iterator":
        return _CDM.CDM_MetaDataLookUpTable_begin(self)

    def end(self) -> "NCollection_DataMap< TCollection_ExtendedString,opencascade::handle< CDM_MetaData >,TCollection_ExtendedString >::iterator":
        return _CDM.CDM_MetaDataLookUpTable_end(self)

    def cbegin(self) -> "NCollection_DataMap< TCollection_ExtendedString,opencascade::handle< CDM_MetaData >,TCollection_ExtendedString >::const_iterator":
        return _CDM.CDM_MetaDataLookUpTable_cbegin(self)

    def cend(self) -> "NCollection_DataMap< TCollection_ExtendedString,opencascade::handle< CDM_MetaData >,TCollection_ExtendedString >::const_iterator":
        return _CDM.CDM_MetaDataLookUpTable_cend(self)

    def __init__(self, *args):
        _CDM.CDM_MetaDataLookUpTable_swiginit(self, _CDM.new_CDM_MetaDataLookUpTable(*args))

    def Exchange(self, theOther: "CDM_MetaDataLookUpTable") -> "void":
        return _CDM.CDM_MetaDataLookUpTable_Exchange(self, theOther)

    def Assign(self, theOther: "CDM_MetaDataLookUpTable") -> "NCollection_DataMap< TCollection_ExtendedString,opencascade::handle< CDM_MetaData >,TCollection_ExtendedString > &":
        return _CDM.CDM_MetaDataLookUpTable_Assign(self, theOther)

    def Set(self, theOther: "CDM_MetaDataLookUpTable") -> "NCollection_DataMap< TCollection_ExtendedString,opencascade::handle< CDM_MetaData >,TCollection_ExtendedString > &":
        return _CDM.CDM_MetaDataLookUpTable_Set(self, theOther)

    def ReSize(self, N: "Standard_Integer const") -> "void":
        return _CDM.CDM_MetaDataLookUpTable_ReSize(self, N)

    def Bind(self, theKey: "TCollection_ExtendedString", theItem: "opencascade::handle< CDM_MetaData > const &") -> "Standard_Boolean":
        return _CDM.CDM_MetaDataLookUpTable_Bind(self, theKey, theItem)

    def Bound(self, theKey: "TCollection_ExtendedString", theItem: "opencascade::handle< CDM_MetaData > const &") -> "opencascade::handle< CDM_MetaData > *":
        return _CDM.CDM_MetaDataLookUpTable_Bound(self, theKey, theItem)

    def IsBound(self, theKey: "TCollection_ExtendedString") -> "Standard_Boolean":
        return _CDM.CDM_MetaDataLookUpTable_IsBound(self, theKey)

    def UnBind(self, theKey: "TCollection_ExtendedString") -> "Standard_Boolean":
        return _CDM.CDM_MetaDataLookUpTable_UnBind(self, theKey)

    def Seek(self, theKey: "TCollection_ExtendedString") -> "opencascade::handle< CDM_MetaData > const *":
        return _CDM.CDM_MetaDataLookUpTable_Seek(self, theKey)

    def Find(self, *args) -> "Standard_Boolean":
        return _CDM.CDM_MetaDataLookUpTable_Find(self, *args)

    def ChangeSeek(self, theKey: "TCollection_ExtendedString") -> "opencascade::handle< CDM_MetaData > *":
        return _CDM.CDM_MetaDataLookUpTable_ChangeSeek(self, theKey)

    def ChangeFind(self, theKey: "TCollection_ExtendedString") -> "opencascade::handle< CDM_MetaData > &":
        return _CDM.CDM_MetaDataLookUpTable_ChangeFind(self, theKey)

    def __call__(self, *args) -> "opencascade::handle< CDM_MetaData > &":
        return _CDM.CDM_MetaDataLookUpTable___call__(self, *args)

    def Clear(self, *args) -> "void":
        return _CDM.CDM_MetaDataLookUpTable_Clear(self, *args)
    __swig_destroy__ = _CDM.delete_CDM_MetaDataLookUpTable

    def Size(self) -> "Standard_Integer":
        return _CDM.CDM_MetaDataLookUpTable_Size(self)

# Register CDM_MetaDataLookUpTable in _CDM:
_CDM.CDM_MetaDataLookUpTable_swigregister(CDM_MetaDataLookUpTable)

class CDM_Application(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def BeginOfUpdate(self, *args) -> "void":
        r"""
        This method is called before the update of a document. by default, writes in messagedriver().

        Parameters
        ----------
        aDocument: CDM_Document

        Returns
        -------
        None

        """
        return _CDM.CDM_Application_BeginOfUpdate(self, *args)

    def DumpJsonToString(self, depth: "int"=-1) -> "std::string":
        r"""DumpJsonToString(CDM_Application self, int depth=-1) -> std::string"""
        return _CDM.CDM_Application_DumpJsonToString(self, depth)

    def EndOfUpdate(self, *args) -> "void":
        r"""
        This method is called affter the update of a document. by default, writes in messagedriver().

        Parameters
        ----------
        aDocument: CDM_Document
        theStatus: bool
        ErrorString: TCollection_ExtendedString

        Returns
        -------
        None

        """
        return _CDM.CDM_Application_EndOfUpdate(self, *args)

    def MessageDriver(self, *args) -> "opencascade::handle< Message_Messenger >":
        r"""
        Returns default messenger;.

        Returns
        -------
        opencascade::handle<Message_Messenger>

        """
        return _CDM.CDM_Application_MessageDriver(self, *args)

    def MetaDataLookUpTable(self, *args) -> "CDM_MetaDataLookUpTable &":
        r"""
        Returns metadata lookuptable.

        Returns
        -------
        CDM_MetaDataLookUpTable

        """
        return _CDM.CDM_Application_MetaDataLookUpTable(self, *args)

    def Name(self, *args) -> "TCollection_ExtendedString":
        r"""
        Returns the application name.

        Returns
        -------
        TCollection_ExtendedString

        """
        return _CDM.CDM_Application_Name(self, *args)

    def Resources(self, *args) -> "opencascade::handle< Resource_Manager >":
        r"""
        The manager returned by this virtual method will be used to search for format.retrieval resource items.

        Returns
        -------
        opencascade::handle<Resource_Manager>

        """
        return _CDM.CDM_Application_Resources(self, *args)

    def Version(self, *args) -> "TCollection_AsciiString":
        r"""
        Returns the application version.

        Returns
        -------
        TCollection_AsciiString

        """
        return _CDM.CDM_Application_Version(self, *args)

    def Write(self, *args) -> "void":
        r"""
        Writes the string in the application messagerdriver.

        Parameters
        ----------
        aString: Standard_ExtString

        Returns
        -------
        None

        """
        return _CDM.CDM_Application_Write(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_CDM_Application_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _CDM.delete_CDM_Application

# Register CDM_Application in _CDM:
_CDM.CDM_Application_swigregister(CDM_Application)

class CDM_Document(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def AddComment(self, *args) -> "void":
        r"""
        Appends a comment into comments of this document.

        Parameters
        ----------
        aComment: TCollection_ExtendedString

        Returns
        -------
        None

        """
        return _CDM.CDM_Document_AddComment(self, *args)

    def Application(self, *args) -> "opencascade::handle< CDM_Application > const &":
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<CDM_Application>

        """
        return _CDM.CDM_Document_Application(self, *args)

    def CanClose(self, *args) -> "CDM_CanCloseStatus":
        r"""
        No available documentation.

        Returns
        -------
        CDM_CanCloseStatus

        """
        return _CDM.CDM_Document_CanClose(self, *args)

    def CanCloseReference(self, *args) -> "Standard_Boolean":
        r"""
        A referenced document may indicate through this virtual method that it does not allow the closing of adocument which it references through the reference areferenceidentifier. by default returns standard_true.

        Parameters
        ----------
        aDocument: CDM_Document
        aReferenceIdentifier: int

        Returns
        -------
        bool

        """
        return _CDM.CDM_Document_CanCloseReference(self, *args)

    def Close(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _CDM.CDM_Document_Close(self, *args)

    def CloseReference(self, *args) -> "void":
        r"""
        A referenced document may update its internal data structure when {adocument} which it references through the reference {areferenceidentifier} is being closed. by default this method does nothing.

        Parameters
        ----------
        aDocument: CDM_Document
        aReferenceIdentifier: int

        Returns
        -------
        None

        """
        return _CDM.CDM_Document_CloseReference(self, *args)

    def Comment(self, *args) -> "Standard_ExtString":
        r"""
        Returns the first of associated comments. by default the comment is an empty string.

        Returns
        -------
        Standard_ExtString

        """
        return _CDM.CDM_Document_Comment(self, *args)

    def Comments(self, *args) -> "void":
        r"""
        Returns the associated comments through <acomments>. returns empty sequence if no comments are associated.

        Parameters
        ----------
        aComments: TColStd_SequenceOfExtendedString

        Returns
        -------
        None

        """
        return _CDM.CDM_Document_Comments(self, *args)

    def CopyReference(self, *args) -> "Standard_Integer":
        r"""
        Copies a reference to this document. this method avoid retrieval of referenced document. the arguments are the original document and a valid reference identifier returns the local identifier.

        Parameters
        ----------
        aFromDocument: CDM_Document
        aReferenceIdentifier: int

        Returns
        -------
        int

        """
        return _CDM.CDM_Document_CopyReference(self, *args)

    def CreateReference(self, *args) -> "Standard_Integer":
        r"""
        Creates a reference from this document to {anotherdocument}. returns a reference identifier. this reference identifier is unique in the document and will not be used for the next references, even after the storing of the document. if there is already a reference between the two documents, the reference is not created, but its reference identifier is returned.

        Parameters
        ----------
        anOtherDocument: CDM_Document

        Returns
        -------
        int
        No available documentation.

        Parameters
        ----------
        aMetaData: CDM_MetaData
        aReferenceIdentifier: int
        anApplication: CDM_Application
        aToDocumentVersion: int
        UseStorageConfiguration: bool

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        aMetaData: CDM_MetaData
        anApplication: CDM_Application
        aDocumentVersion: int
        UseStorageConfiguration: bool

        Returns
        -------
        int

        """
        return _CDM.CDM_Document_CreateReference(self, *args)

    def DeepReferences(self, *args) -> "Standard_Boolean":
        r"""
        Returns true is this document references adocument;.

        Parameters
        ----------
        aDocument: CDM_Document

        Returns
        -------
        bool

        """
        return _CDM.CDM_Document_DeepReferences(self, *args)

    def Description(self, *args) -> "TCollection_ExtendedString":
        r"""
        Gets the `fileformat`.description resource.

        Returns
        -------
        TCollection_ExtendedString

        """
        return _CDM.CDM_Document_Description(self, *args)

    def Document(self, *args) -> "opencascade::handle< CDM_Document >":
        r"""
        Returns the to document of the reference identified by areferenceidentifier. if the todocument is stored and has not yet been retrieved, this method will retrieve it.

        Parameters
        ----------
        aReferenceIdentifier: int

        Returns
        -------
        opencascade::handle<CDM_Document>

        """
        return _CDM.CDM_Document_Document(self, *args)

    def DumpJsonToString(self, depth: "int"=-1) -> "std::string":
        r"""DumpJsonToString(CDM_Document self, int depth=-1) -> std::string"""
        return _CDM.CDM_Document_DumpJsonToString(self, depth)

    def Extensions(self, *args) -> "void":
        r"""
        By default empties the extensions.

        Parameters
        ----------
        Extensions: TColStd_SequenceOfExtendedString

        Returns
        -------
        None

        """
        return _CDM.CDM_Document_Extensions(self, *args)

    def FileExtension(self, *args) -> "TCollection_ExtendedString":
        r"""
        Gets the desktop.domain.application.`fileformat`.fileextension resource.

        Returns
        -------
        TCollection_ExtendedString

        """
        return _CDM.CDM_Document_FileExtension(self, *args)

    def FindDescription(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _CDM.CDM_Document_FindDescription(self, *args)

    def FindFileExtension(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _CDM.CDM_Document_FindFileExtension(self, *args)

    def Folder(self, *args) -> "TCollection_ExtendedString":
        r"""
        No available documentation.

        Returns
        -------
        TCollection_ExtendedString

        """
        return _CDM.CDM_Document_Folder(self, *args)

    def FromReferencesNumber(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of references having this document as to document.

        Returns
        -------
        int

        """
        return _CDM.CDM_Document_FromReferencesNumber(self, *args)

    def GetAlternativeDocument(self, *args) -> "Standard_Boolean":
        r"""
        This method can be redefined to extract another document in a different format. for example, to extract a shape from an applicative document.

        Parameters
        ----------
        aFormat: TCollection_ExtendedString
        anAlternativeDocument: CDM_Document

        Returns
        -------
        bool

        """
        return _CDM.CDM_Document_GetAlternativeDocument(self, *args)

    def HasRequestedFolder(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _CDM.CDM_Document_HasRequestedFolder(self, *args)

    def HasRequestedPreviousVersion(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _CDM.CDM_Document_HasRequestedPreviousVersion(self, *args)

    def IsInSession(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the to document of the reference identified by areferenceidentifier is in session, false if it corresponds to a not yet retrieved document.

        Parameters
        ----------
        aReferenceIdentifier: int

        Returns
        -------
        bool

        """
        return _CDM.CDM_Document_IsInSession(self, *args)

    def IsModified(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the version is greater than the storage version.

        Returns
        -------
        bool

        """
        return _CDM.CDM_Document_IsModified(self, *args)

    def IsOpened(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Returns
        -------
        bool
        Returns true if the document corresponding to the given reference has been retrieved and opened. otherwise returns false. this method does not retrieve the referenced document.

        Parameters
        ----------
        aReferenceIdentifier: int

        Returns
        -------
        bool

        """
        return _CDM.CDM_Document_IsOpened(self, *args)

    def IsReadOnly(self, *args) -> "Standard_Boolean":
        r"""
        Indicates that this document cannot be modified.

        Returns
        -------
        bool
        Indicates that the referenced document cannot be modified,.

        Parameters
        ----------
        aReferenceIdentifier: int

        Returns
        -------
        bool

        """
        return _CDM.CDM_Document_IsReadOnly(self, *args)

    def IsStored(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the to document of the reference identified by areferenceidentifier has already been stored, false otherwise.

        Parameters
        ----------
        aReferenceIdentifier: int

        Returns
        -------
        bool
        No available documentation.

        Returns
        -------
        bool

        """
        return _CDM.CDM_Document_IsStored(self, *args)

    def IsUpToDate(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the modification counter found in the given reference is equal to the actual modification counter of the to document. this method is able to deal with a reference to a not retrieved document.

        Parameters
        ----------
        aReferenceIdentifier: int

        Returns
        -------
        bool

        """
        return _CDM.CDM_Document_IsUpToDate(self, *args)

    def LoadResources(self, *args) -> "void":
        r"""
        Read (or rereads) the following resource.

        Returns
        -------
        None

        """
        return _CDM.CDM_Document_LoadResources(self, *args)

    def MetaData(self, *args) -> "opencascade::handle< CDM_MetaData >":
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<CDM_MetaData>

        """
        return _CDM.CDM_Document_MetaData(self, *args)

    def Modifications(self, *args) -> "Standard_Integer":
        r"""
        Returns the current modification counter.

        Returns
        -------
        int

        """
        return _CDM.CDM_Document_Modifications(self, *args)

    def Modify(self, *args) -> "void":
        r"""
        Indicates that this document has been modified. this method increments the modification counter.

        Returns
        -------
        None

        """
        return _CDM.CDM_Document_Modify(self, *args)

    def Name(self, *args) -> "TCollection_ExtendedString":
        r"""
        Returns the name of the metadata of the to document of the reference identified by areferenceidentifier.

        Parameters
        ----------
        aReferenceIdentifier: int

        Returns
        -------
        TCollection_ExtendedString

        """
        return _CDM.CDM_Document_Name(self, *args)

    def Open(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        anApplication: CDM_Application

        Returns
        -------
        None

        """
        return _CDM.CDM_Document_Open(self, *args)

    def PrintToString(self) -> "std::string":
        r"""PrintToString(CDM_Document self) -> std::string"""
        return _CDM.CDM_Document_PrintToString(self)

    def Reference(self, *args) -> "opencascade::handle< CDM_Reference >":
        r"""
        No available documentation.

        Parameters
        ----------
        aReferenceIdentifier: int

        Returns
        -------
        opencascade::handle<CDM_Reference>

        """
        return _CDM.CDM_Document_Reference(self, *args)

    def ReferenceCounter(self, *args) -> "Standard_Integer":
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _CDM.CDM_Document_ReferenceCounter(self, *args)

    def RemoveAllReferences(self, *args) -> "void":
        r"""
        Removes all references having this document for from document.

        Returns
        -------
        None

        """
        return _CDM.CDM_Document_RemoveAllReferences(self, *args)

    def RemoveReference(self, *args) -> "void":
        r"""
        Removes the reference between the from document and the to document identified by a reference identifier.

        Parameters
        ----------
        aReferenceIdentifier: int

        Returns
        -------
        None

        """
        return _CDM.CDM_Document_RemoveReference(self, *args)

    def RequestedComment(self, *args) -> "TCollection_ExtendedString":
        r"""
        No available documentation.

        Returns
        -------
        TCollection_ExtendedString

        """
        return _CDM.CDM_Document_RequestedComment(self, *args)

    def RequestedFolder(self, *args) -> "TCollection_ExtendedString":
        r"""
        No available documentation.

        Returns
        -------
        TCollection_ExtendedString

        """
        return _CDM.CDM_Document_RequestedFolder(self, *args)

    def RequestedName(self, *args) -> "TCollection_ExtendedString":
        r"""
        Determines under which the document is going to be store. by default the name of the document will be used. if the document has no name its presentation will be used.

        Returns
        -------
        TCollection_ExtendedString

        """
        return _CDM.CDM_Document_RequestedName(self, *args)

    def RequestedPreviousVersion(self, *args) -> "TCollection_ExtendedString":
        r"""
        No available documentation.

        Returns
        -------
        TCollection_ExtendedString

        """
        return _CDM.CDM_Document_RequestedPreviousVersion(self, *args)

    def SetComment(self, *args) -> "void":
        r"""
        Associates a comment with this document.

        Parameters
        ----------
        aComment: TCollection_ExtendedString

        Returns
        -------
        None

        """
        return _CDM.CDM_Document_SetComment(self, *args)

    def SetComments(self, *args) -> "void":
        r"""
        Associates a comments with this document.

        Parameters
        ----------
        aComments: TColStd_SequenceOfExtendedString

        Returns
        -------
        None

        """
        return _CDM.CDM_Document_SetComments(self, *args)

    def SetIsReadOnly(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _CDM.CDM_Document_SetIsReadOnly(self, *args)

    def SetIsUpToDate(self, *args) -> "void":
        r"""
        Resets the modification counter in the given reference to the actual modification counter of its to document. this method should be called after the application has updated this document.

        Parameters
        ----------
        aReferenceIdentifier: int

        Returns
        -------
        None

        """
        return _CDM.CDM_Document_SetIsUpToDate(self, *args)

    def SetMetaData(self, *args) -> "void":
        r"""
        Associates database information to a document which has been stored. the name of the document is now the name which has beenused to store the data.

        Parameters
        ----------
        aMetaData: CDM_MetaData

        Returns
        -------
        None

        """
        return _CDM.CDM_Document_SetMetaData(self, *args)

    def SetModifications(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Modifications: int

        Returns
        -------
        None

        """
        return _CDM.CDM_Document_SetModifications(self, *args)

    def SetReferenceCounter(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        aReferenceCounter: int

        Returns
        -------
        None

        """
        return _CDM.CDM_Document_SetReferenceCounter(self, *args)

    def SetRequestedComment(self, *args) -> "void":
        r"""
        Defines the comment with which the object should be stored.

        Parameters
        ----------
        aComment: TCollection_ExtendedString

        Returns
        -------
        None

        """
        return _CDM.CDM_Document_SetRequestedComment(self, *args)

    def SetRequestedFolder(self, *args) -> "void":
        r"""
        Defines the folder in which the object should be stored.

        Parameters
        ----------
        aFolder: TCollection_ExtendedString

        Returns
        -------
        None

        """
        return _CDM.CDM_Document_SetRequestedFolder(self, *args)

    def SetRequestedName(self, *args) -> "void":
        r"""
        Defines the name under which the object should be stored.

        Parameters
        ----------
        aName: TCollection_ExtendedString

        Returns
        -------
        None

        """
        return _CDM.CDM_Document_SetRequestedName(self, *args)

    def SetRequestedPreviousVersion(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        aPreviousVersion: TCollection_ExtendedString

        Returns
        -------
        None

        """
        return _CDM.CDM_Document_SetRequestedPreviousVersion(self, *args)

    def ShallowReferences(self, *args) -> "Standard_Boolean":
        r"""
        Returns true is this document references adocument;.

        Parameters
        ----------
        aDocument: CDM_Document

        Returns
        -------
        bool

        """
        return _CDM.CDM_Document_ShallowReferences(self, *args)

    def StorageFormat(self, *args) -> "TCollection_ExtendedString":
        r"""
        The storage format is the key which is used to determine in the application resources the storage driver plugin, the file extension and other data used to store the document.

        Returns
        -------
        TCollection_ExtendedString

        """
        return _CDM.CDM_Document_StorageFormat(self, *args)

    def StorageVersion(self, *args) -> "Standard_Integer":
        r"""
        Returns the value of the modification counter at the time of storage. by default returns 0.

        Returns
        -------
        int

        """
        return _CDM.CDM_Document_StorageVersion(self, *args)

    def ToReferencesNumber(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of references having this document as from document.

        Returns
        -------
        int

        """
        return _CDM.CDM_Document_ToReferencesNumber(self, *args)

    def UnModify(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _CDM.CDM_Document_UnModify(self, *args)

    def UnsetIsReadOnly(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _CDM.CDM_Document_UnsetIsReadOnly(self, *args)

    def UnsetIsStored(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _CDM.CDM_Document_UnsetIsStored(self, *args)

    def UnsetRequestedPreviousVersion(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _CDM.CDM_Document_UnsetRequestedPreviousVersion(self, *args)

    def Update(self, *args) -> "void":
        r"""
        The update method will be called once for each reference, but it should not perform any computation, to avoid multiple computation of a same document.

        Parameters
        ----------
        aToDocument: CDM_Document
        aReferenceIdentifier: int
        aModifContext: Standard_Address

        Returns
        -------
        None
        This method update will be called to signal the end of the modified references list. the document should be recomputed and updatefromdocuments should be called. update should returns true in case of success, false otherwise. in case of failure, additional information can be given in errorstring.

        Parameters
        ----------
        ErrorString: TCollection_ExtendedString

        Returns
        -------
        bool
        The following method should be used instead: //! update(me:mutable; errorstring: out extendedstring from tcollection) returns boolean from standard.

        Returns
        -------
        None

        """
        return _CDM.CDM_Document_Update(self, *args)

    def UpdateFromDocuments(self, *args) -> "void":
        r"""
        Call virtual method update on all referencing documents. this method keeps the list of the -- documents to process.it may be the starting of an update -- cycle. if not, the reentrant calls made by update method (without argument) will append the referencing documents to the list and call the update method (with arguments). only the first call to updatefromdocuments generate call to update().

        Parameters
        ----------
        aModifContext: Standard_Address

        Returns
        -------
        None

        """
        return _CDM.CDM_Document_UpdateFromDocuments(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_CDM_Document_DownCast(t)


    __repr__ = _dumps_object


# Register CDM_Document in _CDM:
_CDM.CDM_Document_swigregister(CDM_Document)

class CDM_MetaData(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Document(self, *args) -> "opencascade::handle< CDM_Document >":
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<CDM_Document>

        """
        return _CDM.CDM_MetaData_Document(self, *args)

    def DumpJsonToString(self, depth: "int"=-1) -> "std::string":
        r"""DumpJsonToString(CDM_MetaData self, int depth=-1) -> std::string"""
        return _CDM.CDM_MetaData_DumpJsonToString(self, depth)

    def FileName(self, *args) -> "TCollection_ExtendedString":
        r"""
        No available documentation.

        Returns
        -------
        TCollection_ExtendedString

        """
        return _CDM.CDM_MetaData_FileName(self, *args)

    def Folder(self, *args) -> "TCollection_ExtendedString":
        r"""
        Returns the folder in which the meta-data has to be created or has to be found.

        Returns
        -------
        TCollection_ExtendedString

        """
        return _CDM.CDM_MetaData_Folder(self, *args)

    def HasVersion(self, *args) -> "Standard_Boolean":
        r"""
        Indicates that the version has to be taken into account when searching the corresponding meta-data.

        Returns
        -------
        bool

        """
        return _CDM.CDM_MetaData_HasVersion(self, *args)

    def IsReadOnly(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _CDM.CDM_MetaData_IsReadOnly(self, *args)

    def IsRetrieved(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _CDM.CDM_MetaData_IsRetrieved(self, *args)

    @staticmethod
    def LookUp(*args) -> "opencascade::handle< CDM_MetaData >":
        r"""
        No available documentation.

        Parameters
        ----------
        theLookUpTable: CDM_MetaDataLookUpTable
        aFolder: TCollection_ExtendedString
        aName: TCollection_ExtendedString
        aPath: TCollection_ExtendedString
        aFileName: TCollection_ExtendedString
        ReadOnly: bool

        Returns
        -------
        opencascade::handle<CDM_MetaData>
        No available documentation.

        Parameters
        ----------
        theLookUpTable: CDM_MetaDataLookUpTable
        aFolder: TCollection_ExtendedString
        aName: TCollection_ExtendedString
        aPath: TCollection_ExtendedString
        aVersion: TCollection_ExtendedString
        aFileName: TCollection_ExtendedString
        ReadOnly: bool

        Returns
        -------
        opencascade::handle<CDM_MetaData>

        """
        return _CDM.CDM_MetaData_LookUp(*args)

    def Name(self, *args) -> "TCollection_ExtendedString":
        r"""
        Returns the name under which the meta-data has to be created or has to be found.

        Returns
        -------
        TCollection_ExtendedString

        """
        return _CDM.CDM_MetaData_Name(self, *args)

    def Path(self, *args) -> "TCollection_ExtendedString":
        r"""
        No available documentation.

        Returns
        -------
        TCollection_ExtendedString

        """
        return _CDM.CDM_MetaData_Path(self, *args)

    def PrintToString(self) -> "std::string":
        r"""PrintToString(CDM_MetaData self) -> std::string"""
        return _CDM.CDM_MetaData_PrintToString(self)

    def SetIsReadOnly(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _CDM.CDM_MetaData_SetIsReadOnly(self, *args)

    def UnsetDocument(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _CDM.CDM_MetaData_UnsetDocument(self, *args)

    def UnsetIsReadOnly(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _CDM.CDM_MetaData_UnsetIsReadOnly(self, *args)

    def Version(self, *args) -> "TCollection_ExtendedString":
        r"""
        Returns the version under which the meta-data has to be found. warning: raises nosuchobject from standard if no version has been defined.

        Returns
        -------
        TCollection_ExtendedString

        """
        return _CDM.CDM_MetaData_Version(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_CDM_MetaData_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _CDM.delete_CDM_MetaData

# Register CDM_MetaData in _CDM:
_CDM.CDM_MetaData_swigregister(CDM_MetaData)

def CDM_MetaData_LookUp(*args) -> "opencascade::handle< CDM_MetaData >":
    r"""
    No available documentation.

    Parameters
    ----------
    theLookUpTable: CDM_MetaDataLookUpTable
    aFolder: TCollection_ExtendedString
    aName: TCollection_ExtendedString
    aPath: TCollection_ExtendedString
    aFileName: TCollection_ExtendedString
    ReadOnly: bool

    Returns
    -------
    opencascade::handle<CDM_MetaData>
    No available documentation.

    Parameters
    ----------
    theLookUpTable: CDM_MetaDataLookUpTable
    aFolder: TCollection_ExtendedString
    aName: TCollection_ExtendedString
    aPath: TCollection_ExtendedString
    aVersion: TCollection_ExtendedString
    aFileName: TCollection_ExtendedString
    ReadOnly: bool

    Returns
    -------
    opencascade::handle<CDM_MetaData>

    """
    return _CDM.CDM_MetaData_LookUp(*args)

class CDM_Reference(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def DocumentVersion(self, *args) -> "Standard_Integer":
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _CDM.CDM_Reference_DocumentVersion(self, *args)

    def DumpJsonToString(self, depth: "int"=-1) -> "std::string":
        r"""DumpJsonToString(CDM_Reference self, int depth=-1) -> std::string"""
        return _CDM.CDM_Reference_DumpJsonToString(self, depth)

    def FromDocument(self, *args) -> "opencascade::handle< CDM_Document >":
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<CDM_Document>

        """
        return _CDM.CDM_Reference_FromDocument(self, *args)

    def IsReadOnly(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _CDM.CDM_Reference_IsReadOnly(self, *args)

    def ReferenceIdentifier(self, *args) -> "Standard_Integer":
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _CDM.CDM_Reference_ReferenceIdentifier(self, *args)

    def ToDocument(self, *args) -> "opencascade::handle< CDM_Document >":
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<CDM_Document>

        """
        return _CDM.CDM_Reference_ToDocument(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_CDM_Reference_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _CDM.delete_CDM_Reference

# Register CDM_Reference in _CDM:
_CDM.CDM_Reference_swigregister(CDM_Reference)

class CDM_ReferenceIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        aDocument: CDM_Document

        Returns
        -------
        None

        """
        _CDM.CDM_ReferenceIterator_swiginit(self, _CDM.new_CDM_ReferenceIterator(*args))

    def Document(self, *args) -> "opencascade::handle< CDM_Document >":
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<CDM_Document>

        """
        return _CDM.CDM_ReferenceIterator_Document(self, *args)

    def DocumentVersion(self, *args) -> "Standard_Integer":
        r"""
        Returns the document version in the reference.

        Returns
        -------
        int

        """
        return _CDM.CDM_ReferenceIterator_DocumentVersion(self, *args)

    def More(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _CDM.CDM_ReferenceIterator_More(self, *args)

    def Next(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _CDM.CDM_ReferenceIterator_Next(self, *args)

    def ReferenceIdentifier(self, *args) -> "Standard_Integer":
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _CDM.CDM_ReferenceIterator_ReferenceIdentifier(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _CDM.delete_CDM_ReferenceIterator

# Register CDM_ReferenceIterator in _CDM:
_CDM.CDM_ReferenceIterator_swigregister(CDM_ReferenceIterator)


CDM_NamesDirectory=OCC.Core.TColStd.TColStd_DataMapOfStringInteger



