// ----------------------------------------------------------------------------
//
//  Copyright (C) 2008-2018 Fons Adriaensen <fons@linuxaudio.org>
//    
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// ----------------------------------------------------------------------------


#include <math.h>
#include <string.h>
#include "jgainctl.h"


Jgainctl::Jgainctl (const char *client_name, const char *server_name, int nchan) :
    _fader (0)
{
    if (nchan < 0) nchan = 0;
    if (nchan > MAXCHAN) nchan = MAXCHAN;
    if (   open_jack (client_name, server_name, nchan, nchan)
        || create_inp_ports ("in_%d")
        || create_out_ports ("out_%d"))	_state = FAILED;
    else
    {
	_fader = new Fader2 (nchan, _jack_rate);
	_state = PROCESS;
    }
}


Jgainctl::~Jgainctl (void)
{
    _state = INITIAL;
    close_jack ();
    delete _fader;
}


int Jgainctl::jack_process (int nframes)
{
    float  *inp [MAXCHAN];
    float  *out [MAXCHAN];
    int    i;
    
    if (_state < PROCESS) return 0;
    for (i = 0; i < _ninp; i++)
    {
        inp [i] = (float *) jack_port_get_buffer (_inp_ports [i], nframes);
        out [i] = (float *) jack_port_get_buffer (_out_ports [i], nframes);
    }
    _fader->process (nframes, inp, out);
    return 0;
}

