// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from stm32g491.svd, see https://github.com/tinygo-org/stm32-svd

//go:build stm32 && stm32g491xx
// +build stm32,stm32g491xx

// STM32G491xx
//

package stm32

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "STM32G491xx"
	CPU          = "CM4"
	FPUPresent   = true
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	IRQ_WWDG = 0

	// External interrupt/event controller
	IRQ_PVD_PVM = 1

	// Real-time clock
	IRQ_RTC_TAMP_CSS_LSE = 2

	// Real-time clock
	IRQ_RTC_WKUP = 3

	// Flash
	IRQ_FLASH = 4

	// Reset and clock control
	IRQ_RCC = 5

	// External interrupt/event controller
	IRQ_EXTI0 = 6

	// External interrupt/event controller
	IRQ_EXTI1 = 7

	// External interrupt/event controller
	IRQ_EXTI2 = 8

	// External interrupt/event controller
	IRQ_EXTI3 = 9

	// External interrupt/event controller
	IRQ_EXTI4 = 10

	// DMA controller
	IRQ_DMA1_CH1 = 11

	// DMA controller
	IRQ_DMA1_CH2 = 12

	// DMA controller
	IRQ_DMA1_CH3 = 13

	// DMA controller
	IRQ_DMA1_CH4 = 14

	// DMA controller
	IRQ_DMA1_CH5 = 15

	// DMA controller
	IRQ_DMA1_CH6 = 16

	// Analog-to-Digital Converter
	IRQ_ADC1_2 = 18

	// External interrupt/event controller
	IRQ_USB_HP = 19

	// External interrupt/event controller
	IRQ_USB_LP = 20

	// External interrupt/event controller
	IRQ_fdcan1_intr1_it = 21

	// External interrupt/event controller
	IRQ_fdcan1_intr0_it = 22

	// External interrupt/event controller
	IRQ_EXTI9_5 = 23

	// Advanced-timers
	IRQ_TIM1_BRK_TIM15 = 24

	// Advanced-timers
	IRQ_TIM1_UP_TIM16 = 25

	// Advanced-timers
	IRQ_TIM1_TRG_COM = 26

	// Advanced-timers
	IRQ_TIM1_CC = 27

	// Advanced-timers
	IRQ_TIM2 = 28

	// Advanced-timers
	IRQ_TIM3 = 29

	IRQ_TIM4 = 30

	// Inter-integrated circuit
	IRQ_I2C1_EV = 31

	// Inter-integrated circuit
	IRQ_I2C1_ER = 32

	IRQ_I2C2_EV = 33

	IRQ_I2C2_ER = 34

	// Serial peripheral interface/Inter-IC sound
	IRQ_SPI1 = 35

	IRQ_SPI2 = 36

	// Universal synchronous asynchronous receiver transmitter
	IRQ_USART1 = 37

	IRQ_USART2 = 38

	IRQ_USART3 = 39

	// External interrupt/event controller
	IRQ_EXTI15_10 = 40

	// Real-time clock
	IRQ_RTC_ALARM = 41

	// External interrupt/event controller
	IRQ_USBWakeUP = 42

	IRQ_TIM8_BRK = 43

	IRQ_TIM8_UP = 44

	IRQ_TIM8_TRG_COM = 45

	// Advanced-timers
	IRQ_TIM8_CC = 46

	// Analog-to-Digital Converter
	IRQ_ADC3 = 47

	// Universal synchronous asynchronous receiver transmitter
	IRQ_LPTIM1 = 49

	IRQ_SPI3 = 51

	// Universal synchronous asynchronous receiver transmitter
	IRQ_UART4 = 52

	IRQ_UART5 = 53

	// Basic-timers
	IRQ_TIM6_DACUNDER = 54

	IRQ_TIM7 = 55

	IRQ_DMA2_CH1 = 56

	IRQ_DMA2_CH2 = 57

	IRQ_DMA2_CH3 = 58

	IRQ_DMA2_CH4 = 59

	IRQ_DMA2_CH5 = 60

	// UCPD1
	IRQ_UCPD1 = 63

	// Comparator control and status register
	IRQ_COMP1_2_3 = 64

	// Comparator control and status register
	IRQ_COMP4 = 65

	// External interrupt/event controller
	IRQ_CRS = 75

	// Serial audio interface
	IRQ_SAI = 76

	// Floting point unit
	IRQ_FPU = 81

	// Random number generator
	IRQ_RNG = 90

	// Universal synchronous asynchronous receiver transmitter
	IRQ_LPUART = 91

	IRQ_I2C3_EV = 92

	IRQ_I2C3_ER = 93

	// DMAMUX
	IRQ_DMAMUX_OVR = 94

	IRQ_DMA2_CH6 = 97

	// CORDIC Co-processor
	IRQ_Cordic = 100

	// Filter Math Accelerator
	IRQ_FMAC = 101

	// Highest interrupt number on this device.
	IRQ_max = 101
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export WWDG_IRQHandler
func interruptWWDG() {
	callHandlers(IRQ_WWDG)
}

//export PVD_PVM_IRQHandler
func interruptPVD_PVM() {
	callHandlers(IRQ_PVD_PVM)
}

//export RTC_TAMP_CSS_LSE_IRQHandler
func interruptRTC_TAMP_CSS_LSE() {
	callHandlers(IRQ_RTC_TAMP_CSS_LSE)
}

//export RTC_WKUP_IRQHandler
func interruptRTC_WKUP() {
	callHandlers(IRQ_RTC_WKUP)
}

//export FLASH_IRQHandler
func interruptFLASH() {
	callHandlers(IRQ_FLASH)
}

//export RCC_IRQHandler
func interruptRCC() {
	callHandlers(IRQ_RCC)
}

//export EXTI0_IRQHandler
func interruptEXTI0() {
	callHandlers(IRQ_EXTI0)
}

//export EXTI1_IRQHandler
func interruptEXTI1() {
	callHandlers(IRQ_EXTI1)
}

//export EXTI2_IRQHandler
func interruptEXTI2() {
	callHandlers(IRQ_EXTI2)
}

//export EXTI3_IRQHandler
func interruptEXTI3() {
	callHandlers(IRQ_EXTI3)
}

//export EXTI4_IRQHandler
func interruptEXTI4() {
	callHandlers(IRQ_EXTI4)
}

//export DMA1_CH1_IRQHandler
func interruptDMA1_CH1() {
	callHandlers(IRQ_DMA1_CH1)
}

//export DMA1_CH2_IRQHandler
func interruptDMA1_CH2() {
	callHandlers(IRQ_DMA1_CH2)
}

//export DMA1_CH3_IRQHandler
func interruptDMA1_CH3() {
	callHandlers(IRQ_DMA1_CH3)
}

//export DMA1_CH4_IRQHandler
func interruptDMA1_CH4() {
	callHandlers(IRQ_DMA1_CH4)
}

//export DMA1_CH5_IRQHandler
func interruptDMA1_CH5() {
	callHandlers(IRQ_DMA1_CH5)
}

//export DMA1_CH6_IRQHandler
func interruptDMA1_CH6() {
	callHandlers(IRQ_DMA1_CH6)
}

//export ADC1_2_IRQHandler
func interruptADC1_2() {
	callHandlers(IRQ_ADC1_2)
}

//export USB_HP_IRQHandler
func interruptUSB_HP() {
	callHandlers(IRQ_USB_HP)
}

//export USB_LP_IRQHandler
func interruptUSB_LP() {
	callHandlers(IRQ_USB_LP)
}

//export fdcan1_intr1_it_IRQHandler
func interruptfdcan1_intr1_it() {
	callHandlers(IRQ_fdcan1_intr1_it)
}

//export fdcan1_intr0_it_IRQHandler
func interruptfdcan1_intr0_it() {
	callHandlers(IRQ_fdcan1_intr0_it)
}

//export EXTI9_5_IRQHandler
func interruptEXTI9_5() {
	callHandlers(IRQ_EXTI9_5)
}

//export TIM1_BRK_TIM15_IRQHandler
func interruptTIM1_BRK_TIM15() {
	callHandlers(IRQ_TIM1_BRK_TIM15)
}

//export TIM1_UP_TIM16_IRQHandler
func interruptTIM1_UP_TIM16() {
	callHandlers(IRQ_TIM1_UP_TIM16)
}

//export TIM1_TRG_COM_IRQHandler
func interruptTIM1_TRG_COM() {
	callHandlers(IRQ_TIM1_TRG_COM)
}

//export TIM1_CC_IRQHandler
func interruptTIM1_CC() {
	callHandlers(IRQ_TIM1_CC)
}

//export TIM2_IRQHandler
func interruptTIM2() {
	callHandlers(IRQ_TIM2)
}

//export TIM3_IRQHandler
func interruptTIM3() {
	callHandlers(IRQ_TIM3)
}

//export TIM4_IRQHandler
func interruptTIM4() {
	callHandlers(IRQ_TIM4)
}

//export I2C1_EV_IRQHandler
func interruptI2C1_EV() {
	callHandlers(IRQ_I2C1_EV)
}

//export I2C1_ER_IRQHandler
func interruptI2C1_ER() {
	callHandlers(IRQ_I2C1_ER)
}

//export I2C2_EV_IRQHandler
func interruptI2C2_EV() {
	callHandlers(IRQ_I2C2_EV)
}

//export I2C2_ER_IRQHandler
func interruptI2C2_ER() {
	callHandlers(IRQ_I2C2_ER)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export SPI2_IRQHandler
func interruptSPI2() {
	callHandlers(IRQ_SPI2)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export USART2_IRQHandler
func interruptUSART2() {
	callHandlers(IRQ_USART2)
}

//export USART3_IRQHandler
func interruptUSART3() {
	callHandlers(IRQ_USART3)
}

//export EXTI15_10_IRQHandler
func interruptEXTI15_10() {
	callHandlers(IRQ_EXTI15_10)
}

//export RTC_ALARM_IRQHandler
func interruptRTC_ALARM() {
	callHandlers(IRQ_RTC_ALARM)
}

//export USBWakeUP_IRQHandler
func interruptUSBWakeUP() {
	callHandlers(IRQ_USBWakeUP)
}

//export TIM8_BRK_IRQHandler
func interruptTIM8_BRK() {
	callHandlers(IRQ_TIM8_BRK)
}

//export TIM8_UP_IRQHandler
func interruptTIM8_UP() {
	callHandlers(IRQ_TIM8_UP)
}

//export TIM8_TRG_COM_IRQHandler
func interruptTIM8_TRG_COM() {
	callHandlers(IRQ_TIM8_TRG_COM)
}

//export TIM8_CC_IRQHandler
func interruptTIM8_CC() {
	callHandlers(IRQ_TIM8_CC)
}

//export ADC3_IRQHandler
func interruptADC3() {
	callHandlers(IRQ_ADC3)
}

//export LPTIM1_IRQHandler
func interruptLPTIM1() {
	callHandlers(IRQ_LPTIM1)
}

//export SPI3_IRQHandler
func interruptSPI3() {
	callHandlers(IRQ_SPI3)
}

//export UART4_IRQHandler
func interruptUART4() {
	callHandlers(IRQ_UART4)
}

//export UART5_IRQHandler
func interruptUART5() {
	callHandlers(IRQ_UART5)
}

//export TIM6_DACUNDER_IRQHandler
func interruptTIM6_DACUNDER() {
	callHandlers(IRQ_TIM6_DACUNDER)
}

//export TIM7_IRQHandler
func interruptTIM7() {
	callHandlers(IRQ_TIM7)
}

//export DMA2_CH1_IRQHandler
func interruptDMA2_CH1() {
	callHandlers(IRQ_DMA2_CH1)
}

//export DMA2_CH2_IRQHandler
func interruptDMA2_CH2() {
	callHandlers(IRQ_DMA2_CH2)
}

//export DMA2_CH3_IRQHandler
func interruptDMA2_CH3() {
	callHandlers(IRQ_DMA2_CH3)
}

//export DMA2_CH4_IRQHandler
func interruptDMA2_CH4() {
	callHandlers(IRQ_DMA2_CH4)
}

//export DMA2_CH5_IRQHandler
func interruptDMA2_CH5() {
	callHandlers(IRQ_DMA2_CH5)
}

//export UCPD1_IRQHandler
func interruptUCPD1() {
	callHandlers(IRQ_UCPD1)
}

//export COMP1_2_3_IRQHandler
func interruptCOMP1_2_3() {
	callHandlers(IRQ_COMP1_2_3)
}

//export COMP4_IRQHandler
func interruptCOMP4() {
	callHandlers(IRQ_COMP4)
}

//export CRS_IRQHandler
func interruptCRS() {
	callHandlers(IRQ_CRS)
}

//export SAI_IRQHandler
func interruptSAI() {
	callHandlers(IRQ_SAI)
}

//export FPU_IRQHandler
func interruptFPU() {
	callHandlers(IRQ_FPU)
}

//export RNG_IRQHandler
func interruptRNG() {
	callHandlers(IRQ_RNG)
}

//export LPUART_IRQHandler
func interruptLPUART() {
	callHandlers(IRQ_LPUART)
}

//export I2C3_EV_IRQHandler
func interruptI2C3_EV() {
	callHandlers(IRQ_I2C3_EV)
}

//export I2C3_ER_IRQHandler
func interruptI2C3_ER() {
	callHandlers(IRQ_I2C3_ER)
}

//export DMAMUX_OVR_IRQHandler
func interruptDMAMUX_OVR() {
	callHandlers(IRQ_DMAMUX_OVR)
}

//export DMA2_CH6_IRQHandler
func interruptDMA2_CH6() {
	callHandlers(IRQ_DMA2_CH6)
}

//export Cordic_IRQHandler
func interruptCordic() {
	callHandlers(IRQ_Cordic)
}

//export FMAC_IRQHandler
func interruptFMAC() {
	callHandlers(IRQ_FMAC)
}

// Peripherals.
var (
	// Cyclic redundancy check calculation unit
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// WinWATCHDOG
	IWDG = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// System window watchdog
	WWDG = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))

	// Inter-integrated circuit
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))

	// Flash
	FLASH = (*Flash_Type)(unsafe.Pointer(uintptr(0x40022000)))

	// Debug support
	DBGMCU = (*DBGMCU_Type)(unsafe.Pointer(uintptr(0xe0042000)))

	// Reset and clock control
	RCC = (*RCC_Type)(unsafe.Pointer(uintptr(0x40021000)))

	// Power control
	PWR = (*PWR_Type)(unsafe.Pointer(uintptr(0x40007000)))

	// Random number generator
	RNG = (*RNG_Type)(unsafe.Pointer(uintptr(0x50060800)))

	// General-purpose I/Os
	GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000000)))

	// General-purpose I/Os
	GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000400)))

	// General-purpose I/Os
	GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000800)))

	// General purpose timers
	TIM15 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// General purpose timers
	TIM16 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014400)))

	// Advanced-timers
	TIM1 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40012c00)))

	// Advanced-timers
	TIM2 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Basic-timers
	TIM6 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001000)))

	// Low power timer
	LPTIMER1 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40007c00)))

	// Universal synchronous asynchronous receiver transmitter
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40013800)))

	// Universal synchronous asynchronous receiver transmitter
	UART4 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004c00)))

	// Universal synchronous asynchronous receiver transmitter
	LPUART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// Serial peripheral interface/Inter-IC sound
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))

	// External interrupt/event controller
	EXTI = (*EXTI_Type)(unsafe.Pointer(uintptr(0x40010400)))

	// Real-time clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))

	// DMA controller
	DMA1 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// DMAMUX
	DMAMUX = (*DMAMUX_Type)(unsafe.Pointer(uintptr(0x40020800)))

	// System configuration controller
	SYSCFG = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// Voltage reference buffer
	VREFBUF = (*VREFBUF_Type)(unsafe.Pointer(uintptr(0x40010030)))

	// Comparator control and status register
	COMP = (*COMP_Type)(unsafe.Pointer(uintptr(0x40010200)))

	// Operational amplifiers
	OPAMP = (*OPAMP_Type)(unsafe.Pointer(uintptr(0x40010300)))

	// Digital-to-analog converter
	DAC1 = (*DAC_Type)(unsafe.Pointer(uintptr(0x50000800)))

	// Analog-to-Digital Converter
	ADC1 = (*ADC_Type)(unsafe.Pointer(uintptr(0x50000000)))

	// Analog-to-Digital Converter
	ADC3 = (*ADC_Type)(unsafe.Pointer(uintptr(0x50000400)))

	// Analog-to-Digital Converter
	ADC12_Common = (*ADC_Type)(unsafe.Pointer(uintptr(0x50000300)))

	// Filter Math Accelerator
	FMAC = (*FMAC_Type)(unsafe.Pointer(uintptr(0x40021400)))

	// CORDIC Co-processor
	CORDIC = (*CORDIC_Type)(unsafe.Pointer(uintptr(0x40020c00)))

	// Serial audio interface
	SAI = (*SAI_Type)(unsafe.Pointer(uintptr(0x40015400)))

	// Tamper and backup registers
	TAMP = (*TAMP_Type)(unsafe.Pointer(uintptr(0x40002400)))

	// Floting point unit
	FPU = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ef34)))

	// Memory protection unit
	MPU = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000e084)))

	// SysTick timer
	STK = (*STK_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// System control block
	SCB = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// Nested vectored interrupt controller
	NVIC_STIR = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000ef00)))

	// Floating point unit CPACR
	FPU_CPACR = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ed88)))

	// System control block ACTLR
	SCB_ACTLR = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000e008)))

	// FDCAN
	FDCAN = (*FDCAN_Type)(unsafe.Pointer(uintptr(0x4000a400)))

	// FDCAN
	FDCAN1 = (*FDCAN_Type)(unsafe.Pointer(uintptr(0x40006400)))

	// UCPD1
	UCPD1 = (*UCPD_Type)(unsafe.Pointer(uintptr(0x4000a000)))

	// USB_FS_device
	USB = (*USB_Type)(unsafe.Pointer(uintptr(0x40005c00)))

	// CRS
	CRS = (*CRS_Type)(unsafe.Pointer(uintptr(0x40002000)))

	// Advanced-timers
	TIM3 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000400)))

	// Inter-integrated circuit
	I2C2 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))

	// Inter-integrated circuit
	I2C3 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40007800)))

	// General-purpose I/Os
	GPIOD = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000c00)))

	// General-purpose I/Os
	GPIOE = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001000)))

	// General-purpose I/Os
	GPIOF = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001400)))

	// General-purpose I/Os
	GPIOG = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001800)))

	// General purpose timers
	TIM17 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014800)))

	// Advanced-timers
	TIM8 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40013400)))

	// Advanced-timers
	TIM4 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000800)))

	// Basic-timers
	TIM7 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001400)))

	// Universal synchronous asynchronous receiver transmitter
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))

	// Universal synchronous asynchronous receiver transmitter
	USART3 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004800)))

	// Universal synchronous asynchronous receiver transmitter
	UART5 = (*USART_Type)(unsafe.Pointer(uintptr(0x40005000)))

	// Serial peripheral interface/Inter-IC sound
	SPI3 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003c00)))

	// Serial peripheral interface/Inter-IC sound
	SPI2 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))

	// DMA controller
	DMA2 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020400)))

	// Digital-to-analog converter
	DAC2 = (*DAC_Type)(unsafe.Pointer(uintptr(0x50000c00)))

	// Digital-to-analog converter
	DAC3 = (*DAC_Type)(unsafe.Pointer(uintptr(0x50001000)))

	// Digital-to-analog converter
	DAC4 = (*DAC_Type)(unsafe.Pointer(uintptr(0x50001400)))

	// Analog-to-Digital Converter
	ADC2 = (*ADC_Type)(unsafe.Pointer(uintptr(0x50000100)))

	// Analog-to-Digital Converter
	ADC345_Common = (*ADC_Type)(unsafe.Pointer(uintptr(0x50000700)))
)

// Cyclic redundancy check calculation unit
type CRC_Type struct {
	DR   volatile.Register32 // 0x0
	IDR  volatile.Register32 // 0x4
	CR   volatile.Register32 // 0x8
	_    [4]byte
	INIT volatile.Register32 // 0x10
	POL  volatile.Register32 // 0x14
}

// CRC.DR: Data register
func (o *CRC_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *CRC_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// CRC.IDR: Independent data register
func (o *CRC_Type) SetIDR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, value)
}
func (o *CRC_Type) GetIDR() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg)
}

// CRC.CR: Control register
func (o *CRC_Type) SetCR_REV_OUT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *CRC_Type) GetCR_REV_OUT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *CRC_Type) SetCR_REV_IN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x60)|value<<5)
}
func (o *CRC_Type) GetCR_REV_IN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x60) >> 5
}
func (o *CRC_Type) SetCR_POLYSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x18)|value<<3)
}
func (o *CRC_Type) GetCR_POLYSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x18) >> 3
}
func (o *CRC_Type) SetCR_RESET(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *CRC_Type) GetCR_RESET() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// CRC.INIT: Initial CRC value
func (o *CRC_Type) SetINIT(value uint32) {
	volatile.StoreUint32(&o.INIT.Reg, value)
}
func (o *CRC_Type) GetINIT() uint32 {
	return volatile.LoadUint32(&o.INIT.Reg)
}

// CRC.POL: polynomial
func (o *CRC_Type) SetPOL(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, value)
}
func (o *CRC_Type) GetPOL() uint32 {
	return volatile.LoadUint32(&o.POL.Reg)
}

// WinWATCHDOG
type IWDG_Type struct {
	KR   volatile.Register32 // 0x0
	PR   volatile.Register32 // 0x4
	RLR  volatile.Register32 // 0x8
	SR   volatile.Register32 // 0xC
	WINR volatile.Register32 // 0x10
}

// IWDG.KR: Key register
func (o *IWDG_Type) SetKR_KEY(value uint32) {
	volatile.StoreUint32(&o.KR.Reg, volatile.LoadUint32(&o.KR.Reg)&^(0xffff)|value)
}
func (o *IWDG_Type) GetKR_KEY() uint32 {
	return volatile.LoadUint32(&o.KR.Reg) & 0xffff
}

// IWDG.PR: Prescaler register
func (o *IWDG_Type) SetPR(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x7)|value)
}
func (o *IWDG_Type) GetPR() uint32 {
	return volatile.LoadUint32(&o.PR.Reg) & 0x7
}

// IWDG.RLR: Reload register
func (o *IWDG_Type) SetRLR_RL(value uint32) {
	volatile.StoreUint32(&o.RLR.Reg, volatile.LoadUint32(&o.RLR.Reg)&^(0xfff)|value)
}
func (o *IWDG_Type) GetRLR_RL() uint32 {
	return volatile.LoadUint32(&o.RLR.Reg) & 0xfff
}

// IWDG.SR: Status register
func (o *IWDG_Type) SetSR_WVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *IWDG_Type) GetSR_WVU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *IWDG_Type) SetSR_RVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *IWDG_Type) GetSR_RVU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *IWDG_Type) SetSR_PVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *IWDG_Type) GetSR_PVU() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// IWDG.WINR: Window register
func (o *IWDG_Type) SetWINR_WIN(value uint32) {
	volatile.StoreUint32(&o.WINR.Reg, volatile.LoadUint32(&o.WINR.Reg)&^(0xfff)|value)
}
func (o *IWDG_Type) GetWINR_WIN() uint32 {
	return volatile.LoadUint32(&o.WINR.Reg) & 0xfff
}

// System window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// WWDG.CR: Control register
func (o *WWDG_Type) SetCR_WDGA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *WWDG_Type) GetCR_WDGA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *WWDG_Type) SetCR_T(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7f)|value)
}
func (o *WWDG_Type) GetCR_T() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x7f
}

// WWDG.CFR: Configuration register
func (o *WWDG_Type) SetCFR_EWI(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x200)|value<<9)
}
func (o *WWDG_Type) GetCFR_EWI() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x200) >> 9
}
func (o *WWDG_Type) SetCFR_W(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x7f)|value)
}
func (o *WWDG_Type) GetCFR_W() uint32 {
	return volatile.LoadUint32(&o.CFR.Reg) & 0x7f
}
func (o *WWDG_Type) SetCFR_WDGTB(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x3800)|value<<11)
}
func (o *WWDG_Type) GetCFR_WDGTB() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x3800) >> 11
}

// WWDG.SR: Status register
func (o *WWDG_Type) SetSR_EWIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *WWDG_Type) GetSR_EWIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// Inter-integrated circuit
type I2C_Type struct {
	CR1      volatile.Register32 // 0x0
	CR2      volatile.Register32 // 0x4
	OAR1     volatile.Register32 // 0x8
	OAR2     volatile.Register32 // 0xC
	TIMINGR  volatile.Register32 // 0x10
	TIMEOUTR volatile.Register32 // 0x14
	ISR      volatile.Register32 // 0x18
	ICR      volatile.Register32 // 0x1C
	PECR     volatile.Register32 // 0x20
	RXDR     volatile.Register32 // 0x24
	TXDR     volatile.Register32 // 0x28
}

// I2C.CR1: Control register 1
func (o *I2C_Type) SetCR1_PE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCR1_PE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *I2C_Type) SetCR1_TXIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetCR1_TXIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetCR1_RXIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetCR1_RXIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetCR1_ADDRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetCR1_ADDRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetCR1_NACKIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetCR1_NACKIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetCR1_STOPIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetCR1_STOPIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetCR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetCR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetCR1_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetCR1_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetCR1_DNF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xf00)|value<<8)
}
func (o *I2C_Type) GetCR1_DNF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xf00) >> 8
}
func (o *I2C_Type) SetCR1_ANFOFF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCR1_ANFOFF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCR1_TXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetCR1_TXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetCR1_RXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetCR1_RXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetCR1_SBC(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetCR1_SBC() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetCR1_NOSTRETCH(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000)|value<<17)
}
func (o *I2C_Type) GetCR1_NOSTRETCH() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000) >> 17
}
func (o *I2C_Type) SetCR1_WUPEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40000)|value<<18)
}
func (o *I2C_Type) GetCR1_WUPEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40000) >> 18
}
func (o *I2C_Type) SetCR1_GCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000)|value<<19)
}
func (o *I2C_Type) GetCR1_GCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000) >> 19
}
func (o *I2C_Type) SetCR1_SMBHEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100000)|value<<20)
}
func (o *I2C_Type) GetCR1_SMBHEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100000) >> 20
}
func (o *I2C_Type) SetCR1_SMBDEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200000)|value<<21)
}
func (o *I2C_Type) GetCR1_SMBDEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200000) >> 21
}
func (o *I2C_Type) SetCR1_ALERTEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400000)|value<<22)
}
func (o *I2C_Type) GetCR1_ALERTEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400000) >> 22
}
func (o *I2C_Type) SetCR1_PECEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800000)|value<<23)
}
func (o *I2C_Type) GetCR1_PECEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800000) >> 23
}

// I2C.CR2: Control register 2
func (o *I2C_Type) SetCR2_PECBYTE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000000)|value<<26)
}
func (o *I2C_Type) GetCR2_PECBYTE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000000) >> 26
}
func (o *I2C_Type) SetCR2_AUTOEND(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000000)|value<<25)
}
func (o *I2C_Type) GetCR2_AUTOEND() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000000) >> 25
}
func (o *I2C_Type) SetCR2_RELOAD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000000)|value<<24)
}
func (o *I2C_Type) GetCR2_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000000) >> 24
}
func (o *I2C_Type) SetCR2_NBYTES(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xff0000)|value<<16)
}
func (o *I2C_Type) GetCR2_NBYTES() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xff0000) >> 16
}
func (o *I2C_Type) SetCR2_NACK(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetCR2_NACK() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetCR2_STOP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetCR2_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetCR2_START(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetCR2_START() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetCR2_HEAD10R(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCR2_HEAD10R() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCR2_ADD10(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetCR2_ADD10() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetCR2_RD_WRN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetCR2_RD_WRN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetCR2_SADD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetCR2_SADD() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x3ff
}

// I2C.OAR1: Own address register 1
func (o *I2C_Type) SetOAR1_OA1(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetOAR1_OA1() uint32 {
	return volatile.LoadUint32(&o.OAR1.Reg) & 0x3ff
}
func (o *I2C_Type) SetOAR1_OA1MODE(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetOAR1_OA1MODE() uint32 {
	return (volatile.LoadUint32(&o.OAR1.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetOAR1_OA1EN(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetOAR1_OA1EN() uint32 {
	return (volatile.LoadUint32(&o.OAR1.Reg) & 0x8000) >> 15
}

// I2C.OAR2: Own address register 2
func (o *I2C_Type) SetOAR2_OA2(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetOAR2_OA2() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetOAR2_OA2MSK(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0x700)|value<<8)
}
func (o *I2C_Type) GetOAR2_OA2MSK() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0x700) >> 8
}
func (o *I2C_Type) SetOAR2_OA2EN(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetOAR2_OA2EN() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0x8000) >> 15
}

// I2C.TIMINGR: Timing register
func (o *I2C_Type) SetTIMINGR_SCLL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetTIMINGR_SCLL() uint32 {
	return volatile.LoadUint32(&o.TIMINGR.Reg) & 0xff
}
func (o *I2C_Type) SetTIMINGR_SCLH(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xff00)|value<<8)
}
func (o *I2C_Type) GetTIMINGR_SCLH() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xff00) >> 8
}
func (o *I2C_Type) SetTIMINGR_SDADEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf0000)|value<<16)
}
func (o *I2C_Type) GetTIMINGR_SDADEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf0000) >> 16
}
func (o *I2C_Type) SetTIMINGR_SCLDEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf00000)|value<<20)
}
func (o *I2C_Type) GetTIMINGR_SCLDEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf00000) >> 20
}
func (o *I2C_Type) SetTIMINGR_PRESC(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf0000000)|value<<28)
}
func (o *I2C_Type) GetTIMINGR_PRESC() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf0000000) >> 28
}

// I2C.TIMEOUTR: Status register 1
func (o *I2C_Type) SetTIMEOUTR_TIMEOUTA(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0xfff)|value)
}
func (o *I2C_Type) GetTIMEOUTR_TIMEOUTA() uint32 {
	return volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0xfff
}
func (o *I2C_Type) SetTIMEOUTR_TIDLE(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetTIMEOUTR_TIDLE() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetTIMEOUTR_TIMOUTEN(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetTIMEOUTR_TIMOUTEN() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetTIMEOUTR_TIMEOUTB(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0xfff0000)|value<<16)
}
func (o *I2C_Type) GetTIMEOUTR_TIMEOUTB() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0xfff0000) >> 16
}
func (o *I2C_Type) SetTIMEOUTR_TEXTEN(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetTIMEOUTR_TEXTEN() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x80000000) >> 31
}

// I2C.ISR: Interrupt and Status register
func (o *I2C_Type) SetISR_ADDCODE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xfe0000)|value<<17)
}
func (o *I2C_Type) GetISR_ADDCODE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xfe0000) >> 17
}
func (o *I2C_Type) SetISR_DIR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetISR_DIR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetISR_BUSY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetISR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetISR_ALERT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetISR_ALERT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetISR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetISR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetISR_PECERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetISR_PECERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetISR_OVR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetISR_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetISR_ARLO(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetISR_ARLO() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetISR_BERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetISR_BERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetISR_TCR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetISR_TCR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetISR_TC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetISR_TC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetISR_STOPF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetISR_STOPF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetISR_NACKF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetISR_NACKF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetISR_ADDR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetISR_ADDR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetISR_RXNE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetISR_RXNE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetISR_TXIS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetISR_TXIS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetISR_TXE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetISR_TXE() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// I2C.ICR: Interrupt clear register
func (o *I2C_Type) SetICR_ALERTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetICR_ALERTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetICR_TIMOUTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetICR_TIMOUTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetICR_PECCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetICR_PECCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetICR_OVRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetICR_OVRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetICR_ARLOCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetICR_ARLOCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetICR_BERRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetICR_BERRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetICR_STOPCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetICR_STOPCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetICR_NACKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetICR_NACKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetICR_ADDRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetICR_ADDRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}

// I2C.PECR: PEC register
func (o *I2C_Type) SetPECR_PEC(value uint32) {
	volatile.StoreUint32(&o.PECR.Reg, volatile.LoadUint32(&o.PECR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetPECR_PEC() uint32 {
	return volatile.LoadUint32(&o.PECR.Reg) & 0xff
}

// I2C.RXDR: Receive data register
func (o *I2C_Type) SetRXDR_RXDATA(value uint32) {
	volatile.StoreUint32(&o.RXDR.Reg, volatile.LoadUint32(&o.RXDR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetRXDR_RXDATA() uint32 {
	return volatile.LoadUint32(&o.RXDR.Reg) & 0xff
}

// I2C.TXDR: Transmit data register
func (o *I2C_Type) SetTXDR_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXDR.Reg, volatile.LoadUint32(&o.TXDR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetTXDR_TXDATA() uint32 {
	return volatile.LoadUint32(&o.TXDR.Reg) & 0xff
}

// Flash
type Flash_Type struct {
	ACR      volatile.Register32 // 0x0
	PDKEYR   volatile.Register32 // 0x4
	KEYR     volatile.Register32 // 0x8
	OPTKEYR  volatile.Register32 // 0xC
	SR       volatile.Register32 // 0x10
	CR       volatile.Register32 // 0x14
	ECCR     volatile.Register32 // 0x18
	_        [4]byte
	OPTR     volatile.Register32 // 0x20
	PCROP1SR volatile.Register32 // 0x24
	PCROP1ER volatile.Register32 // 0x28
	WRP1AR   volatile.Register32 // 0x2C
	WRP1BR   volatile.Register32 // 0x30
	_        [60]byte
	SEC1R    volatile.Register32 // 0x70
}

// Flash.ACR: Access control register
func (o *Flash_Type) SetACR_LATENCY(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0xf)|value)
}
func (o *Flash_Type) GetACR_LATENCY() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0xf
}
func (o *Flash_Type) SetACR_PRFTEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x100)|value<<8)
}
func (o *Flash_Type) GetACR_PRFTEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x100) >> 8
}
func (o *Flash_Type) SetACR_ICEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x200)|value<<9)
}
func (o *Flash_Type) GetACR_ICEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x200) >> 9
}
func (o *Flash_Type) SetACR_DCEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x400)|value<<10)
}
func (o *Flash_Type) GetACR_DCEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x400) >> 10
}
func (o *Flash_Type) SetACR_ICRST(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x800)|value<<11)
}
func (o *Flash_Type) GetACR_ICRST() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x800) >> 11
}
func (o *Flash_Type) SetACR_DCRST(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x1000)|value<<12)
}
func (o *Flash_Type) GetACR_DCRST() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x1000) >> 12
}
func (o *Flash_Type) SetACR_RUN_PD(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x2000)|value<<13)
}
func (o *Flash_Type) GetACR_RUN_PD() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x2000) >> 13
}
func (o *Flash_Type) SetACR_SLEEP_PD(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x4000)|value<<14)
}
func (o *Flash_Type) GetACR_SLEEP_PD() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x4000) >> 14
}
func (o *Flash_Type) SetACR_DBG_SWEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x40000)|value<<18)
}
func (o *Flash_Type) GetACR_DBG_SWEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x40000) >> 18
}

// Flash.PDKEYR: Power down key register
func (o *Flash_Type) SetPDKEYR(value uint32) {
	volatile.StoreUint32(&o.PDKEYR.Reg, value)
}
func (o *Flash_Type) GetPDKEYR() uint32 {
	return volatile.LoadUint32(&o.PDKEYR.Reg)
}

// Flash.KEYR: Flash key register
func (o *Flash_Type) SetKEYR(value uint32) {
	volatile.StoreUint32(&o.KEYR.Reg, value)
}
func (o *Flash_Type) GetKEYR() uint32 {
	return volatile.LoadUint32(&o.KEYR.Reg)
}

// Flash.OPTKEYR: Option byte key register
func (o *Flash_Type) SetOPTKEYR(value uint32) {
	volatile.StoreUint32(&o.OPTKEYR.Reg, value)
}
func (o *Flash_Type) GetOPTKEYR() uint32 {
	return volatile.LoadUint32(&o.OPTKEYR.Reg)
}

// Flash.SR: Status register
func (o *Flash_Type) SetSR_EOP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *Flash_Type) GetSR_EOP() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *Flash_Type) SetSR_OPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *Flash_Type) GetSR_OPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *Flash_Type) SetSR_PROGERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *Flash_Type) GetSR_PROGERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *Flash_Type) SetSR_WRPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *Flash_Type) GetSR_WRPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *Flash_Type) SetSR_PGAERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *Flash_Type) GetSR_PGAERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *Flash_Type) SetSR_SIZERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *Flash_Type) GetSR_SIZERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *Flash_Type) SetSR_PGSERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *Flash_Type) GetSR_PGSERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *Flash_Type) SetSR_MISERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *Flash_Type) GetSR_MISERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *Flash_Type) SetSR_FASTERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *Flash_Type) GetSR_FASTERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *Flash_Type) SetSR_RDERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000)|value<<14)
}
func (o *Flash_Type) GetSR_RDERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000) >> 14
}
func (o *Flash_Type) SetSR_OPTVERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000)|value<<15)
}
func (o *Flash_Type) GetSR_OPTVERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000) >> 15
}
func (o *Flash_Type) SetSR_BSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *Flash_Type) GetSR_BSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}

// Flash.CR: Flash control register
func (o *Flash_Type) SetCR_PG(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *Flash_Type) GetCR_PG() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *Flash_Type) SetCR_PER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *Flash_Type) GetCR_PER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *Flash_Type) SetCR_MER1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *Flash_Type) GetCR_MER1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *Flash_Type) SetCR_PNB(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3f8)|value<<3)
}
func (o *Flash_Type) GetCR_PNB() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x3f8) >> 3
}
func (o *Flash_Type) SetCR_STRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *Flash_Type) GetCR_STRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *Flash_Type) SetCR_OPTSTRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *Flash_Type) GetCR_OPTSTRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *Flash_Type) SetCR_FSTPG(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *Flash_Type) GetCR_FSTPG() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *Flash_Type) SetCR_EOPIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *Flash_Type) GetCR_EOPIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *Flash_Type) SetCR_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000000)|value<<25)
}
func (o *Flash_Type) GetCR_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000000) >> 25
}
func (o *Flash_Type) SetCR_RDERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000000)|value<<26)
}
func (o *Flash_Type) GetCR_RDERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000000) >> 26
}
func (o *Flash_Type) SetCR_OBL_LAUNCH(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000000)|value<<27)
}
func (o *Flash_Type) GetCR_OBL_LAUNCH() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000000) >> 27
}
func (o *Flash_Type) SetCR_SEC_PROT1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000000)|value<<28)
}
func (o *Flash_Type) GetCR_SEC_PROT1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000000) >> 28
}
func (o *Flash_Type) SetCR_OPTLOCK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000000)|value<<30)
}
func (o *Flash_Type) GetCR_OPTLOCK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000000) >> 30
}
func (o *Flash_Type) SetCR_LOCK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000000)|value<<31)
}
func (o *Flash_Type) GetCR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000000) >> 31
}

// Flash.ECCR: Flash ECC register
func (o *Flash_Type) SetECCR_ADDR_ECC(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x7ffff)|value)
}
func (o *Flash_Type) GetECCR_ADDR_ECC() uint32 {
	return volatile.LoadUint32(&o.ECCR.Reg) & 0x7ffff
}
func (o *Flash_Type) SetECCR_BK_ECC(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x200000)|value<<21)
}
func (o *Flash_Type) GetECCR_BK_ECC() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x200000) >> 21
}
func (o *Flash_Type) SetECCR_SYSF_ECC(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x400000)|value<<22)
}
func (o *Flash_Type) GetECCR_SYSF_ECC() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x400000) >> 22
}
func (o *Flash_Type) SetECCR_ECCIE(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x1000000)|value<<24)
}
func (o *Flash_Type) GetECCR_ECCIE() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x1000000) >> 24
}
func (o *Flash_Type) SetECCR_ECCC2(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x10000000)|value<<28)
}
func (o *Flash_Type) GetECCR_ECCC2() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x10000000) >> 28
}
func (o *Flash_Type) SetECCR_ECCD2(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x20000000)|value<<29)
}
func (o *Flash_Type) GetECCR_ECCD2() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x20000000) >> 29
}
func (o *Flash_Type) SetECCR_ECCC(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x40000000)|value<<30)
}
func (o *Flash_Type) GetECCR_ECCC() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x40000000) >> 30
}
func (o *Flash_Type) SetECCR_ECCD(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x80000000)|value<<31)
}
func (o *Flash_Type) GetECCR_ECCD() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x80000000) >> 31
}

// Flash.OPTR: Flash option register
func (o *Flash_Type) SetOPTR_RDP(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0xff)|value)
}
func (o *Flash_Type) GetOPTR_RDP() uint32 {
	return volatile.LoadUint32(&o.OPTR.Reg) & 0xff
}
func (o *Flash_Type) SetOPTR_BOR_LEV(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x700)|value<<8)
}
func (o *Flash_Type) GetOPTR_BOR_LEV() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x700) >> 8
}
func (o *Flash_Type) SetOPTR_NRST_STOP(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x1000)|value<<12)
}
func (o *Flash_Type) GetOPTR_NRST_STOP() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x1000) >> 12
}
func (o *Flash_Type) SetOPTR_NRST_STDBY(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x2000)|value<<13)
}
func (o *Flash_Type) GetOPTR_NRST_STDBY() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x2000) >> 13
}
func (o *Flash_Type) SetOPTR_NRST_SHDW(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x4000)|value<<14)
}
func (o *Flash_Type) GetOPTR_NRST_SHDW() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x4000) >> 14
}
func (o *Flash_Type) SetOPTR_IDWG_SW(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x10000)|value<<16)
}
func (o *Flash_Type) GetOPTR_IDWG_SW() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x10000) >> 16
}
func (o *Flash_Type) SetOPTR_IWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x20000)|value<<17)
}
func (o *Flash_Type) GetOPTR_IWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x20000) >> 17
}
func (o *Flash_Type) SetOPTR_IWDG_STDBY(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x40000)|value<<18)
}
func (o *Flash_Type) GetOPTR_IWDG_STDBY() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x40000) >> 18
}
func (o *Flash_Type) SetOPTR_WWDG_SW(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x80000)|value<<19)
}
func (o *Flash_Type) GetOPTR_WWDG_SW() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x80000) >> 19
}
func (o *Flash_Type) SetOPTR_NBOOT1(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x800000)|value<<23)
}
func (o *Flash_Type) GetOPTR_NBOOT1() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x800000) >> 23
}
func (o *Flash_Type) SetOPTR_SRAM2_PE(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x1000000)|value<<24)
}
func (o *Flash_Type) GetOPTR_SRAM2_PE() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x1000000) >> 24
}
func (o *Flash_Type) SetOPTR_SRAM2_RST(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x2000000)|value<<25)
}
func (o *Flash_Type) GetOPTR_SRAM2_RST() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x2000000) >> 25
}
func (o *Flash_Type) SetOPTR_NSWBOOT0(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x4000000)|value<<26)
}
func (o *Flash_Type) GetOPTR_NSWBOOT0() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x4000000) >> 26
}
func (o *Flash_Type) SetOPTR_NBOOT0(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x8000000)|value<<27)
}
func (o *Flash_Type) GetOPTR_NBOOT0() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x8000000) >> 27
}
func (o *Flash_Type) SetOPTR_NRST_MODE(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x30000000)|value<<28)
}
func (o *Flash_Type) GetOPTR_NRST_MODE() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x30000000) >> 28
}
func (o *Flash_Type) SetOPTR_IRHEN(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x40000000)|value<<30)
}
func (o *Flash_Type) GetOPTR_IRHEN() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x40000000) >> 30
}

// Flash.PCROP1SR: Flash Bank 1 PCROP Start address register
func (o *Flash_Type) SetPCROP1SR_PCROP1_STRT(value uint32) {
	volatile.StoreUint32(&o.PCROP1SR.Reg, volatile.LoadUint32(&o.PCROP1SR.Reg)&^(0x7fff)|value)
}
func (o *Flash_Type) GetPCROP1SR_PCROP1_STRT() uint32 {
	return volatile.LoadUint32(&o.PCROP1SR.Reg) & 0x7fff
}

// Flash.PCROP1ER: Flash Bank 1 PCROP End address register
func (o *Flash_Type) SetPCROP1ER_PCROP1_END(value uint32) {
	volatile.StoreUint32(&o.PCROP1ER.Reg, volatile.LoadUint32(&o.PCROP1ER.Reg)&^(0x7fff)|value)
}
func (o *Flash_Type) GetPCROP1ER_PCROP1_END() uint32 {
	return volatile.LoadUint32(&o.PCROP1ER.Reg) & 0x7fff
}
func (o *Flash_Type) SetPCROP1ER_PCROP_RDP(value uint32) {
	volatile.StoreUint32(&o.PCROP1ER.Reg, volatile.LoadUint32(&o.PCROP1ER.Reg)&^(0x80000000)|value<<31)
}
func (o *Flash_Type) GetPCROP1ER_PCROP_RDP() uint32 {
	return (volatile.LoadUint32(&o.PCROP1ER.Reg) & 0x80000000) >> 31
}

// Flash.WRP1AR: Flash Bank 1 WRP area A address register
func (o *Flash_Type) SetWRP1AR_WRP1A_STRT(value uint32) {
	volatile.StoreUint32(&o.WRP1AR.Reg, volatile.LoadUint32(&o.WRP1AR.Reg)&^(0x7f)|value)
}
func (o *Flash_Type) GetWRP1AR_WRP1A_STRT() uint32 {
	return volatile.LoadUint32(&o.WRP1AR.Reg) & 0x7f
}
func (o *Flash_Type) SetWRP1AR_WRP1A_END(value uint32) {
	volatile.StoreUint32(&o.WRP1AR.Reg, volatile.LoadUint32(&o.WRP1AR.Reg)&^(0x7f0000)|value<<16)
}
func (o *Flash_Type) GetWRP1AR_WRP1A_END() uint32 {
	return (volatile.LoadUint32(&o.WRP1AR.Reg) & 0x7f0000) >> 16
}

// Flash.WRP1BR: Flash Bank 1 WRP area B address register
func (o *Flash_Type) SetWRP1BR_WRP1B_STRT(value uint32) {
	volatile.StoreUint32(&o.WRP1BR.Reg, volatile.LoadUint32(&o.WRP1BR.Reg)&^(0x7f)|value)
}
func (o *Flash_Type) GetWRP1BR_WRP1B_STRT() uint32 {
	return volatile.LoadUint32(&o.WRP1BR.Reg) & 0x7f
}
func (o *Flash_Type) SetWRP1BR_WRP1B_END(value uint32) {
	volatile.StoreUint32(&o.WRP1BR.Reg, volatile.LoadUint32(&o.WRP1BR.Reg)&^(0x7f0000)|value<<16)
}
func (o *Flash_Type) GetWRP1BR_WRP1B_END() uint32 {
	return (volatile.LoadUint32(&o.WRP1BR.Reg) & 0x7f0000) >> 16
}

// Flash.SEC1R: securable area bank1 register
func (o *Flash_Type) SetSEC1R_BOOT_LOCK(value uint32) {
	volatile.StoreUint32(&o.SEC1R.Reg, volatile.LoadUint32(&o.SEC1R.Reg)&^(0x10000)|value<<16)
}
func (o *Flash_Type) GetSEC1R_BOOT_LOCK() uint32 {
	return (volatile.LoadUint32(&o.SEC1R.Reg) & 0x10000) >> 16
}
func (o *Flash_Type) SetSEC1R_SEC_SIZE1(value uint32) {
	volatile.StoreUint32(&o.SEC1R.Reg, volatile.LoadUint32(&o.SEC1R.Reg)&^(0xff)|value)
}
func (o *Flash_Type) GetSEC1R_SEC_SIZE1() uint32 {
	return volatile.LoadUint32(&o.SEC1R.Reg) & 0xff
}

// Debug support
type DBGMCU_Type struct {
	IDCODE   volatile.Register32 // 0x0
	CR       volatile.Register32 // 0x4
	APB1L_FZ volatile.Register32 // 0x8
	APB1H_FZ volatile.Register32 // 0xC
	APB2_FZ  volatile.Register32 // 0x10
}

// DBGMCU.IDCODE: MCU Device ID Code Register
func (o *DBGMCU_Type) SetIDCODE_DEV_ID(value uint32) {
	volatile.StoreUint32(&o.IDCODE.Reg, volatile.LoadUint32(&o.IDCODE.Reg)&^(0xffff)|value)
}
func (o *DBGMCU_Type) GetIDCODE_DEV_ID() uint32 {
	return volatile.LoadUint32(&o.IDCODE.Reg) & 0xffff
}
func (o *DBGMCU_Type) SetIDCODE_REV_ID(value uint32) {
	volatile.StoreUint32(&o.IDCODE.Reg, volatile.LoadUint32(&o.IDCODE.Reg)&^(0xffff0000)|value<<16)
}
func (o *DBGMCU_Type) GetIDCODE_REV_ID() uint32 {
	return (volatile.LoadUint32(&o.IDCODE.Reg) & 0xffff0000) >> 16
}

// DBGMCU.CR: Debug MCU Configuration Register
func (o *DBGMCU_Type) SetCR_DBG_SLEEP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DBGMCU_Type) GetCR_DBG_SLEEP() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *DBGMCU_Type) SetCR_DBG_STOP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DBGMCU_Type) GetCR_DBG_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DBGMCU_Type) SetCR_DBG_STANDBY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DBGMCU_Type) GetCR_DBG_STANDBY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DBGMCU_Type) SetCR_TRACE_IOEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DBGMCU_Type) GetCR_TRACE_IOEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DBGMCU_Type) SetCR_TRACE_MODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc0)|value<<6)
}
func (o *DBGMCU_Type) GetCR_TRACE_MODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc0) >> 6
}

// DBGMCU.APB1L_FZ: APB Low Freeze Register 1
func (o *DBGMCU_Type) SetAPB1L_FZ_DBG_TIMER2_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1L_FZ.Reg, volatile.LoadUint32(&o.APB1L_FZ.Reg)&^(0x1)|value)
}
func (o *DBGMCU_Type) GetAPB1L_FZ_DBG_TIMER2_STOP() uint32 {
	return volatile.LoadUint32(&o.APB1L_FZ.Reg) & 0x1
}
func (o *DBGMCU_Type) SetAPB1L_FZ_DBG_TIM3_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1L_FZ.Reg, volatile.LoadUint32(&o.APB1L_FZ.Reg)&^(0x2)|value<<1)
}
func (o *DBGMCU_Type) GetAPB1L_FZ_DBG_TIM3_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1L_FZ.Reg) & 0x2) >> 1
}
func (o *DBGMCU_Type) SetAPB1L_FZ_DBG_TIM4_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1L_FZ.Reg, volatile.LoadUint32(&o.APB1L_FZ.Reg)&^(0x4)|value<<2)
}
func (o *DBGMCU_Type) GetAPB1L_FZ_DBG_TIM4_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1L_FZ.Reg) & 0x4) >> 2
}
func (o *DBGMCU_Type) SetAPB1L_FZ_DBG_TIM5_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1L_FZ.Reg, volatile.LoadUint32(&o.APB1L_FZ.Reg)&^(0x8)|value<<3)
}
func (o *DBGMCU_Type) GetAPB1L_FZ_DBG_TIM5_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1L_FZ.Reg) & 0x8) >> 3
}
func (o *DBGMCU_Type) SetAPB1L_FZ_DBG_TIMER6_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1L_FZ.Reg, volatile.LoadUint32(&o.APB1L_FZ.Reg)&^(0x10)|value<<4)
}
func (o *DBGMCU_Type) GetAPB1L_FZ_DBG_TIMER6_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1L_FZ.Reg) & 0x10) >> 4
}
func (o *DBGMCU_Type) SetAPB1L_FZ_DBG_TIM7_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1L_FZ.Reg, volatile.LoadUint32(&o.APB1L_FZ.Reg)&^(0x20)|value<<5)
}
func (o *DBGMCU_Type) GetAPB1L_FZ_DBG_TIM7_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1L_FZ.Reg) & 0x20) >> 5
}
func (o *DBGMCU_Type) SetAPB1L_FZ_DBG_RTC_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1L_FZ.Reg, volatile.LoadUint32(&o.APB1L_FZ.Reg)&^(0x400)|value<<10)
}
func (o *DBGMCU_Type) GetAPB1L_FZ_DBG_RTC_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1L_FZ.Reg) & 0x400) >> 10
}
func (o *DBGMCU_Type) SetAPB1L_FZ_DBG_WWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1L_FZ.Reg, volatile.LoadUint32(&o.APB1L_FZ.Reg)&^(0x800)|value<<11)
}
func (o *DBGMCU_Type) GetAPB1L_FZ_DBG_WWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1L_FZ.Reg) & 0x800) >> 11
}
func (o *DBGMCU_Type) SetAPB1L_FZ_DBG_IWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1L_FZ.Reg, volatile.LoadUint32(&o.APB1L_FZ.Reg)&^(0x1000)|value<<12)
}
func (o *DBGMCU_Type) GetAPB1L_FZ_DBG_IWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1L_FZ.Reg) & 0x1000) >> 12
}
func (o *DBGMCU_Type) SetAPB1L_FZ_DBG_I2C1_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1L_FZ.Reg, volatile.LoadUint32(&o.APB1L_FZ.Reg)&^(0x200000)|value<<21)
}
func (o *DBGMCU_Type) GetAPB1L_FZ_DBG_I2C1_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1L_FZ.Reg) & 0x200000) >> 21
}
func (o *DBGMCU_Type) SetAPB1L_FZ_DBG_I2C2_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1L_FZ.Reg, volatile.LoadUint32(&o.APB1L_FZ.Reg)&^(0x400000)|value<<22)
}
func (o *DBGMCU_Type) GetAPB1L_FZ_DBG_I2C2_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1L_FZ.Reg) & 0x400000) >> 22
}
func (o *DBGMCU_Type) SetAPB1L_FZ_DBG_I2C3_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1L_FZ.Reg, volatile.LoadUint32(&o.APB1L_FZ.Reg)&^(0x40000000)|value<<30)
}
func (o *DBGMCU_Type) GetAPB1L_FZ_DBG_I2C3_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1L_FZ.Reg) & 0x40000000) >> 30
}
func (o *DBGMCU_Type) SetAPB1L_FZ_DBG_LPTIMER_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1L_FZ.Reg, volatile.LoadUint32(&o.APB1L_FZ.Reg)&^(0x80000000)|value<<31)
}
func (o *DBGMCU_Type) GetAPB1L_FZ_DBG_LPTIMER_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1L_FZ.Reg) & 0x80000000) >> 31
}

// DBGMCU.APB1H_FZ: APB Low Freeze Register 2
func (o *DBGMCU_Type) SetAPB1H_FZ_DBG_I2C4_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1H_FZ.Reg, volatile.LoadUint32(&o.APB1H_FZ.Reg)&^(0x2)|value<<1)
}
func (o *DBGMCU_Type) GetAPB1H_FZ_DBG_I2C4_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1H_FZ.Reg) & 0x2) >> 1
}

// DBGMCU.APB2_FZ: APB High Freeze Register
func (o *DBGMCU_Type) SetAPB2_FZ_DBG_TIM1_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x800)|value<<11)
}
func (o *DBGMCU_Type) GetAPB2_FZ_DBG_TIM1_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x800) >> 11
}
func (o *DBGMCU_Type) SetAPB2_FZ_DBG_TIM8_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x2000)|value<<13)
}
func (o *DBGMCU_Type) GetAPB2_FZ_DBG_TIM8_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x2000) >> 13
}
func (o *DBGMCU_Type) SetAPB2_FZ_DBG_TIM15_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x10000)|value<<16)
}
func (o *DBGMCU_Type) GetAPB2_FZ_DBG_TIM15_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x10000) >> 16
}
func (o *DBGMCU_Type) SetAPB2_FZ_DBG_TIM16_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x20000)|value<<17)
}
func (o *DBGMCU_Type) GetAPB2_FZ_DBG_TIM16_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x20000) >> 17
}
func (o *DBGMCU_Type) SetAPB2_FZ_DBG_TIM17_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x40000)|value<<18)
}
func (o *DBGMCU_Type) GetAPB2_FZ_DBG_TIM17_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x40000) >> 18
}
func (o *DBGMCU_Type) SetAPB2_FZ_DBG_TIM20_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x100000)|value<<20)
}
func (o *DBGMCU_Type) GetAPB2_FZ_DBG_TIM20_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x100000) >> 20
}
func (o *DBGMCU_Type) SetAPB2_FZ_DBG_HRTIM0_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x4000000)|value<<26)
}
func (o *DBGMCU_Type) GetAPB2_FZ_DBG_HRTIM0_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x4000000) >> 26
}
func (o *DBGMCU_Type) SetAPB2_FZ_DBG_HRTIM1_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x8000000)|value<<27)
}
func (o *DBGMCU_Type) GetAPB2_FZ_DBG_HRTIM1_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x8000000) >> 27
}
func (o *DBGMCU_Type) SetAPB2_FZ_DBG_HRTIM2_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x10000000)|value<<28)
}
func (o *DBGMCU_Type) GetAPB2_FZ_DBG_HRTIM2_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x10000000) >> 28
}
func (o *DBGMCU_Type) SetAPB2_FZ_DBG_HRTIM3_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x20000000)|value<<29)
}
func (o *DBGMCU_Type) GetAPB2_FZ_DBG_HRTIM3_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x20000000) >> 29
}

// Reset and clock control
type RCC_Type struct {
	CR         volatile.Register32 // 0x0
	ICSCR      volatile.Register32 // 0x4
	CFGR       volatile.Register32 // 0x8
	PLLCFGR    volatile.Register32 // 0xC
	_          [8]byte
	CIER       volatile.Register32 // 0x18
	CIFR       volatile.Register32 // 0x1C
	CICR       volatile.Register32 // 0x20
	_          [4]byte
	AHB1RSTR   volatile.Register32 // 0x28
	AHB2RSTR   volatile.Register32 // 0x2C
	AHB3RSTR   volatile.Register32 // 0x30
	_          [4]byte
	APB1RSTR1  volatile.Register32 // 0x38
	APB1RSTR2  volatile.Register32 // 0x3C
	APB2RSTR   volatile.Register32 // 0x40
	_          [4]byte
	AHB1ENR    volatile.Register32 // 0x48
	AHB2ENR    volatile.Register32 // 0x4C
	AHB3ENR    volatile.Register32 // 0x50
	_          [4]byte
	APB1ENR1   volatile.Register32 // 0x58
	APB1ENR2   volatile.Register32 // 0x5C
	APB2ENR    volatile.Register32 // 0x60
	_          [4]byte
	AHB1SMENR  volatile.Register32 // 0x68
	AHB2SMENR  volatile.Register32 // 0x6C
	AHB3SMENR  volatile.Register32 // 0x70
	_          [4]byte
	APB1SMENR1 volatile.Register32 // 0x78
	APB1SMENR2 volatile.Register32 // 0x7C
	APB2SMENR  volatile.Register32 // 0x80
	_          [4]byte
	CCIPR      volatile.Register32 // 0x88
	_          [4]byte
	BDCR       volatile.Register32 // 0x90
	CSR        volatile.Register32 // 0x94
	CRRCR      volatile.Register32 // 0x98
	CCIPR2     volatile.Register32 // 0x9C
}

// RCC.CR: Clock control register
func (o *RCC_Type) SetCR_PLLRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetCR_PLLRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetCR_PLLON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetCR_PLLON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetCR_CSSON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetCR_CSSON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetCR_HSEBYP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetCR_HSEBYP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetCR_HSERDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetCR_HSERDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetCR_HSEON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetCR_HSEON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetCR_HSIRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetCR_HSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetCR_HSIKERON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCR_HSIKERON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetCR_HSION(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetCR_HSION() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}

// RCC.ICSCR: Internal clock sources calibration register
func (o *RCC_Type) SetICSCR_HSICAL0(value uint32) {
	volatile.StoreUint32(&o.ICSCR.Reg, volatile.LoadUint32(&o.ICSCR.Reg)&^(0xff0000)|value<<16)
}
func (o *RCC_Type) GetICSCR_HSICAL0() uint32 {
	return (volatile.LoadUint32(&o.ICSCR.Reg) & 0xff0000) >> 16
}
func (o *RCC_Type) SetICSCR_HSITRIM(value uint32) {
	volatile.StoreUint32(&o.ICSCR.Reg, volatile.LoadUint32(&o.ICSCR.Reg)&^(0x7f000000)|value<<24)
}
func (o *RCC_Type) GetICSCR_HSITRIM() uint32 {
	return (volatile.LoadUint32(&o.ICSCR.Reg) & 0x7f000000) >> 24
}

// RCC.CFGR: Clock configuration register
func (o *RCC_Type) SetCFGR_MCOPRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x70000000)|value<<28)
}
func (o *RCC_Type) GetCFGR_MCOPRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x70000000) >> 28
}
func (o *RCC_Type) SetCFGR_MCOSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xf000000)|value<<24)
}
func (o *RCC_Type) GetCFGR_MCOSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xf000000) >> 24
}
func (o *RCC_Type) SetCFGR_PPRE2(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x3800)|value<<11)
}
func (o *RCC_Type) GetCFGR_PPRE2() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x3800) >> 11
}
func (o *RCC_Type) SetCFGR_PPRE1(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x700)|value<<8)
}
func (o *RCC_Type) GetCFGR_PPRE1() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x700) >> 8
}
func (o *RCC_Type) SetCFGR_HPRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xf0)|value<<4)
}
func (o *RCC_Type) GetCFGR_HPRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xf0) >> 4
}
func (o *RCC_Type) SetCFGR_SWS(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc)|value<<2)
}
func (o *RCC_Type) GetCFGR_SWS() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc) >> 2
}
func (o *RCC_Type) SetCFGR_SW(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x3)|value)
}
func (o *RCC_Type) GetCFGR_SW() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x3
}

// RCC.PLLCFGR: PLL configuration register
func (o *RCC_Type) SetPLLCFGR_PLLPDIV(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0xf8000000)|value<<27)
}
func (o *RCC_Type) GetPLLCFGR_PLLPDIV() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0xf8000000) >> 27
}
func (o *RCC_Type) SetPLLCFGR_PLLR(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x6000000)|value<<25)
}
func (o *RCC_Type) GetPLLCFGR_PLLR() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x6000000) >> 25
}
func (o *RCC_Type) SetPLLCFGR_PLLREN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetPLLCFGR_PLLREN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetPLLCFGR_PLLQ(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x600000)|value<<21)
}
func (o *RCC_Type) GetPLLCFGR_PLLQ() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x600000) >> 21
}
func (o *RCC_Type) SetPLLCFGR_PLLQEN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetPLLCFGR_PLLQEN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetPLLCFGR_PLLP(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetPLLCFGR_PLLP() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetPLLCFGR_PLLPEN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetPLLCFGR_PLLPEN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetPLLCFGR_PLLN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x7f00)|value<<8)
}
func (o *RCC_Type) GetPLLCFGR_PLLN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x7f00) >> 8
}
func (o *RCC_Type) SetPLLCFGR_PLLM(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0xf0)|value<<4)
}
func (o *RCC_Type) GetPLLCFGR_PLLM() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0xf0) >> 4
}
func (o *RCC_Type) SetPLLCFGR_PLLSRC(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x3)|value)
}
func (o *RCC_Type) GetPLLCFGR_PLLSRC() uint32 {
	return volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x3
}

// RCC.CIER: Clock interrupt enable register
func (o *RCC_Type) SetCIER_LSIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCIER_LSIRDYIE() uint32 {
	return volatile.LoadUint32(&o.CIER.Reg) & 0x1
}
func (o *RCC_Type) SetCIER_LSERDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCIER_LSERDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCIER_HSIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetCIER_HSIRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetCIER_HSERDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetCIER_HSERDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetCIER_PLLRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetCIER_PLLRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetCIER_LSECSSIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCIER_LSECSSIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetCIER_HSI48RDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetCIER_HSI48RDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x400) >> 10
}

// RCC.CIFR: Clock interrupt flag register
func (o *RCC_Type) SetCIFR_LSIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCIFR_LSIRDYF() uint32 {
	return volatile.LoadUint32(&o.CIFR.Reg) & 0x1
}
func (o *RCC_Type) SetCIFR_LSERDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCIFR_LSERDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCIFR_HSIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetCIFR_HSIRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetCIFR_HSERDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetCIFR_HSERDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetCIFR_PLLRDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetCIFR_PLLRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetCIFR_CSSF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetCIFR_CSSF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetCIFR_LSECSSF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCIFR_LSECSSF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetCIFR_HSI48RDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetCIFR_HSI48RDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x400) >> 10
}

// RCC.CICR: Clock interrupt clear register
func (o *RCC_Type) SetCICR_LSIRDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCICR_LSIRDYC() uint32 {
	return volatile.LoadUint32(&o.CICR.Reg) & 0x1
}
func (o *RCC_Type) SetCICR_LSERDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCICR_LSERDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCICR_HSIRDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetCICR_HSIRDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetCICR_HSERDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetCICR_HSERDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetCICR_PLLRDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetCICR_PLLRDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetCICR_CSSC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetCICR_CSSC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetCICR_LSECSSC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCICR_LSECSSC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetCICR_HSI48RDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetCICR_HSI48RDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x400) >> 10
}

// RCC.AHB1RSTR: AHB1 peripheral reset register
func (o *RCC_Type) SetAHB1RSTR_DMA1RST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB1RSTR_DMA1RST() uint32 {
	return volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB1RSTR_DMA2RST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB1RSTR_DMA2RST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB1RSTR_DMAMUX1RST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB1RSTR_DMAMUX1RST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB1RSTR_CORDICRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHB1RSTR_CORDICRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHB1RSTR_FMACRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB1RSTR_FMACRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB1RSTR_FLASHRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB1RSTR_FLASHRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAHB1RSTR_CRCRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB1RSTR_CRCRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x1000) >> 12
}

// RCC.AHB2RSTR: AHB2 peripheral reset register
func (o *RCC_Type) SetAHB2RSTR_GPIOARST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB2RSTR_GPIOARST() uint32 {
	return volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB2RSTR_GPIOBRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB2RSTR_GPIOBRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB2RSTR_GPIOCRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB2RSTR_GPIOCRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB2RSTR_GPIODRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHB2RSTR_GPIODRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHB2RSTR_GPIOERST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB2RSTR_GPIOERST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB2RSTR_GPIOFRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB2RSTR_GPIOFRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB2RSTR_GPIOGRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB2RSTR_GPIOGRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB2RSTR_ADC12RST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAHB2RSTR_ADC12RST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAHB2RSTR_ADC345RST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAHB2RSTR_ADC345RST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAHB2RSTR_DAC1RST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB2RSTR_DAC1RST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHB2RSTR_DAC2RST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAHB2RSTR_DAC2RST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAHB2RSTR_DAC3RST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAHB2RSTR_DAC3RST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAHB2RSTR_DAC4RST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAHB2RSTR_DAC4RST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAHB2RSTR_AESRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAHB2RSTR_AESRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAHB2RSTR_RNGRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAHB2RSTR_RNGRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x4000000) >> 26
}

// RCC.AHB3RSTR: AHB3 peripheral reset register
func (o *RCC_Type) SetAHB3RSTR_FMCRST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB3RSTR_FMCRST() uint32 {
	return volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB3RSTR_QSPIRST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB3RSTR_QSPIRST() uint32 {
	return (volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x100) >> 8
}

// RCC.APB1RSTR1: APB1 peripheral reset register 1
func (o *RCC_Type) SetAPB1RSTR1_LPTIM1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPB1RSTR1_LPTIM1RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetAPB1RSTR1_I2C3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAPB1RSTR1_I2C3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAPB1RSTR1_PWRRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPB1RSTR1_PWRRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPB1RSTR1_FDCANRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAPB1RSTR1_FDCANRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAPB1RSTR1_USBRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1RSTR1_USBRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1RSTR1_I2C2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1RSTR1_I2C2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1RSTR1_I2C1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1RSTR1_I2C1RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1RSTR1_UART5RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB1RSTR1_UART5RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB1RSTR1_UART4RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAPB1RSTR1_UART4RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAPB1RSTR1_USART3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB1RSTR1_USART3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB1RSTR1_USART2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1RSTR1_USART2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1RSTR1_SPI3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB1RSTR1_SPI3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB1RSTR1_SPI2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1RSTR1_SPI2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1RSTR1_CRSRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB1RSTR1_CRSRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB1RSTR1_TIM7RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1RSTR1_TIM7RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1RSTR1_TIM6RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB1RSTR1_TIM6RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB1RSTR1_TIM5RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB1RSTR1_TIM5RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB1RSTR1_TIM4RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1RSTR1_TIM4RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1RSTR1_TIM3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1RSTR1_TIM3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1RSTR1_TIM2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1RSTR1_TIM2RST() uint32 {
	return volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x1
}

// RCC.APB1RSTR2: APB1 peripheral reset register 2
func (o *RCC_Type) SetAPB1RSTR2_LPUART1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR2.Reg, volatile.LoadUint32(&o.APB1RSTR2.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1RSTR2_LPUART1RST() uint32 {
	return volatile.LoadUint32(&o.APB1RSTR2.Reg) & 0x1
}
func (o *RCC_Type) SetAPB1RSTR2_I2C4RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR2.Reg, volatile.LoadUint32(&o.APB1RSTR2.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1RSTR2_I2C4RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR2.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1RSTR2_UCPD1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR2.Reg, volatile.LoadUint32(&o.APB1RSTR2.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB1RSTR2_UCPD1RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR2.Reg) & 0x100) >> 8
}

// RCC.APB2RSTR: APB2 peripheral reset register
func (o *RCC_Type) SetAPB2RSTR_SYSCFGRST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB2RSTR_SYSCFGRST() uint32 {
	return volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB2RSTR_TIM1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2RSTR_TIM1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB2RSTR_SPI1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2RSTR_SPI1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2RSTR_TIM8RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAPB2RSTR_TIM8RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAPB2RSTR_USART1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2RSTR_USART1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2RSTR_SPI4RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB2RSTR_SPI4RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB2RSTR_TIM15RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB2RSTR_TIM15RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB2RSTR_TIM16RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2RSTR_TIM16RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2RSTR_TIM17RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2RSTR_TIM17RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB2RSTR_TIM20RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB2RSTR_TIM20RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB2RSTR_SAI1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB2RSTR_SAI1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB2RSTR_HRTIM1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAPB2RSTR_HRTIM1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x4000000) >> 26
}

// RCC.AHB1ENR: AHB1 peripheral clock enable register
func (o *RCC_Type) SetAHB1ENR_DMA1EN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB1ENR_DMA1EN() uint32 {
	return volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB1ENR_DMA2EN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB1ENR_DMA2EN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB1ENR_DMAMUXEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB1ENR_DMAMUXEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB1ENR_CORDICEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHB1ENR_CORDICEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHB1ENR_FMACEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB1ENR_FMACEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB1ENR_FLASHEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB1ENR_FLASHEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAHB1ENR_CRCEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB1ENR_CRCEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x1000) >> 12
}

// RCC.AHB2ENR: AHB2 peripheral clock enable register
func (o *RCC_Type) SetAHB2ENR_GPIOAEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB2ENR_GPIOAEN() uint32 {
	return volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB2ENR_GPIOBEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB2ENR_GPIOBEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB2ENR_GPIOCEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB2ENR_GPIOCEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB2ENR_GPIODEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHB2ENR_GPIODEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHB2ENR_GPIOEEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB2ENR_GPIOEEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB2ENR_GPIOFEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB2ENR_GPIOFEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB2ENR_GPIOGEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB2ENR_GPIOGEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB2ENR_ADC12EN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAHB2ENR_ADC12EN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAHB2ENR_ADC345EN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAHB2ENR_ADC345EN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAHB2ENR_DAC1EN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB2ENR_DAC1EN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHB2ENR_DAC2EN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAHB2ENR_DAC2EN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAHB2ENR_DAC3EN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAHB2ENR_DAC3EN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAHB2ENR_DAC4EN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAHB2ENR_DAC4EN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAHB2ENR_AESEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAHB2ENR_AESEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAHB2ENR_RNGEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAHB2ENR_RNGEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x4000000) >> 26
}

// RCC.AHB3ENR: AHB3 peripheral clock enable register
func (o *RCC_Type) SetAHB3ENR_FMCEN(value uint32) {
	volatile.StoreUint32(&o.AHB3ENR.Reg, volatile.LoadUint32(&o.AHB3ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB3ENR_FMCEN() uint32 {
	return volatile.LoadUint32(&o.AHB3ENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB3ENR_QSPIEN(value uint32) {
	volatile.StoreUint32(&o.AHB3ENR.Reg, volatile.LoadUint32(&o.AHB3ENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB3ENR_QSPIEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3ENR.Reg) & 0x100) >> 8
}

// RCC.APB1ENR1: APB1ENR1
func (o *RCC_Type) SetAPB1ENR1_TIM2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1ENR1_TIM2EN() uint32 {
	return volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x1
}
func (o *RCC_Type) SetAPB1ENR1_TIM3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1ENR1_TIM3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1ENR1_TIM4EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1ENR1_TIM4EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1ENR1_TIM5EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB1ENR1_TIM5EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB1ENR1_TIM6EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB1ENR1_TIM6EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB1ENR1_TIM7EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1ENR1_TIM7EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1ENR1_CRSEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB1ENR1_CRSEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB1ENR1_RTCAPBEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAPB1ENR1_RTCAPBEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetAPB1ENR1_WWDGEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB1ENR1_WWDGEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB1ENR1_SPI2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1ENR1_SPI2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1ENR1_SPI3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB1ENR1_SPI3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB1ENR1_USART2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1ENR1_USART2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1ENR1_USART3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB1ENR1_USART3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB1ENR1_UART4EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAPB1ENR1_UART4EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAPB1ENR1_UART5EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB1ENR1_UART5EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB1ENR1_I2C1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1ENR1_I2C1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1ENR1_I2C2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1ENR1_I2C2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1ENR1_USBEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1ENR1_USBEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1ENR1_FDCANEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAPB1ENR1_FDCANEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAPB1ENR1_PWREN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPB1ENR1_PWREN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPB1ENR1_I2C3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAPB1ENR1_I2C3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAPB1ENR1_LPTIM1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPB1ENR1_LPTIM1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x80000000) >> 31
}

// RCC.APB1ENR2: APB1 peripheral clock enable register 2
func (o *RCC_Type) SetAPB1ENR2_LPUART1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR2.Reg, volatile.LoadUint32(&o.APB1ENR2.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1ENR2_LPUART1EN() uint32 {
	return volatile.LoadUint32(&o.APB1ENR2.Reg) & 0x1
}
func (o *RCC_Type) SetAPB1ENR2_I2C4EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR2.Reg, volatile.LoadUint32(&o.APB1ENR2.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1ENR2_I2C4EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR2.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1ENR2_UCPD1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR2.Reg, volatile.LoadUint32(&o.APB1ENR2.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB1ENR2_UCPD1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR2.Reg) & 0x100) >> 8
}

// RCC.APB2ENR: APB2ENR
func (o *RCC_Type) SetAPB2ENR_SYSCFGEN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB2ENR_SYSCFGEN() uint32 {
	return volatile.LoadUint32(&o.APB2ENR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB2ENR_TIM1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2ENR_TIM1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB2ENR_SPI1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2ENR_SPI1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2ENR_TIM8EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAPB2ENR_TIM8EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAPB2ENR_USART1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2ENR_USART1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2ENR_SPI4EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB2ENR_SPI4EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB2ENR_TIM15EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB2ENR_TIM15EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB2ENR_TIM16EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2ENR_TIM16EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2ENR_TIM17EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2ENR_TIM17EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB2ENR_TIM20EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB2ENR_TIM20EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB2ENR_SAI1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB2ENR_SAI1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB2ENR_HRTIM1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAPB2ENR_HRTIM1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x4000000) >> 26
}

// RCC.AHB1SMENR: AHB1 peripheral clocks enable in Sleep and Stop modes register
func (o *RCC_Type) SetAHB1SMENR_DMA1SMEN(value uint32) {
	volatile.StoreUint32(&o.AHB1SMENR.Reg, volatile.LoadUint32(&o.AHB1SMENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB1SMENR_DMA1SMEN() uint32 {
	return volatile.LoadUint32(&o.AHB1SMENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB1SMENR_DMA2SMEN(value uint32) {
	volatile.StoreUint32(&o.AHB1SMENR.Reg, volatile.LoadUint32(&o.AHB1SMENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB1SMENR_DMA2SMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1SMENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB1SMENR_DMAMUX1SMEN(value uint32) {
	volatile.StoreUint32(&o.AHB1SMENR.Reg, volatile.LoadUint32(&o.AHB1SMENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB1SMENR_DMAMUX1SMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1SMENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB1SMENR_CORDICSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB1SMENR.Reg, volatile.LoadUint32(&o.AHB1SMENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHB1SMENR_CORDICSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1SMENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHB1SMENR_FLASHSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB1SMENR.Reg, volatile.LoadUint32(&o.AHB1SMENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB1SMENR_FLASHSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1SMENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAHB1SMENR_SRAM1SMEN(value uint32) {
	volatile.StoreUint32(&o.AHB1SMENR.Reg, volatile.LoadUint32(&o.AHB1SMENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAHB1SMENR_SRAM1SMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1SMENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAHB1SMENR_CRCSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB1SMENR.Reg, volatile.LoadUint32(&o.AHB1SMENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB1SMENR_CRCSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1SMENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB1SMENR_FMACSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB1SMENR.Reg, volatile.LoadUint32(&o.AHB1SMENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB1SMENR_FMACSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1SMENR.Reg) & 0x10) >> 4
}

// RCC.AHB2SMENR: AHB2 peripheral clocks enable in Sleep and Stop modes register
func (o *RCC_Type) SetAHB2SMENR_GPIOASMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB2SMENR_GPIOASMEN() uint32 {
	return volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB2SMENR_GPIOBSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB2SMENR_GPIOBSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB2SMENR_GPIOCSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB2SMENR_GPIOCSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB2SMENR_GPIODSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHB2SMENR_GPIODSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHB2SMENR_GPIOESMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB2SMENR_GPIOESMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB2SMENR_GPIOFSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB2SMENR_GPIOFSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB2SMENR_GPIOGSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB2SMENR_GPIOGSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB2SMENR_ADC12SMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAHB2SMENR_ADC12SMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAHB2SMENR_ADC345SMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAHB2SMENR_ADC345SMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAHB2SMENR_DAC1SMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB2SMENR_DAC1SMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHB2SMENR_DAC2SMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAHB2SMENR_DAC2SMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAHB2SMENR_DAC3SMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAHB2SMENR_DAC3SMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAHB2SMENR_DAC4SMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAHB2SMENR_DAC4SMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAHB2SMENR_AESMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAHB2SMENR_AESMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAHB2SMENR_RNGEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAHB2SMENR_RNGEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetAHB2SMENR_CCMSRAMSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAHB2SMENR_CCMSRAMSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAHB2SMENR_SRAM2SMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAHB2SMENR_SRAM2SMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x400) >> 10
}

// RCC.AHB3SMENR: AHB3 peripheral clocks enable in Sleep and Stop modes register
func (o *RCC_Type) SetAHB3SMENR_FMCSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB3SMENR.Reg, volatile.LoadUint32(&o.AHB3SMENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB3SMENR_FMCSMEN() uint32 {
	return volatile.LoadUint32(&o.AHB3SMENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB3SMENR_QSPISMEN(value uint32) {
	volatile.StoreUint32(&o.AHB3SMENR.Reg, volatile.LoadUint32(&o.AHB3SMENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB3SMENR_QSPISMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3SMENR.Reg) & 0x100) >> 8
}

// RCC.APB1SMENR1: APB1SMENR1
func (o *RCC_Type) SetAPB1SMENR1_TIM2SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1SMENR1_TIM2SMEN() uint32 {
	return volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x1
}
func (o *RCC_Type) SetAPB1SMENR1_TIM3SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1SMENR1_TIM3SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1SMENR1_TIM4SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1SMENR1_TIM4SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1SMENR1_TIM5SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB1SMENR1_TIM5SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB1SMENR1_TIM6SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB1SMENR1_TIM6SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB1SMENR1_TIM7SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1SMENR1_TIM7SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1SMENR1_CRSSMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB1SMENR1_CRSSMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB1SMENR1_RTCAPBSMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAPB1SMENR1_RTCAPBSMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetAPB1SMENR1_WWDGSMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB1SMENR1_WWDGSMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB1SMENR1_SPI2SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1SMENR1_SPI2SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1SMENR1_SP3SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB1SMENR1_SP3SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB1SMENR1_USART2SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1SMENR1_USART2SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1SMENR1_USART3SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB1SMENR1_USART3SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB1SMENR1_UART4SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAPB1SMENR1_UART4SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAPB1SMENR1_UART5SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB1SMENR1_UART5SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB1SMENR1_I2C1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1SMENR1_I2C1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1SMENR1_I2C2SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1SMENR1_I2C2SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1SMENR1_FDCANSMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAPB1SMENR1_FDCANSMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAPB1SMENR1_PWRSMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPB1SMENR1_PWRSMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPB1SMENR1_LPTIM1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPB1SMENR1_LPTIM1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetAPB1SMENR1_USBSMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1SMENR1_USBSMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1SMENR1_I2C3SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAPB1SMENR1_I2C3SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x40000000) >> 30
}

// RCC.APB1SMENR2: APB1 peripheral clocks enable in Sleep and Stop modes register 2
func (o *RCC_Type) SetAPB1SMENR2_LPUART1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR2.Reg, volatile.LoadUint32(&o.APB1SMENR2.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1SMENR2_LPUART1SMEN() uint32 {
	return volatile.LoadUint32(&o.APB1SMENR2.Reg) & 0x1
}
func (o *RCC_Type) SetAPB1SMENR2_I2C4SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR2.Reg, volatile.LoadUint32(&o.APB1SMENR2.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1SMENR2_I2C4SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR2.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1SMENR2_UCPD1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR2.Reg, volatile.LoadUint32(&o.APB1SMENR2.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB1SMENR2_UCPD1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR2.Reg) & 0x100) >> 8
}

// RCC.APB2SMENR: APB2SMENR
func (o *RCC_Type) SetAPB2SMENR_SYSCFGSMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB2SMENR_SYSCFGSMEN() uint32 {
	return volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB2SMENR_TIM1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2SMENR_TIM1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB2SMENR_SPI1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2SMENR_SPI1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2SMENR_TIM8SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAPB2SMENR_TIM8SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAPB2SMENR_USART1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2SMENR_USART1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2SMENR_SPI4SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB2SMENR_SPI4SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB2SMENR_TIM15SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB2SMENR_TIM15SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB2SMENR_TIM16SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2SMENR_TIM16SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2SMENR_TIM17SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2SMENR_TIM17SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB2SMENR_TIM20SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB2SMENR_TIM20SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB2SMENR_SAI1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB2SMENR_SAI1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB2SMENR_HRTIM1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAPB2SMENR_HRTIM1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x4000000) >> 26
}

// RCC.CCIPR: CCIPR
func (o *RCC_Type) SetCCIPR_ADC345SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc0000000)|value<<30)
}
func (o *RCC_Type) GetCCIPR_ADC345SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc0000000) >> 30
}
func (o *RCC_Type) SetCCIPR_ADC12SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x30000000)|value<<28)
}
func (o *RCC_Type) GetCCIPR_ADC12SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x30000000) >> 28
}
func (o *RCC_Type) SetCCIPR_CLK48SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc000000)|value<<26)
}
func (o *RCC_Type) GetCCIPR_CLK48SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc000000) >> 26
}
func (o *RCC_Type) SetCCIPR_FDCANSEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x3000000)|value<<24)
}
func (o *RCC_Type) GetCCIPR_FDCANSEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x3000000) >> 24
}
func (o *RCC_Type) SetCCIPR_I2S23SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc00000)|value<<22)
}
func (o *RCC_Type) GetCCIPR_I2S23SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc00000) >> 22
}
func (o *RCC_Type) SetCCIPR_SAI1SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x300000)|value<<20)
}
func (o *RCC_Type) GetCCIPR_SAI1SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x300000) >> 20
}
func (o *RCC_Type) SetCCIPR_LPTIM1SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc0000)|value<<18)
}
func (o *RCC_Type) GetCCIPR_LPTIM1SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc0000) >> 18
}
func (o *RCC_Type) SetCCIPR_I2C3SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x30000)|value<<16)
}
func (o *RCC_Type) GetCCIPR_I2C3SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x30000) >> 16
}
func (o *RCC_Type) SetCCIPR_I2C2SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc000)|value<<14)
}
func (o *RCC_Type) GetCCIPR_I2C2SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc000) >> 14
}
func (o *RCC_Type) SetCCIPR_I2C1SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x3000)|value<<12)
}
func (o *RCC_Type) GetCCIPR_I2C1SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x3000) >> 12
}
func (o *RCC_Type) SetCCIPR_LPUART1SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc00)|value<<10)
}
func (o *RCC_Type) GetCCIPR_LPUART1SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc00) >> 10
}
func (o *RCC_Type) SetCCIPR_UART5SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x300)|value<<8)
}
func (o *RCC_Type) GetCCIPR_UART5SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x300) >> 8
}
func (o *RCC_Type) SetCCIPR_UART4SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc0)|value<<6)
}
func (o *RCC_Type) GetCCIPR_UART4SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc0) >> 6
}
func (o *RCC_Type) SetCCIPR_USART3SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x30)|value<<4)
}
func (o *RCC_Type) GetCCIPR_USART3SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x30) >> 4
}
func (o *RCC_Type) SetCCIPR_USART2SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc)|value<<2)
}
func (o *RCC_Type) GetCCIPR_USART2SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc) >> 2
}
func (o *RCC_Type) SetCCIPR_USART1SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x3)|value)
}
func (o *RCC_Type) GetCCIPR_USART1SEL() uint32 {
	return volatile.LoadUint32(&o.CCIPR.Reg) & 0x3
}

// RCC.BDCR: BDCR
func (o *RCC_Type) SetBDCR_LSCOSEL(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetBDCR_LSCOSEL() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetBDCR_LSCOEN(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetBDCR_LSCOEN() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetBDCR_BDRST(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetBDCR_BDRST() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetBDCR_RTCEN(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetBDCR_RTCEN() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetBDCR_RTCSEL(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x300)|value<<8)
}
func (o *RCC_Type) GetBDCR_RTCSEL() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x300) >> 8
}
func (o *RCC_Type) SetBDCR_LSECSSD(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetBDCR_LSECSSD() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetBDCR_LSECSSON(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetBDCR_LSECSSON() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetBDCR_LSEDRV(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x18)|value<<3)
}
func (o *RCC_Type) GetBDCR_LSEDRV() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x18) >> 3
}
func (o *RCC_Type) SetBDCR_LSEBYP(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetBDCR_LSEBYP() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetBDCR_LSERDY(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetBDCR_LSERDY() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetBDCR_LSEON(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetBDCR_LSEON() uint32 {
	return volatile.LoadUint32(&o.BDCR.Reg) & 0x1
}

// RCC.CSR: CSR
func (o *RCC_Type) SetCSR_LPWRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetCSR_LPWRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetCSR_WWDGRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetCSR_WWDGRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetCSR_IWDGRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetCSR_IWDGRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetCSR_SFTRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetCSR_SFTRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetCSR_BORRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetCSR_BORRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetCSR_PINRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetCSR_PINRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetCSR_OBLRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetCSR_OBLRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetCSR_RMVF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetCSR_RMVF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetCSR_LSIRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCSR_LSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCSR_LSION(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCSR_LSION() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}

// RCC.CRRCR: Clock recovery RC register
func (o *RCC_Type) SetCRRCR_HSI48ON(value uint32) {
	volatile.StoreUint32(&o.CRRCR.Reg, volatile.LoadUint32(&o.CRRCR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCRRCR_HSI48ON() uint32 {
	return volatile.LoadUint32(&o.CRRCR.Reg) & 0x1
}
func (o *RCC_Type) SetCRRCR_HSI48RDY(value uint32) {
	volatile.StoreUint32(&o.CRRCR.Reg, volatile.LoadUint32(&o.CRRCR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCRRCR_HSI48RDY() uint32 {
	return (volatile.LoadUint32(&o.CRRCR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCRRCR_HSI48CAL(value uint32) {
	volatile.StoreUint32(&o.CRRCR.Reg, volatile.LoadUint32(&o.CRRCR.Reg)&^(0xff80)|value<<7)
}
func (o *RCC_Type) GetCRRCR_HSI48CAL() uint32 {
	return (volatile.LoadUint32(&o.CRRCR.Reg) & 0xff80) >> 7
}

// RCC.CCIPR2: Peripherals independent clock configuration register
func (o *RCC_Type) SetCCIPR2_I2C4SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR2.Reg, volatile.LoadUint32(&o.CCIPR2.Reg)&^(0x3)|value)
}
func (o *RCC_Type) GetCCIPR2_I2C4SEL() uint32 {
	return volatile.LoadUint32(&o.CCIPR2.Reg) & 0x3
}
func (o *RCC_Type) SetCCIPR2_QSPISEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR2.Reg, volatile.LoadUint32(&o.CCIPR2.Reg)&^(0x300000)|value<<20)
}
func (o *RCC_Type) GetCCIPR2_QSPISEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR2.Reg) & 0x300000) >> 20
}

// Power control
type PWR_Type struct {
	CR1   volatile.Register32 // 0x0
	CR2   volatile.Register32 // 0x4
	CR3   volatile.Register32 // 0x8
	CR4   volatile.Register32 // 0xC
	SR1   volatile.Register32 // 0x10
	SR2   volatile.Register32 // 0x14
	SCR   volatile.Register32 // 0x18
	_     [4]byte
	PUCRA volatile.Register32 // 0x20
	PDCRA volatile.Register32 // 0x24
	PUCRB volatile.Register32 // 0x28
	PDCRB volatile.Register32 // 0x2C
	PUCRC volatile.Register32 // 0x30
	PDCRC volatile.Register32 // 0x34
	PUCRD volatile.Register32 // 0x38
	PDCRD volatile.Register32 // 0x3C
	PUCRE volatile.Register32 // 0x40
	PDCRE volatile.Register32 // 0x44
	PUCRF volatile.Register32 // 0x48
	PDCRF volatile.Register32 // 0x4C
	PUCRG volatile.Register32 // 0x50
	PDCRG volatile.Register32 // 0x54
	_     [40]byte
	CR5   volatile.Register32 // 0x80
}

// PWR.CR1: Power control register 1
func (o *PWR_Type) SetCR1_LPR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetCR1_LPR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetCR1_VOS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x600)|value<<9)
}
func (o *PWR_Type) GetCR1_VOS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x600) >> 9
}
func (o *PWR_Type) SetCR1_DBP(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCR1_DBP() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCR1_LPMS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x7)|value)
}
func (o *PWR_Type) GetCR1_LPMS() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x7
}

// PWR.CR2: Power control register 2
func (o *PWR_Type) SetCR2_PVMEN1(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCR2_PVMEN1() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCR2_PLS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xe)|value<<1)
}
func (o *PWR_Type) GetCR2_PLS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xe) >> 1
}
func (o *PWR_Type) SetCR2_PVDE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR2_PVDE() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}
func (o *PWR_Type) SetCR2_PVMEN2(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetCR2_PVMEN2() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetCR2_PVMEN3(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetCR2_PVMEN3() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetCR2_PVMEN4(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetCR2_PVMEN4() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80) >> 7
}

// PWR.CR3: Power control register 3
func (o *PWR_Type) SetCR3_EWUP1(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR3_EWUP1() uint32 {
	return volatile.LoadUint32(&o.CR3.Reg) & 0x1
}
func (o *PWR_Type) SetCR3_EWUP2(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCR3_EWUP2() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCR3_EWUP3(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetCR3_EWUP3() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetCR3_EWUP4(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetCR3_EWUP4() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetCR3_EWUP5(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCR3_EWUP5() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCR3_RRS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCR3_RRS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCR3_APC(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetCR3_APC() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetCR3_UCPD1_STDBY(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetCR3_UCPD1_STDBY() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetCR3_UCPD1_DBDIS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetCR3_UCPD1_DBDIS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetCR3_EIWUL(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetCR3_EIWUL() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8000) >> 15
}

// PWR.CR4: Power control register 4
func (o *PWR_Type) SetCR4_VBRS(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCR4_VBRS() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCR4_VBE(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCR4_VBE() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCR4_WP5(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCR4_WP5() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCR4_WP4(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetCR4_WP4() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetCR4_WP3(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetCR4_WP3() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetCR4_WP2(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCR4_WP2() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCR4_WP1(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR4_WP1() uint32 {
	return volatile.LoadUint32(&o.CR4.Reg) & 0x1
}

// PWR.SR1: Power status register 1
func (o *PWR_Type) SetSR1_WUFI(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetSR1_WUFI() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetSR1_SBF(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetSR1_SBF() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetSR1_WUF5(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetSR1_WUF5() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetSR1_WUF4(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetSR1_WUF4() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetSR1_WUF3(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetSR1_WUF3() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetSR1_WUF2(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetSR1_WUF2() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetSR1_WUF1(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetSR1_WUF1() uint32 {
	return volatile.LoadUint32(&o.SR1.Reg) & 0x1
}

// PWR.SR2: Power status register 2
func (o *PWR_Type) SetSR2_PVMO4(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetSR2_PVMO4() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetSR2_PVMO3(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetSR2_PVMO3() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetSR2_PVMO2(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetSR2_PVMO2() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetSR2_PVMO1(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetSR2_PVMO1() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetSR2_PVDO(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetSR2_PVDO() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetSR2_VOSF(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetSR2_VOSF() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetSR2_REGLPF(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetSR2_REGLPF() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetSR2_REGLPS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetSR2_REGLPS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x100) >> 8
}

// PWR.SCR: Power status clear register
func (o *PWR_Type) SetSCR_CSBF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetSCR_CSBF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetSCR_CWUF5(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetSCR_CWUF5() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetSCR_CWUF4(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetSCR_CWUF4() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetSCR_CWUF3(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetSCR_CWUF3() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetSCR_CWUF2(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetSCR_CWUF2() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetSCR_CWUF1(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetSCR_CWUF1() uint32 {
	return volatile.LoadUint32(&o.SCR.Reg) & 0x1
}

// PWR.PUCRA: Power Port A pull-up control register
func (o *PWR_Type) SetPUCRA_PU15(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPUCRA_PU15() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPUCRA_PU13(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPUCRA_PU13() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPUCRA_PU12(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPUCRA_PU12() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPUCRA_PU11(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPUCRA_PU11() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPUCRA_PU10(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPUCRA_PU10() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPUCRA_PU9(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPUCRA_PU9() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPUCRA_PU8(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPUCRA_PU8() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPUCRA_PU7(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPUCRA_PU7() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPUCRA_PU6(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPUCRA_PU6() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPUCRA_PU5(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPUCRA_PU5() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPUCRA_PU4(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPUCRA_PU4() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPUCRA_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRA_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPUCRA_PU2(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPUCRA_PU2() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPUCRA_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRA_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRA_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRA_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRA.Reg) & 0x1
}

// PWR.PDCRA: Power Port A pull-down control register
func (o *PWR_Type) SetPDCRA_PD14(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPDCRA_PD14() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPDCRA_PD12(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPDCRA_PD12() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPDCRA_PD11(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPDCRA_PD11() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPDCRA_PD10(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPDCRA_PD10() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPDCRA_PD9(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPDCRA_PD9() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPDCRA_PD8(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPDCRA_PD8() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPDCRA_PD7(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPDCRA_PD7() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPDCRA_PD6(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPDCRA_PD6() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPDCRA_PD5(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPDCRA_PD5() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPDCRA_PD4(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPDCRA_PD4() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPDCRA_PD3(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPDCRA_PD3() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPDCRA_PD2(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPDCRA_PD2() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPDCRA_PD1(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPDCRA_PD1() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPDCRA_PD0(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPDCRA_PD0() uint32 {
	return volatile.LoadUint32(&o.PDCRA.Reg) & 0x1
}

// PWR.PUCRB: Power Port B pull-up control register
func (o *PWR_Type) SetPUCRB_PU15(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPUCRB_PU15() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPUCRB_PU14(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPUCRB_PU14() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPUCRB_PU13(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPUCRB_PU13() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPUCRB_PU12(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPUCRB_PU12() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPUCRB_PU11(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPUCRB_PU11() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPUCRB_PU10(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPUCRB_PU10() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPUCRB_PU9(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPUCRB_PU9() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPUCRB_PU8(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPUCRB_PU8() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPUCRB_PU7(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPUCRB_PU7() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPUCRB_PU6(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPUCRB_PU6() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPUCRB_PU5(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPUCRB_PU5() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPUCRB_PU4(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPUCRB_PU4() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPUCRB_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRB_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPUCRB_PU2(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPUCRB_PU2() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPUCRB_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRB_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRB_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRB_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRB.Reg) & 0x1
}

// PWR.PDCRB: Power Port B pull-down control register
func (o *PWR_Type) SetPDCRB_PD15(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPDCRB_PD15() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPDCRB_PD14(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPDCRB_PD14() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPDCRB_PD13(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPDCRB_PD13() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPDCRB_PD12(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPDCRB_PD12() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPDCRB_PD11(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPDCRB_PD11() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPDCRB_PD10(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPDCRB_PD10() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPDCRB_PD9(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPDCRB_PD9() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPDCRB_PD8(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPDCRB_PD8() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPDCRB_PD7(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPDCRB_PD7() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPDCRB_PD6(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPDCRB_PD6() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPDCRB_PD5(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPDCRB_PD5() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPDCRB_PD3(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPDCRB_PD3() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPDCRB_PD2(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPDCRB_PD2() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPDCRB_PD1(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPDCRB_PD1() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPDCRB_PD0(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPDCRB_PD0() uint32 {
	return volatile.LoadUint32(&o.PDCRB.Reg) & 0x1
}

// PWR.PUCRC: Power Port C pull-up control register
func (o *PWR_Type) SetPUCRC_PU15(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPUCRC_PU15() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPUCRC_PU14(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPUCRC_PU14() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPUCRC_PU13(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPUCRC_PU13() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPUCRC_PU12(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPUCRC_PU12() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPUCRC_PU11(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPUCRC_PU11() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPUCRC_PU10(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPUCRC_PU10() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPUCRC_PU9(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPUCRC_PU9() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPUCRC_PU8(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPUCRC_PU8() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPUCRC_PU7(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPUCRC_PU7() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPUCRC_PU6(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPUCRC_PU6() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPUCRC_PU5(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPUCRC_PU5() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPUCRC_PU4(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPUCRC_PU4() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPUCRC_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRC_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPUCRC_PU2(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPUCRC_PU2() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPUCRC_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRC_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRC_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRC_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRC.Reg) & 0x1
}

// PWR.PDCRC: Power Port C pull-down control register
func (o *PWR_Type) SetPDCRC_PD15(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPDCRC_PD15() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPDCRC_PD14(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPDCRC_PD14() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPDCRC_PD13(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPDCRC_PD13() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPDCRC_PD12(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPDCRC_PD12() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPDCRC_PD11(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPDCRC_PD11() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPDCRC_PD10(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPDCRC_PD10() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPDCRC_PD9(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPDCRC_PD9() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPDCRC_PD8(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPDCRC_PD8() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPDCRC_PD7(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPDCRC_PD7() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPDCRC_PD6(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPDCRC_PD6() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPDCRC_PD5(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPDCRC_PD5() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPDCRC_PD4(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPDCRC_PD4() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPDCRC_PD3(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPDCRC_PD3() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPDCRC_PD2(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPDCRC_PD2() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPDCRC_PD1(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPDCRC_PD1() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPDCRC_PD0(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPDCRC_PD0() uint32 {
	return volatile.LoadUint32(&o.PDCRC.Reg) & 0x1
}

// PWR.PUCRD: Power Port D pull-up control register
func (o *PWR_Type) SetPUCRD_PU15(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPUCRD_PU15() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPUCRD_PU14(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPUCRD_PU14() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPUCRD_PU13(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPUCRD_PU13() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPUCRD_PU12(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPUCRD_PU12() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPUCRD_PU11(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPUCRD_PU11() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPUCRD_PU10(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPUCRD_PU10() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPUCRD_PU9(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPUCRD_PU9() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPUCRD_PU8(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPUCRD_PU8() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPUCRD_PU7(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPUCRD_PU7() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPUCRD_PU6(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPUCRD_PU6() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPUCRD_PU5(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPUCRD_PU5() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPUCRD_PU4(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPUCRD_PU4() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPUCRD_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRD_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPUCRD_PU2(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPUCRD_PU2() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPUCRD_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRD_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRD_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRD_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRD.Reg) & 0x1
}

// PWR.PDCRD: Power Port D pull-down control register
func (o *PWR_Type) SetPDCRD_PD15(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPDCRD_PD15() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPDCRD_PD14(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPDCRD_PD14() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPDCRD_PD13(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPDCRD_PD13() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPDCRD_PD12(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPDCRD_PD12() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPDCRD_PD11(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPDCRD_PD11() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPDCRD_PD10(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPDCRD_PD10() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPDCRD_PD9(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPDCRD_PD9() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPDCRD_PD8(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPDCRD_PD8() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPDCRD_PD7(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPDCRD_PD7() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPDCRD_PD6(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPDCRD_PD6() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPDCRD_PD5(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPDCRD_PD5() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPDCRD_PD4(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPDCRD_PD4() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPDCRD_PD3(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPDCRD_PD3() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPDCRD_PD2(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPDCRD_PD2() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPDCRD_PD1(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPDCRD_PD1() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPDCRD_PD0(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPDCRD_PD0() uint32 {
	return volatile.LoadUint32(&o.PDCRD.Reg) & 0x1
}

// PWR.PUCRE: Power Port E pull-up control register
func (o *PWR_Type) SetPUCRE_PU15(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPUCRE_PU15() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPUCRE_PU14(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPUCRE_PU14() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPUCRE_PU13(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPUCRE_PU13() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPUCRE_PU12(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPUCRE_PU12() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPUCRE_PU11(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPUCRE_PU11() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPUCRE_PU10(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPUCRE_PU10() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPUCRE_PU9(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPUCRE_PU9() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPUCRE_PU8(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPUCRE_PU8() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPUCRE_PU7(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPUCRE_PU7() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPUCRE_PU6(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPUCRE_PU6() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPUCRE_PU5(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPUCRE_PU5() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPUCRE_PU4(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPUCRE_PU4() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPUCRE_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRE_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPUCRE_PU2(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPUCRE_PU2() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPUCRE_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRE_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRE_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRE_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRE.Reg) & 0x1
}

// PWR.PDCRE: Power Port E pull-down control register
func (o *PWR_Type) SetPDCRE_PD15(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPDCRE_PD15() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPDCRE_PD14(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPDCRE_PD14() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPDCRE_PD13(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPDCRE_PD13() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPDCRE_PD12(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPDCRE_PD12() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPDCRE_PD11(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPDCRE_PD11() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPDCRE_PD10(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPDCRE_PD10() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPDCRE_PD9(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPDCRE_PD9() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPDCRE_PD8(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPDCRE_PD8() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPDCRE_PD7(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPDCRE_PD7() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPDCRE_PD6(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPDCRE_PD6() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPDCRE_PD5(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPDCRE_PD5() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPDCRE_PD4(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPDCRE_PD4() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPDCRE_PD3(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPDCRE_PD3() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPDCRE_PD2(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPDCRE_PD2() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPDCRE_PD1(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPDCRE_PD1() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPDCRE_PD0(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPDCRE_PD0() uint32 {
	return volatile.LoadUint32(&o.PDCRE.Reg) & 0x1
}

// PWR.PUCRF: Power Port F pull-up control register
func (o *PWR_Type) SetPUCRF_PU15(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPUCRF_PU15() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPUCRF_PU14(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPUCRF_PU14() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPUCRF_PU13(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPUCRF_PU13() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPUCRF_PU12(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPUCRF_PU12() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPUCRF_PU11(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPUCRF_PU11() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPUCRF_PU10(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPUCRF_PU10() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPUCRF_PU9(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPUCRF_PU9() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPUCRF_PU8(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPUCRF_PU8() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPUCRF_PU7(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPUCRF_PU7() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPUCRF_PU6(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPUCRF_PU6() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPUCRF_PU5(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPUCRF_PU5() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPUCRF_PU4(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPUCRF_PU4() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPUCRF_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRF_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPUCRF_PU2(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPUCRF_PU2() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPUCRF_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRF_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRF_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRF_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRF.Reg) & 0x1
}

// PWR.PDCRF: Power Port F pull-down control register
func (o *PWR_Type) SetPDCRF_PD15(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPDCRF_PD15() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPDCRF_PD14(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPDCRF_PD14() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPDCRF_PD13(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPDCRF_PD13() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPDCRF_PD12(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPDCRF_PD12() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPDCRF_PD11(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPDCRF_PD11() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPDCRF_PD10(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPDCRF_PD10() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPDCRF_PD9(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPDCRF_PD9() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPDCRF_PD8(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPDCRF_PD8() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPDCRF_PD7(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPDCRF_PD7() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPDCRF_PD6(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPDCRF_PD6() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPDCRF_PD5(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPDCRF_PD5() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPDCRF_PD4(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPDCRF_PD4() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPDCRF_PD3(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPDCRF_PD3() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPDCRF_PD2(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPDCRF_PD2() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPDCRF_PD1(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPDCRF_PD1() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPDCRF_PD0(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPDCRF_PD0() uint32 {
	return volatile.LoadUint32(&o.PDCRF.Reg) & 0x1
}

// PWR.PUCRG: Power Port G pull-up control register
func (o *PWR_Type) SetPUCRG_PU10(value uint32) {
	volatile.StoreUint32(&o.PUCRG.Reg, volatile.LoadUint32(&o.PUCRG.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPUCRG_PU10() uint32 {
	return (volatile.LoadUint32(&o.PUCRG.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPUCRG_PU9(value uint32) {
	volatile.StoreUint32(&o.PUCRG.Reg, volatile.LoadUint32(&o.PUCRG.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPUCRG_PU9() uint32 {
	return (volatile.LoadUint32(&o.PUCRG.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPUCRG_PU8(value uint32) {
	volatile.StoreUint32(&o.PUCRG.Reg, volatile.LoadUint32(&o.PUCRG.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPUCRG_PU8() uint32 {
	return (volatile.LoadUint32(&o.PUCRG.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPUCRG_PU7(value uint32) {
	volatile.StoreUint32(&o.PUCRG.Reg, volatile.LoadUint32(&o.PUCRG.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPUCRG_PU7() uint32 {
	return (volatile.LoadUint32(&o.PUCRG.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPUCRG_PU6(value uint32) {
	volatile.StoreUint32(&o.PUCRG.Reg, volatile.LoadUint32(&o.PUCRG.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPUCRG_PU6() uint32 {
	return (volatile.LoadUint32(&o.PUCRG.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPUCRG_PU5(value uint32) {
	volatile.StoreUint32(&o.PUCRG.Reg, volatile.LoadUint32(&o.PUCRG.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPUCRG_PU5() uint32 {
	return (volatile.LoadUint32(&o.PUCRG.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPUCRG_PU4(value uint32) {
	volatile.StoreUint32(&o.PUCRG.Reg, volatile.LoadUint32(&o.PUCRG.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPUCRG_PU4() uint32 {
	return (volatile.LoadUint32(&o.PUCRG.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPUCRG_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRG.Reg, volatile.LoadUint32(&o.PUCRG.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRG_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRG.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPUCRG_PU2(value uint32) {
	volatile.StoreUint32(&o.PUCRG.Reg, volatile.LoadUint32(&o.PUCRG.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPUCRG_PU2() uint32 {
	return (volatile.LoadUint32(&o.PUCRG.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPUCRG_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRG.Reg, volatile.LoadUint32(&o.PUCRG.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRG_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRG.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRG_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRG.Reg, volatile.LoadUint32(&o.PUCRG.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRG_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRG.Reg) & 0x1
}

// PWR.PDCRG: Power Port G pull-down control register
func (o *PWR_Type) SetPDCRG_PD10(value uint32) {
	volatile.StoreUint32(&o.PDCRG.Reg, volatile.LoadUint32(&o.PDCRG.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPDCRG_PD10() uint32 {
	return (volatile.LoadUint32(&o.PDCRG.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPDCRG_PD9(value uint32) {
	volatile.StoreUint32(&o.PDCRG.Reg, volatile.LoadUint32(&o.PDCRG.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPDCRG_PD9() uint32 {
	return (volatile.LoadUint32(&o.PDCRG.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPDCRG_PD8(value uint32) {
	volatile.StoreUint32(&o.PDCRG.Reg, volatile.LoadUint32(&o.PDCRG.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPDCRG_PD8() uint32 {
	return (volatile.LoadUint32(&o.PDCRG.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPDCRG_PD7(value uint32) {
	volatile.StoreUint32(&o.PDCRG.Reg, volatile.LoadUint32(&o.PDCRG.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPDCRG_PD7() uint32 {
	return (volatile.LoadUint32(&o.PDCRG.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPDCRG_PD6(value uint32) {
	volatile.StoreUint32(&o.PDCRG.Reg, volatile.LoadUint32(&o.PDCRG.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPDCRG_PD6() uint32 {
	return (volatile.LoadUint32(&o.PDCRG.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPDCRG_PD5(value uint32) {
	volatile.StoreUint32(&o.PDCRG.Reg, volatile.LoadUint32(&o.PDCRG.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPDCRG_PD5() uint32 {
	return (volatile.LoadUint32(&o.PDCRG.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPDCRG_PD4(value uint32) {
	volatile.StoreUint32(&o.PDCRG.Reg, volatile.LoadUint32(&o.PDCRG.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPDCRG_PD4() uint32 {
	return (volatile.LoadUint32(&o.PDCRG.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPDCRG_PD3(value uint32) {
	volatile.StoreUint32(&o.PDCRG.Reg, volatile.LoadUint32(&o.PDCRG.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPDCRG_PD3() uint32 {
	return (volatile.LoadUint32(&o.PDCRG.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPDCRG_PD2(value uint32) {
	volatile.StoreUint32(&o.PDCRG.Reg, volatile.LoadUint32(&o.PDCRG.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPDCRG_PD2() uint32 {
	return (volatile.LoadUint32(&o.PDCRG.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPDCRG_PD1(value uint32) {
	volatile.StoreUint32(&o.PDCRG.Reg, volatile.LoadUint32(&o.PDCRG.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPDCRG_PD1() uint32 {
	return (volatile.LoadUint32(&o.PDCRG.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPDCRG_PD0(value uint32) {
	volatile.StoreUint32(&o.PDCRG.Reg, volatile.LoadUint32(&o.PDCRG.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPDCRG_PD0() uint32 {
	return volatile.LoadUint32(&o.PDCRG.Reg) & 0x1
}

// PWR.CR5: Power control register 5
func (o *PWR_Type) SetCR5_R1MODE(value uint32) {
	volatile.StoreUint32(&o.CR5.Reg, volatile.LoadUint32(&o.CR5.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR5_R1MODE() uint32 {
	return volatile.LoadUint32(&o.CR5.Reg) & 0x1
}

// Random number generator
type RNG_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	DR volatile.Register32 // 0x8
}

// RNG.CR: control register
func (o *RNG_Type) SetCR_CED(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *RNG_Type) GetCR_CED() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *RNG_Type) SetCR_IE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RNG_Type) GetCR_IE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RNG_Type) SetCR_RNGEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *RNG_Type) GetCR_RNGEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}

// RNG.SR: status register
func (o *RNG_Type) SetSR_SEIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *RNG_Type) GetSR_SEIS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *RNG_Type) SetSR_CEIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *RNG_Type) GetSR_CEIS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *RNG_Type) SetSR_SECS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *RNG_Type) GetSR_SECS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *RNG_Type) SetSR_CECS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *RNG_Type) GetSR_CECS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *RNG_Type) SetSR_DRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *RNG_Type) GetSR_DRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// RNG.DR: data register
func (o *RNG_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *RNG_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// General-purpose I/Os
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
	BRR     volatile.Register32 // 0x28
}

// GPIO.MODER: GPIO port mode register
func (o *GPIO_Type) SetMODER_MODER15(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetMODER_MODER15() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetMODER_MODER14(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetMODER_MODER14() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetMODER_MODER13(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetMODER_MODER13() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetMODER_MODER12(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetMODER_MODER12() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetMODER_MODER11(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetMODER_MODER11() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetMODER_MODER10(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetMODER_MODER10() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetMODER_MODER9(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetMODER_MODER9() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetMODER_MODER8(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetMODER_MODER8() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetMODER_MODER7(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetMODER_MODER7() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetMODER_MODER6(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetMODER_MODER6() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetMODER_MODER5(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetMODER_MODER5() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetMODER_MODER4(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetMODER_MODER4() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetMODER_MODER3(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetMODER_MODER3() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetMODER_MODER2(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetMODER_MODER2() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetMODER_MODER1(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetMODER_MODER1() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetMODER_MODER0(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetMODER_MODER0() uint32 {
	return volatile.LoadUint32(&o.MODER.Reg) & 0x3
}

// GPIO.OTYPER: GPIO port output type register
func (o *GPIO_Type) SetOTYPER_OT15(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetOTYPER_OT15() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetOTYPER_OT14(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetOTYPER_OT14() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetOTYPER_OT13(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetOTYPER_OT13() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetOTYPER_OT12(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetOTYPER_OT12() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetOTYPER_OT11(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetOTYPER_OT11() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetOTYPER_OT10(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetOTYPER_OT10() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetOTYPER_OT9(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetOTYPER_OT9() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetOTYPER_OT8(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetOTYPER_OT8() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetOTYPER_OT7(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetOTYPER_OT7() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetOTYPER_OT6(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetOTYPER_OT6() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetOTYPER_OT5(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetOTYPER_OT5() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetOTYPER_OT4(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetOTYPER_OT4() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetOTYPER_OT3(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetOTYPER_OT3() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetOTYPER_OT2(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetOTYPER_OT2() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetOTYPER_OT1(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetOTYPER_OT1() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetOTYPER_OT0(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetOTYPER_OT0() uint32 {
	return volatile.LoadUint32(&o.OTYPER.Reg) & 0x1
}

// GPIO.OSPEEDR: GPIO port output speed register
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR15(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR15() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR14(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR14() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR13(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR13() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR12(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR12() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR11(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR11() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR10(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR10() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR9(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR9() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR8(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR8() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR7(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR7() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR6(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR6() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR5(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR5() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR4(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR4() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR3(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR3() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR2(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR2() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR1(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR1() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR0(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR0() uint32 {
	return volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3
}

// GPIO.PUPDR: GPIO port pull-up/pull-down register
func (o *GPIO_Type) SetPUPDR_PUPDR15(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetPUPDR_PUPDR15() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetPUPDR_PUPDR14(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetPUPDR_PUPDR14() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetPUPDR_PUPDR13(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetPUPDR_PUPDR13() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetPUPDR_PUPDR12(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetPUPDR_PUPDR12() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetPUPDR_PUPDR11(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetPUPDR_PUPDR11() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetPUPDR_PUPDR10(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetPUPDR_PUPDR10() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetPUPDR_PUPDR9(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetPUPDR_PUPDR9() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetPUPDR_PUPDR8(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetPUPDR_PUPDR8() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetPUPDR_PUPDR7(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetPUPDR_PUPDR7() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetPUPDR_PUPDR6(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetPUPDR_PUPDR6() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetPUPDR_PUPDR5(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetPUPDR_PUPDR5() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetPUPDR_PUPDR4(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetPUPDR_PUPDR4() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetPUPDR_PUPDR3(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetPUPDR_PUPDR3() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetPUPDR_PUPDR2(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetPUPDR_PUPDR2() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetPUPDR_PUPDR1(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetPUPDR_PUPDR1() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetPUPDR_PUPDR0(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPUPDR_PUPDR0() uint32 {
	return volatile.LoadUint32(&o.PUPDR.Reg) & 0x3
}

// GPIO.IDR: GPIO port input data register
func (o *GPIO_Type) SetIDR_IDR15(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetIDR_IDR15() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetIDR_IDR14(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetIDR_IDR14() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetIDR_IDR13(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetIDR_IDR13() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetIDR_IDR12(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetIDR_IDR12() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetIDR_IDR11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetIDR_IDR11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetIDR_IDR10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetIDR_IDR10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetIDR_IDR9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetIDR_IDR9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetIDR_IDR8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetIDR_IDR8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetIDR_IDR7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetIDR_IDR7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetIDR_IDR6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetIDR_IDR6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetIDR_IDR5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetIDR_IDR5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetIDR_IDR4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetIDR_IDR4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetIDR_IDR3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetIDR_IDR3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetIDR_IDR2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetIDR_IDR2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetIDR_IDR1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetIDR_IDR1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetIDR_IDR0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetIDR_IDR0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}

// GPIO.ODR: GPIO port output data register
func (o *GPIO_Type) SetODR_ODR15(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetODR_ODR15() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetODR_ODR14(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetODR_ODR14() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetODR_ODR13(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetODR_ODR13() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetODR_ODR12(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetODR_ODR12() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetODR_ODR11(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetODR_ODR11() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetODR_ODR10(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetODR_ODR10() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetODR_ODR9(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetODR_ODR9() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetODR_ODR8(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetODR_ODR8() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetODR_ODR7(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetODR_ODR7() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetODR_ODR6(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetODR_ODR6() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetODR_ODR5(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetODR_ODR5() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetODR_ODR4(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetODR_ODR4() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetODR_ODR3(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetODR_ODR3() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetODR_ODR2(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetODR_ODR2() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetODR_ODR1(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetODR_ODR1() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetODR_ODR0(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetODR_ODR0() uint32 {
	return volatile.LoadUint32(&o.ODR.Reg) & 0x1
}

// GPIO.BSRR: GPIO port bit set/reset register
func (o *GPIO_Type) SetBSRR_BR15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetBSRR_BR15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000000) >> 31
}
func (o *GPIO_Type) SetBSRR_BR14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetBSRR_BR14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetBSRR_BR13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetBSRR_BR13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetBSRR_BR12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetBSRR_BR12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetBSRR_BR11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetBSRR_BR11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetBSRR_BR10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetBSRR_BR10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetBSRR_BR9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetBSRR_BR9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetBSRR_BR8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetBSRR_BR8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetBSRR_BR7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetBSRR_BR7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetBSRR_BR6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetBSRR_BR6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetBSRR_BR5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetBSRR_BR5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetBSRR_BR4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetBSRR_BR4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetBSRR_BR3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetBSRR_BR3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetBSRR_BR2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetBSRR_BR2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetBSRR_BR1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetBSRR_BR1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetBSRR_BR0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetBSRR_BR0() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetBSRR_BS15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetBSRR_BS15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetBSRR_BS14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetBSRR_BS14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetBSRR_BS13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetBSRR_BS13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetBSRR_BS12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetBSRR_BS12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetBSRR_BS11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetBSRR_BS11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetBSRR_BS10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetBSRR_BS10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetBSRR_BS9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetBSRR_BS9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetBSRR_BS8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetBSRR_BS8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetBSRR_BS7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetBSRR_BS7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetBSRR_BS6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetBSRR_BS6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetBSRR_BS5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetBSRR_BS5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetBSRR_BS4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetBSRR_BS4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetBSRR_BS3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetBSRR_BS3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetBSRR_BS2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetBSRR_BS2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetBSRR_BS1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetBSRR_BS1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetBSRR_BS0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetBSRR_BS0() uint32 {
	return volatile.LoadUint32(&o.BSRR.Reg) & 0x1
}

// GPIO.LCKR: GPIO port configuration lock register
func (o *GPIO_Type) SetLCKR_LCKK(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetLCKR_LCKK() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetLCKR_LCK15(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetLCKR_LCK15() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetLCKR_LCK14(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetLCKR_LCK14() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetLCKR_LCK13(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetLCKR_LCK13() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetLCKR_LCK12(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetLCKR_LCK12() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetLCKR_LCK11(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetLCKR_LCK11() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetLCKR_LCK10(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetLCKR_LCK10() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetLCKR_LCK9(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetLCKR_LCK9() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetLCKR_LCK8(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetLCKR_LCK8() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetLCKR_LCK7(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetLCKR_LCK7() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetLCKR_LCK6(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetLCKR_LCK6() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetLCKR_LCK5(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetLCKR_LCK5() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetLCKR_LCK4(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetLCKR_LCK4() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetLCKR_LCK3(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetLCKR_LCK3() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetLCKR_LCK2(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetLCKR_LCK2() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetLCKR_LCK1(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetLCKR_LCK1() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetLCKR_LCK0(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetLCKR_LCK0() uint32 {
	return volatile.LoadUint32(&o.LCKR.Reg) & 0x1
}

// GPIO.AFRL: GPIO alternate function low register
func (o *GPIO_Type) SetAFRL_AFRL7(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRL_AFRL7() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000000) >> 28
}
func (o *GPIO_Type) SetAFRL_AFRL6(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRL_AFRL6() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRL_AFRL5(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRL_AFRL5() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRL_AFRL4(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRL_AFRL4() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRL_AFRL3(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRL_AFRL3() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRL_AFRL2(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRL_AFRL2() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRL_AFRL1(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRL_AFRL1() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRL_AFRL0(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRL_AFRL0() uint32 {
	return volatile.LoadUint32(&o.AFRL.Reg) & 0xf
}

// GPIO.AFRH: GPIO alternate function high register
func (o *GPIO_Type) SetAFRH_AFRH15(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRH_AFRH15() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000000) >> 28
}
func (o *GPIO_Type) SetAFRH_AFRH14(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRH_AFRH14() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRH_AFRH13(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRH_AFRH13() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRH_AFRH12(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRH_AFRH12() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRH_AFRH11(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRH_AFRH11() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRH_AFRH10(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRH_AFRH10() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRH_AFRH9(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRH_AFRH9() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRH_AFRH8(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRH_AFRH8() uint32 {
	return volatile.LoadUint32(&o.AFRH.Reg) & 0xf
}

// GPIO.BRR: GPIO port bit reset register
func (o *GPIO_Type) SetBRR_BR0(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetBRR_BR0() uint32 {
	return volatile.LoadUint32(&o.BRR.Reg) & 0x1
}
func (o *GPIO_Type) SetBRR_BR1(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetBRR_BR1() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetBRR_BR2(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetBRR_BR2() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetBRR_BR3(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetBRR_BR3() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetBRR_BR4(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetBRR_BR4() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetBRR_BR5(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetBRR_BR5() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetBRR_BR6(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetBRR_BR6() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetBRR_BR7(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetBRR_BR7() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetBRR_BR8(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetBRR_BR8() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetBRR_BR9(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetBRR_BR9() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetBRR_BR10(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetBRR_BR10() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetBRR_BR11(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetBRR_BR11() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetBRR_BR12(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetBRR_BR12() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetBRR_BR13(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetBRR_BR13() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetBRR_BR14(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetBRR_BR14() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetBRR_BR15(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetBRR_BR15() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x8000) >> 15
}

// General purpose timers
type TIM_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	SMCR         volatile.Register32 // 0x8
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	_            [4]byte
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	RCR          volatile.Register32 // 0x30
	CCR1         volatile.Register32 // 0x34
	CCR2         volatile.Register32 // 0x38
	_            [8]byte
	BDTR         volatile.Register32 // 0x44
	_            [12]byte
	DTR2         volatile.Register32 // 0x54
	_            [4]byte
	TISEL        volatile.Register32 // 0x5C
	AF1          volatile.Register32 // 0x60
	AF2          volatile.Register32 // 0x64
	_            [884]byte
	DCR          volatile.Register32 // 0x3DC
	DMAR         volatile.Register32 // 0x3E0
}

// TIM.CR1: control register 1
func (o *TIM_Type) SetCR1_CEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCR1_CEN() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *TIM_Type) SetCR1_UDIS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetCR1_UDIS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetCR1_URS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCR1_URS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCR1_OPM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCR1_OPM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCR1_ARPE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCR1_ARPE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCR1_CKD(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCR1_CKD() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCR1_UIFREMAP(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCR1_UIFREMAP() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCR1_DITHEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetCR1_DITHEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}

// TIM.CR2: control register 2
func (o *TIM_Type) SetCR2_OIS2(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCR2_OIS2() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCR2_OIS1N(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetCR2_OIS1N() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetCR2_OIS1(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetCR2_OIS1() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetCR2_TI1S(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCR2_TI1S() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCR2_MMS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCR2_MMS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCR2_CCDS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCR2_CCDS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCR2_CCUS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCR2_CCUS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCR2_CCPC(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCR2_CCPC() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}

// TIM.SMCR: slave mode control register
func (o *TIM_Type) SetSMCR_TS_4_3(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x300000)|value<<20)
}
func (o *TIM_Type) GetSMCR_TS_4_3() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x300000) >> 20
}
func (o *TIM_Type) SetSMCR_SMS_3(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetSMCR_SMS_3() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetSMCR_MSM(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetSMCR_MSM() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetSMCR_TS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetSMCR_TS() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetSMCR_SMS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x7)|value)
}
func (o *TIM_Type) GetSMCR_SMS() uint32 {
	return volatile.LoadUint32(&o.SMCR.Reg) & 0x7
}

// TIM.DIER: DMA/Interrupt enable register
func (o *TIM_Type) SetDIER_TDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetDIER_TDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetDIER_COMDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetDIER_COMDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetDIER_CC2DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetDIER_CC2DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetDIER_CC1DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetDIER_CC1DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetDIER_UDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetDIER_UDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetDIER_BIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetDIER_BIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetDIER_TIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetDIER_TIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetDIER_COMIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetDIER_COMIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetDIER_CC2IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetDIER_CC2IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetDIER_CC1IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetDIER_CC1IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetDIER_UIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetDIER_UIE() uint32 {
	return volatile.LoadUint32(&o.DIER.Reg) & 0x1
}

// TIM.SR: status register
func (o *TIM_Type) SetSR_CC2OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetSR_CC2OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetSR_CC1OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetSR_CC1OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetSR_BIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetSR_BIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetSR_TIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetSR_TIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetSR_COMIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetSR_COMIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetSR_CC2IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetSR_CC2IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetSR_CC1IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetSR_CC1IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetSR_UIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetSR_UIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// TIM.EGR: event generation register
func (o *TIM_Type) SetEGR_BG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetEGR_BG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetEGR_TG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetEGR_TG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetEGR_COMG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetEGR_COMG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetEGR_CC2G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetEGR_CC2G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetEGR_CC1G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetEGR_CC1G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetEGR_UG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetEGR_UG() uint32 {
	return volatile.LoadUint32(&o.EGR.Reg) & 0x1
}

// TIM.CCMR1_Output: capture/compare mode register (output mode)
func (o *TIM_Type) SetCCMR1_Output_OC2M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x1000000)|value<<24)
}
func (o *TIM_Type) GetCCMR1_Output_OC2M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x1000000) >> 24
}
func (o *TIM_Type) SetCCMR1_Output_OC1M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCCMR1_Output_OC1M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetCCMR1_Output_OC2M(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIM_Type) GetCCMR1_Output_OC2M() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x7000) >> 12
}
func (o *TIM_Type) SetCCMR1_Output_OC2PE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCMR1_Output_OC2PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCMR1_Output_OC2FE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCMR1_Output_OC2FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCMR1_Output_CC2S(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCCMR1_Output_CC2S() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCCMR1_Output_OC1CE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCMR1_Output_OC1CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCMR1_Output_OC1M(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCCMR1_Output_OC1M() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCCMR1_Output_OC1PE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCMR1_Output_OC1PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCMR1_Output_OC1FE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCMR1_Output_OC1FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCMR1_Output_CC1S(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x3)|value)
}
func (o *TIM_Type) GetCCMR1_Output_CC1S() uint32 {
	return volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x3
}

// TIM.CCER: capture/compare enable register
func (o *TIM_Type) SetCCER_CC2NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCER_CC2NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCER_CC2P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetCCER_CC2P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetCCER_CC2E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetCCER_CC2E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetCCER_CC1NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCER_CC1NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCER_CC1NE(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCER_CC1NE() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCER_CC1P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetCCER_CC1P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetCCER_CC1E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCCER_CC1E() uint32 {
	return volatile.LoadUint32(&o.CCER.Reg) & 0x1
}

// TIM.CNT: counter
func (o *TIM_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0xffff
}
func (o *TIM_Type) SetCNT_UIFCPY(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0x80000000)|value<<31)
}
func (o *TIM_Type) GetCNT_UIFCPY() uint32 {
	return (volatile.LoadUint32(&o.CNT.Reg) & 0x80000000) >> 31
}

// TIM.PSC: prescaler
func (o *TIM_Type) SetPSC(value uint32) {
	volatile.StoreUint32(&o.PSC.Reg, volatile.LoadUint32(&o.PSC.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetPSC() uint32 {
	return volatile.LoadUint32(&o.PSC.Reg) & 0xffff
}

// TIM.ARR: auto-reload register
func (o *TIM_Type) SetARR(value uint32) {
	volatile.StoreUint32(&o.ARR.Reg, volatile.LoadUint32(&o.ARR.Reg)&^(0xfffff)|value)
}
func (o *TIM_Type) GetARR() uint32 {
	return volatile.LoadUint32(&o.ARR.Reg) & 0xfffff
}

// TIM.RCR: repetition counter register
func (o *TIM_Type) SetRCR_REP(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xff)|value)
}
func (o *TIM_Type) GetRCR_REP() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xff
}

// TIM.CCR1: capture/compare register
func (o *TIM_Type) SetCCR1_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0xfffff)|value)
}
func (o *TIM_Type) GetCCR1_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR1.Reg) & 0xfffff
}

// TIM.CCR2: capture/compare register
func (o *TIM_Type) SetCCR2_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0xfffff)|value)
}
func (o *TIM_Type) GetCCR2_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR2.Reg) & 0xfffff
}

// TIM.BDTR: break and dead-time register
func (o *TIM_Type) SetBDTR_DTG(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0xff)|value)
}
func (o *TIM_Type) GetBDTR_DTG() uint32 {
	return volatile.LoadUint32(&o.BDTR.Reg) & 0xff
}
func (o *TIM_Type) SetBDTR_LOCK(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetBDTR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetBDTR_OSSI(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetBDTR_OSSI() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetBDTR_OSSR(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetBDTR_OSSR() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetBDTR_BKE(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetBDTR_BKE() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetBDTR_BKP(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetBDTR_BKP() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetBDTR_AOE(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetBDTR_AOE() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetBDTR_MOE(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetBDTR_MOE() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetBDTR_BKF(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0xf0000)|value<<16)
}
func (o *TIM_Type) GetBDTR_BKF() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0xf0000) >> 16
}
func (o *TIM_Type) SetBDTR_BKDSRM(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x4000000)|value<<26)
}
func (o *TIM_Type) GetBDTR_BKDSRM() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x4000000) >> 26
}
func (o *TIM_Type) SetBDTR_BKBID(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x10000000)|value<<28)
}
func (o *TIM_Type) GetBDTR_BKBID() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x10000000) >> 28
}

// TIM.DTR2: timer Deadtime Register 2
func (o *TIM_Type) SetDTR2_DTGF(value uint32) {
	volatile.StoreUint32(&o.DTR2.Reg, volatile.LoadUint32(&o.DTR2.Reg)&^(0xff)|value)
}
func (o *TIM_Type) GetDTR2_DTGF() uint32 {
	return volatile.LoadUint32(&o.DTR2.Reg) & 0xff
}
func (o *TIM_Type) SetDTR2_DTAE(value uint32) {
	volatile.StoreUint32(&o.DTR2.Reg, volatile.LoadUint32(&o.DTR2.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetDTR2_DTAE() uint32 {
	return (volatile.LoadUint32(&o.DTR2.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetDTR2_DTPE(value uint32) {
	volatile.StoreUint32(&o.DTR2.Reg, volatile.LoadUint32(&o.DTR2.Reg)&^(0x20000)|value<<17)
}
func (o *TIM_Type) GetDTR2_DTPE() uint32 {
	return (volatile.LoadUint32(&o.DTR2.Reg) & 0x20000) >> 17
}

// TIM.TISEL: TIM timer input selection register
func (o *TIM_Type) SetTISEL_TI1SEL(value uint32) {
	volatile.StoreUint32(&o.TISEL.Reg, volatile.LoadUint32(&o.TISEL.Reg)&^(0xf)|value)
}
func (o *TIM_Type) GetTISEL_TI1SEL() uint32 {
	return volatile.LoadUint32(&o.TISEL.Reg) & 0xf
}
func (o *TIM_Type) SetTISEL_TI2SEL(value uint32) {
	volatile.StoreUint32(&o.TISEL.Reg, volatile.LoadUint32(&o.TISEL.Reg)&^(0xf00)|value<<8)
}
func (o *TIM_Type) GetTISEL_TI2SEL() uint32 {
	return (volatile.LoadUint32(&o.TISEL.Reg) & 0xf00) >> 8
}

// TIM.AF1: TIM alternate function option register 1
func (o *TIM_Type) SetAF1_BKCMP4P(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetAF1_BKCMP4P() uint32 {
	return (volatile.LoadUint32(&o.AF1.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetAF1_BKCMP3P(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetAF1_BKCMP3P() uint32 {
	return (volatile.LoadUint32(&o.AF1.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetAF1_BKCMP2P(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetAF1_BKCMP2P() uint32 {
	return (volatile.LoadUint32(&o.AF1.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetAF1_BKCMP1P(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetAF1_BKCMP1P() uint32 {
	return (volatile.LoadUint32(&o.AF1.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetAF1_BKINP(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetAF1_BKINP() uint32 {
	return (volatile.LoadUint32(&o.AF1.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetAF1_BKCMP7E(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetAF1_BKCMP7E() uint32 {
	return (volatile.LoadUint32(&o.AF1.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetAF1_BKCMP6E(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetAF1_BKCMP6E() uint32 {
	return (volatile.LoadUint32(&o.AF1.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetAF1_BKCMP5E(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetAF1_BKCMP5E() uint32 {
	return (volatile.LoadUint32(&o.AF1.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetAF1_BKCMP4E(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetAF1_BKCMP4E() uint32 {
	return (volatile.LoadUint32(&o.AF1.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetAF1_BKCMP3E(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetAF1_BKCMP3E() uint32 {
	return (volatile.LoadUint32(&o.AF1.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetAF1_BKCMP2E(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetAF1_BKCMP2E() uint32 {
	return (volatile.LoadUint32(&o.AF1.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetAF1_BKCMP1E(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetAF1_BKCMP1E() uint32 {
	return (volatile.LoadUint32(&o.AF1.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetAF1_BKINE(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetAF1_BKINE() uint32 {
	return volatile.LoadUint32(&o.AF1.Reg) & 0x1
}

// TIM.AF2: TIM alternate function option register 2
func (o *TIM_Type) SetAF2_OCRSEL(value uint32) {
	volatile.StoreUint32(&o.AF2.Reg, volatile.LoadUint32(&o.AF2.Reg)&^(0x70000)|value<<16)
}
func (o *TIM_Type) GetAF2_OCRSEL() uint32 {
	return (volatile.LoadUint32(&o.AF2.Reg) & 0x70000) >> 16
}

// TIM.DCR: DMA control register
func (o *TIM_Type) SetDCR_DBL(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f00)|value<<8)
}
func (o *TIM_Type) GetDCR_DBL() uint32 {
	return (volatile.LoadUint32(&o.DCR.Reg) & 0x1f00) >> 8
}
func (o *TIM_Type) SetDCR_DBA(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f)|value)
}
func (o *TIM_Type) GetDCR_DBA() uint32 {
	return volatile.LoadUint32(&o.DCR.Reg) & 0x1f
}

// TIM.DMAR: DMA address for full transfer
func (o *TIM_Type) SetDMAR(value uint32) {
	volatile.StoreUint32(&o.DMAR.Reg, value)
}
func (o *TIM_Type) GetDMAR() uint32 {
	return volatile.LoadUint32(&o.DMAR.Reg)
}

// Low power timer
type LPTIM_Type struct {
	ISR  volatile.Register32 // 0x0
	ICR  volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	CFGR volatile.Register32 // 0xC
	CR   volatile.Register32 // 0x10
	CMP  volatile.Register32 // 0x14
	ARR  volatile.Register32 // 0x18
	CNT  volatile.Register32 // 0x1C
	OR   volatile.Register32 // 0x20
}

// LPTIM.ISR: Interrupt and Status Register
func (o *LPTIM_Type) SetISR_DOWN(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetISR_DOWN() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *LPTIM_Type) SetISR_UP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetISR_UP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetISR_ARROK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetISR_ARROK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetISR_CMPOK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetISR_CMPOK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetISR_EXTTRIG(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetISR_EXTTRIG() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetISR_ARRM(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetISR_ARRM() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetISR_CMPM(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetISR_CMPM() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// LPTIM.ICR: Interrupt Clear Register
func (o *LPTIM_Type) SetICR_DOWNCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetICR_DOWNCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *LPTIM_Type) SetICR_UPCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetICR_UPCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetICR_ARROKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetICR_ARROKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetICR_CMPOKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetICR_CMPOKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetICR_EXTTRIGCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetICR_EXTTRIGCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetICR_ARRMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetICR_ARRMCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetICR_CMPMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetICR_CMPMCF() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// LPTIM.IER: Interrupt Enable Register
func (o *LPTIM_Type) SetIER_DOWNIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetIER_DOWNIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *LPTIM_Type) SetIER_UPIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetIER_UPIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetIER_ARROKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetIER_ARROKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetIER_CMPOKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetIER_CMPOKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetIER_EXTTRIGIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetIER_EXTTRIGIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetIER_ARRMIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetIER_ARRMIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetIER_CMPMIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetIER_CMPMIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// LPTIM.CFGR: Configuration Register
func (o *LPTIM_Type) SetCFGR_ENC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *LPTIM_Type) GetCFGR_ENC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1000000) >> 24
}
func (o *LPTIM_Type) SetCFGR_COUNTMODE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x800000)|value<<23)
}
func (o *LPTIM_Type) GetCFGR_COUNTMODE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x800000) >> 23
}
func (o *LPTIM_Type) SetCFGR_PRELOAD(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x400000)|value<<22)
}
func (o *LPTIM_Type) GetCFGR_PRELOAD() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x400000) >> 22
}
func (o *LPTIM_Type) SetCFGR_WAVPOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x200000)|value<<21)
}
func (o *LPTIM_Type) GetCFGR_WAVPOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x200000) >> 21
}
func (o *LPTIM_Type) SetCFGR_WAVE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x100000)|value<<20)
}
func (o *LPTIM_Type) GetCFGR_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x100000) >> 20
}
func (o *LPTIM_Type) SetCFGR_TIMOUT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80000)|value<<19)
}
func (o *LPTIM_Type) GetCFGR_TIMOUT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80000) >> 19
}
func (o *LPTIM_Type) SetCFGR_TRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x60000)|value<<17)
}
func (o *LPTIM_Type) GetCFGR_TRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x60000) >> 17
}
func (o *LPTIM_Type) SetCFGR_TRIGSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1e000)|value<<13)
}
func (o *LPTIM_Type) GetCFGR_TRIGSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1e000) >> 13
}
func (o *LPTIM_Type) SetCFGR_PRESC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe00)|value<<9)
}
func (o *LPTIM_Type) GetCFGR_PRESC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe00) >> 9
}
func (o *LPTIM_Type) SetCFGR_TRGFLT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc0)|value<<6)
}
func (o *LPTIM_Type) GetCFGR_TRGFLT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc0) >> 6
}
func (o *LPTIM_Type) SetCFGR_CKFLT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x18)|value<<3)
}
func (o *LPTIM_Type) GetCFGR_CKFLT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x18) >> 3
}
func (o *LPTIM_Type) SetCFGR_CKPOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x6)|value<<1)
}
func (o *LPTIM_Type) GetCFGR_CKPOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x6) >> 1
}
func (o *LPTIM_Type) SetCFGR_CKSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetCFGR_CKSEL() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x1
}

// LPTIM.CR: Control Register
func (o *LPTIM_Type) SetCR_RSTARE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetCR_RSTARE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetCR_COUNTRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetCR_COUNTRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetCR_CNTSTRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetCR_CNTSTRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetCR_SNGSTRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetCR_SNGSTRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetCR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetCR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// LPTIM.CMP: Compare Register
func (o *LPTIM_Type) SetCMP(value uint32) {
	volatile.StoreUint32(&o.CMP.Reg, volatile.LoadUint32(&o.CMP.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetCMP() uint32 {
	return volatile.LoadUint32(&o.CMP.Reg) & 0xffff
}

// LPTIM.ARR: Autoreload Register
func (o *LPTIM_Type) SetARR(value uint32) {
	volatile.StoreUint32(&o.ARR.Reg, volatile.LoadUint32(&o.ARR.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetARR() uint32 {
	return volatile.LoadUint32(&o.ARR.Reg) & 0xffff
}

// LPTIM.CNT: Counter Register
func (o *LPTIM_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0xffff
}

// LPTIM.OR: option register
func (o *LPTIM_Type) SetOR_IN1(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetOR_IN1() uint32 {
	return volatile.LoadUint32(&o.OR.Reg) & 0x1
}
func (o *LPTIM_Type) SetOR_IN2(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetOR_IN2() uint32 {
	return (volatile.LoadUint32(&o.OR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetOR_IN1_2_1(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0xc)|value<<2)
}
func (o *LPTIM_Type) GetOR_IN1_2_1() uint32 {
	return (volatile.LoadUint32(&o.OR.Reg) & 0xc) >> 2
}
func (o *LPTIM_Type) SetOR_IN2_2_1(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x30)|value<<4)
}
func (o *LPTIM_Type) GetOR_IN2_2_1() uint32 {
	return (volatile.LoadUint32(&o.OR.Reg) & 0x30) >> 4
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	CR1   volatile.Register32 // 0x0
	CR2   volatile.Register32 // 0x4
	CR3   volatile.Register32 // 0x8
	BRR   volatile.Register32 // 0xC
	GTPR  volatile.Register32 // 0x10
	RTOR  volatile.Register32 // 0x14
	RQR   volatile.Register32 // 0x18
	ISR   volatile.Register32 // 0x1C
	ICR   volatile.Register32 // 0x20
	RDR   volatile.Register32 // 0x24
	TDR   volatile.Register32 // 0x28
	PRESC volatile.Register32 // 0x2C
}

// USART.CR1: Control register 1
func (o *USART_Type) SetCR1_RXFFIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000000)|value<<31)
}
func (o *USART_Type) GetCR1_RXFFIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000000) >> 31
}
func (o *USART_Type) SetCR1_TXFEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40000000)|value<<30)
}
func (o *USART_Type) GetCR1_TXFEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40000000) >> 30
}
func (o *USART_Type) SetCR1_FIFOEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000000)|value<<29)
}
func (o *USART_Type) GetCR1_FIFOEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000000) >> 29
}
func (o *USART_Type) SetCR1_M1(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetCR1_M1() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetCR1_EOBIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000000)|value<<27)
}
func (o *USART_Type) GetCR1_EOBIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000000) >> 27
}
func (o *USART_Type) SetCR1_RTOIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000000)|value<<26)
}
func (o *USART_Type) GetCR1_RTOIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000000) >> 26
}
func (o *USART_Type) SetCR1_DEAT4(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000000)|value<<25)
}
func (o *USART_Type) GetCR1_DEAT4() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000000) >> 25
}
func (o *USART_Type) SetCR1_DEAT3(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetCR1_DEAT3() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000000) >> 24
}
func (o *USART_Type) SetCR1_DEAT2(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetCR1_DEAT2() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetCR1_DEAT1(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetCR1_DEAT1() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetCR1_DEAT0(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200000)|value<<21)
}
func (o *USART_Type) GetCR1_DEAT0() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200000) >> 21
}
func (o *USART_Type) SetCR1_DEDT4(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetCR1_DEDT4() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetCR1_DEDT3(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetCR1_DEDT3() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetCR1_DEDT2(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetCR1_DEDT2() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetCR1_DEDT1(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetCR1_DEDT1() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetCR1_DEDT0(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetCR1_DEDT0() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetCR1_OVER8(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR1_OVER8() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR1_CMIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR1_CMIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR1_MME(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR1_MME() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR1_M0(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR1_M0() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR1_WAKE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR1_WAKE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR1_PCE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR1_PCE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR1_PS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR1_PS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR1_PEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR1_PEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR1_TXEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR1_TXEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR1_RXNEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR1_RXNEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR1_IDLEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR1_IDLEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR1_TE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR1_TE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR1_RE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR1_RE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR1_UESM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCR1_UESM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCR1_UE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCR1_UE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// USART.CR2: Control register 2
func (o *USART_Type) SetCR2_ADD4_7(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf0000000)|value<<28)
}
func (o *USART_Type) GetCR2_ADD4_7() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xf0000000) >> 28
}
func (o *USART_Type) SetCR2_ADD0_3(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf000000)|value<<24)
}
func (o *USART_Type) GetCR2_ADD0_3() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xf000000) >> 24
}
func (o *USART_Type) SetCR2_RTOEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetCR2_RTOEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetCR2_ABRMOD1(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetCR2_ABRMOD1() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetCR2_ABRMOD0(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200000)|value<<21)
}
func (o *USART_Type) GetCR2_ABRMOD0() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200000) >> 21
}
func (o *USART_Type) SetCR2_ABREN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetCR2_ABREN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetCR2_MSBFIRST(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetCR2_MSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetCR2_TAINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetCR2_TAINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetCR2_TXINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetCR2_TXINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetCR2_RXINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetCR2_RXINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetCR2_SWAP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR2_SWAP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR2_LINEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR2_LINEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR2_STOP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3000)|value<<12)
}
func (o *USART_Type) GetCR2_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x3000) >> 12
}
func (o *USART_Type) SetCR2_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR2_CLKEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR2_CPOL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR2_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR2_CPHA(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR2_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR2_LBCL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR2_LBCL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR2_LBDIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR2_LBDIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR2_LBDL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR2_LBDL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR2_ADDM7(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR2_ADDM7() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR2_DIS_NSS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR2_DIS_NSS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR2_SLVEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCR2_SLVEN() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}

// USART.CR3: Control register 3
func (o *USART_Type) SetCR3_TXFTCFG(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0xe0000000)|value<<29)
}
func (o *USART_Type) GetCR3_TXFTCFG() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0xe0000000) >> 29
}
func (o *USART_Type) SetCR3_RXFTIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetCR3_RXFTIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetCR3_RXFTCFG(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0xe000000)|value<<25)
}
func (o *USART_Type) GetCR3_RXFTCFG() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0xe000000) >> 25
}
func (o *USART_Type) SetCR3_TCBGTIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetCR3_TCBGTIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x1000000) >> 24
}
func (o *USART_Type) SetCR3_TXFTIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetCR3_TXFTIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetCR3_WUFIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetCR3_WUFIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetCR3_WUS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x300000)|value<<20)
}
func (o *USART_Type) GetCR3_WUS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x300000) >> 20
}
func (o *USART_Type) SetCR3_SCARCNT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0xe0000)|value<<17)
}
func (o *USART_Type) GetCR3_SCARCNT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0xe0000) >> 17
}
func (o *USART_Type) SetCR3_DEP(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR3_DEP() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR3_DEM(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR3_DEM() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR3_DDRE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR3_DDRE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR3_OVRDIS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR3_OVRDIS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR3_ONEBIT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR3_ONEBIT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR3_CTSIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR3_CTSIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR3_CTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR3_CTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR3_RTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR3_RTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR3_DMAT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR3_DMAT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR3_DMAR(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR3_DMAR() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR3_SCEN(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR3_SCEN() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR3_NACK(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR3_NACK() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR3_HDSEL(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR3_HDSEL() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR3_IRLP(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR3_IRLP() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR3_IREN(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCR3_IREN() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCR3_EIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCR3_EIE() uint32 {
	return volatile.LoadUint32(&o.CR3.Reg) & 0x1
}

// USART.BRR: Baud rate register
func (o *USART_Type) SetBRR_DIV_Mantissa(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0xfff0)|value<<4)
}
func (o *USART_Type) GetBRR_DIV_Mantissa() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0xfff0) >> 4
}
func (o *USART_Type) SetBRR_DIV_Fraction(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetBRR_DIV_Fraction() uint32 {
	return volatile.LoadUint32(&o.BRR.Reg) & 0xf
}

// USART.GTPR: Guard time and prescaler register
func (o *USART_Type) SetGTPR_GT(value uint32) {
	volatile.StoreUint32(&o.GTPR.Reg, volatile.LoadUint32(&o.GTPR.Reg)&^(0xff00)|value<<8)
}
func (o *USART_Type) GetGTPR_GT() uint32 {
	return (volatile.LoadUint32(&o.GTPR.Reg) & 0xff00) >> 8
}
func (o *USART_Type) SetGTPR_PSC(value uint32) {
	volatile.StoreUint32(&o.GTPR.Reg, volatile.LoadUint32(&o.GTPR.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetGTPR_PSC() uint32 {
	return volatile.LoadUint32(&o.GTPR.Reg) & 0xff
}

// USART.RTOR: Receiver timeout register
func (o *USART_Type) SetRTOR_BLEN(value uint32) {
	volatile.StoreUint32(&o.RTOR.Reg, volatile.LoadUint32(&o.RTOR.Reg)&^(0xff000000)|value<<24)
}
func (o *USART_Type) GetRTOR_BLEN() uint32 {
	return (volatile.LoadUint32(&o.RTOR.Reg) & 0xff000000) >> 24
}
func (o *USART_Type) SetRTOR_RTO(value uint32) {
	volatile.StoreUint32(&o.RTOR.Reg, volatile.LoadUint32(&o.RTOR.Reg)&^(0xffffff)|value)
}
func (o *USART_Type) GetRTOR_RTO() uint32 {
	return volatile.LoadUint32(&o.RTOR.Reg) & 0xffffff
}

// USART.RQR: Request register
func (o *USART_Type) SetRQR_TXFRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetRQR_TXFRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetRQR_RXFRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetRQR_RXFRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetRQR_MMRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetRQR_MMRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetRQR_SBKRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetRQR_SBKRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetRQR_ABRRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetRQR_ABRRQ() uint32 {
	return volatile.LoadUint32(&o.RQR.Reg) & 0x1
}

// USART.ISR: Interrupt & status register
func (o *USART_Type) SetISR_TXFT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000000)|value<<27)
}
func (o *USART_Type) GetISR_TXFT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000000) >> 27
}
func (o *USART_Type) SetISR_RXFT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *USART_Type) GetISR_RXFT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *USART_Type) SetISR_TCBGT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *USART_Type) GetISR_TCBGT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000000) >> 25
}
func (o *USART_Type) SetISR_RXFF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetISR_RXFF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *USART_Type) SetISR_TXFE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetISR_TXFE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetISR_REACK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetISR_REACK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetISR_TEACK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200000)|value<<21)
}
func (o *USART_Type) GetISR_TEACK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200000) >> 21
}
func (o *USART_Type) SetISR_WUF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetISR_WUF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetISR_RWU(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetISR_RWU() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetISR_SBKF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetISR_SBKF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetISR_CMF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetISR_CMF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetISR_BUSY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetISR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetISR_ABRF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetISR_ABRF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetISR_ABRE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetISR_ABRE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetISR_UDR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetISR_UDR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetISR_EOBF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetISR_EOBF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetISR_RTOF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetISR_RTOF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetISR_CTS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetISR_CTS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetISR_CTSIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetISR_CTSIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetISR_LBDF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetISR_LBDF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetISR_TXE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetISR_TXE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetISR_TC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetISR_TC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetISR_RXNE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetISR_RXNE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetISR_IDLE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetISR_IDLE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetISR_ORE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetISR_ORE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetISR_NF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetISR_NF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetISR_FE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetISR_FE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetISR_PE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetISR_PE() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// USART.ICR: Interrupt flag clear register
func (o *USART_Type) SetICR_WUCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetICR_WUCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetICR_CMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetICR_CMCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetICR_UDRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetICR_UDRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetICR_EOBCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetICR_EOBCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetICR_RTOCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetICR_RTOCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetICR_CTSCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetICR_CTSCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetICR_LBDCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetICR_LBDCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetICR_TCBGTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetICR_TCBGTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetICR_TCCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetICR_TCCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetICR_TXFECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetICR_TXFECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetICR_IDLECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetICR_IDLECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetICR_ORECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetICR_ORECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetICR_NCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetICR_NCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetICR_FECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetICR_FECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetICR_PECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetICR_PECF() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// USART.RDR: Receive data register
func (o *USART_Type) SetRDR(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetRDR() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg) & 0x1ff
}

// USART.TDR: Transmit data register
func (o *USART_Type) SetTDR(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetTDR() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg) & 0x1ff
}

// USART.PRESC: USART prescaler register
func (o *USART_Type) SetPRESC_PRESCALER(value uint32) {
	volatile.StoreUint32(&o.PRESC.Reg, volatile.LoadUint32(&o.PRESC.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetPRESC_PRESCALER() uint32 {
	return volatile.LoadUint32(&o.PRESC.Reg) & 0xf
}

// Serial peripheral interface/Inter-IC sound
type SPI_Type struct {
	CR1     volatile.Register32 // 0x0
	CR2     volatile.Register32 // 0x4
	SR      volatile.Register32 // 0x8
	DR      volatile.Register32 // 0xC
	CRCPR   volatile.Register32 // 0x10
	RXCRCR  volatile.Register32 // 0x14
	TXCRCR  volatile.Register32 // 0x18
	I2SCFGR volatile.Register32 // 0x1C
	I2SPR   volatile.Register32 // 0x20
}

// SPI.CR1: control register 1
func (o *SPI_Type) SetCR1_BIDIMODE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *SPI_Type) GetCR1_BIDIMODE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *SPI_Type) SetCR1_BIDIOE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *SPI_Type) GetCR1_BIDIOE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *SPI_Type) SetCR1_CRCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *SPI_Type) GetCR1_CRCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *SPI_Type) SetCR1_CRCNEXT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *SPI_Type) GetCR1_CRCNEXT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *SPI_Type) SetCR1_DFF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *SPI_Type) GetCR1_DFF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *SPI_Type) SetCR1_RXONLY(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetCR1_RXONLY() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetCR1_SSM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetCR1_SSM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetCR1_SSI(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetCR1_SSI() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetCR1_LSBFIRST(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR1_LSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR1_SPE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetCR1_SPE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetCR1_BR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x38)|value<<3)
}
func (o *SPI_Type) GetCR1_BR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x38) >> 3
}
func (o *SPI_Type) SetCR1_MSTR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCR1_MSTR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCR1_CPOL(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR1_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR1_CPHA(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR1_CPHA() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// SPI.CR2: control register 2
func (o *SPI_Type) SetCR2_RXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR2_RXDMAEN() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}
func (o *SPI_Type) SetCR2_TXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR2_TXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR2_SSOE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCR2_SSOE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCR2_NSSP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetCR2_NSSP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetCR2_FRF(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetCR2_FRF() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetCR2_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetCR2_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetCR2_RXNEIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetCR2_RXNEIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetCR2_TXEIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR2_TXEIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR2_DS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf00)|value<<8)
}
func (o *SPI_Type) GetCR2_DS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xf00) >> 8
}
func (o *SPI_Type) SetCR2_FRXTH(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *SPI_Type) GetCR2_FRXTH() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *SPI_Type) SetCR2_LDMA_RX(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *SPI_Type) GetCR2_LDMA_RX() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *SPI_Type) SetCR2_LDMA_TX(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *SPI_Type) GetCR2_LDMA_TX() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}

// SPI.SR: status register
func (o *SPI_Type) SetSR_RXNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetSR_RXNE() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SPI_Type) SetSR_TXE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetSR_TXE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetSR_CRCERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetSR_CRCERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetSR_MODF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetSR_MODF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetSR_OVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetSR_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetSR_BSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetSR_BSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetSR_TIFRFE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetSR_TIFRFE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetSR_FRLVL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x600)|value<<9)
}
func (o *SPI_Type) GetSR_FRLVL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x600) >> 9
}
func (o *SPI_Type) SetSR_FTLVL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1800)|value<<11)
}
func (o *SPI_Type) GetSR_FTLVL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1800) >> 11
}

// SPI.DR: data register
func (o *SPI_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xffff
}

// SPI.CRCPR: CRC polynomial register
func (o *SPI_Type) SetCRCPR_CRCPOLY(value uint32) {
	volatile.StoreUint32(&o.CRCPR.Reg, volatile.LoadUint32(&o.CRCPR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetCRCPR_CRCPOLY() uint32 {
	return volatile.LoadUint32(&o.CRCPR.Reg) & 0xffff
}

// SPI.RXCRCR: RX CRC register
func (o *SPI_Type) SetRXCRCR_RxCRC(value uint32) {
	volatile.StoreUint32(&o.RXCRCR.Reg, volatile.LoadUint32(&o.RXCRCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetRXCRCR_RxCRC() uint32 {
	return volatile.LoadUint32(&o.RXCRCR.Reg) & 0xffff
}

// SPI.TXCRCR: TX CRC register
func (o *SPI_Type) SetTXCRCR_TxCRC(value uint32) {
	volatile.StoreUint32(&o.TXCRCR.Reg, volatile.LoadUint32(&o.TXCRCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTXCRCR_TxCRC() uint32 {
	return volatile.LoadUint32(&o.TXCRCR.Reg) & 0xffff
}

// SPI.I2SCFGR: configuration register
func (o *SPI_Type) SetI2SCFGR_CHLEN(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetI2SCFGR_CHLEN() uint32 {
	return volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x1
}
func (o *SPI_Type) SetI2SCFGR_DATLEN(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x6)|value<<1)
}
func (o *SPI_Type) GetI2SCFGR_DATLEN() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x6) >> 1
}
func (o *SPI_Type) SetI2SCFGR_CKPOL(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetI2SCFGR_CKPOL() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetI2SCFGR_I2SSTD(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x30)|value<<4)
}
func (o *SPI_Type) GetI2SCFGR_I2SSTD() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x30) >> 4
}
func (o *SPI_Type) SetI2SCFGR_PCMSYNC(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetI2SCFGR_PCMSYNC() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetI2SCFGR_I2SCFG(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x300)|value<<8)
}
func (o *SPI_Type) GetI2SCFGR_I2SCFG() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x300) >> 8
}
func (o *SPI_Type) SetI2SCFGR_I2SE(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetI2SCFGR_I2SE() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetI2SCFGR_I2SMOD(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x800)|value<<11)
}
func (o *SPI_Type) GetI2SCFGR_I2SMOD() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x800) >> 11
}

// SPI.I2SPR: prescaler register
func (o *SPI_Type) SetI2SPR_I2SDIV(value uint32) {
	volatile.StoreUint32(&o.I2SPR.Reg, volatile.LoadUint32(&o.I2SPR.Reg)&^(0xff)|value)
}
func (o *SPI_Type) GetI2SPR_I2SDIV() uint32 {
	return volatile.LoadUint32(&o.I2SPR.Reg) & 0xff
}
func (o *SPI_Type) SetI2SPR_ODD(value uint32) {
	volatile.StoreUint32(&o.I2SPR.Reg, volatile.LoadUint32(&o.I2SPR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetI2SPR_ODD() uint32 {
	return (volatile.LoadUint32(&o.I2SPR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetI2SPR_MCKOE(value uint32) {
	volatile.StoreUint32(&o.I2SPR.Reg, volatile.LoadUint32(&o.I2SPR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetI2SPR_MCKOE() uint32 {
	return (volatile.LoadUint32(&o.I2SPR.Reg) & 0x200) >> 9
}

// External interrupt/event controller
type EXTI_Type struct {
	IMR1   volatile.Register32 // 0x0
	EMR1   volatile.Register32 // 0x4
	RTSR1  volatile.Register32 // 0x8
	FTSR1  volatile.Register32 // 0xC
	SWIER1 volatile.Register32 // 0x10
	PR1    volatile.Register32 // 0x14
	_      [8]byte
	IMR2   volatile.Register32 // 0x20
	EMR2   volatile.Register32 // 0x24
	RTSR2  volatile.Register32 // 0x28
	FTSR2  volatile.Register32 // 0x2C
	SWIER2 volatile.Register32 // 0x30
	PR2    volatile.Register32 // 0x34
}

// EXTI.IMR1: Interrupt mask register
func (o *EXTI_Type) SetIMR1_IM0(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetIMR1_IM0() uint32 {
	return volatile.LoadUint32(&o.IMR1.Reg) & 0x1
}
func (o *EXTI_Type) SetIMR1_IM1(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetIMR1_IM1() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetIMR1_IM2(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetIMR1_IM2() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetIMR1_IM3(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetIMR1_IM3() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetIMR1_IM4(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetIMR1_IM4() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetIMR1_IM5(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetIMR1_IM5() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetIMR1_IM6(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetIMR1_IM6() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetIMR1_IM7(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetIMR1_IM7() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetIMR1_IM8(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetIMR1_IM8() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetIMR1_IM9(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetIMR1_IM9() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetIMR1_IM10(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetIMR1_IM10() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetIMR1_IM11(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetIMR1_IM11() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetIMR1_IM12(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetIMR1_IM12() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetIMR1_IM13(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetIMR1_IM13() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetIMR1_IM14(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetIMR1_IM14() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetIMR1_IM15(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetIMR1_IM15() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetIMR1_IM16(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetIMR1_IM16() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetIMR1_IM17(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetIMR1_IM17() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetIMR1_IM18(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetIMR1_IM18() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetIMR1_IM19(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetIMR1_IM19() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetIMR1_IM20(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetIMR1_IM20() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetIMR1_IM21(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetIMR1_IM21() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetIMR1_IM22(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetIMR1_IM22() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetIMR1_IM23(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetIMR1_IM23() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x800000) >> 23
}
func (o *EXTI_Type) SetIMR1_IM24(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTI_Type) GetIMR1_IM24() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x1000000) >> 24
}
func (o *EXTI_Type) SetIMR1_IM25(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2000000)|value<<25)
}
func (o *EXTI_Type) GetIMR1_IM25() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2000000) >> 25
}
func (o *EXTI_Type) SetIMR1_IM26(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4000000)|value<<26)
}
func (o *EXTI_Type) GetIMR1_IM26() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4000000) >> 26
}
func (o *EXTI_Type) SetIMR1_IM27(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8000000)|value<<27)
}
func (o *EXTI_Type) GetIMR1_IM27() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8000000) >> 27
}
func (o *EXTI_Type) SetIMR1_IM28(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10000000)|value<<28)
}
func (o *EXTI_Type) GetIMR1_IM28() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10000000) >> 28
}
func (o *EXTI_Type) SetIMR1_IM29(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTI_Type) GetIMR1_IM29() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20000000) >> 29
}
func (o *EXTI_Type) SetIMR1_IM30(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTI_Type) GetIMR1_IM30() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40000000) >> 30
}
func (o *EXTI_Type) SetIMR1_IM31(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetIMR1_IM31() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80000000) >> 31
}

// EXTI.EMR1: Event mask register
func (o *EXTI_Type) SetEMR1_EM0(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetEMR1_EM0() uint32 {
	return volatile.LoadUint32(&o.EMR1.Reg) & 0x1
}
func (o *EXTI_Type) SetEMR1_EM1(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetEMR1_EM1() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetEMR1_EM2(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetEMR1_EM2() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetEMR1_EM3(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetEMR1_EM3() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetEMR1_EM4(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetEMR1_EM4() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetEMR1_EM5(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetEMR1_EM5() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetEMR1_EM6(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetEMR1_EM6() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetEMR1_EM7(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetEMR1_EM7() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetEMR1_EM8(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetEMR1_EM8() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetEMR1_EM9(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetEMR1_EM9() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetEMR1_EM10(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetEMR1_EM10() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetEMR1_EM11(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetEMR1_EM11() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetEMR1_EM12(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetEMR1_EM12() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetEMR1_EM13(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetEMR1_EM13() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetEMR1_EM14(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetEMR1_EM14() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetEMR1_EM15(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetEMR1_EM15() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetEMR1_EM16(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetEMR1_EM16() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetEMR1_EM17(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetEMR1_EM17() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetEMR1_EM18(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetEMR1_EM18() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetEMR1_EM19(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetEMR1_EM19() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetEMR1_EM20(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetEMR1_EM20() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetEMR1_EM21(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetEMR1_EM21() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetEMR1_EM22(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetEMR1_EM22() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetEMR1_EM23(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetEMR1_EM23() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x800000) >> 23
}
func (o *EXTI_Type) SetEMR1_EM24(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTI_Type) GetEMR1_EM24() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x1000000) >> 24
}
func (o *EXTI_Type) SetEMR1_EM25(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x2000000)|value<<25)
}
func (o *EXTI_Type) GetEMR1_EM25() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x2000000) >> 25
}
func (o *EXTI_Type) SetEMR1_EM26(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x4000000)|value<<26)
}
func (o *EXTI_Type) GetEMR1_EM26() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x4000000) >> 26
}
func (o *EXTI_Type) SetEMR1_EM27(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x8000000)|value<<27)
}
func (o *EXTI_Type) GetEMR1_EM27() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x8000000) >> 27
}
func (o *EXTI_Type) SetEMR1_EM28(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x10000000)|value<<28)
}
func (o *EXTI_Type) GetEMR1_EM28() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x10000000) >> 28
}
func (o *EXTI_Type) SetEMR1_EM29(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTI_Type) GetEMR1_EM29() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x20000000) >> 29
}
func (o *EXTI_Type) SetEMR1_EM30(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTI_Type) GetEMR1_EM30() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x40000000) >> 30
}
func (o *EXTI_Type) SetEMR1_EM31(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetEMR1_EM31() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x80000000) >> 31
}

// EXTI.RTSR1: Rising Trigger selection register
func (o *EXTI_Type) SetRTSR1_RT0(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetRTSR1_RT0() uint32 {
	return volatile.LoadUint32(&o.RTSR1.Reg) & 0x1
}
func (o *EXTI_Type) SetRTSR1_RT1(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetRTSR1_RT1() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetRTSR1_RT2(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetRTSR1_RT2() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetRTSR1_RT3(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetRTSR1_RT3() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetRTSR1_RT4(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetRTSR1_RT4() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetRTSR1_RT5(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetRTSR1_RT5() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetRTSR1_RT6(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetRTSR1_RT6() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetRTSR1_RT7(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetRTSR1_RT7() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetRTSR1_RT8(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetRTSR1_RT8() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetRTSR1_RT9(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetRTSR1_RT9() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetRTSR1_RT10(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetRTSR1_RT10() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetRTSR1_RT11(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetRTSR1_RT11() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetRTSR1_RT12(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetRTSR1_RT12() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetRTSR1_RT13(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetRTSR1_RT13() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetRTSR1_RT14(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetRTSR1_RT14() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetRTSR1_RT15(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetRTSR1_RT15() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetRTSR1_RT16(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetRTSR1_RT16() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetRTSR1_RT19(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetRTSR1_RT19() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetRTSR1_RT20(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetRTSR1_RT20() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetRTSR1_RT21(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetRTSR1_RT21() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetRTSR1_RT22(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetRTSR1_RT22() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetRTSR1_RT29(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTI_Type) GetRTSR1_RT29() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x20000000) >> 29
}
func (o *EXTI_Type) SetRTSR1_RT17(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetRTSR1_RT17() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetRTSR1_RT30(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTI_Type) GetRTSR1_RT30() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x40000000) >> 30
}
func (o *EXTI_Type) SetRTSR1_RT31(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetRTSR1_RT31() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x80000000) >> 31
}

// EXTI.FTSR1: Falling Trigger selection register
func (o *EXTI_Type) SetFTSR1_FT0(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetFTSR1_FT0() uint32 {
	return volatile.LoadUint32(&o.FTSR1.Reg) & 0x1
}
func (o *EXTI_Type) SetFTSR1_FT1(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetFTSR1_FT1() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetFTSR1_FT2(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetFTSR1_FT2() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetFTSR1_FT3(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetFTSR1_FT3() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetFTSR1_FT4(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetFTSR1_FT4() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetFTSR1_FT5(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetFTSR1_FT5() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetFTSR1_FT6(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetFTSR1_FT6() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetFTSR1_FT7(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetFTSR1_FT7() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetFTSR1_FT8(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetFTSR1_FT8() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetFTSR1_FT9(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetFTSR1_FT9() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetFTSR1_FT10(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetFTSR1_FT10() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetFTSR1_FT11(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetFTSR1_FT11() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetFTSR1_FT12(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetFTSR1_FT12() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetFTSR1_FT13(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetFTSR1_FT13() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetFTSR1_FT14(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetFTSR1_FT14() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetFTSR1_FT15(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetFTSR1_FT15() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetFTSR1_FT16(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetFTSR1_FT16() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetFTSR1_FT19(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetFTSR1_FT19() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetFTSR1_FT20(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetFTSR1_FT20() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetFTSR1_FT21(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetFTSR1_FT21() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetFTSR1_FT22(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetFTSR1_FT22() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetFTSR1_FT17(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetFTSR1_FT17() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetFTSR1_FT29(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTI_Type) GetFTSR1_FT29() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x20000000) >> 29
}
func (o *EXTI_Type) SetFTSR1_FT30(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTI_Type) GetFTSR1_FT30() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x40000000) >> 30
}
func (o *EXTI_Type) SetFTSR1_FT31(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetFTSR1_FT31() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x80000000) >> 31
}

// EXTI.SWIER1: Software interrupt event register
func (o *EXTI_Type) SetSWIER1_SWI0(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetSWIER1_SWI0() uint32 {
	return volatile.LoadUint32(&o.SWIER1.Reg) & 0x1
}
func (o *EXTI_Type) SetSWIER1_SWI1(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetSWIER1_SWI1() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetSWIER1_SWI2(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetSWIER1_SWI2() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetSWIER1_SWI3(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetSWIER1_SWI3() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetSWIER1_SWI4(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetSWIER1_SWI4() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetSWIER1_SWI5(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetSWIER1_SWI5() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetSWIER1_SWI6(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetSWIER1_SWI6() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetSWIER1_SWI7(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetSWIER1_SWI7() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetSWIER1_SWI8(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetSWIER1_SWI8() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetSWIER1_SWI9(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetSWIER1_SWI9() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetSWIER1_SWI10(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetSWIER1_SWI10() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetSWIER1_SWI11(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetSWIER1_SWI11() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetSWIER1_SWI12(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetSWIER1_SWI12() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetSWIER1_SWI13(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetSWIER1_SWI13() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetSWIER1_SWI14(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetSWIER1_SWI14() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetSWIER1_SWI15(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetSWIER1_SWI15() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetSWIER1_SWI16(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetSWIER1_SWI16() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetSWIER1_SWI19(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetSWIER1_SWI19() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetSWIER1_SWI20(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetSWIER1_SWI20() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetSWIER1_SWI21(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetSWIER1_SWI21() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetSWIER1_SWI22(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetSWIER1_SWI22() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetSWIER1_SWI17(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetSWIER1_SWI17() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x20000) >> 17
}

// EXTI.PR1: Pending register
func (o *EXTI_Type) SetPR1_PIF0(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetPR1_PIF0() uint32 {
	return volatile.LoadUint32(&o.PR1.Reg) & 0x1
}
func (o *EXTI_Type) SetPR1_PIF1(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetPR1_PIF1() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetPR1_PIF2(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetPR1_PIF2() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetPR1_PIF3(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetPR1_PIF3() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetPR1_PIF4(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetPR1_PIF4() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetPR1_PIF5(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetPR1_PIF5() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetPR1_PIF6(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetPR1_PIF6() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetPR1_PIF7(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetPR1_PIF7() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetPR1_PIF8(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetPR1_PIF8() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetPR1_PIF9(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetPR1_PIF9() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetPR1_PIF10(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetPR1_PIF10() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetPR1_PIF11(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetPR1_PIF11() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetPR1_PIF12(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetPR1_PIF12() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetPR1_PIF13(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetPR1_PIF13() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetPR1_PIF14(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetPR1_PIF14() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetPR1_PIF15(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetPR1_PIF15() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetPR1_PIF16(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetPR1_PIF16() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetPR1_PIF19(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetPR1_PIF19() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetPR1_PIF20(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetPR1_PIF20() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetPR1_PIF21(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetPR1_PIF21() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetPR1_PIF22(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetPR1_PIF22() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetPR1_PIF17(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetPR1_PIF17() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x20000) >> 17
}

// EXTI.IMR2: Interrupt mask register
func (o *EXTI_Type) SetIMR2_IM32(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetIMR2_IM32() uint32 {
	return volatile.LoadUint32(&o.IMR2.Reg) & 0x1
}
func (o *EXTI_Type) SetIMR2_IM33(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetIMR2_IM33() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetIMR2_IM34(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetIMR2_IM34() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetIMR2_IM35(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetIMR2_IM35() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetIMR2_IM36(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetIMR2_IM36() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetIMR2_IM37(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetIMR2_IM37() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetIMR2_IM40(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetIMR2_IM40() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetIMR2_IM41(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetIMR2_IM41() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetIMR2_IM42(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetIMR2_IM42() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetIMR2_IM43(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetIMR2_IM43() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x800) >> 11
}

// EXTI.EMR2: Event mask register
func (o *EXTI_Type) SetEMR2_EM32(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetEMR2_EM32() uint32 {
	return volatile.LoadUint32(&o.EMR2.Reg) & 0x1
}
func (o *EXTI_Type) SetEMR2_EM33(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetEMR2_EM33() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetEMR2_EM34(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetEMR2_EM34() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetEMR2_EM35(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetEMR2_EM35() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetEMR2_EM36(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetEMR2_EM36() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetEMR2_EM37(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetEMR2_EM37() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetEMR2_EM40(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetEMR2_EM40() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetEMR2_EM41(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetEMR2_EM41() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetEMR2_EM42(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetEMR2_EM42() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetEMR2_EM43(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetEMR2_EM43() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x800) >> 11
}

// EXTI.RTSR2: Rising Trigger selection register
func (o *EXTI_Type) SetRTSR2_RT32(value uint32) {
	volatile.StoreUint32(&o.RTSR2.Reg, volatile.LoadUint32(&o.RTSR2.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetRTSR2_RT32() uint32 {
	return volatile.LoadUint32(&o.RTSR2.Reg) & 0x1
}
func (o *EXTI_Type) SetRTSR2_RT33(value uint32) {
	volatile.StoreUint32(&o.RTSR2.Reg, volatile.LoadUint32(&o.RTSR2.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetRTSR2_RT33() uint32 {
	return (volatile.LoadUint32(&o.RTSR2.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetRTSR2_RT40(value uint32) {
	volatile.StoreUint32(&o.RTSR2.Reg, volatile.LoadUint32(&o.RTSR2.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetRTSR2_RT40() uint32 {
	return (volatile.LoadUint32(&o.RTSR2.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetRTSR2_RT41(value uint32) {
	volatile.StoreUint32(&o.RTSR2.Reg, volatile.LoadUint32(&o.RTSR2.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetRTSR2_RT41() uint32 {
	return (volatile.LoadUint32(&o.RTSR2.Reg) & 0x200) >> 9
}

// EXTI.FTSR2: Falling Trigger selection register
func (o *EXTI_Type) SetFTSR2_FT32(value uint32) {
	volatile.StoreUint32(&o.FTSR2.Reg, volatile.LoadUint32(&o.FTSR2.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetFTSR2_FT32() uint32 {
	return volatile.LoadUint32(&o.FTSR2.Reg) & 0x1
}
func (o *EXTI_Type) SetFTSR2_FT33(value uint32) {
	volatile.StoreUint32(&o.FTSR2.Reg, volatile.LoadUint32(&o.FTSR2.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetFTSR2_FT33() uint32 {
	return (volatile.LoadUint32(&o.FTSR2.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetFTSR2_FT40(value uint32) {
	volatile.StoreUint32(&o.FTSR2.Reg, volatile.LoadUint32(&o.FTSR2.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetFTSR2_FT40() uint32 {
	return (volatile.LoadUint32(&o.FTSR2.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetFTSR2_FT41(value uint32) {
	volatile.StoreUint32(&o.FTSR2.Reg, volatile.LoadUint32(&o.FTSR2.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetFTSR2_FT41() uint32 {
	return (volatile.LoadUint32(&o.FTSR2.Reg) & 0x200) >> 9
}

// EXTI.SWIER2: Software interrupt event register
func (o *EXTI_Type) SetSWIER2_SWI32(value uint32) {
	volatile.StoreUint32(&o.SWIER2.Reg, volatile.LoadUint32(&o.SWIER2.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetSWIER2_SWI32() uint32 {
	return volatile.LoadUint32(&o.SWIER2.Reg) & 0x1
}
func (o *EXTI_Type) SetSWIER2_SWI33(value uint32) {
	volatile.StoreUint32(&o.SWIER2.Reg, volatile.LoadUint32(&o.SWIER2.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetSWIER2_SWI33() uint32 {
	return (volatile.LoadUint32(&o.SWIER2.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetSWIER2_SWI40(value uint32) {
	volatile.StoreUint32(&o.SWIER2.Reg, volatile.LoadUint32(&o.SWIER2.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetSWIER2_SWI40() uint32 {
	return (volatile.LoadUint32(&o.SWIER2.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetSWIER2_SWI41(value uint32) {
	volatile.StoreUint32(&o.SWIER2.Reg, volatile.LoadUint32(&o.SWIER2.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetSWIER2_SWI41() uint32 {
	return (volatile.LoadUint32(&o.SWIER2.Reg) & 0x200) >> 9
}

// EXTI.PR2: Pending register
func (o *EXTI_Type) SetPR2_PIF32(value uint32) {
	volatile.StoreUint32(&o.PR2.Reg, volatile.LoadUint32(&o.PR2.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetPR2_PIF32() uint32 {
	return volatile.LoadUint32(&o.PR2.Reg) & 0x1
}
func (o *EXTI_Type) SetPR2_PIF33(value uint32) {
	volatile.StoreUint32(&o.PR2.Reg, volatile.LoadUint32(&o.PR2.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetPR2_PIF33() uint32 {
	return (volatile.LoadUint32(&o.PR2.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetPR2_PIF40(value uint32) {
	volatile.StoreUint32(&o.PR2.Reg, volatile.LoadUint32(&o.PR2.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetPR2_PIF40() uint32 {
	return (volatile.LoadUint32(&o.PR2.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetPR2_PIF41(value uint32) {
	volatile.StoreUint32(&o.PR2.Reg, volatile.LoadUint32(&o.PR2.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetPR2_PIF41() uint32 {
	return (volatile.LoadUint32(&o.PR2.Reg) & 0x200) >> 9
}

// Real-time clock
type RTC_Type struct {
	TR       volatile.Register32 // 0x0
	DR       volatile.Register32 // 0x4
	SSR      volatile.Register32 // 0x8
	ICSR     volatile.Register32 // 0xC
	PRER     volatile.Register32 // 0x10
	WUTR     volatile.Register32 // 0x14
	CR       volatile.Register32 // 0x18
	_        [8]byte
	WPR      volatile.Register32 // 0x24
	CALR     volatile.Register32 // 0x28
	SHIFTR   volatile.Register32 // 0x2C
	TSTR     volatile.Register32 // 0x30
	TSDR     volatile.Register32 // 0x34
	TSSSR    volatile.Register32 // 0x38
	_        [4]byte
	ALRMAR   volatile.Register32 // 0x40
	ALRMASSR volatile.Register32 // 0x44
	ALRMBR   volatile.Register32 // 0x48
	ALRMBSSR volatile.Register32 // 0x4C
	SR       volatile.Register32 // 0x50
	MISR     volatile.Register32 // 0x54
	_        [4]byte
	SCR      volatile.Register32 // 0x5C
}

// RTC.TR: time register
func (o *RTC_Type) SetTR_PM(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTR_PM() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetTR_HT(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetTR_HT() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetTR_HU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetTR_HU() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetTR_MNT(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetTR_MNT() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetTR_MNU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTR_MNU() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTR_ST(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetTR_ST() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetTR_SU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTR_SU() uint32 {
	return volatile.LoadUint32(&o.TR.Reg) & 0xf
}

// RTC.DR: date register
func (o *RTC_Type) SetDR_YT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf00000)|value<<20)
}
func (o *RTC_Type) GetDR_YT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf00000) >> 20
}
func (o *RTC_Type) SetDR_YU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetDR_YU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetDR_WDU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xe000)|value<<13)
}
func (o *RTC_Type) GetDR_WDU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xe000) >> 13
}
func (o *RTC_Type) SetDR_MT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetDR_MT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetDR_MU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetDR_MU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetDR_DT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x30)|value<<4)
}
func (o *RTC_Type) GetDR_DT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x30) >> 4
}
func (o *RTC_Type) SetDR_DU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetDR_DU() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xf
}

// RTC.SSR: sub second register
func (o *RTC_Type) SetSSR_SS(value uint32) {
	volatile.StoreUint32(&o.SSR.Reg, volatile.LoadUint32(&o.SSR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetSSR_SS() uint32 {
	return volatile.LoadUint32(&o.SSR.Reg) & 0xffff
}

// RTC.ICSR: initialization and status register
func (o *RTC_Type) SetICSR_ALRAWF(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetICSR_ALRAWF() uint32 {
	return volatile.LoadUint32(&o.ICSR.Reg) & 0x1
}
func (o *RTC_Type) SetICSR_ALRBWF(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetICSR_ALRBWF() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetICSR_WUTWF(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetICSR_WUTWF() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetICSR_SHPF(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetICSR_SHPF() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetICSR_INITS(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetICSR_INITS() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetICSR_RSF(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetICSR_RSF() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetICSR_INITF(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetICSR_INITF() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetICSR_INIT(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetICSR_INIT() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetICSR_RECALPF(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetICSR_RECALPF() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x10000) >> 16
}

// RTC.PRER: prescaler register
func (o *RTC_Type) SetPRER_PREDIV_A(value uint32) {
	volatile.StoreUint32(&o.PRER.Reg, volatile.LoadUint32(&o.PRER.Reg)&^(0x7f0000)|value<<16)
}
func (o *RTC_Type) GetPRER_PREDIV_A() uint32 {
	return (volatile.LoadUint32(&o.PRER.Reg) & 0x7f0000) >> 16
}
func (o *RTC_Type) SetPRER_PREDIV_S(value uint32) {
	volatile.StoreUint32(&o.PRER.Reg, volatile.LoadUint32(&o.PRER.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetPRER_PREDIV_S() uint32 {
	return volatile.LoadUint32(&o.PRER.Reg) & 0x7fff
}

// RTC.WUTR: wakeup timer register
func (o *RTC_Type) SetWUTR_WUT(value uint32) {
	volatile.StoreUint32(&o.WUTR.Reg, volatile.LoadUint32(&o.WUTR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetWUTR_WUT() uint32 {
	return volatile.LoadUint32(&o.WUTR.Reg) & 0xffff
}

// RTC.CR: control register
func (o *RTC_Type) SetCR_WUCKSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7)|value)
}
func (o *RTC_Type) GetCR_WUCKSEL() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x7
}
func (o *RTC_Type) SetCR_TSEDGE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetCR_TSEDGE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetCR_REFCKON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetCR_REFCKON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetCR_BYPSHAD(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetCR_BYPSHAD() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetCR_FMT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetCR_FMT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetCR_ALRAE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_Type) GetCR_ALRAE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *RTC_Type) SetCR_ALRBE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *RTC_Type) GetCR_ALRBE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *RTC_Type) SetCR_WUTE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *RTC_Type) GetCR_WUTE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *RTC_Type) SetCR_TSE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *RTC_Type) GetCR_TSE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *RTC_Type) SetCR_ALRAIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetCR_ALRAIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetCR_ALRBIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetCR_ALRBIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetCR_WUTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetCR_WUTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetCR_TSIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetCR_TSIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetCR_ADD1H(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetCR_ADD1H() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetCR_SUB1H(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetCR_SUB1H() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetCR_BKP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetCR_BKP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetCR_COSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetCR_COSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *RTC_Type) SetCR_POL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_Type) GetCR_POL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *RTC_Type) SetCR_OSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x600000)|value<<21)
}
func (o *RTC_Type) GetCR_OSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x600000) >> 21
}
func (o *RTC_Type) SetCR_COE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetCR_COE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetCR_ITSE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_Type) GetCR_ITSE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *RTC_Type) SetCR_TAMPTS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000000)|value<<25)
}
func (o *RTC_Type) GetCR_TAMPTS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000000) >> 25
}
func (o *RTC_Type) SetCR_TAMPOE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000000)|value<<26)
}
func (o *RTC_Type) GetCR_TAMPOE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000000) >> 26
}
func (o *RTC_Type) SetCR_TAMPALRM_PU(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000000)|value<<29)
}
func (o *RTC_Type) GetCR_TAMPALRM_PU() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000000) >> 29
}
func (o *RTC_Type) SetCR_TAMPALRM_TYPE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_Type) GetCR_TAMPALRM_TYPE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000000) >> 30
}
func (o *RTC_Type) SetCR_OUT2EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetCR_OUT2EN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000000) >> 31
}

// RTC.WPR: write protection register
func (o *RTC_Type) SetWPR_KEY(value uint32) {
	volatile.StoreUint32(&o.WPR.Reg, volatile.LoadUint32(&o.WPR.Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetWPR_KEY() uint32 {
	return volatile.LoadUint32(&o.WPR.Reg) & 0xff
}

// RTC.CALR: calibration register
func (o *RTC_Type) SetCALR_CALP(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetCALR_CALP() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetCALR_CALW8(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetCALR_CALW8() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetCALR_CALW16(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetCALR_CALW16() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetCALR_CALM(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x1ff)|value)
}
func (o *RTC_Type) GetCALR_CALM() uint32 {
	return volatile.LoadUint32(&o.CALR.Reg) & 0x1ff
}

// RTC.SHIFTR: shift control register
func (o *RTC_Type) SetSHIFTR_ADD1S(value uint32) {
	volatile.StoreUint32(&o.SHIFTR.Reg, volatile.LoadUint32(&o.SHIFTR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetSHIFTR_ADD1S() uint32 {
	return (volatile.LoadUint32(&o.SHIFTR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetSHIFTR_SUBFS(value uint32) {
	volatile.StoreUint32(&o.SHIFTR.Reg, volatile.LoadUint32(&o.SHIFTR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetSHIFTR_SUBFS() uint32 {
	return volatile.LoadUint32(&o.SHIFTR.Reg) & 0x7fff
}

// RTC.TSTR: time stamp time register
func (o *RTC_Type) SetTSTR_SU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTSTR_SU() uint32 {
	return volatile.LoadUint32(&o.TSTR.Reg) & 0xf
}
func (o *RTC_Type) SetTSTR_ST(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetTSTR_ST() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetTSTR_MNU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTSTR_MNU() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTSTR_MNT(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetTSTR_MNT() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetTSTR_HU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetTSTR_HU() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetTSTR_HT(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetTSTR_HT() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetTSTR_PM(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTSTR_PM() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x400000) >> 22
}

// RTC.TSDR: time stamp date register
func (o *RTC_Type) SetTSDR_WDU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xe000)|value<<13)
}
func (o *RTC_Type) GetTSDR_WDU() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0xe000) >> 13
}
func (o *RTC_Type) SetTSDR_MT(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetTSDR_MT() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetTSDR_MU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTSDR_MU() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTSDR_DT(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0x30)|value<<4)
}
func (o *RTC_Type) GetTSDR_DT() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0x30) >> 4
}
func (o *RTC_Type) SetTSDR_DU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTSDR_DU() uint32 {
	return volatile.LoadUint32(&o.TSDR.Reg) & 0xf
}

// RTC.TSSSR: timestamp sub second register
func (o *RTC_Type) SetTSSSR_SS(value uint32) {
	volatile.StoreUint32(&o.TSSSR.Reg, volatile.LoadUint32(&o.TSSSR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetTSSSR_SS() uint32 {
	return volatile.LoadUint32(&o.TSSSR.Reg) & 0xffff
}

// RTC.ALRMAR: alarm A register
func (o *RTC_Type) SetALRMAR_MSK4(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetALRMAR_MSK4() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetALRMAR_WDSEL(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_Type) GetALRMAR_WDSEL() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x40000000) >> 30
}
func (o *RTC_Type) SetALRMAR_DT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x30000000)|value<<28)
}
func (o *RTC_Type) GetALRMAR_DT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x30000000) >> 28
}
func (o *RTC_Type) SetALRMAR_DU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMAR_DU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMAR_MSK3(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetALRMAR_MSK3() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetALRMAR_PM(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetALRMAR_PM() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetALRMAR_HT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetALRMAR_HT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetALRMAR_HU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetALRMAR_HU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetALRMAR_MSK2(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetALRMAR_MSK2() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetALRMAR_MNT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetALRMAR_MNT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetALRMAR_MNU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetALRMAR_MNU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetALRMAR_MSK1(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetALRMAR_MSK1() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetALRMAR_ST(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetALRMAR_ST() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetALRMAR_SU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetALRMAR_SU() uint32 {
	return volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf
}

// RTC.ALRMASSR: alarm A sub second register
func (o *RTC_Type) SetALRMASSR_MASKSS(value uint32) {
	volatile.StoreUint32(&o.ALRMASSR.Reg, volatile.LoadUint32(&o.ALRMASSR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMASSR_MASKSS() uint32 {
	return (volatile.LoadUint32(&o.ALRMASSR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMASSR_SS(value uint32) {
	volatile.StoreUint32(&o.ALRMASSR.Reg, volatile.LoadUint32(&o.ALRMASSR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetALRMASSR_SS() uint32 {
	return volatile.LoadUint32(&o.ALRMASSR.Reg) & 0x7fff
}

// RTC.ALRMBR: alarm B register
func (o *RTC_Type) SetALRMBR_MSK4(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetALRMBR_MSK4() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetALRMBR_WDSEL(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_Type) GetALRMBR_WDSEL() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x40000000) >> 30
}
func (o *RTC_Type) SetALRMBR_DT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x30000000)|value<<28)
}
func (o *RTC_Type) GetALRMBR_DT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x30000000) >> 28
}
func (o *RTC_Type) SetALRMBR_DU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMBR_DU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMBR_MSK3(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetALRMBR_MSK3() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetALRMBR_PM(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetALRMBR_PM() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetALRMBR_HT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetALRMBR_HT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetALRMBR_HU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetALRMBR_HU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetALRMBR_MSK2(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetALRMBR_MSK2() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetALRMBR_MNT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetALRMBR_MNT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetALRMBR_MNU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetALRMBR_MNU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetALRMBR_MSK1(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetALRMBR_MSK1() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetALRMBR_ST(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetALRMBR_ST() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetALRMBR_SU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetALRMBR_SU() uint32 {
	return volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf
}

// RTC.ALRMBSSR: alarm B sub second register
func (o *RTC_Type) SetALRMBSSR_MASKSS(value uint32) {
	volatile.StoreUint32(&o.ALRMBSSR.Reg, volatile.LoadUint32(&o.ALRMBSSR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMBSSR_MASKSS() uint32 {
	return (volatile.LoadUint32(&o.ALRMBSSR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMBSSR_SS(value uint32) {
	volatile.StoreUint32(&o.ALRMBSSR.Reg, volatile.LoadUint32(&o.ALRMBSSR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetALRMBSSR_SS() uint32 {
	return volatile.LoadUint32(&o.ALRMBSSR.Reg) & 0x7fff
}

// RTC.SR: status register
func (o *RTC_Type) SetSR_ALRAF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetSR_ALRAF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *RTC_Type) SetSR_ALRBF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetSR_ALRBF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetSR_WUTF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetSR_WUTF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetSR_TSF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetSR_TSF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetSR_TSOVF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetSR_TSOVF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetSR_ITSF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetSR_ITSF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}

// RTC.MISR: status register
func (o *RTC_Type) SetMISR_ALRAMF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetMISR_ALRAMF() uint32 {
	return volatile.LoadUint32(&o.MISR.Reg) & 0x1
}
func (o *RTC_Type) SetMISR_ALRBMF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetMISR_ALRBMF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetMISR_WUTMF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetMISR_WUTMF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetMISR_TSMF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetMISR_TSMF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetMISR_TSOVMF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetMISR_TSOVMF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetMISR_ITSMF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetMISR_ITSMF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x20) >> 5
}

// RTC.SCR: status register
func (o *RTC_Type) SetSCR_CALRAF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetSCR_CALRAF() uint32 {
	return volatile.LoadUint32(&o.SCR.Reg) & 0x1
}
func (o *RTC_Type) SetSCR_CALRBF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetSCR_CALRBF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetSCR_CWUTF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetSCR_CWUTF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetSCR_CTSF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetSCR_CTSF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetSCR_CTSOVF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetSCR_CTSOVF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetSCR_CITSF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetSCR_CITSF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x20) >> 5
}

// DMA controller
type DMA_Type struct {
	ISR    volatile.Register32 // 0x0
	IFCR   volatile.Register32 // 0x4
	CCR1   volatile.Register32 // 0x8
	CNDTR1 volatile.Register32 // 0xC
	CPAR1  volatile.Register32 // 0x10
	CMAR1  volatile.Register32 // 0x14
	_      [4]byte
	CCR2   volatile.Register32 // 0x1C
	CNDTR2 volatile.Register32 // 0x20
	CPAR2  volatile.Register32 // 0x24
	CMAR2  volatile.Register32 // 0x28
	_      [4]byte
	CCR3   volatile.Register32 // 0x30
	CNDTR3 volatile.Register32 // 0x34
	CPAR3  volatile.Register32 // 0x38
	CMAR3  volatile.Register32 // 0x3C
	_      [4]byte
	CCR4   volatile.Register32 // 0x44
	CNDTR4 volatile.Register32 // 0x48
	CPAR4  volatile.Register32 // 0x4C
	CMAR4  volatile.Register32 // 0x50
	_      [4]byte
	CCR5   volatile.Register32 // 0x58
	CNDTR5 volatile.Register32 // 0x5C
	CPAR5  volatile.Register32 // 0x60
	CMAR5  volatile.Register32 // 0x64
	_      [4]byte
	CCR6   volatile.Register32 // 0x6C
	CNDTR6 volatile.Register32 // 0x70
	CPAR6  volatile.Register32 // 0x74
	CMAR6  volatile.Register32 // 0x78
	_      [4]byte
	CCR7   volatile.Register32 // 0x80
	CNDTR7 volatile.Register32 // 0x84
	CPAR7  volatile.Register32 // 0x88
	CMAR7  volatile.Register32 // 0x8C
	_      [4]byte
	CCR8   volatile.Register32 // 0x94
	CNDTR8 volatile.Register32 // 0x98
	CPAR8  volatile.Register32 // 0x9C
	CMAR8  volatile.Register32 // 0xA0
}

// DMA.ISR: interrupt status register
func (o *DMA_Type) SetISR_TEIF8(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000000)|value<<31)
}
func (o *DMA_Type) GetISR_TEIF8() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000000) >> 31
}
func (o *DMA_Type) SetISR_HTIF8(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000000)|value<<30)
}
func (o *DMA_Type) GetISR_HTIF8() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000000) >> 30
}
func (o *DMA_Type) SetISR_TCIF8(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000000)|value<<29)
}
func (o *DMA_Type) GetISR_TCIF8() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000000) >> 29
}
func (o *DMA_Type) SetISR_GIF8(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000000)|value<<28)
}
func (o *DMA_Type) GetISR_GIF8() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000000) >> 28
}
func (o *DMA_Type) SetISR_TEIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetISR_TEIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetISR_HTIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetISR_HTIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetISR_TCIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetISR_TCIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetISR_GIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetISR_GIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetISR_TEIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetISR_TEIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetISR_HTIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetISR_HTIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetISR_TCIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetISR_TCIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetISR_GIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetISR_GIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetISR_TEIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetISR_TEIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetISR_HTIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetISR_HTIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetISR_TCIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetISR_TCIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetISR_GIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetISR_GIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetISR_TEIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetISR_TEIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetISR_HTIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetISR_HTIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetISR_TCIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetISR_TCIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetISR_GIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetISR_GIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetISR_TEIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetISR_TEIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetISR_HTIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetISR_HTIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetISR_TCIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetISR_TCIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetISR_GIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetISR_GIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetISR_TEIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetISR_TEIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetISR_HTIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetISR_HTIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetISR_TCIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetISR_TCIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetISR_GIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetISR_GIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetISR_TEIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetISR_TEIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetISR_HTIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetISR_HTIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetISR_TCIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetISR_TCIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetISR_GIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetISR_GIF1() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// DMA.IFCR: DMA interrupt flag clear register
func (o *DMA_Type) SetIFCR_TEIF8(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x80000000)|value<<31)
}
func (o *DMA_Type) GetIFCR_TEIF8() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x80000000) >> 31
}
func (o *DMA_Type) SetIFCR_HTIF8(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x40000000)|value<<30)
}
func (o *DMA_Type) GetIFCR_HTIF8() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x40000000) >> 30
}
func (o *DMA_Type) SetIFCR_TCIF8(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20000000)|value<<29)
}
func (o *DMA_Type) GetIFCR_TCIF8() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20000000) >> 29
}
func (o *DMA_Type) SetIFCR_GIF8(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10000000)|value<<28)
}
func (o *DMA_Type) GetIFCR_GIF8() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10000000) >> 28
}
func (o *DMA_Type) SetIFCR_TEIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetIFCR_TEIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetIFCR_HTIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetIFCR_HTIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetIFCR_TCIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetIFCR_TCIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetIFCR_GIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetIFCR_GIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetIFCR_TEIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetIFCR_TEIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetIFCR_HTIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetIFCR_HTIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetIFCR_TCIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetIFCR_TCIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetIFCR_GIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetIFCR_GIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetIFCR_TEIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetIFCR_TEIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetIFCR_HTIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetIFCR_HTIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetIFCR_TCIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetIFCR_TCIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetIFCR_GIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetIFCR_GIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetIFCR_TEIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetIFCR_TEIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetIFCR_HTIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetIFCR_HTIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetIFCR_TCIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetIFCR_TCIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetIFCR_GIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetIFCR_GIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetIFCR_TEIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetIFCR_TEIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetIFCR_HTIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetIFCR_HTIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetIFCR_TCIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetIFCR_TCIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetIFCR_GIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetIFCR_GIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetIFCR_TEIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetIFCR_TEIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetIFCR_HTIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIFCR_HTIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetIFCR_TCIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIFCR_TCIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIFCR_GIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIFCR_GIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIFCR_TEIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIFCR_TEIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIFCR_HTIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIFCR_HTIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIFCR_TCIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIFCR_TCIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIFCR_GIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIFCR_GIF1() uint32 {
	return volatile.LoadUint32(&o.IFCR.Reg) & 0x1
}

// DMA.CCR1: DMA channel 1 configuration register
func (o *DMA_Type) SetCCR1_EN(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR1_EN() uint32 {
	return volatile.LoadUint32(&o.CCR1.Reg) & 0x1
}
func (o *DMA_Type) SetCCR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR1_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR1_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR1_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR1_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR1_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR1_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR1_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR1_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR1_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR1_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR1_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR1_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR1_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR1_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR1_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR1_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR1_PL(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR1_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR1_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR1_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x4000) >> 14
}

// DMA.CNDTR1: channel x number of data to transfer register
func (o *DMA_Type) SetCNDTR1_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR1.Reg, volatile.LoadUint32(&o.CNDTR1.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetCNDTR1_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR1.Reg) & 0xffff
}

// DMA.CPAR1: DMA channel x peripheral address register
func (o *DMA_Type) SetCPAR1(value uint32) {
	volatile.StoreUint32(&o.CPAR1.Reg, value)
}
func (o *DMA_Type) GetCPAR1() uint32 {
	return volatile.LoadUint32(&o.CPAR1.Reg)
}

// DMA.CMAR1: DMA channel x memory address register
func (o *DMA_Type) SetCMAR1(value uint32) {
	volatile.StoreUint32(&o.CMAR1.Reg, value)
}
func (o *DMA_Type) GetCMAR1() uint32 {
	return volatile.LoadUint32(&o.CMAR1.Reg)
}

// DMA.CCR2: DMA channel 2 configuration register
func (o *DMA_Type) SetCCR2_EN(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR2_EN() uint32 {
	return volatile.LoadUint32(&o.CCR2.Reg) & 0x1
}
func (o *DMA_Type) SetCCR2_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR2_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR2_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR2_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR2_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR2_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR2_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR2_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR2_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR2_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR2_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR2_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR2_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR2_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR2_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR2_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR2_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR2_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR2_PL(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR2_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR2_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR2_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x4000) >> 14
}

// DMA.CNDTR2: channel x number of data to transfer register
func (o *DMA_Type) SetCNDTR2_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR2.Reg, volatile.LoadUint32(&o.CNDTR2.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetCNDTR2_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR2.Reg) & 0xffff
}

// DMA.CPAR2: DMA channel x peripheral address register
func (o *DMA_Type) SetCPAR2(value uint32) {
	volatile.StoreUint32(&o.CPAR2.Reg, value)
}
func (o *DMA_Type) GetCPAR2() uint32 {
	return volatile.LoadUint32(&o.CPAR2.Reg)
}

// DMA.CMAR2: DMA channel x memory address register
func (o *DMA_Type) SetCMAR2(value uint32) {
	volatile.StoreUint32(&o.CMAR2.Reg, value)
}
func (o *DMA_Type) GetCMAR2() uint32 {
	return volatile.LoadUint32(&o.CMAR2.Reg)
}

// DMA.CCR3: DMA channel 3 configuration register
func (o *DMA_Type) SetCCR3_EN(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR3_EN() uint32 {
	return volatile.LoadUint32(&o.CCR3.Reg) & 0x1
}
func (o *DMA_Type) SetCCR3_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR3_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR3_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR3_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR3_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR3_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR3_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR3_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR3_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR3_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR3_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR3_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR3_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR3_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR3_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR3_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR3_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR3_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR3_PL(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR3_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR3_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR3_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x4000) >> 14
}

// DMA.CNDTR3: channel x number of data to transfer register
func (o *DMA_Type) SetCNDTR3_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR3.Reg, volatile.LoadUint32(&o.CNDTR3.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetCNDTR3_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR3.Reg) & 0xffff
}

// DMA.CPAR3: DMA channel x peripheral address register
func (o *DMA_Type) SetCPAR3(value uint32) {
	volatile.StoreUint32(&o.CPAR3.Reg, value)
}
func (o *DMA_Type) GetCPAR3() uint32 {
	return volatile.LoadUint32(&o.CPAR3.Reg)
}

// DMA.CMAR3: DMA channel x memory address register
func (o *DMA_Type) SetCMAR3(value uint32) {
	volatile.StoreUint32(&o.CMAR3.Reg, value)
}
func (o *DMA_Type) GetCMAR3() uint32 {
	return volatile.LoadUint32(&o.CMAR3.Reg)
}

// DMA.CCR4: DMA channel 3 configuration register
func (o *DMA_Type) SetCCR4_EN(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR4_EN() uint32 {
	return volatile.LoadUint32(&o.CCR4.Reg) & 0x1
}
func (o *DMA_Type) SetCCR4_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR4_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR4_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR4_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR4_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR4_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR4_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR4_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR4_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR4_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR4_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR4_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR4_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR4_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR4_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR4_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR4_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR4_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR4_PL(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR4_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR4_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR4_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x4000) >> 14
}

// DMA.CNDTR4: channel x number of data to transfer register
func (o *DMA_Type) SetCNDTR4_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR4.Reg, volatile.LoadUint32(&o.CNDTR4.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetCNDTR4_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR4.Reg) & 0xffff
}

// DMA.CPAR4: DMA channel x peripheral address register
func (o *DMA_Type) SetCPAR4(value uint32) {
	volatile.StoreUint32(&o.CPAR4.Reg, value)
}
func (o *DMA_Type) GetCPAR4() uint32 {
	return volatile.LoadUint32(&o.CPAR4.Reg)
}

// DMA.CMAR4: DMA channel x memory address register
func (o *DMA_Type) SetCMAR4(value uint32) {
	volatile.StoreUint32(&o.CMAR4.Reg, value)
}
func (o *DMA_Type) GetCMAR4() uint32 {
	return volatile.LoadUint32(&o.CMAR4.Reg)
}

// DMA.CCR5: DMA channel 4 configuration register
func (o *DMA_Type) SetCCR5_EN(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR5_EN() uint32 {
	return volatile.LoadUint32(&o.CCR5.Reg) & 0x1
}
func (o *DMA_Type) SetCCR5_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR5_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR5_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR5_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR5_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR5_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR5_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR5_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR5_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR5_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR5_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR5_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR5_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR5_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR5_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR5_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR5_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR5_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR5_PL(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR5_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR5_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR5_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x4000) >> 14
}

// DMA.CNDTR5: channel x number of data to transfer register
func (o *DMA_Type) SetCNDTR5_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR5.Reg, volatile.LoadUint32(&o.CNDTR5.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetCNDTR5_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR5.Reg) & 0xffff
}

// DMA.CPAR5: DMA channel x peripheral address register
func (o *DMA_Type) SetCPAR5(value uint32) {
	volatile.StoreUint32(&o.CPAR5.Reg, value)
}
func (o *DMA_Type) GetCPAR5() uint32 {
	return volatile.LoadUint32(&o.CPAR5.Reg)
}

// DMA.CMAR5: DMA channel x memory address register
func (o *DMA_Type) SetCMAR5(value uint32) {
	volatile.StoreUint32(&o.CMAR5.Reg, value)
}
func (o *DMA_Type) GetCMAR5() uint32 {
	return volatile.LoadUint32(&o.CMAR5.Reg)
}

// DMA.CCR6: DMA channel 5 configuration register
func (o *DMA_Type) SetCCR6_EN(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR6_EN() uint32 {
	return volatile.LoadUint32(&o.CCR6.Reg) & 0x1
}
func (o *DMA_Type) SetCCR6_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR6_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR6_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR6_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR6_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR6_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR6_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR6_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR6_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR6_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR6_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR6_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR6_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR6_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR6_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR6_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR6_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR6_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR6_PL(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR6_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR6_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR6_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x4000) >> 14
}

// DMA.CNDTR6: channel x number of data to transfer register
func (o *DMA_Type) SetCNDTR6_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR6.Reg, volatile.LoadUint32(&o.CNDTR6.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetCNDTR6_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR6.Reg) & 0xffff
}

// DMA.CPAR6: DMA channel x peripheral address register
func (o *DMA_Type) SetCPAR6(value uint32) {
	volatile.StoreUint32(&o.CPAR6.Reg, value)
}
func (o *DMA_Type) GetCPAR6() uint32 {
	return volatile.LoadUint32(&o.CPAR6.Reg)
}

// DMA.CMAR6: DMA channel x memory address register
func (o *DMA_Type) SetCMAR6(value uint32) {
	volatile.StoreUint32(&o.CMAR6.Reg, value)
}
func (o *DMA_Type) GetCMAR6() uint32 {
	return volatile.LoadUint32(&o.CMAR6.Reg)
}

// DMA.CCR7: DMA channel 6 configuration register
func (o *DMA_Type) SetCCR7_EN(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR7_EN() uint32 {
	return volatile.LoadUint32(&o.CCR7.Reg) & 0x1
}
func (o *DMA_Type) SetCCR7_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR7_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR7_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR7_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR7_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR7_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR7_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR7_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR7_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR7_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR7_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR7_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR7_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR7_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR7_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR7_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR7_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR7_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR7_PL(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR7_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR7_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR7_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x4000) >> 14
}

// DMA.CNDTR7: channel x number of data to transfer register
func (o *DMA_Type) SetCNDTR7_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR7.Reg, volatile.LoadUint32(&o.CNDTR7.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetCNDTR7_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR7.Reg) & 0xffff
}

// DMA.CPAR7: DMA channel x peripheral address register
func (o *DMA_Type) SetCPAR7(value uint32) {
	volatile.StoreUint32(&o.CPAR7.Reg, value)
}
func (o *DMA_Type) GetCPAR7() uint32 {
	return volatile.LoadUint32(&o.CPAR7.Reg)
}

// DMA.CMAR7: DMA channel x memory address register
func (o *DMA_Type) SetCMAR7(value uint32) {
	volatile.StoreUint32(&o.CMAR7.Reg, value)
}
func (o *DMA_Type) GetCMAR7() uint32 {
	return volatile.LoadUint32(&o.CMAR7.Reg)
}

// DMA.CCR8: DMA channel 7 configuration register
func (o *DMA_Type) SetCCR8_EN(value uint32) {
	volatile.StoreUint32(&o.CCR8.Reg, volatile.LoadUint32(&o.CCR8.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR8_EN() uint32 {
	return volatile.LoadUint32(&o.CCR8.Reg) & 0x1
}
func (o *DMA_Type) SetCCR8_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR8.Reg, volatile.LoadUint32(&o.CCR8.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR8_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR8.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR8_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR8.Reg, volatile.LoadUint32(&o.CCR8.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR8_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR8.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR8_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR8.Reg, volatile.LoadUint32(&o.CCR8.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR8_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR8.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR8_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR8.Reg, volatile.LoadUint32(&o.CCR8.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR8_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR8.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR8_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR8.Reg, volatile.LoadUint32(&o.CCR8.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR8_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR8.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR8_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR8.Reg, volatile.LoadUint32(&o.CCR8.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR8_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR8.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR8_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR8.Reg, volatile.LoadUint32(&o.CCR8.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR8_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR8.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR8_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR8.Reg, volatile.LoadUint32(&o.CCR8.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR8_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR8.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR8_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR8.Reg, volatile.LoadUint32(&o.CCR8.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR8_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR8.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR8_PL(value uint32) {
	volatile.StoreUint32(&o.CCR8.Reg, volatile.LoadUint32(&o.CCR8.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR8_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR8.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR8_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR8.Reg, volatile.LoadUint32(&o.CCR8.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR8_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR8.Reg) & 0x4000) >> 14
}

// DMA.CNDTR8: channel x number of data to transfer register
func (o *DMA_Type) SetCNDTR8_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR8.Reg, volatile.LoadUint32(&o.CNDTR8.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetCNDTR8_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR8.Reg) & 0xffff
}

// DMA.CPAR8: DMA channel x peripheral address register
func (o *DMA_Type) SetCPAR8(value uint32) {
	volatile.StoreUint32(&o.CPAR8.Reg, value)
}
func (o *DMA_Type) GetCPAR8() uint32 {
	return volatile.LoadUint32(&o.CPAR8.Reg)
}

// DMA.CMAR8: DMA channel x memory address register
func (o *DMA_Type) SetCMAR8(value uint32) {
	volatile.StoreUint32(&o.CMAR8.Reg, value)
}
func (o *DMA_Type) GetCMAR8() uint32 {
	return volatile.LoadUint32(&o.CMAR8.Reg)
}

// DMAMUX
type DMAMUX_Type struct {
	C0CR  volatile.Register32 // 0x0
	C1CR  volatile.Register32 // 0x4
	C2CR  volatile.Register32 // 0x8
	C3CR  volatile.Register32 // 0xC
	C4CR  volatile.Register32 // 0x10
	C5CR  volatile.Register32 // 0x14
	C6CR  volatile.Register32 // 0x18
	C7CR  volatile.Register32 // 0x1C
	C8CR  volatile.Register32 // 0x20
	C9CR  volatile.Register32 // 0x24
	C10CR volatile.Register32 // 0x28
	C11CR volatile.Register32 // 0x2C
	C12CR volatile.Register32 // 0x30
	C13CR volatile.Register32 // 0x34
	C14CR volatile.Register32 // 0x38
	C15CR volatile.Register32 // 0x3C
	_     [64]byte
	CSR   volatile.Register32 // 0x80
	CFR   volatile.Register32 // 0x84
	_     [120]byte
	RG0CR volatile.Register32 // 0x100
	RG1CR volatile.Register32 // 0x104
	RG2CR volatile.Register32 // 0x108
	RG3CR volatile.Register32 // 0x10C
	_     [48]byte
	RGSR  volatile.Register32 // 0x140
	RGCFR volatile.Register32 // 0x144
}

// DMAMUX.C0CR: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetC0CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC0CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C0CR.Reg) & 0x7f
}
func (o *DMAMUX_Type) SetC0CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC0CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC0CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC0CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC0CR_SE(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC0CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC0CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC0CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC0CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC0CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC0CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC0CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0x1f000000) >> 24
}

// DMAMUX.C1CR: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetC1CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC1CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C1CR.Reg) & 0x7f
}
func (o *DMAMUX_Type) SetC1CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC1CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC1CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC1CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC1CR_SE(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC1CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC1CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC1CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC1CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC1CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC1CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC1CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x1f000000) >> 24
}

// DMAMUX.C2CR: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetC2CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC2CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C2CR.Reg) & 0x7f
}
func (o *DMAMUX_Type) SetC2CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC2CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC2CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC2CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC2CR_SE(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC2CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC2CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC2CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC2CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC2CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC2CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC2CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x1f000000) >> 24
}

// DMAMUX.C3CR: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetC3CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC3CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C3CR.Reg) & 0x7f
}
func (o *DMAMUX_Type) SetC3CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC3CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC3CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC3CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC3CR_SE(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC3CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC3CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC3CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC3CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC3CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC3CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC3CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0x1f000000) >> 24
}

// DMAMUX.C4CR: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetC4CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC4CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C4CR.Reg) & 0x7f
}
func (o *DMAMUX_Type) SetC4CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC4CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC4CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC4CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC4CR_SE(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC4CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC4CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC4CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC4CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC4CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC4CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC4CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0x1f000000) >> 24
}

// DMAMUX.C5CR: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetC5CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC5CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C5CR.Reg) & 0x7f
}
func (o *DMAMUX_Type) SetC5CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC5CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC5CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC5CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC5CR_SE(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC5CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC5CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC5CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC5CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC5CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC5CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC5CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0x1f000000) >> 24
}

// DMAMUX.C6CR: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetC6CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC6CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C6CR.Reg) & 0x7f
}
func (o *DMAMUX_Type) SetC6CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC6CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC6CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC6CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC6CR_SE(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC6CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC6CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC6CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC6CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC6CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC6CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC6CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0x1f000000) >> 24
}

// DMAMUX.C7CR: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetC7CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C7CR.Reg, volatile.LoadUint32(&o.C7CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC7CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C7CR.Reg) & 0x7f
}
func (o *DMAMUX_Type) SetC7CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C7CR.Reg, volatile.LoadUint32(&o.C7CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC7CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C7CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC7CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C7CR.Reg, volatile.LoadUint32(&o.C7CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC7CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C7CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC7CR_SE(value uint32) {
	volatile.StoreUint32(&o.C7CR.Reg, volatile.LoadUint32(&o.C7CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC7CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C7CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC7CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C7CR.Reg, volatile.LoadUint32(&o.C7CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC7CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C7CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC7CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C7CR.Reg, volatile.LoadUint32(&o.C7CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC7CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C7CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC7CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C7CR.Reg, volatile.LoadUint32(&o.C7CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC7CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C7CR.Reg) & 0x1f000000) >> 24
}

// DMAMUX.C8CR: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetC8CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C8CR.Reg, volatile.LoadUint32(&o.C8CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC8CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C8CR.Reg) & 0x7f
}
func (o *DMAMUX_Type) SetC8CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C8CR.Reg, volatile.LoadUint32(&o.C8CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC8CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C8CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC8CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C8CR.Reg, volatile.LoadUint32(&o.C8CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC8CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C8CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC8CR_SE(value uint32) {
	volatile.StoreUint32(&o.C8CR.Reg, volatile.LoadUint32(&o.C8CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC8CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C8CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC8CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C8CR.Reg, volatile.LoadUint32(&o.C8CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC8CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C8CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC8CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C8CR.Reg, volatile.LoadUint32(&o.C8CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC8CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C8CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC8CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C8CR.Reg, volatile.LoadUint32(&o.C8CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC8CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C8CR.Reg) & 0x1f000000) >> 24
}

// DMAMUX.C9CR: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetC9CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C9CR.Reg, volatile.LoadUint32(&o.C9CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC9CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C9CR.Reg) & 0x7f
}
func (o *DMAMUX_Type) SetC9CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C9CR.Reg, volatile.LoadUint32(&o.C9CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC9CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C9CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC9CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C9CR.Reg, volatile.LoadUint32(&o.C9CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC9CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C9CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC9CR_SE(value uint32) {
	volatile.StoreUint32(&o.C9CR.Reg, volatile.LoadUint32(&o.C9CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC9CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C9CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC9CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C9CR.Reg, volatile.LoadUint32(&o.C9CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC9CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C9CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC9CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C9CR.Reg, volatile.LoadUint32(&o.C9CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC9CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C9CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC9CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C9CR.Reg, volatile.LoadUint32(&o.C9CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC9CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C9CR.Reg) & 0x1f000000) >> 24
}

// DMAMUX.C10CR: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetC10CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C10CR.Reg, volatile.LoadUint32(&o.C10CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC10CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C10CR.Reg) & 0x7f
}
func (o *DMAMUX_Type) SetC10CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C10CR.Reg, volatile.LoadUint32(&o.C10CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC10CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C10CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC10CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C10CR.Reg, volatile.LoadUint32(&o.C10CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC10CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C10CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC10CR_SE(value uint32) {
	volatile.StoreUint32(&o.C10CR.Reg, volatile.LoadUint32(&o.C10CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC10CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C10CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC10CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C10CR.Reg, volatile.LoadUint32(&o.C10CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC10CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C10CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC10CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C10CR.Reg, volatile.LoadUint32(&o.C10CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC10CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C10CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC10CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C10CR.Reg, volatile.LoadUint32(&o.C10CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC10CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C10CR.Reg) & 0x1f000000) >> 24
}

// DMAMUX.C11CR: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetC11CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C11CR.Reg, volatile.LoadUint32(&o.C11CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC11CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C11CR.Reg) & 0x7f
}
func (o *DMAMUX_Type) SetC11CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C11CR.Reg, volatile.LoadUint32(&o.C11CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC11CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C11CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC11CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C11CR.Reg, volatile.LoadUint32(&o.C11CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC11CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C11CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC11CR_SE(value uint32) {
	volatile.StoreUint32(&o.C11CR.Reg, volatile.LoadUint32(&o.C11CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC11CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C11CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC11CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C11CR.Reg, volatile.LoadUint32(&o.C11CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC11CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C11CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC11CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C11CR.Reg, volatile.LoadUint32(&o.C11CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC11CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C11CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC11CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C11CR.Reg, volatile.LoadUint32(&o.C11CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC11CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C11CR.Reg) & 0x1f000000) >> 24
}

// DMAMUX.C12CR: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetC12CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C12CR.Reg, volatile.LoadUint32(&o.C12CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC12CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C12CR.Reg) & 0x7f
}
func (o *DMAMUX_Type) SetC12CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C12CR.Reg, volatile.LoadUint32(&o.C12CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC12CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C12CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC12CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C12CR.Reg, volatile.LoadUint32(&o.C12CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC12CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C12CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC12CR_SE(value uint32) {
	volatile.StoreUint32(&o.C12CR.Reg, volatile.LoadUint32(&o.C12CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC12CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C12CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC12CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C12CR.Reg, volatile.LoadUint32(&o.C12CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC12CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C12CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC12CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C12CR.Reg, volatile.LoadUint32(&o.C12CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC12CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C12CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC12CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C12CR.Reg, volatile.LoadUint32(&o.C12CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC12CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C12CR.Reg) & 0x1f000000) >> 24
}

// DMAMUX.C13CR: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetC13CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C13CR.Reg, volatile.LoadUint32(&o.C13CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC13CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C13CR.Reg) & 0x7f
}
func (o *DMAMUX_Type) SetC13CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C13CR.Reg, volatile.LoadUint32(&o.C13CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC13CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C13CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC13CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C13CR.Reg, volatile.LoadUint32(&o.C13CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC13CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C13CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC13CR_SE(value uint32) {
	volatile.StoreUint32(&o.C13CR.Reg, volatile.LoadUint32(&o.C13CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC13CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C13CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC13CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C13CR.Reg, volatile.LoadUint32(&o.C13CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC13CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C13CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC13CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C13CR.Reg, volatile.LoadUint32(&o.C13CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC13CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C13CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC13CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C13CR.Reg, volatile.LoadUint32(&o.C13CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC13CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C13CR.Reg) & 0x1f000000) >> 24
}

// DMAMUX.C14CR: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetC14CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C14CR.Reg, volatile.LoadUint32(&o.C14CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC14CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C14CR.Reg) & 0x7f
}
func (o *DMAMUX_Type) SetC14CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C14CR.Reg, volatile.LoadUint32(&o.C14CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC14CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C14CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC14CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C14CR.Reg, volatile.LoadUint32(&o.C14CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC14CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C14CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC14CR_SE(value uint32) {
	volatile.StoreUint32(&o.C14CR.Reg, volatile.LoadUint32(&o.C14CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC14CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C14CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC14CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C14CR.Reg, volatile.LoadUint32(&o.C14CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC14CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C14CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC14CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C14CR.Reg, volatile.LoadUint32(&o.C14CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC14CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C14CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC14CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C14CR.Reg, volatile.LoadUint32(&o.C14CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC14CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C14CR.Reg) & 0x1f000000) >> 24
}

// DMAMUX.C15CR: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetC15CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C15CR.Reg, volatile.LoadUint32(&o.C15CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC15CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C15CR.Reg) & 0x7f
}
func (o *DMAMUX_Type) SetC15CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C15CR.Reg, volatile.LoadUint32(&o.C15CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC15CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C15CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC15CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C15CR.Reg, volatile.LoadUint32(&o.C15CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC15CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C15CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC15CR_SE(value uint32) {
	volatile.StoreUint32(&o.C15CR.Reg, volatile.LoadUint32(&o.C15CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC15CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C15CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC15CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C15CR.Reg, volatile.LoadUint32(&o.C15CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC15CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C15CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC15CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C15CR.Reg, volatile.LoadUint32(&o.C15CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC15CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C15CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC15CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C15CR.Reg, volatile.LoadUint32(&o.C15CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC15CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C15CR.Reg) & 0x1f000000) >> 24
}

// DMAMUX.CSR: DMAMUX request line multiplexer interrupt channel status register
func (o *DMAMUX_Type) SetCSR_SOF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0xffff)|value)
}
func (o *DMAMUX_Type) GetCSR_SOF() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0xffff
}

// DMAMUX.CFR: DMAMUX request line multiplexer interrupt clear flag register
func (o *DMAMUX_Type) SetCFR_CSOF(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0xffff)|value)
}
func (o *DMAMUX_Type) GetCFR_CSOF() uint32 {
	return volatile.LoadUint32(&o.CFR.Reg) & 0xffff
}

// DMAMUX.RG0CR: DMAMux - DMA request generator channel x control register
func (o *DMAMUX_Type) SetRG0CR_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RG0CR.Reg, volatile.LoadUint32(&o.RG0CR.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRG0CR_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RG0CR.Reg) & 0x1f
}
func (o *DMAMUX_Type) SetRG0CR_OIE(value uint32) {
	volatile.StoreUint32(&o.RG0CR.Reg, volatile.LoadUint32(&o.RG0CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRG0CR_OIE() uint32 {
	return (volatile.LoadUint32(&o.RG0CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRG0CR_GE(value uint32) {
	volatile.StoreUint32(&o.RG0CR.Reg, volatile.LoadUint32(&o.RG0CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRG0CR_GE() uint32 {
	return (volatile.LoadUint32(&o.RG0CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRG0CR_GPOL(value uint32) {
	volatile.StoreUint32(&o.RG0CR.Reg, volatile.LoadUint32(&o.RG0CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRG0CR_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RG0CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRG0CR_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RG0CR.Reg, volatile.LoadUint32(&o.RG0CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRG0CR_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RG0CR.Reg) & 0xf80000) >> 19
}

// DMAMUX.RG1CR: DMAMux - DMA request generator channel x control register
func (o *DMAMUX_Type) SetRG1CR_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RG1CR.Reg, volatile.LoadUint32(&o.RG1CR.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRG1CR_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RG1CR.Reg) & 0x1f
}
func (o *DMAMUX_Type) SetRG1CR_OIE(value uint32) {
	volatile.StoreUint32(&o.RG1CR.Reg, volatile.LoadUint32(&o.RG1CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRG1CR_OIE() uint32 {
	return (volatile.LoadUint32(&o.RG1CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRG1CR_GE(value uint32) {
	volatile.StoreUint32(&o.RG1CR.Reg, volatile.LoadUint32(&o.RG1CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRG1CR_GE() uint32 {
	return (volatile.LoadUint32(&o.RG1CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRG1CR_GPOL(value uint32) {
	volatile.StoreUint32(&o.RG1CR.Reg, volatile.LoadUint32(&o.RG1CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRG1CR_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RG1CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRG1CR_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RG1CR.Reg, volatile.LoadUint32(&o.RG1CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRG1CR_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RG1CR.Reg) & 0xf80000) >> 19
}

// DMAMUX.RG2CR: DMAMux - DMA request generator channel x control register
func (o *DMAMUX_Type) SetRG2CR_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RG2CR.Reg, volatile.LoadUint32(&o.RG2CR.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRG2CR_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RG2CR.Reg) & 0x1f
}
func (o *DMAMUX_Type) SetRG2CR_OIE(value uint32) {
	volatile.StoreUint32(&o.RG2CR.Reg, volatile.LoadUint32(&o.RG2CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRG2CR_OIE() uint32 {
	return (volatile.LoadUint32(&o.RG2CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRG2CR_GE(value uint32) {
	volatile.StoreUint32(&o.RG2CR.Reg, volatile.LoadUint32(&o.RG2CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRG2CR_GE() uint32 {
	return (volatile.LoadUint32(&o.RG2CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRG2CR_GPOL(value uint32) {
	volatile.StoreUint32(&o.RG2CR.Reg, volatile.LoadUint32(&o.RG2CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRG2CR_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RG2CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRG2CR_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RG2CR.Reg, volatile.LoadUint32(&o.RG2CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRG2CR_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RG2CR.Reg) & 0xf80000) >> 19
}

// DMAMUX.RG3CR: DMAMux - DMA request generator channel x control register
func (o *DMAMUX_Type) SetRG3CR_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RG3CR.Reg, volatile.LoadUint32(&o.RG3CR.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRG3CR_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RG3CR.Reg) & 0x1f
}
func (o *DMAMUX_Type) SetRG3CR_OIE(value uint32) {
	volatile.StoreUint32(&o.RG3CR.Reg, volatile.LoadUint32(&o.RG3CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRG3CR_OIE() uint32 {
	return (volatile.LoadUint32(&o.RG3CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRG3CR_GE(value uint32) {
	volatile.StoreUint32(&o.RG3CR.Reg, volatile.LoadUint32(&o.RG3CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRG3CR_GE() uint32 {
	return (volatile.LoadUint32(&o.RG3CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRG3CR_GPOL(value uint32) {
	volatile.StoreUint32(&o.RG3CR.Reg, volatile.LoadUint32(&o.RG3CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRG3CR_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RG3CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRG3CR_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RG3CR.Reg, volatile.LoadUint32(&o.RG3CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRG3CR_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RG3CR.Reg) & 0xf80000) >> 19
}

// DMAMUX.RGSR: DMAMux - DMA request generator status register
func (o *DMAMUX_Type) SetRGSR_OF(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0xf)|value)
}
func (o *DMAMUX_Type) GetRGSR_OF() uint32 {
	return volatile.LoadUint32(&o.RGSR.Reg) & 0xf
}

// DMAMUX.RGCFR: DMAMux - DMA request generator clear flag register
func (o *DMAMUX_Type) SetRGCFR_COF(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0xf)|value)
}
func (o *DMAMUX_Type) GetRGCFR_COF() uint32 {
	return volatile.LoadUint32(&o.RGCFR.Reg) & 0xf
}

// System configuration controller
type SYSCFG_Type struct {
	MEMRMP  volatile.Register32 // 0x0
	CFGR1   volatile.Register32 // 0x4
	EXTICR1 volatile.Register32 // 0x8
	EXTICR2 volatile.Register32 // 0xC
	EXTICR3 volatile.Register32 // 0x10
	EXTICR4 volatile.Register32 // 0x14
	SCSR    volatile.Register32 // 0x18
	CFGR2   volatile.Register32 // 0x1C
	SWPR    volatile.Register32 // 0x20
	SKR     volatile.Register32 // 0x24
}

// SYSCFG.MEMRMP: Remap Memory register
func (o *SYSCFG_Type) SetMEMRMP_MEM_MODE(value uint32) {
	volatile.StoreUint32(&o.MEMRMP.Reg, volatile.LoadUint32(&o.MEMRMP.Reg)&^(0x7)|value)
}
func (o *SYSCFG_Type) GetMEMRMP_MEM_MODE() uint32 {
	return volatile.LoadUint32(&o.MEMRMP.Reg) & 0x7
}
func (o *SYSCFG_Type) SetMEMRMP_FB_mode(value uint32) {
	volatile.StoreUint32(&o.MEMRMP.Reg, volatile.LoadUint32(&o.MEMRMP.Reg)&^(0x100)|value<<8)
}
func (o *SYSCFG_Type) GetMEMRMP_FB_mode() uint32 {
	return (volatile.LoadUint32(&o.MEMRMP.Reg) & 0x100) >> 8
}

// SYSCFG.CFGR1: peripheral mode configuration register
func (o *SYSCFG_Type) SetCFGR1_BOOSTEN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x100)|value<<8)
}
func (o *SYSCFG_Type) GetCFGR1_BOOSTEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x100) >> 8
}
func (o *SYSCFG_Type) SetCFGR1_ANASWVDD(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x200)|value<<9)
}
func (o *SYSCFG_Type) GetCFGR1_ANASWVDD() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x200) >> 9
}
func (o *SYSCFG_Type) SetCFGR1_I2C_PB6_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCFG_Type) GetCFGR1_I2C_PB6_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x10000) >> 16
}
func (o *SYSCFG_Type) SetCFGR1_I2C_PB7_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x20000)|value<<17)
}
func (o *SYSCFG_Type) GetCFGR1_I2C_PB7_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x20000) >> 17
}
func (o *SYSCFG_Type) SetCFGR1_I2C_PB8_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCFG_Type) GetCFGR1_I2C_PB8_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x40000) >> 18
}
func (o *SYSCFG_Type) SetCFGR1_I2C_PB9_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x80000)|value<<19)
}
func (o *SYSCFG_Type) GetCFGR1_I2C_PB9_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x80000) >> 19
}
func (o *SYSCFG_Type) SetCFGR1_I2C1_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCFG_Type) GetCFGR1_I2C1_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x100000) >> 20
}
func (o *SYSCFG_Type) SetCFGR1_I2C2_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x200000)|value<<21)
}
func (o *SYSCFG_Type) GetCFGR1_I2C2_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x200000) >> 21
}
func (o *SYSCFG_Type) SetCFGR1_I2C3_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x400000)|value<<22)
}
func (o *SYSCFG_Type) GetCFGR1_I2C3_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x400000) >> 22
}
func (o *SYSCFG_Type) SetCFGR1_I2C4_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x800000)|value<<23)
}
func (o *SYSCFG_Type) GetCFGR1_I2C4_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x800000) >> 23
}
func (o *SYSCFG_Type) SetCFGR1_FPU_IE(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0xfc000000)|value<<26)
}
func (o *SYSCFG_Type) GetCFGR1_FPU_IE() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0xfc000000) >> 26
}

// SYSCFG.EXTICR1: external interrupt configuration register 1
func (o *SYSCFG_Type) SetEXTICR1_EXTI3(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI3() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI2(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI2() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI1(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI1() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI0(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI0() uint32 {
	return volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf
}

// SYSCFG.EXTICR2: external interrupt configuration register 2
func (o *SYSCFG_Type) SetEXTICR2_EXTI7(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI7() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI6(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI6() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI5(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI5() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI4(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI4() uint32 {
	return volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf
}

// SYSCFG.EXTICR3: external interrupt configuration register 3
func (o *SYSCFG_Type) SetEXTICR3_EXTI11(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI11() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI10(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI10() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI9(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI9() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI8(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI8() uint32 {
	return volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf
}

// SYSCFG.EXTICR4: external interrupt configuration register 4
func (o *SYSCFG_Type) SetEXTICR4_EXTI15(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI15() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI14(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI14() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI13(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI13() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI12(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI12() uint32 {
	return volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf
}

// SYSCFG.SCSR: CCM SRAM control and status register
func (o *SYSCFG_Type) SetSCSR_CCMER(value uint32) {
	volatile.StoreUint32(&o.SCSR.Reg, volatile.LoadUint32(&o.SCSR.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetSCSR_CCMER() uint32 {
	return volatile.LoadUint32(&o.SCSR.Reg) & 0x1
}
func (o *SYSCFG_Type) SetSCSR_CCMBSY(value uint32) {
	volatile.StoreUint32(&o.SCSR.Reg, volatile.LoadUint32(&o.SCSR.Reg)&^(0x2)|value<<1)
}
func (o *SYSCFG_Type) GetSCSR_CCMBSY() uint32 {
	return (volatile.LoadUint32(&o.SCSR.Reg) & 0x2) >> 1
}

// SYSCFG.CFGR2: configuration register 2
func (o *SYSCFG_Type) SetCFGR2_CLL(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetCFGR2_CLL() uint32 {
	return volatile.LoadUint32(&o.CFGR2.Reg) & 0x1
}
func (o *SYSCFG_Type) SetCFGR2_SPL(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x2)|value<<1)
}
func (o *SYSCFG_Type) GetCFGR2_SPL() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x2) >> 1
}
func (o *SYSCFG_Type) SetCFGR2_PVDL(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x4)|value<<2)
}
func (o *SYSCFG_Type) GetCFGR2_PVDL() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x4) >> 2
}
func (o *SYSCFG_Type) SetCFGR2_ECCL(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x8)|value<<3)
}
func (o *SYSCFG_Type) GetCFGR2_ECCL() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x8) >> 3
}
func (o *SYSCFG_Type) SetCFGR2_SPF(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x100)|value<<8)
}
func (o *SYSCFG_Type) GetCFGR2_SPF() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x100) >> 8
}

// SYSCFG.SWPR: SRAM Write protection register 1
func (o *SYSCFG_Type) SetSWPR_Page0_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetSWPR_Page0_WP() uint32 {
	return volatile.LoadUint32(&o.SWPR.Reg) & 0x1
}
func (o *SYSCFG_Type) SetSWPR_Page1_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x2)|value<<1)
}
func (o *SYSCFG_Type) GetSWPR_Page1_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x2) >> 1
}
func (o *SYSCFG_Type) SetSWPR_Page2_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x4)|value<<2)
}
func (o *SYSCFG_Type) GetSWPR_Page2_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x4) >> 2
}
func (o *SYSCFG_Type) SetSWPR_Page3_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x8)|value<<3)
}
func (o *SYSCFG_Type) GetSWPR_Page3_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x8) >> 3
}
func (o *SYSCFG_Type) SetSWPR_Page4_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x10)|value<<4)
}
func (o *SYSCFG_Type) GetSWPR_Page4_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x10) >> 4
}
func (o *SYSCFG_Type) SetSWPR_Page5_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x20)|value<<5)
}
func (o *SYSCFG_Type) GetSWPR_Page5_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x20) >> 5
}
func (o *SYSCFG_Type) SetSWPR_Page6_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x40)|value<<6)
}
func (o *SYSCFG_Type) GetSWPR_Page6_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x40) >> 6
}
func (o *SYSCFG_Type) SetSWPR_Page7_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x80)|value<<7)
}
func (o *SYSCFG_Type) GetSWPR_Page7_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x80) >> 7
}
func (o *SYSCFG_Type) SetSWPR_Page8_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x100)|value<<8)
}
func (o *SYSCFG_Type) GetSWPR_Page8_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x100) >> 8
}
func (o *SYSCFG_Type) SetSWPR_Page9_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x200)|value<<9)
}
func (o *SYSCFG_Type) GetSWPR_Page9_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x200) >> 9
}
func (o *SYSCFG_Type) SetSWPR_Page10_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x400)|value<<10)
}
func (o *SYSCFG_Type) GetSWPR_Page10_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x400) >> 10
}
func (o *SYSCFG_Type) SetSWPR_Page11_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x800)|value<<11)
}
func (o *SYSCFG_Type) GetSWPR_Page11_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x800) >> 11
}
func (o *SYSCFG_Type) SetSWPR_Page12_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCFG_Type) GetSWPR_Page12_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x1000) >> 12
}
func (o *SYSCFG_Type) SetSWPR_Page13_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCFG_Type) GetSWPR_Page13_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x2000) >> 13
}
func (o *SYSCFG_Type) SetSWPR_Page14_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x4000)|value<<14)
}
func (o *SYSCFG_Type) GetSWPR_Page14_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x4000) >> 14
}
func (o *SYSCFG_Type) SetSWPR_Page15_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x8000)|value<<15)
}
func (o *SYSCFG_Type) GetSWPR_Page15_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x8000) >> 15
}
func (o *SYSCFG_Type) SetSWPR_Page16_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCFG_Type) GetSWPR_Page16_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x10000) >> 16
}
func (o *SYSCFG_Type) SetSWPR_Page17_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x20000)|value<<17)
}
func (o *SYSCFG_Type) GetSWPR_Page17_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x20000) >> 17
}
func (o *SYSCFG_Type) SetSWPR_Page18_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCFG_Type) GetSWPR_Page18_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x40000) >> 18
}
func (o *SYSCFG_Type) SetSWPR_Page19_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x80000)|value<<19)
}
func (o *SYSCFG_Type) GetSWPR_Page19_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x80000) >> 19
}
func (o *SYSCFG_Type) SetSWPR_Page20_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCFG_Type) GetSWPR_Page20_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x100000) >> 20
}
func (o *SYSCFG_Type) SetSWPR_Page21_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x200000)|value<<21)
}
func (o *SYSCFG_Type) GetSWPR_Page21_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x200000) >> 21
}
func (o *SYSCFG_Type) SetSWPR_Page22_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x400000)|value<<22)
}
func (o *SYSCFG_Type) GetSWPR_Page22_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x400000) >> 22
}
func (o *SYSCFG_Type) SetSWPR_Page23_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x800000)|value<<23)
}
func (o *SYSCFG_Type) GetSWPR_Page23_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x800000) >> 23
}
func (o *SYSCFG_Type) SetSWPR_Page24_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSCFG_Type) GetSWPR_Page24_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x1000000) >> 24
}
func (o *SYSCFG_Type) SetSWPR_Page25_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSCFG_Type) GetSWPR_Page25_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x2000000) >> 25
}
func (o *SYSCFG_Type) SetSWPR_Page26_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSCFG_Type) GetSWPR_Page26_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x4000000) >> 26
}
func (o *SYSCFG_Type) SetSWPR_Page27_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSCFG_Type) GetSWPR_Page27_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x8000000) >> 27
}
func (o *SYSCFG_Type) SetSWPR_Page28_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSCFG_Type) GetSWPR_Page28_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x10000000) >> 28
}
func (o *SYSCFG_Type) SetSWPR_Page29_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSCFG_Type) GetSWPR_Page29_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x20000000) >> 29
}
func (o *SYSCFG_Type) SetSWPR_Page30_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSCFG_Type) GetSWPR_Page30_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x40000000) >> 30
}
func (o *SYSCFG_Type) SetSWPR_Page31_WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSCFG_Type) GetSWPR_Page31_WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x80000000) >> 31
}

// SYSCFG.SKR: SRAM2 Key Register
func (o *SYSCFG_Type) SetSKR_KEY(value uint32) {
	volatile.StoreUint32(&o.SKR.Reg, volatile.LoadUint32(&o.SKR.Reg)&^(0xff)|value)
}
func (o *SYSCFG_Type) GetSKR_KEY() uint32 {
	return volatile.LoadUint32(&o.SKR.Reg) & 0xff
}

// Voltage reference buffer
type VREFBUF_Type struct {
	CSR volatile.Register32 // 0x0
	CCR volatile.Register32 // 0x4
}

// VREFBUF.CSR: VREF_BUF Control and Status Register
func (o *VREFBUF_Type) SetCSR_ENVR(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *VREFBUF_Type) GetCSR_ENVR() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *VREFBUF_Type) SetCSR_HIZ(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *VREFBUF_Type) GetCSR_HIZ() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *VREFBUF_Type) SetCSR_VRR(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *VREFBUF_Type) GetCSR_VRR() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}
func (o *VREFBUF_Type) SetCSR_VRS(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x30)|value<<4)
}
func (o *VREFBUF_Type) GetCSR_VRS() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x30) >> 4
}

// VREFBUF.CCR: VREF_BUF Calibration Control Register
func (o *VREFBUF_Type) SetCCR_TRIM(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x3f)|value)
}
func (o *VREFBUF_Type) GetCCR_TRIM() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x3f
}

// Comparator control and status register
type COMP_Type struct {
	C1CSR volatile.Register32 // 0x0
	C2CSR volatile.Register32 // 0x4
	C3CSR volatile.Register32 // 0x8
	C4CSR volatile.Register32 // 0xC
}

// COMP.C1CSR: Comparator control/status register
func (o *COMP_Type) SetC1CSR_EN(value uint32) {
	volatile.StoreUint32(&o.C1CSR.Reg, volatile.LoadUint32(&o.C1CSR.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetC1CSR_EN() uint32 {
	return volatile.LoadUint32(&o.C1CSR.Reg) & 0x1
}
func (o *COMP_Type) SetC1CSR_COMP_DEGLITCH_EN(value uint32) {
	volatile.StoreUint32(&o.C1CSR.Reg, volatile.LoadUint32(&o.C1CSR.Reg)&^(0x2)|value<<1)
}
func (o *COMP_Type) GetC1CSR_COMP_DEGLITCH_EN() uint32 {
	return (volatile.LoadUint32(&o.C1CSR.Reg) & 0x2) >> 1
}
func (o *COMP_Type) SetC1CSR_INMSEL(value uint32) {
	volatile.StoreUint32(&o.C1CSR.Reg, volatile.LoadUint32(&o.C1CSR.Reg)&^(0x70)|value<<4)
}
func (o *COMP_Type) GetC1CSR_INMSEL() uint32 {
	return (volatile.LoadUint32(&o.C1CSR.Reg) & 0x70) >> 4
}
func (o *COMP_Type) SetC1CSR_INPSEL(value uint32) {
	volatile.StoreUint32(&o.C1CSR.Reg, volatile.LoadUint32(&o.C1CSR.Reg)&^(0x100)|value<<8)
}
func (o *COMP_Type) GetC1CSR_INPSEL() uint32 {
	return (volatile.LoadUint32(&o.C1CSR.Reg) & 0x100) >> 8
}
func (o *COMP_Type) SetC1CSR_POL(value uint32) {
	volatile.StoreUint32(&o.C1CSR.Reg, volatile.LoadUint32(&o.C1CSR.Reg)&^(0x8000)|value<<15)
}
func (o *COMP_Type) GetC1CSR_POL() uint32 {
	return (volatile.LoadUint32(&o.C1CSR.Reg) & 0x8000) >> 15
}
func (o *COMP_Type) SetC1CSR_HYST(value uint32) {
	volatile.StoreUint32(&o.C1CSR.Reg, volatile.LoadUint32(&o.C1CSR.Reg)&^(0x70000)|value<<16)
}
func (o *COMP_Type) GetC1CSR_HYST() uint32 {
	return (volatile.LoadUint32(&o.C1CSR.Reg) & 0x70000) >> 16
}
func (o *COMP_Type) SetC1CSR_BLANKSEL(value uint32) {
	volatile.StoreUint32(&o.C1CSR.Reg, volatile.LoadUint32(&o.C1CSR.Reg)&^(0x380000)|value<<19)
}
func (o *COMP_Type) GetC1CSR_BLANKSEL() uint32 {
	return (volatile.LoadUint32(&o.C1CSR.Reg) & 0x380000) >> 19
}
func (o *COMP_Type) SetC1CSR_BRGEN(value uint32) {
	volatile.StoreUint32(&o.C1CSR.Reg, volatile.LoadUint32(&o.C1CSR.Reg)&^(0x400000)|value<<22)
}
func (o *COMP_Type) GetC1CSR_BRGEN() uint32 {
	return (volatile.LoadUint32(&o.C1CSR.Reg) & 0x400000) >> 22
}
func (o *COMP_Type) SetC1CSR_SCALEN(value uint32) {
	volatile.StoreUint32(&o.C1CSR.Reg, volatile.LoadUint32(&o.C1CSR.Reg)&^(0x800000)|value<<23)
}
func (o *COMP_Type) GetC1CSR_SCALEN() uint32 {
	return (volatile.LoadUint32(&o.C1CSR.Reg) & 0x800000) >> 23
}
func (o *COMP_Type) SetC1CSR_VALUE(value uint32) {
	volatile.StoreUint32(&o.C1CSR.Reg, volatile.LoadUint32(&o.C1CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *COMP_Type) GetC1CSR_VALUE() uint32 {
	return (volatile.LoadUint32(&o.C1CSR.Reg) & 0x40000000) >> 30
}
func (o *COMP_Type) SetC1CSR_LOCK(value uint32) {
	volatile.StoreUint32(&o.C1CSR.Reg, volatile.LoadUint32(&o.C1CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *COMP_Type) GetC1CSR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.C1CSR.Reg) & 0x80000000) >> 31
}

// COMP.C2CSR: Comparator control/status register
func (o *COMP_Type) SetC2CSR_EN(value uint32) {
	volatile.StoreUint32(&o.C2CSR.Reg, volatile.LoadUint32(&o.C2CSR.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetC2CSR_EN() uint32 {
	return volatile.LoadUint32(&o.C2CSR.Reg) & 0x1
}
func (o *COMP_Type) SetC2CSR_COMP_DEGLITCH_EN(value uint32) {
	volatile.StoreUint32(&o.C2CSR.Reg, volatile.LoadUint32(&o.C2CSR.Reg)&^(0x2)|value<<1)
}
func (o *COMP_Type) GetC2CSR_COMP_DEGLITCH_EN() uint32 {
	return (volatile.LoadUint32(&o.C2CSR.Reg) & 0x2) >> 1
}
func (o *COMP_Type) SetC2CSR_INMSEL(value uint32) {
	volatile.StoreUint32(&o.C2CSR.Reg, volatile.LoadUint32(&o.C2CSR.Reg)&^(0x70)|value<<4)
}
func (o *COMP_Type) GetC2CSR_INMSEL() uint32 {
	return (volatile.LoadUint32(&o.C2CSR.Reg) & 0x70) >> 4
}
func (o *COMP_Type) SetC2CSR_INPSEL(value uint32) {
	volatile.StoreUint32(&o.C2CSR.Reg, volatile.LoadUint32(&o.C2CSR.Reg)&^(0x100)|value<<8)
}
func (o *COMP_Type) GetC2CSR_INPSEL() uint32 {
	return (volatile.LoadUint32(&o.C2CSR.Reg) & 0x100) >> 8
}
func (o *COMP_Type) SetC2CSR_POL(value uint32) {
	volatile.StoreUint32(&o.C2CSR.Reg, volatile.LoadUint32(&o.C2CSR.Reg)&^(0x8000)|value<<15)
}
func (o *COMP_Type) GetC2CSR_POL() uint32 {
	return (volatile.LoadUint32(&o.C2CSR.Reg) & 0x8000) >> 15
}
func (o *COMP_Type) SetC2CSR_HYST(value uint32) {
	volatile.StoreUint32(&o.C2CSR.Reg, volatile.LoadUint32(&o.C2CSR.Reg)&^(0x70000)|value<<16)
}
func (o *COMP_Type) GetC2CSR_HYST() uint32 {
	return (volatile.LoadUint32(&o.C2CSR.Reg) & 0x70000) >> 16
}
func (o *COMP_Type) SetC2CSR_BLANKSEL(value uint32) {
	volatile.StoreUint32(&o.C2CSR.Reg, volatile.LoadUint32(&o.C2CSR.Reg)&^(0x380000)|value<<19)
}
func (o *COMP_Type) GetC2CSR_BLANKSEL() uint32 {
	return (volatile.LoadUint32(&o.C2CSR.Reg) & 0x380000) >> 19
}
func (o *COMP_Type) SetC2CSR_BRGEN(value uint32) {
	volatile.StoreUint32(&o.C2CSR.Reg, volatile.LoadUint32(&o.C2CSR.Reg)&^(0x400000)|value<<22)
}
func (o *COMP_Type) GetC2CSR_BRGEN() uint32 {
	return (volatile.LoadUint32(&o.C2CSR.Reg) & 0x400000) >> 22
}
func (o *COMP_Type) SetC2CSR_SCALEN(value uint32) {
	volatile.StoreUint32(&o.C2CSR.Reg, volatile.LoadUint32(&o.C2CSR.Reg)&^(0x800000)|value<<23)
}
func (o *COMP_Type) GetC2CSR_SCALEN() uint32 {
	return (volatile.LoadUint32(&o.C2CSR.Reg) & 0x800000) >> 23
}
func (o *COMP_Type) SetC2CSR_VALUE(value uint32) {
	volatile.StoreUint32(&o.C2CSR.Reg, volatile.LoadUint32(&o.C2CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *COMP_Type) GetC2CSR_VALUE() uint32 {
	return (volatile.LoadUint32(&o.C2CSR.Reg) & 0x40000000) >> 30
}
func (o *COMP_Type) SetC2CSR_LOCK(value uint32) {
	volatile.StoreUint32(&o.C2CSR.Reg, volatile.LoadUint32(&o.C2CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *COMP_Type) GetC2CSR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.C2CSR.Reg) & 0x80000000) >> 31
}

// COMP.C3CSR: Comparator control/status register
func (o *COMP_Type) SetC3CSR_EN(value uint32) {
	volatile.StoreUint32(&o.C3CSR.Reg, volatile.LoadUint32(&o.C3CSR.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetC3CSR_EN() uint32 {
	return volatile.LoadUint32(&o.C3CSR.Reg) & 0x1
}
func (o *COMP_Type) SetC3CSR_COMP_DEGLITCH_EN(value uint32) {
	volatile.StoreUint32(&o.C3CSR.Reg, volatile.LoadUint32(&o.C3CSR.Reg)&^(0x2)|value<<1)
}
func (o *COMP_Type) GetC3CSR_COMP_DEGLITCH_EN() uint32 {
	return (volatile.LoadUint32(&o.C3CSR.Reg) & 0x2) >> 1
}
func (o *COMP_Type) SetC3CSR_INMSEL(value uint32) {
	volatile.StoreUint32(&o.C3CSR.Reg, volatile.LoadUint32(&o.C3CSR.Reg)&^(0x70)|value<<4)
}
func (o *COMP_Type) GetC3CSR_INMSEL() uint32 {
	return (volatile.LoadUint32(&o.C3CSR.Reg) & 0x70) >> 4
}
func (o *COMP_Type) SetC3CSR_INPSEL(value uint32) {
	volatile.StoreUint32(&o.C3CSR.Reg, volatile.LoadUint32(&o.C3CSR.Reg)&^(0x100)|value<<8)
}
func (o *COMP_Type) GetC3CSR_INPSEL() uint32 {
	return (volatile.LoadUint32(&o.C3CSR.Reg) & 0x100) >> 8
}
func (o *COMP_Type) SetC3CSR_POL(value uint32) {
	volatile.StoreUint32(&o.C3CSR.Reg, volatile.LoadUint32(&o.C3CSR.Reg)&^(0x8000)|value<<15)
}
func (o *COMP_Type) GetC3CSR_POL() uint32 {
	return (volatile.LoadUint32(&o.C3CSR.Reg) & 0x8000) >> 15
}
func (o *COMP_Type) SetC3CSR_HYST(value uint32) {
	volatile.StoreUint32(&o.C3CSR.Reg, volatile.LoadUint32(&o.C3CSR.Reg)&^(0x70000)|value<<16)
}
func (o *COMP_Type) GetC3CSR_HYST() uint32 {
	return (volatile.LoadUint32(&o.C3CSR.Reg) & 0x70000) >> 16
}
func (o *COMP_Type) SetC3CSR_BLANKSEL(value uint32) {
	volatile.StoreUint32(&o.C3CSR.Reg, volatile.LoadUint32(&o.C3CSR.Reg)&^(0x380000)|value<<19)
}
func (o *COMP_Type) GetC3CSR_BLANKSEL() uint32 {
	return (volatile.LoadUint32(&o.C3CSR.Reg) & 0x380000) >> 19
}
func (o *COMP_Type) SetC3CSR_BRGEN(value uint32) {
	volatile.StoreUint32(&o.C3CSR.Reg, volatile.LoadUint32(&o.C3CSR.Reg)&^(0x400000)|value<<22)
}
func (o *COMP_Type) GetC3CSR_BRGEN() uint32 {
	return (volatile.LoadUint32(&o.C3CSR.Reg) & 0x400000) >> 22
}
func (o *COMP_Type) SetC3CSR_SCALEN(value uint32) {
	volatile.StoreUint32(&o.C3CSR.Reg, volatile.LoadUint32(&o.C3CSR.Reg)&^(0x800000)|value<<23)
}
func (o *COMP_Type) GetC3CSR_SCALEN() uint32 {
	return (volatile.LoadUint32(&o.C3CSR.Reg) & 0x800000) >> 23
}
func (o *COMP_Type) SetC3CSR_VALUE(value uint32) {
	volatile.StoreUint32(&o.C3CSR.Reg, volatile.LoadUint32(&o.C3CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *COMP_Type) GetC3CSR_VALUE() uint32 {
	return (volatile.LoadUint32(&o.C3CSR.Reg) & 0x40000000) >> 30
}
func (o *COMP_Type) SetC3CSR_LOCK(value uint32) {
	volatile.StoreUint32(&o.C3CSR.Reg, volatile.LoadUint32(&o.C3CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *COMP_Type) GetC3CSR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.C3CSR.Reg) & 0x80000000) >> 31
}

// COMP.C4CSR: Comparator control/status register
func (o *COMP_Type) SetC4CSR_EN(value uint32) {
	volatile.StoreUint32(&o.C4CSR.Reg, volatile.LoadUint32(&o.C4CSR.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetC4CSR_EN() uint32 {
	return volatile.LoadUint32(&o.C4CSR.Reg) & 0x1
}
func (o *COMP_Type) SetC4CSR_COMP_DEGLITCH_EN(value uint32) {
	volatile.StoreUint32(&o.C4CSR.Reg, volatile.LoadUint32(&o.C4CSR.Reg)&^(0x2)|value<<1)
}
func (o *COMP_Type) GetC4CSR_COMP_DEGLITCH_EN() uint32 {
	return (volatile.LoadUint32(&o.C4CSR.Reg) & 0x2) >> 1
}
func (o *COMP_Type) SetC4CSR_INMSEL(value uint32) {
	volatile.StoreUint32(&o.C4CSR.Reg, volatile.LoadUint32(&o.C4CSR.Reg)&^(0x70)|value<<4)
}
func (o *COMP_Type) GetC4CSR_INMSEL() uint32 {
	return (volatile.LoadUint32(&o.C4CSR.Reg) & 0x70) >> 4
}
func (o *COMP_Type) SetC4CSR_INPSEL(value uint32) {
	volatile.StoreUint32(&o.C4CSR.Reg, volatile.LoadUint32(&o.C4CSR.Reg)&^(0x100)|value<<8)
}
func (o *COMP_Type) GetC4CSR_INPSEL() uint32 {
	return (volatile.LoadUint32(&o.C4CSR.Reg) & 0x100) >> 8
}
func (o *COMP_Type) SetC4CSR_POL(value uint32) {
	volatile.StoreUint32(&o.C4CSR.Reg, volatile.LoadUint32(&o.C4CSR.Reg)&^(0x8000)|value<<15)
}
func (o *COMP_Type) GetC4CSR_POL() uint32 {
	return (volatile.LoadUint32(&o.C4CSR.Reg) & 0x8000) >> 15
}
func (o *COMP_Type) SetC4CSR_HYST(value uint32) {
	volatile.StoreUint32(&o.C4CSR.Reg, volatile.LoadUint32(&o.C4CSR.Reg)&^(0x70000)|value<<16)
}
func (o *COMP_Type) GetC4CSR_HYST() uint32 {
	return (volatile.LoadUint32(&o.C4CSR.Reg) & 0x70000) >> 16
}
func (o *COMP_Type) SetC4CSR_BLANKSEL(value uint32) {
	volatile.StoreUint32(&o.C4CSR.Reg, volatile.LoadUint32(&o.C4CSR.Reg)&^(0x380000)|value<<19)
}
func (o *COMP_Type) GetC4CSR_BLANKSEL() uint32 {
	return (volatile.LoadUint32(&o.C4CSR.Reg) & 0x380000) >> 19
}
func (o *COMP_Type) SetC4CSR_BRGEN(value uint32) {
	volatile.StoreUint32(&o.C4CSR.Reg, volatile.LoadUint32(&o.C4CSR.Reg)&^(0x400000)|value<<22)
}
func (o *COMP_Type) GetC4CSR_BRGEN() uint32 {
	return (volatile.LoadUint32(&o.C4CSR.Reg) & 0x400000) >> 22
}
func (o *COMP_Type) SetC4CSR_SCALEN(value uint32) {
	volatile.StoreUint32(&o.C4CSR.Reg, volatile.LoadUint32(&o.C4CSR.Reg)&^(0x800000)|value<<23)
}
func (o *COMP_Type) GetC4CSR_SCALEN() uint32 {
	return (volatile.LoadUint32(&o.C4CSR.Reg) & 0x800000) >> 23
}
func (o *COMP_Type) SetC4CSR_VALUE(value uint32) {
	volatile.StoreUint32(&o.C4CSR.Reg, volatile.LoadUint32(&o.C4CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *COMP_Type) GetC4CSR_VALUE() uint32 {
	return (volatile.LoadUint32(&o.C4CSR.Reg) & 0x40000000) >> 30
}
func (o *COMP_Type) SetC4CSR_LOCK(value uint32) {
	volatile.StoreUint32(&o.C4CSR.Reg, volatile.LoadUint32(&o.C4CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *COMP_Type) GetC4CSR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.C4CSR.Reg) & 0x80000000) >> 31
}

// Operational amplifiers
type OPAMP_Type struct {
	OPAMP1_CSR  volatile.Register32 // 0x0
	OPAMP2_CSR  volatile.Register32 // 0x4
	OPAMP3_CSR  volatile.Register32 // 0x8
	_           [8]byte
	OPAMP6_CSR  volatile.Register32 // 0x14
	OPAMP1_TCMR volatile.Register32 // 0x18
	OPAMP2_TCMR volatile.Register32 // 0x1C
	OPAMP3_TCMR volatile.Register32 // 0x20
	_           [8]byte
	OPAMP6_TCMR volatile.Register32 // 0x2C
}

// OPAMP.OPAMP1_CSR: OPAMP1 control/status register
func (o *OPAMP_Type) SetOPAMP1_CSR_OPAEN(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x1)|value)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_OPAEN() uint32 {
	return volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x1
}
func (o *OPAMP_Type) SetOPAMP1_CSR_FORCE_VP(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x2)|value<<1)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_FORCE_VP() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x2) >> 1
}
func (o *OPAMP_Type) SetOPAMP1_CSR_VP_SEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0xc)|value<<2)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_VP_SEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0xc) >> 2
}
func (o *OPAMP_Type) SetOPAMP1_CSR_USERTRIM(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x10)|value<<4)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_USERTRIM() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x10) >> 4
}
func (o *OPAMP_Type) SetOPAMP1_CSR_VM_SEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x60)|value<<5)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_VM_SEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x60) >> 5
}
func (o *OPAMP_Type) SetOPAMP1_CSR_OPAHSM(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x80)|value<<7)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_OPAHSM() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x80) >> 7
}
func (o *OPAMP_Type) SetOPAMP1_CSR_OPAINTOEN(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x100)|value<<8)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_OPAINTOEN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x100) >> 8
}
func (o *OPAMP_Type) SetOPAMP1_CSR_CALON(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x800)|value<<11)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_CALON() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x800) >> 11
}
func (o *OPAMP_Type) SetOPAMP1_CSR_CALSEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x3000)|value<<12)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_CALSEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x3000) >> 12
}
func (o *OPAMP_Type) SetOPAMP1_CSR_PGA_GAIN(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x7c000)|value<<14)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_PGA_GAIN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x7c000) >> 14
}
func (o *OPAMP_Type) SetOPAMP1_CSR_TRIMOFFSETP(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0xf80000)|value<<19)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_TRIMOFFSETP() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0xf80000) >> 19
}
func (o *OPAMP_Type) SetOPAMP1_CSR_TRIMOFFSETN(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x1f000000)|value<<24)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_TRIMOFFSETN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x1f000000) >> 24
}
func (o *OPAMP_Type) SetOPAMP1_CSR_CALOUT(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_CALOUT() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x40000000) >> 30
}
func (o *OPAMP_Type) SetOPAMP1_CSR_LOCK(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x80000000) >> 31
}

// OPAMP.OPAMP2_CSR: OPAMP2 control/status register
func (o *OPAMP_Type) SetOPAMP2_CSR_OPAEN(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x1)|value)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_OPAEN() uint32 {
	return volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x1
}
func (o *OPAMP_Type) SetOPAMP2_CSR_FORCE_VP(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x2)|value<<1)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_FORCE_VP() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x2) >> 1
}
func (o *OPAMP_Type) SetOPAMP2_CSR_VP_SEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0xc)|value<<2)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_VP_SEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0xc) >> 2
}
func (o *OPAMP_Type) SetOPAMP2_CSR_USERTRIM(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x10)|value<<4)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_USERTRIM() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x10) >> 4
}
func (o *OPAMP_Type) SetOPAMP2_CSR_VM_SEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x60)|value<<5)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_VM_SEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x60) >> 5
}
func (o *OPAMP_Type) SetOPAMP2_CSR_OPAHSM(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x80)|value<<7)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_OPAHSM() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x80) >> 7
}
func (o *OPAMP_Type) SetOPAMP2_CSR_OPAINTOEN(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x100)|value<<8)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_OPAINTOEN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x100) >> 8
}
func (o *OPAMP_Type) SetOPAMP2_CSR_CALON(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x800)|value<<11)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_CALON() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x800) >> 11
}
func (o *OPAMP_Type) SetOPAMP2_CSR_CALSEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x3000)|value<<12)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_CALSEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x3000) >> 12
}
func (o *OPAMP_Type) SetOPAMP2_CSR_PGA_GAIN(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x7c000)|value<<14)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_PGA_GAIN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x7c000) >> 14
}
func (o *OPAMP_Type) SetOPAMP2_CSR_TRIMOFFSETP(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0xf80000)|value<<19)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_TRIMOFFSETP() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0xf80000) >> 19
}
func (o *OPAMP_Type) SetOPAMP2_CSR_TRIMOFFSETN(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x1f000000)|value<<24)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_TRIMOFFSETN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x1f000000) >> 24
}
func (o *OPAMP_Type) SetOPAMP2_CSR_CALOUT(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_CALOUT() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x40000000) >> 30
}
func (o *OPAMP_Type) SetOPAMP2_CSR_LOCK(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x80000000) >> 31
}

// OPAMP.OPAMP3_CSR: OPAMP3 control/status register
func (o *OPAMP_Type) SetOPAMP3_CSR_OPAEN(value uint32) {
	volatile.StoreUint32(&o.OPAMP3_CSR.Reg, volatile.LoadUint32(&o.OPAMP3_CSR.Reg)&^(0x1)|value)
}
func (o *OPAMP_Type) GetOPAMP3_CSR_OPAEN() uint32 {
	return volatile.LoadUint32(&o.OPAMP3_CSR.Reg) & 0x1
}
func (o *OPAMP_Type) SetOPAMP3_CSR_FORCE_VP(value uint32) {
	volatile.StoreUint32(&o.OPAMP3_CSR.Reg, volatile.LoadUint32(&o.OPAMP3_CSR.Reg)&^(0x2)|value<<1)
}
func (o *OPAMP_Type) GetOPAMP3_CSR_FORCE_VP() uint32 {
	return (volatile.LoadUint32(&o.OPAMP3_CSR.Reg) & 0x2) >> 1
}
func (o *OPAMP_Type) SetOPAMP3_CSR_VP_SEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP3_CSR.Reg, volatile.LoadUint32(&o.OPAMP3_CSR.Reg)&^(0xc)|value<<2)
}
func (o *OPAMP_Type) GetOPAMP3_CSR_VP_SEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP3_CSR.Reg) & 0xc) >> 2
}
func (o *OPAMP_Type) SetOPAMP3_CSR_USERTRIM(value uint32) {
	volatile.StoreUint32(&o.OPAMP3_CSR.Reg, volatile.LoadUint32(&o.OPAMP3_CSR.Reg)&^(0x10)|value<<4)
}
func (o *OPAMP_Type) GetOPAMP3_CSR_USERTRIM() uint32 {
	return (volatile.LoadUint32(&o.OPAMP3_CSR.Reg) & 0x10) >> 4
}
func (o *OPAMP_Type) SetOPAMP3_CSR_VM_SEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP3_CSR.Reg, volatile.LoadUint32(&o.OPAMP3_CSR.Reg)&^(0x60)|value<<5)
}
func (o *OPAMP_Type) GetOPAMP3_CSR_VM_SEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP3_CSR.Reg) & 0x60) >> 5
}
func (o *OPAMP_Type) SetOPAMP3_CSR_OPAHSM(value uint32) {
	volatile.StoreUint32(&o.OPAMP3_CSR.Reg, volatile.LoadUint32(&o.OPAMP3_CSR.Reg)&^(0x80)|value<<7)
}
func (o *OPAMP_Type) GetOPAMP3_CSR_OPAHSM() uint32 {
	return (volatile.LoadUint32(&o.OPAMP3_CSR.Reg) & 0x80) >> 7
}
func (o *OPAMP_Type) SetOPAMP3_CSR_OPAINTOEN(value uint32) {
	volatile.StoreUint32(&o.OPAMP3_CSR.Reg, volatile.LoadUint32(&o.OPAMP3_CSR.Reg)&^(0x100)|value<<8)
}
func (o *OPAMP_Type) GetOPAMP3_CSR_OPAINTOEN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP3_CSR.Reg) & 0x100) >> 8
}
func (o *OPAMP_Type) SetOPAMP3_CSR_CALON(value uint32) {
	volatile.StoreUint32(&o.OPAMP3_CSR.Reg, volatile.LoadUint32(&o.OPAMP3_CSR.Reg)&^(0x800)|value<<11)
}
func (o *OPAMP_Type) GetOPAMP3_CSR_CALON() uint32 {
	return (volatile.LoadUint32(&o.OPAMP3_CSR.Reg) & 0x800) >> 11
}
func (o *OPAMP_Type) SetOPAMP3_CSR_CALSEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP3_CSR.Reg, volatile.LoadUint32(&o.OPAMP3_CSR.Reg)&^(0x3000)|value<<12)
}
func (o *OPAMP_Type) GetOPAMP3_CSR_CALSEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP3_CSR.Reg) & 0x3000) >> 12
}
func (o *OPAMP_Type) SetOPAMP3_CSR_PGA_GAIN(value uint32) {
	volatile.StoreUint32(&o.OPAMP3_CSR.Reg, volatile.LoadUint32(&o.OPAMP3_CSR.Reg)&^(0x7c000)|value<<14)
}
func (o *OPAMP_Type) GetOPAMP3_CSR_PGA_GAIN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP3_CSR.Reg) & 0x7c000) >> 14
}
func (o *OPAMP_Type) SetOPAMP3_CSR_TRIMOFFSETP(value uint32) {
	volatile.StoreUint32(&o.OPAMP3_CSR.Reg, volatile.LoadUint32(&o.OPAMP3_CSR.Reg)&^(0xf80000)|value<<19)
}
func (o *OPAMP_Type) GetOPAMP3_CSR_TRIMOFFSETP() uint32 {
	return (volatile.LoadUint32(&o.OPAMP3_CSR.Reg) & 0xf80000) >> 19
}
func (o *OPAMP_Type) SetOPAMP3_CSR_TRIMOFFSETN(value uint32) {
	volatile.StoreUint32(&o.OPAMP3_CSR.Reg, volatile.LoadUint32(&o.OPAMP3_CSR.Reg)&^(0x1f000000)|value<<24)
}
func (o *OPAMP_Type) GetOPAMP3_CSR_TRIMOFFSETN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP3_CSR.Reg) & 0x1f000000) >> 24
}
func (o *OPAMP_Type) SetOPAMP3_CSR_CALOUT(value uint32) {
	volatile.StoreUint32(&o.OPAMP3_CSR.Reg, volatile.LoadUint32(&o.OPAMP3_CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *OPAMP_Type) GetOPAMP3_CSR_CALOUT() uint32 {
	return (volatile.LoadUint32(&o.OPAMP3_CSR.Reg) & 0x40000000) >> 30
}
func (o *OPAMP_Type) SetOPAMP3_CSR_LOCK(value uint32) {
	volatile.StoreUint32(&o.OPAMP3_CSR.Reg, volatile.LoadUint32(&o.OPAMP3_CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *OPAMP_Type) GetOPAMP3_CSR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.OPAMP3_CSR.Reg) & 0x80000000) >> 31
}

// OPAMP.OPAMP6_CSR: OPAMP6 control/status register
func (o *OPAMP_Type) SetOPAMP6_CSR_OPAEN(value uint32) {
	volatile.StoreUint32(&o.OPAMP6_CSR.Reg, volatile.LoadUint32(&o.OPAMP6_CSR.Reg)&^(0x1)|value)
}
func (o *OPAMP_Type) GetOPAMP6_CSR_OPAEN() uint32 {
	return volatile.LoadUint32(&o.OPAMP6_CSR.Reg) & 0x1
}
func (o *OPAMP_Type) SetOPAMP6_CSR_FORCE_VP(value uint32) {
	volatile.StoreUint32(&o.OPAMP6_CSR.Reg, volatile.LoadUint32(&o.OPAMP6_CSR.Reg)&^(0x2)|value<<1)
}
func (o *OPAMP_Type) GetOPAMP6_CSR_FORCE_VP() uint32 {
	return (volatile.LoadUint32(&o.OPAMP6_CSR.Reg) & 0x2) >> 1
}
func (o *OPAMP_Type) SetOPAMP6_CSR_VP_SEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP6_CSR.Reg, volatile.LoadUint32(&o.OPAMP6_CSR.Reg)&^(0xc)|value<<2)
}
func (o *OPAMP_Type) GetOPAMP6_CSR_VP_SEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP6_CSR.Reg) & 0xc) >> 2
}
func (o *OPAMP_Type) SetOPAMP6_CSR_USERTRIM(value uint32) {
	volatile.StoreUint32(&o.OPAMP6_CSR.Reg, volatile.LoadUint32(&o.OPAMP6_CSR.Reg)&^(0x10)|value<<4)
}
func (o *OPAMP_Type) GetOPAMP6_CSR_USERTRIM() uint32 {
	return (volatile.LoadUint32(&o.OPAMP6_CSR.Reg) & 0x10) >> 4
}
func (o *OPAMP_Type) SetOPAMP6_CSR_VM_SEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP6_CSR.Reg, volatile.LoadUint32(&o.OPAMP6_CSR.Reg)&^(0x60)|value<<5)
}
func (o *OPAMP_Type) GetOPAMP6_CSR_VM_SEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP6_CSR.Reg) & 0x60) >> 5
}
func (o *OPAMP_Type) SetOPAMP6_CSR_OPAHSM(value uint32) {
	volatile.StoreUint32(&o.OPAMP6_CSR.Reg, volatile.LoadUint32(&o.OPAMP6_CSR.Reg)&^(0x80)|value<<7)
}
func (o *OPAMP_Type) GetOPAMP6_CSR_OPAHSM() uint32 {
	return (volatile.LoadUint32(&o.OPAMP6_CSR.Reg) & 0x80) >> 7
}
func (o *OPAMP_Type) SetOPAMP6_CSR_OPAINTOEN(value uint32) {
	volatile.StoreUint32(&o.OPAMP6_CSR.Reg, volatile.LoadUint32(&o.OPAMP6_CSR.Reg)&^(0x100)|value<<8)
}
func (o *OPAMP_Type) GetOPAMP6_CSR_OPAINTOEN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP6_CSR.Reg) & 0x100) >> 8
}
func (o *OPAMP_Type) SetOPAMP6_CSR_CALON(value uint32) {
	volatile.StoreUint32(&o.OPAMP6_CSR.Reg, volatile.LoadUint32(&o.OPAMP6_CSR.Reg)&^(0x800)|value<<11)
}
func (o *OPAMP_Type) GetOPAMP6_CSR_CALON() uint32 {
	return (volatile.LoadUint32(&o.OPAMP6_CSR.Reg) & 0x800) >> 11
}
func (o *OPAMP_Type) SetOPAMP6_CSR_CALSEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP6_CSR.Reg, volatile.LoadUint32(&o.OPAMP6_CSR.Reg)&^(0x3000)|value<<12)
}
func (o *OPAMP_Type) GetOPAMP6_CSR_CALSEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP6_CSR.Reg) & 0x3000) >> 12
}
func (o *OPAMP_Type) SetOPAMP6_CSR_PGA_GAIN(value uint32) {
	volatile.StoreUint32(&o.OPAMP6_CSR.Reg, volatile.LoadUint32(&o.OPAMP6_CSR.Reg)&^(0x7c000)|value<<14)
}
func (o *OPAMP_Type) GetOPAMP6_CSR_PGA_GAIN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP6_CSR.Reg) & 0x7c000) >> 14
}
func (o *OPAMP_Type) SetOPAMP6_CSR_TRIMOFFSETP(value uint32) {
	volatile.StoreUint32(&o.OPAMP6_CSR.Reg, volatile.LoadUint32(&o.OPAMP6_CSR.Reg)&^(0xf80000)|value<<19)
}
func (o *OPAMP_Type) GetOPAMP6_CSR_TRIMOFFSETP() uint32 {
	return (volatile.LoadUint32(&o.OPAMP6_CSR.Reg) & 0xf80000) >> 19
}
func (o *OPAMP_Type) SetOPAMP6_CSR_TRIMOFFSETN(value uint32) {
	volatile.StoreUint32(&o.OPAMP6_CSR.Reg, volatile.LoadUint32(&o.OPAMP6_CSR.Reg)&^(0x1f000000)|value<<24)
}
func (o *OPAMP_Type) GetOPAMP6_CSR_TRIMOFFSETN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP6_CSR.Reg) & 0x1f000000) >> 24
}
func (o *OPAMP_Type) SetOPAMP6_CSR_CALOUT(value uint32) {
	volatile.StoreUint32(&o.OPAMP6_CSR.Reg, volatile.LoadUint32(&o.OPAMP6_CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *OPAMP_Type) GetOPAMP6_CSR_CALOUT() uint32 {
	return (volatile.LoadUint32(&o.OPAMP6_CSR.Reg) & 0x40000000) >> 30
}
func (o *OPAMP_Type) SetOPAMP6_CSR_LOCK(value uint32) {
	volatile.StoreUint32(&o.OPAMP6_CSR.Reg, volatile.LoadUint32(&o.OPAMP6_CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *OPAMP_Type) GetOPAMP6_CSR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.OPAMP6_CSR.Reg) & 0x80000000) >> 31
}

// OPAMP.OPAMP1_TCMR: OPAMP1 control/status register
func (o *OPAMP_Type) SetOPAMP1_TCMR_VMS_SEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_TCMR.Reg, volatile.LoadUint32(&o.OPAMP1_TCMR.Reg)&^(0x1)|value)
}
func (o *OPAMP_Type) GetOPAMP1_TCMR_VMS_SEL() uint32 {
	return volatile.LoadUint32(&o.OPAMP1_TCMR.Reg) & 0x1
}
func (o *OPAMP_Type) SetOPAMP1_TCMR_VPS_SEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_TCMR.Reg, volatile.LoadUint32(&o.OPAMP1_TCMR.Reg)&^(0x6)|value<<1)
}
func (o *OPAMP_Type) GetOPAMP1_TCMR_VPS_SEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_TCMR.Reg) & 0x6) >> 1
}
func (o *OPAMP_Type) SetOPAMP1_TCMR_T1CM_EN(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_TCMR.Reg, volatile.LoadUint32(&o.OPAMP1_TCMR.Reg)&^(0x8)|value<<3)
}
func (o *OPAMP_Type) GetOPAMP1_TCMR_T1CM_EN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_TCMR.Reg) & 0x8) >> 3
}
func (o *OPAMP_Type) SetOPAMP1_TCMR_T8CM_EN(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_TCMR.Reg, volatile.LoadUint32(&o.OPAMP1_TCMR.Reg)&^(0x10)|value<<4)
}
func (o *OPAMP_Type) GetOPAMP1_TCMR_T8CM_EN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_TCMR.Reg) & 0x10) >> 4
}
func (o *OPAMP_Type) SetOPAMP1_TCMR_T20CM_EN(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_TCMR.Reg, volatile.LoadUint32(&o.OPAMP1_TCMR.Reg)&^(0x20)|value<<5)
}
func (o *OPAMP_Type) GetOPAMP1_TCMR_T20CM_EN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_TCMR.Reg) & 0x20) >> 5
}
func (o *OPAMP_Type) SetOPAMP1_TCMR_LOCK(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_TCMR.Reg, volatile.LoadUint32(&o.OPAMP1_TCMR.Reg)&^(0x80000000)|value<<31)
}
func (o *OPAMP_Type) GetOPAMP1_TCMR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_TCMR.Reg) & 0x80000000) >> 31
}

// OPAMP.OPAMP2_TCMR: OPAMP2 control/status register
func (o *OPAMP_Type) SetOPAMP2_TCMR_VMS_SEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_TCMR.Reg, volatile.LoadUint32(&o.OPAMP2_TCMR.Reg)&^(0x1)|value)
}
func (o *OPAMP_Type) GetOPAMP2_TCMR_VMS_SEL() uint32 {
	return volatile.LoadUint32(&o.OPAMP2_TCMR.Reg) & 0x1
}
func (o *OPAMP_Type) SetOPAMP2_TCMR_VPS_SEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_TCMR.Reg, volatile.LoadUint32(&o.OPAMP2_TCMR.Reg)&^(0x6)|value<<1)
}
func (o *OPAMP_Type) GetOPAMP2_TCMR_VPS_SEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_TCMR.Reg) & 0x6) >> 1
}
func (o *OPAMP_Type) SetOPAMP2_TCMR_T1CM_EN(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_TCMR.Reg, volatile.LoadUint32(&o.OPAMP2_TCMR.Reg)&^(0x8)|value<<3)
}
func (o *OPAMP_Type) GetOPAMP2_TCMR_T1CM_EN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_TCMR.Reg) & 0x8) >> 3
}
func (o *OPAMP_Type) SetOPAMP2_TCMR_T8CM_EN(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_TCMR.Reg, volatile.LoadUint32(&o.OPAMP2_TCMR.Reg)&^(0x10)|value<<4)
}
func (o *OPAMP_Type) GetOPAMP2_TCMR_T8CM_EN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_TCMR.Reg) & 0x10) >> 4
}
func (o *OPAMP_Type) SetOPAMP2_TCMR_T20CM_EN(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_TCMR.Reg, volatile.LoadUint32(&o.OPAMP2_TCMR.Reg)&^(0x20)|value<<5)
}
func (o *OPAMP_Type) GetOPAMP2_TCMR_T20CM_EN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_TCMR.Reg) & 0x20) >> 5
}
func (o *OPAMP_Type) SetOPAMP2_TCMR_LOCK(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_TCMR.Reg, volatile.LoadUint32(&o.OPAMP2_TCMR.Reg)&^(0x80000000)|value<<31)
}
func (o *OPAMP_Type) GetOPAMP2_TCMR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_TCMR.Reg) & 0x80000000) >> 31
}

// OPAMP.OPAMP3_TCMR: OPAMP3 control/status register
func (o *OPAMP_Type) SetOPAMP3_TCMR_VMS_SEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP3_TCMR.Reg, volatile.LoadUint32(&o.OPAMP3_TCMR.Reg)&^(0x1)|value)
}
func (o *OPAMP_Type) GetOPAMP3_TCMR_VMS_SEL() uint32 {
	return volatile.LoadUint32(&o.OPAMP3_TCMR.Reg) & 0x1
}
func (o *OPAMP_Type) SetOPAMP3_TCMR_VPS_SEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP3_TCMR.Reg, volatile.LoadUint32(&o.OPAMP3_TCMR.Reg)&^(0x6)|value<<1)
}
func (o *OPAMP_Type) GetOPAMP3_TCMR_VPS_SEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP3_TCMR.Reg) & 0x6) >> 1
}
func (o *OPAMP_Type) SetOPAMP3_TCMR_T1CM_EN(value uint32) {
	volatile.StoreUint32(&o.OPAMP3_TCMR.Reg, volatile.LoadUint32(&o.OPAMP3_TCMR.Reg)&^(0x8)|value<<3)
}
func (o *OPAMP_Type) GetOPAMP3_TCMR_T1CM_EN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP3_TCMR.Reg) & 0x8) >> 3
}
func (o *OPAMP_Type) SetOPAMP3_TCMR_T8CM_EN(value uint32) {
	volatile.StoreUint32(&o.OPAMP3_TCMR.Reg, volatile.LoadUint32(&o.OPAMP3_TCMR.Reg)&^(0x10)|value<<4)
}
func (o *OPAMP_Type) GetOPAMP3_TCMR_T8CM_EN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP3_TCMR.Reg) & 0x10) >> 4
}
func (o *OPAMP_Type) SetOPAMP3_TCMR_T20CM_EN(value uint32) {
	volatile.StoreUint32(&o.OPAMP3_TCMR.Reg, volatile.LoadUint32(&o.OPAMP3_TCMR.Reg)&^(0x20)|value<<5)
}
func (o *OPAMP_Type) GetOPAMP3_TCMR_T20CM_EN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP3_TCMR.Reg) & 0x20) >> 5
}
func (o *OPAMP_Type) SetOPAMP3_TCMR_LOCK(value uint32) {
	volatile.StoreUint32(&o.OPAMP3_TCMR.Reg, volatile.LoadUint32(&o.OPAMP3_TCMR.Reg)&^(0x80000000)|value<<31)
}
func (o *OPAMP_Type) GetOPAMP3_TCMR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.OPAMP3_TCMR.Reg) & 0x80000000) >> 31
}

// OPAMP.OPAMP6_TCMR: OPAMP6 control/status register
func (o *OPAMP_Type) SetOPAMP6_TCMR_VMS_SEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP6_TCMR.Reg, volatile.LoadUint32(&o.OPAMP6_TCMR.Reg)&^(0x1)|value)
}
func (o *OPAMP_Type) GetOPAMP6_TCMR_VMS_SEL() uint32 {
	return volatile.LoadUint32(&o.OPAMP6_TCMR.Reg) & 0x1
}
func (o *OPAMP_Type) SetOPAMP6_TCMR_VPS_SEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP6_TCMR.Reg, volatile.LoadUint32(&o.OPAMP6_TCMR.Reg)&^(0x6)|value<<1)
}
func (o *OPAMP_Type) GetOPAMP6_TCMR_VPS_SEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP6_TCMR.Reg) & 0x6) >> 1
}
func (o *OPAMP_Type) SetOPAMP6_TCMR_T1CM_EN(value uint32) {
	volatile.StoreUint32(&o.OPAMP6_TCMR.Reg, volatile.LoadUint32(&o.OPAMP6_TCMR.Reg)&^(0x8)|value<<3)
}
func (o *OPAMP_Type) GetOPAMP6_TCMR_T1CM_EN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP6_TCMR.Reg) & 0x8) >> 3
}
func (o *OPAMP_Type) SetOPAMP6_TCMR_T8CM_EN(value uint32) {
	volatile.StoreUint32(&o.OPAMP6_TCMR.Reg, volatile.LoadUint32(&o.OPAMP6_TCMR.Reg)&^(0x10)|value<<4)
}
func (o *OPAMP_Type) GetOPAMP6_TCMR_T8CM_EN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP6_TCMR.Reg) & 0x10) >> 4
}
func (o *OPAMP_Type) SetOPAMP6_TCMR_T20CM_EN(value uint32) {
	volatile.StoreUint32(&o.OPAMP6_TCMR.Reg, volatile.LoadUint32(&o.OPAMP6_TCMR.Reg)&^(0x20)|value<<5)
}
func (o *OPAMP_Type) GetOPAMP6_TCMR_T20CM_EN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP6_TCMR.Reg) & 0x20) >> 5
}
func (o *OPAMP_Type) SetOPAMP6_TCMR_LOCK(value uint32) {
	volatile.StoreUint32(&o.OPAMP6_TCMR.Reg, volatile.LoadUint32(&o.OPAMP6_TCMR.Reg)&^(0x80000000)|value<<31)
}
func (o *OPAMP_Type) GetOPAMP6_TCMR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.OPAMP6_TCMR.Reg) & 0x80000000) >> 31
}

// Digital-to-analog converter
type DAC_Type struct {
	DAC_CR      volatile.Register32 // 0x0
	DAC_SWTRGR  volatile.Register32 // 0x4
	DAC_DHR12R1 volatile.Register32 // 0x8
	DAC_DHR12L1 volatile.Register32 // 0xC
	DAC_DHR8R1  volatile.Register32 // 0x10
	DAC_DHR12R2 volatile.Register32 // 0x14
	DAC_DHR12L2 volatile.Register32 // 0x18
	DAC_DHR8R2  volatile.Register32 // 0x1C
	DAC_DHR12RD volatile.Register32 // 0x20
	DAC_DHR12LD volatile.Register32 // 0x24
	DAC_DHR8RD  volatile.Register32 // 0x28
	DAC_DOR1    volatile.Register32 // 0x2C
	DAC_DOR2    volatile.Register32 // 0x30
	DAC_SR      volatile.Register32 // 0x34
	DAC_CCR     volatile.Register32 // 0x38
	DAC_MCR     volatile.Register32 // 0x3C
	DAC_SHSR1   volatile.Register32 // 0x40
	DAC_SHSR2   volatile.Register32 // 0x44
	DAC_SHHR    volatile.Register32 // 0x48
	DAC_SHRR    volatile.Register32 // 0x4C
	_           [8]byte
	DAC_STR1    volatile.Register32 // 0x58
	DAC_STR2    volatile.Register32 // 0x5C
	DAC_STMODR  volatile.Register32 // 0x60
}

// DAC.DAC_CR: DAC control register
func (o *DAC_Type) SetDAC_CR_EN1(value uint32) {
	volatile.StoreUint32(&o.DAC_CR.Reg, volatile.LoadUint32(&o.DAC_CR.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetDAC_CR_EN1() uint32 {
	return volatile.LoadUint32(&o.DAC_CR.Reg) & 0x1
}
func (o *DAC_Type) SetDAC_CR_TEN1(value uint32) {
	volatile.StoreUint32(&o.DAC_CR.Reg, volatile.LoadUint32(&o.DAC_CR.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetDAC_CR_TEN1() uint32 {
	return (volatile.LoadUint32(&o.DAC_CR.Reg) & 0x2) >> 1
}
func (o *DAC_Type) SetDAC_CR_TSEL1(value uint32) {
	volatile.StoreUint32(&o.DAC_CR.Reg, volatile.LoadUint32(&o.DAC_CR.Reg)&^(0x3c)|value<<2)
}
func (o *DAC_Type) GetDAC_CR_TSEL1() uint32 {
	return (volatile.LoadUint32(&o.DAC_CR.Reg) & 0x3c) >> 2
}
func (o *DAC_Type) SetDAC_CR_WAVE1(value uint32) {
	volatile.StoreUint32(&o.DAC_CR.Reg, volatile.LoadUint32(&o.DAC_CR.Reg)&^(0xc0)|value<<6)
}
func (o *DAC_Type) GetDAC_CR_WAVE1() uint32 {
	return (volatile.LoadUint32(&o.DAC_CR.Reg) & 0xc0) >> 6
}
func (o *DAC_Type) SetDAC_CR_MAMP1(value uint32) {
	volatile.StoreUint32(&o.DAC_CR.Reg, volatile.LoadUint32(&o.DAC_CR.Reg)&^(0xf00)|value<<8)
}
func (o *DAC_Type) GetDAC_CR_MAMP1() uint32 {
	return (volatile.LoadUint32(&o.DAC_CR.Reg) & 0xf00) >> 8
}
func (o *DAC_Type) SetDAC_CR_DMAEN1(value uint32) {
	volatile.StoreUint32(&o.DAC_CR.Reg, volatile.LoadUint32(&o.DAC_CR.Reg)&^(0x1000)|value<<12)
}
func (o *DAC_Type) GetDAC_CR_DMAEN1() uint32 {
	return (volatile.LoadUint32(&o.DAC_CR.Reg) & 0x1000) >> 12
}
func (o *DAC_Type) SetDAC_CR_DMAUDRIE1(value uint32) {
	volatile.StoreUint32(&o.DAC_CR.Reg, volatile.LoadUint32(&o.DAC_CR.Reg)&^(0x2000)|value<<13)
}
func (o *DAC_Type) GetDAC_CR_DMAUDRIE1() uint32 {
	return (volatile.LoadUint32(&o.DAC_CR.Reg) & 0x2000) >> 13
}
func (o *DAC_Type) SetDAC_CR_CEN1(value uint32) {
	volatile.StoreUint32(&o.DAC_CR.Reg, volatile.LoadUint32(&o.DAC_CR.Reg)&^(0x4000)|value<<14)
}
func (o *DAC_Type) GetDAC_CR_CEN1() uint32 {
	return (volatile.LoadUint32(&o.DAC_CR.Reg) & 0x4000) >> 14
}
func (o *DAC_Type) SetDAC_CR_EN2(value uint32) {
	volatile.StoreUint32(&o.DAC_CR.Reg, volatile.LoadUint32(&o.DAC_CR.Reg)&^(0x10000)|value<<16)
}
func (o *DAC_Type) GetDAC_CR_EN2() uint32 {
	return (volatile.LoadUint32(&o.DAC_CR.Reg) & 0x10000) >> 16
}
func (o *DAC_Type) SetDAC_CR_TEN2(value uint32) {
	volatile.StoreUint32(&o.DAC_CR.Reg, volatile.LoadUint32(&o.DAC_CR.Reg)&^(0x20000)|value<<17)
}
func (o *DAC_Type) GetDAC_CR_TEN2() uint32 {
	return (volatile.LoadUint32(&o.DAC_CR.Reg) & 0x20000) >> 17
}
func (o *DAC_Type) SetDAC_CR_TSEL2(value uint32) {
	volatile.StoreUint32(&o.DAC_CR.Reg, volatile.LoadUint32(&o.DAC_CR.Reg)&^(0x3c0000)|value<<18)
}
func (o *DAC_Type) GetDAC_CR_TSEL2() uint32 {
	return (volatile.LoadUint32(&o.DAC_CR.Reg) & 0x3c0000) >> 18
}
func (o *DAC_Type) SetDAC_CR_WAVE2(value uint32) {
	volatile.StoreUint32(&o.DAC_CR.Reg, volatile.LoadUint32(&o.DAC_CR.Reg)&^(0xc00000)|value<<22)
}
func (o *DAC_Type) GetDAC_CR_WAVE2() uint32 {
	return (volatile.LoadUint32(&o.DAC_CR.Reg) & 0xc00000) >> 22
}
func (o *DAC_Type) SetDAC_CR_MAMP2(value uint32) {
	volatile.StoreUint32(&o.DAC_CR.Reg, volatile.LoadUint32(&o.DAC_CR.Reg)&^(0xf000000)|value<<24)
}
func (o *DAC_Type) GetDAC_CR_MAMP2() uint32 {
	return (volatile.LoadUint32(&o.DAC_CR.Reg) & 0xf000000) >> 24
}
func (o *DAC_Type) SetDAC_CR_DMAEN2(value uint32) {
	volatile.StoreUint32(&o.DAC_CR.Reg, volatile.LoadUint32(&o.DAC_CR.Reg)&^(0x10000000)|value<<28)
}
func (o *DAC_Type) GetDAC_CR_DMAEN2() uint32 {
	return (volatile.LoadUint32(&o.DAC_CR.Reg) & 0x10000000) >> 28
}
func (o *DAC_Type) SetDAC_CR_DMAUDRIE2(value uint32) {
	volatile.StoreUint32(&o.DAC_CR.Reg, volatile.LoadUint32(&o.DAC_CR.Reg)&^(0x20000000)|value<<29)
}
func (o *DAC_Type) GetDAC_CR_DMAUDRIE2() uint32 {
	return (volatile.LoadUint32(&o.DAC_CR.Reg) & 0x20000000) >> 29
}
func (o *DAC_Type) SetDAC_CR_CEN2(value uint32) {
	volatile.StoreUint32(&o.DAC_CR.Reg, volatile.LoadUint32(&o.DAC_CR.Reg)&^(0x40000000)|value<<30)
}
func (o *DAC_Type) GetDAC_CR_CEN2() uint32 {
	return (volatile.LoadUint32(&o.DAC_CR.Reg) & 0x40000000) >> 30
}

// DAC.DAC_SWTRGR: DAC software trigger register
func (o *DAC_Type) SetDAC_SWTRGR_SWTRIG1(value uint32) {
	volatile.StoreUint32(&o.DAC_SWTRGR.Reg, volatile.LoadUint32(&o.DAC_SWTRGR.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetDAC_SWTRGR_SWTRIG1() uint32 {
	return volatile.LoadUint32(&o.DAC_SWTRGR.Reg) & 0x1
}
func (o *DAC_Type) SetDAC_SWTRGR_SWTRIG2(value uint32) {
	volatile.StoreUint32(&o.DAC_SWTRGR.Reg, volatile.LoadUint32(&o.DAC_SWTRGR.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetDAC_SWTRGR_SWTRIG2() uint32 {
	return (volatile.LoadUint32(&o.DAC_SWTRGR.Reg) & 0x2) >> 1
}
func (o *DAC_Type) SetDAC_SWTRGR_SWTRIGB1(value uint32) {
	volatile.StoreUint32(&o.DAC_SWTRGR.Reg, volatile.LoadUint32(&o.DAC_SWTRGR.Reg)&^(0x10000)|value<<16)
}
func (o *DAC_Type) GetDAC_SWTRGR_SWTRIGB1() uint32 {
	return (volatile.LoadUint32(&o.DAC_SWTRGR.Reg) & 0x10000) >> 16
}
func (o *DAC_Type) SetDAC_SWTRGR_SWTRIGB2(value uint32) {
	volatile.StoreUint32(&o.DAC_SWTRGR.Reg, volatile.LoadUint32(&o.DAC_SWTRGR.Reg)&^(0x20000)|value<<17)
}
func (o *DAC_Type) GetDAC_SWTRGR_SWTRIGB2() uint32 {
	return (volatile.LoadUint32(&o.DAC_SWTRGR.Reg) & 0x20000) >> 17
}

// DAC.DAC_DHR12R1: DAC channel1 12-bit right-aligned data holding register
func (o *DAC_Type) SetDAC_DHR12R1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DAC_DHR12R1.Reg, volatile.LoadUint32(&o.DAC_DHR12R1.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDAC_DHR12R1_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DAC_DHR12R1.Reg) & 0xfff
}
func (o *DAC_Type) SetDAC_DHR12R1_DACC1DHRB(value uint32) {
	volatile.StoreUint32(&o.DAC_DHR12R1.Reg, volatile.LoadUint32(&o.DAC_DHR12R1.Reg)&^(0xfff0000)|value<<16)
}
func (o *DAC_Type) GetDAC_DHR12R1_DACC1DHRB() uint32 {
	return (volatile.LoadUint32(&o.DAC_DHR12R1.Reg) & 0xfff0000) >> 16
}

// DAC.DAC_DHR12L1: DAC channel1 12-bit left aligned data holding register
func (o *DAC_Type) SetDAC_DHR12L1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DAC_DHR12L1.Reg, volatile.LoadUint32(&o.DAC_DHR12L1.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDAC_DHR12L1_DACC1DHR() uint32 {
	return (volatile.LoadUint32(&o.DAC_DHR12L1.Reg) & 0xfff0) >> 4
}
func (o *DAC_Type) SetDAC_DHR12L1_DACC1DHRB(value uint32) {
	volatile.StoreUint32(&o.DAC_DHR12L1.Reg, volatile.LoadUint32(&o.DAC_DHR12L1.Reg)&^(0xfff00000)|value<<20)
}
func (o *DAC_Type) GetDAC_DHR12L1_DACC1DHRB() uint32 {
	return (volatile.LoadUint32(&o.DAC_DHR12L1.Reg) & 0xfff00000) >> 20
}

// DAC.DAC_DHR8R1: DAC channel1 8-bit right aligned data holding register
func (o *DAC_Type) SetDAC_DHR8R1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DAC_DHR8R1.Reg, volatile.LoadUint32(&o.DAC_DHR8R1.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDAC_DHR8R1_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DAC_DHR8R1.Reg) & 0xff
}
func (o *DAC_Type) SetDAC_DHR8R1_DACC1DHRB(value uint32) {
	volatile.StoreUint32(&o.DAC_DHR8R1.Reg, volatile.LoadUint32(&o.DAC_DHR8R1.Reg)&^(0xff00)|value<<8)
}
func (o *DAC_Type) GetDAC_DHR8R1_DACC1DHRB() uint32 {
	return (volatile.LoadUint32(&o.DAC_DHR8R1.Reg) & 0xff00) >> 8
}

// DAC.DAC_DHR12R2: DAC channel2 12-bit right aligned data holding register
func (o *DAC_Type) SetDAC_DHR12R2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DAC_DHR12R2.Reg, volatile.LoadUint32(&o.DAC_DHR12R2.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDAC_DHR12R2_DACC2DHR() uint32 {
	return volatile.LoadUint32(&o.DAC_DHR12R2.Reg) & 0xfff
}
func (o *DAC_Type) SetDAC_DHR12R2_DACC2DHRB(value uint32) {
	volatile.StoreUint32(&o.DAC_DHR12R2.Reg, volatile.LoadUint32(&o.DAC_DHR12R2.Reg)&^(0xfff0000)|value<<16)
}
func (o *DAC_Type) GetDAC_DHR12R2_DACC2DHRB() uint32 {
	return (volatile.LoadUint32(&o.DAC_DHR12R2.Reg) & 0xfff0000) >> 16
}

// DAC.DAC_DHR12L2: DAC channel2 12-bit left aligned data holding register
func (o *DAC_Type) SetDAC_DHR12L2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DAC_DHR12L2.Reg, volatile.LoadUint32(&o.DAC_DHR12L2.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDAC_DHR12L2_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DAC_DHR12L2.Reg) & 0xfff0) >> 4
}
func (o *DAC_Type) SetDAC_DHR12L2_DACC2DHRB(value uint32) {
	volatile.StoreUint32(&o.DAC_DHR12L2.Reg, volatile.LoadUint32(&o.DAC_DHR12L2.Reg)&^(0xfff00000)|value<<20)
}
func (o *DAC_Type) GetDAC_DHR12L2_DACC2DHRB() uint32 {
	return (volatile.LoadUint32(&o.DAC_DHR12L2.Reg) & 0xfff00000) >> 20
}

// DAC.DAC_DHR8R2: DAC channel2 8-bit right-aligned data holding register
func (o *DAC_Type) SetDAC_DHR8R2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DAC_DHR8R2.Reg, volatile.LoadUint32(&o.DAC_DHR8R2.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDAC_DHR8R2_DACC2DHR() uint32 {
	return volatile.LoadUint32(&o.DAC_DHR8R2.Reg) & 0xff
}
func (o *DAC_Type) SetDAC_DHR8R2_DACC2DHRB(value uint32) {
	volatile.StoreUint32(&o.DAC_DHR8R2.Reg, volatile.LoadUint32(&o.DAC_DHR8R2.Reg)&^(0xff00)|value<<8)
}
func (o *DAC_Type) GetDAC_DHR8R2_DACC2DHRB() uint32 {
	return (volatile.LoadUint32(&o.DAC_DHR8R2.Reg) & 0xff00) >> 8
}

// DAC.DAC_DHR12RD: Dual DAC 12-bit right-aligned data holding register
func (o *DAC_Type) SetDAC_DHR12RD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DAC_DHR12RD.Reg, volatile.LoadUint32(&o.DAC_DHR12RD.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDAC_DHR12RD_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DAC_DHR12RD.Reg) & 0xfff
}
func (o *DAC_Type) SetDAC_DHR12RD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DAC_DHR12RD.Reg, volatile.LoadUint32(&o.DAC_DHR12RD.Reg)&^(0xfff0000)|value<<16)
}
func (o *DAC_Type) GetDAC_DHR12RD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DAC_DHR12RD.Reg) & 0xfff0000) >> 16
}

// DAC.DAC_DHR12LD: DUAL DAC 12-bit left aligned data holding register
func (o *DAC_Type) SetDAC_DHR12LD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DAC_DHR12LD.Reg, volatile.LoadUint32(&o.DAC_DHR12LD.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDAC_DHR12LD_DACC1DHR() uint32 {
	return (volatile.LoadUint32(&o.DAC_DHR12LD.Reg) & 0xfff0) >> 4
}
func (o *DAC_Type) SetDAC_DHR12LD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DAC_DHR12LD.Reg, volatile.LoadUint32(&o.DAC_DHR12LD.Reg)&^(0xfff00000)|value<<20)
}
func (o *DAC_Type) GetDAC_DHR12LD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DAC_DHR12LD.Reg) & 0xfff00000) >> 20
}

// DAC.DAC_DHR8RD: DUAL DAC 8-bit right aligned data holding register
func (o *DAC_Type) SetDAC_DHR8RD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DAC_DHR8RD.Reg, volatile.LoadUint32(&o.DAC_DHR8RD.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDAC_DHR8RD_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DAC_DHR8RD.Reg) & 0xff
}
func (o *DAC_Type) SetDAC_DHR8RD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DAC_DHR8RD.Reg, volatile.LoadUint32(&o.DAC_DHR8RD.Reg)&^(0xff00)|value<<8)
}
func (o *DAC_Type) GetDAC_DHR8RD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DAC_DHR8RD.Reg) & 0xff00) >> 8
}

// DAC.DAC_DOR1: DAC channel1 data output register
func (o *DAC_Type) SetDAC_DOR1_DACC1DOR(value uint32) {
	volatile.StoreUint32(&o.DAC_DOR1.Reg, volatile.LoadUint32(&o.DAC_DOR1.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDAC_DOR1_DACC1DOR() uint32 {
	return volatile.LoadUint32(&o.DAC_DOR1.Reg) & 0xfff
}
func (o *DAC_Type) SetDAC_DOR1_DACC1DORB(value uint32) {
	volatile.StoreUint32(&o.DAC_DOR1.Reg, volatile.LoadUint32(&o.DAC_DOR1.Reg)&^(0xfff0000)|value<<16)
}
func (o *DAC_Type) GetDAC_DOR1_DACC1DORB() uint32 {
	return (volatile.LoadUint32(&o.DAC_DOR1.Reg) & 0xfff0000) >> 16
}

// DAC.DAC_DOR2: DAC channel2 data output register
func (o *DAC_Type) SetDAC_DOR2_DACC2DOR(value uint32) {
	volatile.StoreUint32(&o.DAC_DOR2.Reg, volatile.LoadUint32(&o.DAC_DOR2.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDAC_DOR2_DACC2DOR() uint32 {
	return volatile.LoadUint32(&o.DAC_DOR2.Reg) & 0xfff
}
func (o *DAC_Type) SetDAC_DOR2_DACC2DORB(value uint32) {
	volatile.StoreUint32(&o.DAC_DOR2.Reg, volatile.LoadUint32(&o.DAC_DOR2.Reg)&^(0xfff0000)|value<<16)
}
func (o *DAC_Type) GetDAC_DOR2_DACC2DORB() uint32 {
	return (volatile.LoadUint32(&o.DAC_DOR2.Reg) & 0xfff0000) >> 16
}

// DAC.DAC_SR: DAC status register
func (o *DAC_Type) SetDAC_SR_DAC1RDY(value uint32) {
	volatile.StoreUint32(&o.DAC_SR.Reg, volatile.LoadUint32(&o.DAC_SR.Reg)&^(0x800)|value<<11)
}
func (o *DAC_Type) GetDAC_SR_DAC1RDY() uint32 {
	return (volatile.LoadUint32(&o.DAC_SR.Reg) & 0x800) >> 11
}
func (o *DAC_Type) SetDAC_SR_DORSTAT1(value uint32) {
	volatile.StoreUint32(&o.DAC_SR.Reg, volatile.LoadUint32(&o.DAC_SR.Reg)&^(0x1000)|value<<12)
}
func (o *DAC_Type) GetDAC_SR_DORSTAT1() uint32 {
	return (volatile.LoadUint32(&o.DAC_SR.Reg) & 0x1000) >> 12
}
func (o *DAC_Type) SetDAC_SR_DMAUDR1(value uint32) {
	volatile.StoreUint32(&o.DAC_SR.Reg, volatile.LoadUint32(&o.DAC_SR.Reg)&^(0x2000)|value<<13)
}
func (o *DAC_Type) GetDAC_SR_DMAUDR1() uint32 {
	return (volatile.LoadUint32(&o.DAC_SR.Reg) & 0x2000) >> 13
}
func (o *DAC_Type) SetDAC_SR_CAL_FLAG1(value uint32) {
	volatile.StoreUint32(&o.DAC_SR.Reg, volatile.LoadUint32(&o.DAC_SR.Reg)&^(0x4000)|value<<14)
}
func (o *DAC_Type) GetDAC_SR_CAL_FLAG1() uint32 {
	return (volatile.LoadUint32(&o.DAC_SR.Reg) & 0x4000) >> 14
}
func (o *DAC_Type) SetDAC_SR_BWST1(value uint32) {
	volatile.StoreUint32(&o.DAC_SR.Reg, volatile.LoadUint32(&o.DAC_SR.Reg)&^(0x8000)|value<<15)
}
func (o *DAC_Type) GetDAC_SR_BWST1() uint32 {
	return (volatile.LoadUint32(&o.DAC_SR.Reg) & 0x8000) >> 15
}
func (o *DAC_Type) SetDAC_SR_DAC2RDY(value uint32) {
	volatile.StoreUint32(&o.DAC_SR.Reg, volatile.LoadUint32(&o.DAC_SR.Reg)&^(0x8000000)|value<<27)
}
func (o *DAC_Type) GetDAC_SR_DAC2RDY() uint32 {
	return (volatile.LoadUint32(&o.DAC_SR.Reg) & 0x8000000) >> 27
}
func (o *DAC_Type) SetDAC_SR_DORSTAT2(value uint32) {
	volatile.StoreUint32(&o.DAC_SR.Reg, volatile.LoadUint32(&o.DAC_SR.Reg)&^(0x10000000)|value<<28)
}
func (o *DAC_Type) GetDAC_SR_DORSTAT2() uint32 {
	return (volatile.LoadUint32(&o.DAC_SR.Reg) & 0x10000000) >> 28
}
func (o *DAC_Type) SetDAC_SR_DMAUDR2(value uint32) {
	volatile.StoreUint32(&o.DAC_SR.Reg, volatile.LoadUint32(&o.DAC_SR.Reg)&^(0x20000000)|value<<29)
}
func (o *DAC_Type) GetDAC_SR_DMAUDR2() uint32 {
	return (volatile.LoadUint32(&o.DAC_SR.Reg) & 0x20000000) >> 29
}
func (o *DAC_Type) SetDAC_SR_CAL_FLAG2(value uint32) {
	volatile.StoreUint32(&o.DAC_SR.Reg, volatile.LoadUint32(&o.DAC_SR.Reg)&^(0x40000000)|value<<30)
}
func (o *DAC_Type) GetDAC_SR_CAL_FLAG2() uint32 {
	return (volatile.LoadUint32(&o.DAC_SR.Reg) & 0x40000000) >> 30
}
func (o *DAC_Type) SetDAC_SR_BWST2(value uint32) {
	volatile.StoreUint32(&o.DAC_SR.Reg, volatile.LoadUint32(&o.DAC_SR.Reg)&^(0x80000000)|value<<31)
}
func (o *DAC_Type) GetDAC_SR_BWST2() uint32 {
	return (volatile.LoadUint32(&o.DAC_SR.Reg) & 0x80000000) >> 31
}

// DAC.DAC_CCR: DAC calibration control register
func (o *DAC_Type) SetDAC_CCR_OTRIM1(value uint32) {
	volatile.StoreUint32(&o.DAC_CCR.Reg, volatile.LoadUint32(&o.DAC_CCR.Reg)&^(0x1f)|value)
}
func (o *DAC_Type) GetDAC_CCR_OTRIM1() uint32 {
	return volatile.LoadUint32(&o.DAC_CCR.Reg) & 0x1f
}
func (o *DAC_Type) SetDAC_CCR_OTRIM2(value uint32) {
	volatile.StoreUint32(&o.DAC_CCR.Reg, volatile.LoadUint32(&o.DAC_CCR.Reg)&^(0x1f0000)|value<<16)
}
func (o *DAC_Type) GetDAC_CCR_OTRIM2() uint32 {
	return (volatile.LoadUint32(&o.DAC_CCR.Reg) & 0x1f0000) >> 16
}

// DAC.DAC_MCR: DAC mode control register
func (o *DAC_Type) SetDAC_MCR_MODE1(value uint32) {
	volatile.StoreUint32(&o.DAC_MCR.Reg, volatile.LoadUint32(&o.DAC_MCR.Reg)&^(0x7)|value)
}
func (o *DAC_Type) GetDAC_MCR_MODE1() uint32 {
	return volatile.LoadUint32(&o.DAC_MCR.Reg) & 0x7
}
func (o *DAC_Type) SetDAC_MCR_DMADOUBLE1(value uint32) {
	volatile.StoreUint32(&o.DAC_MCR.Reg, volatile.LoadUint32(&o.DAC_MCR.Reg)&^(0x100)|value<<8)
}
func (o *DAC_Type) GetDAC_MCR_DMADOUBLE1() uint32 {
	return (volatile.LoadUint32(&o.DAC_MCR.Reg) & 0x100) >> 8
}
func (o *DAC_Type) SetDAC_MCR_SINFORMAT1(value uint32) {
	volatile.StoreUint32(&o.DAC_MCR.Reg, volatile.LoadUint32(&o.DAC_MCR.Reg)&^(0x200)|value<<9)
}
func (o *DAC_Type) GetDAC_MCR_SINFORMAT1() uint32 {
	return (volatile.LoadUint32(&o.DAC_MCR.Reg) & 0x200) >> 9
}
func (o *DAC_Type) SetDAC_MCR_HFSEL(value uint32) {
	volatile.StoreUint32(&o.DAC_MCR.Reg, volatile.LoadUint32(&o.DAC_MCR.Reg)&^(0xc000)|value<<14)
}
func (o *DAC_Type) GetDAC_MCR_HFSEL() uint32 {
	return (volatile.LoadUint32(&o.DAC_MCR.Reg) & 0xc000) >> 14
}
func (o *DAC_Type) SetDAC_MCR_MODE2(value uint32) {
	volatile.StoreUint32(&o.DAC_MCR.Reg, volatile.LoadUint32(&o.DAC_MCR.Reg)&^(0x70000)|value<<16)
}
func (o *DAC_Type) GetDAC_MCR_MODE2() uint32 {
	return (volatile.LoadUint32(&o.DAC_MCR.Reg) & 0x70000) >> 16
}
func (o *DAC_Type) SetDAC_MCR_DMADOUBLE2(value uint32) {
	volatile.StoreUint32(&o.DAC_MCR.Reg, volatile.LoadUint32(&o.DAC_MCR.Reg)&^(0x1000000)|value<<24)
}
func (o *DAC_Type) GetDAC_MCR_DMADOUBLE2() uint32 {
	return (volatile.LoadUint32(&o.DAC_MCR.Reg) & 0x1000000) >> 24
}
func (o *DAC_Type) SetDAC_MCR_SINFORMAT2(value uint32) {
	volatile.StoreUint32(&o.DAC_MCR.Reg, volatile.LoadUint32(&o.DAC_MCR.Reg)&^(0x2000000)|value<<25)
}
func (o *DAC_Type) GetDAC_MCR_SINFORMAT2() uint32 {
	return (volatile.LoadUint32(&o.DAC_MCR.Reg) & 0x2000000) >> 25
}

// DAC.DAC_SHSR1: DAC Sample and Hold sample time register 1
func (o *DAC_Type) SetDAC_SHSR1_TSAMPLE1(value uint32) {
	volatile.StoreUint32(&o.DAC_SHSR1.Reg, volatile.LoadUint32(&o.DAC_SHSR1.Reg)&^(0x3ff)|value)
}
func (o *DAC_Type) GetDAC_SHSR1_TSAMPLE1() uint32 {
	return volatile.LoadUint32(&o.DAC_SHSR1.Reg) & 0x3ff
}

// DAC.DAC_SHSR2: DAC Sample and Hold sample time register 2
func (o *DAC_Type) SetDAC_SHSR2_TSAMPLE2(value uint32) {
	volatile.StoreUint32(&o.DAC_SHSR2.Reg, volatile.LoadUint32(&o.DAC_SHSR2.Reg)&^(0x3ff)|value)
}
func (o *DAC_Type) GetDAC_SHSR2_TSAMPLE2() uint32 {
	return volatile.LoadUint32(&o.DAC_SHSR2.Reg) & 0x3ff
}

// DAC.DAC_SHHR: DAC Sample and Hold hold time register
func (o *DAC_Type) SetDAC_SHHR_THOLD1(value uint32) {
	volatile.StoreUint32(&o.DAC_SHHR.Reg, volatile.LoadUint32(&o.DAC_SHHR.Reg)&^(0x3ff)|value)
}
func (o *DAC_Type) GetDAC_SHHR_THOLD1() uint32 {
	return volatile.LoadUint32(&o.DAC_SHHR.Reg) & 0x3ff
}
func (o *DAC_Type) SetDAC_SHHR_THOLD2(value uint32) {
	volatile.StoreUint32(&o.DAC_SHHR.Reg, volatile.LoadUint32(&o.DAC_SHHR.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DAC_Type) GetDAC_SHHR_THOLD2() uint32 {
	return (volatile.LoadUint32(&o.DAC_SHHR.Reg) & 0x3ff0000) >> 16
}

// DAC.DAC_SHRR: DAC Sample and Hold refresh time register
func (o *DAC_Type) SetDAC_SHRR_TREFRESH1(value uint32) {
	volatile.StoreUint32(&o.DAC_SHRR.Reg, volatile.LoadUint32(&o.DAC_SHRR.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDAC_SHRR_TREFRESH1() uint32 {
	return volatile.LoadUint32(&o.DAC_SHRR.Reg) & 0xff
}
func (o *DAC_Type) SetDAC_SHRR_TREFRESH2(value uint32) {
	volatile.StoreUint32(&o.DAC_SHRR.Reg, volatile.LoadUint32(&o.DAC_SHRR.Reg)&^(0xff0000)|value<<16)
}
func (o *DAC_Type) GetDAC_SHRR_TREFRESH2() uint32 {
	return (volatile.LoadUint32(&o.DAC_SHRR.Reg) & 0xff0000) >> 16
}

// DAC.DAC_STR1: Sawtooth register
func (o *DAC_Type) SetDAC_STR1_STRSTDATA1(value uint32) {
	volatile.StoreUint32(&o.DAC_STR1.Reg, volatile.LoadUint32(&o.DAC_STR1.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDAC_STR1_STRSTDATA1() uint32 {
	return volatile.LoadUint32(&o.DAC_STR1.Reg) & 0xfff
}
func (o *DAC_Type) SetDAC_STR1_STDIR1(value uint32) {
	volatile.StoreUint32(&o.DAC_STR1.Reg, volatile.LoadUint32(&o.DAC_STR1.Reg)&^(0x1000)|value<<12)
}
func (o *DAC_Type) GetDAC_STR1_STDIR1() uint32 {
	return (volatile.LoadUint32(&o.DAC_STR1.Reg) & 0x1000) >> 12
}
func (o *DAC_Type) SetDAC_STR1_STINCDATA1(value uint32) {
	volatile.StoreUint32(&o.DAC_STR1.Reg, volatile.LoadUint32(&o.DAC_STR1.Reg)&^(0xffff0000)|value<<16)
}
func (o *DAC_Type) GetDAC_STR1_STINCDATA1() uint32 {
	return (volatile.LoadUint32(&o.DAC_STR1.Reg) & 0xffff0000) >> 16
}

// DAC.DAC_STR2: Sawtooth register
func (o *DAC_Type) SetDAC_STR2_STRSTDATA2(value uint32) {
	volatile.StoreUint32(&o.DAC_STR2.Reg, volatile.LoadUint32(&o.DAC_STR2.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDAC_STR2_STRSTDATA2() uint32 {
	return volatile.LoadUint32(&o.DAC_STR2.Reg) & 0xfff
}
func (o *DAC_Type) SetDAC_STR2_STDIR2(value uint32) {
	volatile.StoreUint32(&o.DAC_STR2.Reg, volatile.LoadUint32(&o.DAC_STR2.Reg)&^(0x1000)|value<<12)
}
func (o *DAC_Type) GetDAC_STR2_STDIR2() uint32 {
	return (volatile.LoadUint32(&o.DAC_STR2.Reg) & 0x1000) >> 12
}
func (o *DAC_Type) SetDAC_STR2_STINCDATA2(value uint32) {
	volatile.StoreUint32(&o.DAC_STR2.Reg, volatile.LoadUint32(&o.DAC_STR2.Reg)&^(0xffff0000)|value<<16)
}
func (o *DAC_Type) GetDAC_STR2_STINCDATA2() uint32 {
	return (volatile.LoadUint32(&o.DAC_STR2.Reg) & 0xffff0000) >> 16
}

// DAC.DAC_STMODR: Sawtooth Mode register
func (o *DAC_Type) SetDAC_STMODR_STRSTTRIGSEL1(value uint32) {
	volatile.StoreUint32(&o.DAC_STMODR.Reg, volatile.LoadUint32(&o.DAC_STMODR.Reg)&^(0xf)|value)
}
func (o *DAC_Type) GetDAC_STMODR_STRSTTRIGSEL1() uint32 {
	return volatile.LoadUint32(&o.DAC_STMODR.Reg) & 0xf
}
func (o *DAC_Type) SetDAC_STMODR_STINCTRIGSEL1(value uint32) {
	volatile.StoreUint32(&o.DAC_STMODR.Reg, volatile.LoadUint32(&o.DAC_STMODR.Reg)&^(0xf00)|value<<8)
}
func (o *DAC_Type) GetDAC_STMODR_STINCTRIGSEL1() uint32 {
	return (volatile.LoadUint32(&o.DAC_STMODR.Reg) & 0xf00) >> 8
}
func (o *DAC_Type) SetDAC_STMODR_STRSTTRIGSEL2(value uint32) {
	volatile.StoreUint32(&o.DAC_STMODR.Reg, volatile.LoadUint32(&o.DAC_STMODR.Reg)&^(0xf0000)|value<<16)
}
func (o *DAC_Type) GetDAC_STMODR_STRSTTRIGSEL2() uint32 {
	return (volatile.LoadUint32(&o.DAC_STMODR.Reg) & 0xf0000) >> 16
}
func (o *DAC_Type) SetDAC_STMODR_STINCTRIGSEL2(value uint32) {
	volatile.StoreUint32(&o.DAC_STMODR.Reg, volatile.LoadUint32(&o.DAC_STMODR.Reg)&^(0xf000000)|value<<24)
}
func (o *DAC_Type) GetDAC_STMODR_STINCTRIGSEL2() uint32 {
	return (volatile.LoadUint32(&o.DAC_STMODR.Reg) & 0xf000000) >> 24
}

// Analog-to-Digital Converter
type ADC_Type struct {
	ISR     volatile.Register32 // 0x0
	IER     volatile.Register32 // 0x4
	CR      volatile.Register32 // 0x8
	CFGR    volatile.Register32 // 0xC
	CFGR2   volatile.Register32 // 0x10
	SMPR1   volatile.Register32 // 0x14
	SMPR2   volatile.Register32 // 0x18
	_       [4]byte
	TR1     volatile.Register32 // 0x20
	TR2     volatile.Register32 // 0x24
	TR3     volatile.Register32 // 0x28
	_       [4]byte
	SQR1    volatile.Register32 // 0x30
	SQR2    volatile.Register32 // 0x34
	SQR3    volatile.Register32 // 0x38
	SQR4    volatile.Register32 // 0x3C
	DR      volatile.Register32 // 0x40
	_       [8]byte
	JSQR    volatile.Register32 // 0x4C
	_       [16]byte
	OFR1    volatile.Register32 // 0x60
	OFR2    volatile.Register32 // 0x64
	OFR3    volatile.Register32 // 0x68
	OFR4    volatile.Register32 // 0x6C
	_       [16]byte
	JDR1    volatile.Register32 // 0x80
	JDR2    volatile.Register32 // 0x84
	JDR3    volatile.Register32 // 0x88
	JDR4    volatile.Register32 // 0x8C
	_       [16]byte
	AWD2CR  volatile.Register32 // 0xA0
	AWD3CR  volatile.Register32 // 0xA4
	_       [8]byte
	DIFSEL  volatile.Register32 // 0xB0
	CALFACT volatile.Register32 // 0xB4
	_       [8]byte
	GCOMP   volatile.Register32 // 0xC0
}

// ADC.ISR: interrupt and status register
func (o *ADC_Type) SetISR_JQOVF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetISR_JQOVF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetISR_AWD3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetISR_AWD3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetISR_AWD2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetISR_AWD2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetISR_AWD1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetISR_AWD1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetISR_JEOS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetISR_JEOS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetISR_JEOC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetISR_JEOC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetISR_OVR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetISR_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetISR_EOS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetISR_EOS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetISR_EOC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetISR_EOC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetISR_EOSMP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetISR_EOSMP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetISR_ADRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetISR_ADRDY() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// ADC.IER: interrupt enable register
func (o *ADC_Type) SetIER_JQOVFIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetIER_JQOVFIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetIER_AWD3IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetIER_AWD3IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetIER_AWD2IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetIER_AWD2IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetIER_AWD1IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetIER_AWD1IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetIER_JEOSIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetIER_JEOSIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetIER_JEOCIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetIER_JEOCIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetIER_OVRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetIER_OVRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetIER_EOSIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetIER_EOSIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetIER_EOCIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetIER_EOCIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetIER_EOSMPIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetIER_EOSMPIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetIER_ADRDYIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetIER_ADRDYIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// ADC.CR: control register
func (o *ADC_Type) SetCR_ADCAL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetCR_ADCAL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetCR_ADCALDIF(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetCR_ADCALDIF() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetCR_DEEPPWD(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetCR_DEEPPWD() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetCR_ADVREGEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetCR_ADVREGEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000000) >> 28
}
func (o *ADC_Type) SetCR_JADSTP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCR_JADSTP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCR_ADSTP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCR_ADSTP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCR_JADSTART(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCR_JADSTART() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCR_ADSTART(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCR_ADSTART() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCR_ADDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCR_ADDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCR_ADEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCR_ADEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// ADC.CFGR: configuration register
func (o *ADC_Type) SetCFGR_JQDIS(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetCFGR_JQDIS() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetCFGR_AWD1CH(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetCFGR_AWD1CH() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetCFGR_JAUTO(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetCFGR_JAUTO() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetCFGR_JAWD1EN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetCFGR_JAWD1EN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetCFGR_AWD1EN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetCFGR_AWD1EN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetCFGR_AWD1SGL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetCFGR_AWD1SGL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetCFGR_JQM(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x200000)|value<<21)
}
func (o *ADC_Type) GetCFGR_JQM() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x200000) >> 21
}
func (o *ADC_Type) SetCFGR_JDISCEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x100000)|value<<20)
}
func (o *ADC_Type) GetCFGR_JDISCEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x100000) >> 20
}
func (o *ADC_Type) SetCFGR_DISCNUM(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe0000)|value<<17)
}
func (o *ADC_Type) GetCFGR_DISCNUM() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe0000) >> 17
}
func (o *ADC_Type) SetCFGR_DISCEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetCFGR_DISCEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetCFGR_ALIGN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetCFGR_ALIGN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetCFGR_AUTDLY(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetCFGR_AUTDLY() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetCFGR_CONT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetCFGR_CONT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetCFGR_OVRMOD(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetCFGR_OVRMOD() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetCFGR_EXTEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc00)|value<<10)
}
func (o *ADC_Type) GetCFGR_EXTEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc00) >> 10
}
func (o *ADC_Type) SetCFGR_EXTSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x3e0)|value<<5)
}
func (o *ADC_Type) GetCFGR_EXTSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x3e0) >> 5
}
func (o *ADC_Type) SetCFGR_RES(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x18)|value<<3)
}
func (o *ADC_Type) GetCFGR_RES() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x18) >> 3
}
func (o *ADC_Type) SetCFGR_DMACFG(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCFGR_DMACFG() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCFGR_DMAEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCFGR_DMAEN() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x1
}

// ADC.CFGR2: configuration register
func (o *ADC_Type) SetCFGR2_SMPTRIG(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x8000000)|value<<27)
}
func (o *ADC_Type) GetCFGR2_SMPTRIG() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x8000000) >> 27
}
func (o *ADC_Type) SetCFGR2_BULB(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetCFGR2_BULB() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetCFGR2_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetCFGR2_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetCFGR2_GCOMP(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetCFGR2_GCOMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetCFGR2_ROVSM(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCFGR2_ROVSM() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCFGR2_TROVS(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCFGR2_TROVS() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCFGR2_OVSS(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x1e0)|value<<5)
}
func (o *ADC_Type) GetCFGR2_OVSS() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x1e0) >> 5
}
func (o *ADC_Type) SetCFGR2_OVSR(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x1c)|value<<2)
}
func (o *ADC_Type) GetCFGR2_OVSR() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x1c) >> 2
}
func (o *ADC_Type) SetCFGR2_JOVSE(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCFGR2_JOVSE() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCFGR2_ROVSE(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCFGR2_ROVSE() uint32 {
	return volatile.LoadUint32(&o.CFGR2.Reg) & 0x1
}

// ADC.SMPR1: sample time register 1
func (o *ADC_Type) SetSMPR1_SMP9(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x38000000)|value<<27)
}
func (o *ADC_Type) GetSMPR1_SMP9() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x38000000) >> 27
}
func (o *ADC_Type) SetSMPR1_SMP8(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x7000000)|value<<24)
}
func (o *ADC_Type) GetSMPR1_SMP8() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x7000000) >> 24
}
func (o *ADC_Type) SetSMPR1_SMP7(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0xe00000)|value<<21)
}
func (o *ADC_Type) GetSMPR1_SMP7() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0xe00000) >> 21
}
func (o *ADC_Type) SetSMPR1_SMP6(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x1c0000)|value<<18)
}
func (o *ADC_Type) GetSMPR1_SMP6() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x1c0000) >> 18
}
func (o *ADC_Type) SetSMPR1_SMP5(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x38000)|value<<15)
}
func (o *ADC_Type) GetSMPR1_SMP5() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x38000) >> 15
}
func (o *ADC_Type) SetSMPR1_SMP4(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x7000)|value<<12)
}
func (o *ADC_Type) GetSMPR1_SMP4() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x7000) >> 12
}
func (o *ADC_Type) SetSMPR1_SMP3(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0xe00)|value<<9)
}
func (o *ADC_Type) GetSMPR1_SMP3() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0xe00) >> 9
}
func (o *ADC_Type) SetSMPR1_SMP2(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x1c0)|value<<6)
}
func (o *ADC_Type) GetSMPR1_SMP2() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x1c0) >> 6
}
func (o *ADC_Type) SetSMPR1_SMP1(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x38)|value<<3)
}
func (o *ADC_Type) GetSMPR1_SMP1() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x38) >> 3
}
func (o *ADC_Type) SetSMPR1_SMPPLUS(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetSMPR1_SMPPLUS() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetSMPR1_SMP0(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x7)|value)
}
func (o *ADC_Type) GetSMPR1_SMP0() uint32 {
	return volatile.LoadUint32(&o.SMPR1.Reg) & 0x7
}

// ADC.SMPR2: sample time register 2
func (o *ADC_Type) SetSMPR2_SMP18(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x7000000)|value<<24)
}
func (o *ADC_Type) GetSMPR2_SMP18() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x7000000) >> 24
}
func (o *ADC_Type) SetSMPR2_SMP17(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0xe00000)|value<<21)
}
func (o *ADC_Type) GetSMPR2_SMP17() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0xe00000) >> 21
}
func (o *ADC_Type) SetSMPR2_SMP16(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x1c0000)|value<<18)
}
func (o *ADC_Type) GetSMPR2_SMP16() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x1c0000) >> 18
}
func (o *ADC_Type) SetSMPR2_SMP15(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x38000)|value<<15)
}
func (o *ADC_Type) GetSMPR2_SMP15() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x38000) >> 15
}
func (o *ADC_Type) SetSMPR2_SMP14(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x7000)|value<<12)
}
func (o *ADC_Type) GetSMPR2_SMP14() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x7000) >> 12
}
func (o *ADC_Type) SetSMPR2_SMP13(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0xe00)|value<<9)
}
func (o *ADC_Type) GetSMPR2_SMP13() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0xe00) >> 9
}
func (o *ADC_Type) SetSMPR2_SMP12(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x1c0)|value<<6)
}
func (o *ADC_Type) GetSMPR2_SMP12() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x1c0) >> 6
}
func (o *ADC_Type) SetSMPR2_SMP11(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x38)|value<<3)
}
func (o *ADC_Type) GetSMPR2_SMP11() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x38) >> 3
}
func (o *ADC_Type) SetSMPR2_SMP10(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x7)|value)
}
func (o *ADC_Type) GetSMPR2_SMP10() uint32 {
	return volatile.LoadUint32(&o.SMPR2.Reg) & 0x7
}

// ADC.TR1: watchdog threshold register 1
func (o *ADC_Type) SetTR1_HT1(value uint32) {
	volatile.StoreUint32(&o.TR1.Reg, volatile.LoadUint32(&o.TR1.Reg)&^(0xfff0000)|value<<16)
}
func (o *ADC_Type) GetTR1_HT1() uint32 {
	return (volatile.LoadUint32(&o.TR1.Reg) & 0xfff0000) >> 16
}
func (o *ADC_Type) SetTR1_AWDFILT(value uint32) {
	volatile.StoreUint32(&o.TR1.Reg, volatile.LoadUint32(&o.TR1.Reg)&^(0x7000)|value<<12)
}
func (o *ADC_Type) GetTR1_AWDFILT() uint32 {
	return (volatile.LoadUint32(&o.TR1.Reg) & 0x7000) >> 12
}
func (o *ADC_Type) SetTR1_LT1(value uint32) {
	volatile.StoreUint32(&o.TR1.Reg, volatile.LoadUint32(&o.TR1.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetTR1_LT1() uint32 {
	return volatile.LoadUint32(&o.TR1.Reg) & 0xfff
}

// ADC.TR2: watchdog threshold register
func (o *ADC_Type) SetTR2_HT2(value uint32) {
	volatile.StoreUint32(&o.TR2.Reg, volatile.LoadUint32(&o.TR2.Reg)&^(0xff0000)|value<<16)
}
func (o *ADC_Type) GetTR2_HT2() uint32 {
	return (volatile.LoadUint32(&o.TR2.Reg) & 0xff0000) >> 16
}
func (o *ADC_Type) SetTR2_LT2(value uint32) {
	volatile.StoreUint32(&o.TR2.Reg, volatile.LoadUint32(&o.TR2.Reg)&^(0xff)|value)
}
func (o *ADC_Type) GetTR2_LT2() uint32 {
	return volatile.LoadUint32(&o.TR2.Reg) & 0xff
}

// ADC.TR3: watchdog threshold register 3
func (o *ADC_Type) SetTR3_HT3(value uint32) {
	volatile.StoreUint32(&o.TR3.Reg, volatile.LoadUint32(&o.TR3.Reg)&^(0xff0000)|value<<16)
}
func (o *ADC_Type) GetTR3_HT3() uint32 {
	return (volatile.LoadUint32(&o.TR3.Reg) & 0xff0000) >> 16
}
func (o *ADC_Type) SetTR3_LT3(value uint32) {
	volatile.StoreUint32(&o.TR3.Reg, volatile.LoadUint32(&o.TR3.Reg)&^(0xff)|value)
}
func (o *ADC_Type) GetTR3_LT3() uint32 {
	return volatile.LoadUint32(&o.TR3.Reg) & 0xff
}

// ADC.SQR1: regular sequence register 1
func (o *ADC_Type) SetSQR1_SQ4(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x1f000000)|value<<24)
}
func (o *ADC_Type) GetSQR1_SQ4() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x1f000000) >> 24
}
func (o *ADC_Type) SetSQR1_SQ3(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x7c0000)|value<<18)
}
func (o *ADC_Type) GetSQR1_SQ3() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x7c0000) >> 18
}
func (o *ADC_Type) SetSQR1_SQ2(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x1f000)|value<<12)
}
func (o *ADC_Type) GetSQR1_SQ2() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x1f000) >> 12
}
func (o *ADC_Type) SetSQR1_SQ1(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x7c0)|value<<6)
}
func (o *ADC_Type) GetSQR1_SQ1() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x7c0) >> 6
}
func (o *ADC_Type) SetSQR1_L(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetSQR1_L() uint32 {
	return volatile.LoadUint32(&o.SQR1.Reg) & 0xf
}

// ADC.SQR2: regular sequence register 2
func (o *ADC_Type) SetSQR2_SQ9(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x1f000000)|value<<24)
}
func (o *ADC_Type) GetSQR2_SQ9() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x1f000000) >> 24
}
func (o *ADC_Type) SetSQR2_SQ8(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x7c0000)|value<<18)
}
func (o *ADC_Type) GetSQR2_SQ8() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x7c0000) >> 18
}
func (o *ADC_Type) SetSQR2_SQ7(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x1f000)|value<<12)
}
func (o *ADC_Type) GetSQR2_SQ7() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x1f000) >> 12
}
func (o *ADC_Type) SetSQR2_SQ6(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x7c0)|value<<6)
}
func (o *ADC_Type) GetSQR2_SQ6() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x7c0) >> 6
}
func (o *ADC_Type) SetSQR2_SQ5(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR2_SQ5() uint32 {
	return volatile.LoadUint32(&o.SQR2.Reg) & 0x1f
}

// ADC.SQR3: regular sequence register 3
func (o *ADC_Type) SetSQR3_SQ14(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x1f000000)|value<<24)
}
func (o *ADC_Type) GetSQR3_SQ14() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x1f000000) >> 24
}
func (o *ADC_Type) SetSQR3_SQ13(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x7c0000)|value<<18)
}
func (o *ADC_Type) GetSQR3_SQ13() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x7c0000) >> 18
}
func (o *ADC_Type) SetSQR3_SQ12(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x1f000)|value<<12)
}
func (o *ADC_Type) GetSQR3_SQ12() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x1f000) >> 12
}
func (o *ADC_Type) SetSQR3_SQ11(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x7c0)|value<<6)
}
func (o *ADC_Type) GetSQR3_SQ11() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x7c0) >> 6
}
func (o *ADC_Type) SetSQR3_SQ10(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR3_SQ10() uint32 {
	return volatile.LoadUint32(&o.SQR3.Reg) & 0x1f
}

// ADC.SQR4: regular sequence register 4
func (o *ADC_Type) SetSQR4_SQ16(value uint32) {
	volatile.StoreUint32(&o.SQR4.Reg, volatile.LoadUint32(&o.SQR4.Reg)&^(0x7c0)|value<<6)
}
func (o *ADC_Type) GetSQR4_SQ16() uint32 {
	return (volatile.LoadUint32(&o.SQR4.Reg) & 0x7c0) >> 6
}
func (o *ADC_Type) SetSQR4_SQ15(value uint32) {
	volatile.StoreUint32(&o.SQR4.Reg, volatile.LoadUint32(&o.SQR4.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR4_SQ15() uint32 {
	return volatile.LoadUint32(&o.SQR4.Reg) & 0x1f
}

// ADC.DR: regular Data Register
func (o *ADC_Type) SetDR_RDATA(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetDR_RDATA() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xffff
}

// ADC.JSQR: injected sequence register
func (o *ADC_Type) SetJSQR_JSQ4(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0xf8000000)|value<<27)
}
func (o *ADC_Type) GetJSQR_JSQ4() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0xf8000000) >> 27
}
func (o *ADC_Type) SetJSQR_JSQ3(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x3e00000)|value<<21)
}
func (o *ADC_Type) GetJSQR_JSQ3() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x3e00000) >> 21
}
func (o *ADC_Type) SetJSQR_JSQ2(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0xf8000)|value<<15)
}
func (o *ADC_Type) GetJSQR_JSQ2() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0xf8000) >> 15
}
func (o *ADC_Type) SetJSQR_JSQ1(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x3e00)|value<<9)
}
func (o *ADC_Type) GetJSQR_JSQ1() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x3e00) >> 9
}
func (o *ADC_Type) SetJSQR_JEXTEN(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x180)|value<<7)
}
func (o *ADC_Type) GetJSQR_JEXTEN() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x180) >> 7
}
func (o *ADC_Type) SetJSQR_JEXTSEL(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x7c)|value<<2)
}
func (o *ADC_Type) GetJSQR_JEXTSEL() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x7c) >> 2
}
func (o *ADC_Type) SetJSQR_JL(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x3)|value)
}
func (o *ADC_Type) GetJSQR_JL() uint32 {
	return volatile.LoadUint32(&o.JSQR.Reg) & 0x3
}

// ADC.OFR1: offset register 1
func (o *ADC_Type) SetOFR1_OFFSET1_EN(value uint32) {
	volatile.StoreUint32(&o.OFR1.Reg, volatile.LoadUint32(&o.OFR1.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetOFR1_OFFSET1_EN() uint32 {
	return (volatile.LoadUint32(&o.OFR1.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetOFR1_OFFSET1_CH(value uint32) {
	volatile.StoreUint32(&o.OFR1.Reg, volatile.LoadUint32(&o.OFR1.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetOFR1_OFFSET1_CH() uint32 {
	return (volatile.LoadUint32(&o.OFR1.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetOFR1_SATEN(value uint32) {
	volatile.StoreUint32(&o.OFR1.Reg, volatile.LoadUint32(&o.OFR1.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetOFR1_SATEN() uint32 {
	return (volatile.LoadUint32(&o.OFR1.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetOFR1_OFFSETPOS(value uint32) {
	volatile.StoreUint32(&o.OFR1.Reg, volatile.LoadUint32(&o.OFR1.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetOFR1_OFFSETPOS() uint32 {
	return (volatile.LoadUint32(&o.OFR1.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetOFR1_OFFSET1(value uint32) {
	volatile.StoreUint32(&o.OFR1.Reg, volatile.LoadUint32(&o.OFR1.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetOFR1_OFFSET1() uint32 {
	return volatile.LoadUint32(&o.OFR1.Reg) & 0xfff
}

// ADC.OFR2: offset register 2
func (o *ADC_Type) SetOFR2_OFFSET2_EN(value uint32) {
	volatile.StoreUint32(&o.OFR2.Reg, volatile.LoadUint32(&o.OFR2.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetOFR2_OFFSET2_EN() uint32 {
	return (volatile.LoadUint32(&o.OFR2.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetOFR2_OFFSET2_CH(value uint32) {
	volatile.StoreUint32(&o.OFR2.Reg, volatile.LoadUint32(&o.OFR2.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetOFR2_OFFSET2_CH() uint32 {
	return (volatile.LoadUint32(&o.OFR2.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetOFR2_SATEN(value uint32) {
	volatile.StoreUint32(&o.OFR2.Reg, volatile.LoadUint32(&o.OFR2.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetOFR2_SATEN() uint32 {
	return (volatile.LoadUint32(&o.OFR2.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetOFR2_OFFSETPOS(value uint32) {
	volatile.StoreUint32(&o.OFR2.Reg, volatile.LoadUint32(&o.OFR2.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetOFR2_OFFSETPOS() uint32 {
	return (volatile.LoadUint32(&o.OFR2.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetOFR2_OFFSET2(value uint32) {
	volatile.StoreUint32(&o.OFR2.Reg, volatile.LoadUint32(&o.OFR2.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetOFR2_OFFSET2() uint32 {
	return volatile.LoadUint32(&o.OFR2.Reg) & 0xfff
}

// ADC.OFR3: offset register 3
func (o *ADC_Type) SetOFR3_OFFSET3_EN(value uint32) {
	volatile.StoreUint32(&o.OFR3.Reg, volatile.LoadUint32(&o.OFR3.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetOFR3_OFFSET3_EN() uint32 {
	return (volatile.LoadUint32(&o.OFR3.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetOFR3_OFFSET3_CH(value uint32) {
	volatile.StoreUint32(&o.OFR3.Reg, volatile.LoadUint32(&o.OFR3.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetOFR3_OFFSET3_CH() uint32 {
	return (volatile.LoadUint32(&o.OFR3.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetOFR3_SATEN(value uint32) {
	volatile.StoreUint32(&o.OFR3.Reg, volatile.LoadUint32(&o.OFR3.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetOFR3_SATEN() uint32 {
	return (volatile.LoadUint32(&o.OFR3.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetOFR3_OFFSETPOS(value uint32) {
	volatile.StoreUint32(&o.OFR3.Reg, volatile.LoadUint32(&o.OFR3.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetOFR3_OFFSETPOS() uint32 {
	return (volatile.LoadUint32(&o.OFR3.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetOFR3_OFFSET3(value uint32) {
	volatile.StoreUint32(&o.OFR3.Reg, volatile.LoadUint32(&o.OFR3.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetOFR3_OFFSET3() uint32 {
	return volatile.LoadUint32(&o.OFR3.Reg) & 0xfff
}

// ADC.OFR4: offset register 4
func (o *ADC_Type) SetOFR4_OFFSET4_EN(value uint32) {
	volatile.StoreUint32(&o.OFR4.Reg, volatile.LoadUint32(&o.OFR4.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetOFR4_OFFSET4_EN() uint32 {
	return (volatile.LoadUint32(&o.OFR4.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetOFR4_OFFSET4_CH(value uint32) {
	volatile.StoreUint32(&o.OFR4.Reg, volatile.LoadUint32(&o.OFR4.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetOFR4_OFFSET4_CH() uint32 {
	return (volatile.LoadUint32(&o.OFR4.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetOFR4_SATEN(value uint32) {
	volatile.StoreUint32(&o.OFR4.Reg, volatile.LoadUint32(&o.OFR4.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetOFR4_SATEN() uint32 {
	return (volatile.LoadUint32(&o.OFR4.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetOFR4_OFFSETPOS(value uint32) {
	volatile.StoreUint32(&o.OFR4.Reg, volatile.LoadUint32(&o.OFR4.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetOFR4_OFFSETPOS() uint32 {
	return (volatile.LoadUint32(&o.OFR4.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetOFR4_OFFSET4(value uint32) {
	volatile.StoreUint32(&o.OFR4.Reg, volatile.LoadUint32(&o.OFR4.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetOFR4_OFFSET4() uint32 {
	return volatile.LoadUint32(&o.OFR4.Reg) & 0xfff
}

// ADC.JDR1: injected data register 1
func (o *ADC_Type) SetJDR1_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDR1.Reg, volatile.LoadUint32(&o.JDR1.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR1_JDATA() uint32 {
	return volatile.LoadUint32(&o.JDR1.Reg) & 0xffff
}

// ADC.JDR2: injected data register 2
func (o *ADC_Type) SetJDR2_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDR2.Reg, volatile.LoadUint32(&o.JDR2.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR2_JDATA() uint32 {
	return volatile.LoadUint32(&o.JDR2.Reg) & 0xffff
}

// ADC.JDR3: injected data register 3
func (o *ADC_Type) SetJDR3_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDR3.Reg, volatile.LoadUint32(&o.JDR3.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR3_JDATA() uint32 {
	return volatile.LoadUint32(&o.JDR3.Reg) & 0xffff
}

// ADC.JDR4: injected data register 4
func (o *ADC_Type) SetJDR4_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDR4.Reg, volatile.LoadUint32(&o.JDR4.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR4_JDATA() uint32 {
	return volatile.LoadUint32(&o.JDR4.Reg) & 0xffff
}

// ADC.AWD2CR: Analog Watchdog 2 Configuration Register
func (o *ADC_Type) SetAWD2CR_AWD2CH0(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH0() uint32 {
	return volatile.LoadUint32(&o.AWD2CR.Reg) & 0x1
}
func (o *ADC_Type) SetAWD2CR_AWD2CH1(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH1() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetAWD2CR_AWD2CH2(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH2() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetAWD2CR_AWD2CH3(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH3() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetAWD2CR_AWD2CH4(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH4() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetAWD2CR_AWD2CH5(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH5() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetAWD2CR_AWD2CH6(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH6() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetAWD2CR_AWD2CH7(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH7() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetAWD2CR_AWD2CH8(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH8() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetAWD2CR_AWD2CH9(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH9() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetAWD2CR_AWD2CH10(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH10() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetAWD2CR_AWD2CH11(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH11() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetAWD2CR_AWD2CH12(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH12() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetAWD2CR_AWD2CH13(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH13() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetAWD2CR_AWD2CH14(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH14() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetAWD2CR_AWD2CH15(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH15() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetAWD2CR_AWD2CH16(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH16() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetAWD2CR_AWD2CH17(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x20000)|value<<17)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH17() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x20000) >> 17
}
func (o *ADC_Type) SetAWD2CR_AWD2CH18(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x40000)|value<<18)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH18() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x40000) >> 18
}

// ADC.AWD3CR: Analog Watchdog 3 Configuration Register
func (o *ADC_Type) SetAWD3CR_AWD3CH0(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH0() uint32 {
	return volatile.LoadUint32(&o.AWD3CR.Reg) & 0x1
}
func (o *ADC_Type) SetAWD3CR_AWD3CH1(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH1() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetAWD3CR_AWD3CH2(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH2() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetAWD3CR_AWD3CH3(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH3() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetAWD3CR_AWD3CH4(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH4() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetAWD3CR_AWD3CH5(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH5() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetAWD3CR_AWD3CH6(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH6() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetAWD3CR_AWD3CH7(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH7() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetAWD3CR_AWD3CH8(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH8() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetAWD3CR_AWD3CH9(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH9() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetAWD3CR_AWD3CH10(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH10() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetAWD3CR_AWD3CH11(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH11() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetAWD3CR_AWD3CH12(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH12() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetAWD3CR_AWD3CH13(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH13() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetAWD3CR_AWD3CH14(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH14() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetAWD3CR_AWD3CH15(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH15() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetAWD3CR_AWD3CH16(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH16() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetAWD3CR_AWD3CH17(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x20000)|value<<17)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH17() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x20000) >> 17
}
func (o *ADC_Type) SetAWD3CR_AWD3CH18(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x40000)|value<<18)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH18() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x40000) >> 18
}

// ADC.DIFSEL: Differential Mode Selection Register 2
func (o *ADC_Type) SetDIFSEL_DIFSEL_0(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL_0() uint32 {
	return volatile.LoadUint32(&o.DIFSEL.Reg) & 0x1
}
func (o *ADC_Type) SetDIFSEL_DIFSEL_1(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL_1() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetDIFSEL_DIFSEL_2(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL_2() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetDIFSEL_DIFSEL_3(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL_3() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetDIFSEL_DIFSEL_4(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL_4() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetDIFSEL_DIFSEL_5(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL_5() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetDIFSEL_DIFSEL_6(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL_6() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetDIFSEL_DIFSEL_7(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL_7() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetDIFSEL_DIFSEL_8(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL_8() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetDIFSEL_DIFSEL_9(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL_9() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetDIFSEL_DIFSEL_10(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL_10() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetDIFSEL_DIFSEL_11(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL_11() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetDIFSEL_DIFSEL_12(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL_12() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetDIFSEL_DIFSEL_13(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL_13() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetDIFSEL_DIFSEL_14(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL_14() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetDIFSEL_DIFSEL_15(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL_15() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetDIFSEL_DIFSEL_16(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL_16() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetDIFSEL_DIFSEL_17(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x20000)|value<<17)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL_17() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x20000) >> 17
}
func (o *ADC_Type) SetDIFSEL_DIFSEL_18(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x40000)|value<<18)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL_18() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x40000) >> 18
}

// ADC.CALFACT: Calibration Factors
func (o *ADC_Type) SetCALFACT_CALFACT_D(value uint32) {
	volatile.StoreUint32(&o.CALFACT.Reg, volatile.LoadUint32(&o.CALFACT.Reg)&^(0x7f0000)|value<<16)
}
func (o *ADC_Type) GetCALFACT_CALFACT_D() uint32 {
	return (volatile.LoadUint32(&o.CALFACT.Reg) & 0x7f0000) >> 16
}
func (o *ADC_Type) SetCALFACT_CALFACT_S(value uint32) {
	volatile.StoreUint32(&o.CALFACT.Reg, volatile.LoadUint32(&o.CALFACT.Reg)&^(0x7f)|value)
}
func (o *ADC_Type) GetCALFACT_CALFACT_S() uint32 {
	return volatile.LoadUint32(&o.CALFACT.Reg) & 0x7f
}

// ADC.GCOMP: Gain compensation Register
func (o *ADC_Type) SetGCOMP_GCOMPCOEFF(value uint32) {
	volatile.StoreUint32(&o.GCOMP.Reg, volatile.LoadUint32(&o.GCOMP.Reg)&^(0x3fff)|value)
}
func (o *ADC_Type) GetGCOMP_GCOMPCOEFF() uint32 {
	return volatile.LoadUint32(&o.GCOMP.Reg) & 0x3fff
}

// Filter Math Accelerator
type FMAC_Type struct {
	X1BUFCFG volatile.Register32 // 0x0
	X2BUFCFG volatile.Register32 // 0x4
	YBUFCFG  volatile.Register32 // 0x8
	PARAM    volatile.Register32 // 0xC
	CR       volatile.Register32 // 0x10
	SR       volatile.Register32 // 0x14
	WDATA    volatile.Register32 // 0x18
	RDATA    volatile.Register32 // 0x1C
}

// FMAC.X1BUFCFG: FMAC X1 Buffer Configuration register
func (o *FMAC_Type) SetX1BUFCFG_X1_BASE(value uint32) {
	volatile.StoreUint32(&o.X1BUFCFG.Reg, volatile.LoadUint32(&o.X1BUFCFG.Reg)&^(0xff)|value)
}
func (o *FMAC_Type) GetX1BUFCFG_X1_BASE() uint32 {
	return volatile.LoadUint32(&o.X1BUFCFG.Reg) & 0xff
}
func (o *FMAC_Type) SetX1BUFCFG_X1_BUF_SIZE(value uint32) {
	volatile.StoreUint32(&o.X1BUFCFG.Reg, volatile.LoadUint32(&o.X1BUFCFG.Reg)&^(0xff00)|value<<8)
}
func (o *FMAC_Type) GetX1BUFCFG_X1_BUF_SIZE() uint32 {
	return (volatile.LoadUint32(&o.X1BUFCFG.Reg) & 0xff00) >> 8
}
func (o *FMAC_Type) SetX1BUFCFG_FULL_WM(value uint32) {
	volatile.StoreUint32(&o.X1BUFCFG.Reg, volatile.LoadUint32(&o.X1BUFCFG.Reg)&^(0x3000000)|value<<24)
}
func (o *FMAC_Type) GetX1BUFCFG_FULL_WM() uint32 {
	return (volatile.LoadUint32(&o.X1BUFCFG.Reg) & 0x3000000) >> 24
}

// FMAC.X2BUFCFG: FMAC X2 Buffer Configuration register
func (o *FMAC_Type) SetX2BUFCFG_X2_BASE(value uint32) {
	volatile.StoreUint32(&o.X2BUFCFG.Reg, volatile.LoadUint32(&o.X2BUFCFG.Reg)&^(0xff)|value)
}
func (o *FMAC_Type) GetX2BUFCFG_X2_BASE() uint32 {
	return volatile.LoadUint32(&o.X2BUFCFG.Reg) & 0xff
}
func (o *FMAC_Type) SetX2BUFCFG_X2_BUF_SIZE(value uint32) {
	volatile.StoreUint32(&o.X2BUFCFG.Reg, volatile.LoadUint32(&o.X2BUFCFG.Reg)&^(0xff00)|value<<8)
}
func (o *FMAC_Type) GetX2BUFCFG_X2_BUF_SIZE() uint32 {
	return (volatile.LoadUint32(&o.X2BUFCFG.Reg) & 0xff00) >> 8
}

// FMAC.YBUFCFG: FMAC Y Buffer Configuration register
func (o *FMAC_Type) SetYBUFCFG_Y_BASE(value uint32) {
	volatile.StoreUint32(&o.YBUFCFG.Reg, volatile.LoadUint32(&o.YBUFCFG.Reg)&^(0xff)|value)
}
func (o *FMAC_Type) GetYBUFCFG_Y_BASE() uint32 {
	return volatile.LoadUint32(&o.YBUFCFG.Reg) & 0xff
}
func (o *FMAC_Type) SetYBUFCFG_Y_BUF_SIZE(value uint32) {
	volatile.StoreUint32(&o.YBUFCFG.Reg, volatile.LoadUint32(&o.YBUFCFG.Reg)&^(0xff00)|value<<8)
}
func (o *FMAC_Type) GetYBUFCFG_Y_BUF_SIZE() uint32 {
	return (volatile.LoadUint32(&o.YBUFCFG.Reg) & 0xff00) >> 8
}
func (o *FMAC_Type) SetYBUFCFG_EMPTY_WM(value uint32) {
	volatile.StoreUint32(&o.YBUFCFG.Reg, volatile.LoadUint32(&o.YBUFCFG.Reg)&^(0x3000000)|value<<24)
}
func (o *FMAC_Type) GetYBUFCFG_EMPTY_WM() uint32 {
	return (volatile.LoadUint32(&o.YBUFCFG.Reg) & 0x3000000) >> 24
}

// FMAC.PARAM: FMAC Parameter register
func (o *FMAC_Type) SetPARAM_START(value uint32) {
	volatile.StoreUint32(&o.PARAM.Reg, volatile.LoadUint32(&o.PARAM.Reg)&^(0x80000000)|value<<31)
}
func (o *FMAC_Type) GetPARAM_START() uint32 {
	return (volatile.LoadUint32(&o.PARAM.Reg) & 0x80000000) >> 31
}
func (o *FMAC_Type) SetPARAM_FUNC(value uint32) {
	volatile.StoreUint32(&o.PARAM.Reg, volatile.LoadUint32(&o.PARAM.Reg)&^(0x7f000000)|value<<24)
}
func (o *FMAC_Type) GetPARAM_FUNC() uint32 {
	return (volatile.LoadUint32(&o.PARAM.Reg) & 0x7f000000) >> 24
}
func (o *FMAC_Type) SetPARAM_R(value uint32) {
	volatile.StoreUint32(&o.PARAM.Reg, volatile.LoadUint32(&o.PARAM.Reg)&^(0xff0000)|value<<16)
}
func (o *FMAC_Type) GetPARAM_R() uint32 {
	return (volatile.LoadUint32(&o.PARAM.Reg) & 0xff0000) >> 16
}
func (o *FMAC_Type) SetPARAM_Q(value uint32) {
	volatile.StoreUint32(&o.PARAM.Reg, volatile.LoadUint32(&o.PARAM.Reg)&^(0xff00)|value<<8)
}
func (o *FMAC_Type) GetPARAM_Q() uint32 {
	return (volatile.LoadUint32(&o.PARAM.Reg) & 0xff00) >> 8
}
func (o *FMAC_Type) SetPARAM_P(value uint32) {
	volatile.StoreUint32(&o.PARAM.Reg, volatile.LoadUint32(&o.PARAM.Reg)&^(0xff)|value)
}
func (o *FMAC_Type) GetPARAM_P() uint32 {
	return volatile.LoadUint32(&o.PARAM.Reg) & 0xff
}

// FMAC.CR: FMAC Control register
func (o *FMAC_Type) SetCR_RESET(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *FMAC_Type) GetCR_RESET() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *FMAC_Type) SetCR_CLIPEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *FMAC_Type) GetCR_CLIPEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *FMAC_Type) SetCR_DMAWEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *FMAC_Type) GetCR_DMAWEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *FMAC_Type) SetCR_DMAREN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *FMAC_Type) GetCR_DMAREN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *FMAC_Type) SetCR_SATIEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *FMAC_Type) GetCR_SATIEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *FMAC_Type) SetCR_UNFLIEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *FMAC_Type) GetCR_UNFLIEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *FMAC_Type) SetCR_OVFLIEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *FMAC_Type) GetCR_OVFLIEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *FMAC_Type) SetCR_WIEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *FMAC_Type) GetCR_WIEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *FMAC_Type) SetCR_RIEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *FMAC_Type) GetCR_RIEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// FMAC.SR: FMAC Status register
func (o *FMAC_Type) SetSR_YEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *FMAC_Type) GetSR_YEMPTY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *FMAC_Type) SetSR_X1FULL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *FMAC_Type) GetSR_X1FULL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *FMAC_Type) SetSR_OVFL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *FMAC_Type) GetSR_OVFL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *FMAC_Type) SetSR_UNFL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *FMAC_Type) GetSR_UNFL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *FMAC_Type) SetSR_SAT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *FMAC_Type) GetSR_SAT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}

// FMAC.WDATA: FMAC Write Data register
func (o *FMAC_Type) SetWDATA(value uint32) {
	volatile.StoreUint32(&o.WDATA.Reg, volatile.LoadUint32(&o.WDATA.Reg)&^(0xffff)|value)
}
func (o *FMAC_Type) GetWDATA() uint32 {
	return volatile.LoadUint32(&o.WDATA.Reg) & 0xffff
}

// FMAC.RDATA: FMAC Read Data register
func (o *FMAC_Type) SetRDATA(value uint32) {
	volatile.StoreUint32(&o.RDATA.Reg, volatile.LoadUint32(&o.RDATA.Reg)&^(0xffff)|value)
}
func (o *FMAC_Type) GetRDATA() uint32 {
	return volatile.LoadUint32(&o.RDATA.Reg) & 0xffff
}

// CORDIC Co-processor
type CORDIC_Type struct {
	CSR   volatile.Register32 // 0x0
	WDATA volatile.Register32 // 0x4
	RDATA volatile.Register32 // 0x8
}

// CORDIC.CSR: CORDIC Control Status register
func (o *CORDIC_Type) SetCSR_FUNC(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0xf)|value)
}
func (o *CORDIC_Type) GetCSR_FUNC() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0xf
}
func (o *CORDIC_Type) SetCSR_PRECISION(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0xf0)|value<<4)
}
func (o *CORDIC_Type) GetCSR_PRECISION() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0xf0) >> 4
}
func (o *CORDIC_Type) SetCSR_SCALE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x700)|value<<8)
}
func (o *CORDIC_Type) GetCSR_SCALE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x700) >> 8
}
func (o *CORDIC_Type) SetCSR_IEN(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10000)|value<<16)
}
func (o *CORDIC_Type) GetCSR_IEN() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10000) >> 16
}
func (o *CORDIC_Type) SetCSR_DMAREN(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20000)|value<<17)
}
func (o *CORDIC_Type) GetCSR_DMAREN() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20000) >> 17
}
func (o *CORDIC_Type) SetCSR_DMAWEN(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40000)|value<<18)
}
func (o *CORDIC_Type) GetCSR_DMAWEN() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40000) >> 18
}
func (o *CORDIC_Type) SetCSR_NRES(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80000)|value<<19)
}
func (o *CORDIC_Type) GetCSR_NRES() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80000) >> 19
}
func (o *CORDIC_Type) SetCSR_NARGS(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x100000)|value<<20)
}
func (o *CORDIC_Type) GetCSR_NARGS() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x100000) >> 20
}
func (o *CORDIC_Type) SetCSR_RESSIZE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x200000)|value<<21)
}
func (o *CORDIC_Type) GetCSR_RESSIZE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x200000) >> 21
}
func (o *CORDIC_Type) SetCSR_ARGSIZE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x400000)|value<<22)
}
func (o *CORDIC_Type) GetCSR_ARGSIZE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x400000) >> 22
}
func (o *CORDIC_Type) SetCSR_RRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *CORDIC_Type) GetCSR_RRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80000000) >> 31
}

// CORDIC.WDATA: CORDIC argument register
func (o *CORDIC_Type) SetWDATA(value uint32) {
	volatile.StoreUint32(&o.WDATA.Reg, value)
}
func (o *CORDIC_Type) GetWDATA() uint32 {
	return volatile.LoadUint32(&o.WDATA.Reg)
}

// CORDIC.RDATA: CORDIC result register
func (o *CORDIC_Type) SetRDATA(value uint32) {
	volatile.StoreUint32(&o.RDATA.Reg, value)
}
func (o *CORDIC_Type) GetRDATA() uint32 {
	return volatile.LoadUint32(&o.RDATA.Reg)
}

// Serial audio interface
type SAI_Type struct {
	_      [4]byte
	ACR1   volatile.Register32 // 0x4
	ACR2   volatile.Register32 // 0x8
	AFRCR  volatile.Register32 // 0xC
	ASLOTR volatile.Register32 // 0x10
	AIM    volatile.Register32 // 0x14
	ASR    volatile.Register32 // 0x18
	ACLRFR volatile.Register32 // 0x1C
	ADR    volatile.Register32 // 0x20
	BCR1   volatile.Register32 // 0x24
	BCR2   volatile.Register32 // 0x28
	BFRCR  volatile.Register32 // 0x2C
	BSLOTR volatile.Register32 // 0x30
	BIM    volatile.Register32 // 0x34
	BSR    volatile.Register32 // 0x38
	BCLRFR volatile.Register32 // 0x3C
	BDR    volatile.Register32 // 0x40
	PDMCR  volatile.Register32 // 0x44
	PDMDLY volatile.Register32 // 0x48
}

// SAI.ACR1: AConfiguration register 1
func (o *SAI_Type) SetACR1_MCKEN(value uint32) {
	volatile.StoreUint32(&o.ACR1.Reg, volatile.LoadUint32(&o.ACR1.Reg)&^(0x8000000)|value<<27)
}
func (o *SAI_Type) GetACR1_MCKEN() uint32 {
	return (volatile.LoadUint32(&o.ACR1.Reg) & 0x8000000) >> 27
}
func (o *SAI_Type) SetACR1_OSR(value uint32) {
	volatile.StoreUint32(&o.ACR1.Reg, volatile.LoadUint32(&o.ACR1.Reg)&^(0x4000000)|value<<26)
}
func (o *SAI_Type) GetACR1_OSR() uint32 {
	return (volatile.LoadUint32(&o.ACR1.Reg) & 0x4000000) >> 26
}
func (o *SAI_Type) SetACR1_MCJDIV(value uint32) {
	volatile.StoreUint32(&o.ACR1.Reg, volatile.LoadUint32(&o.ACR1.Reg)&^(0x3f00000)|value<<20)
}
func (o *SAI_Type) GetACR1_MCJDIV() uint32 {
	return (volatile.LoadUint32(&o.ACR1.Reg) & 0x3f00000) >> 20
}
func (o *SAI_Type) SetACR1_NODIV(value uint32) {
	volatile.StoreUint32(&o.ACR1.Reg, volatile.LoadUint32(&o.ACR1.Reg)&^(0x80000)|value<<19)
}
func (o *SAI_Type) GetACR1_NODIV() uint32 {
	return (volatile.LoadUint32(&o.ACR1.Reg) & 0x80000) >> 19
}
func (o *SAI_Type) SetACR1_DMAEN(value uint32) {
	volatile.StoreUint32(&o.ACR1.Reg, volatile.LoadUint32(&o.ACR1.Reg)&^(0x20000)|value<<17)
}
func (o *SAI_Type) GetACR1_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.ACR1.Reg) & 0x20000) >> 17
}
func (o *SAI_Type) SetACR1_SAIAEN(value uint32) {
	volatile.StoreUint32(&o.ACR1.Reg, volatile.LoadUint32(&o.ACR1.Reg)&^(0x10000)|value<<16)
}
func (o *SAI_Type) GetACR1_SAIAEN() uint32 {
	return (volatile.LoadUint32(&o.ACR1.Reg) & 0x10000) >> 16
}
func (o *SAI_Type) SetACR1_OutDri(value uint32) {
	volatile.StoreUint32(&o.ACR1.Reg, volatile.LoadUint32(&o.ACR1.Reg)&^(0x2000)|value<<13)
}
func (o *SAI_Type) GetACR1_OutDri() uint32 {
	return (volatile.LoadUint32(&o.ACR1.Reg) & 0x2000) >> 13
}
func (o *SAI_Type) SetACR1_MONO(value uint32) {
	volatile.StoreUint32(&o.ACR1.Reg, volatile.LoadUint32(&o.ACR1.Reg)&^(0x1000)|value<<12)
}
func (o *SAI_Type) GetACR1_MONO() uint32 {
	return (volatile.LoadUint32(&o.ACR1.Reg) & 0x1000) >> 12
}
func (o *SAI_Type) SetACR1_SYNCEN(value uint32) {
	volatile.StoreUint32(&o.ACR1.Reg, volatile.LoadUint32(&o.ACR1.Reg)&^(0xc00)|value<<10)
}
func (o *SAI_Type) GetACR1_SYNCEN() uint32 {
	return (volatile.LoadUint32(&o.ACR1.Reg) & 0xc00) >> 10
}
func (o *SAI_Type) SetACR1_CKSTR(value uint32) {
	volatile.StoreUint32(&o.ACR1.Reg, volatile.LoadUint32(&o.ACR1.Reg)&^(0x200)|value<<9)
}
func (o *SAI_Type) GetACR1_CKSTR() uint32 {
	return (volatile.LoadUint32(&o.ACR1.Reg) & 0x200) >> 9
}
func (o *SAI_Type) SetACR1_LSBFIRST(value uint32) {
	volatile.StoreUint32(&o.ACR1.Reg, volatile.LoadUint32(&o.ACR1.Reg)&^(0x100)|value<<8)
}
func (o *SAI_Type) GetACR1_LSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.ACR1.Reg) & 0x100) >> 8
}
func (o *SAI_Type) SetACR1_DS(value uint32) {
	volatile.StoreUint32(&o.ACR1.Reg, volatile.LoadUint32(&o.ACR1.Reg)&^(0xe0)|value<<5)
}
func (o *SAI_Type) GetACR1_DS() uint32 {
	return (volatile.LoadUint32(&o.ACR1.Reg) & 0xe0) >> 5
}
func (o *SAI_Type) SetACR1_PRTCFG(value uint32) {
	volatile.StoreUint32(&o.ACR1.Reg, volatile.LoadUint32(&o.ACR1.Reg)&^(0xc)|value<<2)
}
func (o *SAI_Type) GetACR1_PRTCFG() uint32 {
	return (volatile.LoadUint32(&o.ACR1.Reg) & 0xc) >> 2
}
func (o *SAI_Type) SetACR1_MODE(value uint32) {
	volatile.StoreUint32(&o.ACR1.Reg, volatile.LoadUint32(&o.ACR1.Reg)&^(0x3)|value)
}
func (o *SAI_Type) GetACR1_MODE() uint32 {
	return volatile.LoadUint32(&o.ACR1.Reg) & 0x3
}

// SAI.ACR2: AConfiguration register 2
func (o *SAI_Type) SetACR2_COMP(value uint32) {
	volatile.StoreUint32(&o.ACR2.Reg, volatile.LoadUint32(&o.ACR2.Reg)&^(0xc000)|value<<14)
}
func (o *SAI_Type) GetACR2_COMP() uint32 {
	return (volatile.LoadUint32(&o.ACR2.Reg) & 0xc000) >> 14
}
func (o *SAI_Type) SetACR2_CPL(value uint32) {
	volatile.StoreUint32(&o.ACR2.Reg, volatile.LoadUint32(&o.ACR2.Reg)&^(0x2000)|value<<13)
}
func (o *SAI_Type) GetACR2_CPL() uint32 {
	return (volatile.LoadUint32(&o.ACR2.Reg) & 0x2000) >> 13
}
func (o *SAI_Type) SetACR2_MUTECN(value uint32) {
	volatile.StoreUint32(&o.ACR2.Reg, volatile.LoadUint32(&o.ACR2.Reg)&^(0x1f80)|value<<7)
}
func (o *SAI_Type) GetACR2_MUTECN() uint32 {
	return (volatile.LoadUint32(&o.ACR2.Reg) & 0x1f80) >> 7
}
func (o *SAI_Type) SetACR2_MUTEVAL(value uint32) {
	volatile.StoreUint32(&o.ACR2.Reg, volatile.LoadUint32(&o.ACR2.Reg)&^(0x40)|value<<6)
}
func (o *SAI_Type) GetACR2_MUTEVAL() uint32 {
	return (volatile.LoadUint32(&o.ACR2.Reg) & 0x40) >> 6
}
func (o *SAI_Type) SetACR2_MUTE(value uint32) {
	volatile.StoreUint32(&o.ACR2.Reg, volatile.LoadUint32(&o.ACR2.Reg)&^(0x20)|value<<5)
}
func (o *SAI_Type) GetACR2_MUTE() uint32 {
	return (volatile.LoadUint32(&o.ACR2.Reg) & 0x20) >> 5
}
func (o *SAI_Type) SetACR2_TRIS(value uint32) {
	volatile.StoreUint32(&o.ACR2.Reg, volatile.LoadUint32(&o.ACR2.Reg)&^(0x10)|value<<4)
}
func (o *SAI_Type) GetACR2_TRIS() uint32 {
	return (volatile.LoadUint32(&o.ACR2.Reg) & 0x10) >> 4
}
func (o *SAI_Type) SetACR2_FFLUS(value uint32) {
	volatile.StoreUint32(&o.ACR2.Reg, volatile.LoadUint32(&o.ACR2.Reg)&^(0x8)|value<<3)
}
func (o *SAI_Type) GetACR2_FFLUS() uint32 {
	return (volatile.LoadUint32(&o.ACR2.Reg) & 0x8) >> 3
}
func (o *SAI_Type) SetACR2_FTH(value uint32) {
	volatile.StoreUint32(&o.ACR2.Reg, volatile.LoadUint32(&o.ACR2.Reg)&^(0x7)|value)
}
func (o *SAI_Type) GetACR2_FTH() uint32 {
	return volatile.LoadUint32(&o.ACR2.Reg) & 0x7
}

// SAI.AFRCR: AFRCR
func (o *SAI_Type) SetAFRCR_FSOFF(value uint32) {
	volatile.StoreUint32(&o.AFRCR.Reg, volatile.LoadUint32(&o.AFRCR.Reg)&^(0x40000)|value<<18)
}
func (o *SAI_Type) GetAFRCR_FSOFF() uint32 {
	return (volatile.LoadUint32(&o.AFRCR.Reg) & 0x40000) >> 18
}
func (o *SAI_Type) SetAFRCR_FSPOL(value uint32) {
	volatile.StoreUint32(&o.AFRCR.Reg, volatile.LoadUint32(&o.AFRCR.Reg)&^(0x20000)|value<<17)
}
func (o *SAI_Type) GetAFRCR_FSPOL() uint32 {
	return (volatile.LoadUint32(&o.AFRCR.Reg) & 0x20000) >> 17
}
func (o *SAI_Type) SetAFRCR_FSDEF(value uint32) {
	volatile.StoreUint32(&o.AFRCR.Reg, volatile.LoadUint32(&o.AFRCR.Reg)&^(0x10000)|value<<16)
}
func (o *SAI_Type) GetAFRCR_FSDEF() uint32 {
	return (volatile.LoadUint32(&o.AFRCR.Reg) & 0x10000) >> 16
}
func (o *SAI_Type) SetAFRCR_FSALL(value uint32) {
	volatile.StoreUint32(&o.AFRCR.Reg, volatile.LoadUint32(&o.AFRCR.Reg)&^(0x7f00)|value<<8)
}
func (o *SAI_Type) GetAFRCR_FSALL() uint32 {
	return (volatile.LoadUint32(&o.AFRCR.Reg) & 0x7f00) >> 8
}
func (o *SAI_Type) SetAFRCR_FRL(value uint32) {
	volatile.StoreUint32(&o.AFRCR.Reg, volatile.LoadUint32(&o.AFRCR.Reg)&^(0xff)|value)
}
func (o *SAI_Type) GetAFRCR_FRL() uint32 {
	return volatile.LoadUint32(&o.AFRCR.Reg) & 0xff
}

// SAI.ASLOTR: ASlot register
func (o *SAI_Type) SetASLOTR_SLOTEN(value uint32) {
	volatile.StoreUint32(&o.ASLOTR.Reg, volatile.LoadUint32(&o.ASLOTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SAI_Type) GetASLOTR_SLOTEN() uint32 {
	return (volatile.LoadUint32(&o.ASLOTR.Reg) & 0xffff0000) >> 16
}
func (o *SAI_Type) SetASLOTR_NBSLOT(value uint32) {
	volatile.StoreUint32(&o.ASLOTR.Reg, volatile.LoadUint32(&o.ASLOTR.Reg)&^(0xf00)|value<<8)
}
func (o *SAI_Type) GetASLOTR_NBSLOT() uint32 {
	return (volatile.LoadUint32(&o.ASLOTR.Reg) & 0xf00) >> 8
}
func (o *SAI_Type) SetASLOTR_SLOTSZ(value uint32) {
	volatile.StoreUint32(&o.ASLOTR.Reg, volatile.LoadUint32(&o.ASLOTR.Reg)&^(0xc0)|value<<6)
}
func (o *SAI_Type) GetASLOTR_SLOTSZ() uint32 {
	return (volatile.LoadUint32(&o.ASLOTR.Reg) & 0xc0) >> 6
}
func (o *SAI_Type) SetASLOTR_FBOFF(value uint32) {
	volatile.StoreUint32(&o.ASLOTR.Reg, volatile.LoadUint32(&o.ASLOTR.Reg)&^(0x1f)|value)
}
func (o *SAI_Type) GetASLOTR_FBOFF() uint32 {
	return volatile.LoadUint32(&o.ASLOTR.Reg) & 0x1f
}

// SAI.AIM: AInterrupt mask register2
func (o *SAI_Type) SetAIM_LFSDET(value uint32) {
	volatile.StoreUint32(&o.AIM.Reg, volatile.LoadUint32(&o.AIM.Reg)&^(0x40)|value<<6)
}
func (o *SAI_Type) GetAIM_LFSDET() uint32 {
	return (volatile.LoadUint32(&o.AIM.Reg) & 0x40) >> 6
}
func (o *SAI_Type) SetAIM_AFSDETIE(value uint32) {
	volatile.StoreUint32(&o.AIM.Reg, volatile.LoadUint32(&o.AIM.Reg)&^(0x20)|value<<5)
}
func (o *SAI_Type) GetAIM_AFSDETIE() uint32 {
	return (volatile.LoadUint32(&o.AIM.Reg) & 0x20) >> 5
}
func (o *SAI_Type) SetAIM_CNRDYIE(value uint32) {
	volatile.StoreUint32(&o.AIM.Reg, volatile.LoadUint32(&o.AIM.Reg)&^(0x10)|value<<4)
}
func (o *SAI_Type) GetAIM_CNRDYIE() uint32 {
	return (volatile.LoadUint32(&o.AIM.Reg) & 0x10) >> 4
}
func (o *SAI_Type) SetAIM_FREQIE(value uint32) {
	volatile.StoreUint32(&o.AIM.Reg, volatile.LoadUint32(&o.AIM.Reg)&^(0x8)|value<<3)
}
func (o *SAI_Type) GetAIM_FREQIE() uint32 {
	return (volatile.LoadUint32(&o.AIM.Reg) & 0x8) >> 3
}
func (o *SAI_Type) SetAIM_WCKCFG(value uint32) {
	volatile.StoreUint32(&o.AIM.Reg, volatile.LoadUint32(&o.AIM.Reg)&^(0x4)|value<<2)
}
func (o *SAI_Type) GetAIM_WCKCFG() uint32 {
	return (volatile.LoadUint32(&o.AIM.Reg) & 0x4) >> 2
}
func (o *SAI_Type) SetAIM_MUTEDET(value uint32) {
	volatile.StoreUint32(&o.AIM.Reg, volatile.LoadUint32(&o.AIM.Reg)&^(0x2)|value<<1)
}
func (o *SAI_Type) GetAIM_MUTEDET() uint32 {
	return (volatile.LoadUint32(&o.AIM.Reg) & 0x2) >> 1
}
func (o *SAI_Type) SetAIM_OVRUDRIE(value uint32) {
	volatile.StoreUint32(&o.AIM.Reg, volatile.LoadUint32(&o.AIM.Reg)&^(0x1)|value)
}
func (o *SAI_Type) GetAIM_OVRUDRIE() uint32 {
	return volatile.LoadUint32(&o.AIM.Reg) & 0x1
}

// SAI.ASR: AStatus register
func (o *SAI_Type) SetASR_FLVL(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x70000)|value<<16)
}
func (o *SAI_Type) GetASR_FLVL() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x70000) >> 16
}
func (o *SAI_Type) SetASR_LFSDET(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x40)|value<<6)
}
func (o *SAI_Type) GetASR_LFSDET() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x40) >> 6
}
func (o *SAI_Type) SetASR_AFSDET(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x20)|value<<5)
}
func (o *SAI_Type) GetASR_AFSDET() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x20) >> 5
}
func (o *SAI_Type) SetASR_CNRDY(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x10)|value<<4)
}
func (o *SAI_Type) GetASR_CNRDY() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x10) >> 4
}
func (o *SAI_Type) SetASR_FREQ(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x8)|value<<3)
}
func (o *SAI_Type) GetASR_FREQ() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x8) >> 3
}
func (o *SAI_Type) SetASR_WCKCFG(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x4)|value<<2)
}
func (o *SAI_Type) GetASR_WCKCFG() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x4) >> 2
}
func (o *SAI_Type) SetASR_MUTEDET(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x2)|value<<1)
}
func (o *SAI_Type) GetASR_MUTEDET() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x2) >> 1
}
func (o *SAI_Type) SetASR_OVRUDR(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x1)|value)
}
func (o *SAI_Type) GetASR_OVRUDR() uint32 {
	return volatile.LoadUint32(&o.ASR.Reg) & 0x1
}

// SAI.ACLRFR: AClear flag register
func (o *SAI_Type) SetACLRFR_LFSDET(value uint32) {
	volatile.StoreUint32(&o.ACLRFR.Reg, volatile.LoadUint32(&o.ACLRFR.Reg)&^(0x40)|value<<6)
}
func (o *SAI_Type) GetACLRFR_LFSDET() uint32 {
	return (volatile.LoadUint32(&o.ACLRFR.Reg) & 0x40) >> 6
}
func (o *SAI_Type) SetACLRFR_CAFSDET(value uint32) {
	volatile.StoreUint32(&o.ACLRFR.Reg, volatile.LoadUint32(&o.ACLRFR.Reg)&^(0x20)|value<<5)
}
func (o *SAI_Type) GetACLRFR_CAFSDET() uint32 {
	return (volatile.LoadUint32(&o.ACLRFR.Reg) & 0x20) >> 5
}
func (o *SAI_Type) SetACLRFR_CNRDY(value uint32) {
	volatile.StoreUint32(&o.ACLRFR.Reg, volatile.LoadUint32(&o.ACLRFR.Reg)&^(0x10)|value<<4)
}
func (o *SAI_Type) GetACLRFR_CNRDY() uint32 {
	return (volatile.LoadUint32(&o.ACLRFR.Reg) & 0x10) >> 4
}
func (o *SAI_Type) SetACLRFR_WCKCFG(value uint32) {
	volatile.StoreUint32(&o.ACLRFR.Reg, volatile.LoadUint32(&o.ACLRFR.Reg)&^(0x4)|value<<2)
}
func (o *SAI_Type) GetACLRFR_WCKCFG() uint32 {
	return (volatile.LoadUint32(&o.ACLRFR.Reg) & 0x4) >> 2
}
func (o *SAI_Type) SetACLRFR_MUTEDET(value uint32) {
	volatile.StoreUint32(&o.ACLRFR.Reg, volatile.LoadUint32(&o.ACLRFR.Reg)&^(0x2)|value<<1)
}
func (o *SAI_Type) GetACLRFR_MUTEDET() uint32 {
	return (volatile.LoadUint32(&o.ACLRFR.Reg) & 0x2) >> 1
}
func (o *SAI_Type) SetACLRFR_OVRUDR(value uint32) {
	volatile.StoreUint32(&o.ACLRFR.Reg, volatile.LoadUint32(&o.ACLRFR.Reg)&^(0x1)|value)
}
func (o *SAI_Type) GetACLRFR_OVRUDR() uint32 {
	return volatile.LoadUint32(&o.ACLRFR.Reg) & 0x1
}

// SAI.ADR: AData register
func (o *SAI_Type) SetADR(value uint32) {
	volatile.StoreUint32(&o.ADR.Reg, value)
}
func (o *SAI_Type) GetADR() uint32 {
	return volatile.LoadUint32(&o.ADR.Reg)
}

// SAI.BCR1: BConfiguration register 1
func (o *SAI_Type) SetBCR1_MCKEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x8000000)|value<<27)
}
func (o *SAI_Type) GetBCR1_MCKEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x8000000) >> 27
}
func (o *SAI_Type) SetBCR1_OSR(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x4000000)|value<<26)
}
func (o *SAI_Type) GetBCR1_OSR() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x4000000) >> 26
}
func (o *SAI_Type) SetBCR1_MCJDIV(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x3f00000)|value<<20)
}
func (o *SAI_Type) GetBCR1_MCJDIV() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x3f00000) >> 20
}
func (o *SAI_Type) SetBCR1_NODIV(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x80000)|value<<19)
}
func (o *SAI_Type) GetBCR1_NODIV() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x80000) >> 19
}
func (o *SAI_Type) SetBCR1_DMAEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x20000)|value<<17)
}
func (o *SAI_Type) GetBCR1_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x20000) >> 17
}
func (o *SAI_Type) SetBCR1_SAIBEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x10000)|value<<16)
}
func (o *SAI_Type) GetBCR1_SAIBEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x10000) >> 16
}
func (o *SAI_Type) SetBCR1_OutDri(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x2000)|value<<13)
}
func (o *SAI_Type) GetBCR1_OutDri() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x2000) >> 13
}
func (o *SAI_Type) SetBCR1_MONO(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x1000)|value<<12)
}
func (o *SAI_Type) GetBCR1_MONO() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x1000) >> 12
}
func (o *SAI_Type) SetBCR1_SYNCEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0xc00)|value<<10)
}
func (o *SAI_Type) GetBCR1_SYNCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0xc00) >> 10
}
func (o *SAI_Type) SetBCR1_CKSTR(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x200)|value<<9)
}
func (o *SAI_Type) GetBCR1_CKSTR() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x200) >> 9
}
func (o *SAI_Type) SetBCR1_LSBFIRST(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x100)|value<<8)
}
func (o *SAI_Type) GetBCR1_LSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x100) >> 8
}
func (o *SAI_Type) SetBCR1_DS(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0xe0)|value<<5)
}
func (o *SAI_Type) GetBCR1_DS() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0xe0) >> 5
}
func (o *SAI_Type) SetBCR1_PRTCFG(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0xc)|value<<2)
}
func (o *SAI_Type) GetBCR1_PRTCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0xc) >> 2
}
func (o *SAI_Type) SetBCR1_MODE(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x3)|value)
}
func (o *SAI_Type) GetBCR1_MODE() uint32 {
	return volatile.LoadUint32(&o.BCR1.Reg) & 0x3
}

// SAI.BCR2: BConfiguration register 2
func (o *SAI_Type) SetBCR2_COMP(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0xc000)|value<<14)
}
func (o *SAI_Type) GetBCR2_COMP() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0xc000) >> 14
}
func (o *SAI_Type) SetBCR2_CPL(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x2000)|value<<13)
}
func (o *SAI_Type) GetBCR2_CPL() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x2000) >> 13
}
func (o *SAI_Type) SetBCR2_MUTECN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x1f80)|value<<7)
}
func (o *SAI_Type) GetBCR2_MUTECN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x1f80) >> 7
}
func (o *SAI_Type) SetBCR2_MUTEVAL(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x40)|value<<6)
}
func (o *SAI_Type) GetBCR2_MUTEVAL() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x40) >> 6
}
func (o *SAI_Type) SetBCR2_MUTE(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x20)|value<<5)
}
func (o *SAI_Type) GetBCR2_MUTE() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x20) >> 5
}
func (o *SAI_Type) SetBCR2_TRIS(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x10)|value<<4)
}
func (o *SAI_Type) GetBCR2_TRIS() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x10) >> 4
}
func (o *SAI_Type) SetBCR2_FFLUS(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x8)|value<<3)
}
func (o *SAI_Type) GetBCR2_FFLUS() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x8) >> 3
}
func (o *SAI_Type) SetBCR2_FTH(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x7)|value)
}
func (o *SAI_Type) GetBCR2_FTH() uint32 {
	return volatile.LoadUint32(&o.BCR2.Reg) & 0x7
}

// SAI.BFRCR: BFRCR
func (o *SAI_Type) SetBFRCR_FSOFF(value uint32) {
	volatile.StoreUint32(&o.BFRCR.Reg, volatile.LoadUint32(&o.BFRCR.Reg)&^(0x40000)|value<<18)
}
func (o *SAI_Type) GetBFRCR_FSOFF() uint32 {
	return (volatile.LoadUint32(&o.BFRCR.Reg) & 0x40000) >> 18
}
func (o *SAI_Type) SetBFRCR_FSPOL(value uint32) {
	volatile.StoreUint32(&o.BFRCR.Reg, volatile.LoadUint32(&o.BFRCR.Reg)&^(0x20000)|value<<17)
}
func (o *SAI_Type) GetBFRCR_FSPOL() uint32 {
	return (volatile.LoadUint32(&o.BFRCR.Reg) & 0x20000) >> 17
}
func (o *SAI_Type) SetBFRCR_FSDEF(value uint32) {
	volatile.StoreUint32(&o.BFRCR.Reg, volatile.LoadUint32(&o.BFRCR.Reg)&^(0x10000)|value<<16)
}
func (o *SAI_Type) GetBFRCR_FSDEF() uint32 {
	return (volatile.LoadUint32(&o.BFRCR.Reg) & 0x10000) >> 16
}
func (o *SAI_Type) SetBFRCR_FSALL(value uint32) {
	volatile.StoreUint32(&o.BFRCR.Reg, volatile.LoadUint32(&o.BFRCR.Reg)&^(0x7f00)|value<<8)
}
func (o *SAI_Type) GetBFRCR_FSALL() uint32 {
	return (volatile.LoadUint32(&o.BFRCR.Reg) & 0x7f00) >> 8
}
func (o *SAI_Type) SetBFRCR_FRL(value uint32) {
	volatile.StoreUint32(&o.BFRCR.Reg, volatile.LoadUint32(&o.BFRCR.Reg)&^(0xff)|value)
}
func (o *SAI_Type) GetBFRCR_FRL() uint32 {
	return volatile.LoadUint32(&o.BFRCR.Reg) & 0xff
}

// SAI.BSLOTR: BSlot register
func (o *SAI_Type) SetBSLOTR_SLOTEN(value uint32) {
	volatile.StoreUint32(&o.BSLOTR.Reg, volatile.LoadUint32(&o.BSLOTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SAI_Type) GetBSLOTR_SLOTEN() uint32 {
	return (volatile.LoadUint32(&o.BSLOTR.Reg) & 0xffff0000) >> 16
}
func (o *SAI_Type) SetBSLOTR_NBSLOT(value uint32) {
	volatile.StoreUint32(&o.BSLOTR.Reg, volatile.LoadUint32(&o.BSLOTR.Reg)&^(0xf00)|value<<8)
}
func (o *SAI_Type) GetBSLOTR_NBSLOT() uint32 {
	return (volatile.LoadUint32(&o.BSLOTR.Reg) & 0xf00) >> 8
}
func (o *SAI_Type) SetBSLOTR_SLOTSZ(value uint32) {
	volatile.StoreUint32(&o.BSLOTR.Reg, volatile.LoadUint32(&o.BSLOTR.Reg)&^(0xc0)|value<<6)
}
func (o *SAI_Type) GetBSLOTR_SLOTSZ() uint32 {
	return (volatile.LoadUint32(&o.BSLOTR.Reg) & 0xc0) >> 6
}
func (o *SAI_Type) SetBSLOTR_FBOFF(value uint32) {
	volatile.StoreUint32(&o.BSLOTR.Reg, volatile.LoadUint32(&o.BSLOTR.Reg)&^(0x1f)|value)
}
func (o *SAI_Type) GetBSLOTR_FBOFF() uint32 {
	return volatile.LoadUint32(&o.BSLOTR.Reg) & 0x1f
}

// SAI.BIM: BInterrupt mask register2
func (o *SAI_Type) SetBIM_LFSDETIE(value uint32) {
	volatile.StoreUint32(&o.BIM.Reg, volatile.LoadUint32(&o.BIM.Reg)&^(0x40)|value<<6)
}
func (o *SAI_Type) GetBIM_LFSDETIE() uint32 {
	return (volatile.LoadUint32(&o.BIM.Reg) & 0x40) >> 6
}
func (o *SAI_Type) SetBIM_AFSDETIE(value uint32) {
	volatile.StoreUint32(&o.BIM.Reg, volatile.LoadUint32(&o.BIM.Reg)&^(0x20)|value<<5)
}
func (o *SAI_Type) GetBIM_AFSDETIE() uint32 {
	return (volatile.LoadUint32(&o.BIM.Reg) & 0x20) >> 5
}
func (o *SAI_Type) SetBIM_CNRDYIE(value uint32) {
	volatile.StoreUint32(&o.BIM.Reg, volatile.LoadUint32(&o.BIM.Reg)&^(0x10)|value<<4)
}
func (o *SAI_Type) GetBIM_CNRDYIE() uint32 {
	return (volatile.LoadUint32(&o.BIM.Reg) & 0x10) >> 4
}
func (o *SAI_Type) SetBIM_FREQIE(value uint32) {
	volatile.StoreUint32(&o.BIM.Reg, volatile.LoadUint32(&o.BIM.Reg)&^(0x8)|value<<3)
}
func (o *SAI_Type) GetBIM_FREQIE() uint32 {
	return (volatile.LoadUint32(&o.BIM.Reg) & 0x8) >> 3
}
func (o *SAI_Type) SetBIM_WCKCFG(value uint32) {
	volatile.StoreUint32(&o.BIM.Reg, volatile.LoadUint32(&o.BIM.Reg)&^(0x4)|value<<2)
}
func (o *SAI_Type) GetBIM_WCKCFG() uint32 {
	return (volatile.LoadUint32(&o.BIM.Reg) & 0x4) >> 2
}
func (o *SAI_Type) SetBIM_MUTEDET(value uint32) {
	volatile.StoreUint32(&o.BIM.Reg, volatile.LoadUint32(&o.BIM.Reg)&^(0x2)|value<<1)
}
func (o *SAI_Type) GetBIM_MUTEDET() uint32 {
	return (volatile.LoadUint32(&o.BIM.Reg) & 0x2) >> 1
}
func (o *SAI_Type) SetBIM_OVRUDRIE(value uint32) {
	volatile.StoreUint32(&o.BIM.Reg, volatile.LoadUint32(&o.BIM.Reg)&^(0x1)|value)
}
func (o *SAI_Type) GetBIM_OVRUDRIE() uint32 {
	return volatile.LoadUint32(&o.BIM.Reg) & 0x1
}

// SAI.BSR: BStatus register
func (o *SAI_Type) SetBSR_FLVL(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x70000)|value<<16)
}
func (o *SAI_Type) GetBSR_FLVL() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x70000) >> 16
}
func (o *SAI_Type) SetBSR_LFSDET(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x40)|value<<6)
}
func (o *SAI_Type) GetBSR_LFSDET() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x40) >> 6
}
func (o *SAI_Type) SetBSR_AFSDET(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x20)|value<<5)
}
func (o *SAI_Type) GetBSR_AFSDET() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x20) >> 5
}
func (o *SAI_Type) SetBSR_CNRDY(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x10)|value<<4)
}
func (o *SAI_Type) GetBSR_CNRDY() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x10) >> 4
}
func (o *SAI_Type) SetBSR_FREQ(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x8)|value<<3)
}
func (o *SAI_Type) GetBSR_FREQ() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x8) >> 3
}
func (o *SAI_Type) SetBSR_WCKCFG(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x4)|value<<2)
}
func (o *SAI_Type) GetBSR_WCKCFG() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x4) >> 2
}
func (o *SAI_Type) SetBSR_MUTEDET(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x2)|value<<1)
}
func (o *SAI_Type) GetBSR_MUTEDET() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x2) >> 1
}
func (o *SAI_Type) SetBSR_OVRUDR(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x1)|value)
}
func (o *SAI_Type) GetBSR_OVRUDR() uint32 {
	return volatile.LoadUint32(&o.BSR.Reg) & 0x1
}

// SAI.BCLRFR: BClear flag register
func (o *SAI_Type) SetBCLRFR_LFSDET(value uint32) {
	volatile.StoreUint32(&o.BCLRFR.Reg, volatile.LoadUint32(&o.BCLRFR.Reg)&^(0x40)|value<<6)
}
func (o *SAI_Type) GetBCLRFR_LFSDET() uint32 {
	return (volatile.LoadUint32(&o.BCLRFR.Reg) & 0x40) >> 6
}
func (o *SAI_Type) SetBCLRFR_CAFSDET(value uint32) {
	volatile.StoreUint32(&o.BCLRFR.Reg, volatile.LoadUint32(&o.BCLRFR.Reg)&^(0x20)|value<<5)
}
func (o *SAI_Type) GetBCLRFR_CAFSDET() uint32 {
	return (volatile.LoadUint32(&o.BCLRFR.Reg) & 0x20) >> 5
}
func (o *SAI_Type) SetBCLRFR_CNRDY(value uint32) {
	volatile.StoreUint32(&o.BCLRFR.Reg, volatile.LoadUint32(&o.BCLRFR.Reg)&^(0x10)|value<<4)
}
func (o *SAI_Type) GetBCLRFR_CNRDY() uint32 {
	return (volatile.LoadUint32(&o.BCLRFR.Reg) & 0x10) >> 4
}
func (o *SAI_Type) SetBCLRFR_WCKCFG(value uint32) {
	volatile.StoreUint32(&o.BCLRFR.Reg, volatile.LoadUint32(&o.BCLRFR.Reg)&^(0x4)|value<<2)
}
func (o *SAI_Type) GetBCLRFR_WCKCFG() uint32 {
	return (volatile.LoadUint32(&o.BCLRFR.Reg) & 0x4) >> 2
}
func (o *SAI_Type) SetBCLRFR_MUTEDET(value uint32) {
	volatile.StoreUint32(&o.BCLRFR.Reg, volatile.LoadUint32(&o.BCLRFR.Reg)&^(0x2)|value<<1)
}
func (o *SAI_Type) GetBCLRFR_MUTEDET() uint32 {
	return (volatile.LoadUint32(&o.BCLRFR.Reg) & 0x2) >> 1
}
func (o *SAI_Type) SetBCLRFR_OVRUDR(value uint32) {
	volatile.StoreUint32(&o.BCLRFR.Reg, volatile.LoadUint32(&o.BCLRFR.Reg)&^(0x1)|value)
}
func (o *SAI_Type) GetBCLRFR_OVRUDR() uint32 {
	return volatile.LoadUint32(&o.BCLRFR.Reg) & 0x1
}

// SAI.BDR: BData register
func (o *SAI_Type) SetBDR(value uint32) {
	volatile.StoreUint32(&o.BDR.Reg, value)
}
func (o *SAI_Type) GetBDR() uint32 {
	return volatile.LoadUint32(&o.BDR.Reg)
}

// SAI.PDMCR: PDM control register
func (o *SAI_Type) SetPDMCR_PDMEN(value uint32) {
	volatile.StoreUint32(&o.PDMCR.Reg, volatile.LoadUint32(&o.PDMCR.Reg)&^(0x1)|value)
}
func (o *SAI_Type) GetPDMCR_PDMEN() uint32 {
	return volatile.LoadUint32(&o.PDMCR.Reg) & 0x1
}
func (o *SAI_Type) SetPDMCR_MICNBR(value uint32) {
	volatile.StoreUint32(&o.PDMCR.Reg, volatile.LoadUint32(&o.PDMCR.Reg)&^(0x30)|value<<4)
}
func (o *SAI_Type) GetPDMCR_MICNBR() uint32 {
	return (volatile.LoadUint32(&o.PDMCR.Reg) & 0x30) >> 4
}
func (o *SAI_Type) SetPDMCR_CKEN1(value uint32) {
	volatile.StoreUint32(&o.PDMCR.Reg, volatile.LoadUint32(&o.PDMCR.Reg)&^(0x100)|value<<8)
}
func (o *SAI_Type) GetPDMCR_CKEN1() uint32 {
	return (volatile.LoadUint32(&o.PDMCR.Reg) & 0x100) >> 8
}
func (o *SAI_Type) SetPDMCR_CKEN2(value uint32) {
	volatile.StoreUint32(&o.PDMCR.Reg, volatile.LoadUint32(&o.PDMCR.Reg)&^(0x200)|value<<9)
}
func (o *SAI_Type) GetPDMCR_CKEN2() uint32 {
	return (volatile.LoadUint32(&o.PDMCR.Reg) & 0x200) >> 9
}
func (o *SAI_Type) SetPDMCR_CKEN3(value uint32) {
	volatile.StoreUint32(&o.PDMCR.Reg, volatile.LoadUint32(&o.PDMCR.Reg)&^(0x400)|value<<10)
}
func (o *SAI_Type) GetPDMCR_CKEN3() uint32 {
	return (volatile.LoadUint32(&o.PDMCR.Reg) & 0x400) >> 10
}
func (o *SAI_Type) SetPDMCR_CKEN4(value uint32) {
	volatile.StoreUint32(&o.PDMCR.Reg, volatile.LoadUint32(&o.PDMCR.Reg)&^(0x800)|value<<11)
}
func (o *SAI_Type) GetPDMCR_CKEN4() uint32 {
	return (volatile.LoadUint32(&o.PDMCR.Reg) & 0x800) >> 11
}

// SAI.PDMDLY: PDM delay register
func (o *SAI_Type) SetPDMDLY_DLYM1L(value uint32) {
	volatile.StoreUint32(&o.PDMDLY.Reg, volatile.LoadUint32(&o.PDMDLY.Reg)&^(0x7)|value)
}
func (o *SAI_Type) GetPDMDLY_DLYM1L() uint32 {
	return volatile.LoadUint32(&o.PDMDLY.Reg) & 0x7
}
func (o *SAI_Type) SetPDMDLY_DLYM1R(value uint32) {
	volatile.StoreUint32(&o.PDMDLY.Reg, volatile.LoadUint32(&o.PDMDLY.Reg)&^(0x70)|value<<4)
}
func (o *SAI_Type) GetPDMDLY_DLYM1R() uint32 {
	return (volatile.LoadUint32(&o.PDMDLY.Reg) & 0x70) >> 4
}
func (o *SAI_Type) SetPDMDLY_DLYM2L(value uint32) {
	volatile.StoreUint32(&o.PDMDLY.Reg, volatile.LoadUint32(&o.PDMDLY.Reg)&^(0x700)|value<<8)
}
func (o *SAI_Type) GetPDMDLY_DLYM2L() uint32 {
	return (volatile.LoadUint32(&o.PDMDLY.Reg) & 0x700) >> 8
}
func (o *SAI_Type) SetPDMDLY_DLYM2R(value uint32) {
	volatile.StoreUint32(&o.PDMDLY.Reg, volatile.LoadUint32(&o.PDMDLY.Reg)&^(0x7000)|value<<12)
}
func (o *SAI_Type) GetPDMDLY_DLYM2R() uint32 {
	return (volatile.LoadUint32(&o.PDMDLY.Reg) & 0x7000) >> 12
}
func (o *SAI_Type) SetPDMDLY_DLYM3L(value uint32) {
	volatile.StoreUint32(&o.PDMDLY.Reg, volatile.LoadUint32(&o.PDMDLY.Reg)&^(0x70000)|value<<16)
}
func (o *SAI_Type) GetPDMDLY_DLYM3L() uint32 {
	return (volatile.LoadUint32(&o.PDMDLY.Reg) & 0x70000) >> 16
}
func (o *SAI_Type) SetPDMDLY_DLYM3R(value uint32) {
	volatile.StoreUint32(&o.PDMDLY.Reg, volatile.LoadUint32(&o.PDMDLY.Reg)&^(0x700000)|value<<20)
}
func (o *SAI_Type) GetPDMDLY_DLYM3R() uint32 {
	return (volatile.LoadUint32(&o.PDMDLY.Reg) & 0x700000) >> 20
}
func (o *SAI_Type) SetPDMDLY_DLYM4L(value uint32) {
	volatile.StoreUint32(&o.PDMDLY.Reg, volatile.LoadUint32(&o.PDMDLY.Reg)&^(0x7000000)|value<<24)
}
func (o *SAI_Type) GetPDMDLY_DLYM4L() uint32 {
	return (volatile.LoadUint32(&o.PDMDLY.Reg) & 0x7000000) >> 24
}
func (o *SAI_Type) SetPDMDLY_DLYM4R(value uint32) {
	volatile.StoreUint32(&o.PDMDLY.Reg, volatile.LoadUint32(&o.PDMDLY.Reg)&^(0x70000000)|value<<28)
}
func (o *SAI_Type) GetPDMDLY_DLYM4R() uint32 {
	return (volatile.LoadUint32(&o.PDMDLY.Reg) & 0x70000000) >> 28
}

// Tamper and backup registers
type TAMP_Type struct {
	CR1    volatile.Register32 // 0x0
	CR2    volatile.Register32 // 0x4
	_      [4]byte
	FLTCR  volatile.Register32 // 0xC
	_      [28]byte
	IER    volatile.Register32 // 0x2C
	SR     volatile.Register32 // 0x30
	MISR   volatile.Register32 // 0x34
	_      [4]byte
	SCR    volatile.Register32 // 0x3C
	_      [192]byte
	BKP0R  volatile.Register32 // 0x100
	BKP1R  volatile.Register32 // 0x104
	BKP2R  volatile.Register32 // 0x108
	BKP3R  volatile.Register32 // 0x10C
	BKP4R  volatile.Register32 // 0x110
	BKP5R  volatile.Register32 // 0x114
	BKP6R  volatile.Register32 // 0x118
	BKP7R  volatile.Register32 // 0x11C
	BKP8R  volatile.Register32 // 0x120
	BKP9R  volatile.Register32 // 0x124
	BKP10R volatile.Register32 // 0x128
	BKP11R volatile.Register32 // 0x12C
	BKP12R volatile.Register32 // 0x130
	BKP13R volatile.Register32 // 0x134
	BKP14R volatile.Register32 // 0x138
	BKP15R volatile.Register32 // 0x13C
	BKP16R volatile.Register32 // 0x140
	BKP17R volatile.Register32 // 0x144
	BKP18R volatile.Register32 // 0x148
	BKP19R volatile.Register32 // 0x14C
	BKP20R volatile.Register32 // 0x150
	BKP21R volatile.Register32 // 0x154
	BKP22R volatile.Register32 // 0x158
	BKP23R volatile.Register32 // 0x15C
	BKP24R volatile.Register32 // 0x160
	BKP25R volatile.Register32 // 0x164
	BKP26R volatile.Register32 // 0x168
	BKP27R volatile.Register32 // 0x16C
	BKP28R volatile.Register32 // 0x170
	BKP29R volatile.Register32 // 0x174
	BKP30R volatile.Register32 // 0x178
	BKP31R volatile.Register32 // 0x17C
}

// TAMP.CR1: control register 1
func (o *TAMP_Type) SetCR1_TAMP1E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *TAMP_Type) GetCR1_TAMP1E() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *TAMP_Type) SetCR1_TAMP2E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *TAMP_Type) GetCR1_TAMP2E() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *TAMP_Type) SetCR1_TAMP3E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *TAMP_Type) GetCR1_TAMP3E() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *TAMP_Type) SetCR1_ITAMP3E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40000)|value<<18)
}
func (o *TAMP_Type) GetCR1_ITAMP3E() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40000) >> 18
}
func (o *TAMP_Type) SetCR1_ITAMP4E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000)|value<<19)
}
func (o *TAMP_Type) GetCR1_ITAMP4E() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000) >> 19
}
func (o *TAMP_Type) SetCR1_ITAMP5E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100000)|value<<20)
}
func (o *TAMP_Type) GetCR1_ITAMP5E() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100000) >> 20
}
func (o *TAMP_Type) SetCR1_ITAMP6E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200000)|value<<21)
}
func (o *TAMP_Type) GetCR1_ITAMP6E() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200000) >> 21
}

// TAMP.CR2: control register 2
func (o *TAMP_Type) SetCR2_TAMP1NOER(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *TAMP_Type) GetCR2_TAMP1NOER() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}
func (o *TAMP_Type) SetCR2_TAMP2NOER(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2)|value<<1)
}
func (o *TAMP_Type) GetCR2_TAMP2NOER() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2) >> 1
}
func (o *TAMP_Type) SetCR2_TAMP3NOER(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *TAMP_Type) GetCR2_TAMP3NOER() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4) >> 2
}
func (o *TAMP_Type) SetCR2_TAMP1MSK(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10000)|value<<16)
}
func (o *TAMP_Type) GetCR2_TAMP1MSK() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10000) >> 16
}
func (o *TAMP_Type) SetCR2_TAMP2MSK(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20000)|value<<17)
}
func (o *TAMP_Type) GetCR2_TAMP2MSK() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20000) >> 17
}
func (o *TAMP_Type) SetCR2_TAMP3MSK(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40000)|value<<18)
}
func (o *TAMP_Type) GetCR2_TAMP3MSK() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40000) >> 18
}
func (o *TAMP_Type) SetCR2_TAMP1TRG(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000000)|value<<24)
}
func (o *TAMP_Type) GetCR2_TAMP1TRG() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000000) >> 24
}
func (o *TAMP_Type) SetCR2_TAMP2TRG(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000000)|value<<25)
}
func (o *TAMP_Type) GetCR2_TAMP2TRG() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000000) >> 25
}
func (o *TAMP_Type) SetCR2_TAMP3TRG(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000000)|value<<26)
}
func (o *TAMP_Type) GetCR2_TAMP3TRG() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000000) >> 26
}

// TAMP.FLTCR: TAMP filter control register
func (o *TAMP_Type) SetFLTCR_TAMPFREQ(value uint32) {
	volatile.StoreUint32(&o.FLTCR.Reg, volatile.LoadUint32(&o.FLTCR.Reg)&^(0x7)|value)
}
func (o *TAMP_Type) GetFLTCR_TAMPFREQ() uint32 {
	return volatile.LoadUint32(&o.FLTCR.Reg) & 0x7
}
func (o *TAMP_Type) SetFLTCR_TAMPFLT(value uint32) {
	volatile.StoreUint32(&o.FLTCR.Reg, volatile.LoadUint32(&o.FLTCR.Reg)&^(0x18)|value<<3)
}
func (o *TAMP_Type) GetFLTCR_TAMPFLT() uint32 {
	return (volatile.LoadUint32(&o.FLTCR.Reg) & 0x18) >> 3
}
func (o *TAMP_Type) SetFLTCR_TAMPPRCH(value uint32) {
	volatile.StoreUint32(&o.FLTCR.Reg, volatile.LoadUint32(&o.FLTCR.Reg)&^(0x60)|value<<5)
}
func (o *TAMP_Type) GetFLTCR_TAMPPRCH() uint32 {
	return (volatile.LoadUint32(&o.FLTCR.Reg) & 0x60) >> 5
}
func (o *TAMP_Type) SetFLTCR_TAMPPUDIS(value uint32) {
	volatile.StoreUint32(&o.FLTCR.Reg, volatile.LoadUint32(&o.FLTCR.Reg)&^(0x80)|value<<7)
}
func (o *TAMP_Type) GetFLTCR_TAMPPUDIS() uint32 {
	return (volatile.LoadUint32(&o.FLTCR.Reg) & 0x80) >> 7
}

// TAMP.IER: TAMP interrupt enable register
func (o *TAMP_Type) SetIER_TAMP1IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *TAMP_Type) GetIER_TAMP1IE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *TAMP_Type) SetIER_TAMP2IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *TAMP_Type) GetIER_TAMP2IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *TAMP_Type) SetIER_TAMP3IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *TAMP_Type) GetIER_TAMP3IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *TAMP_Type) SetIER_ITAMP3IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *TAMP_Type) GetIER_ITAMP3IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *TAMP_Type) SetIER_ITAMP4IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *TAMP_Type) GetIER_ITAMP4IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}
func (o *TAMP_Type) SetIER_ITAMP5IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100000)|value<<20)
}
func (o *TAMP_Type) GetIER_ITAMP5IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100000) >> 20
}
func (o *TAMP_Type) SetIER_ITAMP6IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200000)|value<<21)
}
func (o *TAMP_Type) GetIER_ITAMP6IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200000) >> 21
}

// TAMP.SR: TAMP status register
func (o *TAMP_Type) SetSR_TAMP1F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *TAMP_Type) GetSR_TAMP1F() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *TAMP_Type) SetSR_TAMP2F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *TAMP_Type) GetSR_TAMP2F() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *TAMP_Type) SetSR_TAMP3F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *TAMP_Type) GetSR_TAMP3F() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *TAMP_Type) SetSR_ITAMP3F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000)|value<<18)
}
func (o *TAMP_Type) GetSR_ITAMP3F() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000) >> 18
}
func (o *TAMP_Type) SetSR_ITAMP4F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *TAMP_Type) GetSR_ITAMP4F() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}
func (o *TAMP_Type) SetSR_ITAMP5F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100000)|value<<20)
}
func (o *TAMP_Type) GetSR_ITAMP5F() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100000) >> 20
}
func (o *TAMP_Type) SetSR_ITAMP6F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200000)|value<<21)
}
func (o *TAMP_Type) GetSR_ITAMP6F() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200000) >> 21
}

// TAMP.MISR: TAMP masked interrupt status register
func (o *TAMP_Type) SetMISR_TAMP1MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x1)|value)
}
func (o *TAMP_Type) GetMISR_TAMP1MF() uint32 {
	return volatile.LoadUint32(&o.MISR.Reg) & 0x1
}
func (o *TAMP_Type) SetMISR_TAMP2MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x2)|value<<1)
}
func (o *TAMP_Type) GetMISR_TAMP2MF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x2) >> 1
}
func (o *TAMP_Type) SetMISR_TAMP3MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x4)|value<<2)
}
func (o *TAMP_Type) GetMISR_TAMP3MF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x4) >> 2
}
func (o *TAMP_Type) SetMISR_ITAMP3MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x40000)|value<<18)
}
func (o *TAMP_Type) GetMISR_ITAMP3MF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x40000) >> 18
}
func (o *TAMP_Type) SetMISR_ITAMP4MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x80000)|value<<19)
}
func (o *TAMP_Type) GetMISR_ITAMP4MF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x80000) >> 19
}
func (o *TAMP_Type) SetMISR_ITAMP5MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x100000)|value<<20)
}
func (o *TAMP_Type) GetMISR_ITAMP5MF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x100000) >> 20
}
func (o *TAMP_Type) SetMISR_ITAMP6MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x200000)|value<<21)
}
func (o *TAMP_Type) GetMISR_ITAMP6MF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x200000) >> 21
}

// TAMP.SCR: TAMP status clear register
func (o *TAMP_Type) SetSCR_CTAMP1F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x1)|value)
}
func (o *TAMP_Type) GetSCR_CTAMP1F() uint32 {
	return volatile.LoadUint32(&o.SCR.Reg) & 0x1
}
func (o *TAMP_Type) SetSCR_CTAMP2F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x2)|value<<1)
}
func (o *TAMP_Type) GetSCR_CTAMP2F() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x2) >> 1
}
func (o *TAMP_Type) SetSCR_CTAMP3F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x4)|value<<2)
}
func (o *TAMP_Type) GetSCR_CTAMP3F() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x4) >> 2
}
func (o *TAMP_Type) SetSCR_CITAMP3F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x40000)|value<<18)
}
func (o *TAMP_Type) GetSCR_CITAMP3F() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x40000) >> 18
}
func (o *TAMP_Type) SetSCR_CITAMP4F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x80000)|value<<19)
}
func (o *TAMP_Type) GetSCR_CITAMP4F() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x80000) >> 19
}
func (o *TAMP_Type) SetSCR_CITAMP5F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x100000)|value<<20)
}
func (o *TAMP_Type) GetSCR_CITAMP5F() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x100000) >> 20
}
func (o *TAMP_Type) SetSCR_CITAMP6F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x200000)|value<<21)
}
func (o *TAMP_Type) GetSCR_CITAMP6F() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x200000) >> 21
}

// TAMP.BKP0R: TAMP backup register
func (o *TAMP_Type) SetBKP0R(value uint32) {
	volatile.StoreUint32(&o.BKP0R.Reg, value)
}
func (o *TAMP_Type) GetBKP0R() uint32 {
	return volatile.LoadUint32(&o.BKP0R.Reg)
}

// TAMP.BKP1R: TAMP backup register
func (o *TAMP_Type) SetBKP1R(value uint32) {
	volatile.StoreUint32(&o.BKP1R.Reg, value)
}
func (o *TAMP_Type) GetBKP1R() uint32 {
	return volatile.LoadUint32(&o.BKP1R.Reg)
}

// TAMP.BKP2R: TAMP backup register
func (o *TAMP_Type) SetBKP2R(value uint32) {
	volatile.StoreUint32(&o.BKP2R.Reg, value)
}
func (o *TAMP_Type) GetBKP2R() uint32 {
	return volatile.LoadUint32(&o.BKP2R.Reg)
}

// TAMP.BKP3R: TAMP backup register
func (o *TAMP_Type) SetBKP3R(value uint32) {
	volatile.StoreUint32(&o.BKP3R.Reg, value)
}
func (o *TAMP_Type) GetBKP3R() uint32 {
	return volatile.LoadUint32(&o.BKP3R.Reg)
}

// TAMP.BKP4R: TAMP backup register
func (o *TAMP_Type) SetBKP4R(value uint32) {
	volatile.StoreUint32(&o.BKP4R.Reg, value)
}
func (o *TAMP_Type) GetBKP4R() uint32 {
	return volatile.LoadUint32(&o.BKP4R.Reg)
}

// TAMP.BKP5R: TAMP backup register
func (o *TAMP_Type) SetBKP5R(value uint32) {
	volatile.StoreUint32(&o.BKP5R.Reg, value)
}
func (o *TAMP_Type) GetBKP5R() uint32 {
	return volatile.LoadUint32(&o.BKP5R.Reg)
}

// TAMP.BKP6R: TAMP backup register
func (o *TAMP_Type) SetBKP6R(value uint32) {
	volatile.StoreUint32(&o.BKP6R.Reg, value)
}
func (o *TAMP_Type) GetBKP6R() uint32 {
	return volatile.LoadUint32(&o.BKP6R.Reg)
}

// TAMP.BKP7R: TAMP backup register
func (o *TAMP_Type) SetBKP7R(value uint32) {
	volatile.StoreUint32(&o.BKP7R.Reg, value)
}
func (o *TAMP_Type) GetBKP7R() uint32 {
	return volatile.LoadUint32(&o.BKP7R.Reg)
}

// TAMP.BKP8R: TAMP backup register
func (o *TAMP_Type) SetBKP8R(value uint32) {
	volatile.StoreUint32(&o.BKP8R.Reg, value)
}
func (o *TAMP_Type) GetBKP8R() uint32 {
	return volatile.LoadUint32(&o.BKP8R.Reg)
}

// TAMP.BKP9R: TAMP backup register
func (o *TAMP_Type) SetBKP9R(value uint32) {
	volatile.StoreUint32(&o.BKP9R.Reg, value)
}
func (o *TAMP_Type) GetBKP9R() uint32 {
	return volatile.LoadUint32(&o.BKP9R.Reg)
}

// TAMP.BKP10R: TAMP backup register
func (o *TAMP_Type) SetBKP10R(value uint32) {
	volatile.StoreUint32(&o.BKP10R.Reg, value)
}
func (o *TAMP_Type) GetBKP10R() uint32 {
	return volatile.LoadUint32(&o.BKP10R.Reg)
}

// TAMP.BKP11R: TAMP backup register
func (o *TAMP_Type) SetBKP11R(value uint32) {
	volatile.StoreUint32(&o.BKP11R.Reg, value)
}
func (o *TAMP_Type) GetBKP11R() uint32 {
	return volatile.LoadUint32(&o.BKP11R.Reg)
}

// TAMP.BKP12R: TAMP backup register
func (o *TAMP_Type) SetBKP12R(value uint32) {
	volatile.StoreUint32(&o.BKP12R.Reg, value)
}
func (o *TAMP_Type) GetBKP12R() uint32 {
	return volatile.LoadUint32(&o.BKP12R.Reg)
}

// TAMP.BKP13R: TAMP backup register
func (o *TAMP_Type) SetBKP13R(value uint32) {
	volatile.StoreUint32(&o.BKP13R.Reg, value)
}
func (o *TAMP_Type) GetBKP13R() uint32 {
	return volatile.LoadUint32(&o.BKP13R.Reg)
}

// TAMP.BKP14R: TAMP backup register
func (o *TAMP_Type) SetBKP14R(value uint32) {
	volatile.StoreUint32(&o.BKP14R.Reg, value)
}
func (o *TAMP_Type) GetBKP14R() uint32 {
	return volatile.LoadUint32(&o.BKP14R.Reg)
}

// TAMP.BKP15R: TAMP backup register
func (o *TAMP_Type) SetBKP15R(value uint32) {
	volatile.StoreUint32(&o.BKP15R.Reg, value)
}
func (o *TAMP_Type) GetBKP15R() uint32 {
	return volatile.LoadUint32(&o.BKP15R.Reg)
}

// TAMP.BKP16R: TAMP backup register
func (o *TAMP_Type) SetBKP16R(value uint32) {
	volatile.StoreUint32(&o.BKP16R.Reg, value)
}
func (o *TAMP_Type) GetBKP16R() uint32 {
	return volatile.LoadUint32(&o.BKP16R.Reg)
}

// TAMP.BKP17R: TAMP backup register
func (o *TAMP_Type) SetBKP17R(value uint32) {
	volatile.StoreUint32(&o.BKP17R.Reg, value)
}
func (o *TAMP_Type) GetBKP17R() uint32 {
	return volatile.LoadUint32(&o.BKP17R.Reg)
}

// TAMP.BKP18R: TAMP backup register
func (o *TAMP_Type) SetBKP18R(value uint32) {
	volatile.StoreUint32(&o.BKP18R.Reg, value)
}
func (o *TAMP_Type) GetBKP18R() uint32 {
	return volatile.LoadUint32(&o.BKP18R.Reg)
}

// TAMP.BKP19R: TAMP backup register
func (o *TAMP_Type) SetBKP19R(value uint32) {
	volatile.StoreUint32(&o.BKP19R.Reg, value)
}
func (o *TAMP_Type) GetBKP19R() uint32 {
	return volatile.LoadUint32(&o.BKP19R.Reg)
}

// TAMP.BKP20R: TAMP backup register
func (o *TAMP_Type) SetBKP20R(value uint32) {
	volatile.StoreUint32(&o.BKP20R.Reg, value)
}
func (o *TAMP_Type) GetBKP20R() uint32 {
	return volatile.LoadUint32(&o.BKP20R.Reg)
}

// TAMP.BKP21R: TAMP backup register
func (o *TAMP_Type) SetBKP21R(value uint32) {
	volatile.StoreUint32(&o.BKP21R.Reg, value)
}
func (o *TAMP_Type) GetBKP21R() uint32 {
	return volatile.LoadUint32(&o.BKP21R.Reg)
}

// TAMP.BKP22R: TAMP backup register
func (o *TAMP_Type) SetBKP22R(value uint32) {
	volatile.StoreUint32(&o.BKP22R.Reg, value)
}
func (o *TAMP_Type) GetBKP22R() uint32 {
	return volatile.LoadUint32(&o.BKP22R.Reg)
}

// TAMP.BKP23R: TAMP backup register
func (o *TAMP_Type) SetBKP23R(value uint32) {
	volatile.StoreUint32(&o.BKP23R.Reg, value)
}
func (o *TAMP_Type) GetBKP23R() uint32 {
	return volatile.LoadUint32(&o.BKP23R.Reg)
}

// TAMP.BKP24R: TAMP backup register
func (o *TAMP_Type) SetBKP24R(value uint32) {
	volatile.StoreUint32(&o.BKP24R.Reg, value)
}
func (o *TAMP_Type) GetBKP24R() uint32 {
	return volatile.LoadUint32(&o.BKP24R.Reg)
}

// TAMP.BKP25R: TAMP backup register
func (o *TAMP_Type) SetBKP25R(value uint32) {
	volatile.StoreUint32(&o.BKP25R.Reg, value)
}
func (o *TAMP_Type) GetBKP25R() uint32 {
	return volatile.LoadUint32(&o.BKP25R.Reg)
}

// TAMP.BKP26R: TAMP backup register
func (o *TAMP_Type) SetBKP26R(value uint32) {
	volatile.StoreUint32(&o.BKP26R.Reg, value)
}
func (o *TAMP_Type) GetBKP26R() uint32 {
	return volatile.LoadUint32(&o.BKP26R.Reg)
}

// TAMP.BKP27R: TAMP backup register
func (o *TAMP_Type) SetBKP27R(value uint32) {
	volatile.StoreUint32(&o.BKP27R.Reg, value)
}
func (o *TAMP_Type) GetBKP27R() uint32 {
	return volatile.LoadUint32(&o.BKP27R.Reg)
}

// TAMP.BKP28R: TAMP backup register
func (o *TAMP_Type) SetBKP28R(value uint32) {
	volatile.StoreUint32(&o.BKP28R.Reg, value)
}
func (o *TAMP_Type) GetBKP28R() uint32 {
	return volatile.LoadUint32(&o.BKP28R.Reg)
}

// TAMP.BKP29R: TAMP backup register
func (o *TAMP_Type) SetBKP29R(value uint32) {
	volatile.StoreUint32(&o.BKP29R.Reg, value)
}
func (o *TAMP_Type) GetBKP29R() uint32 {
	return volatile.LoadUint32(&o.BKP29R.Reg)
}

// TAMP.BKP30R: TAMP backup register
func (o *TAMP_Type) SetBKP30R(value uint32) {
	volatile.StoreUint32(&o.BKP30R.Reg, value)
}
func (o *TAMP_Type) GetBKP30R() uint32 {
	return volatile.LoadUint32(&o.BKP30R.Reg)
}

// TAMP.BKP31R: TAMP backup register
func (o *TAMP_Type) SetBKP31R(value uint32) {
	volatile.StoreUint32(&o.BKP31R.Reg, value)
}
func (o *TAMP_Type) GetBKP31R() uint32 {
	return volatile.LoadUint32(&o.BKP31R.Reg)
}

// Floting point unit
type FPU_Type struct {
	FPCCR volatile.Register32 // 0x0
	FPCAR volatile.Register32 // 0x4
	FPSCR volatile.Register32 // 0x8
}

// FPU.FPCCR: Floating-point context control register
func (o *FPU_Type) SetFPCCR_LSPACT(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x1)|value)
}
func (o *FPU_Type) GetFPCCR_LSPACT() uint32 {
	return volatile.LoadUint32(&o.FPCCR.Reg) & 0x1
}
func (o *FPU_Type) SetFPCCR_USER(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x2)|value<<1)
}
func (o *FPU_Type) GetFPCCR_USER() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x2) >> 1
}
func (o *FPU_Type) SetFPCCR_THREAD(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x8)|value<<3)
}
func (o *FPU_Type) GetFPCCR_THREAD() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x8) >> 3
}
func (o *FPU_Type) SetFPCCR_HFRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x10)|value<<4)
}
func (o *FPU_Type) GetFPCCR_HFRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x10) >> 4
}
func (o *FPU_Type) SetFPCCR_MMRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x20)|value<<5)
}
func (o *FPU_Type) GetFPCCR_MMRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x20) >> 5
}
func (o *FPU_Type) SetFPCCR_BFRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x40)|value<<6)
}
func (o *FPU_Type) GetFPCCR_BFRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x40) >> 6
}
func (o *FPU_Type) SetFPCCR_MONRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x100)|value<<8)
}
func (o *FPU_Type) GetFPCCR_MONRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x100) >> 8
}
func (o *FPU_Type) SetFPCCR_LSPEN(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x40000000)|value<<30)
}
func (o *FPU_Type) GetFPCCR_LSPEN() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x40000000) >> 30
}
func (o *FPU_Type) SetFPCCR_ASPEN(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x80000000)|value<<31)
}
func (o *FPU_Type) GetFPCCR_ASPEN() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x80000000) >> 31
}

// FPU.FPCAR: Floating-point context address register
func (o *FPU_Type) SetFPCAR_ADDRESS(value uint32) {
	volatile.StoreUint32(&o.FPCAR.Reg, volatile.LoadUint32(&o.FPCAR.Reg)&^(0xfffffff8)|value<<3)
}
func (o *FPU_Type) GetFPCAR_ADDRESS() uint32 {
	return (volatile.LoadUint32(&o.FPCAR.Reg) & 0xfffffff8) >> 3
}

// FPU.FPSCR: Floating-point status control register
func (o *FPU_Type) SetFPSCR_IOC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x1)|value)
}
func (o *FPU_Type) GetFPSCR_IOC() uint32 {
	return volatile.LoadUint32(&o.FPSCR.Reg) & 0x1
}
func (o *FPU_Type) SetFPSCR_DZC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x2)|value<<1)
}
func (o *FPU_Type) GetFPSCR_DZC() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x2) >> 1
}
func (o *FPU_Type) SetFPSCR_OFC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x4)|value<<2)
}
func (o *FPU_Type) GetFPSCR_OFC() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x4) >> 2
}
func (o *FPU_Type) SetFPSCR_UFC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x8)|value<<3)
}
func (o *FPU_Type) GetFPSCR_UFC() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x8) >> 3
}
func (o *FPU_Type) SetFPSCR_IXC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x10)|value<<4)
}
func (o *FPU_Type) GetFPSCR_IXC() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x10) >> 4
}
func (o *FPU_Type) SetFPSCR_IDC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x80)|value<<7)
}
func (o *FPU_Type) GetFPSCR_IDC() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x80) >> 7
}
func (o *FPU_Type) SetFPSCR_RMode(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0xc00000)|value<<22)
}
func (o *FPU_Type) GetFPSCR_RMode() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0xc00000) >> 22
}
func (o *FPU_Type) SetFPSCR_FZ(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x1000000)|value<<24)
}
func (o *FPU_Type) GetFPSCR_FZ() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x1000000) >> 24
}
func (o *FPU_Type) SetFPSCR_DN(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x2000000)|value<<25)
}
func (o *FPU_Type) GetFPSCR_DN() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x2000000) >> 25
}
func (o *FPU_Type) SetFPSCR_AHP(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x4000000)|value<<26)
}
func (o *FPU_Type) GetFPSCR_AHP() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x4000000) >> 26
}
func (o *FPU_Type) SetFPSCR_V(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x10000000)|value<<28)
}
func (o *FPU_Type) GetFPSCR_V() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x10000000) >> 28
}
func (o *FPU_Type) SetFPSCR_C(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x20000000)|value<<29)
}
func (o *FPU_Type) GetFPSCR_C() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x20000000) >> 29
}
func (o *FPU_Type) SetFPSCR_Z(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x40000000)|value<<30)
}
func (o *FPU_Type) GetFPSCR_Z() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x40000000) >> 30
}
func (o *FPU_Type) SetFPSCR_N(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x80000000)|value<<31)
}
func (o *FPU_Type) GetFPSCR_N() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x80000000) >> 31
}

// Memory protection unit
type MPU_Type struct {
	TYPER volatile.Register32 // 0x0
	CTRL  volatile.Register32 // 0x4
	RNR   volatile.Register32 // 0x8
	RBAR  volatile.Register32 // 0xC
	RASR  volatile.Register32 // 0x10
}

// MPU.TYPER: MPU type register
func (o *MPU_Type) SetTYPER_SEPARATE(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetTYPER_SEPARATE() uint32 {
	return volatile.LoadUint32(&o.TYPER.Reg) & 0x1
}
func (o *MPU_Type) SetTYPER_DREGION(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0xff00)|value<<8)
}
func (o *MPU_Type) GetTYPER_DREGION() uint32 {
	return (volatile.LoadUint32(&o.TYPER.Reg) & 0xff00) >> 8
}
func (o *MPU_Type) SetTYPER_IREGION(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0xff0000)|value<<16)
}
func (o *MPU_Type) GetTYPER_IREGION() uint32 {
	return (volatile.LoadUint32(&o.TYPER.Reg) & 0xff0000) >> 16
}

// MPU.CTRL: MPU control register
func (o *MPU_Type) SetCTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetCTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *MPU_Type) SetCTRL_HFNMIENA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *MPU_Type) GetCTRL_HFNMIENA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *MPU_Type) SetCTRL_PRIVDEFENA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *MPU_Type) GetCTRL_PRIVDEFENA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}

// MPU.RNR: MPU region number register
func (o *MPU_Type) SetRNR_REGION(value uint32) {
	volatile.StoreUint32(&o.RNR.Reg, volatile.LoadUint32(&o.RNR.Reg)&^(0xff)|value)
}
func (o *MPU_Type) GetRNR_REGION() uint32 {
	return volatile.LoadUint32(&o.RNR.Reg) & 0xff
}

// MPU.RBAR: MPU region base address register
func (o *MPU_Type) SetRBAR_REGION(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0xf)|value)
}
func (o *MPU_Type) GetRBAR_REGION() uint32 {
	return volatile.LoadUint32(&o.RBAR.Reg) & 0xf
}
func (o *MPU_Type) SetRBAR_VALID(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0x10)|value<<4)
}
func (o *MPU_Type) GetRBAR_VALID() uint32 {
	return (volatile.LoadUint32(&o.RBAR.Reg) & 0x10) >> 4
}
func (o *MPU_Type) SetRBAR_ADDR(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0xffffffe0)|value<<5)
}
func (o *MPU_Type) GetRBAR_ADDR() uint32 {
	return (volatile.LoadUint32(&o.RBAR.Reg) & 0xffffffe0) >> 5
}

// MPU.RASR: MPU region attribute and size register
func (o *MPU_Type) SetRASR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetRASR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.RASR.Reg) & 0x1
}
func (o *MPU_Type) SetRASR_SIZE(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x3e)|value<<1)
}
func (o *MPU_Type) GetRASR_SIZE() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x3e) >> 1
}
func (o *MPU_Type) SetRASR_SRD(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0xff00)|value<<8)
}
func (o *MPU_Type) GetRASR_SRD() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0xff00) >> 8
}
func (o *MPU_Type) SetRASR_B(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x10000)|value<<16)
}
func (o *MPU_Type) GetRASR_B() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x10000) >> 16
}
func (o *MPU_Type) SetRASR_C(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x20000)|value<<17)
}
func (o *MPU_Type) GetRASR_C() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x20000) >> 17
}
func (o *MPU_Type) SetRASR_S(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x40000)|value<<18)
}
func (o *MPU_Type) GetRASR_S() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x40000) >> 18
}
func (o *MPU_Type) SetRASR_TEX(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x380000)|value<<19)
}
func (o *MPU_Type) GetRASR_TEX() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x380000) >> 19
}
func (o *MPU_Type) SetRASR_AP(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x7000000)|value<<24)
}
func (o *MPU_Type) GetRASR_AP() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x7000000) >> 24
}
func (o *MPU_Type) SetRASR_XN(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x10000000)|value<<28)
}
func (o *MPU_Type) GetRASR_XN() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x10000000) >> 28
}

// SysTick timer
type STK_Type struct {
	CTRL  volatile.Register32 // 0x0
	LOAD  volatile.Register32 // 0x4
	VAL   volatile.Register32 // 0x8
	CALIB volatile.Register32 // 0xC
}

// STK.CTRL: SysTick control and status register
func (o *STK_Type) SetCTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *STK_Type) GetCTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *STK_Type) SetCTRL_TICKINT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *STK_Type) GetCTRL_TICKINT() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *STK_Type) SetCTRL_CLKSOURCE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *STK_Type) GetCTRL_CLKSOURCE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *STK_Type) SetCTRL_COUNTFLAG(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *STK_Type) GetCTRL_COUNTFLAG() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10000) >> 16
}

// STK.LOAD: SysTick reload value register
func (o *STK_Type) SetLOAD_RELOAD(value uint32) {
	volatile.StoreUint32(&o.LOAD.Reg, volatile.LoadUint32(&o.LOAD.Reg)&^(0xffffff)|value)
}
func (o *STK_Type) GetLOAD_RELOAD() uint32 {
	return volatile.LoadUint32(&o.LOAD.Reg) & 0xffffff
}

// STK.VAL: SysTick current value register
func (o *STK_Type) SetVAL_CURRENT(value uint32) {
	volatile.StoreUint32(&o.VAL.Reg, volatile.LoadUint32(&o.VAL.Reg)&^(0xffffff)|value)
}
func (o *STK_Type) GetVAL_CURRENT() uint32 {
	return volatile.LoadUint32(&o.VAL.Reg) & 0xffffff
}

// STK.CALIB: SysTick calibration value register
func (o *STK_Type) SetCALIB_TENMS(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0xffffff)|value)
}
func (o *STK_Type) GetCALIB_TENMS() uint32 {
	return volatile.LoadUint32(&o.CALIB.Reg) & 0xffffff
}
func (o *STK_Type) SetCALIB_SKEW(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0x40000000)|value<<30)
}
func (o *STK_Type) GetCALIB_SKEW() uint32 {
	return (volatile.LoadUint32(&o.CALIB.Reg) & 0x40000000) >> 30
}
func (o *STK_Type) SetCALIB_NOREF(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0x80000000)|value<<31)
}
func (o *STK_Type) GetCALIB_NOREF() uint32 {
	return (volatile.LoadUint32(&o.CALIB.Reg) & 0x80000000) >> 31
}

// System control block
type SCB_Type struct {
	CPUID                volatile.Register32 // 0x0
	ICSR                 volatile.Register32 // 0x4
	VTOR                 volatile.Register32 // 0x8
	AIRCR                volatile.Register32 // 0xC
	SCR                  volatile.Register32 // 0x10
	CCR                  volatile.Register32 // 0x14
	SHPR1                volatile.Register32 // 0x18
	SHPR2                volatile.Register32 // 0x1C
	SHPR3                volatile.Register32 // 0x20
	SHCSR                volatile.Register32 // 0x24
	CFSR_UFSR_BFSR_MMFSR volatile.Register32 // 0x28
	HFSR                 volatile.Register32 // 0x2C
	_                    [4]byte
	MMFAR                volatile.Register32 // 0x34
	BFAR                 volatile.Register32 // 0x38
	AFSR                 volatile.Register32 // 0x3C
}

// SCB.CPUID: CPUID base register
func (o *SCB_Type) SetCPUID_Revision(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xf)|value)
}
func (o *SCB_Type) GetCPUID_Revision() uint32 {
	return volatile.LoadUint32(&o.CPUID.Reg) & 0xf
}
func (o *SCB_Type) SetCPUID_PartNo(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xfff0)|value<<4)
}
func (o *SCB_Type) GetCPUID_PartNo() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xfff0) >> 4
}
func (o *SCB_Type) SetCPUID_Constant(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xf0000)|value<<16)
}
func (o *SCB_Type) GetCPUID_Constant() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xf0000) >> 16
}
func (o *SCB_Type) SetCPUID_Variant(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xf00000)|value<<20)
}
func (o *SCB_Type) GetCPUID_Variant() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xf00000) >> 20
}
func (o *SCB_Type) SetCPUID_Implementer(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xff000000)|value<<24)
}
func (o *SCB_Type) GetCPUID_Implementer() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xff000000) >> 24
}

// SCB.ICSR: Interrupt control and state register
func (o *SCB_Type) SetICSR_VECTACTIVE(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x1ff)|value)
}
func (o *SCB_Type) GetICSR_VECTACTIVE() uint32 {
	return volatile.LoadUint32(&o.ICSR.Reg) & 0x1ff
}
func (o *SCB_Type) SetICSR_RETTOBASE(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x800)|value<<11)
}
func (o *SCB_Type) GetICSR_RETTOBASE() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x800) >> 11
}
func (o *SCB_Type) SetICSR_VECTPENDING(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x7f000)|value<<12)
}
func (o *SCB_Type) GetICSR_VECTPENDING() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x7f000) >> 12
}
func (o *SCB_Type) SetICSR_ISRPENDING(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x400000)|value<<22)
}
func (o *SCB_Type) GetICSR_ISRPENDING() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x400000) >> 22
}
func (o *SCB_Type) SetICSR_PENDSTCLR(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x2000000)|value<<25)
}
func (o *SCB_Type) GetICSR_PENDSTCLR() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x2000000) >> 25
}
func (o *SCB_Type) SetICSR_PENDSTSET(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x4000000)|value<<26)
}
func (o *SCB_Type) GetICSR_PENDSTSET() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x4000000) >> 26
}
func (o *SCB_Type) SetICSR_PENDSVCLR(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x8000000)|value<<27)
}
func (o *SCB_Type) GetICSR_PENDSVCLR() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x8000000) >> 27
}
func (o *SCB_Type) SetICSR_PENDSVSET(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x10000000)|value<<28)
}
func (o *SCB_Type) GetICSR_PENDSVSET() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x10000000) >> 28
}
func (o *SCB_Type) SetICSR_NMIPENDSET(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x80000000)|value<<31)
}
func (o *SCB_Type) GetICSR_NMIPENDSET() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x80000000) >> 31
}

// SCB.VTOR: Vector table offset register
func (o *SCB_Type) SetVTOR_TBLOFF(value uint32) {
	volatile.StoreUint32(&o.VTOR.Reg, volatile.LoadUint32(&o.VTOR.Reg)&^(0x3ffffe00)|value<<9)
}
func (o *SCB_Type) GetVTOR_TBLOFF() uint32 {
	return (volatile.LoadUint32(&o.VTOR.Reg) & 0x3ffffe00) >> 9
}

// SCB.AIRCR: Application interrupt and reset control register
func (o *SCB_Type) SetAIRCR_VECTRESET(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x1)|value)
}
func (o *SCB_Type) GetAIRCR_VECTRESET() uint32 {
	return volatile.LoadUint32(&o.AIRCR.Reg) & 0x1
}
func (o *SCB_Type) SetAIRCR_VECTCLRACTIVE(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetAIRCR_VECTCLRACTIVE() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetAIRCR_SYSRESETREQ(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x4)|value<<2)
}
func (o *SCB_Type) GetAIRCR_SYSRESETREQ() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x4) >> 2
}
func (o *SCB_Type) SetAIRCR_PRIGROUP(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x700)|value<<8)
}
func (o *SCB_Type) GetAIRCR_PRIGROUP() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x700) >> 8
}
func (o *SCB_Type) SetAIRCR_ENDIANESS(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x8000)|value<<15)
}
func (o *SCB_Type) GetAIRCR_ENDIANESS() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x8000) >> 15
}
func (o *SCB_Type) SetAIRCR_VECTKEYSTAT(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCB_Type) GetAIRCR_VECTKEYSTAT() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0xffff0000) >> 16
}

// SCB.SCR: System control register
func (o *SCB_Type) SetSCR_SLEEPONEXIT(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetSCR_SLEEPONEXIT() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetSCR_SLEEPDEEP(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x4)|value<<2)
}
func (o *SCB_Type) GetSCR_SLEEPDEEP() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x4) >> 2
}
func (o *SCB_Type) SetSCR_SEVEONPEND(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x10)|value<<4)
}
func (o *SCB_Type) GetSCR_SEVEONPEND() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x10) >> 4
}

// SCB.CCR: Configuration and control register
func (o *SCB_Type) SetCCR_NONBASETHRDENA(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1)|value)
}
func (o *SCB_Type) GetCCR_NONBASETHRDENA() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x1
}
func (o *SCB_Type) SetCCR_USERSETMPEND(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetCCR_USERSETMPEND() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetCCR_UNALIGN__TRP(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x8)|value<<3)
}
func (o *SCB_Type) GetCCR_UNALIGN__TRP() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x8) >> 3
}
func (o *SCB_Type) SetCCR_DIV_0_TRP(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x10)|value<<4)
}
func (o *SCB_Type) GetCCR_DIV_0_TRP() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x10) >> 4
}
func (o *SCB_Type) SetCCR_BFHFNMIGN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x100)|value<<8)
}
func (o *SCB_Type) GetCCR_BFHFNMIGN() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x100) >> 8
}
func (o *SCB_Type) SetCCR_STKALIGN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x200)|value<<9)
}
func (o *SCB_Type) GetCCR_STKALIGN() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x200) >> 9
}

// SCB.SHPR1: System handler priority registers
func (o *SCB_Type) SetSHPR1_PRI_4(value uint32) {
	volatile.StoreUint32(&o.SHPR1.Reg, volatile.LoadUint32(&o.SHPR1.Reg)&^(0xff)|value)
}
func (o *SCB_Type) GetSHPR1_PRI_4() uint32 {
	return volatile.LoadUint32(&o.SHPR1.Reg) & 0xff
}
func (o *SCB_Type) SetSHPR1_PRI_5(value uint32) {
	volatile.StoreUint32(&o.SHPR1.Reg, volatile.LoadUint32(&o.SHPR1.Reg)&^(0xff00)|value<<8)
}
func (o *SCB_Type) GetSHPR1_PRI_5() uint32 {
	return (volatile.LoadUint32(&o.SHPR1.Reg) & 0xff00) >> 8
}
func (o *SCB_Type) SetSHPR1_PRI_6(value uint32) {
	volatile.StoreUint32(&o.SHPR1.Reg, volatile.LoadUint32(&o.SHPR1.Reg)&^(0xff0000)|value<<16)
}
func (o *SCB_Type) GetSHPR1_PRI_6() uint32 {
	return (volatile.LoadUint32(&o.SHPR1.Reg) & 0xff0000) >> 16
}

// SCB.SHPR2: System handler priority registers
func (o *SCB_Type) SetSHPR2_PRI_11(value uint32) {
	volatile.StoreUint32(&o.SHPR2.Reg, volatile.LoadUint32(&o.SHPR2.Reg)&^(0xff000000)|value<<24)
}
func (o *SCB_Type) GetSHPR2_PRI_11() uint32 {
	return (volatile.LoadUint32(&o.SHPR2.Reg) & 0xff000000) >> 24
}

// SCB.SHPR3: System handler priority registers
func (o *SCB_Type) SetSHPR3_PRI_14(value uint32) {
	volatile.StoreUint32(&o.SHPR3.Reg, volatile.LoadUint32(&o.SHPR3.Reg)&^(0xff0000)|value<<16)
}
func (o *SCB_Type) GetSHPR3_PRI_14() uint32 {
	return (volatile.LoadUint32(&o.SHPR3.Reg) & 0xff0000) >> 16
}
func (o *SCB_Type) SetSHPR3_PRI_15(value uint32) {
	volatile.StoreUint32(&o.SHPR3.Reg, volatile.LoadUint32(&o.SHPR3.Reg)&^(0xff000000)|value<<24)
}
func (o *SCB_Type) GetSHPR3_PRI_15() uint32 {
	return (volatile.LoadUint32(&o.SHPR3.Reg) & 0xff000000) >> 24
}

// SCB.SHCSR: System handler control and state register
func (o *SCB_Type) SetSHCSR_MEMFAULTACT(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x1)|value)
}
func (o *SCB_Type) GetSHCSR_MEMFAULTACT() uint32 {
	return volatile.LoadUint32(&o.SHCSR.Reg) & 0x1
}
func (o *SCB_Type) SetSHCSR_BUSFAULTACT(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetSHCSR_BUSFAULTACT() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetSHCSR_USGFAULTACT(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x8)|value<<3)
}
func (o *SCB_Type) GetSHCSR_USGFAULTACT() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x8) >> 3
}
func (o *SCB_Type) SetSHCSR_SVCALLACT(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x80)|value<<7)
}
func (o *SCB_Type) GetSHCSR_SVCALLACT() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x80) >> 7
}
func (o *SCB_Type) SetSHCSR_MONITORACT(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x100)|value<<8)
}
func (o *SCB_Type) GetSHCSR_MONITORACT() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x100) >> 8
}
func (o *SCB_Type) SetSHCSR_PENDSVACT(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x400)|value<<10)
}
func (o *SCB_Type) GetSHCSR_PENDSVACT() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x400) >> 10
}
func (o *SCB_Type) SetSHCSR_SYSTICKACT(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x800)|value<<11)
}
func (o *SCB_Type) GetSHCSR_SYSTICKACT() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x800) >> 11
}
func (o *SCB_Type) SetSHCSR_USGFAULTPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x1000)|value<<12)
}
func (o *SCB_Type) GetSHCSR_USGFAULTPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x1000) >> 12
}
func (o *SCB_Type) SetSHCSR_MEMFAULTPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x2000)|value<<13)
}
func (o *SCB_Type) GetSHCSR_MEMFAULTPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x2000) >> 13
}
func (o *SCB_Type) SetSHCSR_BUSFAULTPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x4000)|value<<14)
}
func (o *SCB_Type) GetSHCSR_BUSFAULTPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x4000) >> 14
}
func (o *SCB_Type) SetSHCSR_SVCALLPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x8000)|value<<15)
}
func (o *SCB_Type) GetSHCSR_SVCALLPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x8000) >> 15
}
func (o *SCB_Type) SetSHCSR_MEMFAULTENA(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x10000)|value<<16)
}
func (o *SCB_Type) GetSHCSR_MEMFAULTENA() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x10000) >> 16
}
func (o *SCB_Type) SetSHCSR_BUSFAULTENA(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x20000)|value<<17)
}
func (o *SCB_Type) GetSHCSR_BUSFAULTENA() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x20000) >> 17
}
func (o *SCB_Type) SetSHCSR_USGFAULTENA(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x40000)|value<<18)
}
func (o *SCB_Type) GetSHCSR_USGFAULTENA() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x40000) >> 18
}

// SCB.CFSR_UFSR_BFSR_MMFSR: Configurable fault status register
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_IACCVIOL(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_IACCVIOL() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_MUNSTKERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x8)|value<<3)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_MUNSTKERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x8) >> 3
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_MSTKERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x10)|value<<4)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_MSTKERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x10) >> 4
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_MLSPERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x20)|value<<5)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_MLSPERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x20) >> 5
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_MMARVALID(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x80)|value<<7)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_MMARVALID() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x80) >> 7
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_IBUSERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x100)|value<<8)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_IBUSERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x100) >> 8
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_PRECISERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x200)|value<<9)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_PRECISERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x200) >> 9
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_IMPRECISERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x400)|value<<10)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_IMPRECISERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x400) >> 10
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_UNSTKERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x800)|value<<11)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_UNSTKERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x800) >> 11
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_STKERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x1000)|value<<12)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_STKERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x1000) >> 12
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_LSPERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x2000)|value<<13)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_LSPERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x2000) >> 13
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_BFARVALID(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x8000)|value<<15)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_BFARVALID() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x8000) >> 15
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_UNDEFINSTR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x10000)|value<<16)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_UNDEFINSTR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x10000) >> 16
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_INVSTATE(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x20000)|value<<17)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_INVSTATE() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x20000) >> 17
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_INVPC(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x40000)|value<<18)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_INVPC() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x40000) >> 18
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_NOCP(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x80000)|value<<19)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_NOCP() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x80000) >> 19
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_UNALIGNED(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x1000000)|value<<24)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_UNALIGNED() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x1000000) >> 24
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_DIVBYZERO(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x2000000)|value<<25)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_DIVBYZERO() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x2000000) >> 25
}

// SCB.HFSR: Hard fault status register
func (o *SCB_Type) SetHFSR_VECTTBL(value uint32) {
	volatile.StoreUint32(&o.HFSR.Reg, volatile.LoadUint32(&o.HFSR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetHFSR_VECTTBL() uint32 {
	return (volatile.LoadUint32(&o.HFSR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetHFSR_FORCED(value uint32) {
	volatile.StoreUint32(&o.HFSR.Reg, volatile.LoadUint32(&o.HFSR.Reg)&^(0x40000000)|value<<30)
}
func (o *SCB_Type) GetHFSR_FORCED() uint32 {
	return (volatile.LoadUint32(&o.HFSR.Reg) & 0x40000000) >> 30
}
func (o *SCB_Type) SetHFSR_DEBUG_VT(value uint32) {
	volatile.StoreUint32(&o.HFSR.Reg, volatile.LoadUint32(&o.HFSR.Reg)&^(0x80000000)|value<<31)
}
func (o *SCB_Type) GetHFSR_DEBUG_VT() uint32 {
	return (volatile.LoadUint32(&o.HFSR.Reg) & 0x80000000) >> 31
}

// SCB.MMFAR: Memory management fault address register
func (o *SCB_Type) SetMMFAR(value uint32) {
	volatile.StoreUint32(&o.MMFAR.Reg, value)
}
func (o *SCB_Type) GetMMFAR() uint32 {
	return volatile.LoadUint32(&o.MMFAR.Reg)
}

// SCB.BFAR: Bus fault address register
func (o *SCB_Type) SetBFAR(value uint32) {
	volatile.StoreUint32(&o.BFAR.Reg, value)
}
func (o *SCB_Type) GetBFAR() uint32 {
	return volatile.LoadUint32(&o.BFAR.Reg)
}

// SCB.AFSR: Auxiliary fault status register
func (o *SCB_Type) SetAFSR(value uint32) {
	volatile.StoreUint32(&o.AFSR.Reg, value)
}
func (o *SCB_Type) GetAFSR() uint32 {
	return volatile.LoadUint32(&o.AFSR.Reg)
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	ISER0 volatile.Register32 // 0x0
	ISER1 volatile.Register32 // 0x4
	ISER2 volatile.Register32 // 0x8
	ISER3 volatile.Register32 // 0xC
	_     [112]byte
	ICER0 volatile.Register32 // 0x80
	ICER1 volatile.Register32 // 0x84
	ICER2 volatile.Register32 // 0x88
	ICER3 volatile.Register32 // 0x8C
	_     [112]byte
	ISPR0 volatile.Register32 // 0x100
	ISPR1 volatile.Register32 // 0x104
	ISPR2 volatile.Register32 // 0x108
	ISPR3 volatile.Register32 // 0x10C
	_     [112]byte
	ICPR0 volatile.Register32 // 0x180
	ICPR1 volatile.Register32 // 0x184
	ICPR2 volatile.Register32 // 0x188
	ICPR3 volatile.Register32 // 0x18C
	_     [112]byte
	IABR0 volatile.Register32 // 0x200
	IABR1 volatile.Register32 // 0x204
	IABR2 volatile.Register32 // 0x208
	IABR3 volatile.Register32 // 0x20C
	_     [240]byte
	IPR0  volatile.Register32 // 0x300
	IPR1  volatile.Register32 // 0x304
	IPR2  volatile.Register32 // 0x308
	IPR3  volatile.Register32 // 0x30C
	IPR4  volatile.Register32 // 0x310
	IPR5  volatile.Register32 // 0x314
	IPR6  volatile.Register32 // 0x318
	IPR7  volatile.Register32 // 0x31C
	IPR8  volatile.Register32 // 0x320
	IPR9  volatile.Register32 // 0x324
	IPR10 volatile.Register32 // 0x328
	IPR11 volatile.Register32 // 0x32C
	IPR12 volatile.Register32 // 0x330
	IPR13 volatile.Register32 // 0x334
	IPR14 volatile.Register32 // 0x338
	IPR15 volatile.Register32 // 0x33C
	IPR16 volatile.Register32 // 0x340
	IPR17 volatile.Register32 // 0x344
	IPR18 volatile.Register32 // 0x348
	IPR19 volatile.Register32 // 0x34C
	IPR20 volatile.Register32 // 0x350
	IPR21 volatile.Register32 // 0x354
	IPR22 volatile.Register32 // 0x358
	IPR23 volatile.Register32 // 0x35C
	IPR24 volatile.Register32 // 0x360
	IPR25 volatile.Register32 // 0x364
}

// NVIC.ISER0: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER0(value uint32) {
	volatile.StoreUint32(&o.ISER0.Reg, value)
}
func (o *NVIC_Type) GetISER0() uint32 {
	return volatile.LoadUint32(&o.ISER0.Reg)
}

// NVIC.ISER1: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER1(value uint32) {
	volatile.StoreUint32(&o.ISER1.Reg, value)
}
func (o *NVIC_Type) GetISER1() uint32 {
	return volatile.LoadUint32(&o.ISER1.Reg)
}

// NVIC.ISER2: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER2(value uint32) {
	volatile.StoreUint32(&o.ISER2.Reg, value)
}
func (o *NVIC_Type) GetISER2() uint32 {
	return volatile.LoadUint32(&o.ISER2.Reg)
}

// NVIC.ISER3: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER3(value uint32) {
	volatile.StoreUint32(&o.ISER3.Reg, value)
}
func (o *NVIC_Type) GetISER3() uint32 {
	return volatile.LoadUint32(&o.ISER3.Reg)
}

// NVIC.ICER0: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER0(value uint32) {
	volatile.StoreUint32(&o.ICER0.Reg, value)
}
func (o *NVIC_Type) GetICER0() uint32 {
	return volatile.LoadUint32(&o.ICER0.Reg)
}

// NVIC.ICER1: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER1(value uint32) {
	volatile.StoreUint32(&o.ICER1.Reg, value)
}
func (o *NVIC_Type) GetICER1() uint32 {
	return volatile.LoadUint32(&o.ICER1.Reg)
}

// NVIC.ICER2: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER2(value uint32) {
	volatile.StoreUint32(&o.ICER2.Reg, value)
}
func (o *NVIC_Type) GetICER2() uint32 {
	return volatile.LoadUint32(&o.ICER2.Reg)
}

// NVIC.ICER3: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER3(value uint32) {
	volatile.StoreUint32(&o.ICER3.Reg, value)
}
func (o *NVIC_Type) GetICER3() uint32 {
	return volatile.LoadUint32(&o.ICER3.Reg)
}

// NVIC.ISPR0: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR0(value uint32) {
	volatile.StoreUint32(&o.ISPR0.Reg, value)
}
func (o *NVIC_Type) GetISPR0() uint32 {
	return volatile.LoadUint32(&o.ISPR0.Reg)
}

// NVIC.ISPR1: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR1(value uint32) {
	volatile.StoreUint32(&o.ISPR1.Reg, value)
}
func (o *NVIC_Type) GetISPR1() uint32 {
	return volatile.LoadUint32(&o.ISPR1.Reg)
}

// NVIC.ISPR2: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR2(value uint32) {
	volatile.StoreUint32(&o.ISPR2.Reg, value)
}
func (o *NVIC_Type) GetISPR2() uint32 {
	return volatile.LoadUint32(&o.ISPR2.Reg)
}

// NVIC.ISPR3: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR3(value uint32) {
	volatile.StoreUint32(&o.ISPR3.Reg, value)
}
func (o *NVIC_Type) GetISPR3() uint32 {
	return volatile.LoadUint32(&o.ISPR3.Reg)
}

// NVIC.ICPR0: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR0(value uint32) {
	volatile.StoreUint32(&o.ICPR0.Reg, value)
}
func (o *NVIC_Type) GetICPR0() uint32 {
	return volatile.LoadUint32(&o.ICPR0.Reg)
}

// NVIC.ICPR1: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR1(value uint32) {
	volatile.StoreUint32(&o.ICPR1.Reg, value)
}
func (o *NVIC_Type) GetICPR1() uint32 {
	return volatile.LoadUint32(&o.ICPR1.Reg)
}

// NVIC.ICPR2: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR2(value uint32) {
	volatile.StoreUint32(&o.ICPR2.Reg, value)
}
func (o *NVIC_Type) GetICPR2() uint32 {
	return volatile.LoadUint32(&o.ICPR2.Reg)
}

// NVIC.ICPR3: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR3(value uint32) {
	volatile.StoreUint32(&o.ICPR3.Reg, value)
}
func (o *NVIC_Type) GetICPR3() uint32 {
	return volatile.LoadUint32(&o.ICPR3.Reg)
}

// NVIC.IABR0: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR0(value uint32) {
	volatile.StoreUint32(&o.IABR0.Reg, value)
}
func (o *NVIC_Type) GetIABR0() uint32 {
	return volatile.LoadUint32(&o.IABR0.Reg)
}

// NVIC.IABR1: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR1(value uint32) {
	volatile.StoreUint32(&o.IABR1.Reg, value)
}
func (o *NVIC_Type) GetIABR1() uint32 {
	return volatile.LoadUint32(&o.IABR1.Reg)
}

// NVIC.IABR2: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR2(value uint32) {
	volatile.StoreUint32(&o.IABR2.Reg, value)
}
func (o *NVIC_Type) GetIABR2() uint32 {
	return volatile.LoadUint32(&o.IABR2.Reg)
}

// NVIC.IABR3: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR3(value uint32) {
	volatile.StoreUint32(&o.IABR3.Reg, value)
}
func (o *NVIC_Type) GetIABR3() uint32 {
	return volatile.LoadUint32(&o.IABR3.Reg)
}

// NVIC.IPR0: Interrupt Priority Register
func (o *NVIC_Type) SetIPR0_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR0_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR0.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR0_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR0_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR0_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR0_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR0_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR0_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff000000) >> 24
}

// NVIC.IPR1: Interrupt Priority Register
func (o *NVIC_Type) SetIPR1_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR1_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR1.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR1_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR1_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR1_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR1_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR1_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR1_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff000000) >> 24
}

// NVIC.IPR2: Interrupt Priority Register
func (o *NVIC_Type) SetIPR2_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR2_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR2.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR2_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR2_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR2_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR2_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR2_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR2_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff000000) >> 24
}

// NVIC.IPR3: Interrupt Priority Register
func (o *NVIC_Type) SetIPR3_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR3_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR3.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR3_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR3_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR3_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR3_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR3_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR3_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff000000) >> 24
}

// NVIC.IPR4: Interrupt Priority Register
func (o *NVIC_Type) SetIPR4_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR4_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR4.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR4_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR4_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR4_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR4_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR4_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR4_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff000000) >> 24
}

// NVIC.IPR5: Interrupt Priority Register
func (o *NVIC_Type) SetIPR5_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR5_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR5.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR5_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR5_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR5_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR5_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR5_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR5_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff000000) >> 24
}

// NVIC.IPR6: Interrupt Priority Register
func (o *NVIC_Type) SetIPR6_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR6_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR6.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR6_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR6_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR6_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR6_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR6_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR6_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff000000) >> 24
}

// NVIC.IPR7: Interrupt Priority Register
func (o *NVIC_Type) SetIPR7_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR7_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR7.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR7_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR7_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR7_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR7_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR7_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR7_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff000000) >> 24
}

// NVIC.IPR8: Interrupt Priority Register
func (o *NVIC_Type) SetIPR8_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR8_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR8.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR8_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR8_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR8_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR8_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR8_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR8_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff000000) >> 24
}

// NVIC.IPR9: Interrupt Priority Register
func (o *NVIC_Type) SetIPR9_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR9_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR9.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR9_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR9_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR9_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR9_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR9_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR9_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff000000) >> 24
}

// NVIC.IPR10: Interrupt Priority Register
func (o *NVIC_Type) SetIPR10_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR10_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR10.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR10_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR10_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR10_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR10_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR10_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR10_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff000000) >> 24
}

// NVIC.IPR11: Interrupt Priority Register
func (o *NVIC_Type) SetIPR11_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR11_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR11.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR11_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR11_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR11_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR11_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR11_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR11_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff000000) >> 24
}

// NVIC.IPR12: Interrupt Priority Register
func (o *NVIC_Type) SetIPR12_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR12_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR12.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR12_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR12_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR12_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR12_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR12_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR12_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff000000) >> 24
}

// NVIC.IPR13: Interrupt Priority Register
func (o *NVIC_Type) SetIPR13_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR13_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR13.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR13_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR13_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR13_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR13_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR13_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR13_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff000000) >> 24
}

// NVIC.IPR14: Interrupt Priority Register
func (o *NVIC_Type) SetIPR14_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR14_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR14.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR14_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR14_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR14.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR14_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR14_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR14.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR14_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR14_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR14.Reg) & 0xff000000) >> 24
}

// NVIC.IPR15: Interrupt Priority Register
func (o *NVIC_Type) SetIPR15_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR15_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR15.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR15_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR15_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR15.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR15_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR15_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR15.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR15_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR15_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR15.Reg) & 0xff000000) >> 24
}

// NVIC.IPR16: Interrupt Priority Register
func (o *NVIC_Type) SetIPR16_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR16_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR16.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR16_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR16_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR16.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR16_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR16_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR16.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR16_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR16_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR16.Reg) & 0xff000000) >> 24
}

// NVIC.IPR17: Interrupt Priority Register
func (o *NVIC_Type) SetIPR17_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR17_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR17.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR17_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR17_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR17.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR17_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR17_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR17.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR17_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR17_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR17.Reg) & 0xff000000) >> 24
}

// NVIC.IPR18: Interrupt Priority Register
func (o *NVIC_Type) SetIPR18_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR18_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR18.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR18_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR18_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR18.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR18_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR18_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR18.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR18_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR18_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR18.Reg) & 0xff000000) >> 24
}

// NVIC.IPR19: Interrupt Priority Register
func (o *NVIC_Type) SetIPR19_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR19_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR19.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR19_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR19_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR19.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR19_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR19_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR19.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR19_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR19_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR19.Reg) & 0xff000000) >> 24
}

// NVIC.IPR20: Interrupt Priority Register
func (o *NVIC_Type) SetIPR20_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR20.Reg, volatile.LoadUint32(&o.IPR20.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR20_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR20.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR20_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR20.Reg, volatile.LoadUint32(&o.IPR20.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR20_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR20.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR20_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR20.Reg, volatile.LoadUint32(&o.IPR20.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR20_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR20.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR20_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR20.Reg, volatile.LoadUint32(&o.IPR20.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR20_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR20.Reg) & 0xff000000) >> 24
}

// FDCAN
type FDCAN_Type struct {
	CREL   volatile.Register32 // 0x0
	ENDN   volatile.Register32 // 0x4
	_      [4]byte
	DBTP   volatile.Register32 // 0xC
	TEST   volatile.Register32 // 0x10
	RWD    volatile.Register32 // 0x14
	CCCR   volatile.Register32 // 0x18
	NBTP   volatile.Register32 // 0x1C
	TSCC   volatile.Register32 // 0x20
	TSCV   volatile.Register32 // 0x24
	TOCC   volatile.Register32 // 0x28
	TOCV   volatile.Register32 // 0x2C
	_      [16]byte
	ECR    volatile.Register32 // 0x40
	PSR    volatile.Register32 // 0x44
	TDCR   volatile.Register32 // 0x48
	_      [4]byte
	IR     volatile.Register32 // 0x50
	IE     volatile.Register32 // 0x54
	ILS    volatile.Register32 // 0x58
	ILE    volatile.Register32 // 0x5C
	_      [32]byte
	RXGFC  volatile.Register32 // 0x80
	XIDAM  volatile.Register32 // 0x84
	HPMS   volatile.Register32 // 0x88
	_      [4]byte
	RXF0S  volatile.Register32 // 0x90
	RXF0A  volatile.Register32 // 0x94
	RXF1S  volatile.Register32 // 0x98
	RXF1A  volatile.Register32 // 0x9C
	_      [32]byte
	TXBC   volatile.Register32 // 0xC0
	TXFQS  volatile.Register32 // 0xC4
	TXBRP  volatile.Register32 // 0xC8
	TXBAR  volatile.Register32 // 0xCC
	TXBCR  volatile.Register32 // 0xD0
	TXBTO  volatile.Register32 // 0xD4
	TXBCF  volatile.Register32 // 0xD8
	TXBTIE volatile.Register32 // 0xDC
	TXBCIE volatile.Register32 // 0xE0
	TXEFS  volatile.Register32 // 0xE4
	TXEFA  volatile.Register32 // 0xE8
	_      [20]byte
	CKDIV  volatile.Register32 // 0x100
}

// FDCAN.CREL: FDCAN Core Release Register
func (o *FDCAN_Type) SetCREL_DAY(value uint32) {
	volatile.StoreUint32(&o.CREL.Reg, volatile.LoadUint32(&o.CREL.Reg)&^(0xff)|value)
}
func (o *FDCAN_Type) GetCREL_DAY() uint32 {
	return volatile.LoadUint32(&o.CREL.Reg) & 0xff
}
func (o *FDCAN_Type) SetCREL_MON(value uint32) {
	volatile.StoreUint32(&o.CREL.Reg, volatile.LoadUint32(&o.CREL.Reg)&^(0xff00)|value<<8)
}
func (o *FDCAN_Type) GetCREL_MON() uint32 {
	return (volatile.LoadUint32(&o.CREL.Reg) & 0xff00) >> 8
}
func (o *FDCAN_Type) SetCREL_YEAR(value uint32) {
	volatile.StoreUint32(&o.CREL.Reg, volatile.LoadUint32(&o.CREL.Reg)&^(0xf0000)|value<<16)
}
func (o *FDCAN_Type) GetCREL_YEAR() uint32 {
	return (volatile.LoadUint32(&o.CREL.Reg) & 0xf0000) >> 16
}
func (o *FDCAN_Type) SetCREL_SUBSTEP(value uint32) {
	volatile.StoreUint32(&o.CREL.Reg, volatile.LoadUint32(&o.CREL.Reg)&^(0xf00000)|value<<20)
}
func (o *FDCAN_Type) GetCREL_SUBSTEP() uint32 {
	return (volatile.LoadUint32(&o.CREL.Reg) & 0xf00000) >> 20
}
func (o *FDCAN_Type) SetCREL_STEP(value uint32) {
	volatile.StoreUint32(&o.CREL.Reg, volatile.LoadUint32(&o.CREL.Reg)&^(0xf000000)|value<<24)
}
func (o *FDCAN_Type) GetCREL_STEP() uint32 {
	return (volatile.LoadUint32(&o.CREL.Reg) & 0xf000000) >> 24
}
func (o *FDCAN_Type) SetCREL_REL(value uint32) {
	volatile.StoreUint32(&o.CREL.Reg, volatile.LoadUint32(&o.CREL.Reg)&^(0xf0000000)|value<<28)
}
func (o *FDCAN_Type) GetCREL_REL() uint32 {
	return (volatile.LoadUint32(&o.CREL.Reg) & 0xf0000000) >> 28
}

// FDCAN.ENDN: FDCAN Core Release Register
func (o *FDCAN_Type) SetENDN(value uint32) {
	volatile.StoreUint32(&o.ENDN.Reg, value)
}
func (o *FDCAN_Type) GetENDN() uint32 {
	return volatile.LoadUint32(&o.ENDN.Reg)
}

// FDCAN.DBTP: This register is only writable if bits CCCR.CCE and CCCR.INIT are set. The CAN bit time may be programed in the range of 4 to 25 time quanta. The CAN time quantum may be programmed in the range of 1 to 1024 FDCAN clock periods. tq = (DBRP + 1) FDCAN clock period. DTSEG1 is the sum of Prop_Seg and Phase_Seg1. DTSEG2 is Phase_Seg2. Therefore the length of the bit time is (programmed values) [DTSEG1 + DTSEG2 + 3] tq or (functional values) [Sync_Seg + Prop_Seg + Phase_Seg1 + Phase_Seg2] tq. The Information Processing Time (IPT) is zero, meaning the data for the next bit is available at the first clock edge after the sample point.
func (o *FDCAN_Type) SetDBTP_DSJW(value uint32) {
	volatile.StoreUint32(&o.DBTP.Reg, volatile.LoadUint32(&o.DBTP.Reg)&^(0xf)|value)
}
func (o *FDCAN_Type) GetDBTP_DSJW() uint32 {
	return volatile.LoadUint32(&o.DBTP.Reg) & 0xf
}
func (o *FDCAN_Type) SetDBTP_DTSEG2(value uint32) {
	volatile.StoreUint32(&o.DBTP.Reg, volatile.LoadUint32(&o.DBTP.Reg)&^(0xf0)|value<<4)
}
func (o *FDCAN_Type) GetDBTP_DTSEG2() uint32 {
	return (volatile.LoadUint32(&o.DBTP.Reg) & 0xf0) >> 4
}
func (o *FDCAN_Type) SetDBTP_DTSEG1(value uint32) {
	volatile.StoreUint32(&o.DBTP.Reg, volatile.LoadUint32(&o.DBTP.Reg)&^(0x1f00)|value<<8)
}
func (o *FDCAN_Type) GetDBTP_DTSEG1() uint32 {
	return (volatile.LoadUint32(&o.DBTP.Reg) & 0x1f00) >> 8
}
func (o *FDCAN_Type) SetDBTP_DBRP(value uint32) {
	volatile.StoreUint32(&o.DBTP.Reg, volatile.LoadUint32(&o.DBTP.Reg)&^(0x1f0000)|value<<16)
}
func (o *FDCAN_Type) GetDBTP_DBRP() uint32 {
	return (volatile.LoadUint32(&o.DBTP.Reg) & 0x1f0000) >> 16
}
func (o *FDCAN_Type) SetDBTP_TDC(value uint32) {
	volatile.StoreUint32(&o.DBTP.Reg, volatile.LoadUint32(&o.DBTP.Reg)&^(0x800000)|value<<23)
}
func (o *FDCAN_Type) GetDBTP_TDC() uint32 {
	return (volatile.LoadUint32(&o.DBTP.Reg) & 0x800000) >> 23
}

// FDCAN.TEST: Write access to the Test Register has to be enabled by setting bit CCCR[TEST] to 1 . All Test Register functions are set to their reset values when bit CCCR[TEST] is reset. Loop Back mode and software control of Tx pin FDCANx_TX are hardware test modes. Programming TX differently from 00 may disturb the message transfer on the CAN bus.
func (o *FDCAN_Type) SetTEST_LBCK(value uint32) {
	volatile.StoreUint32(&o.TEST.Reg, volatile.LoadUint32(&o.TEST.Reg)&^(0x10)|value<<4)
}
func (o *FDCAN_Type) GetTEST_LBCK() uint32 {
	return (volatile.LoadUint32(&o.TEST.Reg) & 0x10) >> 4
}
func (o *FDCAN_Type) SetTEST_TX(value uint32) {
	volatile.StoreUint32(&o.TEST.Reg, volatile.LoadUint32(&o.TEST.Reg)&^(0x60)|value<<5)
}
func (o *FDCAN_Type) GetTEST_TX() uint32 {
	return (volatile.LoadUint32(&o.TEST.Reg) & 0x60) >> 5
}
func (o *FDCAN_Type) SetTEST_RX(value uint32) {
	volatile.StoreUint32(&o.TEST.Reg, volatile.LoadUint32(&o.TEST.Reg)&^(0x80)|value<<7)
}
func (o *FDCAN_Type) GetTEST_RX() uint32 {
	return (volatile.LoadUint32(&o.TEST.Reg) & 0x80) >> 7
}

// FDCAN.RWD: The RAM Watchdog monitors the READY output of the Message RAM. A Message RAM access starts the Message RAM Watchdog Counter with the value configured by the RWD[WDC] bits. The counter is reloaded with RWD[WDC] bits when the Message RAM signals successful completion by activating its READY output. In case there is no response from the Message RAM until the counter has counted down to 0, the counter stops and interrupt flag IR[WDI] bit is set. The RAM Watchdog Counter is clocked by the fdcan_pclk clock.
func (o *FDCAN_Type) SetRWD_WDC(value uint32) {
	volatile.StoreUint32(&o.RWD.Reg, volatile.LoadUint32(&o.RWD.Reg)&^(0xff)|value)
}
func (o *FDCAN_Type) GetRWD_WDC() uint32 {
	return volatile.LoadUint32(&o.RWD.Reg) & 0xff
}
func (o *FDCAN_Type) SetRWD_WDV(value uint32) {
	volatile.StoreUint32(&o.RWD.Reg, volatile.LoadUint32(&o.RWD.Reg)&^(0xff00)|value<<8)
}
func (o *FDCAN_Type) GetRWD_WDV() uint32 {
	return (volatile.LoadUint32(&o.RWD.Reg) & 0xff00) >> 8
}

// FDCAN.CCCR: For details about setting and resetting of single bits see Software initialization.
func (o *FDCAN_Type) SetCCCR_INIT(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x1)|value)
}
func (o *FDCAN_Type) GetCCCR_INIT() uint32 {
	return volatile.LoadUint32(&o.CCCR.Reg) & 0x1
}
func (o *FDCAN_Type) SetCCCR_CCE(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x2)|value<<1)
}
func (o *FDCAN_Type) GetCCCR_CCE() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x2) >> 1
}
func (o *FDCAN_Type) SetCCCR_ASM(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x4)|value<<2)
}
func (o *FDCAN_Type) GetCCCR_ASM() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x4) >> 2
}
func (o *FDCAN_Type) SetCCCR_CSA(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x8)|value<<3)
}
func (o *FDCAN_Type) GetCCCR_CSA() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x8) >> 3
}
func (o *FDCAN_Type) SetCCCR_CSR(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x10)|value<<4)
}
func (o *FDCAN_Type) GetCCCR_CSR() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x10) >> 4
}
func (o *FDCAN_Type) SetCCCR_MON(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x20)|value<<5)
}
func (o *FDCAN_Type) GetCCCR_MON() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x20) >> 5
}
func (o *FDCAN_Type) SetCCCR_DAR(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x40)|value<<6)
}
func (o *FDCAN_Type) GetCCCR_DAR() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x40) >> 6
}
func (o *FDCAN_Type) SetCCCR_TEST(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x80)|value<<7)
}
func (o *FDCAN_Type) GetCCCR_TEST() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x80) >> 7
}
func (o *FDCAN_Type) SetCCCR_FDOE(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x100)|value<<8)
}
func (o *FDCAN_Type) GetCCCR_FDOE() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x100) >> 8
}
func (o *FDCAN_Type) SetCCCR_BRSE(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x200)|value<<9)
}
func (o *FDCAN_Type) GetCCCR_BRSE() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x200) >> 9
}
func (o *FDCAN_Type) SetCCCR_PXHD(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x1000)|value<<12)
}
func (o *FDCAN_Type) GetCCCR_PXHD() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x1000) >> 12
}
func (o *FDCAN_Type) SetCCCR_EFBI(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x2000)|value<<13)
}
func (o *FDCAN_Type) GetCCCR_EFBI() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x2000) >> 13
}
func (o *FDCAN_Type) SetCCCR_TXP(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x4000)|value<<14)
}
func (o *FDCAN_Type) GetCCCR_TXP() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x4000) >> 14
}
func (o *FDCAN_Type) SetCCCR_NISO(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x8000)|value<<15)
}
func (o *FDCAN_Type) GetCCCR_NISO() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x8000) >> 15
}

// FDCAN.NBTP: FDCAN_NBTP
func (o *FDCAN_Type) SetNBTP_NTSEG2(value uint32) {
	volatile.StoreUint32(&o.NBTP.Reg, volatile.LoadUint32(&o.NBTP.Reg)&^(0x7f)|value)
}
func (o *FDCAN_Type) GetNBTP_NTSEG2() uint32 {
	return volatile.LoadUint32(&o.NBTP.Reg) & 0x7f
}
func (o *FDCAN_Type) SetNBTP_NTSEG1(value uint32) {
	volatile.StoreUint32(&o.NBTP.Reg, volatile.LoadUint32(&o.NBTP.Reg)&^(0xff00)|value<<8)
}
func (o *FDCAN_Type) GetNBTP_NTSEG1() uint32 {
	return (volatile.LoadUint32(&o.NBTP.Reg) & 0xff00) >> 8
}
func (o *FDCAN_Type) SetNBTP_NBRP(value uint32) {
	volatile.StoreUint32(&o.NBTP.Reg, volatile.LoadUint32(&o.NBTP.Reg)&^(0x1ff0000)|value<<16)
}
func (o *FDCAN_Type) GetNBTP_NBRP() uint32 {
	return (volatile.LoadUint32(&o.NBTP.Reg) & 0x1ff0000) >> 16
}
func (o *FDCAN_Type) SetNBTP_NSJW(value uint32) {
	volatile.StoreUint32(&o.NBTP.Reg, volatile.LoadUint32(&o.NBTP.Reg)&^(0xfe000000)|value<<25)
}
func (o *FDCAN_Type) GetNBTP_NSJW() uint32 {
	return (volatile.LoadUint32(&o.NBTP.Reg) & 0xfe000000) >> 25
}

// FDCAN.TSCC: FDCAN Timestamp Counter Configuration Register
func (o *FDCAN_Type) SetTSCC_TSS(value uint32) {
	volatile.StoreUint32(&o.TSCC.Reg, volatile.LoadUint32(&o.TSCC.Reg)&^(0x3)|value)
}
func (o *FDCAN_Type) GetTSCC_TSS() uint32 {
	return volatile.LoadUint32(&o.TSCC.Reg) & 0x3
}
func (o *FDCAN_Type) SetTSCC_TCP(value uint32) {
	volatile.StoreUint32(&o.TSCC.Reg, volatile.LoadUint32(&o.TSCC.Reg)&^(0xf0000)|value<<16)
}
func (o *FDCAN_Type) GetTSCC_TCP() uint32 {
	return (volatile.LoadUint32(&o.TSCC.Reg) & 0xf0000) >> 16
}

// FDCAN.TSCV: FDCAN Timestamp Counter Value Register
func (o *FDCAN_Type) SetTSCV_TSC(value uint32) {
	volatile.StoreUint32(&o.TSCV.Reg, volatile.LoadUint32(&o.TSCV.Reg)&^(0xffff)|value)
}
func (o *FDCAN_Type) GetTSCV_TSC() uint32 {
	return volatile.LoadUint32(&o.TSCV.Reg) & 0xffff
}

// FDCAN.TOCC: FDCAN Timeout Counter Configuration Register
func (o *FDCAN_Type) SetTOCC_ETOC(value uint32) {
	volatile.StoreUint32(&o.TOCC.Reg, volatile.LoadUint32(&o.TOCC.Reg)&^(0x1)|value)
}
func (o *FDCAN_Type) GetTOCC_ETOC() uint32 {
	return volatile.LoadUint32(&o.TOCC.Reg) & 0x1
}
func (o *FDCAN_Type) SetTOCC_TOS(value uint32) {
	volatile.StoreUint32(&o.TOCC.Reg, volatile.LoadUint32(&o.TOCC.Reg)&^(0x6)|value<<1)
}
func (o *FDCAN_Type) GetTOCC_TOS() uint32 {
	return (volatile.LoadUint32(&o.TOCC.Reg) & 0x6) >> 1
}
func (o *FDCAN_Type) SetTOCC_TOP(value uint32) {
	volatile.StoreUint32(&o.TOCC.Reg, volatile.LoadUint32(&o.TOCC.Reg)&^(0xffff0000)|value<<16)
}
func (o *FDCAN_Type) GetTOCC_TOP() uint32 {
	return (volatile.LoadUint32(&o.TOCC.Reg) & 0xffff0000) >> 16
}

// FDCAN.TOCV: FDCAN Timeout Counter Value Register
func (o *FDCAN_Type) SetTOCV_TOC(value uint32) {
	volatile.StoreUint32(&o.TOCV.Reg, volatile.LoadUint32(&o.TOCV.Reg)&^(0xffff)|value)
}
func (o *FDCAN_Type) GetTOCV_TOC() uint32 {
	return volatile.LoadUint32(&o.TOCV.Reg) & 0xffff
}

// FDCAN.ECR: FDCAN Error Counter Register
func (o *FDCAN_Type) SetECR_TEC(value uint32) {
	volatile.StoreUint32(&o.ECR.Reg, volatile.LoadUint32(&o.ECR.Reg)&^(0xff)|value)
}
func (o *FDCAN_Type) GetECR_TEC() uint32 {
	return volatile.LoadUint32(&o.ECR.Reg) & 0xff
}
func (o *FDCAN_Type) SetECR_REC(value uint32) {
	volatile.StoreUint32(&o.ECR.Reg, volatile.LoadUint32(&o.ECR.Reg)&^(0x7f00)|value<<8)
}
func (o *FDCAN_Type) GetECR_REC() uint32 {
	return (volatile.LoadUint32(&o.ECR.Reg) & 0x7f00) >> 8
}
func (o *FDCAN_Type) SetECR_RP(value uint32) {
	volatile.StoreUint32(&o.ECR.Reg, volatile.LoadUint32(&o.ECR.Reg)&^(0x8000)|value<<15)
}
func (o *FDCAN_Type) GetECR_RP() uint32 {
	return (volatile.LoadUint32(&o.ECR.Reg) & 0x8000) >> 15
}
func (o *FDCAN_Type) SetECR_CEL(value uint32) {
	volatile.StoreUint32(&o.ECR.Reg, volatile.LoadUint32(&o.ECR.Reg)&^(0xff0000)|value<<16)
}
func (o *FDCAN_Type) GetECR_CEL() uint32 {
	return (volatile.LoadUint32(&o.ECR.Reg) & 0xff0000) >> 16
}

// FDCAN.PSR: FDCAN Protocol Status Register
func (o *FDCAN_Type) SetPSR_LEC(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x7)|value)
}
func (o *FDCAN_Type) GetPSR_LEC() uint32 {
	return volatile.LoadUint32(&o.PSR.Reg) & 0x7
}
func (o *FDCAN_Type) SetPSR_ACT(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x18)|value<<3)
}
func (o *FDCAN_Type) GetPSR_ACT() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x18) >> 3
}
func (o *FDCAN_Type) SetPSR_EP(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20)|value<<5)
}
func (o *FDCAN_Type) GetPSR_EP() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20) >> 5
}
func (o *FDCAN_Type) SetPSR_EW(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40)|value<<6)
}
func (o *FDCAN_Type) GetPSR_EW() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40) >> 6
}
func (o *FDCAN_Type) SetPSR_BO(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80)|value<<7)
}
func (o *FDCAN_Type) GetPSR_BO() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80) >> 7
}
func (o *FDCAN_Type) SetPSR_DLEC(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x700)|value<<8)
}
func (o *FDCAN_Type) GetPSR_DLEC() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x700) >> 8
}
func (o *FDCAN_Type) SetPSR_RESI(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x800)|value<<11)
}
func (o *FDCAN_Type) GetPSR_RESI() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x800) >> 11
}
func (o *FDCAN_Type) SetPSR_RBRS(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1000)|value<<12)
}
func (o *FDCAN_Type) GetPSR_RBRS() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x1000) >> 12
}
func (o *FDCAN_Type) SetPSR_REDL(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2000)|value<<13)
}
func (o *FDCAN_Type) GetPSR_REDL() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2000) >> 13
}
func (o *FDCAN_Type) SetPSR_PXE(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4000)|value<<14)
}
func (o *FDCAN_Type) GetPSR_PXE() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4000) >> 14
}
func (o *FDCAN_Type) SetPSR_TDCV(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x7f0000)|value<<16)
}
func (o *FDCAN_Type) GetPSR_TDCV() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x7f0000) >> 16
}

// FDCAN.TDCR: FDCAN Transmitter Delay Compensation Register
func (o *FDCAN_Type) SetTDCR_TDCF(value uint32) {
	volatile.StoreUint32(&o.TDCR.Reg, volatile.LoadUint32(&o.TDCR.Reg)&^(0x7f)|value)
}
func (o *FDCAN_Type) GetTDCR_TDCF() uint32 {
	return volatile.LoadUint32(&o.TDCR.Reg) & 0x7f
}
func (o *FDCAN_Type) SetTDCR_TDCO(value uint32) {
	volatile.StoreUint32(&o.TDCR.Reg, volatile.LoadUint32(&o.TDCR.Reg)&^(0x7f00)|value<<8)
}
func (o *FDCAN_Type) GetTDCR_TDCO() uint32 {
	return (volatile.LoadUint32(&o.TDCR.Reg) & 0x7f00) >> 8
}

// FDCAN.IR: The flags are set when one of the listed conditions is detected (edge-sensitive). The flags remain set until the Host clears them. A flag is cleared by writing a 1 to the corresponding bit position. Writing a 0 has no effect. A hard reset will clear the register. The configuration of IE controls whether an interrupt is generated. The configuration of ILS controls on which interrupt line an interrupt is signaled.
func (o *FDCAN_Type) SetIR_RF0N(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x1)|value)
}
func (o *FDCAN_Type) GetIR_RF0N() uint32 {
	return volatile.LoadUint32(&o.IR.Reg) & 0x1
}
func (o *FDCAN_Type) SetIR_RF0F(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x2)|value<<1)
}
func (o *FDCAN_Type) GetIR_RF0F() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x2) >> 1
}
func (o *FDCAN_Type) SetIR_RF0L(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x4)|value<<2)
}
func (o *FDCAN_Type) GetIR_RF0L() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x4) >> 2
}
func (o *FDCAN_Type) SetIR_RF1N(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x8)|value<<3)
}
func (o *FDCAN_Type) GetIR_RF1N() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x8) >> 3
}
func (o *FDCAN_Type) SetIR_RF1F(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x10)|value<<4)
}
func (o *FDCAN_Type) GetIR_RF1F() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x10) >> 4
}
func (o *FDCAN_Type) SetIR_RF1L(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x20)|value<<5)
}
func (o *FDCAN_Type) GetIR_RF1L() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x20) >> 5
}
func (o *FDCAN_Type) SetIR_HPM(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x40)|value<<6)
}
func (o *FDCAN_Type) GetIR_HPM() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x40) >> 6
}
func (o *FDCAN_Type) SetIR_TC(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x80)|value<<7)
}
func (o *FDCAN_Type) GetIR_TC() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x80) >> 7
}
func (o *FDCAN_Type) SetIR_TCF(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x100)|value<<8)
}
func (o *FDCAN_Type) GetIR_TCF() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x100) >> 8
}
func (o *FDCAN_Type) SetIR_TFE(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x200)|value<<9)
}
func (o *FDCAN_Type) GetIR_TFE() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x200) >> 9
}
func (o *FDCAN_Type) SetIR_TEFN(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x400)|value<<10)
}
func (o *FDCAN_Type) GetIR_TEFN() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x400) >> 10
}
func (o *FDCAN_Type) SetIR_TEFF(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x800)|value<<11)
}
func (o *FDCAN_Type) GetIR_TEFF() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x800) >> 11
}
func (o *FDCAN_Type) SetIR_TEFL(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x1000)|value<<12)
}
func (o *FDCAN_Type) GetIR_TEFL() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x1000) >> 12
}
func (o *FDCAN_Type) SetIR_TSW(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x2000)|value<<13)
}
func (o *FDCAN_Type) GetIR_TSW() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x2000) >> 13
}
func (o *FDCAN_Type) SetIR_MRAF(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x4000)|value<<14)
}
func (o *FDCAN_Type) GetIR_MRAF() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x4000) >> 14
}
func (o *FDCAN_Type) SetIR_TOO(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x8000)|value<<15)
}
func (o *FDCAN_Type) GetIR_TOO() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x8000) >> 15
}
func (o *FDCAN_Type) SetIR_ELO(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x10000)|value<<16)
}
func (o *FDCAN_Type) GetIR_ELO() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x10000) >> 16
}
func (o *FDCAN_Type) SetIR_EP(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x20000)|value<<17)
}
func (o *FDCAN_Type) GetIR_EP() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x20000) >> 17
}
func (o *FDCAN_Type) SetIR_EW(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x40000)|value<<18)
}
func (o *FDCAN_Type) GetIR_EW() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x40000) >> 18
}
func (o *FDCAN_Type) SetIR_BO(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x80000)|value<<19)
}
func (o *FDCAN_Type) GetIR_BO() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x80000) >> 19
}
func (o *FDCAN_Type) SetIR_WDI(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x100000)|value<<20)
}
func (o *FDCAN_Type) GetIR_WDI() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x100000) >> 20
}
func (o *FDCAN_Type) SetIR_PEA(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x200000)|value<<21)
}
func (o *FDCAN_Type) GetIR_PEA() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x200000) >> 21
}
func (o *FDCAN_Type) SetIR_PED(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x400000)|value<<22)
}
func (o *FDCAN_Type) GetIR_PED() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x400000) >> 22
}
func (o *FDCAN_Type) SetIR_ARA(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x800000)|value<<23)
}
func (o *FDCAN_Type) GetIR_ARA() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x800000) >> 23
}

// FDCAN.IE: The settings in the Interrupt Enable register determine which status changes in the Interrupt Register will be signaled on an interrupt line.
func (o *FDCAN_Type) SetIE_RF0NE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x1)|value)
}
func (o *FDCAN_Type) GetIE_RF0NE() uint32 {
	return volatile.LoadUint32(&o.IE.Reg) & 0x1
}
func (o *FDCAN_Type) SetIE_RF0FE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x2)|value<<1)
}
func (o *FDCAN_Type) GetIE_RF0FE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x2) >> 1
}
func (o *FDCAN_Type) SetIE_RF0LE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x4)|value<<2)
}
func (o *FDCAN_Type) GetIE_RF0LE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x4) >> 2
}
func (o *FDCAN_Type) SetIE_RF1NE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x8)|value<<3)
}
func (o *FDCAN_Type) GetIE_RF1NE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x8) >> 3
}
func (o *FDCAN_Type) SetIE_RF1FE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x10)|value<<4)
}
func (o *FDCAN_Type) GetIE_RF1FE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x10) >> 4
}
func (o *FDCAN_Type) SetIE_RF1LE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x20)|value<<5)
}
func (o *FDCAN_Type) GetIE_RF1LE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x20) >> 5
}
func (o *FDCAN_Type) SetIE_HPME(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x40)|value<<6)
}
func (o *FDCAN_Type) GetIE_HPME() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x40) >> 6
}
func (o *FDCAN_Type) SetIE_TCE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x80)|value<<7)
}
func (o *FDCAN_Type) GetIE_TCE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x80) >> 7
}
func (o *FDCAN_Type) SetIE_TCFE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x100)|value<<8)
}
func (o *FDCAN_Type) GetIE_TCFE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x100) >> 8
}
func (o *FDCAN_Type) SetIE_TFEE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x200)|value<<9)
}
func (o *FDCAN_Type) GetIE_TFEE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x200) >> 9
}
func (o *FDCAN_Type) SetIE_TEFNE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x400)|value<<10)
}
func (o *FDCAN_Type) GetIE_TEFNE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x400) >> 10
}
func (o *FDCAN_Type) SetIE_TEFFE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x800)|value<<11)
}
func (o *FDCAN_Type) GetIE_TEFFE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x800) >> 11
}
func (o *FDCAN_Type) SetIE_TEFLE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x1000)|value<<12)
}
func (o *FDCAN_Type) GetIE_TEFLE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x1000) >> 12
}
func (o *FDCAN_Type) SetIE_TSWE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x2000)|value<<13)
}
func (o *FDCAN_Type) GetIE_TSWE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x2000) >> 13
}
func (o *FDCAN_Type) SetIE_MRAFE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x4000)|value<<14)
}
func (o *FDCAN_Type) GetIE_MRAFE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x4000) >> 14
}
func (o *FDCAN_Type) SetIE_TOOE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x8000)|value<<15)
}
func (o *FDCAN_Type) GetIE_TOOE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x8000) >> 15
}
func (o *FDCAN_Type) SetIE_ELOE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x10000)|value<<16)
}
func (o *FDCAN_Type) GetIE_ELOE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x10000) >> 16
}
func (o *FDCAN_Type) SetIE_EPE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x20000)|value<<17)
}
func (o *FDCAN_Type) GetIE_EPE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x20000) >> 17
}
func (o *FDCAN_Type) SetIE_EWE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x40000)|value<<18)
}
func (o *FDCAN_Type) GetIE_EWE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x40000) >> 18
}
func (o *FDCAN_Type) SetIE_BOE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x80000)|value<<19)
}
func (o *FDCAN_Type) GetIE_BOE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x80000) >> 19
}
func (o *FDCAN_Type) SetIE_WDIE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x100000)|value<<20)
}
func (o *FDCAN_Type) GetIE_WDIE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x100000) >> 20
}
func (o *FDCAN_Type) SetIE_PEAE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x200000)|value<<21)
}
func (o *FDCAN_Type) GetIE_PEAE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x200000) >> 21
}
func (o *FDCAN_Type) SetIE_PEDE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x400000)|value<<22)
}
func (o *FDCAN_Type) GetIE_PEDE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x400000) >> 22
}
func (o *FDCAN_Type) SetIE_ARAE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x800000)|value<<23)
}
func (o *FDCAN_Type) GetIE_ARAE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x800000) >> 23
}

// FDCAN.ILS: The Interrupt Line Select register assigns an interrupt generated by a specific interrupt flag from the Interrupt Register to one of the two module interrupt lines. For interrupt generation the respective interrupt line has to be enabled via ILE[EINT0] and ILE[EINT1].
func (o *FDCAN_Type) SetILS_RXFIFO0(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x1)|value)
}
func (o *FDCAN_Type) GetILS_RXFIFO0() uint32 {
	return volatile.LoadUint32(&o.ILS.Reg) & 0x1
}
func (o *FDCAN_Type) SetILS_RXFIFO1(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x2)|value<<1)
}
func (o *FDCAN_Type) GetILS_RXFIFO1() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x2) >> 1
}
func (o *FDCAN_Type) SetILS_SMSG(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x4)|value<<2)
}
func (o *FDCAN_Type) GetILS_SMSG() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x4) >> 2
}
func (o *FDCAN_Type) SetILS_TFERR(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x8)|value<<3)
}
func (o *FDCAN_Type) GetILS_TFERR() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x8) >> 3
}
func (o *FDCAN_Type) SetILS_MISC(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x10)|value<<4)
}
func (o *FDCAN_Type) GetILS_MISC() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x10) >> 4
}
func (o *FDCAN_Type) SetILS_BERR(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x20)|value<<5)
}
func (o *FDCAN_Type) GetILS_BERR() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x20) >> 5
}
func (o *FDCAN_Type) SetILS_PERR(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x40)|value<<6)
}
func (o *FDCAN_Type) GetILS_PERR() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x40) >> 6
}

// FDCAN.ILE: Each of the two interrupt lines to the CPU can be enabled/disabled separately by programming bits EINT0 and EINT1.
func (o *FDCAN_Type) SetILE_EINT0(value uint32) {
	volatile.StoreUint32(&o.ILE.Reg, volatile.LoadUint32(&o.ILE.Reg)&^(0x1)|value)
}
func (o *FDCAN_Type) GetILE_EINT0() uint32 {
	return volatile.LoadUint32(&o.ILE.Reg) & 0x1
}
func (o *FDCAN_Type) SetILE_EINT1(value uint32) {
	volatile.StoreUint32(&o.ILE.Reg, volatile.LoadUint32(&o.ILE.Reg)&^(0x2)|value<<1)
}
func (o *FDCAN_Type) GetILE_EINT1() uint32 {
	return (volatile.LoadUint32(&o.ILE.Reg) & 0x2) >> 1
}

// FDCAN.RXGFC: Global settings for Message ID filtering. The Global Filter Configuration controls the filter path for standard and extended messages as described in Figure706: Standard Message ID filter path and Figure707: Extended Message ID filter path.
func (o *FDCAN_Type) SetRXGFC_RRFE(value uint32) {
	volatile.StoreUint32(&o.RXGFC.Reg, volatile.LoadUint32(&o.RXGFC.Reg)&^(0x1)|value)
}
func (o *FDCAN_Type) GetRXGFC_RRFE() uint32 {
	return volatile.LoadUint32(&o.RXGFC.Reg) & 0x1
}
func (o *FDCAN_Type) SetRXGFC_RRFS(value uint32) {
	volatile.StoreUint32(&o.RXGFC.Reg, volatile.LoadUint32(&o.RXGFC.Reg)&^(0x2)|value<<1)
}
func (o *FDCAN_Type) GetRXGFC_RRFS() uint32 {
	return (volatile.LoadUint32(&o.RXGFC.Reg) & 0x2) >> 1
}
func (o *FDCAN_Type) SetRXGFC_ANFE(value uint32) {
	volatile.StoreUint32(&o.RXGFC.Reg, volatile.LoadUint32(&o.RXGFC.Reg)&^(0xc)|value<<2)
}
func (o *FDCAN_Type) GetRXGFC_ANFE() uint32 {
	return (volatile.LoadUint32(&o.RXGFC.Reg) & 0xc) >> 2
}
func (o *FDCAN_Type) SetRXGFC_ANFS(value uint32) {
	volatile.StoreUint32(&o.RXGFC.Reg, volatile.LoadUint32(&o.RXGFC.Reg)&^(0x30)|value<<4)
}
func (o *FDCAN_Type) GetRXGFC_ANFS() uint32 {
	return (volatile.LoadUint32(&o.RXGFC.Reg) & 0x30) >> 4
}
func (o *FDCAN_Type) SetRXGFC_LSE(value uint32) {
	volatile.StoreUint32(&o.RXGFC.Reg, volatile.LoadUint32(&o.RXGFC.Reg)&^(0xf000000)|value<<24)
}
func (o *FDCAN_Type) GetRXGFC_LSE() uint32 {
	return (volatile.LoadUint32(&o.RXGFC.Reg) & 0xf000000) >> 24
}
func (o *FDCAN_Type) SetRXGFC_LSS(value uint32) {
	volatile.StoreUint32(&o.RXGFC.Reg, volatile.LoadUint32(&o.RXGFC.Reg)&^(0x1f0000)|value<<16)
}
func (o *FDCAN_Type) GetRXGFC_LSS() uint32 {
	return (volatile.LoadUint32(&o.RXGFC.Reg) & 0x1f0000) >> 16
}
func (o *FDCAN_Type) SetRXGFC_F0OM(value uint32) {
	volatile.StoreUint32(&o.RXGFC.Reg, volatile.LoadUint32(&o.RXGFC.Reg)&^(0x200)|value<<9)
}
func (o *FDCAN_Type) GetRXGFC_F0OM() uint32 {
	return (volatile.LoadUint32(&o.RXGFC.Reg) & 0x200) >> 9
}
func (o *FDCAN_Type) SetRXGFC_F1OM(value uint32) {
	volatile.StoreUint32(&o.RXGFC.Reg, volatile.LoadUint32(&o.RXGFC.Reg)&^(0x100)|value<<8)
}
func (o *FDCAN_Type) GetRXGFC_F1OM() uint32 {
	return (volatile.LoadUint32(&o.RXGFC.Reg) & 0x100) >> 8
}

// FDCAN.XIDAM: FDCAN Extended ID and Mask Register
func (o *FDCAN_Type) SetXIDAM_EIDM(value uint32) {
	volatile.StoreUint32(&o.XIDAM.Reg, volatile.LoadUint32(&o.XIDAM.Reg)&^(0x1fffffff)|value)
}
func (o *FDCAN_Type) GetXIDAM_EIDM() uint32 {
	return volatile.LoadUint32(&o.XIDAM.Reg) & 0x1fffffff
}

// FDCAN.HPMS: This register is updated every time a Message ID filter element configured to generate a priority event match. This can be used to monitor the status of incoming high priority messages and to enable fast access to these messages.
func (o *FDCAN_Type) SetHPMS_BIDX(value uint32) {
	volatile.StoreUint32(&o.HPMS.Reg, volatile.LoadUint32(&o.HPMS.Reg)&^(0x3f)|value)
}
func (o *FDCAN_Type) GetHPMS_BIDX() uint32 {
	return volatile.LoadUint32(&o.HPMS.Reg) & 0x3f
}
func (o *FDCAN_Type) SetHPMS_MSI(value uint32) {
	volatile.StoreUint32(&o.HPMS.Reg, volatile.LoadUint32(&o.HPMS.Reg)&^(0xc0)|value<<6)
}
func (o *FDCAN_Type) GetHPMS_MSI() uint32 {
	return (volatile.LoadUint32(&o.HPMS.Reg) & 0xc0) >> 6
}
func (o *FDCAN_Type) SetHPMS_FIDX(value uint32) {
	volatile.StoreUint32(&o.HPMS.Reg, volatile.LoadUint32(&o.HPMS.Reg)&^(0x7f00)|value<<8)
}
func (o *FDCAN_Type) GetHPMS_FIDX() uint32 {
	return (volatile.LoadUint32(&o.HPMS.Reg) & 0x7f00) >> 8
}
func (o *FDCAN_Type) SetHPMS_FLST(value uint32) {
	volatile.StoreUint32(&o.HPMS.Reg, volatile.LoadUint32(&o.HPMS.Reg)&^(0x8000)|value<<15)
}
func (o *FDCAN_Type) GetHPMS_FLST() uint32 {
	return (volatile.LoadUint32(&o.HPMS.Reg) & 0x8000) >> 15
}

// FDCAN.RXF0S: FDCAN Rx FIFO 0 Status Register
func (o *FDCAN_Type) SetRXF0S_F0FL(value uint32) {
	volatile.StoreUint32(&o.RXF0S.Reg, volatile.LoadUint32(&o.RXF0S.Reg)&^(0x7f)|value)
}
func (o *FDCAN_Type) GetRXF0S_F0FL() uint32 {
	return volatile.LoadUint32(&o.RXF0S.Reg) & 0x7f
}
func (o *FDCAN_Type) SetRXF0S_F0GI(value uint32) {
	volatile.StoreUint32(&o.RXF0S.Reg, volatile.LoadUint32(&o.RXF0S.Reg)&^(0x3f00)|value<<8)
}
func (o *FDCAN_Type) GetRXF0S_F0GI() uint32 {
	return (volatile.LoadUint32(&o.RXF0S.Reg) & 0x3f00) >> 8
}
func (o *FDCAN_Type) SetRXF0S_F0PI(value uint32) {
	volatile.StoreUint32(&o.RXF0S.Reg, volatile.LoadUint32(&o.RXF0S.Reg)&^(0x3f0000)|value<<16)
}
func (o *FDCAN_Type) GetRXF0S_F0PI() uint32 {
	return (volatile.LoadUint32(&o.RXF0S.Reg) & 0x3f0000) >> 16
}
func (o *FDCAN_Type) SetRXF0S_F0F(value uint32) {
	volatile.StoreUint32(&o.RXF0S.Reg, volatile.LoadUint32(&o.RXF0S.Reg)&^(0x1000000)|value<<24)
}
func (o *FDCAN_Type) GetRXF0S_F0F() uint32 {
	return (volatile.LoadUint32(&o.RXF0S.Reg) & 0x1000000) >> 24
}
func (o *FDCAN_Type) SetRXF0S_RF0L(value uint32) {
	volatile.StoreUint32(&o.RXF0S.Reg, volatile.LoadUint32(&o.RXF0S.Reg)&^(0x2000000)|value<<25)
}
func (o *FDCAN_Type) GetRXF0S_RF0L() uint32 {
	return (volatile.LoadUint32(&o.RXF0S.Reg) & 0x2000000) >> 25
}

// FDCAN.RXF0A: CAN Rx FIFO 0 Acknowledge Register
func (o *FDCAN_Type) SetRXF0A_F0AI(value uint32) {
	volatile.StoreUint32(&o.RXF0A.Reg, volatile.LoadUint32(&o.RXF0A.Reg)&^(0x3f)|value)
}
func (o *FDCAN_Type) GetRXF0A_F0AI() uint32 {
	return volatile.LoadUint32(&o.RXF0A.Reg) & 0x3f
}

// FDCAN.RXF1S: FDCAN Rx FIFO 1 Status Register
func (o *FDCAN_Type) SetRXF1S_F1FL(value uint32) {
	volatile.StoreUint32(&o.RXF1S.Reg, volatile.LoadUint32(&o.RXF1S.Reg)&^(0x7f)|value)
}
func (o *FDCAN_Type) GetRXF1S_F1FL() uint32 {
	return volatile.LoadUint32(&o.RXF1S.Reg) & 0x7f
}
func (o *FDCAN_Type) SetRXF1S_F1GI(value uint32) {
	volatile.StoreUint32(&o.RXF1S.Reg, volatile.LoadUint32(&o.RXF1S.Reg)&^(0x3f00)|value<<8)
}
func (o *FDCAN_Type) GetRXF1S_F1GI() uint32 {
	return (volatile.LoadUint32(&o.RXF1S.Reg) & 0x3f00) >> 8
}
func (o *FDCAN_Type) SetRXF1S_F1PI(value uint32) {
	volatile.StoreUint32(&o.RXF1S.Reg, volatile.LoadUint32(&o.RXF1S.Reg)&^(0x3f0000)|value<<16)
}
func (o *FDCAN_Type) GetRXF1S_F1PI() uint32 {
	return (volatile.LoadUint32(&o.RXF1S.Reg) & 0x3f0000) >> 16
}
func (o *FDCAN_Type) SetRXF1S_F1F(value uint32) {
	volatile.StoreUint32(&o.RXF1S.Reg, volatile.LoadUint32(&o.RXF1S.Reg)&^(0x1000000)|value<<24)
}
func (o *FDCAN_Type) GetRXF1S_F1F() uint32 {
	return (volatile.LoadUint32(&o.RXF1S.Reg) & 0x1000000) >> 24
}
func (o *FDCAN_Type) SetRXF1S_RF1L(value uint32) {
	volatile.StoreUint32(&o.RXF1S.Reg, volatile.LoadUint32(&o.RXF1S.Reg)&^(0x2000000)|value<<25)
}
func (o *FDCAN_Type) GetRXF1S_RF1L() uint32 {
	return (volatile.LoadUint32(&o.RXF1S.Reg) & 0x2000000) >> 25
}
func (o *FDCAN_Type) SetRXF1S_DMS(value uint32) {
	volatile.StoreUint32(&o.RXF1S.Reg, volatile.LoadUint32(&o.RXF1S.Reg)&^(0xc0000000)|value<<30)
}
func (o *FDCAN_Type) GetRXF1S_DMS() uint32 {
	return (volatile.LoadUint32(&o.RXF1S.Reg) & 0xc0000000) >> 30
}

// FDCAN.RXF1A: FDCAN Rx FIFO 1 Acknowledge Register
func (o *FDCAN_Type) SetRXF1A_F1AI(value uint32) {
	volatile.StoreUint32(&o.RXF1A.Reg, volatile.LoadUint32(&o.RXF1A.Reg)&^(0x3f)|value)
}
func (o *FDCAN_Type) GetRXF1A_F1AI() uint32 {
	return volatile.LoadUint32(&o.RXF1A.Reg) & 0x3f
}

// FDCAN.TXBC: FDCAN Tx Buffer Configuration Register
func (o *FDCAN_Type) SetTXBC_TBSA(value uint32) {
	volatile.StoreUint32(&o.TXBC.Reg, volatile.LoadUint32(&o.TXBC.Reg)&^(0xfffc)|value<<2)
}
func (o *FDCAN_Type) GetTXBC_TBSA() uint32 {
	return (volatile.LoadUint32(&o.TXBC.Reg) & 0xfffc) >> 2
}
func (o *FDCAN_Type) SetTXBC_NDTB(value uint32) {
	volatile.StoreUint32(&o.TXBC.Reg, volatile.LoadUint32(&o.TXBC.Reg)&^(0x3f0000)|value<<16)
}
func (o *FDCAN_Type) GetTXBC_NDTB() uint32 {
	return (volatile.LoadUint32(&o.TXBC.Reg) & 0x3f0000) >> 16
}
func (o *FDCAN_Type) SetTXBC_TFQS(value uint32) {
	volatile.StoreUint32(&o.TXBC.Reg, volatile.LoadUint32(&o.TXBC.Reg)&^(0x3f000000)|value<<24)
}
func (o *FDCAN_Type) GetTXBC_TFQS() uint32 {
	return (volatile.LoadUint32(&o.TXBC.Reg) & 0x3f000000) >> 24
}
func (o *FDCAN_Type) SetTXBC_TFQM(value uint32) {
	volatile.StoreUint32(&o.TXBC.Reg, volatile.LoadUint32(&o.TXBC.Reg)&^(0x40000000)|value<<30)
}
func (o *FDCAN_Type) GetTXBC_TFQM() uint32 {
	return (volatile.LoadUint32(&o.TXBC.Reg) & 0x40000000) >> 30
}

// FDCAN.TXFQS: The Tx FIFO/Queue status is related to the pending Tx requests listed in register TXBRP. Therefore the effect of Add/Cancellation requests may be delayed due to a running Tx scan (TXBRP not yet updated).
func (o *FDCAN_Type) SetTXFQS_TFFL(value uint32) {
	volatile.StoreUint32(&o.TXFQS.Reg, volatile.LoadUint32(&o.TXFQS.Reg)&^(0x7)|value)
}
func (o *FDCAN_Type) GetTXFQS_TFFL() uint32 {
	return volatile.LoadUint32(&o.TXFQS.Reg) & 0x7
}
func (o *FDCAN_Type) SetTXFQS_TFGI(value uint32) {
	volatile.StoreUint32(&o.TXFQS.Reg, volatile.LoadUint32(&o.TXFQS.Reg)&^(0x300)|value<<8)
}
func (o *FDCAN_Type) GetTXFQS_TFGI() uint32 {
	return (volatile.LoadUint32(&o.TXFQS.Reg) & 0x300) >> 8
}
func (o *FDCAN_Type) SetTXFQS_TFQPI(value uint32) {
	volatile.StoreUint32(&o.TXFQS.Reg, volatile.LoadUint32(&o.TXFQS.Reg)&^(0x30000)|value<<16)
}
func (o *FDCAN_Type) GetTXFQS_TFQPI() uint32 {
	return (volatile.LoadUint32(&o.TXFQS.Reg) & 0x30000) >> 16
}
func (o *FDCAN_Type) SetTXFQS_TFQF(value uint32) {
	volatile.StoreUint32(&o.TXFQS.Reg, volatile.LoadUint32(&o.TXFQS.Reg)&^(0x200000)|value<<21)
}
func (o *FDCAN_Type) GetTXFQS_TFQF() uint32 {
	return (volatile.LoadUint32(&o.TXFQS.Reg) & 0x200000) >> 21
}

// FDCAN.TXBRP: FDCAN Tx Buffer Request Pending Register
func (o *FDCAN_Type) SetTXBRP_TRP(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x7)|value)
}
func (o *FDCAN_Type) GetTXBRP_TRP() uint32 {
	return volatile.LoadUint32(&o.TXBRP.Reg) & 0x7
}

// FDCAN.TXBAR: FDCAN Tx Buffer Add Request Register
func (o *FDCAN_Type) SetTXBAR_AR(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x7)|value)
}
func (o *FDCAN_Type) GetTXBAR_AR() uint32 {
	return volatile.LoadUint32(&o.TXBAR.Reg) & 0x7
}

// FDCAN.TXBCR: FDCAN Tx Buffer Cancellation Request Register
func (o *FDCAN_Type) SetTXBCR_CR(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x7)|value)
}
func (o *FDCAN_Type) GetTXBCR_CR() uint32 {
	return volatile.LoadUint32(&o.TXBCR.Reg) & 0x7
}

// FDCAN.TXBTO: FDCAN Tx Buffer Transmission Occurred Register
func (o *FDCAN_Type) SetTXBTO_TO(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x7)|value)
}
func (o *FDCAN_Type) GetTXBTO_TO() uint32 {
	return volatile.LoadUint32(&o.TXBTO.Reg) & 0x7
}

// FDCAN.TXBCF: FDCAN Tx Buffer Cancellation Finished Register
func (o *FDCAN_Type) SetTXBCF_CF(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x7)|value)
}
func (o *FDCAN_Type) GetTXBCF_CF() uint32 {
	return volatile.LoadUint32(&o.TXBCF.Reg) & 0x7
}

// FDCAN.TXBTIE: FDCAN Tx Buffer Transmission Interrupt Enable Register
func (o *FDCAN_Type) SetTXBTIE_TIE(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x7)|value)
}
func (o *FDCAN_Type) GetTXBTIE_TIE() uint32 {
	return volatile.LoadUint32(&o.TXBTIE.Reg) & 0x7
}

// FDCAN.TXBCIE: FDCAN Tx Buffer Cancellation Finished Interrupt Enable Register
func (o *FDCAN_Type) SetTXBCIE_CFIE(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x7)|value)
}
func (o *FDCAN_Type) GetTXBCIE_CFIE() uint32 {
	return volatile.LoadUint32(&o.TXBCIE.Reg) & 0x7
}

// FDCAN.TXEFS: FDCAN Tx Event FIFO Status Register
func (o *FDCAN_Type) SetTXEFS_EFFL(value uint32) {
	volatile.StoreUint32(&o.TXEFS.Reg, volatile.LoadUint32(&o.TXEFS.Reg)&^(0x7)|value)
}
func (o *FDCAN_Type) GetTXEFS_EFFL() uint32 {
	return volatile.LoadUint32(&o.TXEFS.Reg) & 0x7
}
func (o *FDCAN_Type) SetTXEFS_EFGI(value uint32) {
	volatile.StoreUint32(&o.TXEFS.Reg, volatile.LoadUint32(&o.TXEFS.Reg)&^(0x300)|value<<8)
}
func (o *FDCAN_Type) GetTXEFS_EFGI() uint32 {
	return (volatile.LoadUint32(&o.TXEFS.Reg) & 0x300) >> 8
}
func (o *FDCAN_Type) SetTXEFS_EFPI(value uint32) {
	volatile.StoreUint32(&o.TXEFS.Reg, volatile.LoadUint32(&o.TXEFS.Reg)&^(0x30000)|value<<16)
}
func (o *FDCAN_Type) GetTXEFS_EFPI() uint32 {
	return (volatile.LoadUint32(&o.TXEFS.Reg) & 0x30000) >> 16
}
func (o *FDCAN_Type) SetTXEFS_EFF(value uint32) {
	volatile.StoreUint32(&o.TXEFS.Reg, volatile.LoadUint32(&o.TXEFS.Reg)&^(0x1000000)|value<<24)
}
func (o *FDCAN_Type) GetTXEFS_EFF() uint32 {
	return (volatile.LoadUint32(&o.TXEFS.Reg) & 0x1000000) >> 24
}
func (o *FDCAN_Type) SetTXEFS_TEFL(value uint32) {
	volatile.StoreUint32(&o.TXEFS.Reg, volatile.LoadUint32(&o.TXEFS.Reg)&^(0x2000000)|value<<25)
}
func (o *FDCAN_Type) GetTXEFS_TEFL() uint32 {
	return (volatile.LoadUint32(&o.TXEFS.Reg) & 0x2000000) >> 25
}

// FDCAN.TXEFA: FDCAN Tx Event FIFO Acknowledge Register
func (o *FDCAN_Type) SetTXEFA_EFAI(value uint32) {
	volatile.StoreUint32(&o.TXEFA.Reg, volatile.LoadUint32(&o.TXEFA.Reg)&^(0x1f)|value)
}
func (o *FDCAN_Type) GetTXEFA_EFAI() uint32 {
	return volatile.LoadUint32(&o.TXEFA.Reg) & 0x1f
}

// FDCAN.CKDIV: FDCAN CFG clock divider register
func (o *FDCAN_Type) SetCKDIV_PDIV(value uint32) {
	volatile.StoreUint32(&o.CKDIV.Reg, volatile.LoadUint32(&o.CKDIV.Reg)&^(0xf)|value)
}
func (o *FDCAN_Type) GetCKDIV_PDIV() uint32 {
	return volatile.LoadUint32(&o.CKDIV.Reg) & 0xf
}

// UCPD1
type UCPD_Type struct {
	CFG1       volatile.Register32 // 0x0
	CFG2       volatile.Register32 // 0x4
	_          [4]byte
	CR         volatile.Register32 // 0xC
	IMR        volatile.Register32 // 0x10
	SR         volatile.Register32 // 0x14
	ICR        volatile.Register32 // 0x18
	TX_ORDSET  volatile.Register32 // 0x1C
	TX_PAYSZ   volatile.Register32 // 0x20
	TXDR       volatile.Register32 // 0x24
	RX_ORDSET  volatile.Register32 // 0x28
	RX_PAYSZ   volatile.Register32 // 0x2C
	RXDR       volatile.Register32 // 0x30
	RX_ORDEXT1 volatile.Register32 // 0x34
	RX_ORDEXT2 volatile.Register32 // 0x38
}

// UCPD.CFG1: UCPD configuration register 1
func (o *UCPD_Type) SetCFG1_HBITCLKDIV(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x3f)|value)
}
func (o *UCPD_Type) GetCFG1_HBITCLKDIV() uint32 {
	return volatile.LoadUint32(&o.CFG1.Reg) & 0x3f
}
func (o *UCPD_Type) SetCFG1_IFRGAP(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x7c0)|value<<6)
}
func (o *UCPD_Type) GetCFG1_IFRGAP() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x7c0) >> 6
}
func (o *UCPD_Type) SetCFG1_TRANSWIN(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xf800)|value<<11)
}
func (o *UCPD_Type) GetCFG1_TRANSWIN() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0xf800) >> 11
}
func (o *UCPD_Type) SetCFG1_PSC_USBPDCLK(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xe0000)|value<<17)
}
func (o *UCPD_Type) GetCFG1_PSC_USBPDCLK() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0xe0000) >> 17
}
func (o *UCPD_Type) SetCFG1_RXORDSETEN(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x1ff00000)|value<<20)
}
func (o *UCPD_Type) GetCFG1_RXORDSETEN() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x1ff00000) >> 20
}
func (o *UCPD_Type) SetCFG1_TXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x20000000)|value<<29)
}
func (o *UCPD_Type) GetCFG1_TXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x20000000) >> 29
}
func (o *UCPD_Type) SetCFG1_RXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x40000000)|value<<30)
}
func (o *UCPD_Type) GetCFG1_RXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x40000000) >> 30
}
func (o *UCPD_Type) SetCFG1_UCPDEN(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x80000000)|value<<31)
}
func (o *UCPD_Type) GetCFG1_UCPDEN() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x80000000) >> 31
}

// UCPD.CFG2: UCPD configuration register 2
func (o *UCPD_Type) SetCFG2_RXFILTDIS(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x1)|value)
}
func (o *UCPD_Type) GetCFG2_RXFILTDIS() uint32 {
	return volatile.LoadUint32(&o.CFG2.Reg) & 0x1
}
func (o *UCPD_Type) SetCFG2_RXFILT2N3(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x2)|value<<1)
}
func (o *UCPD_Type) GetCFG2_RXFILT2N3() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x2) >> 1
}
func (o *UCPD_Type) SetCFG2_FORCECLK(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x4)|value<<2)
}
func (o *UCPD_Type) GetCFG2_FORCECLK() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x4) >> 2
}
func (o *UCPD_Type) SetCFG2_WUPEN(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x8)|value<<3)
}
func (o *UCPD_Type) GetCFG2_WUPEN() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x8) >> 3
}

// UCPD.CR: UCPD configuration register 2
func (o *UCPD_Type) SetCR_TXMODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3)|value)
}
func (o *UCPD_Type) GetCR_TXMODE() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x3
}
func (o *UCPD_Type) SetCR_TXSEND(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *UCPD_Type) GetCR_TXSEND() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *UCPD_Type) SetCR_TXHRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *UCPD_Type) GetCR_TXHRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *UCPD_Type) SetCR_RXMODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *UCPD_Type) GetCR_RXMODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *UCPD_Type) SetCR_PHYRXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *UCPD_Type) GetCR_PHYRXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *UCPD_Type) SetCR_PHYCCSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *UCPD_Type) GetCR_PHYCCSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *UCPD_Type) SetCR_ANASUBMODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x180)|value<<7)
}
func (o *UCPD_Type) GetCR_ANASUBMODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x180) >> 7
}
func (o *UCPD_Type) SetCR_ANAMODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *UCPD_Type) GetCR_ANAMODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *UCPD_Type) SetCR_CCENABLE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc00)|value<<10)
}
func (o *UCPD_Type) GetCR_CCENABLE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc00) >> 10
}
func (o *UCPD_Type) SetCR_FRSRXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *UCPD_Type) GetCR_FRSRXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *UCPD_Type) SetCR_FRSTX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *UCPD_Type) GetCR_FRSTX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *UCPD_Type) SetCR_RDCH(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *UCPD_Type) GetCR_RDCH() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *UCPD_Type) SetCR_CC1TCDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *UCPD_Type) GetCR_CC1TCDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *UCPD_Type) SetCR_CC2TCDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200000)|value<<21)
}
func (o *UCPD_Type) GetCR_CC2TCDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200000) >> 21
}

// UCPD.IMR: UCPD Interrupt Mask Register
func (o *UCPD_Type) SetIMR_TXISIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *UCPD_Type) GetIMR_TXISIE() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *UCPD_Type) SetIMR_TXMSGDISCIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *UCPD_Type) GetIMR_TXMSGDISCIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *UCPD_Type) SetIMR_TXMSGSENTIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *UCPD_Type) GetIMR_TXMSGSENTIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *UCPD_Type) SetIMR_TXMSGABTIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *UCPD_Type) GetIMR_TXMSGABTIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *UCPD_Type) SetIMR_HRSTDISCIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *UCPD_Type) GetIMR_HRSTDISCIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *UCPD_Type) SetIMR_HRSTSENTIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *UCPD_Type) GetIMR_HRSTSENTIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *UCPD_Type) SetIMR_TXUNDIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *UCPD_Type) GetIMR_TXUNDIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *UCPD_Type) SetIMR_RXNEIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *UCPD_Type) GetIMR_RXNEIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *UCPD_Type) SetIMR_RXORDDETIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *UCPD_Type) GetIMR_RXORDDETIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *UCPD_Type) SetIMR_RXHRSTDETIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *UCPD_Type) GetIMR_RXHRSTDETIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *UCPD_Type) SetIMR_RXOVRIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *UCPD_Type) GetIMR_RXOVRIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *UCPD_Type) SetIMR_RXMSGENDIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *UCPD_Type) GetIMR_RXMSGENDIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *UCPD_Type) SetIMR_TYPECEVT1IE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *UCPD_Type) GetIMR_TYPECEVT1IE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *UCPD_Type) SetIMR_TYPECEVT2IE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *UCPD_Type) GetIMR_TYPECEVT2IE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}
func (o *UCPD_Type) SetIMR_FRSEVTIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *UCPD_Type) GetIMR_FRSEVTIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}

// UCPD.SR: UCPD Status Register
func (o *UCPD_Type) SetSR_TXIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *UCPD_Type) GetSR_TXIS() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *UCPD_Type) SetSR_TXMSGDISC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *UCPD_Type) GetSR_TXMSGDISC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *UCPD_Type) SetSR_TXMSGSENT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *UCPD_Type) GetSR_TXMSGSENT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *UCPD_Type) SetSR_TXMSGABT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *UCPD_Type) GetSR_TXMSGABT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *UCPD_Type) SetSR_HRSTDISC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *UCPD_Type) GetSR_HRSTDISC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *UCPD_Type) SetSR_HRSTSENT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *UCPD_Type) GetSR_HRSTSENT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *UCPD_Type) SetSR_TXUND(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *UCPD_Type) GetSR_TXUND() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *UCPD_Type) SetSR_RXNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *UCPD_Type) GetSR_RXNE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *UCPD_Type) SetSR_RXORDDET(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *UCPD_Type) GetSR_RXORDDET() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *UCPD_Type) SetSR_RXHRSTDET(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *UCPD_Type) GetSR_RXHRSTDET() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *UCPD_Type) SetSR_RXOVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *UCPD_Type) GetSR_RXOVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *UCPD_Type) SetSR_RXMSGEND(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *UCPD_Type) GetSR_RXMSGEND() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *UCPD_Type) SetSR_RXERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *UCPD_Type) GetSR_RXERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}
func (o *UCPD_Type) SetSR_TYPECEVT1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000)|value<<14)
}
func (o *UCPD_Type) GetSR_TYPECEVT1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000) >> 14
}
func (o *UCPD_Type) SetSR_TYPECEVT2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000)|value<<15)
}
func (o *UCPD_Type) GetSR_TYPECEVT2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000) >> 15
}
func (o *UCPD_Type) SetSR_TYPEC_VSTATE_CC1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x30000)|value<<16)
}
func (o *UCPD_Type) GetSR_TYPEC_VSTATE_CC1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x30000) >> 16
}
func (o *UCPD_Type) SetSR_TYPEC_VSTATE_CC2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xc0000)|value<<18)
}
func (o *UCPD_Type) GetSR_TYPEC_VSTATE_CC2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xc0000) >> 18
}
func (o *UCPD_Type) SetSR_FRSEVT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100000)|value<<20)
}
func (o *UCPD_Type) GetSR_FRSEVT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100000) >> 20
}

// UCPD.ICR: UCPD Interrupt Clear Register
func (o *UCPD_Type) SetICR_TXMSGDISCCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *UCPD_Type) GetICR_TXMSGDISCCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *UCPD_Type) SetICR_TXMSGSENTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *UCPD_Type) GetICR_TXMSGSENTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *UCPD_Type) SetICR_TXMSGABTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *UCPD_Type) GetICR_TXMSGABTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *UCPD_Type) SetICR_HRSTDISCCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *UCPD_Type) GetICR_HRSTDISCCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *UCPD_Type) SetICR_HRSTSENTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *UCPD_Type) GetICR_HRSTSENTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *UCPD_Type) SetICR_TXUNDCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *UCPD_Type) GetICR_TXUNDCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *UCPD_Type) SetICR_RXORDDETCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *UCPD_Type) GetICR_RXORDDETCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *UCPD_Type) SetICR_RXHRSTDETCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400)|value<<10)
}
func (o *UCPD_Type) GetICR_RXHRSTDETCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400) >> 10
}
func (o *UCPD_Type) SetICR_RXOVRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800)|value<<11)
}
func (o *UCPD_Type) GetICR_RXOVRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800) >> 11
}
func (o *UCPD_Type) SetICR_RXMSGENDCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1000)|value<<12)
}
func (o *UCPD_Type) GetICR_RXMSGENDCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x1000) >> 12
}
func (o *UCPD_Type) SetICR_TYPECEVT1CF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4000)|value<<14)
}
func (o *UCPD_Type) GetICR_TYPECEVT1CF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4000) >> 14
}
func (o *UCPD_Type) SetICR_TYPECEVT2CF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8000)|value<<15)
}
func (o *UCPD_Type) GetICR_TYPECEVT2CF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8000) >> 15
}
func (o *UCPD_Type) SetICR_FRSEVTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100000)|value<<20)
}
func (o *UCPD_Type) GetICR_FRSEVTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100000) >> 20
}

// UCPD.TX_ORDSET: UCPD Tx Ordered Set Type Register
func (o *UCPD_Type) SetTX_ORDSET_TXORDSET(value uint32) {
	volatile.StoreUint32(&o.TX_ORDSET.Reg, volatile.LoadUint32(&o.TX_ORDSET.Reg)&^(0xfffff)|value)
}
func (o *UCPD_Type) GetTX_ORDSET_TXORDSET() uint32 {
	return volatile.LoadUint32(&o.TX_ORDSET.Reg) & 0xfffff
}

// UCPD.TX_PAYSZ: UCPD Tx Paysize Register
func (o *UCPD_Type) SetTX_PAYSZ_TXPAYSZ(value uint32) {
	volatile.StoreUint32(&o.TX_PAYSZ.Reg, volatile.LoadUint32(&o.TX_PAYSZ.Reg)&^(0x3ff)|value)
}
func (o *UCPD_Type) GetTX_PAYSZ_TXPAYSZ() uint32 {
	return volatile.LoadUint32(&o.TX_PAYSZ.Reg) & 0x3ff
}

// UCPD.TXDR: UCPD Tx Data Register
func (o *UCPD_Type) SetTXDR_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXDR.Reg, volatile.LoadUint32(&o.TXDR.Reg)&^(0xff)|value)
}
func (o *UCPD_Type) GetTXDR_TXDATA() uint32 {
	return volatile.LoadUint32(&o.TXDR.Reg) & 0xff
}

// UCPD.RX_ORDSET: UCPD Rx Ordered Set Register
func (o *UCPD_Type) SetRX_ORDSET_RXORDSET(value uint32) {
	volatile.StoreUint32(&o.RX_ORDSET.Reg, volatile.LoadUint32(&o.RX_ORDSET.Reg)&^(0x7)|value)
}
func (o *UCPD_Type) GetRX_ORDSET_RXORDSET() uint32 {
	return volatile.LoadUint32(&o.RX_ORDSET.Reg) & 0x7
}
func (o *UCPD_Type) SetRX_ORDSET_RXSOP3OF4(value uint32) {
	volatile.StoreUint32(&o.RX_ORDSET.Reg, volatile.LoadUint32(&o.RX_ORDSET.Reg)&^(0x8)|value<<3)
}
func (o *UCPD_Type) GetRX_ORDSET_RXSOP3OF4() uint32 {
	return (volatile.LoadUint32(&o.RX_ORDSET.Reg) & 0x8) >> 3
}
func (o *UCPD_Type) SetRX_ORDSET_RXSOPKINVALID(value uint32) {
	volatile.StoreUint32(&o.RX_ORDSET.Reg, volatile.LoadUint32(&o.RX_ORDSET.Reg)&^(0x70)|value<<4)
}
func (o *UCPD_Type) GetRX_ORDSET_RXSOPKINVALID() uint32 {
	return (volatile.LoadUint32(&o.RX_ORDSET.Reg) & 0x70) >> 4
}

// UCPD.RX_PAYSZ: UCPD Rx Paysize Register
func (o *UCPD_Type) SetRX_PAYSZ_RXPAYSZ(value uint32) {
	volatile.StoreUint32(&o.RX_PAYSZ.Reg, volatile.LoadUint32(&o.RX_PAYSZ.Reg)&^(0x3ff)|value)
}
func (o *UCPD_Type) GetRX_PAYSZ_RXPAYSZ() uint32 {
	return volatile.LoadUint32(&o.RX_PAYSZ.Reg) & 0x3ff
}

// UCPD.RXDR: UCPD Rx Data Register
func (o *UCPD_Type) SetRXDR_RXDATA(value uint32) {
	volatile.StoreUint32(&o.RXDR.Reg, volatile.LoadUint32(&o.RXDR.Reg)&^(0xff)|value)
}
func (o *UCPD_Type) GetRXDR_RXDATA() uint32 {
	return volatile.LoadUint32(&o.RXDR.Reg) & 0xff
}

// UCPD.RX_ORDEXT1: UCPD Rx Ordered Set Extension Register 1
func (o *UCPD_Type) SetRX_ORDEXT1_RXSOPX1(value uint32) {
	volatile.StoreUint32(&o.RX_ORDEXT1.Reg, volatile.LoadUint32(&o.RX_ORDEXT1.Reg)&^(0xfffff)|value)
}
func (o *UCPD_Type) GetRX_ORDEXT1_RXSOPX1() uint32 {
	return volatile.LoadUint32(&o.RX_ORDEXT1.Reg) & 0xfffff
}

// UCPD.RX_ORDEXT2: UCPD Rx Ordered Set Extension Register 2
func (o *UCPD_Type) SetRX_ORDEXT2_RXSOPX2(value uint32) {
	volatile.StoreUint32(&o.RX_ORDEXT2.Reg, volatile.LoadUint32(&o.RX_ORDEXT2.Reg)&^(0xfffff)|value)
}
func (o *UCPD_Type) GetRX_ORDEXT2_RXSOPX2() uint32 {
	return volatile.LoadUint32(&o.RX_ORDEXT2.Reg) & 0xfffff
}

// USB_FS_device
type USB_Type struct {
	EP0R   volatile.Register32 // 0x0
	EP1R   volatile.Register32 // 0x4
	EP2R   volatile.Register32 // 0x8
	EP3R   volatile.Register32 // 0xC
	EP4R   volatile.Register32 // 0x10
	EP5R   volatile.Register32 // 0x14
	EP6R   volatile.Register32 // 0x18
	EP7R   volatile.Register32 // 0x1C
	_      [32]byte
	CNTR   volatile.Register32 // 0x40
	ISTR   volatile.Register32 // 0x44
	FNR    volatile.Register32 // 0x48
	DADDR  volatile.Register32 // 0x4C
	BTABLE volatile.Register32 // 0x50
	_      [4]byte
	BCDR   volatile.Register32 // 0x58
}

// USB.EP0R: USB endpoint n register
func (o *USB_Type) SetEP0R_EA(value uint32) {
	volatile.StoreUint32(&o.EP0R.Reg, volatile.LoadUint32(&o.EP0R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP0R_EA() uint32 {
	return volatile.LoadUint32(&o.EP0R.Reg) & 0xf
}
func (o *USB_Type) SetEP0R_STAT_TX(value uint32) {
	volatile.StoreUint32(&o.EP0R.Reg, volatile.LoadUint32(&o.EP0R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP0R_STAT_TX() uint32 {
	return (volatile.LoadUint32(&o.EP0R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP0R_DTOG_TX(value uint32) {
	volatile.StoreUint32(&o.EP0R.Reg, volatile.LoadUint32(&o.EP0R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP0R_DTOG_TX() uint32 {
	return (volatile.LoadUint32(&o.EP0R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP0R_CTR_TX(value uint32) {
	volatile.StoreUint32(&o.EP0R.Reg, volatile.LoadUint32(&o.EP0R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP0R_CTR_TX() uint32 {
	return (volatile.LoadUint32(&o.EP0R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP0R_EP_KIND(value uint32) {
	volatile.StoreUint32(&o.EP0R.Reg, volatile.LoadUint32(&o.EP0R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP0R_EP_KIND() uint32 {
	return (volatile.LoadUint32(&o.EP0R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP0R_EP_TYPE(value uint32) {
	volatile.StoreUint32(&o.EP0R.Reg, volatile.LoadUint32(&o.EP0R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP0R_EP_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EP0R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP0R_SETUP(value uint32) {
	volatile.StoreUint32(&o.EP0R.Reg, volatile.LoadUint32(&o.EP0R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP0R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EP0R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP0R_STAT_RX(value uint32) {
	volatile.StoreUint32(&o.EP0R.Reg, volatile.LoadUint32(&o.EP0R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP0R_STAT_RX() uint32 {
	return (volatile.LoadUint32(&o.EP0R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP0R_DTOG_RX(value uint32) {
	volatile.StoreUint32(&o.EP0R.Reg, volatile.LoadUint32(&o.EP0R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP0R_DTOG_RX() uint32 {
	return (volatile.LoadUint32(&o.EP0R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP0R_CTR_RX(value uint32) {
	volatile.StoreUint32(&o.EP0R.Reg, volatile.LoadUint32(&o.EP0R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP0R_CTR_RX() uint32 {
	return (volatile.LoadUint32(&o.EP0R.Reg) & 0x8000) >> 15
}

// USB.EP1R: USB endpoint n register
func (o *USB_Type) SetEP1R_EA(value uint32) {
	volatile.StoreUint32(&o.EP1R.Reg, volatile.LoadUint32(&o.EP1R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP1R_EA() uint32 {
	return volatile.LoadUint32(&o.EP1R.Reg) & 0xf
}
func (o *USB_Type) SetEP1R_STAT_TX(value uint32) {
	volatile.StoreUint32(&o.EP1R.Reg, volatile.LoadUint32(&o.EP1R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP1R_STAT_TX() uint32 {
	return (volatile.LoadUint32(&o.EP1R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP1R_DTOG_TX(value uint32) {
	volatile.StoreUint32(&o.EP1R.Reg, volatile.LoadUint32(&o.EP1R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP1R_DTOG_TX() uint32 {
	return (volatile.LoadUint32(&o.EP1R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP1R_CTR_TX(value uint32) {
	volatile.StoreUint32(&o.EP1R.Reg, volatile.LoadUint32(&o.EP1R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP1R_CTR_TX() uint32 {
	return (volatile.LoadUint32(&o.EP1R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP1R_EP_KIND(value uint32) {
	volatile.StoreUint32(&o.EP1R.Reg, volatile.LoadUint32(&o.EP1R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP1R_EP_KIND() uint32 {
	return (volatile.LoadUint32(&o.EP1R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP1R_EP_TYPE(value uint32) {
	volatile.StoreUint32(&o.EP1R.Reg, volatile.LoadUint32(&o.EP1R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP1R_EP_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EP1R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP1R_SETUP(value uint32) {
	volatile.StoreUint32(&o.EP1R.Reg, volatile.LoadUint32(&o.EP1R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP1R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EP1R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP1R_STAT_RX(value uint32) {
	volatile.StoreUint32(&o.EP1R.Reg, volatile.LoadUint32(&o.EP1R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP1R_STAT_RX() uint32 {
	return (volatile.LoadUint32(&o.EP1R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP1R_DTOG_RX(value uint32) {
	volatile.StoreUint32(&o.EP1R.Reg, volatile.LoadUint32(&o.EP1R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP1R_DTOG_RX() uint32 {
	return (volatile.LoadUint32(&o.EP1R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP1R_CTR_RX(value uint32) {
	volatile.StoreUint32(&o.EP1R.Reg, volatile.LoadUint32(&o.EP1R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP1R_CTR_RX() uint32 {
	return (volatile.LoadUint32(&o.EP1R.Reg) & 0x8000) >> 15
}

// USB.EP2R: USB endpoint n register
func (o *USB_Type) SetEP2R_EA(value uint32) {
	volatile.StoreUint32(&o.EP2R.Reg, volatile.LoadUint32(&o.EP2R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP2R_EA() uint32 {
	return volatile.LoadUint32(&o.EP2R.Reg) & 0xf
}
func (o *USB_Type) SetEP2R_STAT_TX(value uint32) {
	volatile.StoreUint32(&o.EP2R.Reg, volatile.LoadUint32(&o.EP2R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP2R_STAT_TX() uint32 {
	return (volatile.LoadUint32(&o.EP2R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP2R_DTOG_TX(value uint32) {
	volatile.StoreUint32(&o.EP2R.Reg, volatile.LoadUint32(&o.EP2R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP2R_DTOG_TX() uint32 {
	return (volatile.LoadUint32(&o.EP2R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP2R_CTR_TX(value uint32) {
	volatile.StoreUint32(&o.EP2R.Reg, volatile.LoadUint32(&o.EP2R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP2R_CTR_TX() uint32 {
	return (volatile.LoadUint32(&o.EP2R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP2R_EP_KIND(value uint32) {
	volatile.StoreUint32(&o.EP2R.Reg, volatile.LoadUint32(&o.EP2R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP2R_EP_KIND() uint32 {
	return (volatile.LoadUint32(&o.EP2R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP2R_EP_TYPE(value uint32) {
	volatile.StoreUint32(&o.EP2R.Reg, volatile.LoadUint32(&o.EP2R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP2R_EP_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EP2R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP2R_SETUP(value uint32) {
	volatile.StoreUint32(&o.EP2R.Reg, volatile.LoadUint32(&o.EP2R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP2R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EP2R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP2R_STAT_RX(value uint32) {
	volatile.StoreUint32(&o.EP2R.Reg, volatile.LoadUint32(&o.EP2R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP2R_STAT_RX() uint32 {
	return (volatile.LoadUint32(&o.EP2R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP2R_DTOG_RX(value uint32) {
	volatile.StoreUint32(&o.EP2R.Reg, volatile.LoadUint32(&o.EP2R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP2R_DTOG_RX() uint32 {
	return (volatile.LoadUint32(&o.EP2R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP2R_CTR_RX(value uint32) {
	volatile.StoreUint32(&o.EP2R.Reg, volatile.LoadUint32(&o.EP2R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP2R_CTR_RX() uint32 {
	return (volatile.LoadUint32(&o.EP2R.Reg) & 0x8000) >> 15
}

// USB.EP3R: USB endpoint n register
func (o *USB_Type) SetEP3R_EA(value uint32) {
	volatile.StoreUint32(&o.EP3R.Reg, volatile.LoadUint32(&o.EP3R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP3R_EA() uint32 {
	return volatile.LoadUint32(&o.EP3R.Reg) & 0xf
}
func (o *USB_Type) SetEP3R_STAT_TX(value uint32) {
	volatile.StoreUint32(&o.EP3R.Reg, volatile.LoadUint32(&o.EP3R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP3R_STAT_TX() uint32 {
	return (volatile.LoadUint32(&o.EP3R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP3R_DTOG_TX(value uint32) {
	volatile.StoreUint32(&o.EP3R.Reg, volatile.LoadUint32(&o.EP3R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP3R_DTOG_TX() uint32 {
	return (volatile.LoadUint32(&o.EP3R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP3R_CTR_TX(value uint32) {
	volatile.StoreUint32(&o.EP3R.Reg, volatile.LoadUint32(&o.EP3R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP3R_CTR_TX() uint32 {
	return (volatile.LoadUint32(&o.EP3R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP3R_EP_KIND(value uint32) {
	volatile.StoreUint32(&o.EP3R.Reg, volatile.LoadUint32(&o.EP3R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP3R_EP_KIND() uint32 {
	return (volatile.LoadUint32(&o.EP3R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP3R_EP_TYPE(value uint32) {
	volatile.StoreUint32(&o.EP3R.Reg, volatile.LoadUint32(&o.EP3R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP3R_EP_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EP3R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP3R_SETUP(value uint32) {
	volatile.StoreUint32(&o.EP3R.Reg, volatile.LoadUint32(&o.EP3R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP3R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EP3R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP3R_STAT_RX(value uint32) {
	volatile.StoreUint32(&o.EP3R.Reg, volatile.LoadUint32(&o.EP3R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP3R_STAT_RX() uint32 {
	return (volatile.LoadUint32(&o.EP3R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP3R_DTOG_RX(value uint32) {
	volatile.StoreUint32(&o.EP3R.Reg, volatile.LoadUint32(&o.EP3R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP3R_DTOG_RX() uint32 {
	return (volatile.LoadUint32(&o.EP3R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP3R_CTR_RX(value uint32) {
	volatile.StoreUint32(&o.EP3R.Reg, volatile.LoadUint32(&o.EP3R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP3R_CTR_RX() uint32 {
	return (volatile.LoadUint32(&o.EP3R.Reg) & 0x8000) >> 15
}

// USB.EP4R: USB endpoint n register
func (o *USB_Type) SetEP4R_EA(value uint32) {
	volatile.StoreUint32(&o.EP4R.Reg, volatile.LoadUint32(&o.EP4R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP4R_EA() uint32 {
	return volatile.LoadUint32(&o.EP4R.Reg) & 0xf
}
func (o *USB_Type) SetEP4R_STAT_TX(value uint32) {
	volatile.StoreUint32(&o.EP4R.Reg, volatile.LoadUint32(&o.EP4R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP4R_STAT_TX() uint32 {
	return (volatile.LoadUint32(&o.EP4R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP4R_DTOG_TX(value uint32) {
	volatile.StoreUint32(&o.EP4R.Reg, volatile.LoadUint32(&o.EP4R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP4R_DTOG_TX() uint32 {
	return (volatile.LoadUint32(&o.EP4R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP4R_CTR_TX(value uint32) {
	volatile.StoreUint32(&o.EP4R.Reg, volatile.LoadUint32(&o.EP4R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP4R_CTR_TX() uint32 {
	return (volatile.LoadUint32(&o.EP4R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP4R_EP_KIND(value uint32) {
	volatile.StoreUint32(&o.EP4R.Reg, volatile.LoadUint32(&o.EP4R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP4R_EP_KIND() uint32 {
	return (volatile.LoadUint32(&o.EP4R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP4R_EP_TYPE(value uint32) {
	volatile.StoreUint32(&o.EP4R.Reg, volatile.LoadUint32(&o.EP4R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP4R_EP_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EP4R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP4R_SETUP(value uint32) {
	volatile.StoreUint32(&o.EP4R.Reg, volatile.LoadUint32(&o.EP4R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP4R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EP4R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP4R_STAT_RX(value uint32) {
	volatile.StoreUint32(&o.EP4R.Reg, volatile.LoadUint32(&o.EP4R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP4R_STAT_RX() uint32 {
	return (volatile.LoadUint32(&o.EP4R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP4R_DTOG_RX(value uint32) {
	volatile.StoreUint32(&o.EP4R.Reg, volatile.LoadUint32(&o.EP4R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP4R_DTOG_RX() uint32 {
	return (volatile.LoadUint32(&o.EP4R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP4R_CTR_RX(value uint32) {
	volatile.StoreUint32(&o.EP4R.Reg, volatile.LoadUint32(&o.EP4R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP4R_CTR_RX() uint32 {
	return (volatile.LoadUint32(&o.EP4R.Reg) & 0x8000) >> 15
}

// USB.EP5R: USB endpoint n register
func (o *USB_Type) SetEP5R_EA(value uint32) {
	volatile.StoreUint32(&o.EP5R.Reg, volatile.LoadUint32(&o.EP5R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP5R_EA() uint32 {
	return volatile.LoadUint32(&o.EP5R.Reg) & 0xf
}
func (o *USB_Type) SetEP5R_STAT_TX(value uint32) {
	volatile.StoreUint32(&o.EP5R.Reg, volatile.LoadUint32(&o.EP5R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP5R_STAT_TX() uint32 {
	return (volatile.LoadUint32(&o.EP5R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP5R_DTOG_TX(value uint32) {
	volatile.StoreUint32(&o.EP5R.Reg, volatile.LoadUint32(&o.EP5R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP5R_DTOG_TX() uint32 {
	return (volatile.LoadUint32(&o.EP5R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP5R_CTR_TX(value uint32) {
	volatile.StoreUint32(&o.EP5R.Reg, volatile.LoadUint32(&o.EP5R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP5R_CTR_TX() uint32 {
	return (volatile.LoadUint32(&o.EP5R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP5R_EP_KIND(value uint32) {
	volatile.StoreUint32(&o.EP5R.Reg, volatile.LoadUint32(&o.EP5R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP5R_EP_KIND() uint32 {
	return (volatile.LoadUint32(&o.EP5R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP5R_EP_TYPE(value uint32) {
	volatile.StoreUint32(&o.EP5R.Reg, volatile.LoadUint32(&o.EP5R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP5R_EP_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EP5R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP5R_SETUP(value uint32) {
	volatile.StoreUint32(&o.EP5R.Reg, volatile.LoadUint32(&o.EP5R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP5R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EP5R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP5R_STAT_RX(value uint32) {
	volatile.StoreUint32(&o.EP5R.Reg, volatile.LoadUint32(&o.EP5R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP5R_STAT_RX() uint32 {
	return (volatile.LoadUint32(&o.EP5R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP5R_DTOG_RX(value uint32) {
	volatile.StoreUint32(&o.EP5R.Reg, volatile.LoadUint32(&o.EP5R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP5R_DTOG_RX() uint32 {
	return (volatile.LoadUint32(&o.EP5R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP5R_CTR_RX(value uint32) {
	volatile.StoreUint32(&o.EP5R.Reg, volatile.LoadUint32(&o.EP5R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP5R_CTR_RX() uint32 {
	return (volatile.LoadUint32(&o.EP5R.Reg) & 0x8000) >> 15
}

// USB.EP6R: USB endpoint n register
func (o *USB_Type) SetEP6R_EA(value uint32) {
	volatile.StoreUint32(&o.EP6R.Reg, volatile.LoadUint32(&o.EP6R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP6R_EA() uint32 {
	return volatile.LoadUint32(&o.EP6R.Reg) & 0xf
}
func (o *USB_Type) SetEP6R_STAT_TX(value uint32) {
	volatile.StoreUint32(&o.EP6R.Reg, volatile.LoadUint32(&o.EP6R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP6R_STAT_TX() uint32 {
	return (volatile.LoadUint32(&o.EP6R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP6R_DTOG_TX(value uint32) {
	volatile.StoreUint32(&o.EP6R.Reg, volatile.LoadUint32(&o.EP6R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP6R_DTOG_TX() uint32 {
	return (volatile.LoadUint32(&o.EP6R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP6R_CTR_TX(value uint32) {
	volatile.StoreUint32(&o.EP6R.Reg, volatile.LoadUint32(&o.EP6R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP6R_CTR_TX() uint32 {
	return (volatile.LoadUint32(&o.EP6R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP6R_EP_KIND(value uint32) {
	volatile.StoreUint32(&o.EP6R.Reg, volatile.LoadUint32(&o.EP6R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP6R_EP_KIND() uint32 {
	return (volatile.LoadUint32(&o.EP6R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP6R_EP_TYPE(value uint32) {
	volatile.StoreUint32(&o.EP6R.Reg, volatile.LoadUint32(&o.EP6R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP6R_EP_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EP6R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP6R_SETUP(value uint32) {
	volatile.StoreUint32(&o.EP6R.Reg, volatile.LoadUint32(&o.EP6R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP6R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EP6R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP6R_STAT_RX(value uint32) {
	volatile.StoreUint32(&o.EP6R.Reg, volatile.LoadUint32(&o.EP6R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP6R_STAT_RX() uint32 {
	return (volatile.LoadUint32(&o.EP6R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP6R_DTOG_RX(value uint32) {
	volatile.StoreUint32(&o.EP6R.Reg, volatile.LoadUint32(&o.EP6R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP6R_DTOG_RX() uint32 {
	return (volatile.LoadUint32(&o.EP6R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP6R_CTR_RX(value uint32) {
	volatile.StoreUint32(&o.EP6R.Reg, volatile.LoadUint32(&o.EP6R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP6R_CTR_RX() uint32 {
	return (volatile.LoadUint32(&o.EP6R.Reg) & 0x8000) >> 15
}

// USB.EP7R: USB endpoint n register
func (o *USB_Type) SetEP7R_EA(value uint32) {
	volatile.StoreUint32(&o.EP7R.Reg, volatile.LoadUint32(&o.EP7R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP7R_EA() uint32 {
	return volatile.LoadUint32(&o.EP7R.Reg) & 0xf
}
func (o *USB_Type) SetEP7R_STAT_TX(value uint32) {
	volatile.StoreUint32(&o.EP7R.Reg, volatile.LoadUint32(&o.EP7R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP7R_STAT_TX() uint32 {
	return (volatile.LoadUint32(&o.EP7R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP7R_DTOG_TX(value uint32) {
	volatile.StoreUint32(&o.EP7R.Reg, volatile.LoadUint32(&o.EP7R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP7R_DTOG_TX() uint32 {
	return (volatile.LoadUint32(&o.EP7R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP7R_CTR_TX(value uint32) {
	volatile.StoreUint32(&o.EP7R.Reg, volatile.LoadUint32(&o.EP7R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP7R_CTR_TX() uint32 {
	return (volatile.LoadUint32(&o.EP7R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP7R_EP_KIND(value uint32) {
	volatile.StoreUint32(&o.EP7R.Reg, volatile.LoadUint32(&o.EP7R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP7R_EP_KIND() uint32 {
	return (volatile.LoadUint32(&o.EP7R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP7R_EP_TYPE(value uint32) {
	volatile.StoreUint32(&o.EP7R.Reg, volatile.LoadUint32(&o.EP7R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP7R_EP_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EP7R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP7R_SETUP(value uint32) {
	volatile.StoreUint32(&o.EP7R.Reg, volatile.LoadUint32(&o.EP7R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP7R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EP7R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP7R_STAT_RX(value uint32) {
	volatile.StoreUint32(&o.EP7R.Reg, volatile.LoadUint32(&o.EP7R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP7R_STAT_RX() uint32 {
	return (volatile.LoadUint32(&o.EP7R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP7R_DTOG_RX(value uint32) {
	volatile.StoreUint32(&o.EP7R.Reg, volatile.LoadUint32(&o.EP7R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP7R_DTOG_RX() uint32 {
	return (volatile.LoadUint32(&o.EP7R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP7R_CTR_RX(value uint32) {
	volatile.StoreUint32(&o.EP7R.Reg, volatile.LoadUint32(&o.EP7R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP7R_CTR_RX() uint32 {
	return (volatile.LoadUint32(&o.EP7R.Reg) & 0x8000) >> 15
}

// USB.CNTR: USB control register
func (o *USB_Type) SetCNTR_FRES(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetCNTR_FRES() uint32 {
	return volatile.LoadUint32(&o.CNTR.Reg) & 0x1
}
func (o *USB_Type) SetCNTR_PDWN(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetCNTR_PDWN() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetCNTR_LP_MODE(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetCNTR_LP_MODE() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetCNTR_FSUSP(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetCNTR_FSUSP() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetCNTR_RESUME(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetCNTR_RESUME() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetCNTR_L1RESUME(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetCNTR_L1RESUME() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetCNTR_L1REQM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetCNTR_L1REQM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetCNTR_ESOFM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetCNTR_ESOFM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetCNTR_SOFM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetCNTR_SOFM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetCNTR_RESETM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetCNTR_RESETM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetCNTR_SUSPM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetCNTR_SUSPM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetCNTR_WKUPM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetCNTR_WKUPM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetCNTR_ERRM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetCNTR_ERRM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetCNTR_PMAOVRM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetCNTR_PMAOVRM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetCNTR_CTRM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetCNTR_CTRM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x8000) >> 15
}

// USB.ISTR: USB interrupt status register
func (o *USB_Type) SetISTR_EP_ID(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetISTR_EP_ID() uint32 {
	return volatile.LoadUint32(&o.ISTR.Reg) & 0xf
}
func (o *USB_Type) SetISTR_DIR(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetISTR_DIR() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetISTR_L1REQ(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetISTR_L1REQ() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetISTR_ESOF(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetISTR_ESOF() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetISTR_SOF(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetISTR_SOF() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetISTR_RESET(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetISTR_RESET() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetISTR_SUSP(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetISTR_SUSP() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetISTR_WKUP(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetISTR_WKUP() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetISTR_ERR(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetISTR_ERR() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetISTR_PMAOVR(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetISTR_PMAOVR() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetISTR_CTR(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetISTR_CTR() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x8000) >> 15
}

// USB.FNR: USB frame number register
func (o *USB_Type) SetFNR_FN(value uint32) {
	volatile.StoreUint32(&o.FNR.Reg, volatile.LoadUint32(&o.FNR.Reg)&^(0x7ff)|value)
}
func (o *USB_Type) GetFNR_FN() uint32 {
	return volatile.LoadUint32(&o.FNR.Reg) & 0x7ff
}
func (o *USB_Type) SetFNR_LSOF(value uint32) {
	volatile.StoreUint32(&o.FNR.Reg, volatile.LoadUint32(&o.FNR.Reg)&^(0x1800)|value<<11)
}
func (o *USB_Type) GetFNR_LSOF() uint32 {
	return (volatile.LoadUint32(&o.FNR.Reg) & 0x1800) >> 11
}
func (o *USB_Type) SetFNR_LCK(value uint32) {
	volatile.StoreUint32(&o.FNR.Reg, volatile.LoadUint32(&o.FNR.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetFNR_LCK() uint32 {
	return (volatile.LoadUint32(&o.FNR.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetFNR_RXDM(value uint32) {
	volatile.StoreUint32(&o.FNR.Reg, volatile.LoadUint32(&o.FNR.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetFNR_RXDM() uint32 {
	return (volatile.LoadUint32(&o.FNR.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetFNR_RXDP(value uint32) {
	volatile.StoreUint32(&o.FNR.Reg, volatile.LoadUint32(&o.FNR.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetFNR_RXDP() uint32 {
	return (volatile.LoadUint32(&o.FNR.Reg) & 0x8000) >> 15
}

// USB.DADDR: USB device address
func (o *USB_Type) SetDADDR_ADD(value uint32) {
	volatile.StoreUint32(&o.DADDR.Reg, volatile.LoadUint32(&o.DADDR.Reg)&^(0x7f)|value)
}
func (o *USB_Type) GetDADDR_ADD() uint32 {
	return volatile.LoadUint32(&o.DADDR.Reg) & 0x7f
}
func (o *USB_Type) SetDADDR_EF(value uint32) {
	volatile.StoreUint32(&o.DADDR.Reg, volatile.LoadUint32(&o.DADDR.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetDADDR_EF() uint32 {
	return (volatile.LoadUint32(&o.DADDR.Reg) & 0x80) >> 7
}

// USB.BTABLE: Buffer table address
func (o *USB_Type) SetBTABLE(value uint32) {
	volatile.StoreUint32(&o.BTABLE.Reg, volatile.LoadUint32(&o.BTABLE.Reg)&^(0xfff8)|value<<3)
}
func (o *USB_Type) GetBTABLE() uint32 {
	return (volatile.LoadUint32(&o.BTABLE.Reg) & 0xfff8) >> 3
}

// USB.BCDR: Battery Charging Detector
func (o *USB_Type) SetBCDR_DPPU(value uint32) {
	volatile.StoreUint32(&o.BCDR.Reg, volatile.LoadUint32(&o.BCDR.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetBCDR_DPPU() uint32 {
	return (volatile.LoadUint32(&o.BCDR.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetBCDR_PS2DET(value uint32) {
	volatile.StoreUint32(&o.BCDR.Reg, volatile.LoadUint32(&o.BCDR.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetBCDR_PS2DET() uint32 {
	return (volatile.LoadUint32(&o.BCDR.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetBCDR_SDET(value uint32) {
	volatile.StoreUint32(&o.BCDR.Reg, volatile.LoadUint32(&o.BCDR.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetBCDR_SDET() uint32 {
	return (volatile.LoadUint32(&o.BCDR.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetBCDR_PDET(value uint32) {
	volatile.StoreUint32(&o.BCDR.Reg, volatile.LoadUint32(&o.BCDR.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetBCDR_PDET() uint32 {
	return (volatile.LoadUint32(&o.BCDR.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetBCDR_DCDET(value uint32) {
	volatile.StoreUint32(&o.BCDR.Reg, volatile.LoadUint32(&o.BCDR.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetBCDR_DCDET() uint32 {
	return (volatile.LoadUint32(&o.BCDR.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetBCDR_SDEN(value uint32) {
	volatile.StoreUint32(&o.BCDR.Reg, volatile.LoadUint32(&o.BCDR.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetBCDR_SDEN() uint32 {
	return (volatile.LoadUint32(&o.BCDR.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetBCDR_PDEN(value uint32) {
	volatile.StoreUint32(&o.BCDR.Reg, volatile.LoadUint32(&o.BCDR.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetBCDR_PDEN() uint32 {
	return (volatile.LoadUint32(&o.BCDR.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetBCDR_DCDEN(value uint32) {
	volatile.StoreUint32(&o.BCDR.Reg, volatile.LoadUint32(&o.BCDR.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetBCDR_DCDEN() uint32 {
	return (volatile.LoadUint32(&o.BCDR.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetBCDR_BCDEN(value uint32) {
	volatile.StoreUint32(&o.BCDR.Reg, volatile.LoadUint32(&o.BCDR.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetBCDR_BCDEN() uint32 {
	return volatile.LoadUint32(&o.BCDR.Reg) & 0x1
}

// CRS
type CRS_Type struct {
	CR   volatile.Register32 // 0x0
	CFGR volatile.Register32 // 0x4
	ISR  volatile.Register32 // 0x8
	ICR  volatile.Register32 // 0xC
}

// CRS.CR: CRS control register
func (o *CRS_Type) SetCR_SYNCOKIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *CRS_Type) GetCR_SYNCOKIE() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *CRS_Type) SetCR_SYNCWARNIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *CRS_Type) GetCR_SYNCWARNIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *CRS_Type) SetCR_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *CRS_Type) GetCR_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *CRS_Type) SetCR_ESYNCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *CRS_Type) GetCR_ESYNCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *CRS_Type) SetCR_CEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *CRS_Type) GetCR_CEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *CRS_Type) SetCR_AUTOTRIMEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *CRS_Type) GetCR_AUTOTRIMEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *CRS_Type) SetCR_SWSYNC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *CRS_Type) GetCR_SWSYNC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *CRS_Type) SetCR_TRIM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7f00)|value<<8)
}
func (o *CRS_Type) GetCR_TRIM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x7f00) >> 8
}

// CRS.CFGR: This register can be written only when the frequency error counter is disabled (CEN bit is cleared in CRS_CR). When the counter is enabled, this register is write-protected.
func (o *CRS_Type) SetCFGR_RELOAD(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xffff)|value)
}
func (o *CRS_Type) GetCFGR_RELOAD() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0xffff
}
func (o *CRS_Type) SetCFGR_FELIM(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xff0000)|value<<16)
}
func (o *CRS_Type) GetCFGR_FELIM() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xff0000) >> 16
}
func (o *CRS_Type) SetCFGR_SYNCDIV(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x7000000)|value<<24)
}
func (o *CRS_Type) GetCFGR_SYNCDIV() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x7000000) >> 24
}
func (o *CRS_Type) SetCFGR_SYNCSRC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x30000000)|value<<28)
}
func (o *CRS_Type) GetCFGR_SYNCSRC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x30000000) >> 28
}
func (o *CRS_Type) SetCFGR_SYNCPOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80000000)|value<<31)
}
func (o *CRS_Type) GetCFGR_SYNCPOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80000000) >> 31
}

// CRS.ISR: CRS interrupt and status register
func (o *CRS_Type) SetISR_SYNCOKF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *CRS_Type) GetISR_SYNCOKF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *CRS_Type) SetISR_SYNCWARNF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *CRS_Type) GetISR_SYNCWARNF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *CRS_Type) SetISR_ERRF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *CRS_Type) GetISR_ERRF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *CRS_Type) SetISR_ESYNCF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *CRS_Type) GetISR_ESYNCF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *CRS_Type) SetISR_SYNCERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *CRS_Type) GetISR_SYNCERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *CRS_Type) SetISR_SYNCMISS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *CRS_Type) GetISR_SYNCMISS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *CRS_Type) SetISR_TRIMOVF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *CRS_Type) GetISR_TRIMOVF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *CRS_Type) SetISR_FEDIR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *CRS_Type) GetISR_FEDIR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *CRS_Type) SetISR_FECAP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xffff0000)|value<<16)
}
func (o *CRS_Type) GetISR_FECAP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xffff0000) >> 16
}

// CRS.ICR: CRS interrupt flag clear register
func (o *CRS_Type) SetICR_SYNCOKC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *CRS_Type) GetICR_SYNCOKC() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}
func (o *CRS_Type) SetICR_SYNCWARNC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *CRS_Type) GetICR_SYNCWARNC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *CRS_Type) SetICR_ERRC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *CRS_Type) GetICR_ERRC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *CRS_Type) SetICR_ESYNCC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *CRS_Type) GetICR_ESYNCC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}

// Constants for CRC: Cyclic redundancy check calculation unit
const (
	// DR: Data register
	// Position of DR field.
	CRC_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	CRC_DR_DR_Msk = 0xffffffff

	// IDR: Independent data register
	// Position of IDR field.
	CRC_IDR_IDR_Pos = 0x0
	// Bit mask of IDR field.
	CRC_IDR_IDR_Msk = 0xffffffff

	// CR: Control register
	// Position of REV_OUT field.
	CRC_CR_REV_OUT_Pos = 0x7
	// Bit mask of REV_OUT field.
	CRC_CR_REV_OUT_Msk = 0x80
	// Bit REV_OUT.
	CRC_CR_REV_OUT = 0x80
	// Position of REV_IN field.
	CRC_CR_REV_IN_Pos = 0x5
	// Bit mask of REV_IN field.
	CRC_CR_REV_IN_Msk = 0x60
	// Position of POLYSIZE field.
	CRC_CR_POLYSIZE_Pos = 0x3
	// Bit mask of POLYSIZE field.
	CRC_CR_POLYSIZE_Msk = 0x18
	// Position of RESET field.
	CRC_CR_RESET_Pos = 0x0
	// Bit mask of RESET field.
	CRC_CR_RESET_Msk = 0x1
	// Bit RESET.
	CRC_CR_RESET = 0x1

	// INIT: Initial CRC value
	// Position of CRC_INIT field.
	CRC_INIT_CRC_INIT_Pos = 0x0
	// Bit mask of CRC_INIT field.
	CRC_INIT_CRC_INIT_Msk = 0xffffffff

	// POL: polynomial
	// Position of POL field.
	CRC_POL_POL_Pos = 0x0
	// Bit mask of POL field.
	CRC_POL_POL_Msk = 0xffffffff
)

// Constants for IWDG: WinWATCHDOG
const (
	// KR: Key register
	// Position of KEY field.
	IWDG_KR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	IWDG_KR_KEY_Msk = 0xffff
	// Enable access to PR, RLR and WINR registers (0x5555)
	IWDG_KR_KEY_Enable = 0x5555
	// Reset the watchdog value (0xAAAA)
	IWDG_KR_KEY_Reset = 0xaaaa
	// Start the watchdog (0xCCCC)
	IWDG_KR_KEY_Start = 0xcccc

	// PR: Prescaler register
	// Position of PR field.
	IWDG_PR_PR_Pos = 0x0
	// Bit mask of PR field.
	IWDG_PR_PR_Msk = 0x7
	// Divider /4
	IWDG_PR_PR_DivideBy4 = 0x0
	// Divider /8
	IWDG_PR_PR_DivideBy8 = 0x1
	// Divider /16
	IWDG_PR_PR_DivideBy16 = 0x2
	// Divider /32
	IWDG_PR_PR_DivideBy32 = 0x3
	// Divider /64
	IWDG_PR_PR_DivideBy64 = 0x4
	// Divider /128
	IWDG_PR_PR_DivideBy128 = 0x5
	// Divider /256
	IWDG_PR_PR_DivideBy256 = 0x6
	// Divider /256
	IWDG_PR_PR_DivideBy256bis = 0x7

	// RLR: Reload register
	// Position of RL field.
	IWDG_RLR_RL_Pos = 0x0
	// Bit mask of RL field.
	IWDG_RLR_RL_Msk = 0xfff

	// SR: Status register
	// Position of WVU field.
	IWDG_SR_WVU_Pos = 0x2
	// Bit mask of WVU field.
	IWDG_SR_WVU_Msk = 0x4
	// Bit WVU.
	IWDG_SR_WVU = 0x4
	// Position of RVU field.
	IWDG_SR_RVU_Pos = 0x1
	// Bit mask of RVU field.
	IWDG_SR_RVU_Msk = 0x2
	// Bit RVU.
	IWDG_SR_RVU = 0x2
	// Position of PVU field.
	IWDG_SR_PVU_Pos = 0x0
	// Bit mask of PVU field.
	IWDG_SR_PVU_Msk = 0x1
	// Bit PVU.
	IWDG_SR_PVU = 0x1

	// WINR: Window register
	// Position of WIN field.
	IWDG_WINR_WIN_Pos = 0x0
	// Bit mask of WIN field.
	IWDG_WINR_WIN_Msk = 0xfff
)

// Constants for WWDG: System window watchdog
const (
	// CR: Control register
	// Position of WDGA field.
	WWDG_CR_WDGA_Pos = 0x7
	// Bit mask of WDGA field.
	WWDG_CR_WDGA_Msk = 0x80
	// Bit WDGA.
	WWDG_CR_WDGA = 0x80
	// Watchdog disabled
	WWDG_CR_WDGA_Disabled = 0x0
	// Watchdog enabled
	WWDG_CR_WDGA_Enabled = 0x1
	// Position of T field.
	WWDG_CR_T_Pos = 0x0
	// Bit mask of T field.
	WWDG_CR_T_Msk = 0x7f

	// CFR: Configuration register
	// Position of EWI field.
	WWDG_CFR_EWI_Pos = 0x9
	// Bit mask of EWI field.
	WWDG_CFR_EWI_Msk = 0x200
	// Bit EWI.
	WWDG_CFR_EWI = 0x200
	// interrupt occurs whenever the counter reaches the value 0x40
	WWDG_CFR_EWI_Enable = 0x1
	// Position of W field.
	WWDG_CFR_W_Pos = 0x0
	// Bit mask of W field.
	WWDG_CFR_W_Msk = 0x7f
	// Position of WDGTB field.
	WWDG_CFR_WDGTB_Pos = 0xb
	// Bit mask of WDGTB field.
	WWDG_CFR_WDGTB_Msk = 0x3800
	// Counter clock (PCLK1 div 4096) div 16
	WWDG_CFR_WDGTB_Div16 = 0x4
	// Counter clock (PCLK1 div 4096) div 32
	WWDG_CFR_WDGTB_Div32 = 0x5
	// Counter clock (PCLK1 div 4096) div 64
	WWDG_CFR_WDGTB_Div64 = 0x6
	// Counter clock (PCLK1 div 4096) div 128
	WWDG_CFR_WDGTB_Div128 = 0x7
	// Counter clock (PCLK1 div 4096) div 1
	WWDG_CFR_WDGTB_Div1 = 0x0
	// Counter clock (PCLK1 div 4096) div 2
	WWDG_CFR_WDGTB_Div2 = 0x1
	// Counter clock (PCLK1 div 4096) div 4
	WWDG_CFR_WDGTB_Div4 = 0x2
	// Counter clock (PCLK1 div 4096) div 8
	WWDG_CFR_WDGTB_Div8 = 0x3

	// SR: Status register
	// Position of EWIF field.
	WWDG_SR_EWIF_Pos = 0x0
	// Bit mask of EWIF field.
	WWDG_SR_EWIF_Msk = 0x1
	// Bit EWIF.
	WWDG_SR_EWIF = 0x1
	// The EWI Interrupt Service Routine has been triggered
	WWDG_SR_EWIF_Pending = 0x1
	// The EWI Interrupt Service Routine has been serviced
	WWDG_SR_EWIF_Finished = 0x0
)

// Constants for I2C1: Inter-integrated circuit
const (
	// CR1: Control register 1
	// Position of PE field.
	I2C_CR1_PE_Pos = 0x0
	// Bit mask of PE field.
	I2C_CR1_PE_Msk = 0x1
	// Bit PE.
	I2C_CR1_PE = 0x1
	// Peripheral disabled
	I2C_CR1_PE_Disabled = 0x0
	// Peripheral enabled
	I2C_CR1_PE_Enabled = 0x1
	// Position of TXIE field.
	I2C_CR1_TXIE_Pos = 0x1
	// Bit mask of TXIE field.
	I2C_CR1_TXIE_Msk = 0x2
	// Bit TXIE.
	I2C_CR1_TXIE = 0x2
	// Transmit (TXIS) interrupt disabled
	I2C_CR1_TXIE_Disabled = 0x0
	// Transmit (TXIS) interrupt enabled
	I2C_CR1_TXIE_Enabled = 0x1
	// Position of RXIE field.
	I2C_CR1_RXIE_Pos = 0x2
	// Bit mask of RXIE field.
	I2C_CR1_RXIE_Msk = 0x4
	// Bit RXIE.
	I2C_CR1_RXIE = 0x4
	// Receive (RXNE) interrupt disabled
	I2C_CR1_RXIE_Disabled = 0x0
	// Receive (RXNE) interrupt enabled
	I2C_CR1_RXIE_Enabled = 0x1
	// Position of ADDRIE field.
	I2C_CR1_ADDRIE_Pos = 0x3
	// Bit mask of ADDRIE field.
	I2C_CR1_ADDRIE_Msk = 0x8
	// Bit ADDRIE.
	I2C_CR1_ADDRIE = 0x8
	// Address match (ADDR) interrupts disabled
	I2C_CR1_ADDRIE_Disabled = 0x0
	// Address match (ADDR) interrupts enabled
	I2C_CR1_ADDRIE_Enabled = 0x1
	// Position of NACKIE field.
	I2C_CR1_NACKIE_Pos = 0x4
	// Bit mask of NACKIE field.
	I2C_CR1_NACKIE_Msk = 0x10
	// Bit NACKIE.
	I2C_CR1_NACKIE = 0x10
	// Not acknowledge (NACKF) received interrupts disabled
	I2C_CR1_NACKIE_Disabled = 0x0
	// Not acknowledge (NACKF) received interrupts enabled
	I2C_CR1_NACKIE_Enabled = 0x1
	// Position of STOPIE field.
	I2C_CR1_STOPIE_Pos = 0x5
	// Bit mask of STOPIE field.
	I2C_CR1_STOPIE_Msk = 0x20
	// Bit STOPIE.
	I2C_CR1_STOPIE = 0x20
	// Stop detection (STOPF) interrupt disabled
	I2C_CR1_STOPIE_Disabled = 0x0
	// Stop detection (STOPF) interrupt enabled
	I2C_CR1_STOPIE_Enabled = 0x1
	// Position of TCIE field.
	I2C_CR1_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	I2C_CR1_TCIE_Msk = 0x40
	// Bit TCIE.
	I2C_CR1_TCIE = 0x40
	// Transfer Complete interrupt disabled
	I2C_CR1_TCIE_Disabled = 0x0
	// Transfer Complete interrupt enabled
	I2C_CR1_TCIE_Enabled = 0x1
	// Position of ERRIE field.
	I2C_CR1_ERRIE_Pos = 0x7
	// Bit mask of ERRIE field.
	I2C_CR1_ERRIE_Msk = 0x80
	// Bit ERRIE.
	I2C_CR1_ERRIE = 0x80
	// Error detection interrupts disabled
	I2C_CR1_ERRIE_Disabled = 0x0
	// Error detection interrupts enabled
	I2C_CR1_ERRIE_Enabled = 0x1
	// Position of DNF field.
	I2C_CR1_DNF_Pos = 0x8
	// Bit mask of DNF field.
	I2C_CR1_DNF_Msk = 0xf00
	// Digital filter disabled
	I2C_CR1_DNF_NoFilter = 0x0
	// Digital filter enabled and filtering capability up to 1 tI2CCLK
	I2C_CR1_DNF_Filter1 = 0x1
	// Digital filter enabled and filtering capability up to 2 tI2CCLK
	I2C_CR1_DNF_Filter2 = 0x2
	// Digital filter enabled and filtering capability up to 3 tI2CCLK
	I2C_CR1_DNF_Filter3 = 0x3
	// Digital filter enabled and filtering capability up to 4 tI2CCLK
	I2C_CR1_DNF_Filter4 = 0x4
	// Digital filter enabled and filtering capability up to 5 tI2CCLK
	I2C_CR1_DNF_Filter5 = 0x5
	// Digital filter enabled and filtering capability up to 6 tI2CCLK
	I2C_CR1_DNF_Filter6 = 0x6
	// Digital filter enabled and filtering capability up to 7 tI2CCLK
	I2C_CR1_DNF_Filter7 = 0x7
	// Digital filter enabled and filtering capability up to 8 tI2CCLK
	I2C_CR1_DNF_Filter8 = 0x8
	// Digital filter enabled and filtering capability up to 9 tI2CCLK
	I2C_CR1_DNF_Filter9 = 0x9
	// Digital filter enabled and filtering capability up to 10 tI2CCLK
	I2C_CR1_DNF_Filter10 = 0xa
	// Digital filter enabled and filtering capability up to 11 tI2CCLK
	I2C_CR1_DNF_Filter11 = 0xb
	// Digital filter enabled and filtering capability up to 12 tI2CCLK
	I2C_CR1_DNF_Filter12 = 0xc
	// Digital filter enabled and filtering capability up to 13 tI2CCLK
	I2C_CR1_DNF_Filter13 = 0xd
	// Digital filter enabled and filtering capability up to 14 tI2CCLK
	I2C_CR1_DNF_Filter14 = 0xe
	// Digital filter enabled and filtering capability up to 15 tI2CCLK
	I2C_CR1_DNF_Filter15 = 0xf
	// Position of ANFOFF field.
	I2C_CR1_ANFOFF_Pos = 0xc
	// Bit mask of ANFOFF field.
	I2C_CR1_ANFOFF_Msk = 0x1000
	// Bit ANFOFF.
	I2C_CR1_ANFOFF = 0x1000
	// Analog noise filter enabled
	I2C_CR1_ANFOFF_Enabled = 0x0
	// Analog noise filter disabled
	I2C_CR1_ANFOFF_Disabled = 0x1
	// Position of TXDMAEN field.
	I2C_CR1_TXDMAEN_Pos = 0xe
	// Bit mask of TXDMAEN field.
	I2C_CR1_TXDMAEN_Msk = 0x4000
	// Bit TXDMAEN.
	I2C_CR1_TXDMAEN = 0x4000
	// DMA mode disabled for transmission
	I2C_CR1_TXDMAEN_Disabled = 0x0
	// DMA mode enabled for transmission
	I2C_CR1_TXDMAEN_Enabled = 0x1
	// Position of RXDMAEN field.
	I2C_CR1_RXDMAEN_Pos = 0xf
	// Bit mask of RXDMAEN field.
	I2C_CR1_RXDMAEN_Msk = 0x8000
	// Bit RXDMAEN.
	I2C_CR1_RXDMAEN = 0x8000
	// DMA mode disabled for reception
	I2C_CR1_RXDMAEN_Disabled = 0x0
	// DMA mode enabled for reception
	I2C_CR1_RXDMAEN_Enabled = 0x1
	// Position of SBC field.
	I2C_CR1_SBC_Pos = 0x10
	// Bit mask of SBC field.
	I2C_CR1_SBC_Msk = 0x10000
	// Bit SBC.
	I2C_CR1_SBC = 0x10000
	// Slave byte control disabled
	I2C_CR1_SBC_Disabled = 0x0
	// Slave byte control enabled
	I2C_CR1_SBC_Enabled = 0x1
	// Position of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Pos = 0x11
	// Bit mask of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Msk = 0x20000
	// Bit NOSTRETCH.
	I2C_CR1_NOSTRETCH = 0x20000
	// Clock stretching enabled
	I2C_CR1_NOSTRETCH_Enabled = 0x0
	// Clock stretching disabled
	I2C_CR1_NOSTRETCH_Disabled = 0x1
	// Position of WUPEN field.
	I2C_CR1_WUPEN_Pos = 0x12
	// Bit mask of WUPEN field.
	I2C_CR1_WUPEN_Msk = 0x40000
	// Bit WUPEN.
	I2C_CR1_WUPEN = 0x40000
	// Wakeup from Stop mode disabled
	I2C_CR1_WUPEN_Disabled = 0x0
	// Wakeup from Stop mode enabled
	I2C_CR1_WUPEN_Enabled = 0x1
	// Position of GCEN field.
	I2C_CR1_GCEN_Pos = 0x13
	// Bit mask of GCEN field.
	I2C_CR1_GCEN_Msk = 0x80000
	// Bit GCEN.
	I2C_CR1_GCEN = 0x80000
	// General call disabled. Address 0b00000000 is NACKed
	I2C_CR1_GCEN_Disabled = 0x0
	// General call enabled. Address 0b00000000 is ACKed
	I2C_CR1_GCEN_Enabled = 0x1
	// Position of SMBHEN field.
	I2C_CR1_SMBHEN_Pos = 0x14
	// Bit mask of SMBHEN field.
	I2C_CR1_SMBHEN_Msk = 0x100000
	// Bit SMBHEN.
	I2C_CR1_SMBHEN = 0x100000
	// Host address disabled. Address 0b0001000x is NACKed
	I2C_CR1_SMBHEN_Disabled = 0x0
	// Host address enabled. Address 0b0001000x is ACKed
	I2C_CR1_SMBHEN_Enabled = 0x1
	// Position of SMBDEN field.
	I2C_CR1_SMBDEN_Pos = 0x15
	// Bit mask of SMBDEN field.
	I2C_CR1_SMBDEN_Msk = 0x200000
	// Bit SMBDEN.
	I2C_CR1_SMBDEN = 0x200000
	// Device default address disabled. Address 0b1100001x is NACKed
	I2C_CR1_SMBDEN_Disabled = 0x0
	// Device default address enabled. Address 0b1100001x is ACKed
	I2C_CR1_SMBDEN_Enabled = 0x1
	// Position of ALERTEN field.
	I2C_CR1_ALERTEN_Pos = 0x16
	// Bit mask of ALERTEN field.
	I2C_CR1_ALERTEN_Msk = 0x400000
	// Bit ALERTEN.
	I2C_CR1_ALERTEN = 0x400000
	// In device mode (SMBHEN=Disabled) Releases SMBA pin high and Alert Response Address Header disabled (0001100x) followed by NACK. In host mode (SMBHEN=Enabled) SMBus Alert pin (SMBA) not supported
	I2C_CR1_ALERTEN_Disabled = 0x0
	// In device mode (SMBHEN=Disabled) Drives SMBA pin low and Alert Response Address Header enabled (0001100x) followed by ACK.In host mode (SMBHEN=Enabled) SMBus Alert pin (SMBA) supported
	I2C_CR1_ALERTEN_Enabled = 0x1
	// Position of PECEN field.
	I2C_CR1_PECEN_Pos = 0x17
	// Bit mask of PECEN field.
	I2C_CR1_PECEN_Msk = 0x800000
	// Bit PECEN.
	I2C_CR1_PECEN = 0x800000
	// PEC calculation disabled
	I2C_CR1_PECEN_Disabled = 0x0
	// PEC calculation enabled
	I2C_CR1_PECEN_Enabled = 0x1

	// CR2: Control register 2
	// Position of PECBYTE field.
	I2C_CR2_PECBYTE_Pos = 0x1a
	// Bit mask of PECBYTE field.
	I2C_CR2_PECBYTE_Msk = 0x4000000
	// Bit PECBYTE.
	I2C_CR2_PECBYTE = 0x4000000
	// No PEC transfer
	I2C_CR2_PECBYTE_NoPec = 0x0
	// PEC transmission/reception is requested
	I2C_CR2_PECBYTE_Pec = 0x1
	// Position of AUTOEND field.
	I2C_CR2_AUTOEND_Pos = 0x19
	// Bit mask of AUTOEND field.
	I2C_CR2_AUTOEND_Msk = 0x2000000
	// Bit AUTOEND.
	I2C_CR2_AUTOEND = 0x2000000
	// Software end mode: TC flag is set when NBYTES data are transferred, stretching SCL low
	I2C_CR2_AUTOEND_Software = 0x0
	// Automatic end mode: a STOP condition is automatically sent when NBYTES data are transferred
	I2C_CR2_AUTOEND_Automatic = 0x1
	// Position of RELOAD field.
	I2C_CR2_RELOAD_Pos = 0x18
	// Bit mask of RELOAD field.
	I2C_CR2_RELOAD_Msk = 0x1000000
	// Bit RELOAD.
	I2C_CR2_RELOAD = 0x1000000
	// The transfer is completed after the NBYTES data transfer (STOP or RESTART will follow)
	I2C_CR2_RELOAD_Completed = 0x0
	// The transfer is not completed after the NBYTES data transfer (NBYTES will be reloaded)
	I2C_CR2_RELOAD_NotCompleted = 0x1
	// Position of NBYTES field.
	I2C_CR2_NBYTES_Pos = 0x10
	// Bit mask of NBYTES field.
	I2C_CR2_NBYTES_Msk = 0xff0000
	// Position of NACK field.
	I2C_CR2_NACK_Pos = 0xf
	// Bit mask of NACK field.
	I2C_CR2_NACK_Msk = 0x8000
	// Bit NACK.
	I2C_CR2_NACK = 0x8000
	// an ACK is sent after current received byte
	I2C_CR2_NACK_Ack = 0x0
	// a NACK is sent after current received byte
	I2C_CR2_NACK_Nack = 0x1
	// Position of STOP field.
	I2C_CR2_STOP_Pos = 0xe
	// Bit mask of STOP field.
	I2C_CR2_STOP_Msk = 0x4000
	// Bit STOP.
	I2C_CR2_STOP = 0x4000
	// No Stop generation
	I2C_CR2_STOP_NoStop = 0x0
	// Stop generation after current byte transfer
	I2C_CR2_STOP_Stop = 0x1
	// Position of START field.
	I2C_CR2_START_Pos = 0xd
	// Bit mask of START field.
	I2C_CR2_START_Msk = 0x2000
	// Bit START.
	I2C_CR2_START = 0x2000
	// No Start generation
	I2C_CR2_START_NoStart = 0x0
	// Restart/Start generation
	I2C_CR2_START_Start = 0x1
	// Position of HEAD10R field.
	I2C_CR2_HEAD10R_Pos = 0xc
	// Bit mask of HEAD10R field.
	I2C_CR2_HEAD10R_Msk = 0x1000
	// Bit HEAD10R.
	I2C_CR2_HEAD10R = 0x1000
	// The master sends the complete 10 bit slave address read sequence
	I2C_CR2_HEAD10R_Complete = 0x0
	// The master only sends the 1st 7 bits of the 10 bit address, followed by Read direction
	I2C_CR2_HEAD10R_Partial = 0x1
	// Position of ADD10 field.
	I2C_CR2_ADD10_Pos = 0xb
	// Bit mask of ADD10 field.
	I2C_CR2_ADD10_Msk = 0x800
	// Bit ADD10.
	I2C_CR2_ADD10 = 0x800
	// The master operates in 7-bit addressing mode
	I2C_CR2_ADD10_Bit7 = 0x0
	// The master operates in 10-bit addressing mode
	I2C_CR2_ADD10_Bit10 = 0x1
	// Position of RD_WRN field.
	I2C_CR2_RD_WRN_Pos = 0xa
	// Bit mask of RD_WRN field.
	I2C_CR2_RD_WRN_Msk = 0x400
	// Bit RD_WRN.
	I2C_CR2_RD_WRN = 0x400
	// Master requests a write transfer
	I2C_CR2_RD_WRN_Write = 0x0
	// Master requests a read transfer
	I2C_CR2_RD_WRN_Read = 0x1
	// Position of SADD field.
	I2C_CR2_SADD_Pos = 0x0
	// Bit mask of SADD field.
	I2C_CR2_SADD_Msk = 0x3ff

	// OAR1: Own address register 1
	// Position of OA1 field.
	I2C_OAR1_OA1_Pos = 0x0
	// Bit mask of OA1 field.
	I2C_OAR1_OA1_Msk = 0x3ff
	// Position of OA1MODE field.
	I2C_OAR1_OA1MODE_Pos = 0xa
	// Bit mask of OA1MODE field.
	I2C_OAR1_OA1MODE_Msk = 0x400
	// Bit OA1MODE.
	I2C_OAR1_OA1MODE = 0x400
	// Own address 1 is a 7-bit address
	I2C_OAR1_OA1MODE_Bit7 = 0x0
	// Own address 1 is a 10-bit address
	I2C_OAR1_OA1MODE_Bit10 = 0x1
	// Position of OA1EN field.
	I2C_OAR1_OA1EN_Pos = 0xf
	// Bit mask of OA1EN field.
	I2C_OAR1_OA1EN_Msk = 0x8000
	// Bit OA1EN.
	I2C_OAR1_OA1EN = 0x8000
	// Own address 1 disabled. The received slave address OA1 is NACKed
	I2C_OAR1_OA1EN_Disabled = 0x0
	// Own address 1 enabled. The received slave address OA1 is ACKed
	I2C_OAR1_OA1EN_Enabled = 0x1

	// OAR2: Own address register 2
	// Position of OA2 field.
	I2C_OAR2_OA2_Pos = 0x1
	// Bit mask of OA2 field.
	I2C_OAR2_OA2_Msk = 0xfe
	// Position of OA2MSK field.
	I2C_OAR2_OA2MSK_Pos = 0x8
	// Bit mask of OA2MSK field.
	I2C_OAR2_OA2MSK_Msk = 0x700
	// No mask
	I2C_OAR2_OA2MSK_NoMask = 0x0
	// OA2[1] is masked and don’t care. Only OA2[7:2] are compared
	I2C_OAR2_OA2MSK_Mask1 = 0x1
	// OA2[2:1] are masked and don’t care. Only OA2[7:3] are compared
	I2C_OAR2_OA2MSK_Mask2 = 0x2
	// OA2[3:1] are masked and don’t care. Only OA2[7:4] are compared
	I2C_OAR2_OA2MSK_Mask3 = 0x3
	// OA2[4:1] are masked and don’t care. Only OA2[7:5] are compared
	I2C_OAR2_OA2MSK_Mask4 = 0x4
	// OA2[5:1] are masked and don’t care. Only OA2[7:6] are compared
	I2C_OAR2_OA2MSK_Mask5 = 0x5
	// OA2[6:1] are masked and don’t care. Only OA2[7] is compared.
	I2C_OAR2_OA2MSK_Mask6 = 0x6
	// OA2[7:1] are masked and don’t care. No comparison is done, and all (except reserved) 7-bit received addresses are acknowledged
	I2C_OAR2_OA2MSK_Mask7 = 0x7
	// Position of OA2EN field.
	I2C_OAR2_OA2EN_Pos = 0xf
	// Bit mask of OA2EN field.
	I2C_OAR2_OA2EN_Msk = 0x8000
	// Bit OA2EN.
	I2C_OAR2_OA2EN = 0x8000
	// Own address 2 disabled. The received slave address OA2 is NACKed
	I2C_OAR2_OA2EN_Disabled = 0x0
	// Own address 2 enabled. The received slave address OA2 is ACKed
	I2C_OAR2_OA2EN_Enabled = 0x1

	// TIMINGR: Timing register
	// Position of SCLL field.
	I2C_TIMINGR_SCLL_Pos = 0x0
	// Bit mask of SCLL field.
	I2C_TIMINGR_SCLL_Msk = 0xff
	// Position of SCLH field.
	I2C_TIMINGR_SCLH_Pos = 0x8
	// Bit mask of SCLH field.
	I2C_TIMINGR_SCLH_Msk = 0xff00
	// Position of SDADEL field.
	I2C_TIMINGR_SDADEL_Pos = 0x10
	// Bit mask of SDADEL field.
	I2C_TIMINGR_SDADEL_Msk = 0xf0000
	// Position of SCLDEL field.
	I2C_TIMINGR_SCLDEL_Pos = 0x14
	// Bit mask of SCLDEL field.
	I2C_TIMINGR_SCLDEL_Msk = 0xf00000
	// Position of PRESC field.
	I2C_TIMINGR_PRESC_Pos = 0x1c
	// Bit mask of PRESC field.
	I2C_TIMINGR_PRESC_Msk = 0xf0000000

	// TIMEOUTR: Status register 1
	// Position of TIMEOUTA field.
	I2C_TIMEOUTR_TIMEOUTA_Pos = 0x0
	// Bit mask of TIMEOUTA field.
	I2C_TIMEOUTR_TIMEOUTA_Msk = 0xfff
	// Position of TIDLE field.
	I2C_TIMEOUTR_TIDLE_Pos = 0xc
	// Bit mask of TIDLE field.
	I2C_TIMEOUTR_TIDLE_Msk = 0x1000
	// Bit TIDLE.
	I2C_TIMEOUTR_TIDLE = 0x1000
	// TIMEOUTA is used to detect SCL low timeout
	I2C_TIMEOUTR_TIDLE_Disabled = 0x0
	// TIMEOUTA is used to detect both SCL and SDA high timeout (bus idle condition)
	I2C_TIMEOUTR_TIDLE_Enabled = 0x1
	// Position of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN_Pos = 0xf
	// Bit mask of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN_Msk = 0x8000
	// Bit TIMOUTEN.
	I2C_TIMEOUTR_TIMOUTEN = 0x8000
	// SCL timeout detection is disabled
	I2C_TIMEOUTR_TIMOUTEN_Disabled = 0x0
	// SCL timeout detection is enabled
	I2C_TIMEOUTR_TIMOUTEN_Enabled = 0x1
	// Position of TIMEOUTB field.
	I2C_TIMEOUTR_TIMEOUTB_Pos = 0x10
	// Bit mask of TIMEOUTB field.
	I2C_TIMEOUTR_TIMEOUTB_Msk = 0xfff0000
	// Position of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN_Pos = 0x1f
	// Bit mask of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN_Msk = 0x80000000
	// Bit TEXTEN.
	I2C_TIMEOUTR_TEXTEN = 0x80000000
	// Extended clock timeout detection is disabled
	I2C_TIMEOUTR_TEXTEN_Disabled = 0x0
	// Extended clock timeout detection is enabled
	I2C_TIMEOUTR_TEXTEN_Enabled = 0x1

	// ISR: Interrupt and Status register
	// Position of ADDCODE field.
	I2C_ISR_ADDCODE_Pos = 0x11
	// Bit mask of ADDCODE field.
	I2C_ISR_ADDCODE_Msk = 0xfe0000
	// Position of DIR field.
	I2C_ISR_DIR_Pos = 0x10
	// Bit mask of DIR field.
	I2C_ISR_DIR_Msk = 0x10000
	// Bit DIR.
	I2C_ISR_DIR = 0x10000
	// Write transfer, slave enters receiver mode
	I2C_ISR_DIR_Write = 0x0
	// Read transfer, slave enters transmitter mode
	I2C_ISR_DIR_Read = 0x1
	// Position of BUSY field.
	I2C_ISR_BUSY_Pos = 0xf
	// Bit mask of BUSY field.
	I2C_ISR_BUSY_Msk = 0x8000
	// Bit BUSY.
	I2C_ISR_BUSY = 0x8000
	// No communication is in progress on the bus
	I2C_ISR_BUSY_NotBusy = 0x0
	// A communication is in progress on the bus
	I2C_ISR_BUSY_Busy = 0x1
	// Position of ALERT field.
	I2C_ISR_ALERT_Pos = 0xd
	// Bit mask of ALERT field.
	I2C_ISR_ALERT_Msk = 0x2000
	// Bit ALERT.
	I2C_ISR_ALERT = 0x2000
	// SMBA alert is not detected
	I2C_ISR_ALERT_NoAlert = 0x0
	// SMBA alert event is detected on SMBA pin
	I2C_ISR_ALERT_Alert = 0x1
	// Position of TIMEOUT field.
	I2C_ISR_TIMEOUT_Pos = 0xc
	// Bit mask of TIMEOUT field.
	I2C_ISR_TIMEOUT_Msk = 0x1000
	// Bit TIMEOUT.
	I2C_ISR_TIMEOUT = 0x1000
	// No timeout occured
	I2C_ISR_TIMEOUT_NoTimeout = 0x0
	// Timeout occured
	I2C_ISR_TIMEOUT_Timeout = 0x1
	// Position of PECERR field.
	I2C_ISR_PECERR_Pos = 0xb
	// Bit mask of PECERR field.
	I2C_ISR_PECERR_Msk = 0x800
	// Bit PECERR.
	I2C_ISR_PECERR = 0x800
	// Received PEC does match with PEC register
	I2C_ISR_PECERR_Match = 0x0
	// Received PEC does not match with PEC register
	I2C_ISR_PECERR_NoMatch = 0x1
	// Position of OVR field.
	I2C_ISR_OVR_Pos = 0xa
	// Bit mask of OVR field.
	I2C_ISR_OVR_Msk = 0x400
	// Bit OVR.
	I2C_ISR_OVR = 0x400
	// No overrun/underrun error occurs
	I2C_ISR_OVR_NoOverrun = 0x0
	// slave mode with NOSTRETCH=1, when an overrun/underrun error occurs
	I2C_ISR_OVR_Overrun = 0x1
	// Position of ARLO field.
	I2C_ISR_ARLO_Pos = 0x9
	// Bit mask of ARLO field.
	I2C_ISR_ARLO_Msk = 0x200
	// Bit ARLO.
	I2C_ISR_ARLO = 0x200
	// No arbitration lost
	I2C_ISR_ARLO_NotLost = 0x0
	// Arbitration lost
	I2C_ISR_ARLO_Lost = 0x1
	// Position of BERR field.
	I2C_ISR_BERR_Pos = 0x8
	// Bit mask of BERR field.
	I2C_ISR_BERR_Msk = 0x100
	// Bit BERR.
	I2C_ISR_BERR = 0x100
	// No bus error
	I2C_ISR_BERR_NoError = 0x0
	// Misplaced Start and Stop condition is detected
	I2C_ISR_BERR_Error = 0x1
	// Position of TCR field.
	I2C_ISR_TCR_Pos = 0x7
	// Bit mask of TCR field.
	I2C_ISR_TCR_Msk = 0x80
	// Bit TCR.
	I2C_ISR_TCR = 0x80
	// Transfer is not complete
	I2C_ISR_TCR_NotComplete = 0x0
	// NBYTES has been transfered
	I2C_ISR_TCR_Complete = 0x1
	// Position of TC field.
	I2C_ISR_TC_Pos = 0x6
	// Bit mask of TC field.
	I2C_ISR_TC_Msk = 0x40
	// Bit TC.
	I2C_ISR_TC = 0x40
	// Transfer is not complete
	I2C_ISR_TC_NotComplete = 0x0
	// NBYTES has been transfered
	I2C_ISR_TC_Complete = 0x1
	// Position of STOPF field.
	I2C_ISR_STOPF_Pos = 0x5
	// Bit mask of STOPF field.
	I2C_ISR_STOPF_Msk = 0x20
	// Bit STOPF.
	I2C_ISR_STOPF = 0x20
	// No Stop condition detected
	I2C_ISR_STOPF_NoStop = 0x0
	// Stop condition detected
	I2C_ISR_STOPF_Stop = 0x1
	// Position of NACKF field.
	I2C_ISR_NACKF_Pos = 0x4
	// Bit mask of NACKF field.
	I2C_ISR_NACKF_Msk = 0x10
	// Bit NACKF.
	I2C_ISR_NACKF = 0x10
	// No NACK has been received
	I2C_ISR_NACKF_NoNack = 0x0
	// NACK has been received
	I2C_ISR_NACKF_Nack = 0x1
	// Position of ADDR field.
	I2C_ISR_ADDR_Pos = 0x3
	// Bit mask of ADDR field.
	I2C_ISR_ADDR_Msk = 0x8
	// Bit ADDR.
	I2C_ISR_ADDR = 0x8
	// Adress mismatched or not received
	I2C_ISR_ADDR_NotMatch = 0x0
	// Received slave address matched with one of the enabled slave addresses
	I2C_ISR_ADDR_Match = 0x1
	// Position of RXNE field.
	I2C_ISR_RXNE_Pos = 0x2
	// Bit mask of RXNE field.
	I2C_ISR_RXNE_Msk = 0x4
	// Bit RXNE.
	I2C_ISR_RXNE = 0x4
	// The RXDR register is empty
	I2C_ISR_RXNE_Empty = 0x0
	// Received data is copied into the RXDR register, and is ready to be read
	I2C_ISR_RXNE_NotEmpty = 0x1
	// Position of TXIS field.
	I2C_ISR_TXIS_Pos = 0x1
	// Bit mask of TXIS field.
	I2C_ISR_TXIS_Msk = 0x2
	// Bit TXIS.
	I2C_ISR_TXIS = 0x2
	// The TXDR register is not empty
	I2C_ISR_TXIS_NotEmpty = 0x0
	// The TXDR register is empty and the data to be transmitted must be written in the TXDR register
	I2C_ISR_TXIS_Empty = 0x1
	// Position of TXE field.
	I2C_ISR_TXE_Pos = 0x0
	// Bit mask of TXE field.
	I2C_ISR_TXE_Msk = 0x1
	// Bit TXE.
	I2C_ISR_TXE = 0x1
	// TXDR register not empty
	I2C_ISR_TXE_NotEmpty = 0x0
	// TXDR register empty
	I2C_ISR_TXE_Empty = 0x1

	// ICR: Interrupt clear register
	// Position of ALERTCF field.
	I2C_ICR_ALERTCF_Pos = 0xd
	// Bit mask of ALERTCF field.
	I2C_ICR_ALERTCF_Msk = 0x2000
	// Bit ALERTCF.
	I2C_ICR_ALERTCF = 0x2000
	// Clears the ALERT flag in ISR register
	I2C_ICR_ALERTCF_Clear = 0x1
	// Position of TIMOUTCF field.
	I2C_ICR_TIMOUTCF_Pos = 0xc
	// Bit mask of TIMOUTCF field.
	I2C_ICR_TIMOUTCF_Msk = 0x1000
	// Bit TIMOUTCF.
	I2C_ICR_TIMOUTCF = 0x1000
	// Clears the TIMOUT flag in ISR register
	I2C_ICR_TIMOUTCF_Clear = 0x1
	// Position of PECCF field.
	I2C_ICR_PECCF_Pos = 0xb
	// Bit mask of PECCF field.
	I2C_ICR_PECCF_Msk = 0x800
	// Bit PECCF.
	I2C_ICR_PECCF = 0x800
	// Clears the PEC flag in ISR register
	I2C_ICR_PECCF_Clear = 0x1
	// Position of OVRCF field.
	I2C_ICR_OVRCF_Pos = 0xa
	// Bit mask of OVRCF field.
	I2C_ICR_OVRCF_Msk = 0x400
	// Bit OVRCF.
	I2C_ICR_OVRCF = 0x400
	// Clears the OVR flag in ISR register
	I2C_ICR_OVRCF_Clear = 0x1
	// Position of ARLOCF field.
	I2C_ICR_ARLOCF_Pos = 0x9
	// Bit mask of ARLOCF field.
	I2C_ICR_ARLOCF_Msk = 0x200
	// Bit ARLOCF.
	I2C_ICR_ARLOCF = 0x200
	// Clears the ARLO flag in ISR register
	I2C_ICR_ARLOCF_Clear = 0x1
	// Position of BERRCF field.
	I2C_ICR_BERRCF_Pos = 0x8
	// Bit mask of BERRCF field.
	I2C_ICR_BERRCF_Msk = 0x100
	// Bit BERRCF.
	I2C_ICR_BERRCF = 0x100
	// Clears the BERR flag in ISR register
	I2C_ICR_BERRCF_Clear = 0x1
	// Position of STOPCF field.
	I2C_ICR_STOPCF_Pos = 0x5
	// Bit mask of STOPCF field.
	I2C_ICR_STOPCF_Msk = 0x20
	// Bit STOPCF.
	I2C_ICR_STOPCF = 0x20
	// Clears the STOP flag in ISR register
	I2C_ICR_STOPCF_Clear = 0x1
	// Position of NACKCF field.
	I2C_ICR_NACKCF_Pos = 0x4
	// Bit mask of NACKCF field.
	I2C_ICR_NACKCF_Msk = 0x10
	// Bit NACKCF.
	I2C_ICR_NACKCF = 0x10
	// Clears the NACK flag in ISR register
	I2C_ICR_NACKCF_Clear = 0x1
	// Position of ADDRCF field.
	I2C_ICR_ADDRCF_Pos = 0x3
	// Bit mask of ADDRCF field.
	I2C_ICR_ADDRCF_Msk = 0x8
	// Bit ADDRCF.
	I2C_ICR_ADDRCF = 0x8
	// Clears the ADDR flag in ISR register
	I2C_ICR_ADDRCF_Clear = 0x1

	// PECR: PEC register
	// Position of PEC field.
	I2C_PECR_PEC_Pos = 0x0
	// Bit mask of PEC field.
	I2C_PECR_PEC_Msk = 0xff

	// RXDR: Receive data register
	// Position of RXDATA field.
	I2C_RXDR_RXDATA_Pos = 0x0
	// Bit mask of RXDATA field.
	I2C_RXDR_RXDATA_Msk = 0xff

	// TXDR: Transmit data register
	// Position of TXDATA field.
	I2C_TXDR_TXDATA_Pos = 0x0
	// Bit mask of TXDATA field.
	I2C_TXDR_TXDATA_Msk = 0xff
)

// Constants for FLASH: Flash
const (
	// ACR: Access control register
	// Position of LATENCY field.
	Flash_ACR_LATENCY_Pos = 0x0
	// Bit mask of LATENCY field.
	Flash_ACR_LATENCY_Msk = 0xf
	// Position of PRFTEN field.
	Flash_ACR_PRFTEN_Pos = 0x8
	// Bit mask of PRFTEN field.
	Flash_ACR_PRFTEN_Msk = 0x100
	// Bit PRFTEN.
	Flash_ACR_PRFTEN = 0x100
	// Position of ICEN field.
	Flash_ACR_ICEN_Pos = 0x9
	// Bit mask of ICEN field.
	Flash_ACR_ICEN_Msk = 0x200
	// Bit ICEN.
	Flash_ACR_ICEN = 0x200
	// Position of DCEN field.
	Flash_ACR_DCEN_Pos = 0xa
	// Bit mask of DCEN field.
	Flash_ACR_DCEN_Msk = 0x400
	// Bit DCEN.
	Flash_ACR_DCEN = 0x400
	// Position of ICRST field.
	Flash_ACR_ICRST_Pos = 0xb
	// Bit mask of ICRST field.
	Flash_ACR_ICRST_Msk = 0x800
	// Bit ICRST.
	Flash_ACR_ICRST = 0x800
	// Position of DCRST field.
	Flash_ACR_DCRST_Pos = 0xc
	// Bit mask of DCRST field.
	Flash_ACR_DCRST_Msk = 0x1000
	// Bit DCRST.
	Flash_ACR_DCRST = 0x1000
	// Position of RUN_PD field.
	Flash_ACR_RUN_PD_Pos = 0xd
	// Bit mask of RUN_PD field.
	Flash_ACR_RUN_PD_Msk = 0x2000
	// Bit RUN_PD.
	Flash_ACR_RUN_PD = 0x2000
	// Position of SLEEP_PD field.
	Flash_ACR_SLEEP_PD_Pos = 0xe
	// Bit mask of SLEEP_PD field.
	Flash_ACR_SLEEP_PD_Msk = 0x4000
	// Bit SLEEP_PD.
	Flash_ACR_SLEEP_PD = 0x4000
	// Position of DBG_SWEN field.
	Flash_ACR_DBG_SWEN_Pos = 0x12
	// Bit mask of DBG_SWEN field.
	Flash_ACR_DBG_SWEN_Msk = 0x40000
	// Bit DBG_SWEN.
	Flash_ACR_DBG_SWEN = 0x40000

	// PDKEYR: Power down key register
	// Position of PDKEYR field.
	Flash_PDKEYR_PDKEYR_Pos = 0x0
	// Bit mask of PDKEYR field.
	Flash_PDKEYR_PDKEYR_Msk = 0xffffffff

	// KEYR: Flash key register
	// Position of KEYR field.
	Flash_KEYR_KEYR_Pos = 0x0
	// Bit mask of KEYR field.
	Flash_KEYR_KEYR_Msk = 0xffffffff

	// OPTKEYR: Option byte key register
	// Position of OPTKEYR field.
	Flash_OPTKEYR_OPTKEYR_Pos = 0x0
	// Bit mask of OPTKEYR field.
	Flash_OPTKEYR_OPTKEYR_Msk = 0xffffffff

	// SR: Status register
	// Position of EOP field.
	Flash_SR_EOP_Pos = 0x0
	// Bit mask of EOP field.
	Flash_SR_EOP_Msk = 0x1
	// Bit EOP.
	Flash_SR_EOP = 0x1
	// Position of OPERR field.
	Flash_SR_OPERR_Pos = 0x1
	// Bit mask of OPERR field.
	Flash_SR_OPERR_Msk = 0x2
	// Bit OPERR.
	Flash_SR_OPERR = 0x2
	// Position of PROGERR field.
	Flash_SR_PROGERR_Pos = 0x3
	// Bit mask of PROGERR field.
	Flash_SR_PROGERR_Msk = 0x8
	// Bit PROGERR.
	Flash_SR_PROGERR = 0x8
	// Position of WRPERR field.
	Flash_SR_WRPERR_Pos = 0x4
	// Bit mask of WRPERR field.
	Flash_SR_WRPERR_Msk = 0x10
	// Bit WRPERR.
	Flash_SR_WRPERR = 0x10
	// Position of PGAERR field.
	Flash_SR_PGAERR_Pos = 0x5
	// Bit mask of PGAERR field.
	Flash_SR_PGAERR_Msk = 0x20
	// Bit PGAERR.
	Flash_SR_PGAERR = 0x20
	// Position of SIZERR field.
	Flash_SR_SIZERR_Pos = 0x6
	// Bit mask of SIZERR field.
	Flash_SR_SIZERR_Msk = 0x40
	// Bit SIZERR.
	Flash_SR_SIZERR = 0x40
	// Position of PGSERR field.
	Flash_SR_PGSERR_Pos = 0x7
	// Bit mask of PGSERR field.
	Flash_SR_PGSERR_Msk = 0x80
	// Bit PGSERR.
	Flash_SR_PGSERR = 0x80
	// Position of MISERR field.
	Flash_SR_MISERR_Pos = 0x8
	// Bit mask of MISERR field.
	Flash_SR_MISERR_Msk = 0x100
	// Bit MISERR.
	Flash_SR_MISERR = 0x100
	// Position of FASTERR field.
	Flash_SR_FASTERR_Pos = 0x9
	// Bit mask of FASTERR field.
	Flash_SR_FASTERR_Msk = 0x200
	// Bit FASTERR.
	Flash_SR_FASTERR = 0x200
	// Position of RDERR field.
	Flash_SR_RDERR_Pos = 0xe
	// Bit mask of RDERR field.
	Flash_SR_RDERR_Msk = 0x4000
	// Bit RDERR.
	Flash_SR_RDERR = 0x4000
	// Position of OPTVERR field.
	Flash_SR_OPTVERR_Pos = 0xf
	// Bit mask of OPTVERR field.
	Flash_SR_OPTVERR_Msk = 0x8000
	// Bit OPTVERR.
	Flash_SR_OPTVERR = 0x8000
	// Position of BSY field.
	Flash_SR_BSY_Pos = 0x10
	// Bit mask of BSY field.
	Flash_SR_BSY_Msk = 0x10000
	// Bit BSY.
	Flash_SR_BSY = 0x10000

	// CR: Flash control register
	// Position of PG field.
	Flash_CR_PG_Pos = 0x0
	// Bit mask of PG field.
	Flash_CR_PG_Msk = 0x1
	// Bit PG.
	Flash_CR_PG = 0x1
	// Position of PER field.
	Flash_CR_PER_Pos = 0x1
	// Bit mask of PER field.
	Flash_CR_PER_Msk = 0x2
	// Bit PER.
	Flash_CR_PER = 0x2
	// Position of MER1 field.
	Flash_CR_MER1_Pos = 0x2
	// Bit mask of MER1 field.
	Flash_CR_MER1_Msk = 0x4
	// Bit MER1.
	Flash_CR_MER1 = 0x4
	// Position of PNB field.
	Flash_CR_PNB_Pos = 0x3
	// Bit mask of PNB field.
	Flash_CR_PNB_Msk = 0x3f8
	// Position of STRT field.
	Flash_CR_STRT_Pos = 0x10
	// Bit mask of STRT field.
	Flash_CR_STRT_Msk = 0x10000
	// Bit STRT.
	Flash_CR_STRT = 0x10000
	// Position of OPTSTRT field.
	Flash_CR_OPTSTRT_Pos = 0x11
	// Bit mask of OPTSTRT field.
	Flash_CR_OPTSTRT_Msk = 0x20000
	// Bit OPTSTRT.
	Flash_CR_OPTSTRT = 0x20000
	// Position of FSTPG field.
	Flash_CR_FSTPG_Pos = 0x12
	// Bit mask of FSTPG field.
	Flash_CR_FSTPG_Msk = 0x40000
	// Bit FSTPG.
	Flash_CR_FSTPG = 0x40000
	// Position of EOPIE field.
	Flash_CR_EOPIE_Pos = 0x18
	// Bit mask of EOPIE field.
	Flash_CR_EOPIE_Msk = 0x1000000
	// Bit EOPIE.
	Flash_CR_EOPIE = 0x1000000
	// Position of ERRIE field.
	Flash_CR_ERRIE_Pos = 0x19
	// Bit mask of ERRIE field.
	Flash_CR_ERRIE_Msk = 0x2000000
	// Bit ERRIE.
	Flash_CR_ERRIE = 0x2000000
	// Position of RDERRIE field.
	Flash_CR_RDERRIE_Pos = 0x1a
	// Bit mask of RDERRIE field.
	Flash_CR_RDERRIE_Msk = 0x4000000
	// Bit RDERRIE.
	Flash_CR_RDERRIE = 0x4000000
	// Position of OBL_LAUNCH field.
	Flash_CR_OBL_LAUNCH_Pos = 0x1b
	// Bit mask of OBL_LAUNCH field.
	Flash_CR_OBL_LAUNCH_Msk = 0x8000000
	// Bit OBL_LAUNCH.
	Flash_CR_OBL_LAUNCH = 0x8000000
	// Position of SEC_PROT1 field.
	Flash_CR_SEC_PROT1_Pos = 0x1c
	// Bit mask of SEC_PROT1 field.
	Flash_CR_SEC_PROT1_Msk = 0x10000000
	// Bit SEC_PROT1.
	Flash_CR_SEC_PROT1 = 0x10000000
	// Position of OPTLOCK field.
	Flash_CR_OPTLOCK_Pos = 0x1e
	// Bit mask of OPTLOCK field.
	Flash_CR_OPTLOCK_Msk = 0x40000000
	// Bit OPTLOCK.
	Flash_CR_OPTLOCK = 0x40000000
	// Position of LOCK field.
	Flash_CR_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Flash_CR_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Flash_CR_LOCK = 0x80000000

	// ECCR: Flash ECC register
	// Position of ADDR_ECC field.
	Flash_ECCR_ADDR_ECC_Pos = 0x0
	// Bit mask of ADDR_ECC field.
	Flash_ECCR_ADDR_ECC_Msk = 0x7ffff
	// Position of BK_ECC field.
	Flash_ECCR_BK_ECC_Pos = 0x15
	// Bit mask of BK_ECC field.
	Flash_ECCR_BK_ECC_Msk = 0x200000
	// Bit BK_ECC.
	Flash_ECCR_BK_ECC = 0x200000
	// Position of SYSF_ECC field.
	Flash_ECCR_SYSF_ECC_Pos = 0x16
	// Bit mask of SYSF_ECC field.
	Flash_ECCR_SYSF_ECC_Msk = 0x400000
	// Bit SYSF_ECC.
	Flash_ECCR_SYSF_ECC = 0x400000
	// Position of ECCIE field.
	Flash_ECCR_ECCIE_Pos = 0x18
	// Bit mask of ECCIE field.
	Flash_ECCR_ECCIE_Msk = 0x1000000
	// Bit ECCIE.
	Flash_ECCR_ECCIE = 0x1000000
	// Position of ECCC2 field.
	Flash_ECCR_ECCC2_Pos = 0x1c
	// Bit mask of ECCC2 field.
	Flash_ECCR_ECCC2_Msk = 0x10000000
	// Bit ECCC2.
	Flash_ECCR_ECCC2 = 0x10000000
	// Position of ECCD2 field.
	Flash_ECCR_ECCD2_Pos = 0x1d
	// Bit mask of ECCD2 field.
	Flash_ECCR_ECCD2_Msk = 0x20000000
	// Bit ECCD2.
	Flash_ECCR_ECCD2 = 0x20000000
	// Position of ECCC field.
	Flash_ECCR_ECCC_Pos = 0x1e
	// Bit mask of ECCC field.
	Flash_ECCR_ECCC_Msk = 0x40000000
	// Bit ECCC.
	Flash_ECCR_ECCC = 0x40000000
	// Position of ECCD field.
	Flash_ECCR_ECCD_Pos = 0x1f
	// Bit mask of ECCD field.
	Flash_ECCR_ECCD_Msk = 0x80000000
	// Bit ECCD.
	Flash_ECCR_ECCD = 0x80000000

	// OPTR: Flash option register
	// Position of RDP field.
	Flash_OPTR_RDP_Pos = 0x0
	// Bit mask of RDP field.
	Flash_OPTR_RDP_Msk = 0xff
	// Position of BOR_LEV field.
	Flash_OPTR_BOR_LEV_Pos = 0x8
	// Bit mask of BOR_LEV field.
	Flash_OPTR_BOR_LEV_Msk = 0x700
	// Position of NRST_STOP field.
	Flash_OPTR_NRST_STOP_Pos = 0xc
	// Bit mask of NRST_STOP field.
	Flash_OPTR_NRST_STOP_Msk = 0x1000
	// Bit NRST_STOP.
	Flash_OPTR_NRST_STOP = 0x1000
	// Position of NRST_STDBY field.
	Flash_OPTR_NRST_STDBY_Pos = 0xd
	// Bit mask of NRST_STDBY field.
	Flash_OPTR_NRST_STDBY_Msk = 0x2000
	// Bit NRST_STDBY.
	Flash_OPTR_NRST_STDBY = 0x2000
	// Position of NRST_SHDW field.
	Flash_OPTR_NRST_SHDW_Pos = 0xe
	// Bit mask of NRST_SHDW field.
	Flash_OPTR_NRST_SHDW_Msk = 0x4000
	// Bit NRST_SHDW.
	Flash_OPTR_NRST_SHDW = 0x4000
	// Position of IDWG_SW field.
	Flash_OPTR_IDWG_SW_Pos = 0x10
	// Bit mask of IDWG_SW field.
	Flash_OPTR_IDWG_SW_Msk = 0x10000
	// Bit IDWG_SW.
	Flash_OPTR_IDWG_SW = 0x10000
	// Position of IWDG_STOP field.
	Flash_OPTR_IWDG_STOP_Pos = 0x11
	// Bit mask of IWDG_STOP field.
	Flash_OPTR_IWDG_STOP_Msk = 0x20000
	// Bit IWDG_STOP.
	Flash_OPTR_IWDG_STOP = 0x20000
	// Position of IWDG_STDBY field.
	Flash_OPTR_IWDG_STDBY_Pos = 0x12
	// Bit mask of IWDG_STDBY field.
	Flash_OPTR_IWDG_STDBY_Msk = 0x40000
	// Bit IWDG_STDBY.
	Flash_OPTR_IWDG_STDBY = 0x40000
	// Position of WWDG_SW field.
	Flash_OPTR_WWDG_SW_Pos = 0x13
	// Bit mask of WWDG_SW field.
	Flash_OPTR_WWDG_SW_Msk = 0x80000
	// Bit WWDG_SW.
	Flash_OPTR_WWDG_SW = 0x80000
	// Position of NBOOT1 field.
	Flash_OPTR_NBOOT1_Pos = 0x17
	// Bit mask of NBOOT1 field.
	Flash_OPTR_NBOOT1_Msk = 0x800000
	// Bit NBOOT1.
	Flash_OPTR_NBOOT1 = 0x800000
	// Position of SRAM2_PE field.
	Flash_OPTR_SRAM2_PE_Pos = 0x18
	// Bit mask of SRAM2_PE field.
	Flash_OPTR_SRAM2_PE_Msk = 0x1000000
	// Bit SRAM2_PE.
	Flash_OPTR_SRAM2_PE = 0x1000000
	// Position of SRAM2_RST field.
	Flash_OPTR_SRAM2_RST_Pos = 0x19
	// Bit mask of SRAM2_RST field.
	Flash_OPTR_SRAM2_RST_Msk = 0x2000000
	// Bit SRAM2_RST.
	Flash_OPTR_SRAM2_RST = 0x2000000
	// Position of NSWBOOT0 field.
	Flash_OPTR_NSWBOOT0_Pos = 0x1a
	// Bit mask of NSWBOOT0 field.
	Flash_OPTR_NSWBOOT0_Msk = 0x4000000
	// Bit NSWBOOT0.
	Flash_OPTR_NSWBOOT0 = 0x4000000
	// Position of NBOOT0 field.
	Flash_OPTR_NBOOT0_Pos = 0x1b
	// Bit mask of NBOOT0 field.
	Flash_OPTR_NBOOT0_Msk = 0x8000000
	// Bit NBOOT0.
	Flash_OPTR_NBOOT0 = 0x8000000
	// Position of NRST_MODE field.
	Flash_OPTR_NRST_MODE_Pos = 0x1c
	// Bit mask of NRST_MODE field.
	Flash_OPTR_NRST_MODE_Msk = 0x30000000
	// Position of IRHEN field.
	Flash_OPTR_IRHEN_Pos = 0x1e
	// Bit mask of IRHEN field.
	Flash_OPTR_IRHEN_Msk = 0x40000000
	// Bit IRHEN.
	Flash_OPTR_IRHEN = 0x40000000

	// PCROP1SR: Flash Bank 1 PCROP Start address register
	// Position of PCROP1_STRT field.
	Flash_PCROP1SR_PCROP1_STRT_Pos = 0x0
	// Bit mask of PCROP1_STRT field.
	Flash_PCROP1SR_PCROP1_STRT_Msk = 0x7fff

	// PCROP1ER: Flash Bank 1 PCROP End address register
	// Position of PCROP1_END field.
	Flash_PCROP1ER_PCROP1_END_Pos = 0x0
	// Bit mask of PCROP1_END field.
	Flash_PCROP1ER_PCROP1_END_Msk = 0x7fff
	// Position of PCROP_RDP field.
	Flash_PCROP1ER_PCROP_RDP_Pos = 0x1f
	// Bit mask of PCROP_RDP field.
	Flash_PCROP1ER_PCROP_RDP_Msk = 0x80000000
	// Bit PCROP_RDP.
	Flash_PCROP1ER_PCROP_RDP = 0x80000000

	// WRP1AR: Flash Bank 1 WRP area A address register
	// Position of WRP1A_STRT field.
	Flash_WRP1AR_WRP1A_STRT_Pos = 0x0
	// Bit mask of WRP1A_STRT field.
	Flash_WRP1AR_WRP1A_STRT_Msk = 0x7f
	// Position of WRP1A_END field.
	Flash_WRP1AR_WRP1A_END_Pos = 0x10
	// Bit mask of WRP1A_END field.
	Flash_WRP1AR_WRP1A_END_Msk = 0x7f0000

	// WRP1BR: Flash Bank 1 WRP area B address register
	// Position of WRP1B_STRT field.
	Flash_WRP1BR_WRP1B_STRT_Pos = 0x0
	// Bit mask of WRP1B_STRT field.
	Flash_WRP1BR_WRP1B_STRT_Msk = 0x7f
	// Position of WRP1B_END field.
	Flash_WRP1BR_WRP1B_END_Pos = 0x10
	// Bit mask of WRP1B_END field.
	Flash_WRP1BR_WRP1B_END_Msk = 0x7f0000

	// SEC1R: securable area bank1 register
	// Position of BOOT_LOCK field.
	Flash_SEC1R_BOOT_LOCK_Pos = 0x10
	// Bit mask of BOOT_LOCK field.
	Flash_SEC1R_BOOT_LOCK_Msk = 0x10000
	// Bit BOOT_LOCK.
	Flash_SEC1R_BOOT_LOCK = 0x10000
	// Position of SEC_SIZE1 field.
	Flash_SEC1R_SEC_SIZE1_Pos = 0x0
	// Bit mask of SEC_SIZE1 field.
	Flash_SEC1R_SEC_SIZE1_Msk = 0xff
)

// Constants for DBGMCU: Debug support
const (
	// IDCODE: MCU Device ID Code Register
	// Position of DEV_ID field.
	DBGMCU_IDCODE_DEV_ID_Pos = 0x0
	// Bit mask of DEV_ID field.
	DBGMCU_IDCODE_DEV_ID_Msk = 0xffff
	// Position of REV_ID field.
	DBGMCU_IDCODE_REV_ID_Pos = 0x10
	// Bit mask of REV_ID field.
	DBGMCU_IDCODE_REV_ID_Msk = 0xffff0000

	// CR: Debug MCU Configuration Register
	// Position of DBG_SLEEP field.
	DBGMCU_CR_DBG_SLEEP_Pos = 0x0
	// Bit mask of DBG_SLEEP field.
	DBGMCU_CR_DBG_SLEEP_Msk = 0x1
	// Bit DBG_SLEEP.
	DBGMCU_CR_DBG_SLEEP = 0x1
	// Position of DBG_STOP field.
	DBGMCU_CR_DBG_STOP_Pos = 0x1
	// Bit mask of DBG_STOP field.
	DBGMCU_CR_DBG_STOP_Msk = 0x2
	// Bit DBG_STOP.
	DBGMCU_CR_DBG_STOP = 0x2
	// Position of DBG_STANDBY field.
	DBGMCU_CR_DBG_STANDBY_Pos = 0x2
	// Bit mask of DBG_STANDBY field.
	DBGMCU_CR_DBG_STANDBY_Msk = 0x4
	// Bit DBG_STANDBY.
	DBGMCU_CR_DBG_STANDBY = 0x4
	// Position of TRACE_IOEN field.
	DBGMCU_CR_TRACE_IOEN_Pos = 0x5
	// Bit mask of TRACE_IOEN field.
	DBGMCU_CR_TRACE_IOEN_Msk = 0x20
	// Bit TRACE_IOEN.
	DBGMCU_CR_TRACE_IOEN = 0x20
	// Position of TRACE_MODE field.
	DBGMCU_CR_TRACE_MODE_Pos = 0x6
	// Bit mask of TRACE_MODE field.
	DBGMCU_CR_TRACE_MODE_Msk = 0xc0

	// APB1L_FZ: APB Low Freeze Register 1
	// Position of DBG_TIMER2_STOP field.
	DBGMCU_APB1L_FZ_DBG_TIMER2_STOP_Pos = 0x0
	// Bit mask of DBG_TIMER2_STOP field.
	DBGMCU_APB1L_FZ_DBG_TIMER2_STOP_Msk = 0x1
	// Bit DBG_TIMER2_STOP.
	DBGMCU_APB1L_FZ_DBG_TIMER2_STOP = 0x1
	// Position of DBG_TIM3_STOP field.
	DBGMCU_APB1L_FZ_DBG_TIM3_STOP_Pos = 0x1
	// Bit mask of DBG_TIM3_STOP field.
	DBGMCU_APB1L_FZ_DBG_TIM3_STOP_Msk = 0x2
	// Bit DBG_TIM3_STOP.
	DBGMCU_APB1L_FZ_DBG_TIM3_STOP = 0x2
	// Position of DBG_TIM4_STOP field.
	DBGMCU_APB1L_FZ_DBG_TIM4_STOP_Pos = 0x2
	// Bit mask of DBG_TIM4_STOP field.
	DBGMCU_APB1L_FZ_DBG_TIM4_STOP_Msk = 0x4
	// Bit DBG_TIM4_STOP.
	DBGMCU_APB1L_FZ_DBG_TIM4_STOP = 0x4
	// Position of DBG_TIM5_STOP field.
	DBGMCU_APB1L_FZ_DBG_TIM5_STOP_Pos = 0x3
	// Bit mask of DBG_TIM5_STOP field.
	DBGMCU_APB1L_FZ_DBG_TIM5_STOP_Msk = 0x8
	// Bit DBG_TIM5_STOP.
	DBGMCU_APB1L_FZ_DBG_TIM5_STOP = 0x8
	// Position of DBG_TIMER6_STOP field.
	DBGMCU_APB1L_FZ_DBG_TIMER6_STOP_Pos = 0x4
	// Bit mask of DBG_TIMER6_STOP field.
	DBGMCU_APB1L_FZ_DBG_TIMER6_STOP_Msk = 0x10
	// Bit DBG_TIMER6_STOP.
	DBGMCU_APB1L_FZ_DBG_TIMER6_STOP = 0x10
	// Position of DBG_TIM7_STOP field.
	DBGMCU_APB1L_FZ_DBG_TIM7_STOP_Pos = 0x5
	// Bit mask of DBG_TIM7_STOP field.
	DBGMCU_APB1L_FZ_DBG_TIM7_STOP_Msk = 0x20
	// Bit DBG_TIM7_STOP.
	DBGMCU_APB1L_FZ_DBG_TIM7_STOP = 0x20
	// Position of DBG_RTC_STOP field.
	DBGMCU_APB1L_FZ_DBG_RTC_STOP_Pos = 0xa
	// Bit mask of DBG_RTC_STOP field.
	DBGMCU_APB1L_FZ_DBG_RTC_STOP_Msk = 0x400
	// Bit DBG_RTC_STOP.
	DBGMCU_APB1L_FZ_DBG_RTC_STOP = 0x400
	// Position of DBG_WWDG_STOP field.
	DBGMCU_APB1L_FZ_DBG_WWDG_STOP_Pos = 0xb
	// Bit mask of DBG_WWDG_STOP field.
	DBGMCU_APB1L_FZ_DBG_WWDG_STOP_Msk = 0x800
	// Bit DBG_WWDG_STOP.
	DBGMCU_APB1L_FZ_DBG_WWDG_STOP = 0x800
	// Position of DBG_IWDG_STOP field.
	DBGMCU_APB1L_FZ_DBG_IWDG_STOP_Pos = 0xc
	// Bit mask of DBG_IWDG_STOP field.
	DBGMCU_APB1L_FZ_DBG_IWDG_STOP_Msk = 0x1000
	// Bit DBG_IWDG_STOP.
	DBGMCU_APB1L_FZ_DBG_IWDG_STOP = 0x1000
	// Position of DBG_I2C1_STOP field.
	DBGMCU_APB1L_FZ_DBG_I2C1_STOP_Pos = 0x15
	// Bit mask of DBG_I2C1_STOP field.
	DBGMCU_APB1L_FZ_DBG_I2C1_STOP_Msk = 0x200000
	// Bit DBG_I2C1_STOP.
	DBGMCU_APB1L_FZ_DBG_I2C1_STOP = 0x200000
	// Position of DBG_I2C2_STOP field.
	DBGMCU_APB1L_FZ_DBG_I2C2_STOP_Pos = 0x16
	// Bit mask of DBG_I2C2_STOP field.
	DBGMCU_APB1L_FZ_DBG_I2C2_STOP_Msk = 0x400000
	// Bit DBG_I2C2_STOP.
	DBGMCU_APB1L_FZ_DBG_I2C2_STOP = 0x400000
	// Position of DBG_I2C3_STOP field.
	DBGMCU_APB1L_FZ_DBG_I2C3_STOP_Pos = 0x1e
	// Bit mask of DBG_I2C3_STOP field.
	DBGMCU_APB1L_FZ_DBG_I2C3_STOP_Msk = 0x40000000
	// Bit DBG_I2C3_STOP.
	DBGMCU_APB1L_FZ_DBG_I2C3_STOP = 0x40000000
	// Position of DBG_LPTIMER_STOP field.
	DBGMCU_APB1L_FZ_DBG_LPTIMER_STOP_Pos = 0x1f
	// Bit mask of DBG_LPTIMER_STOP field.
	DBGMCU_APB1L_FZ_DBG_LPTIMER_STOP_Msk = 0x80000000
	// Bit DBG_LPTIMER_STOP.
	DBGMCU_APB1L_FZ_DBG_LPTIMER_STOP = 0x80000000

	// APB1H_FZ: APB Low Freeze Register 2
	// Position of DBG_I2C4_STOP field.
	DBGMCU_APB1H_FZ_DBG_I2C4_STOP_Pos = 0x1
	// Bit mask of DBG_I2C4_STOP field.
	DBGMCU_APB1H_FZ_DBG_I2C4_STOP_Msk = 0x2
	// Bit DBG_I2C4_STOP.
	DBGMCU_APB1H_FZ_DBG_I2C4_STOP = 0x2

	// APB2_FZ: APB High Freeze Register
	// Position of DBG_TIM1_STOP field.
	DBGMCU_APB2_FZ_DBG_TIM1_STOP_Pos = 0xb
	// Bit mask of DBG_TIM1_STOP field.
	DBGMCU_APB2_FZ_DBG_TIM1_STOP_Msk = 0x800
	// Bit DBG_TIM1_STOP.
	DBGMCU_APB2_FZ_DBG_TIM1_STOP = 0x800
	// Position of DBG_TIM8_STOP field.
	DBGMCU_APB2_FZ_DBG_TIM8_STOP_Pos = 0xd
	// Bit mask of DBG_TIM8_STOP field.
	DBGMCU_APB2_FZ_DBG_TIM8_STOP_Msk = 0x2000
	// Bit DBG_TIM8_STOP.
	DBGMCU_APB2_FZ_DBG_TIM8_STOP = 0x2000
	// Position of DBG_TIM15_STOP field.
	DBGMCU_APB2_FZ_DBG_TIM15_STOP_Pos = 0x10
	// Bit mask of DBG_TIM15_STOP field.
	DBGMCU_APB2_FZ_DBG_TIM15_STOP_Msk = 0x10000
	// Bit DBG_TIM15_STOP.
	DBGMCU_APB2_FZ_DBG_TIM15_STOP = 0x10000
	// Position of DBG_TIM16_STOP field.
	DBGMCU_APB2_FZ_DBG_TIM16_STOP_Pos = 0x11
	// Bit mask of DBG_TIM16_STOP field.
	DBGMCU_APB2_FZ_DBG_TIM16_STOP_Msk = 0x20000
	// Bit DBG_TIM16_STOP.
	DBGMCU_APB2_FZ_DBG_TIM16_STOP = 0x20000
	// Position of DBG_TIM17_STOP field.
	DBGMCU_APB2_FZ_DBG_TIM17_STOP_Pos = 0x12
	// Bit mask of DBG_TIM17_STOP field.
	DBGMCU_APB2_FZ_DBG_TIM17_STOP_Msk = 0x40000
	// Bit DBG_TIM17_STOP.
	DBGMCU_APB2_FZ_DBG_TIM17_STOP = 0x40000
	// Position of DBG_TIM20_STOP field.
	DBGMCU_APB2_FZ_DBG_TIM20_STOP_Pos = 0x14
	// Bit mask of DBG_TIM20_STOP field.
	DBGMCU_APB2_FZ_DBG_TIM20_STOP_Msk = 0x100000
	// Bit DBG_TIM20_STOP.
	DBGMCU_APB2_FZ_DBG_TIM20_STOP = 0x100000
	// Position of DBG_HRTIM0_STOP field.
	DBGMCU_APB2_FZ_DBG_HRTIM0_STOP_Pos = 0x1a
	// Bit mask of DBG_HRTIM0_STOP field.
	DBGMCU_APB2_FZ_DBG_HRTIM0_STOP_Msk = 0x4000000
	// Bit DBG_HRTIM0_STOP.
	DBGMCU_APB2_FZ_DBG_HRTIM0_STOP = 0x4000000
	// Position of DBG_HRTIM1_STOP field.
	DBGMCU_APB2_FZ_DBG_HRTIM1_STOP_Pos = 0x1b
	// Bit mask of DBG_HRTIM1_STOP field.
	DBGMCU_APB2_FZ_DBG_HRTIM1_STOP_Msk = 0x8000000
	// Bit DBG_HRTIM1_STOP.
	DBGMCU_APB2_FZ_DBG_HRTIM1_STOP = 0x8000000
	// Position of DBG_HRTIM2_STOP field.
	DBGMCU_APB2_FZ_DBG_HRTIM2_STOP_Pos = 0x1c
	// Bit mask of DBG_HRTIM2_STOP field.
	DBGMCU_APB2_FZ_DBG_HRTIM2_STOP_Msk = 0x10000000
	// Bit DBG_HRTIM2_STOP.
	DBGMCU_APB2_FZ_DBG_HRTIM2_STOP = 0x10000000
	// Position of DBG_HRTIM3_STOP field.
	DBGMCU_APB2_FZ_DBG_HRTIM3_STOP_Pos = 0x1d
	// Bit mask of DBG_HRTIM3_STOP field.
	DBGMCU_APB2_FZ_DBG_HRTIM3_STOP_Msk = 0x20000000
	// Bit DBG_HRTIM3_STOP.
	DBGMCU_APB2_FZ_DBG_HRTIM3_STOP = 0x20000000
)

// Constants for RCC: Reset and clock control
const (
	// CR: Clock control register
	// Position of PLLRDY field.
	RCC_CR_PLLRDY_Pos = 0x19
	// Bit mask of PLLRDY field.
	RCC_CR_PLLRDY_Msk = 0x2000000
	// Bit PLLRDY.
	RCC_CR_PLLRDY = 0x2000000
	// Clock not ready
	RCC_CR_PLLRDY_NotReady = 0x0
	// Clock ready
	RCC_CR_PLLRDY_Ready = 0x1
	// Position of PLLON field.
	RCC_CR_PLLON_Pos = 0x18
	// Bit mask of PLLON field.
	RCC_CR_PLLON_Msk = 0x1000000
	// Bit PLLON.
	RCC_CR_PLLON = 0x1000000
	// Clock Off
	RCC_CR_PLLON_Off = 0x0
	// Clock On
	RCC_CR_PLLON_On = 0x1
	// Position of CSSON field.
	RCC_CR_CSSON_Pos = 0x13
	// Bit mask of CSSON field.
	RCC_CR_CSSON_Msk = 0x80000
	// Bit CSSON.
	RCC_CR_CSSON = 0x80000
	// Clock security system disabled (clock detector OFF)
	RCC_CR_CSSON_Off = 0x0
	// Clock security system enable (clock detector ON if the HSE is ready, OFF if not)
	RCC_CR_CSSON_On = 0x1
	// Position of HSEBYP field.
	RCC_CR_HSEBYP_Pos = 0x12
	// Bit mask of HSEBYP field.
	RCC_CR_HSEBYP_Msk = 0x40000
	// Bit HSEBYP.
	RCC_CR_HSEBYP = 0x40000
	// HSE crystal oscillator not bypassed
	RCC_CR_HSEBYP_NotBypassed = 0x0
	// HSE crystal oscillator bypassed with external clock
	RCC_CR_HSEBYP_Bypassed = 0x1
	// Position of HSERDY field.
	RCC_CR_HSERDY_Pos = 0x11
	// Bit mask of HSERDY field.
	RCC_CR_HSERDY_Msk = 0x20000
	// Bit HSERDY.
	RCC_CR_HSERDY = 0x20000
	// Clock not ready
	RCC_CR_HSERDY_NotReady = 0x0
	// Clock ready
	RCC_CR_HSERDY_Ready = 0x1
	// Position of HSEON field.
	RCC_CR_HSEON_Pos = 0x10
	// Bit mask of HSEON field.
	RCC_CR_HSEON_Msk = 0x10000
	// Bit HSEON.
	RCC_CR_HSEON = 0x10000
	// Clock Off
	RCC_CR_HSEON_Off = 0x0
	// Clock On
	RCC_CR_HSEON_On = 0x1
	// Position of HSIRDY field.
	RCC_CR_HSIRDY_Pos = 0xa
	// Bit mask of HSIRDY field.
	RCC_CR_HSIRDY_Msk = 0x400
	// Bit HSIRDY.
	RCC_CR_HSIRDY = 0x400
	// Clock not ready
	RCC_CR_HSIRDY_NotReady = 0x0
	// Clock ready
	RCC_CR_HSIRDY_Ready = 0x1
	// Position of HSIKERON field.
	RCC_CR_HSIKERON_Pos = 0x9
	// Bit mask of HSIKERON field.
	RCC_CR_HSIKERON_Msk = 0x200
	// Bit HSIKERON.
	RCC_CR_HSIKERON = 0x200
	// Position of HSION field.
	RCC_CR_HSION_Pos = 0x8
	// Bit mask of HSION field.
	RCC_CR_HSION_Msk = 0x100
	// Bit HSION.
	RCC_CR_HSION = 0x100
	// Clock Off
	RCC_CR_HSION_Off = 0x0
	// Clock On
	RCC_CR_HSION_On = 0x1

	// ICSCR: Internal clock sources calibration register
	// Position of HSICAL0 field.
	RCC_ICSCR_HSICAL0_Pos = 0x10
	// Bit mask of HSICAL0 field.
	RCC_ICSCR_HSICAL0_Msk = 0xff0000
	// Position of HSITRIM field.
	RCC_ICSCR_HSITRIM_Pos = 0x18
	// Bit mask of HSITRIM field.
	RCC_ICSCR_HSITRIM_Msk = 0x7f000000

	// CFGR: Clock configuration register
	// Position of MCOPRE field.
	RCC_CFGR_MCOPRE_Pos = 0x1c
	// Bit mask of MCOPRE field.
	RCC_CFGR_MCOPRE_Msk = 0x70000000
	// MCO divided by 1
	RCC_CFGR_MCOPRE_Div1 = 0x0
	// MCO divided by 2
	RCC_CFGR_MCOPRE_Div2 = 0x1
	// MCO divided by 4
	RCC_CFGR_MCOPRE_Div4 = 0x2
	// MCO divided by 8
	RCC_CFGR_MCOPRE_Div8 = 0x3
	// MCO divided by 16
	RCC_CFGR_MCOPRE_Div16 = 0x4
	// Position of MCOSEL field.
	RCC_CFGR_MCOSEL_Pos = 0x18
	// Bit mask of MCOSEL field.
	RCC_CFGR_MCOSEL_Msk = 0xf000000
	// MCO output disabled, no clock on MCO
	RCC_CFGR_MCOSEL_None = 0x0
	// SYSCLK system clock selected
	RCC_CFGR_MCOSEL_SYSCLK = 0x1
	// MSI clock selected
	RCC_CFGR_MCOSEL_MSI = 0x2
	// HSI clock selected
	RCC_CFGR_MCOSEL_HSI = 0x3
	// HSE clock selected
	RCC_CFGR_MCOSEL_HSE = 0x4
	// Main PLL clock selected
	RCC_CFGR_MCOSEL_PLL = 0x5
	// LSI clock selected
	RCC_CFGR_MCOSEL_LSI = 0x6
	// LSE clock selected
	RCC_CFGR_MCOSEL_LSE = 0x7
	// Internal HSI48 clock selected
	RCC_CFGR_MCOSEL_HSI48 = 0x8
	// Position of PPRE2 field.
	RCC_CFGR_PPRE2_Pos = 0xb
	// Bit mask of PPRE2 field.
	RCC_CFGR_PPRE2_Msk = 0x3800
	// HCLK not divided
	RCC_CFGR_PPRE2_Div1 = 0x0
	// HCLK divided by 2
	RCC_CFGR_PPRE2_Div2 = 0x4
	// HCLK divided by 4
	RCC_CFGR_PPRE2_Div4 = 0x5
	// HCLK divided by 8
	RCC_CFGR_PPRE2_Div8 = 0x6
	// HCLK divided by 16
	RCC_CFGR_PPRE2_Div16 = 0x7
	// Position of PPRE1 field.
	RCC_CFGR_PPRE1_Pos = 0x8
	// Bit mask of PPRE1 field.
	RCC_CFGR_PPRE1_Msk = 0x700
	// HCLK not divided
	RCC_CFGR_PPRE1_Div1 = 0x0
	// HCLK divided by 2
	RCC_CFGR_PPRE1_Div2 = 0x4
	// HCLK divided by 4
	RCC_CFGR_PPRE1_Div4 = 0x5
	// HCLK divided by 8
	RCC_CFGR_PPRE1_Div8 = 0x6
	// HCLK divided by 16
	RCC_CFGR_PPRE1_Div16 = 0x7
	// Position of HPRE field.
	RCC_CFGR_HPRE_Pos = 0x4
	// Bit mask of HPRE field.
	RCC_CFGR_HPRE_Msk = 0xf0
	// SYSCLK not divided
	RCC_CFGR_HPRE_Div1 = 0x0
	// SYSCLK divided by 2
	RCC_CFGR_HPRE_Div2 = 0x8
	// SYSCLK divided by 4
	RCC_CFGR_HPRE_Div4 = 0x9
	// SYSCLK divided by 8
	RCC_CFGR_HPRE_Div8 = 0xa
	// SYSCLK divided by 16
	RCC_CFGR_HPRE_Div16 = 0xb
	// SYSCLK divided by 64
	RCC_CFGR_HPRE_Div64 = 0xc
	// SYSCLK divided by 128
	RCC_CFGR_HPRE_Div128 = 0xd
	// SYSCLK divided by 256
	RCC_CFGR_HPRE_Div256 = 0xe
	// SYSCLK divided by 512
	RCC_CFGR_HPRE_Div512 = 0xf
	// Position of SWS field.
	RCC_CFGR_SWS_Pos = 0x2
	// Bit mask of SWS field.
	RCC_CFGR_SWS_Msk = 0xc
	// MSI oscillator used as system clock
	RCC_CFGR_SWS_MSI = 0x0
	// HSI oscillator used as system clock
	RCC_CFGR_SWS_HSI = 0x1
	// HSE used as system clock
	RCC_CFGR_SWS_HSE = 0x2
	// PLL used as system clock
	RCC_CFGR_SWS_PLL = 0x3
	// Position of SW field.
	RCC_CFGR_SW_Pos = 0x0
	// Bit mask of SW field.
	RCC_CFGR_SW_Msk = 0x3
	// MSI selected as system clock
	RCC_CFGR_SW_MSI = 0x0
	// HSI selected as system clock
	RCC_CFGR_SW_HSI = 0x1
	// HSE selected as system clock
	RCC_CFGR_SW_HSE = 0x2
	// PLL selected as system clock
	RCC_CFGR_SW_PLL = 0x3

	// PLLCFGR: PLL configuration register
	// Position of PLLPDIV field.
	RCC_PLLCFGR_PLLPDIV_Pos = 0x1b
	// Bit mask of PLLPDIV field.
	RCC_PLLCFGR_PLLPDIV_Msk = 0xf8000000
	// pll_p_ck is controlled by PLLP
	RCC_PLLCFGR_PLLPDIV_PLLP = 0x0
	// pll_p_ck = vco_ck / 2
	RCC_PLLCFGR_PLLPDIV_Div2 = 0x2
	// pll_p_ck = vco_ck / 3
	RCC_PLLCFGR_PLLPDIV_Div3 = 0x3
	// pll_p_ck = vco_ck / 4
	RCC_PLLCFGR_PLLPDIV_Div4 = 0x4
	// pll_p_ck = vco_ck / 5
	RCC_PLLCFGR_PLLPDIV_Div5 = 0x5
	// pll_p_ck = vco_ck / 6
	RCC_PLLCFGR_PLLPDIV_Div6 = 0x6
	// pll_p_ck = vco_ck / 7
	RCC_PLLCFGR_PLLPDIV_Div7 = 0x7
	// pll_p_ck = vco_ck / 8
	RCC_PLLCFGR_PLLPDIV_Div8 = 0x8
	// pll_p_ck = vco_ck / 9
	RCC_PLLCFGR_PLLPDIV_Div9 = 0x9
	// pll_p_ck = vco_ck / 10
	RCC_PLLCFGR_PLLPDIV_Div10 = 0xa
	// pll_p_ck = vco_ck / 11
	RCC_PLLCFGR_PLLPDIV_Div11 = 0xb
	// pll_p_ck = vco_ck / 12
	RCC_PLLCFGR_PLLPDIV_Div12 = 0xc
	// pll_p_ck = vco_ck / 13
	RCC_PLLCFGR_PLLPDIV_Div13 = 0xd
	// pll_p_ck = vco_ck / 14
	RCC_PLLCFGR_PLLPDIV_Div14 = 0xe
	// pll_p_ck = vco_ck / 15
	RCC_PLLCFGR_PLLPDIV_Div15 = 0xf
	// pll_p_ck = vco_ck / 16
	RCC_PLLCFGR_PLLPDIV_Div16 = 0x10
	// pll_p_ck = vco_ck / 17
	RCC_PLLCFGR_PLLPDIV_Div17 = 0x11
	// pll_p_ck = vco_ck / 18
	RCC_PLLCFGR_PLLPDIV_Div18 = 0x12
	// pll_p_ck = vco_ck / 19
	RCC_PLLCFGR_PLLPDIV_Div19 = 0x13
	// pll_p_ck = vco_ck / 20
	RCC_PLLCFGR_PLLPDIV_Div20 = 0x14
	// pll_p_ck = vco_ck / 21
	RCC_PLLCFGR_PLLPDIV_Div21 = 0x15
	// pll_p_ck = vco_ck / 22
	RCC_PLLCFGR_PLLPDIV_Div22 = 0x16
	// pll_p_ck = vco_ck / 23
	RCC_PLLCFGR_PLLPDIV_Div23 = 0x17
	// pll_p_ck = vco_ck / 24
	RCC_PLLCFGR_PLLPDIV_Div24 = 0x18
	// pll_p_ck = vco_ck / 25
	RCC_PLLCFGR_PLLPDIV_Div25 = 0x19
	// pll_p_ck = vco_ck / 26
	RCC_PLLCFGR_PLLPDIV_Div26 = 0x1a
	// pll_p_ck = vco_ck / 27
	RCC_PLLCFGR_PLLPDIV_Div27 = 0x1b
	// pll_p_ck = vco_ck / 28
	RCC_PLLCFGR_PLLPDIV_Div28 = 0x1c
	// pll_p_ck = vco_ck / 29
	RCC_PLLCFGR_PLLPDIV_Div29 = 0x1d
	// pll_p_ck = vco_ck / 30
	RCC_PLLCFGR_PLLPDIV_Div30 = 0x1e
	// pll_p_ck = vco_ck / 31
	RCC_PLLCFGR_PLLPDIV_Div31 = 0x1f
	// Position of PLLR field.
	RCC_PLLCFGR_PLLR_Pos = 0x19
	// Bit mask of PLLR field.
	RCC_PLLCFGR_PLLR_Msk = 0x6000000
	// pll_r_ck = vco_ck / 2
	RCC_PLLCFGR_PLLR_Div2 = 0x0
	// pll_r_ck = vco_ck / 4
	RCC_PLLCFGR_PLLR_Div4 = 0x1
	// pll_r_ck = vco_ck / 6
	RCC_PLLCFGR_PLLR_Div6 = 0x2
	// pll_r_ck = vco_ck / 8
	RCC_PLLCFGR_PLLR_Div8 = 0x3
	// Position of PLLREN field.
	RCC_PLLCFGR_PLLREN_Pos = 0x18
	// Bit mask of PLLREN field.
	RCC_PLLCFGR_PLLREN_Msk = 0x1000000
	// Bit PLLREN.
	RCC_PLLCFGR_PLLREN = 0x1000000
	// Position of PLLQ field.
	RCC_PLLCFGR_PLLQ_Pos = 0x15
	// Bit mask of PLLQ field.
	RCC_PLLCFGR_PLLQ_Msk = 0x600000
	// pll_q_ck = vco_ck / 2
	RCC_PLLCFGR_PLLQ_Div2 = 0x0
	// pll_q_ck = vco_ck / 4
	RCC_PLLCFGR_PLLQ_Div4 = 0x1
	// pll_q_ck = vco_ck / 6
	RCC_PLLCFGR_PLLQ_Div6 = 0x2
	// pll_q_ck = vco_ck / 8
	RCC_PLLCFGR_PLLQ_Div8 = 0x3
	// Position of PLLQEN field.
	RCC_PLLCFGR_PLLQEN_Pos = 0x14
	// Bit mask of PLLQEN field.
	RCC_PLLCFGR_PLLQEN_Msk = 0x100000
	// Bit PLLQEN.
	RCC_PLLCFGR_PLLQEN = 0x100000
	// Position of PLLP field.
	RCC_PLLCFGR_PLLP_Pos = 0x11
	// Bit mask of PLLP field.
	RCC_PLLCFGR_PLLP_Msk = 0x20000
	// Bit PLLP.
	RCC_PLLCFGR_PLLP = 0x20000
	// pll_p_ck = vco_ck / 7
	RCC_PLLCFGR_PLLP_Div7 = 0x0
	// pll_p_ck = vco_ck / 17
	RCC_PLLCFGR_PLLP_Div17 = 0x1
	// Position of PLLPEN field.
	RCC_PLLCFGR_PLLPEN_Pos = 0x10
	// Bit mask of PLLPEN field.
	RCC_PLLCFGR_PLLPEN_Msk = 0x10000
	// Bit PLLPEN.
	RCC_PLLCFGR_PLLPEN = 0x10000
	// Position of PLLN field.
	RCC_PLLCFGR_PLLN_Pos = 0x8
	// Bit mask of PLLN field.
	RCC_PLLCFGR_PLLN_Msk = 0x7f00
	// pll_n_ck = vco_ck / 8
	RCC_PLLCFGR_PLLN_Div8 = 0x8
	// pll_n_ck = vco_ck / 9
	RCC_PLLCFGR_PLLN_Div9 = 0x9
	// pll_n_ck = vco_ck / 10
	RCC_PLLCFGR_PLLN_Div10 = 0xa
	// pll_n_ck = vco_ck / 11
	RCC_PLLCFGR_PLLN_Div11 = 0xb
	// pll_n_ck = vco_ck / 12
	RCC_PLLCFGR_PLLN_Div12 = 0xc
	// pll_n_ck = vco_ck / 13
	RCC_PLLCFGR_PLLN_Div13 = 0xd
	// pll_n_ck = vco_ck / 14
	RCC_PLLCFGR_PLLN_Div14 = 0xe
	// pll_n_ck = vco_ck / 15
	RCC_PLLCFGR_PLLN_Div15 = 0xf
	// pll_n_ck = vco_ck / 16
	RCC_PLLCFGR_PLLN_Div16 = 0x10
	// pll_n_ck = vco_ck / 17
	RCC_PLLCFGR_PLLN_Div17 = 0x11
	// pll_n_ck = vco_ck / 18
	RCC_PLLCFGR_PLLN_Div18 = 0x12
	// pll_n_ck = vco_ck / 19
	RCC_PLLCFGR_PLLN_Div19 = 0x13
	// pll_n_ck = vco_ck / 20
	RCC_PLLCFGR_PLLN_Div20 = 0x14
	// pll_n_ck = vco_ck / 21
	RCC_PLLCFGR_PLLN_Div21 = 0x15
	// pll_n_ck = vco_ck / 22
	RCC_PLLCFGR_PLLN_Div22 = 0x16
	// pll_n_ck = vco_ck / 23
	RCC_PLLCFGR_PLLN_Div23 = 0x17
	// pll_n_ck = vco_ck / 24
	RCC_PLLCFGR_PLLN_Div24 = 0x18
	// pll_n_ck = vco_ck / 25
	RCC_PLLCFGR_PLLN_Div25 = 0x19
	// pll_n_ck = vco_ck / 26
	RCC_PLLCFGR_PLLN_Div26 = 0x1a
	// pll_n_ck = vco_ck / 27
	RCC_PLLCFGR_PLLN_Div27 = 0x1b
	// pll_n_ck = vco_ck / 28
	RCC_PLLCFGR_PLLN_Div28 = 0x1c
	// pll_n_ck = vco_ck / 29
	RCC_PLLCFGR_PLLN_Div29 = 0x1d
	// pll_n_ck = vco_ck / 30
	RCC_PLLCFGR_PLLN_Div30 = 0x1e
	// pll_n_ck = vco_ck / 31
	RCC_PLLCFGR_PLLN_Div31 = 0x1f
	// pll_n_ck = vco_ck / 32
	RCC_PLLCFGR_PLLN_Div32 = 0x20
	// pll_n_ck = vco_ck / 33
	RCC_PLLCFGR_PLLN_Div33 = 0x21
	// pll_n_ck = vco_ck / 34
	RCC_PLLCFGR_PLLN_Div34 = 0x22
	// pll_n_ck = vco_ck / 35
	RCC_PLLCFGR_PLLN_Div35 = 0x23
	// pll_n_ck = vco_ck / 36
	RCC_PLLCFGR_PLLN_Div36 = 0x24
	// pll_n_ck = vco_ck / 37
	RCC_PLLCFGR_PLLN_Div37 = 0x25
	// pll_n_ck = vco_ck / 38
	RCC_PLLCFGR_PLLN_Div38 = 0x26
	// pll_n_ck = vco_ck / 39
	RCC_PLLCFGR_PLLN_Div39 = 0x27
	// pll_n_ck = vco_ck / 40
	RCC_PLLCFGR_PLLN_Div40 = 0x28
	// pll_n_ck = vco_ck / 41
	RCC_PLLCFGR_PLLN_Div41 = 0x29
	// pll_n_ck = vco_ck / 42
	RCC_PLLCFGR_PLLN_Div42 = 0x2a
	// pll_n_ck = vco_ck / 43
	RCC_PLLCFGR_PLLN_Div43 = 0x2b
	// pll_n_ck = vco_ck / 44
	RCC_PLLCFGR_PLLN_Div44 = 0x2c
	// pll_n_ck = vco_ck / 45
	RCC_PLLCFGR_PLLN_Div45 = 0x2d
	// pll_n_ck = vco_ck / 46
	RCC_PLLCFGR_PLLN_Div46 = 0x2e
	// pll_n_ck = vco_ck / 47
	RCC_PLLCFGR_PLLN_Div47 = 0x2f
	// pll_n_ck = vco_ck / 48
	RCC_PLLCFGR_PLLN_Div48 = 0x30
	// pll_n_ck = vco_ck / 49
	RCC_PLLCFGR_PLLN_Div49 = 0x31
	// pll_n_ck = vco_ck / 50
	RCC_PLLCFGR_PLLN_Div50 = 0x32
	// pll_n_ck = vco_ck / 51
	RCC_PLLCFGR_PLLN_Div51 = 0x33
	// pll_n_ck = vco_ck / 52
	RCC_PLLCFGR_PLLN_Div52 = 0x34
	// pll_n_ck = vco_ck / 53
	RCC_PLLCFGR_PLLN_Div53 = 0x35
	// pll_n_ck = vco_ck / 54
	RCC_PLLCFGR_PLLN_Div54 = 0x36
	// pll_n_ck = vco_ck / 55
	RCC_PLLCFGR_PLLN_Div55 = 0x37
	// pll_n_ck = vco_ck / 56
	RCC_PLLCFGR_PLLN_Div56 = 0x38
	// pll_n_ck = vco_ck / 57
	RCC_PLLCFGR_PLLN_Div57 = 0x39
	// pll_n_ck = vco_ck / 58
	RCC_PLLCFGR_PLLN_Div58 = 0x3a
	// pll_n_ck = vco_ck / 59
	RCC_PLLCFGR_PLLN_Div59 = 0x3b
	// pll_n_ck = vco_ck / 60
	RCC_PLLCFGR_PLLN_Div60 = 0x3c
	// pll_n_ck = vco_ck / 61
	RCC_PLLCFGR_PLLN_Div61 = 0x3d
	// pll_n_ck = vco_ck / 62
	RCC_PLLCFGR_PLLN_Div62 = 0x3e
	// pll_n_ck = vco_ck / 63
	RCC_PLLCFGR_PLLN_Div63 = 0x3f
	// pll_n_ck = vco_ck / 64
	RCC_PLLCFGR_PLLN_Div64 = 0x40
	// pll_n_ck = vco_ck / 65
	RCC_PLLCFGR_PLLN_Div65 = 0x41
	// pll_n_ck = vco_ck / 66
	RCC_PLLCFGR_PLLN_Div66 = 0x42
	// pll_n_ck = vco_ck / 67
	RCC_PLLCFGR_PLLN_Div67 = 0x43
	// pll_n_ck = vco_ck / 68
	RCC_PLLCFGR_PLLN_Div68 = 0x44
	// pll_n_ck = vco_ck / 69
	RCC_PLLCFGR_PLLN_Div69 = 0x45
	// pll_n_ck = vco_ck / 70
	RCC_PLLCFGR_PLLN_Div70 = 0x46
	// pll_n_ck = vco_ck / 71
	RCC_PLLCFGR_PLLN_Div71 = 0x47
	// pll_n_ck = vco_ck / 72
	RCC_PLLCFGR_PLLN_Div72 = 0x48
	// pll_n_ck = vco_ck / 73
	RCC_PLLCFGR_PLLN_Div73 = 0x49
	// pll_n_ck = vco_ck / 74
	RCC_PLLCFGR_PLLN_Div74 = 0x4a
	// pll_n_ck = vco_ck / 75
	RCC_PLLCFGR_PLLN_Div75 = 0x4b
	// pll_n_ck = vco_ck / 76
	RCC_PLLCFGR_PLLN_Div76 = 0x4c
	// pll_n_ck = vco_ck / 77
	RCC_PLLCFGR_PLLN_Div77 = 0x4d
	// pll_n_ck = vco_ck / 78
	RCC_PLLCFGR_PLLN_Div78 = 0x4e
	// pll_n_ck = vco_ck / 79
	RCC_PLLCFGR_PLLN_Div79 = 0x4f
	// pll_n_ck = vco_ck / 80
	RCC_PLLCFGR_PLLN_Div80 = 0x50
	// pll_n_ck = vco_ck / 81
	RCC_PLLCFGR_PLLN_Div81 = 0x51
	// pll_n_ck = vco_ck / 82
	RCC_PLLCFGR_PLLN_Div82 = 0x52
	// pll_n_ck = vco_ck / 83
	RCC_PLLCFGR_PLLN_Div83 = 0x53
	// pll_n_ck = vco_ck / 84
	RCC_PLLCFGR_PLLN_Div84 = 0x54
	// pll_n_ck = vco_ck / 85
	RCC_PLLCFGR_PLLN_Div85 = 0x55
	// pll_n_ck = vco_ck / 86
	RCC_PLLCFGR_PLLN_Div86 = 0x56
	// pll_n_ck = vco_ck / 87
	RCC_PLLCFGR_PLLN_Div87 = 0x57
	// pll_n_ck = vco_ck / 88
	RCC_PLLCFGR_PLLN_Div88 = 0x58
	// pll_n_ck = vco_ck / 89
	RCC_PLLCFGR_PLLN_Div89 = 0x59
	// pll_n_ck = vco_ck / 90
	RCC_PLLCFGR_PLLN_Div90 = 0x5a
	// pll_n_ck = vco_ck / 91
	RCC_PLLCFGR_PLLN_Div91 = 0x5b
	// pll_n_ck = vco_ck / 92
	RCC_PLLCFGR_PLLN_Div92 = 0x5c
	// pll_n_ck = vco_ck / 93
	RCC_PLLCFGR_PLLN_Div93 = 0x5d
	// pll_n_ck = vco_ck / 94
	RCC_PLLCFGR_PLLN_Div94 = 0x5e
	// pll_n_ck = vco_ck / 95
	RCC_PLLCFGR_PLLN_Div95 = 0x5f
	// pll_n_ck = vco_ck / 96
	RCC_PLLCFGR_PLLN_Div96 = 0x60
	// pll_n_ck = vco_ck / 97
	RCC_PLLCFGR_PLLN_Div97 = 0x61
	// pll_n_ck = vco_ck / 98
	RCC_PLLCFGR_PLLN_Div98 = 0x62
	// pll_n_ck = vco_ck / 99
	RCC_PLLCFGR_PLLN_Div99 = 0x63
	// pll_n_ck = vco_ck / 100
	RCC_PLLCFGR_PLLN_Div100 = 0x64
	// pll_n_ck = vco_ck / 101
	RCC_PLLCFGR_PLLN_Div101 = 0x65
	// pll_n_ck = vco_ck / 102
	RCC_PLLCFGR_PLLN_Div102 = 0x66
	// pll_n_ck = vco_ck / 103
	RCC_PLLCFGR_PLLN_Div103 = 0x67
	// pll_n_ck = vco_ck / 104
	RCC_PLLCFGR_PLLN_Div104 = 0x68
	// pll_n_ck = vco_ck / 105
	RCC_PLLCFGR_PLLN_Div105 = 0x69
	// pll_n_ck = vco_ck / 106
	RCC_PLLCFGR_PLLN_Div106 = 0x6a
	// pll_n_ck = vco_ck / 107
	RCC_PLLCFGR_PLLN_Div107 = 0x6b
	// pll_n_ck = vco_ck / 108
	RCC_PLLCFGR_PLLN_Div108 = 0x6c
	// pll_n_ck = vco_ck / 109
	RCC_PLLCFGR_PLLN_Div109 = 0x6d
	// pll_n_ck = vco_ck / 110
	RCC_PLLCFGR_PLLN_Div110 = 0x6e
	// pll_n_ck = vco_ck / 111
	RCC_PLLCFGR_PLLN_Div111 = 0x6f
	// pll_n_ck = vco_ck / 112
	RCC_PLLCFGR_PLLN_Div112 = 0x70
	// pll_n_ck = vco_ck / 113
	RCC_PLLCFGR_PLLN_Div113 = 0x71
	// pll_n_ck = vco_ck / 114
	RCC_PLLCFGR_PLLN_Div114 = 0x72
	// pll_n_ck = vco_ck / 115
	RCC_PLLCFGR_PLLN_Div115 = 0x73
	// pll_n_ck = vco_ck / 116
	RCC_PLLCFGR_PLLN_Div116 = 0x74
	// pll_n_ck = vco_ck / 117
	RCC_PLLCFGR_PLLN_Div117 = 0x75
	// pll_n_ck = vco_ck / 118
	RCC_PLLCFGR_PLLN_Div118 = 0x76
	// pll_n_ck = vco_ck / 119
	RCC_PLLCFGR_PLLN_Div119 = 0x77
	// pll_n_ck = vco_ck / 120
	RCC_PLLCFGR_PLLN_Div120 = 0x78
	// pll_n_ck = vco_ck / 121
	RCC_PLLCFGR_PLLN_Div121 = 0x79
	// pll_n_ck = vco_ck / 122
	RCC_PLLCFGR_PLLN_Div122 = 0x7a
	// pll_n_ck = vco_ck / 123
	RCC_PLLCFGR_PLLN_Div123 = 0x7b
	// pll_n_ck = vco_ck / 124
	RCC_PLLCFGR_PLLN_Div124 = 0x7c
	// pll_n_ck = vco_ck / 125
	RCC_PLLCFGR_PLLN_Div125 = 0x7d
	// pll_n_ck = vco_ck / 126
	RCC_PLLCFGR_PLLN_Div126 = 0x7e
	// pll_n_ck = vco_ck / 127
	RCC_PLLCFGR_PLLN_Div127 = 0x7f
	// Position of PLLM field.
	RCC_PLLCFGR_PLLM_Pos = 0x4
	// Bit mask of PLLM field.
	RCC_PLLCFGR_PLLM_Msk = 0xf0
	// pll_p_ck = vco_ck / 1
	RCC_PLLCFGR_PLLM_Div1 = 0x0
	// pll_p_ck = vco_ck / 2
	RCC_PLLCFGR_PLLM_Div2 = 0x1
	// pll_p_ck = vco_ck / 3
	RCC_PLLCFGR_PLLM_Div3 = 0x2
	// pll_p_ck = vco_ck / 4
	RCC_PLLCFGR_PLLM_Div4 = 0x3
	// pll_p_ck = vco_ck / 5
	RCC_PLLCFGR_PLLM_Div5 = 0x4
	// pll_p_ck = vco_ck / 6
	RCC_PLLCFGR_PLLM_Div6 = 0x5
	// pll_p_ck = vco_ck / 7
	RCC_PLLCFGR_PLLM_Div7 = 0x6
	// pll_p_ck = vco_ck / 8
	RCC_PLLCFGR_PLLM_Div8 = 0x7
	// pll_p_ck = vco_ck / 9
	RCC_PLLCFGR_PLLM_Div9 = 0x8
	// pll_p_ck = vco_ck / 10
	RCC_PLLCFGR_PLLM_Div10 = 0x9
	// pll_p_ck = vco_ck / 11
	RCC_PLLCFGR_PLLM_Div11 = 0xa
	// pll_p_ck = vco_ck / 12
	RCC_PLLCFGR_PLLM_Div12 = 0xb
	// pll_p_ck = vco_ck / 13
	RCC_PLLCFGR_PLLM_Div13 = 0xc
	// pll_p_ck = vco_ck / 14
	RCC_PLLCFGR_PLLM_Div14 = 0xd
	// pll_p_ck = vco_ck / 15
	RCC_PLLCFGR_PLLM_Div15 = 0xe
	// pll_p_ck = vco_ck / 16
	RCC_PLLCFGR_PLLM_Div16 = 0xf
	// Position of PLLSRC field.
	RCC_PLLCFGR_PLLSRC_Pos = 0x0
	// Bit mask of PLLSRC field.
	RCC_PLLCFGR_PLLSRC_Msk = 0x3
	// No clock sent to PLL
	RCC_PLLCFGR_PLLSRC_None = 0x0
	// No clock sent to PLL
	RCC_PLLCFGR_PLLSRC_HSI16 = 0x2
	// No clock sent to PLL
	RCC_PLLCFGR_PLLSRC_HSE = 0x3

	// CIER: Clock interrupt enable register
	// Position of LSIRDYIE field.
	RCC_CIER_LSIRDYIE_Pos = 0x0
	// Bit mask of LSIRDYIE field.
	RCC_CIER_LSIRDYIE_Msk = 0x1
	// Bit LSIRDYIE.
	RCC_CIER_LSIRDYIE = 0x1
	// Position of LSERDYIE field.
	RCC_CIER_LSERDYIE_Pos = 0x1
	// Bit mask of LSERDYIE field.
	RCC_CIER_LSERDYIE_Msk = 0x2
	// Bit LSERDYIE.
	RCC_CIER_LSERDYIE = 0x2
	// Position of HSIRDYIE field.
	RCC_CIER_HSIRDYIE_Pos = 0x3
	// Bit mask of HSIRDYIE field.
	RCC_CIER_HSIRDYIE_Msk = 0x8
	// Bit HSIRDYIE.
	RCC_CIER_HSIRDYIE = 0x8
	// Position of HSERDYIE field.
	RCC_CIER_HSERDYIE_Pos = 0x4
	// Bit mask of HSERDYIE field.
	RCC_CIER_HSERDYIE_Msk = 0x10
	// Bit HSERDYIE.
	RCC_CIER_HSERDYIE = 0x10
	// Position of PLLRDYIE field.
	RCC_CIER_PLLRDYIE_Pos = 0x5
	// Bit mask of PLLRDYIE field.
	RCC_CIER_PLLRDYIE_Msk = 0x20
	// Bit PLLRDYIE.
	RCC_CIER_PLLRDYIE = 0x20
	// Position of LSECSSIE field.
	RCC_CIER_LSECSSIE_Pos = 0x9
	// Bit mask of LSECSSIE field.
	RCC_CIER_LSECSSIE_Msk = 0x200
	// Bit LSECSSIE.
	RCC_CIER_LSECSSIE = 0x200
	// Position of HSI48RDYIE field.
	RCC_CIER_HSI48RDYIE_Pos = 0xa
	// Bit mask of HSI48RDYIE field.
	RCC_CIER_HSI48RDYIE_Msk = 0x400
	// Bit HSI48RDYIE.
	RCC_CIER_HSI48RDYIE = 0x400

	// CIFR: Clock interrupt flag register
	// Position of LSIRDYF field.
	RCC_CIFR_LSIRDYF_Pos = 0x0
	// Bit mask of LSIRDYF field.
	RCC_CIFR_LSIRDYF_Msk = 0x1
	// Bit LSIRDYF.
	RCC_CIFR_LSIRDYF = 0x1
	// Position of LSERDYF field.
	RCC_CIFR_LSERDYF_Pos = 0x1
	// Bit mask of LSERDYF field.
	RCC_CIFR_LSERDYF_Msk = 0x2
	// Bit LSERDYF.
	RCC_CIFR_LSERDYF = 0x2
	// Position of HSIRDYF field.
	RCC_CIFR_HSIRDYF_Pos = 0x3
	// Bit mask of HSIRDYF field.
	RCC_CIFR_HSIRDYF_Msk = 0x8
	// Bit HSIRDYF.
	RCC_CIFR_HSIRDYF = 0x8
	// Position of HSERDYF field.
	RCC_CIFR_HSERDYF_Pos = 0x4
	// Bit mask of HSERDYF field.
	RCC_CIFR_HSERDYF_Msk = 0x10
	// Bit HSERDYF.
	RCC_CIFR_HSERDYF = 0x10
	// Position of PLLRDYF field.
	RCC_CIFR_PLLRDYF_Pos = 0x5
	// Bit mask of PLLRDYF field.
	RCC_CIFR_PLLRDYF_Msk = 0x20
	// Bit PLLRDYF.
	RCC_CIFR_PLLRDYF = 0x20
	// Position of CSSF field.
	RCC_CIFR_CSSF_Pos = 0x8
	// Bit mask of CSSF field.
	RCC_CIFR_CSSF_Msk = 0x100
	// Bit CSSF.
	RCC_CIFR_CSSF = 0x100
	// Position of LSECSSF field.
	RCC_CIFR_LSECSSF_Pos = 0x9
	// Bit mask of LSECSSF field.
	RCC_CIFR_LSECSSF_Msk = 0x200
	// Bit LSECSSF.
	RCC_CIFR_LSECSSF = 0x200
	// Position of HSI48RDYF field.
	RCC_CIFR_HSI48RDYF_Pos = 0xa
	// Bit mask of HSI48RDYF field.
	RCC_CIFR_HSI48RDYF_Msk = 0x400
	// Bit HSI48RDYF.
	RCC_CIFR_HSI48RDYF = 0x400

	// CICR: Clock interrupt clear register
	// Position of LSIRDYC field.
	RCC_CICR_LSIRDYC_Pos = 0x0
	// Bit mask of LSIRDYC field.
	RCC_CICR_LSIRDYC_Msk = 0x1
	// Bit LSIRDYC.
	RCC_CICR_LSIRDYC = 0x1
	// Position of LSERDYC field.
	RCC_CICR_LSERDYC_Pos = 0x1
	// Bit mask of LSERDYC field.
	RCC_CICR_LSERDYC_Msk = 0x2
	// Bit LSERDYC.
	RCC_CICR_LSERDYC = 0x2
	// Position of HSIRDYC field.
	RCC_CICR_HSIRDYC_Pos = 0x3
	// Bit mask of HSIRDYC field.
	RCC_CICR_HSIRDYC_Msk = 0x8
	// Bit HSIRDYC.
	RCC_CICR_HSIRDYC = 0x8
	// Position of HSERDYC field.
	RCC_CICR_HSERDYC_Pos = 0x4
	// Bit mask of HSERDYC field.
	RCC_CICR_HSERDYC_Msk = 0x10
	// Bit HSERDYC.
	RCC_CICR_HSERDYC = 0x10
	// Position of PLLRDYC field.
	RCC_CICR_PLLRDYC_Pos = 0x5
	// Bit mask of PLLRDYC field.
	RCC_CICR_PLLRDYC_Msk = 0x20
	// Bit PLLRDYC.
	RCC_CICR_PLLRDYC = 0x20
	// Position of CSSC field.
	RCC_CICR_CSSC_Pos = 0x8
	// Bit mask of CSSC field.
	RCC_CICR_CSSC_Msk = 0x100
	// Bit CSSC.
	RCC_CICR_CSSC = 0x100
	// Position of LSECSSC field.
	RCC_CICR_LSECSSC_Pos = 0x9
	// Bit mask of LSECSSC field.
	RCC_CICR_LSECSSC_Msk = 0x200
	// Bit LSECSSC.
	RCC_CICR_LSECSSC = 0x200
	// Position of HSI48RDYC field.
	RCC_CICR_HSI48RDYC_Pos = 0xa
	// Bit mask of HSI48RDYC field.
	RCC_CICR_HSI48RDYC_Msk = 0x400
	// Bit HSI48RDYC.
	RCC_CICR_HSI48RDYC = 0x400

	// AHB1RSTR: AHB1 peripheral reset register
	// Position of DMA1RST field.
	RCC_AHB1RSTR_DMA1RST_Pos = 0x0
	// Bit mask of DMA1RST field.
	RCC_AHB1RSTR_DMA1RST_Msk = 0x1
	// Bit DMA1RST.
	RCC_AHB1RSTR_DMA1RST = 0x1
	// Reset the selected module
	RCC_AHB1RSTR_DMA1RST_Reset = 0x1
	// Position of DMA2RST field.
	RCC_AHB1RSTR_DMA2RST_Pos = 0x1
	// Bit mask of DMA2RST field.
	RCC_AHB1RSTR_DMA2RST_Msk = 0x2
	// Bit DMA2RST.
	RCC_AHB1RSTR_DMA2RST = 0x2
	// Reset the selected module
	RCC_AHB1RSTR_DMA2RST_Reset = 0x1
	// Position of DMAMUX1RST field.
	RCC_AHB1RSTR_DMAMUX1RST_Pos = 0x2
	// Bit mask of DMAMUX1RST field.
	RCC_AHB1RSTR_DMAMUX1RST_Msk = 0x4
	// Bit DMAMUX1RST.
	RCC_AHB1RSTR_DMAMUX1RST = 0x4
	// Reset the selected module
	RCC_AHB1RSTR_DMAMUX1RST_Reset = 0x1
	// Position of CORDICRST field.
	RCC_AHB1RSTR_CORDICRST_Pos = 0x3
	// Bit mask of CORDICRST field.
	RCC_AHB1RSTR_CORDICRST_Msk = 0x8
	// Bit CORDICRST.
	RCC_AHB1RSTR_CORDICRST = 0x8
	// Reset the selected module
	RCC_AHB1RSTR_CORDICRST_Reset = 0x1
	// Position of FMACRST field.
	RCC_AHB1RSTR_FMACRST_Pos = 0x4
	// Bit mask of FMACRST field.
	RCC_AHB1RSTR_FMACRST_Msk = 0x10
	// Bit FMACRST.
	RCC_AHB1RSTR_FMACRST = 0x10
	// Reset the selected module
	RCC_AHB1RSTR_FMACRST_Reset = 0x1
	// Position of FLASHRST field.
	RCC_AHB1RSTR_FLASHRST_Pos = 0x8
	// Bit mask of FLASHRST field.
	RCC_AHB1RSTR_FLASHRST_Msk = 0x100
	// Bit FLASHRST.
	RCC_AHB1RSTR_FLASHRST = 0x100
	// Reset the selected module
	RCC_AHB1RSTR_FLASHRST_Reset = 0x1
	// Position of CRCRST field.
	RCC_AHB1RSTR_CRCRST_Pos = 0xc
	// Bit mask of CRCRST field.
	RCC_AHB1RSTR_CRCRST_Msk = 0x1000
	// Bit CRCRST.
	RCC_AHB1RSTR_CRCRST = 0x1000
	// Reset the selected module
	RCC_AHB1RSTR_CRCRST_Reset = 0x1

	// AHB2RSTR: AHB2 peripheral reset register
	// Position of GPIOARST field.
	RCC_AHB2RSTR_GPIOARST_Pos = 0x0
	// Bit mask of GPIOARST field.
	RCC_AHB2RSTR_GPIOARST_Msk = 0x1
	// Bit GPIOARST.
	RCC_AHB2RSTR_GPIOARST = 0x1
	// Reset the selected module
	RCC_AHB2RSTR_GPIOARST_Reset = 0x1
	// Position of GPIOBRST field.
	RCC_AHB2RSTR_GPIOBRST_Pos = 0x1
	// Bit mask of GPIOBRST field.
	RCC_AHB2RSTR_GPIOBRST_Msk = 0x2
	// Bit GPIOBRST.
	RCC_AHB2RSTR_GPIOBRST = 0x2
	// Reset the selected module
	RCC_AHB2RSTR_GPIOBRST_Reset = 0x1
	// Position of GPIOCRST field.
	RCC_AHB2RSTR_GPIOCRST_Pos = 0x2
	// Bit mask of GPIOCRST field.
	RCC_AHB2RSTR_GPIOCRST_Msk = 0x4
	// Bit GPIOCRST.
	RCC_AHB2RSTR_GPIOCRST = 0x4
	// Reset the selected module
	RCC_AHB2RSTR_GPIOCRST_Reset = 0x1
	// Position of GPIODRST field.
	RCC_AHB2RSTR_GPIODRST_Pos = 0x3
	// Bit mask of GPIODRST field.
	RCC_AHB2RSTR_GPIODRST_Msk = 0x8
	// Bit GPIODRST.
	RCC_AHB2RSTR_GPIODRST = 0x8
	// Reset the selected module
	RCC_AHB2RSTR_GPIODRST_Reset = 0x1
	// Position of GPIOERST field.
	RCC_AHB2RSTR_GPIOERST_Pos = 0x4
	// Bit mask of GPIOERST field.
	RCC_AHB2RSTR_GPIOERST_Msk = 0x10
	// Bit GPIOERST.
	RCC_AHB2RSTR_GPIOERST = 0x10
	// Reset the selected module
	RCC_AHB2RSTR_GPIOERST_Reset = 0x1
	// Position of GPIOFRST field.
	RCC_AHB2RSTR_GPIOFRST_Pos = 0x5
	// Bit mask of GPIOFRST field.
	RCC_AHB2RSTR_GPIOFRST_Msk = 0x20
	// Bit GPIOFRST.
	RCC_AHB2RSTR_GPIOFRST = 0x20
	// Reset the selected module
	RCC_AHB2RSTR_GPIOFRST_Reset = 0x1
	// Position of GPIOGRST field.
	RCC_AHB2RSTR_GPIOGRST_Pos = 0x6
	// Bit mask of GPIOGRST field.
	RCC_AHB2RSTR_GPIOGRST_Msk = 0x40
	// Bit GPIOGRST.
	RCC_AHB2RSTR_GPIOGRST = 0x40
	// Reset the selected module
	RCC_AHB2RSTR_GPIOGRST_Reset = 0x1
	// Position of ADC12RST field.
	RCC_AHB2RSTR_ADC12RST_Pos = 0xd
	// Bit mask of ADC12RST field.
	RCC_AHB2RSTR_ADC12RST_Msk = 0x2000
	// Bit ADC12RST.
	RCC_AHB2RSTR_ADC12RST = 0x2000
	// Reset the selected module
	RCC_AHB2RSTR_ADC12RST_Reset = 0x1
	// Position of ADC345RST field.
	RCC_AHB2RSTR_ADC345RST_Pos = 0xe
	// Bit mask of ADC345RST field.
	RCC_AHB2RSTR_ADC345RST_Msk = 0x4000
	// Bit ADC345RST.
	RCC_AHB2RSTR_ADC345RST = 0x4000
	// Reset the selected module
	RCC_AHB2RSTR_ADC345RST_Reset = 0x1
	// Position of DAC1RST field.
	RCC_AHB2RSTR_DAC1RST_Pos = 0x10
	// Bit mask of DAC1RST field.
	RCC_AHB2RSTR_DAC1RST_Msk = 0x10000
	// Bit DAC1RST.
	RCC_AHB2RSTR_DAC1RST = 0x10000
	// Reset the selected module
	RCC_AHB2RSTR_DAC1RST_Reset = 0x1
	// Position of DAC2RST field.
	RCC_AHB2RSTR_DAC2RST_Pos = 0x11
	// Bit mask of DAC2RST field.
	RCC_AHB2RSTR_DAC2RST_Msk = 0x20000
	// Bit DAC2RST.
	RCC_AHB2RSTR_DAC2RST = 0x20000
	// Reset the selected module
	RCC_AHB2RSTR_DAC2RST_Reset = 0x1
	// Position of DAC3RST field.
	RCC_AHB2RSTR_DAC3RST_Pos = 0x12
	// Bit mask of DAC3RST field.
	RCC_AHB2RSTR_DAC3RST_Msk = 0x40000
	// Bit DAC3RST.
	RCC_AHB2RSTR_DAC3RST = 0x40000
	// Reset the selected module
	RCC_AHB2RSTR_DAC3RST_Reset = 0x1
	// Position of DAC4RST field.
	RCC_AHB2RSTR_DAC4RST_Pos = 0x13
	// Bit mask of DAC4RST field.
	RCC_AHB2RSTR_DAC4RST_Msk = 0x80000
	// Bit DAC4RST.
	RCC_AHB2RSTR_DAC4RST = 0x80000
	// Reset the selected module
	RCC_AHB2RSTR_DAC4RST_Reset = 0x1
	// Position of AESRST field.
	RCC_AHB2RSTR_AESRST_Pos = 0x18
	// Bit mask of AESRST field.
	RCC_AHB2RSTR_AESRST_Msk = 0x1000000
	// Bit AESRST.
	RCC_AHB2RSTR_AESRST = 0x1000000
	// Reset the selected module
	RCC_AHB2RSTR_AESRST_Reset = 0x1
	// Position of RNGRST field.
	RCC_AHB2RSTR_RNGRST_Pos = 0x1a
	// Bit mask of RNGRST field.
	RCC_AHB2RSTR_RNGRST_Msk = 0x4000000
	// Bit RNGRST.
	RCC_AHB2RSTR_RNGRST = 0x4000000
	// Reset the selected module
	RCC_AHB2RSTR_RNGRST_Reset = 0x1

	// AHB3RSTR: AHB3 peripheral reset register
	// Position of FMCRST field.
	RCC_AHB3RSTR_FMCRST_Pos = 0x0
	// Bit mask of FMCRST field.
	RCC_AHB3RSTR_FMCRST_Msk = 0x1
	// Bit FMCRST.
	RCC_AHB3RSTR_FMCRST = 0x1
	// Reset the selected module
	RCC_AHB3RSTR_FMCRST_Reset = 0x1
	// Position of QSPIRST field.
	RCC_AHB3RSTR_QSPIRST_Pos = 0x8
	// Bit mask of QSPIRST field.
	RCC_AHB3RSTR_QSPIRST_Msk = 0x100
	// Bit QSPIRST.
	RCC_AHB3RSTR_QSPIRST = 0x100
	// Reset the selected module
	RCC_AHB3RSTR_QSPIRST_Reset = 0x1

	// APB1RSTR1: APB1 peripheral reset register 1
	// Position of LPTIM1RST field.
	RCC_APB1RSTR1_LPTIM1RST_Pos = 0x1f
	// Bit mask of LPTIM1RST field.
	RCC_APB1RSTR1_LPTIM1RST_Msk = 0x80000000
	// Bit LPTIM1RST.
	RCC_APB1RSTR1_LPTIM1RST = 0x80000000
	// Reset the selected module
	RCC_APB1RSTR1_LPTIM1RST_Reset = 0x1
	// Position of I2C3RST field.
	RCC_APB1RSTR1_I2C3RST_Pos = 0x1e
	// Bit mask of I2C3RST field.
	RCC_APB1RSTR1_I2C3RST_Msk = 0x40000000
	// Bit I2C3RST.
	RCC_APB1RSTR1_I2C3RST = 0x40000000
	// Reset the selected module
	RCC_APB1RSTR1_I2C3RST_Reset = 0x1
	// Position of PWRRST field.
	RCC_APB1RSTR1_PWRRST_Pos = 0x1c
	// Bit mask of PWRRST field.
	RCC_APB1RSTR1_PWRRST_Msk = 0x10000000
	// Bit PWRRST.
	RCC_APB1RSTR1_PWRRST = 0x10000000
	// Reset the selected module
	RCC_APB1RSTR1_PWRRST_Reset = 0x1
	// Position of FDCANRST field.
	RCC_APB1RSTR1_FDCANRST_Pos = 0x19
	// Bit mask of FDCANRST field.
	RCC_APB1RSTR1_FDCANRST_Msk = 0x2000000
	// Bit FDCANRST.
	RCC_APB1RSTR1_FDCANRST = 0x2000000
	// Reset the selected module
	RCC_APB1RSTR1_FDCANRST_Reset = 0x1
	// Position of USBRST field.
	RCC_APB1RSTR1_USBRST_Pos = 0x17
	// Bit mask of USBRST field.
	RCC_APB1RSTR1_USBRST_Msk = 0x800000
	// Bit USBRST.
	RCC_APB1RSTR1_USBRST = 0x800000
	// Reset the selected module
	RCC_APB1RSTR1_USBRST_Reset = 0x1
	// Position of I2C2RST field.
	RCC_APB1RSTR1_I2C2RST_Pos = 0x16
	// Bit mask of I2C2RST field.
	RCC_APB1RSTR1_I2C2RST_Msk = 0x400000
	// Bit I2C2RST.
	RCC_APB1RSTR1_I2C2RST = 0x400000
	// Reset the selected module
	RCC_APB1RSTR1_I2C2RST_Reset = 0x1
	// Position of I2C1RST field.
	RCC_APB1RSTR1_I2C1RST_Pos = 0x15
	// Bit mask of I2C1RST field.
	RCC_APB1RSTR1_I2C1RST_Msk = 0x200000
	// Bit I2C1RST.
	RCC_APB1RSTR1_I2C1RST = 0x200000
	// Reset the selected module
	RCC_APB1RSTR1_I2C1RST_Reset = 0x1
	// Position of UART5RST field.
	RCC_APB1RSTR1_UART5RST_Pos = 0x14
	// Bit mask of UART5RST field.
	RCC_APB1RSTR1_UART5RST_Msk = 0x100000
	// Bit UART5RST.
	RCC_APB1RSTR1_UART5RST = 0x100000
	// Reset the selected module
	RCC_APB1RSTR1_UART5RST_Reset = 0x1
	// Position of UART4RST field.
	RCC_APB1RSTR1_UART4RST_Pos = 0x13
	// Bit mask of UART4RST field.
	RCC_APB1RSTR1_UART4RST_Msk = 0x80000
	// Bit UART4RST.
	RCC_APB1RSTR1_UART4RST = 0x80000
	// Reset the selected module
	RCC_APB1RSTR1_UART4RST_Reset = 0x1
	// Position of USART3RST field.
	RCC_APB1RSTR1_USART3RST_Pos = 0x12
	// Bit mask of USART3RST field.
	RCC_APB1RSTR1_USART3RST_Msk = 0x40000
	// Bit USART3RST.
	RCC_APB1RSTR1_USART3RST = 0x40000
	// Reset the selected module
	RCC_APB1RSTR1_USART3RST_Reset = 0x1
	// Position of USART2RST field.
	RCC_APB1RSTR1_USART2RST_Pos = 0x11
	// Bit mask of USART2RST field.
	RCC_APB1RSTR1_USART2RST_Msk = 0x20000
	// Bit USART2RST.
	RCC_APB1RSTR1_USART2RST = 0x20000
	// Reset the selected module
	RCC_APB1RSTR1_USART2RST_Reset = 0x1
	// Position of SPI3RST field.
	RCC_APB1RSTR1_SPI3RST_Pos = 0xf
	// Bit mask of SPI3RST field.
	RCC_APB1RSTR1_SPI3RST_Msk = 0x8000
	// Bit SPI3RST.
	RCC_APB1RSTR1_SPI3RST = 0x8000
	// Reset the selected module
	RCC_APB1RSTR1_SPI3RST_Reset = 0x1
	// Position of SPI2RST field.
	RCC_APB1RSTR1_SPI2RST_Pos = 0xe
	// Bit mask of SPI2RST field.
	RCC_APB1RSTR1_SPI2RST_Msk = 0x4000
	// Bit SPI2RST.
	RCC_APB1RSTR1_SPI2RST = 0x4000
	// Reset the selected module
	RCC_APB1RSTR1_SPI2RST_Reset = 0x1
	// Position of CRSRST field.
	RCC_APB1RSTR1_CRSRST_Pos = 0x8
	// Bit mask of CRSRST field.
	RCC_APB1RSTR1_CRSRST_Msk = 0x100
	// Bit CRSRST.
	RCC_APB1RSTR1_CRSRST = 0x100
	// Reset the selected module
	RCC_APB1RSTR1_CRSRST_Reset = 0x1
	// Position of TIM7RST field.
	RCC_APB1RSTR1_TIM7RST_Pos = 0x5
	// Bit mask of TIM7RST field.
	RCC_APB1RSTR1_TIM7RST_Msk = 0x20
	// Bit TIM7RST.
	RCC_APB1RSTR1_TIM7RST = 0x20
	// Reset the selected module
	RCC_APB1RSTR1_TIM7RST_Reset = 0x1
	// Position of TIM6RST field.
	RCC_APB1RSTR1_TIM6RST_Pos = 0x4
	// Bit mask of TIM6RST field.
	RCC_APB1RSTR1_TIM6RST_Msk = 0x10
	// Bit TIM6RST.
	RCC_APB1RSTR1_TIM6RST = 0x10
	// Reset the selected module
	RCC_APB1RSTR1_TIM6RST_Reset = 0x1
	// Position of TIM5RST field.
	RCC_APB1RSTR1_TIM5RST_Pos = 0x3
	// Bit mask of TIM5RST field.
	RCC_APB1RSTR1_TIM5RST_Msk = 0x8
	// Bit TIM5RST.
	RCC_APB1RSTR1_TIM5RST = 0x8
	// Reset the selected module
	RCC_APB1RSTR1_TIM5RST_Reset = 0x1
	// Position of TIM4RST field.
	RCC_APB1RSTR1_TIM4RST_Pos = 0x2
	// Bit mask of TIM4RST field.
	RCC_APB1RSTR1_TIM4RST_Msk = 0x4
	// Bit TIM4RST.
	RCC_APB1RSTR1_TIM4RST = 0x4
	// Reset the selected module
	RCC_APB1RSTR1_TIM4RST_Reset = 0x1
	// Position of TIM3RST field.
	RCC_APB1RSTR1_TIM3RST_Pos = 0x1
	// Bit mask of TIM3RST field.
	RCC_APB1RSTR1_TIM3RST_Msk = 0x2
	// Bit TIM3RST.
	RCC_APB1RSTR1_TIM3RST = 0x2
	// Reset the selected module
	RCC_APB1RSTR1_TIM3RST_Reset = 0x1
	// Position of TIM2RST field.
	RCC_APB1RSTR1_TIM2RST_Pos = 0x0
	// Bit mask of TIM2RST field.
	RCC_APB1RSTR1_TIM2RST_Msk = 0x1
	// Bit TIM2RST.
	RCC_APB1RSTR1_TIM2RST = 0x1
	// Reset the selected module
	RCC_APB1RSTR1_TIM2RST_Reset = 0x1

	// APB1RSTR2: APB1 peripheral reset register 2
	// Position of LPUART1RST field.
	RCC_APB1RSTR2_LPUART1RST_Pos = 0x0
	// Bit mask of LPUART1RST field.
	RCC_APB1RSTR2_LPUART1RST_Msk = 0x1
	// Bit LPUART1RST.
	RCC_APB1RSTR2_LPUART1RST = 0x1
	// Reset the selected module
	RCC_APB1RSTR2_LPUART1RST_Reset = 0x1
	// Position of I2C4RST field.
	RCC_APB1RSTR2_I2C4RST_Pos = 0x1
	// Bit mask of I2C4RST field.
	RCC_APB1RSTR2_I2C4RST_Msk = 0x2
	// Bit I2C4RST.
	RCC_APB1RSTR2_I2C4RST = 0x2
	// Reset the selected module
	RCC_APB1RSTR2_I2C4RST_Reset = 0x1
	// Position of UCPD1RST field.
	RCC_APB1RSTR2_UCPD1RST_Pos = 0x8
	// Bit mask of UCPD1RST field.
	RCC_APB1RSTR2_UCPD1RST_Msk = 0x100
	// Bit UCPD1RST.
	RCC_APB1RSTR2_UCPD1RST = 0x100
	// Reset the selected module
	RCC_APB1RSTR2_UCPD1RST_Reset = 0x1

	// APB2RSTR: APB2 peripheral reset register
	// Position of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST_Pos = 0x0
	// Bit mask of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST_Msk = 0x1
	// Bit SYSCFGRST.
	RCC_APB2RSTR_SYSCFGRST = 0x1
	// Reset the selected module
	RCC_APB2RSTR_SYSCFGRST_Reset = 0x1
	// Position of TIM1RST field.
	RCC_APB2RSTR_TIM1RST_Pos = 0xb
	// Bit mask of TIM1RST field.
	RCC_APB2RSTR_TIM1RST_Msk = 0x800
	// Bit TIM1RST.
	RCC_APB2RSTR_TIM1RST = 0x800
	// Reset the selected module
	RCC_APB2RSTR_TIM1RST_Reset = 0x1
	// Position of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Pos = 0xc
	// Bit mask of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Msk = 0x1000
	// Bit SPI1RST.
	RCC_APB2RSTR_SPI1RST = 0x1000
	// Reset the selected module
	RCC_APB2RSTR_SPI1RST_Reset = 0x1
	// Position of TIM8RST field.
	RCC_APB2RSTR_TIM8RST_Pos = 0xd
	// Bit mask of TIM8RST field.
	RCC_APB2RSTR_TIM8RST_Msk = 0x2000
	// Bit TIM8RST.
	RCC_APB2RSTR_TIM8RST = 0x2000
	// Reset the selected module
	RCC_APB2RSTR_TIM8RST_Reset = 0x1
	// Position of USART1RST field.
	RCC_APB2RSTR_USART1RST_Pos = 0xe
	// Bit mask of USART1RST field.
	RCC_APB2RSTR_USART1RST_Msk = 0x4000
	// Bit USART1RST.
	RCC_APB2RSTR_USART1RST = 0x4000
	// Reset the selected module
	RCC_APB2RSTR_USART1RST_Reset = 0x1
	// Position of SPI4RST field.
	RCC_APB2RSTR_SPI4RST_Pos = 0xf
	// Bit mask of SPI4RST field.
	RCC_APB2RSTR_SPI4RST_Msk = 0x8000
	// Bit SPI4RST.
	RCC_APB2RSTR_SPI4RST = 0x8000
	// Reset the selected module
	RCC_APB2RSTR_SPI4RST_Reset = 0x1
	// Position of TIM15RST field.
	RCC_APB2RSTR_TIM15RST_Pos = 0x10
	// Bit mask of TIM15RST field.
	RCC_APB2RSTR_TIM15RST_Msk = 0x10000
	// Bit TIM15RST.
	RCC_APB2RSTR_TIM15RST = 0x10000
	// Reset the selected module
	RCC_APB2RSTR_TIM15RST_Reset = 0x1
	// Position of TIM16RST field.
	RCC_APB2RSTR_TIM16RST_Pos = 0x11
	// Bit mask of TIM16RST field.
	RCC_APB2RSTR_TIM16RST_Msk = 0x20000
	// Bit TIM16RST.
	RCC_APB2RSTR_TIM16RST = 0x20000
	// Reset the selected module
	RCC_APB2RSTR_TIM16RST_Reset = 0x1
	// Position of TIM17RST field.
	RCC_APB2RSTR_TIM17RST_Pos = 0x12
	// Bit mask of TIM17RST field.
	RCC_APB2RSTR_TIM17RST_Msk = 0x40000
	// Bit TIM17RST.
	RCC_APB2RSTR_TIM17RST = 0x40000
	// Reset the selected module
	RCC_APB2RSTR_TIM17RST_Reset = 0x1
	// Position of TIM20RST field.
	RCC_APB2RSTR_TIM20RST_Pos = 0x14
	// Bit mask of TIM20RST field.
	RCC_APB2RSTR_TIM20RST_Msk = 0x100000
	// Bit TIM20RST.
	RCC_APB2RSTR_TIM20RST = 0x100000
	// Reset the selected module
	RCC_APB2RSTR_TIM20RST_Reset = 0x1
	// Position of SAI1RST field.
	RCC_APB2RSTR_SAI1RST_Pos = 0x15
	// Bit mask of SAI1RST field.
	RCC_APB2RSTR_SAI1RST_Msk = 0x200000
	// Bit SAI1RST.
	RCC_APB2RSTR_SAI1RST = 0x200000
	// Reset the selected module
	RCC_APB2RSTR_SAI1RST_Reset = 0x1
	// Position of HRTIM1RST field.
	RCC_APB2RSTR_HRTIM1RST_Pos = 0x1a
	// Bit mask of HRTIM1RST field.
	RCC_APB2RSTR_HRTIM1RST_Msk = 0x4000000
	// Bit HRTIM1RST.
	RCC_APB2RSTR_HRTIM1RST = 0x4000000
	// Reset the selected module
	RCC_APB2RSTR_HRTIM1RST_Reset = 0x1

	// AHB1ENR: AHB1 peripheral clock enable register
	// Position of DMA1EN field.
	RCC_AHB1ENR_DMA1EN_Pos = 0x0
	// Bit mask of DMA1EN field.
	RCC_AHB1ENR_DMA1EN_Msk = 0x1
	// Bit DMA1EN.
	RCC_AHB1ENR_DMA1EN = 0x1
	// The selected clock is disabled
	RCC_AHB1ENR_DMA1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_DMA1EN_Enabled = 0x1
	// Position of DMA2EN field.
	RCC_AHB1ENR_DMA2EN_Pos = 0x1
	// Bit mask of DMA2EN field.
	RCC_AHB1ENR_DMA2EN_Msk = 0x2
	// Bit DMA2EN.
	RCC_AHB1ENR_DMA2EN = 0x2
	// The selected clock is disabled
	RCC_AHB1ENR_DMA2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_DMA2EN_Enabled = 0x1
	// Position of DMAMUXEN field.
	RCC_AHB1ENR_DMAMUXEN_Pos = 0x2
	// Bit mask of DMAMUXEN field.
	RCC_AHB1ENR_DMAMUXEN_Msk = 0x4
	// Bit DMAMUXEN.
	RCC_AHB1ENR_DMAMUXEN = 0x4
	// The selected clock is disabled
	RCC_AHB1ENR_DMAMUXEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_DMAMUXEN_Enabled = 0x1
	// Position of CORDICEN field.
	RCC_AHB1ENR_CORDICEN_Pos = 0x3
	// Bit mask of CORDICEN field.
	RCC_AHB1ENR_CORDICEN_Msk = 0x8
	// Bit CORDICEN.
	RCC_AHB1ENR_CORDICEN = 0x8
	// The selected clock is disabled
	RCC_AHB1ENR_CORDICEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_CORDICEN_Enabled = 0x1
	// Position of FMACEN field.
	RCC_AHB1ENR_FMACEN_Pos = 0x4
	// Bit mask of FMACEN field.
	RCC_AHB1ENR_FMACEN_Msk = 0x10
	// Bit FMACEN.
	RCC_AHB1ENR_FMACEN = 0x10
	// The selected clock is disabled
	RCC_AHB1ENR_FMACEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_FMACEN_Enabled = 0x1
	// Position of FLASHEN field.
	RCC_AHB1ENR_FLASHEN_Pos = 0x8
	// Bit mask of FLASHEN field.
	RCC_AHB1ENR_FLASHEN_Msk = 0x100
	// Bit FLASHEN.
	RCC_AHB1ENR_FLASHEN = 0x100
	// The selected clock is disabled
	RCC_AHB1ENR_FLASHEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_FLASHEN_Enabled = 0x1
	// Position of CRCEN field.
	RCC_AHB1ENR_CRCEN_Pos = 0xc
	// Bit mask of CRCEN field.
	RCC_AHB1ENR_CRCEN_Msk = 0x1000
	// Bit CRCEN.
	RCC_AHB1ENR_CRCEN = 0x1000
	// The selected clock is disabled
	RCC_AHB1ENR_CRCEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_CRCEN_Enabled = 0x1

	// AHB2ENR: AHB2 peripheral clock enable register
	// Position of GPIOAEN field.
	RCC_AHB2ENR_GPIOAEN_Pos = 0x0
	// Bit mask of GPIOAEN field.
	RCC_AHB2ENR_GPIOAEN_Msk = 0x1
	// Bit GPIOAEN.
	RCC_AHB2ENR_GPIOAEN = 0x1
	// The selected clock is disabled
	RCC_AHB2ENR_GPIOAEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB2ENR_GPIOAEN_Enabled = 0x1
	// Position of GPIOBEN field.
	RCC_AHB2ENR_GPIOBEN_Pos = 0x1
	// Bit mask of GPIOBEN field.
	RCC_AHB2ENR_GPIOBEN_Msk = 0x2
	// Bit GPIOBEN.
	RCC_AHB2ENR_GPIOBEN = 0x2
	// The selected clock is disabled
	RCC_AHB2ENR_GPIOBEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB2ENR_GPIOBEN_Enabled = 0x1
	// Position of GPIOCEN field.
	RCC_AHB2ENR_GPIOCEN_Pos = 0x2
	// Bit mask of GPIOCEN field.
	RCC_AHB2ENR_GPIOCEN_Msk = 0x4
	// Bit GPIOCEN.
	RCC_AHB2ENR_GPIOCEN = 0x4
	// The selected clock is disabled
	RCC_AHB2ENR_GPIOCEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB2ENR_GPIOCEN_Enabled = 0x1
	// Position of GPIODEN field.
	RCC_AHB2ENR_GPIODEN_Pos = 0x3
	// Bit mask of GPIODEN field.
	RCC_AHB2ENR_GPIODEN_Msk = 0x8
	// Bit GPIODEN.
	RCC_AHB2ENR_GPIODEN = 0x8
	// The selected clock is disabled
	RCC_AHB2ENR_GPIODEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB2ENR_GPIODEN_Enabled = 0x1
	// Position of GPIOEEN field.
	RCC_AHB2ENR_GPIOEEN_Pos = 0x4
	// Bit mask of GPIOEEN field.
	RCC_AHB2ENR_GPIOEEN_Msk = 0x10
	// Bit GPIOEEN.
	RCC_AHB2ENR_GPIOEEN = 0x10
	// The selected clock is disabled
	RCC_AHB2ENR_GPIOEEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB2ENR_GPIOEEN_Enabled = 0x1
	// Position of GPIOFEN field.
	RCC_AHB2ENR_GPIOFEN_Pos = 0x5
	// Bit mask of GPIOFEN field.
	RCC_AHB2ENR_GPIOFEN_Msk = 0x20
	// Bit GPIOFEN.
	RCC_AHB2ENR_GPIOFEN = 0x20
	// The selected clock is disabled
	RCC_AHB2ENR_GPIOFEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB2ENR_GPIOFEN_Enabled = 0x1
	// Position of GPIOGEN field.
	RCC_AHB2ENR_GPIOGEN_Pos = 0x6
	// Bit mask of GPIOGEN field.
	RCC_AHB2ENR_GPIOGEN_Msk = 0x40
	// Bit GPIOGEN.
	RCC_AHB2ENR_GPIOGEN = 0x40
	// The selected clock is disabled
	RCC_AHB2ENR_GPIOGEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB2ENR_GPIOGEN_Enabled = 0x1
	// Position of ADC12EN field.
	RCC_AHB2ENR_ADC12EN_Pos = 0xd
	// Bit mask of ADC12EN field.
	RCC_AHB2ENR_ADC12EN_Msk = 0x2000
	// Bit ADC12EN.
	RCC_AHB2ENR_ADC12EN = 0x2000
	// The selected clock is disabled
	RCC_AHB2ENR_ADC12EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB2ENR_ADC12EN_Enabled = 0x1
	// Position of ADC345EN field.
	RCC_AHB2ENR_ADC345EN_Pos = 0xe
	// Bit mask of ADC345EN field.
	RCC_AHB2ENR_ADC345EN_Msk = 0x4000
	// Bit ADC345EN.
	RCC_AHB2ENR_ADC345EN = 0x4000
	// The selected clock is disabled
	RCC_AHB2ENR_ADC345EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB2ENR_ADC345EN_Enabled = 0x1
	// Position of DAC1EN field.
	RCC_AHB2ENR_DAC1EN_Pos = 0x10
	// Bit mask of DAC1EN field.
	RCC_AHB2ENR_DAC1EN_Msk = 0x10000
	// Bit DAC1EN.
	RCC_AHB2ENR_DAC1EN = 0x10000
	// The selected clock is disabled
	RCC_AHB2ENR_DAC1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB2ENR_DAC1EN_Enabled = 0x1
	// Position of DAC2EN field.
	RCC_AHB2ENR_DAC2EN_Pos = 0x11
	// Bit mask of DAC2EN field.
	RCC_AHB2ENR_DAC2EN_Msk = 0x20000
	// Bit DAC2EN.
	RCC_AHB2ENR_DAC2EN = 0x20000
	// The selected clock is disabled
	RCC_AHB2ENR_DAC2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB2ENR_DAC2EN_Enabled = 0x1
	// Position of DAC3EN field.
	RCC_AHB2ENR_DAC3EN_Pos = 0x12
	// Bit mask of DAC3EN field.
	RCC_AHB2ENR_DAC3EN_Msk = 0x40000
	// Bit DAC3EN.
	RCC_AHB2ENR_DAC3EN = 0x40000
	// The selected clock is disabled
	RCC_AHB2ENR_DAC3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB2ENR_DAC3EN_Enabled = 0x1
	// Position of DAC4EN field.
	RCC_AHB2ENR_DAC4EN_Pos = 0x13
	// Bit mask of DAC4EN field.
	RCC_AHB2ENR_DAC4EN_Msk = 0x80000
	// Bit DAC4EN.
	RCC_AHB2ENR_DAC4EN = 0x80000
	// The selected clock is disabled
	RCC_AHB2ENR_DAC4EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB2ENR_DAC4EN_Enabled = 0x1
	// Position of AESEN field.
	RCC_AHB2ENR_AESEN_Pos = 0x18
	// Bit mask of AESEN field.
	RCC_AHB2ENR_AESEN_Msk = 0x1000000
	// Bit AESEN.
	RCC_AHB2ENR_AESEN = 0x1000000
	// The selected clock is disabled
	RCC_AHB2ENR_AESEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB2ENR_AESEN_Enabled = 0x1
	// Position of RNGEN field.
	RCC_AHB2ENR_RNGEN_Pos = 0x1a
	// Bit mask of RNGEN field.
	RCC_AHB2ENR_RNGEN_Msk = 0x4000000
	// Bit RNGEN.
	RCC_AHB2ENR_RNGEN = 0x4000000
	// The selected clock is disabled
	RCC_AHB2ENR_RNGEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB2ENR_RNGEN_Enabled = 0x1

	// AHB3ENR: AHB3 peripheral clock enable register
	// Position of FMCEN field.
	RCC_AHB3ENR_FMCEN_Pos = 0x0
	// Bit mask of FMCEN field.
	RCC_AHB3ENR_FMCEN_Msk = 0x1
	// Bit FMCEN.
	RCC_AHB3ENR_FMCEN = 0x1
	// The selected clock is disabled
	RCC_AHB3ENR_FMCEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB3ENR_FMCEN_Enabled = 0x1
	// Position of QSPIEN field.
	RCC_AHB3ENR_QSPIEN_Pos = 0x8
	// Bit mask of QSPIEN field.
	RCC_AHB3ENR_QSPIEN_Msk = 0x100
	// Bit QSPIEN.
	RCC_AHB3ENR_QSPIEN = 0x100
	// The selected clock is disabled
	RCC_AHB3ENR_QSPIEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB3ENR_QSPIEN_Enabled = 0x1

	// APB1ENR1: APB1ENR1
	// Position of TIM2EN field.
	RCC_APB1ENR1_TIM2EN_Pos = 0x0
	// Bit mask of TIM2EN field.
	RCC_APB1ENR1_TIM2EN_Msk = 0x1
	// Bit TIM2EN.
	RCC_APB1ENR1_TIM2EN = 0x1
	// The selected clock is disabled
	RCC_APB1ENR1_TIM2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR1_TIM2EN_Enabled = 0x1
	// Position of TIM3EN field.
	RCC_APB1ENR1_TIM3EN_Pos = 0x1
	// Bit mask of TIM3EN field.
	RCC_APB1ENR1_TIM3EN_Msk = 0x2
	// Bit TIM3EN.
	RCC_APB1ENR1_TIM3EN = 0x2
	// The selected clock is disabled
	RCC_APB1ENR1_TIM3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR1_TIM3EN_Enabled = 0x1
	// Position of TIM4EN field.
	RCC_APB1ENR1_TIM4EN_Pos = 0x2
	// Bit mask of TIM4EN field.
	RCC_APB1ENR1_TIM4EN_Msk = 0x4
	// Bit TIM4EN.
	RCC_APB1ENR1_TIM4EN = 0x4
	// The selected clock is disabled
	RCC_APB1ENR1_TIM4EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR1_TIM4EN_Enabled = 0x1
	// Position of TIM5EN field.
	RCC_APB1ENR1_TIM5EN_Pos = 0x3
	// Bit mask of TIM5EN field.
	RCC_APB1ENR1_TIM5EN_Msk = 0x8
	// Bit TIM5EN.
	RCC_APB1ENR1_TIM5EN = 0x8
	// The selected clock is disabled
	RCC_APB1ENR1_TIM5EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR1_TIM5EN_Enabled = 0x1
	// Position of TIM6EN field.
	RCC_APB1ENR1_TIM6EN_Pos = 0x4
	// Bit mask of TIM6EN field.
	RCC_APB1ENR1_TIM6EN_Msk = 0x10
	// Bit TIM6EN.
	RCC_APB1ENR1_TIM6EN = 0x10
	// The selected clock is disabled
	RCC_APB1ENR1_TIM6EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR1_TIM6EN_Enabled = 0x1
	// Position of TIM7EN field.
	RCC_APB1ENR1_TIM7EN_Pos = 0x5
	// Bit mask of TIM7EN field.
	RCC_APB1ENR1_TIM7EN_Msk = 0x20
	// Bit TIM7EN.
	RCC_APB1ENR1_TIM7EN = 0x20
	// The selected clock is disabled
	RCC_APB1ENR1_TIM7EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR1_TIM7EN_Enabled = 0x1
	// Position of CRSEN field.
	RCC_APB1ENR1_CRSEN_Pos = 0x8
	// Bit mask of CRSEN field.
	RCC_APB1ENR1_CRSEN_Msk = 0x100
	// Bit CRSEN.
	RCC_APB1ENR1_CRSEN = 0x100
	// The selected clock is disabled
	RCC_APB1ENR1_CRSEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR1_CRSEN_Enabled = 0x1
	// Position of RTCAPBEN field.
	RCC_APB1ENR1_RTCAPBEN_Pos = 0xa
	// Bit mask of RTCAPBEN field.
	RCC_APB1ENR1_RTCAPBEN_Msk = 0x400
	// Bit RTCAPBEN.
	RCC_APB1ENR1_RTCAPBEN = 0x400
	// The selected clock is disabled
	RCC_APB1ENR1_RTCAPBEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR1_RTCAPBEN_Enabled = 0x1
	// Position of WWDGEN field.
	RCC_APB1ENR1_WWDGEN_Pos = 0xb
	// Bit mask of WWDGEN field.
	RCC_APB1ENR1_WWDGEN_Msk = 0x800
	// Bit WWDGEN.
	RCC_APB1ENR1_WWDGEN = 0x800
	// The selected clock is disabled
	RCC_APB1ENR1_WWDGEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR1_WWDGEN_Enabled = 0x1
	// Position of SPI2EN field.
	RCC_APB1ENR1_SPI2EN_Pos = 0xe
	// Bit mask of SPI2EN field.
	RCC_APB1ENR1_SPI2EN_Msk = 0x4000
	// Bit SPI2EN.
	RCC_APB1ENR1_SPI2EN = 0x4000
	// The selected clock is disabled
	RCC_APB1ENR1_SPI2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR1_SPI2EN_Enabled = 0x1
	// Position of SPI3EN field.
	RCC_APB1ENR1_SPI3EN_Pos = 0xf
	// Bit mask of SPI3EN field.
	RCC_APB1ENR1_SPI3EN_Msk = 0x8000
	// Bit SPI3EN.
	RCC_APB1ENR1_SPI3EN = 0x8000
	// The selected clock is disabled
	RCC_APB1ENR1_SPI3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR1_SPI3EN_Enabled = 0x1
	// Position of USART2EN field.
	RCC_APB1ENR1_USART2EN_Pos = 0x11
	// Bit mask of USART2EN field.
	RCC_APB1ENR1_USART2EN_Msk = 0x20000
	// Bit USART2EN.
	RCC_APB1ENR1_USART2EN = 0x20000
	// The selected clock is disabled
	RCC_APB1ENR1_USART2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR1_USART2EN_Enabled = 0x1
	// Position of USART3EN field.
	RCC_APB1ENR1_USART3EN_Pos = 0x12
	// Bit mask of USART3EN field.
	RCC_APB1ENR1_USART3EN_Msk = 0x40000
	// Bit USART3EN.
	RCC_APB1ENR1_USART3EN = 0x40000
	// The selected clock is disabled
	RCC_APB1ENR1_USART3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR1_USART3EN_Enabled = 0x1
	// Position of UART4EN field.
	RCC_APB1ENR1_UART4EN_Pos = 0x13
	// Bit mask of UART4EN field.
	RCC_APB1ENR1_UART4EN_Msk = 0x80000
	// Bit UART4EN.
	RCC_APB1ENR1_UART4EN = 0x80000
	// The selected clock is disabled
	RCC_APB1ENR1_UART4EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR1_UART4EN_Enabled = 0x1
	// Position of UART5EN field.
	RCC_APB1ENR1_UART5EN_Pos = 0x14
	// Bit mask of UART5EN field.
	RCC_APB1ENR1_UART5EN_Msk = 0x100000
	// Bit UART5EN.
	RCC_APB1ENR1_UART5EN = 0x100000
	// The selected clock is disabled
	RCC_APB1ENR1_UART5EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR1_UART5EN_Enabled = 0x1
	// Position of I2C1EN field.
	RCC_APB1ENR1_I2C1EN_Pos = 0x15
	// Bit mask of I2C1EN field.
	RCC_APB1ENR1_I2C1EN_Msk = 0x200000
	// Bit I2C1EN.
	RCC_APB1ENR1_I2C1EN = 0x200000
	// The selected clock is disabled
	RCC_APB1ENR1_I2C1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR1_I2C1EN_Enabled = 0x1
	// Position of I2C2EN field.
	RCC_APB1ENR1_I2C2EN_Pos = 0x16
	// Bit mask of I2C2EN field.
	RCC_APB1ENR1_I2C2EN_Msk = 0x400000
	// Bit I2C2EN.
	RCC_APB1ENR1_I2C2EN = 0x400000
	// The selected clock is disabled
	RCC_APB1ENR1_I2C2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR1_I2C2EN_Enabled = 0x1
	// Position of USBEN field.
	RCC_APB1ENR1_USBEN_Pos = 0x17
	// Bit mask of USBEN field.
	RCC_APB1ENR1_USBEN_Msk = 0x800000
	// Bit USBEN.
	RCC_APB1ENR1_USBEN = 0x800000
	// The selected clock is disabled
	RCC_APB1ENR1_USBEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR1_USBEN_Enabled = 0x1
	// Position of FDCANEN field.
	RCC_APB1ENR1_FDCANEN_Pos = 0x19
	// Bit mask of FDCANEN field.
	RCC_APB1ENR1_FDCANEN_Msk = 0x2000000
	// Bit FDCANEN.
	RCC_APB1ENR1_FDCANEN = 0x2000000
	// The selected clock is disabled
	RCC_APB1ENR1_FDCANEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR1_FDCANEN_Enabled = 0x1
	// Position of PWREN field.
	RCC_APB1ENR1_PWREN_Pos = 0x1c
	// Bit mask of PWREN field.
	RCC_APB1ENR1_PWREN_Msk = 0x10000000
	// Bit PWREN.
	RCC_APB1ENR1_PWREN = 0x10000000
	// The selected clock is disabled
	RCC_APB1ENR1_PWREN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR1_PWREN_Enabled = 0x1
	// Position of I2C3EN field.
	RCC_APB1ENR1_I2C3EN_Pos = 0x1e
	// Bit mask of I2C3EN field.
	RCC_APB1ENR1_I2C3EN_Msk = 0x40000000
	// Bit I2C3EN.
	RCC_APB1ENR1_I2C3EN = 0x40000000
	// The selected clock is disabled
	RCC_APB1ENR1_I2C3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR1_I2C3EN_Enabled = 0x1
	// Position of LPTIM1EN field.
	RCC_APB1ENR1_LPTIM1EN_Pos = 0x1f
	// Bit mask of LPTIM1EN field.
	RCC_APB1ENR1_LPTIM1EN_Msk = 0x80000000
	// Bit LPTIM1EN.
	RCC_APB1ENR1_LPTIM1EN = 0x80000000
	// The selected clock is disabled
	RCC_APB1ENR1_LPTIM1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR1_LPTIM1EN_Enabled = 0x1

	// APB1ENR2: APB1 peripheral clock enable register 2
	// Position of LPUART1EN field.
	RCC_APB1ENR2_LPUART1EN_Pos = 0x0
	// Bit mask of LPUART1EN field.
	RCC_APB1ENR2_LPUART1EN_Msk = 0x1
	// Bit LPUART1EN.
	RCC_APB1ENR2_LPUART1EN = 0x1
	// The selected clock is disabled
	RCC_APB1ENR2_LPUART1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR2_LPUART1EN_Enabled = 0x1
	// Position of I2C4EN field.
	RCC_APB1ENR2_I2C4EN_Pos = 0x1
	// Bit mask of I2C4EN field.
	RCC_APB1ENR2_I2C4EN_Msk = 0x2
	// Bit I2C4EN.
	RCC_APB1ENR2_I2C4EN = 0x2
	// The selected clock is disabled
	RCC_APB1ENR2_I2C4EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR2_I2C4EN_Enabled = 0x1
	// Position of UCPD1EN field.
	RCC_APB1ENR2_UCPD1EN_Pos = 0x8
	// Bit mask of UCPD1EN field.
	RCC_APB1ENR2_UCPD1EN_Msk = 0x100
	// Bit UCPD1EN.
	RCC_APB1ENR2_UCPD1EN = 0x100
	// The selected clock is disabled
	RCC_APB1ENR2_UCPD1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR2_UCPD1EN_Enabled = 0x1

	// APB2ENR: APB2ENR
	// Position of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN_Pos = 0x0
	// Bit mask of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN_Msk = 0x1
	// Bit SYSCFGEN.
	RCC_APB2ENR_SYSCFGEN = 0x1
	// The selected clock is disabled
	RCC_APB2ENR_SYSCFGEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SYSCFGEN_Enabled = 0x1
	// Position of TIM1EN field.
	RCC_APB2ENR_TIM1EN_Pos = 0xb
	// Bit mask of TIM1EN field.
	RCC_APB2ENR_TIM1EN_Msk = 0x800
	// Bit TIM1EN.
	RCC_APB2ENR_TIM1EN = 0x800
	// The selected clock is disabled
	RCC_APB2ENR_TIM1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM1EN_Enabled = 0x1
	// Position of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Pos = 0xc
	// Bit mask of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Msk = 0x1000
	// Bit SPI1EN.
	RCC_APB2ENR_SPI1EN = 0x1000
	// The selected clock is disabled
	RCC_APB2ENR_SPI1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SPI1EN_Enabled = 0x1
	// Position of TIM8EN field.
	RCC_APB2ENR_TIM8EN_Pos = 0xd
	// Bit mask of TIM8EN field.
	RCC_APB2ENR_TIM8EN_Msk = 0x2000
	// Bit TIM8EN.
	RCC_APB2ENR_TIM8EN = 0x2000
	// The selected clock is disabled
	RCC_APB2ENR_TIM8EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM8EN_Enabled = 0x1
	// Position of USART1EN field.
	RCC_APB2ENR_USART1EN_Pos = 0xe
	// Bit mask of USART1EN field.
	RCC_APB2ENR_USART1EN_Msk = 0x4000
	// Bit USART1EN.
	RCC_APB2ENR_USART1EN = 0x4000
	// The selected clock is disabled
	RCC_APB2ENR_USART1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_USART1EN_Enabled = 0x1
	// Position of SPI4EN field.
	RCC_APB2ENR_SPI4EN_Pos = 0xf
	// Bit mask of SPI4EN field.
	RCC_APB2ENR_SPI4EN_Msk = 0x8000
	// Bit SPI4EN.
	RCC_APB2ENR_SPI4EN = 0x8000
	// The selected clock is disabled
	RCC_APB2ENR_SPI4EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SPI4EN_Enabled = 0x1
	// Position of TIM15EN field.
	RCC_APB2ENR_TIM15EN_Pos = 0x10
	// Bit mask of TIM15EN field.
	RCC_APB2ENR_TIM15EN_Msk = 0x10000
	// Bit TIM15EN.
	RCC_APB2ENR_TIM15EN = 0x10000
	// The selected clock is disabled
	RCC_APB2ENR_TIM15EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM15EN_Enabled = 0x1
	// Position of TIM16EN field.
	RCC_APB2ENR_TIM16EN_Pos = 0x11
	// Bit mask of TIM16EN field.
	RCC_APB2ENR_TIM16EN_Msk = 0x20000
	// Bit TIM16EN.
	RCC_APB2ENR_TIM16EN = 0x20000
	// The selected clock is disabled
	RCC_APB2ENR_TIM16EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM16EN_Enabled = 0x1
	// Position of TIM17EN field.
	RCC_APB2ENR_TIM17EN_Pos = 0x12
	// Bit mask of TIM17EN field.
	RCC_APB2ENR_TIM17EN_Msk = 0x40000
	// Bit TIM17EN.
	RCC_APB2ENR_TIM17EN = 0x40000
	// The selected clock is disabled
	RCC_APB2ENR_TIM17EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM17EN_Enabled = 0x1
	// Position of TIM20EN field.
	RCC_APB2ENR_TIM20EN_Pos = 0x14
	// Bit mask of TIM20EN field.
	RCC_APB2ENR_TIM20EN_Msk = 0x100000
	// Bit TIM20EN.
	RCC_APB2ENR_TIM20EN = 0x100000
	// The selected clock is disabled
	RCC_APB2ENR_TIM20EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM20EN_Enabled = 0x1
	// Position of SAI1EN field.
	RCC_APB2ENR_SAI1EN_Pos = 0x15
	// Bit mask of SAI1EN field.
	RCC_APB2ENR_SAI1EN_Msk = 0x200000
	// Bit SAI1EN.
	RCC_APB2ENR_SAI1EN = 0x200000
	// The selected clock is disabled
	RCC_APB2ENR_SAI1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SAI1EN_Enabled = 0x1
	// Position of HRTIM1EN field.
	RCC_APB2ENR_HRTIM1EN_Pos = 0x1a
	// Bit mask of HRTIM1EN field.
	RCC_APB2ENR_HRTIM1EN_Msk = 0x4000000
	// Bit HRTIM1EN.
	RCC_APB2ENR_HRTIM1EN = 0x4000000
	// The selected clock is disabled
	RCC_APB2ENR_HRTIM1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_HRTIM1EN_Enabled = 0x1

	// AHB1SMENR: AHB1 peripheral clocks enable in Sleep and Stop modes register
	// Position of DMA1SMEN field.
	RCC_AHB1SMENR_DMA1SMEN_Pos = 0x0
	// Bit mask of DMA1SMEN field.
	RCC_AHB1SMENR_DMA1SMEN_Msk = 0x1
	// Bit DMA1SMEN.
	RCC_AHB1SMENR_DMA1SMEN = 0x1
	// Position of DMA2SMEN field.
	RCC_AHB1SMENR_DMA2SMEN_Pos = 0x1
	// Bit mask of DMA2SMEN field.
	RCC_AHB1SMENR_DMA2SMEN_Msk = 0x2
	// Bit DMA2SMEN.
	RCC_AHB1SMENR_DMA2SMEN = 0x2
	// Position of DMAMUX1SMEN field.
	RCC_AHB1SMENR_DMAMUX1SMEN_Pos = 0x2
	// Bit mask of DMAMUX1SMEN field.
	RCC_AHB1SMENR_DMAMUX1SMEN_Msk = 0x4
	// Bit DMAMUX1SMEN.
	RCC_AHB1SMENR_DMAMUX1SMEN = 0x4
	// Position of CORDICSMEN field.
	RCC_AHB1SMENR_CORDICSMEN_Pos = 0x3
	// Bit mask of CORDICSMEN field.
	RCC_AHB1SMENR_CORDICSMEN_Msk = 0x8
	// Bit CORDICSMEN.
	RCC_AHB1SMENR_CORDICSMEN = 0x8
	// Position of FLASHSMEN field.
	RCC_AHB1SMENR_FLASHSMEN_Pos = 0x8
	// Bit mask of FLASHSMEN field.
	RCC_AHB1SMENR_FLASHSMEN_Msk = 0x100
	// Bit FLASHSMEN.
	RCC_AHB1SMENR_FLASHSMEN = 0x100
	// Position of SRAM1SMEN field.
	RCC_AHB1SMENR_SRAM1SMEN_Pos = 0x9
	// Bit mask of SRAM1SMEN field.
	RCC_AHB1SMENR_SRAM1SMEN_Msk = 0x200
	// Bit SRAM1SMEN.
	RCC_AHB1SMENR_SRAM1SMEN = 0x200
	// Position of CRCSMEN field.
	RCC_AHB1SMENR_CRCSMEN_Pos = 0xc
	// Bit mask of CRCSMEN field.
	RCC_AHB1SMENR_CRCSMEN_Msk = 0x1000
	// Bit CRCSMEN.
	RCC_AHB1SMENR_CRCSMEN = 0x1000
	// Position of FMACSMEN field.
	RCC_AHB1SMENR_FMACSMEN_Pos = 0x4
	// Bit mask of FMACSMEN field.
	RCC_AHB1SMENR_FMACSMEN_Msk = 0x10
	// Bit FMACSMEN.
	RCC_AHB1SMENR_FMACSMEN = 0x10

	// AHB2SMENR: AHB2 peripheral clocks enable in Sleep and Stop modes register
	// Position of GPIOASMEN field.
	RCC_AHB2SMENR_GPIOASMEN_Pos = 0x0
	// Bit mask of GPIOASMEN field.
	RCC_AHB2SMENR_GPIOASMEN_Msk = 0x1
	// Bit GPIOASMEN.
	RCC_AHB2SMENR_GPIOASMEN = 0x1
	// Position of GPIOBSMEN field.
	RCC_AHB2SMENR_GPIOBSMEN_Pos = 0x1
	// Bit mask of GPIOBSMEN field.
	RCC_AHB2SMENR_GPIOBSMEN_Msk = 0x2
	// Bit GPIOBSMEN.
	RCC_AHB2SMENR_GPIOBSMEN = 0x2
	// Position of GPIOCSMEN field.
	RCC_AHB2SMENR_GPIOCSMEN_Pos = 0x2
	// Bit mask of GPIOCSMEN field.
	RCC_AHB2SMENR_GPIOCSMEN_Msk = 0x4
	// Bit GPIOCSMEN.
	RCC_AHB2SMENR_GPIOCSMEN = 0x4
	// Position of GPIODSMEN field.
	RCC_AHB2SMENR_GPIODSMEN_Pos = 0x3
	// Bit mask of GPIODSMEN field.
	RCC_AHB2SMENR_GPIODSMEN_Msk = 0x8
	// Bit GPIODSMEN.
	RCC_AHB2SMENR_GPIODSMEN = 0x8
	// Position of GPIOESMEN field.
	RCC_AHB2SMENR_GPIOESMEN_Pos = 0x4
	// Bit mask of GPIOESMEN field.
	RCC_AHB2SMENR_GPIOESMEN_Msk = 0x10
	// Bit GPIOESMEN.
	RCC_AHB2SMENR_GPIOESMEN = 0x10
	// Position of GPIOFSMEN field.
	RCC_AHB2SMENR_GPIOFSMEN_Pos = 0x5
	// Bit mask of GPIOFSMEN field.
	RCC_AHB2SMENR_GPIOFSMEN_Msk = 0x20
	// Bit GPIOFSMEN.
	RCC_AHB2SMENR_GPIOFSMEN = 0x20
	// Position of GPIOGSMEN field.
	RCC_AHB2SMENR_GPIOGSMEN_Pos = 0x6
	// Bit mask of GPIOGSMEN field.
	RCC_AHB2SMENR_GPIOGSMEN_Msk = 0x40
	// Bit GPIOGSMEN.
	RCC_AHB2SMENR_GPIOGSMEN = 0x40
	// Position of ADC12SMEN field.
	RCC_AHB2SMENR_ADC12SMEN_Pos = 0xd
	// Bit mask of ADC12SMEN field.
	RCC_AHB2SMENR_ADC12SMEN_Msk = 0x2000
	// Bit ADC12SMEN.
	RCC_AHB2SMENR_ADC12SMEN = 0x2000
	// Position of ADC345SMEN field.
	RCC_AHB2SMENR_ADC345SMEN_Pos = 0xe
	// Bit mask of ADC345SMEN field.
	RCC_AHB2SMENR_ADC345SMEN_Msk = 0x4000
	// Bit ADC345SMEN.
	RCC_AHB2SMENR_ADC345SMEN = 0x4000
	// Position of DAC1SMEN field.
	RCC_AHB2SMENR_DAC1SMEN_Pos = 0x10
	// Bit mask of DAC1SMEN field.
	RCC_AHB2SMENR_DAC1SMEN_Msk = 0x10000
	// Bit DAC1SMEN.
	RCC_AHB2SMENR_DAC1SMEN = 0x10000
	// Position of DAC2SMEN field.
	RCC_AHB2SMENR_DAC2SMEN_Pos = 0x11
	// Bit mask of DAC2SMEN field.
	RCC_AHB2SMENR_DAC2SMEN_Msk = 0x20000
	// Bit DAC2SMEN.
	RCC_AHB2SMENR_DAC2SMEN = 0x20000
	// Position of DAC3SMEN field.
	RCC_AHB2SMENR_DAC3SMEN_Pos = 0x12
	// Bit mask of DAC3SMEN field.
	RCC_AHB2SMENR_DAC3SMEN_Msk = 0x40000
	// Bit DAC3SMEN.
	RCC_AHB2SMENR_DAC3SMEN = 0x40000
	// Position of DAC4SMEN field.
	RCC_AHB2SMENR_DAC4SMEN_Pos = 0x13
	// Bit mask of DAC4SMEN field.
	RCC_AHB2SMENR_DAC4SMEN_Msk = 0x80000
	// Bit DAC4SMEN.
	RCC_AHB2SMENR_DAC4SMEN = 0x80000
	// Position of AESMEN field.
	RCC_AHB2SMENR_AESMEN_Pos = 0x18
	// Bit mask of AESMEN field.
	RCC_AHB2SMENR_AESMEN_Msk = 0x1000000
	// Bit AESMEN.
	RCC_AHB2SMENR_AESMEN = 0x1000000
	// Position of RNGEN field.
	RCC_AHB2SMENR_RNGEN_Pos = 0x1a
	// Bit mask of RNGEN field.
	RCC_AHB2SMENR_RNGEN_Msk = 0x4000000
	// Bit RNGEN.
	RCC_AHB2SMENR_RNGEN = 0x4000000
	// Position of CCMSRAMSMEN field.
	RCC_AHB2SMENR_CCMSRAMSMEN_Pos = 0x9
	// Bit mask of CCMSRAMSMEN field.
	RCC_AHB2SMENR_CCMSRAMSMEN_Msk = 0x200
	// Bit CCMSRAMSMEN.
	RCC_AHB2SMENR_CCMSRAMSMEN = 0x200
	// Position of SRAM2SMEN field.
	RCC_AHB2SMENR_SRAM2SMEN_Pos = 0xa
	// Bit mask of SRAM2SMEN field.
	RCC_AHB2SMENR_SRAM2SMEN_Msk = 0x400
	// Bit SRAM2SMEN.
	RCC_AHB2SMENR_SRAM2SMEN = 0x400

	// AHB3SMENR: AHB3 peripheral clocks enable in Sleep and Stop modes register
	// Position of FMCSMEN field.
	RCC_AHB3SMENR_FMCSMEN_Pos = 0x0
	// Bit mask of FMCSMEN field.
	RCC_AHB3SMENR_FMCSMEN_Msk = 0x1
	// Bit FMCSMEN.
	RCC_AHB3SMENR_FMCSMEN = 0x1
	// Position of QSPISMEN field.
	RCC_AHB3SMENR_QSPISMEN_Pos = 0x8
	// Bit mask of QSPISMEN field.
	RCC_AHB3SMENR_QSPISMEN_Msk = 0x100
	// Bit QSPISMEN.
	RCC_AHB3SMENR_QSPISMEN = 0x100

	// APB1SMENR1: APB1SMENR1
	// Position of TIM2SMEN field.
	RCC_APB1SMENR1_TIM2SMEN_Pos = 0x0
	// Bit mask of TIM2SMEN field.
	RCC_APB1SMENR1_TIM2SMEN_Msk = 0x1
	// Bit TIM2SMEN.
	RCC_APB1SMENR1_TIM2SMEN = 0x1
	// Position of TIM3SMEN field.
	RCC_APB1SMENR1_TIM3SMEN_Pos = 0x1
	// Bit mask of TIM3SMEN field.
	RCC_APB1SMENR1_TIM3SMEN_Msk = 0x2
	// Bit TIM3SMEN.
	RCC_APB1SMENR1_TIM3SMEN = 0x2
	// Position of TIM4SMEN field.
	RCC_APB1SMENR1_TIM4SMEN_Pos = 0x2
	// Bit mask of TIM4SMEN field.
	RCC_APB1SMENR1_TIM4SMEN_Msk = 0x4
	// Bit TIM4SMEN.
	RCC_APB1SMENR1_TIM4SMEN = 0x4
	// Position of TIM5SMEN field.
	RCC_APB1SMENR1_TIM5SMEN_Pos = 0x3
	// Bit mask of TIM5SMEN field.
	RCC_APB1SMENR1_TIM5SMEN_Msk = 0x8
	// Bit TIM5SMEN.
	RCC_APB1SMENR1_TIM5SMEN = 0x8
	// Position of TIM6SMEN field.
	RCC_APB1SMENR1_TIM6SMEN_Pos = 0x4
	// Bit mask of TIM6SMEN field.
	RCC_APB1SMENR1_TIM6SMEN_Msk = 0x10
	// Bit TIM6SMEN.
	RCC_APB1SMENR1_TIM6SMEN = 0x10
	// Position of TIM7SMEN field.
	RCC_APB1SMENR1_TIM7SMEN_Pos = 0x5
	// Bit mask of TIM7SMEN field.
	RCC_APB1SMENR1_TIM7SMEN_Msk = 0x20
	// Bit TIM7SMEN.
	RCC_APB1SMENR1_TIM7SMEN = 0x20
	// Position of CRSSMEN field.
	RCC_APB1SMENR1_CRSSMEN_Pos = 0x8
	// Bit mask of CRSSMEN field.
	RCC_APB1SMENR1_CRSSMEN_Msk = 0x100
	// Bit CRSSMEN.
	RCC_APB1SMENR1_CRSSMEN = 0x100
	// Position of RTCAPBSMEN field.
	RCC_APB1SMENR1_RTCAPBSMEN_Pos = 0xa
	// Bit mask of RTCAPBSMEN field.
	RCC_APB1SMENR1_RTCAPBSMEN_Msk = 0x400
	// Bit RTCAPBSMEN.
	RCC_APB1SMENR1_RTCAPBSMEN = 0x400
	// Position of WWDGSMEN field.
	RCC_APB1SMENR1_WWDGSMEN_Pos = 0xb
	// Bit mask of WWDGSMEN field.
	RCC_APB1SMENR1_WWDGSMEN_Msk = 0x800
	// Bit WWDGSMEN.
	RCC_APB1SMENR1_WWDGSMEN = 0x800
	// Position of SPI2SMEN field.
	RCC_APB1SMENR1_SPI2SMEN_Pos = 0xe
	// Bit mask of SPI2SMEN field.
	RCC_APB1SMENR1_SPI2SMEN_Msk = 0x4000
	// Bit SPI2SMEN.
	RCC_APB1SMENR1_SPI2SMEN = 0x4000
	// Position of SP3SMEN field.
	RCC_APB1SMENR1_SP3SMEN_Pos = 0xf
	// Bit mask of SP3SMEN field.
	RCC_APB1SMENR1_SP3SMEN_Msk = 0x8000
	// Bit SP3SMEN.
	RCC_APB1SMENR1_SP3SMEN = 0x8000
	// Position of USART2SMEN field.
	RCC_APB1SMENR1_USART2SMEN_Pos = 0x11
	// Bit mask of USART2SMEN field.
	RCC_APB1SMENR1_USART2SMEN_Msk = 0x20000
	// Bit USART2SMEN.
	RCC_APB1SMENR1_USART2SMEN = 0x20000
	// Position of USART3SMEN field.
	RCC_APB1SMENR1_USART3SMEN_Pos = 0x12
	// Bit mask of USART3SMEN field.
	RCC_APB1SMENR1_USART3SMEN_Msk = 0x40000
	// Bit USART3SMEN.
	RCC_APB1SMENR1_USART3SMEN = 0x40000
	// Position of UART4SMEN field.
	RCC_APB1SMENR1_UART4SMEN_Pos = 0x13
	// Bit mask of UART4SMEN field.
	RCC_APB1SMENR1_UART4SMEN_Msk = 0x80000
	// Bit UART4SMEN.
	RCC_APB1SMENR1_UART4SMEN = 0x80000
	// Position of UART5SMEN field.
	RCC_APB1SMENR1_UART5SMEN_Pos = 0x14
	// Bit mask of UART5SMEN field.
	RCC_APB1SMENR1_UART5SMEN_Msk = 0x100000
	// Bit UART5SMEN.
	RCC_APB1SMENR1_UART5SMEN = 0x100000
	// Position of I2C1SMEN field.
	RCC_APB1SMENR1_I2C1SMEN_Pos = 0x15
	// Bit mask of I2C1SMEN field.
	RCC_APB1SMENR1_I2C1SMEN_Msk = 0x200000
	// Bit I2C1SMEN.
	RCC_APB1SMENR1_I2C1SMEN = 0x200000
	// Position of I2C2SMEN field.
	RCC_APB1SMENR1_I2C2SMEN_Pos = 0x16
	// Bit mask of I2C2SMEN field.
	RCC_APB1SMENR1_I2C2SMEN_Msk = 0x400000
	// Bit I2C2SMEN.
	RCC_APB1SMENR1_I2C2SMEN = 0x400000
	// Position of FDCANSMEN field.
	RCC_APB1SMENR1_FDCANSMEN_Pos = 0x19
	// Bit mask of FDCANSMEN field.
	RCC_APB1SMENR1_FDCANSMEN_Msk = 0x2000000
	// Bit FDCANSMEN.
	RCC_APB1SMENR1_FDCANSMEN = 0x2000000
	// Position of PWRSMEN field.
	RCC_APB1SMENR1_PWRSMEN_Pos = 0x1c
	// Bit mask of PWRSMEN field.
	RCC_APB1SMENR1_PWRSMEN_Msk = 0x10000000
	// Bit PWRSMEN.
	RCC_APB1SMENR1_PWRSMEN = 0x10000000
	// Position of LPTIM1SMEN field.
	RCC_APB1SMENR1_LPTIM1SMEN_Pos = 0x1f
	// Bit mask of LPTIM1SMEN field.
	RCC_APB1SMENR1_LPTIM1SMEN_Msk = 0x80000000
	// Bit LPTIM1SMEN.
	RCC_APB1SMENR1_LPTIM1SMEN = 0x80000000
	// Position of USBSMEN field.
	RCC_APB1SMENR1_USBSMEN_Pos = 0x17
	// Bit mask of USBSMEN field.
	RCC_APB1SMENR1_USBSMEN_Msk = 0x800000
	// Bit USBSMEN.
	RCC_APB1SMENR1_USBSMEN = 0x800000
	// Position of I2C3SMEN field.
	RCC_APB1SMENR1_I2C3SMEN_Pos = 0x1e
	// Bit mask of I2C3SMEN field.
	RCC_APB1SMENR1_I2C3SMEN_Msk = 0x40000000
	// Bit I2C3SMEN.
	RCC_APB1SMENR1_I2C3SMEN = 0x40000000

	// APB1SMENR2: APB1 peripheral clocks enable in Sleep and Stop modes register 2
	// Position of LPUART1SMEN field.
	RCC_APB1SMENR2_LPUART1SMEN_Pos = 0x0
	// Bit mask of LPUART1SMEN field.
	RCC_APB1SMENR2_LPUART1SMEN_Msk = 0x1
	// Bit LPUART1SMEN.
	RCC_APB1SMENR2_LPUART1SMEN = 0x1
	// Position of I2C4SMEN field.
	RCC_APB1SMENR2_I2C4SMEN_Pos = 0x1
	// Bit mask of I2C4SMEN field.
	RCC_APB1SMENR2_I2C4SMEN_Msk = 0x2
	// Bit I2C4SMEN.
	RCC_APB1SMENR2_I2C4SMEN = 0x2
	// Position of UCPD1SMEN field.
	RCC_APB1SMENR2_UCPD1SMEN_Pos = 0x8
	// Bit mask of UCPD1SMEN field.
	RCC_APB1SMENR2_UCPD1SMEN_Msk = 0x100
	// Bit UCPD1SMEN.
	RCC_APB1SMENR2_UCPD1SMEN = 0x100

	// APB2SMENR: APB2SMENR
	// Position of SYSCFGSMEN field.
	RCC_APB2SMENR_SYSCFGSMEN_Pos = 0x0
	// Bit mask of SYSCFGSMEN field.
	RCC_APB2SMENR_SYSCFGSMEN_Msk = 0x1
	// Bit SYSCFGSMEN.
	RCC_APB2SMENR_SYSCFGSMEN = 0x1
	// Position of TIM1SMEN field.
	RCC_APB2SMENR_TIM1SMEN_Pos = 0xb
	// Bit mask of TIM1SMEN field.
	RCC_APB2SMENR_TIM1SMEN_Msk = 0x800
	// Bit TIM1SMEN.
	RCC_APB2SMENR_TIM1SMEN = 0x800
	// Position of SPI1SMEN field.
	RCC_APB2SMENR_SPI1SMEN_Pos = 0xc
	// Bit mask of SPI1SMEN field.
	RCC_APB2SMENR_SPI1SMEN_Msk = 0x1000
	// Bit SPI1SMEN.
	RCC_APB2SMENR_SPI1SMEN = 0x1000
	// Position of TIM8SMEN field.
	RCC_APB2SMENR_TIM8SMEN_Pos = 0xd
	// Bit mask of TIM8SMEN field.
	RCC_APB2SMENR_TIM8SMEN_Msk = 0x2000
	// Bit TIM8SMEN.
	RCC_APB2SMENR_TIM8SMEN = 0x2000
	// Position of USART1SMEN field.
	RCC_APB2SMENR_USART1SMEN_Pos = 0xe
	// Bit mask of USART1SMEN field.
	RCC_APB2SMENR_USART1SMEN_Msk = 0x4000
	// Bit USART1SMEN.
	RCC_APB2SMENR_USART1SMEN = 0x4000
	// Position of SPI4SMEN field.
	RCC_APB2SMENR_SPI4SMEN_Pos = 0xf
	// Bit mask of SPI4SMEN field.
	RCC_APB2SMENR_SPI4SMEN_Msk = 0x8000
	// Bit SPI4SMEN.
	RCC_APB2SMENR_SPI4SMEN = 0x8000
	// Position of TIM15SMEN field.
	RCC_APB2SMENR_TIM15SMEN_Pos = 0x10
	// Bit mask of TIM15SMEN field.
	RCC_APB2SMENR_TIM15SMEN_Msk = 0x10000
	// Bit TIM15SMEN.
	RCC_APB2SMENR_TIM15SMEN = 0x10000
	// Position of TIM16SMEN field.
	RCC_APB2SMENR_TIM16SMEN_Pos = 0x11
	// Bit mask of TIM16SMEN field.
	RCC_APB2SMENR_TIM16SMEN_Msk = 0x20000
	// Bit TIM16SMEN.
	RCC_APB2SMENR_TIM16SMEN = 0x20000
	// Position of TIM17SMEN field.
	RCC_APB2SMENR_TIM17SMEN_Pos = 0x12
	// Bit mask of TIM17SMEN field.
	RCC_APB2SMENR_TIM17SMEN_Msk = 0x40000
	// Bit TIM17SMEN.
	RCC_APB2SMENR_TIM17SMEN = 0x40000
	// Position of TIM20SMEN field.
	RCC_APB2SMENR_TIM20SMEN_Pos = 0x14
	// Bit mask of TIM20SMEN field.
	RCC_APB2SMENR_TIM20SMEN_Msk = 0x100000
	// Bit TIM20SMEN.
	RCC_APB2SMENR_TIM20SMEN = 0x100000
	// Position of SAI1SMEN field.
	RCC_APB2SMENR_SAI1SMEN_Pos = 0x15
	// Bit mask of SAI1SMEN field.
	RCC_APB2SMENR_SAI1SMEN_Msk = 0x200000
	// Bit SAI1SMEN.
	RCC_APB2SMENR_SAI1SMEN = 0x200000
	// Position of HRTIM1SMEN field.
	RCC_APB2SMENR_HRTIM1SMEN_Pos = 0x1a
	// Bit mask of HRTIM1SMEN field.
	RCC_APB2SMENR_HRTIM1SMEN_Msk = 0x4000000
	// Bit HRTIM1SMEN.
	RCC_APB2SMENR_HRTIM1SMEN = 0x4000000

	// CCIPR: CCIPR
	// Position of ADC345SEL field.
	RCC_CCIPR_ADC345SEL_Pos = 0x1e
	// Bit mask of ADC345SEL field.
	RCC_CCIPR_ADC345SEL_Msk = 0xc0000000
	// No clock selected for ADC
	RCC_CCIPR_ADC345SEL_None = 0x0
	// PLL 'P' clock selected for ADC
	RCC_CCIPR_ADC345SEL_PLLP = 0x1
	// System clock selected for ADC
	RCC_CCIPR_ADC345SEL_System = 0x2
	// Position of ADC12SEL field.
	RCC_CCIPR_ADC12SEL_Pos = 0x1c
	// Bit mask of ADC12SEL field.
	RCC_CCIPR_ADC12SEL_Msk = 0x30000000
	// No clock selected for ADC
	RCC_CCIPR_ADC12SEL_None = 0x0
	// PLL 'P' clock selected for ADC
	RCC_CCIPR_ADC12SEL_PLLP = 0x1
	// System clock selected for ADC
	RCC_CCIPR_ADC12SEL_System = 0x2
	// Position of CLK48SEL field.
	RCC_CCIPR_CLK48SEL_Pos = 0x1a
	// Bit mask of CLK48SEL field.
	RCC_CCIPR_CLK48SEL_Msk = 0xc000000
	// HSI48 clock selected as 48MHz clock
	RCC_CCIPR_CLK48SEL_HSI48 = 0x0
	// PLL 'Q' (PLL48M1CLK) clock selected as 48MHz clock
	RCC_CCIPR_CLK48SEL_PLLQ = 0x2
	// Position of FDCANSEL field.
	RCC_CCIPR_FDCANSEL_Pos = 0x18
	// Bit mask of FDCANSEL field.
	RCC_CCIPR_FDCANSEL_Msk = 0x3000000
	// HSE clock selected as FDCAN clock
	RCC_CCIPR_FDCANSEL_HSE = 0x0
	// PLL 'Q' clock selected as FDCAN clock
	RCC_CCIPR_FDCANSEL_PLLQ = 0x1
	// PCLK clock selected as FDCAN clock
	RCC_CCIPR_FDCANSEL_PCLK = 0x2
	// Position of I2S23SEL field.
	RCC_CCIPR_I2S23SEL_Pos = 0x16
	// Bit mask of I2S23SEL field.
	RCC_CCIPR_I2S23SEL_Msk = 0xc00000
	// System clock selected as I2S23 clock
	RCC_CCIPR_I2S23SEL_System = 0x0
	// PLL 'Q' clock selected as I2S23 clock
	RCC_CCIPR_I2S23SEL_PLLQ = 0x1
	// Clock provided on I2S_CKIN pin is selected as I2S23 clock
	RCC_CCIPR_I2S23SEL_I2S_CKIN = 0x2
	// HSI16 clock selected as I2S23 clock
	RCC_CCIPR_I2S23SEL_HSI16 = 0x3
	// Position of SAI1SEL field.
	RCC_CCIPR_SAI1SEL_Pos = 0x14
	// Bit mask of SAI1SEL field.
	RCC_CCIPR_SAI1SEL_Msk = 0x300000
	// System clock selected as SAI clock
	RCC_CCIPR_SAI1SEL_System = 0x0
	// PLL 'Q' clock selected as SAI clock
	RCC_CCIPR_SAI1SEL_PLLQ = 0x1
	// Clock provided on I2S_CKIN pin is selected as SAI clock
	RCC_CCIPR_SAI1SEL_I2S_CKIN = 0x2
	// HSI16 clock selected as SAI clock
	RCC_CCIPR_SAI1SEL_HSI16 = 0x3
	// Position of LPTIM1SEL field.
	RCC_CCIPR_LPTIM1SEL_Pos = 0x12
	// Bit mask of LPTIM1SEL field.
	RCC_CCIPR_LPTIM1SEL_Msk = 0xc0000
	// PCLK clock selected as LPTIM1 clock
	RCC_CCIPR_LPTIM1SEL_PCLK = 0x0
	// LSI clock selected as LPTIM1 clock
	RCC_CCIPR_LPTIM1SEL_LSI = 0x1
	// HSI16 clock selected as LPTIM1 clock
	RCC_CCIPR_LPTIM1SEL_HSI16 = 0x2
	// LSE clock selected as LPTIM1 clock
	RCC_CCIPR_LPTIM1SEL_LSE = 0x3
	// Position of I2C3SEL field.
	RCC_CCIPR_I2C3SEL_Pos = 0x10
	// Bit mask of I2C3SEL field.
	RCC_CCIPR_I2C3SEL_Msk = 0x30000
	// PCLK clock selected as I2C clock
	RCC_CCIPR_I2C3SEL_PCLK = 0x0
	// System clock (SYSCLK) selected as I2C clock
	RCC_CCIPR_I2C3SEL_System = 0x1
	// HSI16 clock selected as I2C clock
	RCC_CCIPR_I2C3SEL_HSI16 = 0x2
	// Position of I2C2SEL field.
	RCC_CCIPR_I2C2SEL_Pos = 0xe
	// Bit mask of I2C2SEL field.
	RCC_CCIPR_I2C2SEL_Msk = 0xc000
	// PCLK clock selected as I2C clock
	RCC_CCIPR_I2C2SEL_PCLK = 0x0
	// System clock (SYSCLK) selected as I2C clock
	RCC_CCIPR_I2C2SEL_System = 0x1
	// HSI16 clock selected as I2C clock
	RCC_CCIPR_I2C2SEL_HSI16 = 0x2
	// Position of I2C1SEL field.
	RCC_CCIPR_I2C1SEL_Pos = 0xc
	// Bit mask of I2C1SEL field.
	RCC_CCIPR_I2C1SEL_Msk = 0x3000
	// PCLK clock selected as I2C clock
	RCC_CCIPR_I2C1SEL_PCLK = 0x0
	// System clock (SYSCLK) selected as I2C clock
	RCC_CCIPR_I2C1SEL_System = 0x1
	// HSI16 clock selected as I2C clock
	RCC_CCIPR_I2C1SEL_HSI16 = 0x2
	// Position of LPUART1SEL field.
	RCC_CCIPR_LPUART1SEL_Pos = 0xa
	// Bit mask of LPUART1SEL field.
	RCC_CCIPR_LPUART1SEL_Msk = 0xc00
	// PCLK clock selected as UART clock
	RCC_CCIPR_LPUART1SEL_PCLK = 0x0
	// System clock (SYSCLK) selected as UART clock
	RCC_CCIPR_LPUART1SEL_System = 0x1
	// HSI16 clock selected as UART clock
	RCC_CCIPR_LPUART1SEL_HSI16 = 0x2
	// LSE clock selected as UART clock
	RCC_CCIPR_LPUART1SEL_LSE = 0x3
	// Position of UART5SEL field.
	RCC_CCIPR_UART5SEL_Pos = 0x8
	// Bit mask of UART5SEL field.
	RCC_CCIPR_UART5SEL_Msk = 0x300
	// PCLK clock selected as UART clock
	RCC_CCIPR_UART5SEL_PCLK = 0x0
	// System clock (SYSCLK) selected as UART clock
	RCC_CCIPR_UART5SEL_System = 0x1
	// HSI16 clock selected as UART clock
	RCC_CCIPR_UART5SEL_HSI16 = 0x2
	// LSE clock selected as UART clock
	RCC_CCIPR_UART5SEL_LSE = 0x3
	// Position of UART4SEL field.
	RCC_CCIPR_UART4SEL_Pos = 0x6
	// Bit mask of UART4SEL field.
	RCC_CCIPR_UART4SEL_Msk = 0xc0
	// PCLK clock selected as UART clock
	RCC_CCIPR_UART4SEL_PCLK = 0x0
	// System clock (SYSCLK) selected as UART clock
	RCC_CCIPR_UART4SEL_System = 0x1
	// HSI16 clock selected as UART clock
	RCC_CCIPR_UART4SEL_HSI16 = 0x2
	// LSE clock selected as UART clock
	RCC_CCIPR_UART4SEL_LSE = 0x3
	// Position of USART3SEL field.
	RCC_CCIPR_USART3SEL_Pos = 0x4
	// Bit mask of USART3SEL field.
	RCC_CCIPR_USART3SEL_Msk = 0x30
	// Position of USART2SEL field.
	RCC_CCIPR_USART2SEL_Pos = 0x2
	// Bit mask of USART2SEL field.
	RCC_CCIPR_USART2SEL_Msk = 0xc
	// Position of USART1SEL field.
	RCC_CCIPR_USART1SEL_Pos = 0x0
	// Bit mask of USART1SEL field.
	RCC_CCIPR_USART1SEL_Msk = 0x3

	// BDCR: BDCR
	// Position of LSCOSEL field.
	RCC_BDCR_LSCOSEL_Pos = 0x19
	// Bit mask of LSCOSEL field.
	RCC_BDCR_LSCOSEL_Msk = 0x2000000
	// Bit LSCOSEL.
	RCC_BDCR_LSCOSEL = 0x2000000
	// LSI clock selected
	RCC_BDCR_LSCOSEL_LSI = 0x0
	// LSE clock selected
	RCC_BDCR_LSCOSEL_LSE = 0x1
	// Position of LSCOEN field.
	RCC_BDCR_LSCOEN_Pos = 0x18
	// Bit mask of LSCOEN field.
	RCC_BDCR_LSCOEN_Msk = 0x1000000
	// Bit LSCOEN.
	RCC_BDCR_LSCOEN = 0x1000000
	// LSCO disabled
	RCC_BDCR_LSCOEN_Disabled = 0x0
	// LSCO enabled
	RCC_BDCR_LSCOEN_Enabled = 0x1
	// Position of BDRST field.
	RCC_BDCR_BDRST_Pos = 0x10
	// Bit mask of BDRST field.
	RCC_BDCR_BDRST_Msk = 0x10000
	// Bit BDRST.
	RCC_BDCR_BDRST = 0x10000
	// Reset not activated
	RCC_BDCR_BDRST_Disabled = 0x0
	// Reset the entire RTC domain
	RCC_BDCR_BDRST_Enabled = 0x1
	// Position of RTCEN field.
	RCC_BDCR_RTCEN_Pos = 0xf
	// Bit mask of RTCEN field.
	RCC_BDCR_RTCEN_Msk = 0x8000
	// Bit RTCEN.
	RCC_BDCR_RTCEN = 0x8000
	// RTC clock disabled
	RCC_BDCR_RTCEN_Disabled = 0x0
	// RTC clock enabled
	RCC_BDCR_RTCEN_Enabled = 0x1
	// Position of RTCSEL field.
	RCC_BDCR_RTCSEL_Pos = 0x8
	// Bit mask of RTCSEL field.
	RCC_BDCR_RTCSEL_Msk = 0x300
	// No clock
	RCC_BDCR_RTCSEL_NoClock = 0x0
	// LSE oscillator clock used as RTC clock
	RCC_BDCR_RTCSEL_LSE = 0x1
	// LSI oscillator clock used as RTC clock
	RCC_BDCR_RTCSEL_LSI = 0x2
	// HSE oscillator clock divided by a prescaler used as RTC clock
	RCC_BDCR_RTCSEL_HSE = 0x3
	// Position of LSECSSD field.
	RCC_BDCR_LSECSSD_Pos = 0x6
	// Bit mask of LSECSSD field.
	RCC_BDCR_LSECSSD_Msk = 0x40
	// Bit LSECSSD.
	RCC_BDCR_LSECSSD = 0x40
	// No failure detected on LSE (32 kHz oscillator)
	RCC_BDCR_LSECSSD_NoFailure = 0x0
	// Failure detected on LSE (32 kHz oscillator)
	RCC_BDCR_LSECSSD_Failure = 0x1
	// Position of LSECSSON field.
	RCC_BDCR_LSECSSON_Pos = 0x5
	// Bit mask of LSECSSON field.
	RCC_BDCR_LSECSSON_Msk = 0x20
	// Bit LSECSSON.
	RCC_BDCR_LSECSSON = 0x20
	// CSS on LSE (32 kHz external oscillator) OFF
	RCC_BDCR_LSECSSON_Off = 0x0
	// CSS on LSE (32 kHz external oscillator) ON
	RCC_BDCR_LSECSSON_On = 0x1
	// Position of LSEDRV field.
	RCC_BDCR_LSEDRV_Pos = 0x3
	// Bit mask of LSEDRV field.
	RCC_BDCR_LSEDRV_Msk = 0x18
	// 'Xtal mode' lower driving capability
	RCC_BDCR_LSEDRV_Lower = 0x0
	// 'Xtal mode' medium low driving capability
	RCC_BDCR_LSEDRV_MediumLow = 0x1
	// 'Xtal mode' medium high driving capability
	RCC_BDCR_LSEDRV_MediumHigh = 0x2
	// 'Xtal mode' higher driving capability
	RCC_BDCR_LSEDRV_Higher = 0x3
	// Position of LSEBYP field.
	RCC_BDCR_LSEBYP_Pos = 0x2
	// Bit mask of LSEBYP field.
	RCC_BDCR_LSEBYP_Msk = 0x4
	// Bit LSEBYP.
	RCC_BDCR_LSEBYP = 0x4
	// LSE crystal oscillator not bypassed
	RCC_BDCR_LSEBYP_NotBypassed = 0x0
	// LSE crystal oscillator bypassed with external clock
	RCC_BDCR_LSEBYP_Bypassed = 0x1
	// Position of LSERDY field.
	RCC_BDCR_LSERDY_Pos = 0x1
	// Bit mask of LSERDY field.
	RCC_BDCR_LSERDY_Msk = 0x2
	// Bit LSERDY.
	RCC_BDCR_LSERDY = 0x2
	// LSE clock not ready
	RCC_BDCR_LSERDY_NotReady = 0x0
	// LSE clock ready
	RCC_BDCR_LSERDY_Ready = 0x1
	// Position of LSEON field.
	RCC_BDCR_LSEON_Pos = 0x0
	// Bit mask of LSEON field.
	RCC_BDCR_LSEON_Msk = 0x1
	// Bit LSEON.
	RCC_BDCR_LSEON = 0x1
	// LSE only enabled when requested by a peripheral or system function
	RCC_BDCR_LSEON_Off = 0x0
	// LSE enabled always generated by RCC
	RCC_BDCR_LSEON_On = 0x1

	// CSR: CSR
	// Position of LPWRSTF field.
	RCC_CSR_LPWRSTF_Pos = 0x1f
	// Bit mask of LPWRSTF field.
	RCC_CSR_LPWRSTF_Msk = 0x80000000
	// Bit LPWRSTF.
	RCC_CSR_LPWRSTF = 0x80000000
	// No reset has occured
	RCC_CSR_LPWRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_LPWRSTF_Reset = 0x1
	// Position of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Pos = 0x1e
	// Bit mask of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Msk = 0x40000000
	// Bit WWDGRSTF.
	RCC_CSR_WWDGRSTF = 0x40000000
	// No reset has occured
	RCC_CSR_WWDGRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_WWDGRSTF_Reset = 0x1
	// Position of IWDGRSTF field.
	RCC_CSR_IWDGRSTF_Pos = 0x1d
	// Bit mask of IWDGRSTF field.
	RCC_CSR_IWDGRSTF_Msk = 0x20000000
	// Bit IWDGRSTF.
	RCC_CSR_IWDGRSTF = 0x20000000
	// No reset has occured
	RCC_CSR_IWDGRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_IWDGRSTF_Reset = 0x1
	// Position of SFTRSTF field.
	RCC_CSR_SFTRSTF_Pos = 0x1c
	// Bit mask of SFTRSTF field.
	RCC_CSR_SFTRSTF_Msk = 0x10000000
	// Bit SFTRSTF.
	RCC_CSR_SFTRSTF = 0x10000000
	// No reset has occured
	RCC_CSR_SFTRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_SFTRSTF_Reset = 0x1
	// Position of BORRSTF field.
	RCC_CSR_BORRSTF_Pos = 0x1b
	// Bit mask of BORRSTF field.
	RCC_CSR_BORRSTF_Msk = 0x8000000
	// Bit BORRSTF.
	RCC_CSR_BORRSTF = 0x8000000
	// No reset has occured
	RCC_CSR_BORRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_BORRSTF_Reset = 0x1
	// Position of PINRSTF field.
	RCC_CSR_PINRSTF_Pos = 0x1a
	// Bit mask of PINRSTF field.
	RCC_CSR_PINRSTF_Msk = 0x4000000
	// Bit PINRSTF.
	RCC_CSR_PINRSTF = 0x4000000
	// No reset has occured
	RCC_CSR_PINRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_PINRSTF_Reset = 0x1
	// Position of OBLRSTF field.
	RCC_CSR_OBLRSTF_Pos = 0x19
	// Bit mask of OBLRSTF field.
	RCC_CSR_OBLRSTF_Msk = 0x2000000
	// Bit OBLRSTF.
	RCC_CSR_OBLRSTF = 0x2000000
	// No reset has occured
	RCC_CSR_OBLRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_OBLRSTF_Reset = 0x1
	// Position of RMVF field.
	RCC_CSR_RMVF_Pos = 0x17
	// Bit mask of RMVF field.
	RCC_CSR_RMVF_Msk = 0x800000
	// Bit RMVF.
	RCC_CSR_RMVF = 0x800000
	// Clears the reset flag
	RCC_CSR_RMVF_Clear = 0x1
	// Position of LSIRDY field.
	RCC_CSR_LSIRDY_Pos = 0x1
	// Bit mask of LSIRDY field.
	RCC_CSR_LSIRDY_Msk = 0x2
	// Bit LSIRDY.
	RCC_CSR_LSIRDY = 0x2
	// LSI oscillator not ready
	RCC_CSR_LSIRDY_NotReady = 0x0
	// LSI oscillator ready
	RCC_CSR_LSIRDY_Ready = 0x1
	// Position of LSION field.
	RCC_CSR_LSION_Pos = 0x0
	// Bit mask of LSION field.
	RCC_CSR_LSION_Msk = 0x1
	// Bit LSION.
	RCC_CSR_LSION = 0x1
	// LSI oscillator Off
	RCC_CSR_LSION_Off = 0x0
	// LSI oscillator On
	RCC_CSR_LSION_On = 0x1

	// CRRCR: Clock recovery RC register
	// Position of HSI48ON field.
	RCC_CRRCR_HSI48ON_Pos = 0x0
	// Bit mask of HSI48ON field.
	RCC_CRRCR_HSI48ON_Msk = 0x1
	// Bit HSI48ON.
	RCC_CRRCR_HSI48ON = 0x1
	// Position of HSI48RDY field.
	RCC_CRRCR_HSI48RDY_Pos = 0x1
	// Bit mask of HSI48RDY field.
	RCC_CRRCR_HSI48RDY_Msk = 0x2
	// Bit HSI48RDY.
	RCC_CRRCR_HSI48RDY = 0x2
	// Position of HSI48CAL field.
	RCC_CRRCR_HSI48CAL_Pos = 0x7
	// Bit mask of HSI48CAL field.
	RCC_CRRCR_HSI48CAL_Msk = 0xff80

	// CCIPR2: Peripherals independent clock configuration register
	// Position of I2C4SEL field.
	RCC_CCIPR2_I2C4SEL_Pos = 0x0
	// Bit mask of I2C4SEL field.
	RCC_CCIPR2_I2C4SEL_Msk = 0x3
	// PCLK clock selected as I2C clock
	RCC_CCIPR2_I2C4SEL_PCLK = 0x0
	// System clock (SYSCLK) selected as I2C clock
	RCC_CCIPR2_I2C4SEL_System = 0x1
	// HSI16 clock selected as I2C clock
	RCC_CCIPR2_I2C4SEL_HSI16 = 0x2
	// Position of QSPISEL field.
	RCC_CCIPR2_QSPISEL_Pos = 0x14
	// Bit mask of QSPISEL field.
	RCC_CCIPR2_QSPISEL_Msk = 0x300000
	// System clock selected as QUADSPI kernel clock
	RCC_CCIPR2_QSPISEL_System = 0x0
	// HSI16 clock selected as QUADSPI kernel clock
	RCC_CCIPR2_QSPISEL_HSI16 = 0x1
	// PLL 'Q' clock selected as QUADSPI kernel clock
	RCC_CCIPR2_QSPISEL_PLLQ = 0x2
)

// Constants for PWR: Power control
const (
	// CR1: Power control register 1
	// Position of LPR field.
	PWR_CR1_LPR_Pos = 0xe
	// Bit mask of LPR field.
	PWR_CR1_LPR_Msk = 0x4000
	// Bit LPR.
	PWR_CR1_LPR = 0x4000
	// Position of VOS field.
	PWR_CR1_VOS_Pos = 0x9
	// Bit mask of VOS field.
	PWR_CR1_VOS_Msk = 0x600
	// Position of DBP field.
	PWR_CR1_DBP_Pos = 0x8
	// Bit mask of DBP field.
	PWR_CR1_DBP_Msk = 0x100
	// Bit DBP.
	PWR_CR1_DBP = 0x100
	// Position of LPMS field.
	PWR_CR1_LPMS_Pos = 0x0
	// Bit mask of LPMS field.
	PWR_CR1_LPMS_Msk = 0x7

	// CR2: Power control register 2
	// Position of PVMEN1 field.
	PWR_CR2_PVMEN1_Pos = 0x4
	// Bit mask of PVMEN1 field.
	PWR_CR2_PVMEN1_Msk = 0x10
	// Bit PVMEN1.
	PWR_CR2_PVMEN1 = 0x10
	// Position of PLS field.
	PWR_CR2_PLS_Pos = 0x1
	// Bit mask of PLS field.
	PWR_CR2_PLS_Msk = 0xe
	// Position of PVDE field.
	PWR_CR2_PVDE_Pos = 0x0
	// Bit mask of PVDE field.
	PWR_CR2_PVDE_Msk = 0x1
	// Bit PVDE.
	PWR_CR2_PVDE = 0x1
	// Position of PVMEN2 field.
	PWR_CR2_PVMEN2_Pos = 0x5
	// Bit mask of PVMEN2 field.
	PWR_CR2_PVMEN2_Msk = 0x20
	// Bit PVMEN2.
	PWR_CR2_PVMEN2 = 0x20
	// Position of PVMEN3 field.
	PWR_CR2_PVMEN3_Pos = 0x6
	// Bit mask of PVMEN3 field.
	PWR_CR2_PVMEN3_Msk = 0x40
	// Bit PVMEN3.
	PWR_CR2_PVMEN3 = 0x40
	// Position of PVMEN4 field.
	PWR_CR2_PVMEN4_Pos = 0x7
	// Bit mask of PVMEN4 field.
	PWR_CR2_PVMEN4_Msk = 0x80
	// Bit PVMEN4.
	PWR_CR2_PVMEN4 = 0x80

	// CR3: Power control register 3
	// Position of EWUP1 field.
	PWR_CR3_EWUP1_Pos = 0x0
	// Bit mask of EWUP1 field.
	PWR_CR3_EWUP1_Msk = 0x1
	// Bit EWUP1.
	PWR_CR3_EWUP1 = 0x1
	// Position of EWUP2 field.
	PWR_CR3_EWUP2_Pos = 0x1
	// Bit mask of EWUP2 field.
	PWR_CR3_EWUP2_Msk = 0x2
	// Bit EWUP2.
	PWR_CR3_EWUP2 = 0x2
	// Position of EWUP3 field.
	PWR_CR3_EWUP3_Pos = 0x2
	// Bit mask of EWUP3 field.
	PWR_CR3_EWUP3_Msk = 0x4
	// Bit EWUP3.
	PWR_CR3_EWUP3 = 0x4
	// Position of EWUP4 field.
	PWR_CR3_EWUP4_Pos = 0x3
	// Bit mask of EWUP4 field.
	PWR_CR3_EWUP4_Msk = 0x8
	// Bit EWUP4.
	PWR_CR3_EWUP4 = 0x8
	// Position of EWUP5 field.
	PWR_CR3_EWUP5_Pos = 0x4
	// Bit mask of EWUP5 field.
	PWR_CR3_EWUP5_Msk = 0x10
	// Bit EWUP5.
	PWR_CR3_EWUP5 = 0x10
	// Position of RRS field.
	PWR_CR3_RRS_Pos = 0x8
	// Bit mask of RRS field.
	PWR_CR3_RRS_Msk = 0x100
	// Bit RRS.
	PWR_CR3_RRS = 0x100
	// Position of APC field.
	PWR_CR3_APC_Pos = 0xa
	// Bit mask of APC field.
	PWR_CR3_APC_Msk = 0x400
	// Bit APC.
	PWR_CR3_APC = 0x400
	// Position of UCPD1_STDBY field.
	PWR_CR3_UCPD1_STDBY_Pos = 0xd
	// Bit mask of UCPD1_STDBY field.
	PWR_CR3_UCPD1_STDBY_Msk = 0x2000
	// Bit UCPD1_STDBY.
	PWR_CR3_UCPD1_STDBY = 0x2000
	// Position of UCPD1_DBDIS field.
	PWR_CR3_UCPD1_DBDIS_Pos = 0xe
	// Bit mask of UCPD1_DBDIS field.
	PWR_CR3_UCPD1_DBDIS_Msk = 0x4000
	// Bit UCPD1_DBDIS.
	PWR_CR3_UCPD1_DBDIS = 0x4000
	// Position of EIWUL field.
	PWR_CR3_EIWUL_Pos = 0xf
	// Bit mask of EIWUL field.
	PWR_CR3_EIWUL_Msk = 0x8000
	// Bit EIWUL.
	PWR_CR3_EIWUL = 0x8000

	// CR4: Power control register 4
	// Position of VBRS field.
	PWR_CR4_VBRS_Pos = 0x9
	// Bit mask of VBRS field.
	PWR_CR4_VBRS_Msk = 0x200
	// Bit VBRS.
	PWR_CR4_VBRS = 0x200
	// Position of VBE field.
	PWR_CR4_VBE_Pos = 0x8
	// Bit mask of VBE field.
	PWR_CR4_VBE_Msk = 0x100
	// Bit VBE.
	PWR_CR4_VBE = 0x100
	// Position of WP5 field.
	PWR_CR4_WP5_Pos = 0x4
	// Bit mask of WP5 field.
	PWR_CR4_WP5_Msk = 0x10
	// Bit WP5.
	PWR_CR4_WP5 = 0x10
	// Position of WP4 field.
	PWR_CR4_WP4_Pos = 0x3
	// Bit mask of WP4 field.
	PWR_CR4_WP4_Msk = 0x8
	// Bit WP4.
	PWR_CR4_WP4 = 0x8
	// Position of WP3 field.
	PWR_CR4_WP3_Pos = 0x2
	// Bit mask of WP3 field.
	PWR_CR4_WP3_Msk = 0x4
	// Bit WP3.
	PWR_CR4_WP3 = 0x4
	// Position of WP2 field.
	PWR_CR4_WP2_Pos = 0x1
	// Bit mask of WP2 field.
	PWR_CR4_WP2_Msk = 0x2
	// Bit WP2.
	PWR_CR4_WP2 = 0x2
	// Position of WP1 field.
	PWR_CR4_WP1_Pos = 0x0
	// Bit mask of WP1 field.
	PWR_CR4_WP1_Msk = 0x1
	// Bit WP1.
	PWR_CR4_WP1 = 0x1

	// SR1: Power status register 1
	// Position of WUFI field.
	PWR_SR1_WUFI_Pos = 0xf
	// Bit mask of WUFI field.
	PWR_SR1_WUFI_Msk = 0x8000
	// Bit WUFI.
	PWR_SR1_WUFI = 0x8000
	// Position of SBF field.
	PWR_SR1_SBF_Pos = 0x8
	// Bit mask of SBF field.
	PWR_SR1_SBF_Msk = 0x100
	// Bit SBF.
	PWR_SR1_SBF = 0x100
	// Position of WUF5 field.
	PWR_SR1_WUF5_Pos = 0x4
	// Bit mask of WUF5 field.
	PWR_SR1_WUF5_Msk = 0x10
	// Bit WUF5.
	PWR_SR1_WUF5 = 0x10
	// Position of WUF4 field.
	PWR_SR1_WUF4_Pos = 0x3
	// Bit mask of WUF4 field.
	PWR_SR1_WUF4_Msk = 0x8
	// Bit WUF4.
	PWR_SR1_WUF4 = 0x8
	// Position of WUF3 field.
	PWR_SR1_WUF3_Pos = 0x2
	// Bit mask of WUF3 field.
	PWR_SR1_WUF3_Msk = 0x4
	// Bit WUF3.
	PWR_SR1_WUF3 = 0x4
	// Position of WUF2 field.
	PWR_SR1_WUF2_Pos = 0x1
	// Bit mask of WUF2 field.
	PWR_SR1_WUF2_Msk = 0x2
	// Bit WUF2.
	PWR_SR1_WUF2 = 0x2
	// Position of WUF1 field.
	PWR_SR1_WUF1_Pos = 0x0
	// Bit mask of WUF1 field.
	PWR_SR1_WUF1_Msk = 0x1
	// Bit WUF1.
	PWR_SR1_WUF1 = 0x1

	// SR2: Power status register 2
	// Position of PVMO4 field.
	PWR_SR2_PVMO4_Pos = 0xf
	// Bit mask of PVMO4 field.
	PWR_SR2_PVMO4_Msk = 0x8000
	// Bit PVMO4.
	PWR_SR2_PVMO4 = 0x8000
	// Position of PVMO3 field.
	PWR_SR2_PVMO3_Pos = 0xe
	// Bit mask of PVMO3 field.
	PWR_SR2_PVMO3_Msk = 0x4000
	// Bit PVMO3.
	PWR_SR2_PVMO3 = 0x4000
	// Position of PVMO2 field.
	PWR_SR2_PVMO2_Pos = 0xd
	// Bit mask of PVMO2 field.
	PWR_SR2_PVMO2_Msk = 0x2000
	// Bit PVMO2.
	PWR_SR2_PVMO2 = 0x2000
	// Position of PVMO1 field.
	PWR_SR2_PVMO1_Pos = 0xc
	// Bit mask of PVMO1 field.
	PWR_SR2_PVMO1_Msk = 0x1000
	// Bit PVMO1.
	PWR_SR2_PVMO1 = 0x1000
	// Position of PVDO field.
	PWR_SR2_PVDO_Pos = 0xb
	// Bit mask of PVDO field.
	PWR_SR2_PVDO_Msk = 0x800
	// Bit PVDO.
	PWR_SR2_PVDO = 0x800
	// Position of VOSF field.
	PWR_SR2_VOSF_Pos = 0xa
	// Bit mask of VOSF field.
	PWR_SR2_VOSF_Msk = 0x400
	// Bit VOSF.
	PWR_SR2_VOSF = 0x400
	// Position of REGLPF field.
	PWR_SR2_REGLPF_Pos = 0x9
	// Bit mask of REGLPF field.
	PWR_SR2_REGLPF_Msk = 0x200
	// Bit REGLPF.
	PWR_SR2_REGLPF = 0x200
	// Position of REGLPS field.
	PWR_SR2_REGLPS_Pos = 0x8
	// Bit mask of REGLPS field.
	PWR_SR2_REGLPS_Msk = 0x100
	// Bit REGLPS.
	PWR_SR2_REGLPS = 0x100

	// SCR: Power status clear register
	// Position of CSBF field.
	PWR_SCR_CSBF_Pos = 0x8
	// Bit mask of CSBF field.
	PWR_SCR_CSBF_Msk = 0x100
	// Bit CSBF.
	PWR_SCR_CSBF = 0x100
	// Position of CWUF5 field.
	PWR_SCR_CWUF5_Pos = 0x4
	// Bit mask of CWUF5 field.
	PWR_SCR_CWUF5_Msk = 0x10
	// Bit CWUF5.
	PWR_SCR_CWUF5 = 0x10
	// Position of CWUF4 field.
	PWR_SCR_CWUF4_Pos = 0x3
	// Bit mask of CWUF4 field.
	PWR_SCR_CWUF4_Msk = 0x8
	// Bit CWUF4.
	PWR_SCR_CWUF4 = 0x8
	// Position of CWUF3 field.
	PWR_SCR_CWUF3_Pos = 0x2
	// Bit mask of CWUF3 field.
	PWR_SCR_CWUF3_Msk = 0x4
	// Bit CWUF3.
	PWR_SCR_CWUF3 = 0x4
	// Position of CWUF2 field.
	PWR_SCR_CWUF2_Pos = 0x1
	// Bit mask of CWUF2 field.
	PWR_SCR_CWUF2_Msk = 0x2
	// Bit CWUF2.
	PWR_SCR_CWUF2 = 0x2
	// Position of CWUF1 field.
	PWR_SCR_CWUF1_Pos = 0x0
	// Bit mask of CWUF1 field.
	PWR_SCR_CWUF1_Msk = 0x1
	// Bit CWUF1.
	PWR_SCR_CWUF1 = 0x1

	// PUCRA: Power Port A pull-up control register
	// Position of PU15 field.
	PWR_PUCRA_PU15_Pos = 0xf
	// Bit mask of PU15 field.
	PWR_PUCRA_PU15_Msk = 0x8000
	// Bit PU15.
	PWR_PUCRA_PU15 = 0x8000
	// Position of PU13 field.
	PWR_PUCRA_PU13_Pos = 0xd
	// Bit mask of PU13 field.
	PWR_PUCRA_PU13_Msk = 0x2000
	// Bit PU13.
	PWR_PUCRA_PU13 = 0x2000
	// Position of PU12 field.
	PWR_PUCRA_PU12_Pos = 0xc
	// Bit mask of PU12 field.
	PWR_PUCRA_PU12_Msk = 0x1000
	// Bit PU12.
	PWR_PUCRA_PU12 = 0x1000
	// Position of PU11 field.
	PWR_PUCRA_PU11_Pos = 0xb
	// Bit mask of PU11 field.
	PWR_PUCRA_PU11_Msk = 0x800
	// Bit PU11.
	PWR_PUCRA_PU11 = 0x800
	// Position of PU10 field.
	PWR_PUCRA_PU10_Pos = 0xa
	// Bit mask of PU10 field.
	PWR_PUCRA_PU10_Msk = 0x400
	// Bit PU10.
	PWR_PUCRA_PU10 = 0x400
	// Position of PU9 field.
	PWR_PUCRA_PU9_Pos = 0x9
	// Bit mask of PU9 field.
	PWR_PUCRA_PU9_Msk = 0x200
	// Bit PU9.
	PWR_PUCRA_PU9 = 0x200
	// Position of PU8 field.
	PWR_PUCRA_PU8_Pos = 0x8
	// Bit mask of PU8 field.
	PWR_PUCRA_PU8_Msk = 0x100
	// Bit PU8.
	PWR_PUCRA_PU8 = 0x100
	// Position of PU7 field.
	PWR_PUCRA_PU7_Pos = 0x7
	// Bit mask of PU7 field.
	PWR_PUCRA_PU7_Msk = 0x80
	// Bit PU7.
	PWR_PUCRA_PU7 = 0x80
	// Position of PU6 field.
	PWR_PUCRA_PU6_Pos = 0x6
	// Bit mask of PU6 field.
	PWR_PUCRA_PU6_Msk = 0x40
	// Bit PU6.
	PWR_PUCRA_PU6 = 0x40
	// Position of PU5 field.
	PWR_PUCRA_PU5_Pos = 0x5
	// Bit mask of PU5 field.
	PWR_PUCRA_PU5_Msk = 0x20
	// Bit PU5.
	PWR_PUCRA_PU5 = 0x20
	// Position of PU4 field.
	PWR_PUCRA_PU4_Pos = 0x4
	// Bit mask of PU4 field.
	PWR_PUCRA_PU4_Msk = 0x10
	// Bit PU4.
	PWR_PUCRA_PU4 = 0x10
	// Position of PU3 field.
	PWR_PUCRA_PU3_Pos = 0x3
	// Bit mask of PU3 field.
	PWR_PUCRA_PU3_Msk = 0x8
	// Bit PU3.
	PWR_PUCRA_PU3 = 0x8
	// Position of PU2 field.
	PWR_PUCRA_PU2_Pos = 0x2
	// Bit mask of PU2 field.
	PWR_PUCRA_PU2_Msk = 0x4
	// Bit PU2.
	PWR_PUCRA_PU2 = 0x4
	// Position of PU1 field.
	PWR_PUCRA_PU1_Pos = 0x1
	// Bit mask of PU1 field.
	PWR_PUCRA_PU1_Msk = 0x2
	// Bit PU1.
	PWR_PUCRA_PU1 = 0x2
	// Position of PU0 field.
	PWR_PUCRA_PU0_Pos = 0x0
	// Bit mask of PU0 field.
	PWR_PUCRA_PU0_Msk = 0x1
	// Bit PU0.
	PWR_PUCRA_PU0 = 0x1

	// PDCRA: Power Port A pull-down control register
	// Position of PD14 field.
	PWR_PDCRA_PD14_Pos = 0xe
	// Bit mask of PD14 field.
	PWR_PDCRA_PD14_Msk = 0x4000
	// Bit PD14.
	PWR_PDCRA_PD14 = 0x4000
	// Position of PD12 field.
	PWR_PDCRA_PD12_Pos = 0xc
	// Bit mask of PD12 field.
	PWR_PDCRA_PD12_Msk = 0x1000
	// Bit PD12.
	PWR_PDCRA_PD12 = 0x1000
	// Position of PD11 field.
	PWR_PDCRA_PD11_Pos = 0xb
	// Bit mask of PD11 field.
	PWR_PDCRA_PD11_Msk = 0x800
	// Bit PD11.
	PWR_PDCRA_PD11 = 0x800
	// Position of PD10 field.
	PWR_PDCRA_PD10_Pos = 0xa
	// Bit mask of PD10 field.
	PWR_PDCRA_PD10_Msk = 0x400
	// Bit PD10.
	PWR_PDCRA_PD10 = 0x400
	// Position of PD9 field.
	PWR_PDCRA_PD9_Pos = 0x9
	// Bit mask of PD9 field.
	PWR_PDCRA_PD9_Msk = 0x200
	// Bit PD9.
	PWR_PDCRA_PD9 = 0x200
	// Position of PD8 field.
	PWR_PDCRA_PD8_Pos = 0x8
	// Bit mask of PD8 field.
	PWR_PDCRA_PD8_Msk = 0x100
	// Bit PD8.
	PWR_PDCRA_PD8 = 0x100
	// Position of PD7 field.
	PWR_PDCRA_PD7_Pos = 0x7
	// Bit mask of PD7 field.
	PWR_PDCRA_PD7_Msk = 0x80
	// Bit PD7.
	PWR_PDCRA_PD7 = 0x80
	// Position of PD6 field.
	PWR_PDCRA_PD6_Pos = 0x6
	// Bit mask of PD6 field.
	PWR_PDCRA_PD6_Msk = 0x40
	// Bit PD6.
	PWR_PDCRA_PD6 = 0x40
	// Position of PD5 field.
	PWR_PDCRA_PD5_Pos = 0x5
	// Bit mask of PD5 field.
	PWR_PDCRA_PD5_Msk = 0x20
	// Bit PD5.
	PWR_PDCRA_PD5 = 0x20
	// Position of PD4 field.
	PWR_PDCRA_PD4_Pos = 0x4
	// Bit mask of PD4 field.
	PWR_PDCRA_PD4_Msk = 0x10
	// Bit PD4.
	PWR_PDCRA_PD4 = 0x10
	// Position of PD3 field.
	PWR_PDCRA_PD3_Pos = 0x3
	// Bit mask of PD3 field.
	PWR_PDCRA_PD3_Msk = 0x8
	// Bit PD3.
	PWR_PDCRA_PD3 = 0x8
	// Position of PD2 field.
	PWR_PDCRA_PD2_Pos = 0x2
	// Bit mask of PD2 field.
	PWR_PDCRA_PD2_Msk = 0x4
	// Bit PD2.
	PWR_PDCRA_PD2 = 0x4
	// Position of PD1 field.
	PWR_PDCRA_PD1_Pos = 0x1
	// Bit mask of PD1 field.
	PWR_PDCRA_PD1_Msk = 0x2
	// Bit PD1.
	PWR_PDCRA_PD1 = 0x2
	// Position of PD0 field.
	PWR_PDCRA_PD0_Pos = 0x0
	// Bit mask of PD0 field.
	PWR_PDCRA_PD0_Msk = 0x1
	// Bit PD0.
	PWR_PDCRA_PD0 = 0x1

	// PUCRB: Power Port B pull-up control register
	// Position of PU15 field.
	PWR_PUCRB_PU15_Pos = 0xf
	// Bit mask of PU15 field.
	PWR_PUCRB_PU15_Msk = 0x8000
	// Bit PU15.
	PWR_PUCRB_PU15 = 0x8000
	// Position of PU14 field.
	PWR_PUCRB_PU14_Pos = 0xe
	// Bit mask of PU14 field.
	PWR_PUCRB_PU14_Msk = 0x4000
	// Bit PU14.
	PWR_PUCRB_PU14 = 0x4000
	// Position of PU13 field.
	PWR_PUCRB_PU13_Pos = 0xd
	// Bit mask of PU13 field.
	PWR_PUCRB_PU13_Msk = 0x2000
	// Bit PU13.
	PWR_PUCRB_PU13 = 0x2000
	// Position of PU12 field.
	PWR_PUCRB_PU12_Pos = 0xc
	// Bit mask of PU12 field.
	PWR_PUCRB_PU12_Msk = 0x1000
	// Bit PU12.
	PWR_PUCRB_PU12 = 0x1000
	// Position of PU11 field.
	PWR_PUCRB_PU11_Pos = 0xb
	// Bit mask of PU11 field.
	PWR_PUCRB_PU11_Msk = 0x800
	// Bit PU11.
	PWR_PUCRB_PU11 = 0x800
	// Position of PU10 field.
	PWR_PUCRB_PU10_Pos = 0xa
	// Bit mask of PU10 field.
	PWR_PUCRB_PU10_Msk = 0x400
	// Bit PU10.
	PWR_PUCRB_PU10 = 0x400
	// Position of PU9 field.
	PWR_PUCRB_PU9_Pos = 0x9
	// Bit mask of PU9 field.
	PWR_PUCRB_PU9_Msk = 0x200
	// Bit PU9.
	PWR_PUCRB_PU9 = 0x200
	// Position of PU8 field.
	PWR_PUCRB_PU8_Pos = 0x8
	// Bit mask of PU8 field.
	PWR_PUCRB_PU8_Msk = 0x100
	// Bit PU8.
	PWR_PUCRB_PU8 = 0x100
	// Position of PU7 field.
	PWR_PUCRB_PU7_Pos = 0x7
	// Bit mask of PU7 field.
	PWR_PUCRB_PU7_Msk = 0x80
	// Bit PU7.
	PWR_PUCRB_PU7 = 0x80
	// Position of PU6 field.
	PWR_PUCRB_PU6_Pos = 0x6
	// Bit mask of PU6 field.
	PWR_PUCRB_PU6_Msk = 0x40
	// Bit PU6.
	PWR_PUCRB_PU6 = 0x40
	// Position of PU5 field.
	PWR_PUCRB_PU5_Pos = 0x5
	// Bit mask of PU5 field.
	PWR_PUCRB_PU5_Msk = 0x20
	// Bit PU5.
	PWR_PUCRB_PU5 = 0x20
	// Position of PU4 field.
	PWR_PUCRB_PU4_Pos = 0x4
	// Bit mask of PU4 field.
	PWR_PUCRB_PU4_Msk = 0x10
	// Bit PU4.
	PWR_PUCRB_PU4 = 0x10
	// Position of PU3 field.
	PWR_PUCRB_PU3_Pos = 0x3
	// Bit mask of PU3 field.
	PWR_PUCRB_PU3_Msk = 0x8
	// Bit PU3.
	PWR_PUCRB_PU3 = 0x8
	// Position of PU2 field.
	PWR_PUCRB_PU2_Pos = 0x2
	// Bit mask of PU2 field.
	PWR_PUCRB_PU2_Msk = 0x4
	// Bit PU2.
	PWR_PUCRB_PU2 = 0x4
	// Position of PU1 field.
	PWR_PUCRB_PU1_Pos = 0x1
	// Bit mask of PU1 field.
	PWR_PUCRB_PU1_Msk = 0x2
	// Bit PU1.
	PWR_PUCRB_PU1 = 0x2
	// Position of PU0 field.
	PWR_PUCRB_PU0_Pos = 0x0
	// Bit mask of PU0 field.
	PWR_PUCRB_PU0_Msk = 0x1
	// Bit PU0.
	PWR_PUCRB_PU0 = 0x1

	// PDCRB: Power Port B pull-down control register
	// Position of PD15 field.
	PWR_PDCRB_PD15_Pos = 0xf
	// Bit mask of PD15 field.
	PWR_PDCRB_PD15_Msk = 0x8000
	// Bit PD15.
	PWR_PDCRB_PD15 = 0x8000
	// Position of PD14 field.
	PWR_PDCRB_PD14_Pos = 0xe
	// Bit mask of PD14 field.
	PWR_PDCRB_PD14_Msk = 0x4000
	// Bit PD14.
	PWR_PDCRB_PD14 = 0x4000
	// Position of PD13 field.
	PWR_PDCRB_PD13_Pos = 0xd
	// Bit mask of PD13 field.
	PWR_PDCRB_PD13_Msk = 0x2000
	// Bit PD13.
	PWR_PDCRB_PD13 = 0x2000
	// Position of PD12 field.
	PWR_PDCRB_PD12_Pos = 0xc
	// Bit mask of PD12 field.
	PWR_PDCRB_PD12_Msk = 0x1000
	// Bit PD12.
	PWR_PDCRB_PD12 = 0x1000
	// Position of PD11 field.
	PWR_PDCRB_PD11_Pos = 0xb
	// Bit mask of PD11 field.
	PWR_PDCRB_PD11_Msk = 0x800
	// Bit PD11.
	PWR_PDCRB_PD11 = 0x800
	// Position of PD10 field.
	PWR_PDCRB_PD10_Pos = 0xa
	// Bit mask of PD10 field.
	PWR_PDCRB_PD10_Msk = 0x400
	// Bit PD10.
	PWR_PDCRB_PD10 = 0x400
	// Position of PD9 field.
	PWR_PDCRB_PD9_Pos = 0x9
	// Bit mask of PD9 field.
	PWR_PDCRB_PD9_Msk = 0x200
	// Bit PD9.
	PWR_PDCRB_PD9 = 0x200
	// Position of PD8 field.
	PWR_PDCRB_PD8_Pos = 0x8
	// Bit mask of PD8 field.
	PWR_PDCRB_PD8_Msk = 0x100
	// Bit PD8.
	PWR_PDCRB_PD8 = 0x100
	// Position of PD7 field.
	PWR_PDCRB_PD7_Pos = 0x7
	// Bit mask of PD7 field.
	PWR_PDCRB_PD7_Msk = 0x80
	// Bit PD7.
	PWR_PDCRB_PD7 = 0x80
	// Position of PD6 field.
	PWR_PDCRB_PD6_Pos = 0x6
	// Bit mask of PD6 field.
	PWR_PDCRB_PD6_Msk = 0x40
	// Bit PD6.
	PWR_PDCRB_PD6 = 0x40
	// Position of PD5 field.
	PWR_PDCRB_PD5_Pos = 0x5
	// Bit mask of PD5 field.
	PWR_PDCRB_PD5_Msk = 0x20
	// Bit PD5.
	PWR_PDCRB_PD5 = 0x20
	// Position of PD3 field.
	PWR_PDCRB_PD3_Pos = 0x3
	// Bit mask of PD3 field.
	PWR_PDCRB_PD3_Msk = 0x8
	// Bit PD3.
	PWR_PDCRB_PD3 = 0x8
	// Position of PD2 field.
	PWR_PDCRB_PD2_Pos = 0x2
	// Bit mask of PD2 field.
	PWR_PDCRB_PD2_Msk = 0x4
	// Bit PD2.
	PWR_PDCRB_PD2 = 0x4
	// Position of PD1 field.
	PWR_PDCRB_PD1_Pos = 0x1
	// Bit mask of PD1 field.
	PWR_PDCRB_PD1_Msk = 0x2
	// Bit PD1.
	PWR_PDCRB_PD1 = 0x2
	// Position of PD0 field.
	PWR_PDCRB_PD0_Pos = 0x0
	// Bit mask of PD0 field.
	PWR_PDCRB_PD0_Msk = 0x1
	// Bit PD0.
	PWR_PDCRB_PD0 = 0x1

	// PUCRC: Power Port C pull-up control register
	// Position of PU15 field.
	PWR_PUCRC_PU15_Pos = 0xf
	// Bit mask of PU15 field.
	PWR_PUCRC_PU15_Msk = 0x8000
	// Bit PU15.
	PWR_PUCRC_PU15 = 0x8000
	// Position of PU14 field.
	PWR_PUCRC_PU14_Pos = 0xe
	// Bit mask of PU14 field.
	PWR_PUCRC_PU14_Msk = 0x4000
	// Bit PU14.
	PWR_PUCRC_PU14 = 0x4000
	// Position of PU13 field.
	PWR_PUCRC_PU13_Pos = 0xd
	// Bit mask of PU13 field.
	PWR_PUCRC_PU13_Msk = 0x2000
	// Bit PU13.
	PWR_PUCRC_PU13 = 0x2000
	// Position of PU12 field.
	PWR_PUCRC_PU12_Pos = 0xc
	// Bit mask of PU12 field.
	PWR_PUCRC_PU12_Msk = 0x1000
	// Bit PU12.
	PWR_PUCRC_PU12 = 0x1000
	// Position of PU11 field.
	PWR_PUCRC_PU11_Pos = 0xb
	// Bit mask of PU11 field.
	PWR_PUCRC_PU11_Msk = 0x800
	// Bit PU11.
	PWR_PUCRC_PU11 = 0x800
	// Position of PU10 field.
	PWR_PUCRC_PU10_Pos = 0xa
	// Bit mask of PU10 field.
	PWR_PUCRC_PU10_Msk = 0x400
	// Bit PU10.
	PWR_PUCRC_PU10 = 0x400
	// Position of PU9 field.
	PWR_PUCRC_PU9_Pos = 0x9
	// Bit mask of PU9 field.
	PWR_PUCRC_PU9_Msk = 0x200
	// Bit PU9.
	PWR_PUCRC_PU9 = 0x200
	// Position of PU8 field.
	PWR_PUCRC_PU8_Pos = 0x8
	// Bit mask of PU8 field