/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.MenuItemLayoutHelper;
import sun.swing.StringUIClientPropertyKey;
import sun.swing.plaf.synth.SynthIcon;

class SynthMenuItemLayoutHelper
extends MenuItemLayoutHelper {
    public static final StringUIClientPropertyKey MAX_ACC_OR_ARROW_WIDTH = new StringUIClientPropertyKey("maxAccOrArrowWidth");
    public static final MenuItemLayoutHelper.ColumnAlignment LTR_ALIGNMENT_1 = new MenuItemLayoutHelper.ColumnAlignment(2, 2, 2, 4, 4);
    public static final MenuItemLayoutHelper.ColumnAlignment LTR_ALIGNMENT_2 = new MenuItemLayoutHelper.ColumnAlignment(2, 2, 2, 2, 4);
    public static final MenuItemLayoutHelper.ColumnAlignment RTL_ALIGNMENT_1 = new MenuItemLayoutHelper.ColumnAlignment(4, 4, 4, 2, 2);
    public static final MenuItemLayoutHelper.ColumnAlignment RTL_ALIGNMENT_2 = new MenuItemLayoutHelper.ColumnAlignment(4, 4, 4, 4, 2);
    private SynthContext context;
    private SynthContext accContext;
    private SynthStyle style;
    private SynthStyle accStyle;
    private SynthGraphicsUtils gu;
    private SynthGraphicsUtils accGu;
    private boolean alignAcceleratorText;
    private int maxAccOrArrowWidth;

    public SynthMenuItemLayoutHelper(SynthContext context, SynthContext accContext, JMenuItem mi, Icon checkIcon, Icon arrowIcon, Rectangle viewRect, int gap, String accDelimiter, boolean isLeftToRight, boolean useCheckAndArrow, String propertyPrefix) {
        this.context = context;
        this.accContext = accContext;
        this.style = context.getStyle();
        this.accStyle = accContext.getStyle();
        this.gu = this.style.getGraphicsUtils(context);
        this.accGu = this.accStyle.getGraphicsUtils(accContext);
        this.alignAcceleratorText = this.getAlignAcceleratorText(propertyPrefix);
        this.reset(mi, checkIcon, arrowIcon, viewRect, gap, accDelimiter, isLeftToRight, this.style.getFont(context), this.accStyle.getFont(accContext), useCheckAndArrow, propertyPrefix);
        this.setLeadingGap(0);
    }

    private boolean getAlignAcceleratorText(String propertyPrefix) {
        return this.style.getBoolean(this.context, propertyPrefix + ".alignAcceleratorText", true);
    }

    @Override
    protected void calcWidthsAndHeights() {
        if (this.getIcon() != null) {
            this.getIconSize().setWidth(SynthIcon.getIconWidth(this.getIcon(), this.context));
            this.getIconSize().setHeight(SynthIcon.getIconHeight(this.getIcon(), this.context));
        }
        if (!this.getAccText().equals("")) {
            this.getAccSize().setWidth(this.accGu.computeStringWidth(this.getAccContext(), this.getAccFontMetrics().getFont(), this.getAccFontMetrics(), this.getAccText()));
            this.getAccSize().setHeight(this.getAccFontMetrics().getHeight());
        }
        if (this.getText() == null) {
            this.setText("");
        } else if (!this.getText().equals("")) {
            if (this.getHtmlView() != null) {
                this.getTextSize().setWidth((int)this.getHtmlView().getPreferredSpan(0));
                this.getTextSize().setHeight((int)this.getHtmlView().getPreferredSpan(1));
            } else {
                this.getTextSize().setWidth(this.gu.computeStringWidth(this.context, this.getFontMetrics().getFont(), this.getFontMetrics(), this.getText()));
                this.getTextSize().setHeight(this.getFontMetrics().getHeight());
            }
        }
        if (this.useCheckAndArrow()) {
            if (this.getCheckIcon() != null) {
                this.getCheckSize().setWidth(SynthIcon.getIconWidth(this.getCheckIcon(), this.context));
                this.getCheckSize().setHeight(SynthIcon.getIconHeight(this.getCheckIcon(), this.context));
            }
            if (this.getArrowIcon() != null) {
                this.getArrowSize().setWidth(SynthIcon.getIconWidth(this.getArrowIcon(), this.context));
                this.getArrowSize().setHeight(SynthIcon.getIconHeight(this.getArrowIcon(), this.context));
            }
        }
        if (this.isColumnLayout()) {
            this.getLabelSize().setWidth(this.getIconSize().getWidth() + this.getTextSize().getWidth() + this.getGap());
            this.getLabelSize().setHeight(MenuItemLayoutHelper.max(this.getCheckSize().getHeight(), this.getIconSize().getHeight(), this.getTextSize().getHeight(), this.getAccSize().getHeight(), this.getArrowSize().getHeight()));
        } else {
            Rectangle textRect = new Rectangle();
            Rectangle iconRect = new Rectangle();
            this.gu.layoutText(this.context, this.getFontMetrics(), this.getText(), this.getIcon(), this.getHorizontalAlignment(), this.getVerticalAlignment(), this.getHorizontalTextPosition(), this.getVerticalTextPosition(), this.getViewRect(), iconRect, textRect, this.getGap());
            textRect.width += this.getLeftTextExtraWidth();
            Rectangle labelRect = iconRect.union(textRect);
            this.getLabelSize().setHeight(labelRect.height);
            this.getLabelSize().setWidth(labelRect.width);
        }
    }

    @Override
    protected void calcMaxWidths() {
        this.calcMaxWidth(this.getCheckSize(), MAX_CHECK_WIDTH);
        this.maxAccOrArrowWidth = this.calcMaxValue(MAX_ACC_OR_ARROW_WIDTH, this.getArrowSize().getWidth());
        this.maxAccOrArrowWidth = this.calcMaxValue(MAX_ACC_OR_ARROW_WIDTH, this.getAccSize().getWidth());
        if (this.isColumnLayout()) {
            this.calcMaxWidth(this.getIconSize(), MAX_ICON_WIDTH);
            this.calcMaxWidth(this.getTextSize(), MAX_TEXT_WIDTH);
            int curGap = this.getGap();
            if (this.getIconSize().getMaxWidth() == 0 || this.getTextSize().getMaxWidth() == 0) {
                curGap = 0;
            }
            this.getLabelSize().setMaxWidth(this.calcMaxValue(MAX_LABEL_WIDTH, this.getIconSize().getMaxWidth() + this.getTextSize().getMaxWidth() + curGap));
        } else {
            this.getIconSize().setMaxWidth(this.getParentIntProperty(MAX_ICON_WIDTH));
            this.calcMaxWidth(this.getLabelSize(), MAX_LABEL_WIDTH);
            int candidateTextWidth = this.getLabelSize().getMaxWidth() - this.getIconSize().getMaxWidth();
            if (this.getIconSize().getMaxWidth() > 0) {
                candidateTextWidth -= this.getGap();
            }
            this.getTextSize().setMaxWidth(this.calcMaxValue(MAX_TEXT_WIDTH, candidateTextWidth));
        }
    }

    public SynthContext getContext() {
        return this.context;
    }

    public SynthContext getAccContext() {
        return this.accContext;
    }

    public SynthStyle getStyle() {
        return this.style;
    }

    public SynthStyle getAccStyle() {
        return this.accStyle;
    }

    public SynthGraphicsUtils getGraphicsUtils() {
        return this.gu;
    }

    public SynthGraphicsUtils getAccGraphicsUtils() {
        return this.accGu;
    }

    public boolean alignAcceleratorText() {
        return this.alignAcceleratorText;
    }

    public int getMaxAccOrArrowWidth() {
        return this.maxAccOrArrowWidth;
    }

    @Override
    protected void prepareForLayout(MenuItemLayoutHelper.LayoutResult lr) {
        lr.getCheckRect().width = this.getCheckSize().getMaxWidth();
        if (this.useCheckAndArrow() && !"".equals(this.getAccText())) {
            lr.getAccRect().width = this.maxAccOrArrowWidth;
        } else {
            lr.getArrowRect().width = this.maxAccOrArrowWidth;
        }
    }

    @Override
    public MenuItemLayoutHelper.ColumnAlignment getLTRColumnAlignment() {
        if (this.alignAcceleratorText()) {
            return LTR_ALIGNMENT_2;
        }
        return LTR_ALIGNMENT_1;
    }

    @Override
    public MenuItemLayoutHelper.ColumnAlignment getRTLColumnAlignment() {
        if (this.alignAcceleratorText()) {
            return RTL_ALIGNMENT_2;
        }
        return RTL_ALIGNMENT_1;
    }

    @Override
    protected void layoutIconAndTextInLabelRect(MenuItemLayoutHelper.LayoutResult lr) {
        lr.setTextRect(new Rectangle());
        lr.setIconRect(new Rectangle());
        this.gu.layoutText(this.context, this.getFontMetrics(), this.getText(), this.getIcon(), this.getHorizontalAlignment(), this.getVerticalAlignment(), this.getHorizontalTextPosition(), this.getVerticalTextPosition(), lr.getLabelRect(), lr.getIconRect(), lr.getTextRect(), this.getGap());
    }
}

