/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.palm;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.openoffice.xmerge.converter.palm.PalmDB;
import org.openoffice.xmerge.converter.palm.PdbHeader;
import org.openoffice.xmerge.converter.palm.Record;

public final class PdbDecoder {
    public PalmDB parse(byte[] b) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        DataInputStream dis = new DataInputStream(bais);
        PdbHeader header = new PdbHeader();
        header.read(dis);
        Record[] recArray = new Record[header.numRecords];
        if (header.numRecords != 0) {
            int nBytesToSkip;
            int[] recOffset = new int[header.numRecords];
            byte[] recAttrs = new byte[header.numRecords];
            for (int i = 0; i < header.numRecords; ++i) {
                recOffset[i] = dis.readInt();
                int attr = dis.readInt();
                recAttrs[i] = (byte)(attr >>> 24);
            }
            int lastIndex = header.numRecords - 1;
            for (int i = 0; i < lastIndex; ++i) {
                dis.reset();
                nBytesToSkip = recOffset[i];
                while (nBytesToSkip > 0) {
                    nBytesToSkip = (int)((long)nBytesToSkip - dis.skip(nBytesToSkip));
                }
                int len = recOffset[i + 1] - recOffset[i];
                byte[] bytes = new byte[len];
                dis.readFully(bytes);
                recArray[i] = new Record(bytes, recAttrs[i]);
            }
            dis.reset();
            int len = dis.available() - recOffset[lastIndex];
            nBytesToSkip = recOffset[lastIndex];
            while (nBytesToSkip > 0) {
                nBytesToSkip = (int)((long)nBytesToSkip - dis.skip(nBytesToSkip));
            }
            byte[] bytes = new byte[len];
            dis.readFully(bytes);
            recArray[lastIndex] = new Record(bytes, recAttrs[lastIndex]);
        }
        PalmDB pdb = new PalmDB(header.pdbName, header.creatorID, header.typeID, header.version, header.attribute, recArray);
        return pdb;
    }
}

