/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.ArrayList;
import java.util.List;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.SmapInput;

public class SmapStratum {
    private final List<String> fileNameList = new ArrayList<String>();
    private final List<String> filePathList = new ArrayList<String>();
    private final List<LineInfo> lineData = new ArrayList<LineInfo>();
    private int lastFileID;
    private String outputFileName;
    private String classFileName;

    public void addFile(String string) {
        this.addFile(string, string);
    }

    public void addFile(String string, String string2) {
        int n = this.filePathList.indexOf(string2);
        if (n == -1) {
            this.fileNameList.add(string);
            this.filePathList.add(string2);
        }
    }

    public void optimizeLineSection() {
        LineInfo lineInfo;
        LineInfo lineInfo2;
        int n = 0;
        while (n < this.lineData.size() - 1) {
            lineInfo2 = this.lineData.get(n);
            lineInfo = this.lineData.get(n + 1);
            if (!lineInfo.lineFileIDSet && lineInfo.inputStartLine == lineInfo2.inputStartLine && lineInfo.inputLineCount == 1 && lineInfo2.inputLineCount == 1 && lineInfo.outputStartLine == lineInfo2.outputStartLine + lineInfo2.inputLineCount * lineInfo2.outputLineIncrement) {
                lineInfo2.setOutputLineIncrement(lineInfo.outputStartLine - lineInfo2.outputStartLine + lineInfo.outputLineIncrement);
                this.lineData.remove(n + 1);
                continue;
            }
            ++n;
        }
        n = 0;
        while (n < this.lineData.size() - 1) {
            lineInfo2 = this.lineData.get(n);
            lineInfo = this.lineData.get(n + 1);
            if (!lineInfo.lineFileIDSet && lineInfo.inputStartLine == lineInfo2.inputStartLine + lineInfo2.inputLineCount && lineInfo.outputLineIncrement == lineInfo2.outputLineIncrement && lineInfo.outputStartLine == lineInfo2.outputStartLine + lineInfo2.inputLineCount * lineInfo2.outputLineIncrement) {
                lineInfo2.setInputLineCount(lineInfo2.inputLineCount + lineInfo.inputLineCount);
                this.lineData.remove(n + 1);
                continue;
            }
            ++n;
        }
    }

    public void addLineData(int n, String string, int n2, int n3, int n4) {
        int n5 = this.filePathList.indexOf(string);
        if (n5 == -1) {
            throw new IllegalArgumentException("inputFileName: " + string);
        }
        if (n3 == 0) {
            return;
        }
        LineInfo lineInfo = new LineInfo();
        lineInfo.setInputStartLine(n);
        lineInfo.setInputLineCount(n2);
        lineInfo.setOutputStartLine(n3);
        lineInfo.setOutputLineIncrement(n4);
        if (n5 != this.lastFileID) {
            lineInfo.setLineFileID(n5);
        }
        this.lastFileID = n5;
        this.lineData.add(lineInfo);
    }

    public void addLineInfo(LineInfo lineInfo) {
        this.lineData.add(lineInfo);
    }

    public void setOutputFileName(String string) {
        this.outputFileName = string;
    }

    public void setClassFileName(String string) {
        this.classFileName = string;
    }

    public String getClassFileName() {
        return this.classFileName;
    }

    public String toString() {
        return this.getSmapStringInternal();
    }

    public String getSmapString() {
        if (this.outputFileName == null) {
            throw new IllegalStateException();
        }
        return this.getSmapStringInternal();
    }

    private String getSmapStringInternal() {
        Object object;
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SMAP\n");
        stringBuilder.append(this.outputFileName + "\n");
        stringBuilder.append("JSP\n");
        stringBuilder.append("*S JSP\n");
        stringBuilder.append("*F\n");
        int n2 = this.fileNameList.size();
        for (n = 0; n < n2; ++n) {
            if (this.filePathList.get(n) != null) {
                stringBuilder.append("+ " + n + " " + this.fileNameList.get(n) + "\n");
                object = this.filePathList.get(n);
                if (((String)object).startsWith("/")) {
                    object = ((String)object).substring(1);
                }
                stringBuilder.append((String)object + "\n");
                continue;
            }
            stringBuilder.append(n + " " + this.fileNameList.get(n) + "\n");
        }
        stringBuilder.append("*L\n");
        n2 = this.lineData.size();
        for (n = 0; n < n2; ++n) {
            object = this.lineData.get(n);
            stringBuilder.append(((LineInfo)object).getString());
        }
        stringBuilder.append("*E\n");
        return stringBuilder.toString();
    }

    public SmapInput getInputLineNumber(int n) {
        int n2 = -1;
        int n3 = 0;
        for (LineInfo lineInfo : this.lineData) {
            if (lineInfo.lineFileIDSet) {
                n3 = lineInfo.lineFileID;
            }
            if (lineInfo.outputStartLine > n) break;
            if (lineInfo.getMaxOutputLineNumber() < n) continue;
            int n4 = (n - lineInfo.outputStartLine) / lineInfo.outputLineIncrement;
            n2 = lineInfo.inputStartLine + n4;
        }
        return new SmapInput(this.filePathList.get(n3), n2);
    }

    static class LineInfo {
        private int inputStartLine = -1;
        private int outputStartLine = -1;
        private int lineFileID = 0;
        private int inputLineCount = 1;
        private int outputLineIncrement = 1;
        private boolean lineFileIDSet = false;

        LineInfo() {
        }

        public void setInputStartLine(int n) {
            if (n < 0) {
                throw new IllegalArgumentException(Localizer.getMessage("jsp.error.negativeParameter", n));
            }
            this.inputStartLine = n;
        }

        public void setOutputStartLine(int n) {
            if (n < 0) {
                throw new IllegalArgumentException(Localizer.getMessage("jsp.error.negativeParameter", n));
            }
            this.outputStartLine = n;
        }

        public void setLineFileID(int n) {
            if (n < 0) {
                throw new IllegalArgumentException(Localizer.getMessage("jsp.error.negativeParameter", n));
            }
            this.lineFileID = n;
            this.lineFileIDSet = true;
        }

        public void setInputLineCount(int n) {
            if (n < 0) {
                throw new IllegalArgumentException(Localizer.getMessage("jsp.error.negativeParameter", n));
            }
            this.inputLineCount = n;
        }

        public void setOutputLineIncrement(int n) {
            if (n < 0) {
                throw new IllegalArgumentException(Localizer.getMessage("jsp.error.negativeParameter", n));
            }
            this.outputLineIncrement = n;
        }

        public int getMaxOutputLineNumber() {
            return this.outputStartLine + this.inputLineCount * this.outputLineIncrement;
        }

        public String getString() {
            if (this.inputStartLine == -1 || this.outputStartLine == -1) {
                throw new IllegalStateException();
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.inputStartLine);
            if (this.lineFileIDSet) {
                stringBuilder.append("#" + this.lineFileID);
            }
            if (this.inputLineCount != 1) {
                stringBuilder.append("," + this.inputLineCount);
            }
            stringBuilder.append(":" + this.outputStartLine);
            if (this.outputLineIncrement != 1) {
                stringBuilder.append("," + this.outputLineIncrement);
            }
            stringBuilder.append('\n');
            return stringBuilder.toString();
        }

        public String toString() {
            return this.getString();
        }
    }
}

