/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.BeanNameELResolver;
import javax.el.BeanNameResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.PropertyNotWritableException;
import javax.el.ResourceBundleELResolver;
import javax.el.StaticFieldELResolver;
import javax.el.ValueExpression;
import javax.el.VariableMapper;

public class StandardELContext
extends ELContext {
    private final ELContext wrappedContext;
    private final VariableMapper variableMapper;
    private final FunctionMapper functionMapper;
    private final CompositeELResolver standardResolver;
    private final CompositeELResolver customResolvers;
    private final Map<String, Object> localBeans = new HashMap<String, Object>();

    public StandardELContext(ExpressionFactory expressionFactory) {
        this.wrappedContext = null;
        this.variableMapper = new StandardVariableMapper();
        this.functionMapper = new StandardFunctionMapper(expressionFactory.getInitFunctionMap());
        this.standardResolver = new CompositeELResolver();
        this.customResolvers = new CompositeELResolver();
        ELResolver eLResolver = expressionFactory.getStreamELResolver();
        this.standardResolver.add(new BeanNameELResolver(new StandardBeanNameResolver(this.localBeans)));
        this.standardResolver.add(this.customResolvers);
        if (eLResolver != null) {
            this.standardResolver.add(eLResolver);
        }
        this.standardResolver.add(new StaticFieldELResolver());
        this.standardResolver.add(new MapELResolver());
        this.standardResolver.add(new ResourceBundleELResolver());
        this.standardResolver.add(new ListELResolver());
        this.standardResolver.add(new ArrayELResolver());
        this.standardResolver.add(new BeanELResolver());
    }

    public StandardELContext(ELContext eLContext) {
        this.wrappedContext = eLContext;
        this.variableMapper = eLContext.getVariableMapper();
        this.functionMapper = eLContext.getFunctionMapper();
        this.standardResolver = new CompositeELResolver();
        this.customResolvers = new CompositeELResolver();
        this.standardResolver.add(new BeanNameELResolver(new StandardBeanNameResolver(this.localBeans)));
        this.standardResolver.add(this.customResolvers);
        this.standardResolver.add(eLContext.getELResolver());
    }

    @Override
    public void putContext(Class clazz, Object object) {
        if (this.wrappedContext == null) {
            super.putContext(clazz, object);
        } else {
            this.wrappedContext.putContext(clazz, object);
        }
    }

    @Override
    public Object getContext(Class clazz) {
        if (this.wrappedContext == null) {
            return super.getContext(clazz);
        }
        return this.wrappedContext.getContext(clazz);
    }

    @Override
    public ELResolver getELResolver() {
        return this.standardResolver;
    }

    public void addELResolver(ELResolver eLResolver) {
        this.customResolvers.add(eLResolver);
    }

    @Override
    public FunctionMapper getFunctionMapper() {
        return this.functionMapper;
    }

    @Override
    public VariableMapper getVariableMapper() {
        return this.variableMapper;
    }

    Map<String, Object> getLocalBeans() {
        return this.localBeans;
    }

    private static class StandardFunctionMapper
    extends FunctionMapper {
        private final Map<String, Method> methods = new HashMap<String, Method>();

        public StandardFunctionMapper(Map<String, Method> map) {
            if (map != null) {
                this.methods.putAll(map);
            }
        }

        @Override
        public Method resolveFunction(String string, String string2) {
            String string3 = string + ':' + string2;
            return this.methods.get(string3);
        }

        @Override
        public void mapFunction(String string, String string2, Method method) {
            String string3 = string + ':' + string2;
            if (method == null) {
                this.methods.remove(string3);
            } else {
                this.methods.put(string3, method);
            }
        }
    }

    private static class StandardBeanNameResolver
    extends BeanNameResolver {
        private final Map<String, Object> beans;

        public StandardBeanNameResolver(Map<String, Object> map) {
            this.beans = map;
        }

        @Override
        public boolean isNameResolved(String string) {
            return this.beans.containsKey(string);
        }

        @Override
        public Object getBean(String string) {
            return this.beans.get(string);
        }

        @Override
        public void setBeanValue(String string, Object object) throws PropertyNotWritableException {
            this.beans.put(string, object);
        }

        @Override
        public boolean isReadOnly(String string) {
            return false;
        }

        @Override
        public boolean canCreateBean(String string) {
            return true;
        }
    }

    private static class StandardVariableMapper
    extends VariableMapper {
        private Map<String, ValueExpression> vars;

        private StandardVariableMapper() {
        }

        @Override
        public ValueExpression resolveVariable(String string) {
            if (this.vars == null) {
                return null;
            }
            return this.vars.get(string);
        }

        @Override
        public ValueExpression setVariable(String string, ValueExpression valueExpression) {
            if (this.vars == null) {
                this.vars = new HashMap<String, ValueExpression>();
            }
            if (valueExpression == null) {
                return this.vars.remove(string);
            }
            return this.vars.put(string, valueExpression);
        }
    }
}

