/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.data.sort.SortMode;

public abstract class RearrangeFunction
extends GenericFunction {
    private JDialog _dialog = null;
    private JRadioButton[] _positionRadios = null;
    private JRadioButton[] _sortRadios = null;
    private boolean _nearestAvailable = false;

    public RearrangeFunction(App app, boolean bl) {
        super(app);
        this._nearestAvailable = bl;
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this._sortRadios[2].setEnabled(this.isSortByTimeAllowed());
        this._dialog.setVisible(true);
    }

    private JPanel makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(I18nManager.getText(this.getDescriptionKey()));
        jLabel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        jPanel.add((Component)jLabel, "North");
        this._positionRadios = new JRadioButton[3];
        String[] stringArray = new String[]{"tostart", "toend", "tonearest"};
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1));
        int n = 0;
        while (n < stringArray.length) {
            this._positionRadios[n] = new JRadioButton(I18nManager.getText("dialog.rearrange." + stringArray[n]));
            buttonGroup.add(this._positionRadios[n]);
            jPanel2.add(this._positionRadios[n]);
            ++n;
        }
        this._positionRadios[0].setSelected(true);
        this._positionRadios[2].setVisible(this._nearestAvailable);
        this._sortRadios = new JRadioButton[3];
        String[] stringArray2 = new String[]{"nosort", this.getSortNameKey(), "sortbytime"};
        ButtonGroup buttonGroup2 = new ButtonGroup();
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(1));
        int n2 = 0;
        while (n2 < 3) {
            this._sortRadios[n2] = new JRadioButton(I18nManager.getText("dialog.rearrange." + stringArray2[n2]));
            buttonGroup2.add(this._sortRadios[n2]);
            jPanel3.add(this._sortRadios[n2]);
            ++n2;
        }
        this._sortRadios[0].setSelected(true);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = !RearrangeFunction.this._positionRadios[2].isSelected();
                int n = 0;
                while (n < RearrangeFunction.this._sortRadios.length) {
                    RearrangeFunction.this._sortRadios[n].setEnabled(bl);
                    ++n;
                }
            }
        };
        int n3 = 0;
        while (n3 < this._positionRadios.length) {
            this._positionRadios[n3].addActionListener(actionListener);
            ++n3;
        }
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        jPanel.add((Component)jPanel4, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(I18nManager.getText("button.ok"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RearrangeFunction.this.finish();
                RearrangeFunction.this._dialog.dispose();
            }
        });
        jPanel5.add(jButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.cancel"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RearrangeFunction.this._dialog.dispose();
            }
        });
        jPanel5.add(jButton2);
        jPanel.add((Component)jPanel5, "South");
        return jPanel;
    }

    protected boolean isSortByTimeAllowed() {
        return true;
    }

    protected Rearrange getRearrangeOption() {
        if (this._positionRadios[0].isSelected()) {
            return Rearrange.TO_START;
        }
        if (this._positionRadios[1].isSelected()) {
            return Rearrange.TO_END;
        }
        return Rearrange.TO_NEAREST;
    }

    protected SortMode getSortMode() {
        if (this._sortRadios[0].isSelected()) {
            return SortMode.DONT_SORT;
        }
        if (this._sortRadios[1].isSelected()) {
            return SortMode.SORTBY_NAME;
        }
        return SortMode.SORTBY_TIME;
    }

    protected abstract String getDescriptionKey();

    protected abstract String getSortNameKey();

    protected abstract void finish();

    protected static enum Rearrange {
        TO_START,
        TO_END,
        TO_NEAREST;

    }
}

