/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Desktop;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.StructUtils;
import org.openstreetmap.josm.io.CertificateAmendment;
import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Platform;
import org.openstreetmap.josm.tools.PlatformHook;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.WinRegistry;
import org.openstreetmap.josm.tools.WindowsShortcut;

public class PlatformHookWindows
implements PlatformHook {
    private static final Pattern MS_VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)(\\.\\d+.*)?");
    private static final String WINDOWS_ROOT = "Windows-ROOT";
    private static final String CURRENT_VERSION = "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion";
    private String oSBuildNumber;

    @Override
    public Platform getPlatform() {
        return Platform.WINDOWS;
    }

    @Override
    public void afterPrefStartupHook() {
        this.extendFontconfig("fontconfig.properties.src");
    }

    @Override
    public void startupHook(PlatformHook.JavaExpirationCallback javaCallback, PlatformHook.WebStartMigrationCallback webStartCallback) {
        this.checkExpiredJava(javaCallback);
        this.checkWebStartMigration(webStartCallback);
    }

    @Override
    public void openUrl(String url) throws IOException {
        String customBrowser;
        if (!url.startsWith("file:/") && !(customBrowser = Config.getPref().get("browser.windows", "")).isEmpty()) {
            Runtime.getRuntime().exec(new String[]{customBrowser, url});
            return;
        }
        try {
            Desktop.getDesktop().browse(Utils.urlToURI(url));
        }
        catch (IOException | URISyntaxException e) {
            Logging.log(Logging.LEVEL_WARN, "Desktop class failed. Platform dependent fall back for open url in browser.", e);
            Runtime.getRuntime().exec(new String[]{"rundll32", "url.dll,FileProtocolHandler", url});
        }
    }

    @Override
    public void initSystemShortcuts() {
        Shortcut.registerSystemShortcut("system:duplicate", I18n.tr("reserved", new Object[0]), 68, 128);
        Shortcut.registerSystemShortcut("system:reset", I18n.tr("reserved", new Object[0]), 127, 640).setAutomatic();
        Shortcut.registerSystemShortcut("microsoft-reserved-01", I18n.tr("reserved", new Object[0]), 154, 576).setAutomatic();
        Shortcut.registerSystemShortcut("microsoft-reserved-02", I18n.tr("reserved", new Object[0]), 144, 576).setAutomatic();
        Shortcut.registerSystemShortcut("system:copy", I18n.tr("reserved", new Object[0]), 67, 128);
        Shortcut.registerSystemShortcut("system:cut", I18n.tr("reserved", new Object[0]), 88, 128);
        Shortcut.registerSystemShortcut("system:paste", I18n.tr("reserved", new Object[0]), 86, 128);
        Shortcut.registerSystemShortcut("system:undo", I18n.tr("reserved", new Object[0]), 90, 128);
        Shortcut.registerSystemShortcut("system:redo", I18n.tr("reserved", new Object[0]), 89, 128);
        Shortcut.registerSystemShortcut("system:movefocusright", I18n.tr("reserved", new Object[0]), 39, 128);
        Shortcut.registerSystemShortcut("system:movefocusleft", I18n.tr("reserved", new Object[0]), 37, 128);
        Shortcut.registerSystemShortcut("system:movefocusdown", I18n.tr("reserved", new Object[0]), 40, 128);
        Shortcut.registerSystemShortcut("system:movefocusup", I18n.tr("reserved", new Object[0]), 38, 128);
        Shortcut.registerSystemShortcut("system:selectall", I18n.tr("reserved", new Object[0]), 65, 128);
        Shortcut.registerSystemShortcut("microsoft-reserved-31", I18n.tr("reserved", new Object[0]), 10, 512).setAutomatic();
        Shortcut.registerSystemShortcut("system:exit", I18n.tr("reserved", new Object[0]), 115, 512).setAutomatic();
        Shortcut.registerSystemShortcut("microsoft-reserved-33", I18n.tr("reserved", new Object[0]), 32, 512).setAutomatic();
        Shortcut.registerSystemShortcut("microsoft-reserved-35", I18n.tr("reserved", new Object[0]), 9, 512).setAutomatic();
        Shortcut.registerSystemShortcut("microsoft-reserved-36", I18n.tr("reserved", new Object[0]), 9, 640).setAutomatic();
        Shortcut.registerSystemShortcut("microsoft-reserved-39", I18n.tr("reserved", new Object[0]), 27, 512).setAutomatic();
        Shortcut.registerSystemShortcut("microsoft-reserved-42", I18n.tr("reserved", new Object[0]), 121, 64);
        Shortcut.registerSystemShortcut("microsoft-reserved-43", I18n.tr("reserved", new Object[0]), 27, 128).setAutomatic();
        Shortcut.registerSystemShortcut("microsoft-reserved-50", I18n.tr("reserved", new Object[0]), 27, 192).setAutomatic();
        Shortcut.registerSystemShortcut("microsoft-reserved-51", I18n.tr("reserved", new Object[0]), 16, 512).setAutomatic();
        Shortcut.registerSystemShortcut("microsoft-reserved-52", I18n.tr("reserved", new Object[0]), 16, 128).setAutomatic();
    }

    @Override
    public String getDefaultStyle() {
        return "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    }

    @Override
    public boolean rename(File from, File to) {
        if (to.exists()) {
            Utils.deleteFile(to);
        }
        return from.renameTo(to);
    }

    @Override
    public String getOSDescription() {
        return Utils.strip(Utils.getSystemProperty("os.name")) + ' ' + (Utils.getSystemEnv("ProgramFiles(x86)") == null ? "32" : "64") + "-Bit";
    }

    public static String getProductName() throws IllegalAccessException, InvocationTargetException {
        return WinRegistry.readString(-2147483646, CURRENT_VERSION, "ProductName");
    }

    public static String getReleaseId() throws IllegalAccessException, InvocationTargetException {
        return WinRegistry.readString(-2147483646, CURRENT_VERSION, "ReleaseId");
    }

    public static String getCurrentBuild() throws IllegalAccessException, InvocationTargetException {
        return WinRegistry.readString(-2147483646, CURRENT_VERSION, "CurrentBuild");
    }

    private static String buildOSBuildNumber() {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(PlatformHookWindows.getProductName());
            String releaseId = PlatformHookWindows.getReleaseId();
            if (releaseId != null) {
                sb.append(' ').append(releaseId);
            }
            sb.append(" (").append(PlatformHookWindows.getCurrentBuild()).append(')');
        }
        catch (NoClassDefFoundError | ReflectiveOperationException | JosmRuntimeException e) {
            Logging.log(Logging.LEVEL_ERROR, "Unable to get Windows build number", e);
            Logging.debug(e);
        }
        return sb.toString();
    }

    @Override
    public String getOSBuildNumber() {
        if (this.oSBuildNumber == null) {
            this.oSBuildNumber = PlatformHookWindows.buildOSBuildNumber();
        }
        return this.oSBuildNumber;
    }

    public static KeyStore getRootKeystore() throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException {
        KeyStore ks = KeyStore.getInstance(WINDOWS_ROOT);
        ks.load(null, null);
        return ks;
    }

    @Override
    public X509Certificate getX509Certificate(CertificateAmendment.NativeCertAmend certAmend) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        Certificate result;
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        KeyStore ks = PlatformHookWindows.getRootKeystore();
        for (String winAlias : certAmend.getNativeAliases()) {
            result = ks.getCertificate(winAlias);
            if (!PlatformHookWindows.sha256matches(result, certAmend, md)) {
                Logging.trace("Ignoring {0} as SHA-256 signature does not match", result);
                result = null;
            }
            if (result == null && !NetworkManager.isOffline(OnlineResource.CERTIFICATES)) {
                Logging.trace(PlatformHookWindows.webRequest(certAmend.getWebSite()));
                ks = PlatformHookWindows.getRootKeystore();
                result = ks.getCertificate(winAlias);
            }
            if (!(result instanceof X509Certificate)) continue;
            return (X509Certificate)result;
        }
        Enumeration<String> aliases = ks.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            result = ks.getCertificate(alias);
            if (!PlatformHookWindows.sha256matches(result, certAmend, md)) continue;
            Logging.warn("Certificate not found for alias ''{0}'' but found for alias ''{1}''", certAmend.getNativeAliases(), alias);
            return (X509Certificate)result;
        }
        return null;
    }

    private static boolean sha256matches(Certificate result, CertificateAmendment.NativeCertAmend certAmend, MessageDigest md) throws CertificateEncodingException {
        return result instanceof X509Certificate && certAmend.getSha256().equalsIgnoreCase(Utils.toHexString(md.digest(result.getEncoded())));
    }

    @Override
    public File getDefaultCacheDirectory() {
        String p = Utils.getSystemEnv("LOCALAPPDATA");
        if (Utils.isEmpty(p)) {
            p = Utils.getSystemEnv("APPDATA");
        }
        return new File(new File(p, Preferences.getJOSMDirectoryBaseName()), "cache");
    }

    @Override
    public File getDefaultPrefDirectory() {
        return new File(Utils.getSystemEnv("APPDATA"), Preferences.getJOSMDirectoryBaseName());
    }

    @Override
    public File getDefaultUserDataDirectory() {
        return Config.getDirs().getPreferencesDirectory(false);
    }

    protected void extendFontconfig(String templateFileName) {
        String customFontconfigFile = Config.getPref().get("fontconfig.properties", null);
        if (customFontconfigFile != null) {
            Utils.updateSystemProperty("sun.awt.fontconfig", customFontconfigFile);
            return;
        }
        if (!Config.getPref().getBoolean("font.extended-unicode", true)) {
            return;
        }
        String javaLibPath = Utils.getSystemProperty("java.home") + File.separator + "lib";
        Path templateFile = FileSystems.getDefault().getPath(javaLibPath, templateFileName);
        String templatePath = templateFile.toString();
        if (templatePath.startsWith("null") || !Files.isReadable(templateFile)) {
            Logging.warn("extended font config - unable to find font config template file {0}", templatePath);
            return;
        }
        try (InputStream fis = Files.newInputStream(templateFile, new OpenOption[0]);){
            Properties props = new Properties();
            props.load(fis);
            byte[] content = Files.readAllBytes(templateFile);
            File cachePath = Config.getDirs().getCacheDirectory(true);
            Path fontconfigFile = cachePath.toPath().resolve("fontconfig.properties");
            OutputStream os = Files.newOutputStream(fontconfigFile, new OpenOption[0]);
            os.write(content);
            try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));){
                String prevValue;
                String value;
                String key;
                List<FontEntry> extrasPref = StructUtils.getListOfStructs(Config.getPref(), "font.extended-unicode.extra-items", this.getAdditionalFonts(), FontEntry.class);
                ArrayList<FontEntry> extras = new ArrayList<FontEntry>();
                w.append("\n\n# Added by JOSM to extend unicode coverage of Java font support:\n\n");
                ArrayList<String> allCharSubsets = new ArrayList<String>();
                for (FontEntry entry : extrasPref) {
                    Collection<String> fontsAvail = this.getInstalledFonts();
                    if (fontsAvail != null && fontsAvail.contains(entry.file.toUpperCase(Locale.ENGLISH))) {
                        if (!allCharSubsets.contains(entry.charset)) {
                            allCharSubsets.add(entry.charset);
                            extras.add(entry);
                            continue;
                        }
                        Logging.trace("extended font config - already registered font for charset ''{0}'' - skipping ''{1}''", entry.charset, entry.name);
                        continue;
                    }
                    Logging.trace("extended font config - Font ''{0}'' not found on system - skipping", entry.name);
                }
                for (FontEntry entry : extras) {
                    allCharSubsets.add(entry.charset);
                    if ("".equals(entry.name)) continue;
                    key = "allfonts." + entry.charset;
                    value = entry.name;
                    prevValue = props.getProperty(key);
                    if (prevValue != null && !prevValue.equals(value)) {
                        Logging.warn("extended font config - overriding ''{0}={1}'' with ''{2}''", key, prevValue, value);
                    }
                    w.append(key + '=' + value + '\n');
                }
                w.append('\n');
                for (FontEntry entry : extras) {
                    if ("".equals(entry.name) || "".equals(entry.file)) continue;
                    key = "filename." + entry.name.replace(' ', '_');
                    value = entry.file;
                    prevValue = props.getProperty(key);
                    if (prevValue != null && !prevValue.equals(value)) {
                        Logging.warn("extended font config - overriding ''{0}={1}'' with ''{2}''", key, prevValue, value);
                    }
                    w.append(key + '=' + value + '\n');
                }
                w.append('\n');
                w.append("sequence.fallback=");
                String fallback = props.getProperty("sequence.fallback");
                if (fallback != null) {
                    w.append(fallback).append(",");
                }
                w.append(String.join((CharSequence)",", allCharSubsets)).append("\n");
            }
            Utils.updateSystemProperty("sun.awt.fontconfig", fontconfigFile.toString());
        }
        catch (IOException | InvalidPathException ex) {
            Logging.error(ex);
        }
    }

    protected Collection<String> getInstalledFonts() {
        ArrayList<String> fontsAvail = new ArrayList<String>();
        String systemRoot = Utils.getSystemEnv("SYSTEMROOT");
        if (systemRoot == null) {
            return fontsAvail;
        }
        Path fontPath = FileSystems.getDefault().getPath(systemRoot, "Fonts");
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(fontPath);){
            for (Path p : ds) {
                Path filename = p.getFileName();
                if (filename == null) continue;
                fontsAvail.add(filename.toString().toUpperCase(Locale.ENGLISH));
            }
            fontsAvail.add("");
        }
        catch (IOException | DirectoryIteratorException ex) {
            Logging.log(Logging.LEVEL_ERROR, ex);
            Logging.warn("extended font config - failed to load available Fonts");
            fontsAvail = null;
        }
        return fontsAvail;
    }

    protected Collection<FontEntry> getAdditionalFonts() {
        ArrayList<FontEntry> def = new ArrayList<FontEntry>(33);
        def.add(new FontEntry("devanagari", "", ""));
        def.add(new FontEntry("historic", "Segoe UI Historic", "SEGUIHIS.TTF"));
        def.add(new FontEntry("javanese", "Javanese Text", "JAVATEXT.TTF"));
        def.add(new FontEntry("leelawadee", "Leelawadee", "LEELAWAD.TTF"));
        def.add(new FontEntry("malgun", "Malgun Gothic", "MALGUN.TTF"));
        def.add(new FontEntry("myanmar", "Myanmar Text", "MMRTEXT.TTF"));
        def.add(new FontEntry("nirmala", "Nirmala UI", "NIRMALA.TTF"));
        def.add(new FontEntry("segoeui", "Segoe UI", "SEGOEUI.TTF"));
        def.add(new FontEntry("emoji", "Segoe UI Emoji", "SEGUIEMJ.TTF"));
        def.add(new FontEntry("nko_tifinagh_vai_osmanya", "Ebrima", "EBRIMA.TTF"));
        def.add(new FontEntry("khmer1", "Khmer UI", "KHMERUI.TTF"));
        def.add(new FontEntry("lao1", "Lao UI", "LAOUI.TTF"));
        def.add(new FontEntry("tai_le", "Microsoft Tai Le", "TAILE.TTF"));
        def.add(new FontEntry("new_tai_lue", "Microsoft New Tai Lue", "NTHAILU.TTF"));
        def.add(new FontEntry("ethiopic", "Nyala", "NYALA.TTF"));
        def.add(new FontEntry("tibetan", "Microsoft Himalaya", "HIMALAYA.TTF"));
        def.add(new FontEntry("cherokee", "Plantagenet Cherokee", "PLANTC.TTF"));
        def.add(new FontEntry("unified_canadian", "Euphemia", "EUPHEMIA.TTF"));
        def.add(new FontEntry("khmer2", "DaunPenh", "DAUNPENH.TTF"));
        def.add(new FontEntry("khmer3", "MoolBoran", "MOOLBOR.TTF"));
        def.add(new FontEntry("lao_thai", "DokChampa", "DOKCHAMP.TTF"));
        def.add(new FontEntry("mongolian", "Mongolian Baiti", "MONBAITI.TTF"));
        def.add(new FontEntry("oriya", "Kalinga", "KALINGA.TTF"));
        def.add(new FontEntry("sinhala", "Iskoola Pota", "ISKPOTA.TTF"));
        def.add(new FontEntry("yi", "Yi Baiti", "MSYI.TTF"));
        def.add(new FontEntry("gujarati", "Shruti", "SHRUTI.TTF"));
        def.add(new FontEntry("kannada", "Tunga", "TUNGA.TTF"));
        def.add(new FontEntry("gurmukhi", "Raavi", "RAAVI.TTF"));
        def.add(new FontEntry("telugu", "Gautami", "GAUTAMI.TTF"));
        def.add(new FontEntry("bengali", "Vrinda", "VRINDA.TTF"));
        def.add(new FontEntry("syriac", "Estrangelo Edessa", "ESTRE.TTF"));
        def.add(new FontEntry("thaana", "MV Boli", "MVBOLI.TTF"));
        def.add(new FontEntry("malayalam", "Kartika", "KARTIKA.TTF"));
        def.add(new FontEntry("tamil", "Latha", "LATHA.TTF"));
        def.add(new FontEntry("arialuni", "Arial Unicode MS", "ARIALUNI.TTF"));
        return def;
    }

    public static boolean isDotNet45Installed() {
        try {
            Matcher m;
            String version = WinRegistry.readString(-2147483646, "SOFTWARE\\Microsoft\\NET Framework Setup\\NDP\\v4\\Full", "Version");
            if (version != null && (m = MS_VERSION_PATTERN.matcher(version)).matches()) {
                int maj = Integer.parseInt(m.group(1));
                int min = Integer.parseInt(m.group(2));
                return maj == 4 && min >= 5 || maj > 4;
            }
        }
        catch (IllegalAccessException | NumberFormatException | InvocationTargetException e) {
            Logging.error(e);
        }
        return false;
    }

    public static int getPowerShellVersion() {
        try {
            Matcher m;
            String version = WinRegistry.readString(-2147483646, "SOFTWARE\\Microsoft\\Powershell\\3\\PowershellEngine", "PowershellVersion");
            if (version != null && (m = MS_VERSION_PATTERN.matcher(version)).matches()) {
                return Integer.parseInt(m.group(1));
            }
        }
        catch (IllegalAccessException | NumberFormatException | InvocationTargetException e) {
            Logging.error(e);
        }
        return -1;
    }

    public static String webRequest(String uri) throws IOException {
        if (PlatformHookWindows.isDotNet45Installed() && PlatformHookWindows.getPowerShellVersion() >= 3) {
            try {
                return Utils.execOutput(Arrays.asList("powershell", "-Command", "[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12;[System.Net.WebRequest]::Create('" + uri + "').GetResponse()"), 5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
                Logging.warn("Unable to request certificate of " + uri);
                Logging.debug(e);
            }
        }
        return null;
    }

    @Override
    public File resolveFileLink(File file) {
        if (file.getName().endsWith(".lnk")) {
            try {
                return new File(new WindowsShortcut(file).getRealFilename());
            }
            catch (IOException | ParseException e) {
                Logging.error(e);
            }
        }
        return file;
    }

    @Override
    public Collection<String> getPossiblePreferenceDirs() {
        HashSet<String> locations = new HashSet<String>();
        String appdata = Utils.getSystemEnv("APPDATA");
        if (appdata != null && Utils.getSystemEnv("ALLUSERSPROFILE") != null && appdata.lastIndexOf(File.separator) != -1) {
            appdata = appdata.substring(appdata.lastIndexOf(File.separator));
            locations.add(new File(new File(Utils.getSystemEnv("ALLUSERSPROFILE"), appdata), "JOSM").getPath());
        }
        return locations;
    }

    public static class FontEntry {
        @StructUtils.StructEntry
        public String charset;
        @StructUtils.StructEntry
        @StructUtils.WriteExplicitly
        public String name = "";
        @StructUtils.StructEntry
        @StructUtils.WriteExplicitly
        public String file = "";

        public FontEntry() {
        }

        public FontEntry(String charset, String name, String file) {
            this.charset = charset;
            this.name = name;
            this.file = file;
        }
    }
}

