/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx;

import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import mediathek.config.Config;
import mediathek.config.Daten;
import mediathek.filmeSuchen.ListenerFilmeLaden;
import mediathek.filmeSuchen.ListenerFilmeLadenEvent;
import mediathek.javafx.CenteredBorderPane;
import mediathek.javafx.GarbageCollectionButton;
import mediathek.javafx.VerticalSeparator;
import mediathek.javafx.filmlist.FilmListAgeLabel;
import mediathek.javafx.filmlist.FilmListInfoPane;
import mediathek.tool.MessageBus;
import org.controlsfx.control.StatusBar;

public class StatusBarController {
    private final Label progressLabel = new Label("");
    private final ProgressBar progressBar = new ProgressBar();
    private final StatusBar statusBar = new StatusBar();
    private final FilmListInfoPane filmListInfoPane;
    private final GarbageCollectionButton btnGc = new GarbageCollectionButton();
    private Pane progressPane;

    public StatusBarController(Daten daten) {
        this.filmListInfoPane = new FilmListInfoPane(daten);
        MessageBus.getMessageBus().subscribe(this);
        this.createProgressPane();
        daten.getFilmeLaden().addAdListener(new ListenerFilmeLaden(){

            @Override
            public void start(ListenerFilmeLadenEvent event) {
                StatusBarController.this.addProgressItems();
                if (Config.isDebugModeEnabled()) {
                    Platform.runLater(() -> StatusBarController.this.statusBar.setText(event.senderUrl));
                }
            }

            @Override
            public void progress(ListenerFilmeLadenEvent event) {
                StatusBarController.this.updateProgressBar(event);
            }

            @Override
            public void fertig(ListenerFilmeLadenEvent event) {
                Platform.runLater(() -> StatusBarController.this.progressBar.setProgress(0.0));
                StatusBarController.this.removeProgressItems();
                if (Config.isDebugModeEnabled()) {
                    Platform.runLater(() -> StatusBarController.this.statusBar.setText(""));
                }
            }
        });
    }

    public FilmListAgeLabel getFilmlistAgeLabel() {
        return this.filmListInfoPane.getFilmListAgeLabel();
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    private void createProgressPane() {
        HBox hb = new HBox();
        hb.setSpacing(5.0);
        hb.setMinWidth(Double.NEGATIVE_INFINITY);
        hb.getChildren().addAll((Node[])new Node[]{new VerticalSeparator(), new CenteredBorderPane((Node)this.progressLabel), new CenteredBorderPane((Node)this.progressBar)});
        this.progressPane = hb;
    }

    private void updateProgressBar(ListenerFilmeLadenEvent event) {
        Platform.runLater(() -> {
            if (!this.progressBar.isVisible()) {
                this.progressBar.setVisible(true);
            }
            if (event.max == 0 || event.progress == event.max) {
                this.progressBar.setProgress(-1.0);
            } else {
                double max = event.max;
                double progress = event.progress;
                this.progressBar.setProgress(progress / max);
            }
            this.progressLabel.setText(event.text);
        });
    }

    private void addProgressItems() {
        Platform.runLater(() -> {
            ObservableList<Node> rightItems = this.statusBar.getRightItems();
            if (!rightItems.contains(this.progressPane)) {
                rightItems.add(this.progressPane);
            }
        });
    }

    private void removeProgressItems() {
        Platform.runLater(() -> {
            ObservableList<Node> rightItems = this.statusBar.getRightItems();
            rightItems.remove(this.progressPane);
        });
    }

    private void setupLeftPane() {
        ObservableList<Node> leftItems = this.statusBar.getLeftItems();
        if (Config.isDebugModeEnabled()) {
            leftItems.add(this.btnGc);
            leftItems.add(new VerticalSeparator());
        }
    }

    private void setupRightPane() {
        this.statusBar.getRightItems().add(this.filmListInfoPane);
    }

    public StatusBar createStatusBar() {
        this.statusBar.setText("");
        this.setupLeftPane();
        this.setupRightPane();
        return this.statusBar;
    }
}

