# coding: utf-8

"""
    NetHSM

    All endpoints expect exactly the specified JSON. Additional properties will cause a Bad Request Error (400). All HTTP errors contain a JSON structure with an explanation of type string. All <a href=\"https://tools.ietf.org/html/rfc4648#section-4\">base64</a> encoded values are Big Endian.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from pynitrokey.nethsm.client import schemas  # noqa: F401


class KeyGenerateRequestData(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """


    class MetaOapg:
        required = {
            "type",
            "mechanisms",
        }
        
        class properties:
        
            @staticmethod
            def mechanisms() -> typing.Type['KeyMechanisms']:
                return KeyMechanisms
        
            @staticmethod
            def type() -> typing.Type['KeyType']:
                return KeyType
            
            
            class length(
                schemas.IntSchema
            ):
                pass
        
            @staticmethod
            def id() -> typing.Type['ID']:
                return ID
        
            @staticmethod
            def restrictions() -> typing.Type['KeyRestrictions']:
                return KeyRestrictions
            __annotations__ = {
                "mechanisms": mechanisms,
                "type": type,
                "length": length,
                "id": id,
                "restrictions": restrictions,
            }
    
    type: 'KeyType'
    mechanisms: 'KeyMechanisms'
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["mechanisms"]) -> 'KeyMechanisms': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["type"]) -> 'KeyType': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["length"]) -> MetaOapg.properties.length: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["id"]) -> 'ID': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["restrictions"]) -> 'KeyRestrictions': ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["mechanisms", "type", "length", "id", "restrictions", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["mechanisms"]) -> 'KeyMechanisms': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["type"]) -> 'KeyType': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["length"]) -> typing.Union[MetaOapg.properties.length, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["id"]) -> typing.Union['ID', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["restrictions"]) -> typing.Union['KeyRestrictions', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["mechanisms", "type", "length", "id", "restrictions", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        type: 'KeyType',
        mechanisms: 'KeyMechanisms',
        length: typing.Union[MetaOapg.properties.length, decimal.Decimal, int, schemas.Unset] = schemas.unset,
        id: typing.Union['ID', schemas.Unset] = schemas.unset,
        restrictions: typing.Union['KeyRestrictions', schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'KeyGenerateRequestData':
        return super().__new__(
            cls,
            *args,
            type=type,
            mechanisms=mechanisms,
            length=length,
            id=id,
            restrictions=restrictions,
            _configuration=_configuration,
            **kwargs,
        )

from pynitrokey.nethsm.client.model.id import ID
from pynitrokey.nethsm.client.model.key_mechanisms import KeyMechanisms
from pynitrokey.nethsm.client.model.key_restrictions import KeyRestrictions
from pynitrokey.nethsm.client.model.key_type import KeyType
