/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import oracle.net.ns.NIOPacket;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.Clock;

public class NIONSDataChannel
extends NIOPacket {
    int sessionIdSize;
    protected byte[] compressedDataBuffer;
    protected byte[] decompressedDataBuffer;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;

    public NIONSDataChannel(SessionAtts session) {
        super(session);
        this.header.type = 6;
        this.sessionIdSize = session.poolEnabled ? 16 : 0;
    }

    public int getDataExpansionByteSize() {
        return 0;
    }

    public void readDataFromSocketChannel() throws IOException {
        if (this.session.dataEOF) {
            throw new NetException(202);
        }
        this.session.payloadDataBufferForRead.position(this.session.payloadDataBufferForRead.limit());
        this.readFromSocketChannel(true);
        short dataFlags = this.session.payloadBufferForRead.getShort();
        this.session.payloadDataBufferForRead = this.session.payloadBufferForRead.slice();
        this.session.payloadDataBufferForRead.order(this.session.getByteOrder());
        this.session.payloadDataBufferForRead.limit(this.session.payloadBufferForRead.limit() - 2);
        if ((dataFlags & 0x40) != 0) {
            this.session.dataEOF = true;
        }
        if ((dataFlags & 0x8000) == 32768) {
            this.session.renegotiateSSLSession();
        }
        if ((dataFlags & 0x400) != 0) {
            try {
                this.session.payloadDataBufferForRead.get(this.compressedDataBuffer, 0, this.session.payloadDataBufferForRead.limit());
                int resultLength = this.session.compressionCodec.decompress(this.compressedDataBuffer, 0, this.session.payloadDataBufferForRead.limit(), this.decompressedDataBuffer);
                this.session.payloadDataBufferForRead = ByteBuffer.wrap(this.decompressedDataBuffer, 0, resultLength);
                this.session.payloadDataBufferForRead.order(this.session.getByteOrder());
                this.session.payloadDataBufferForRead.limit(resultLength);
            }
            catch (DataFormatException ex) {
                throw (IOException)new IOException("Network Compression failure").initCause(ex);
            }
        }
    }

    public void sendEOF() throws IOException {
        this.session.prepareWriteBuffer();
        this.session.payloadBufferForWrite.put((byte)0);
        this.session.payloadBufferForWrite.put((byte)64);
        this.writeToSocketChannel();
    }

    public void writeDataToSocketChannel() throws IOException {
        this.writeDataToSocketChannel(0);
    }

    public void writeDataToSocketChannel(int dataFlags) throws IOException {
        if (this.isPollAndCheckRequired()) {
            this.session.dataChannel.readInbandNotificationCtlPacket();
        }
        if (this.session.payloadDataBufferForWrite.position() > 0) {
            this.session.payloadBufferForWrite.clear();
            this.header.type = 6;
            if (this.session.networkCompressionEnabled && this.session.payloadDataBufferForWrite.position() + 10 > this.session.networkCompressionThreshold) {
                try {
                    int resultLength;
                    int uncompressedLength = this.session.payloadDataBufferForWrite.position();
                    if (this.session.writeBuffer.hasArray()) {
                        resultLength = this.session.compressionCodec.compress(this.session.writeBuffer.array(), 10, uncompressedLength, this.compressedDataBuffer);
                    } else {
                        this.session.payloadDataBufferForWrite.rewind();
                        this.session.payloadDataBufferForWrite.get(this.decompressedDataBuffer, 0, uncompressedLength);
                        resultLength = this.session.compressionCodec.compress(this.decompressedDataBuffer, 0, uncompressedLength, this.compressedDataBuffer);
                    }
                    if (resultLength < uncompressedLength) {
                        dataFlags |= 0x400;
                        this.session.payloadDataBufferForWrite.rewind();
                        this.session.payloadDataBufferForWrite.put(this.compressedDataBuffer, 0, resultLength);
                    }
                }
                catch (DataFormatException ex) {
                    throw (IOException)new IOException("Network Compression failure").initCause(ex);
                }
            }
            this.session.payloadBufferForWrite.position(this.session.payloadDataBufferForWrite.position() + 2);
            this.session.payloadBufferForWrite.put(0, (byte)(dataFlags / 256));
            this.session.payloadBufferForWrite.put(1, (byte)(dataFlags % 256));
            this.writeToSocketChannel();
        }
    }

    private boolean isPollAndCheckRequired() {
        return this.session.isPollAndCheckEnabled && Clock.currentTimeMillis() - this.session.nt.getNetStat().getLastNetworkAccessTime() > (long)SessionAtts.DEFAULT_POLL_AND_CHECK_TIME_MILLIS;
    }

    public ByteBuffer getDataBuffer() {
        return this.session.payloadDataBufferForRead;
    }

    void initializeNetworkCompressionBuffers() {
        this.compressedDataBuffer = new byte[this.session.getSDU()];
        this.decompressedDataBuffer = new byte[this.session.getSDU()];
    }

    byte[] readPayloadDataFromSocketChannel(int len) throws IOException {
        byte[] data = new byte[len];
        int bytesToReadThisTime = 0;
        for (int bytesReadSoFar = 0; bytesReadSoFar < len; bytesReadSoFar += bytesToReadThisTime) {
            this.readDataFromSocketChannel();
            bytesToReadThisTime = this.session.payloadDataBufferForRead.limit();
            this.session.payloadDataBufferForRead.get(data, bytesReadSoFar, bytesToReadThisTime);
        }
        return data;
    }

    void writeDataToSocketChannel(byte[] data) throws IOException {
        int bytesToWriteThisTime = 0;
        int dataFlags = 0;
        for (int bytesWrittenSoFar = 0; bytesWrittenSoFar < data.length; bytesWrittenSoFar += bytesToWriteThisTime) {
            this.session.prepareWriteBuffer();
            bytesToWriteThisTime = this.session.payloadDataBufferForWrite.limit() - this.session.payloadDataBufferForWrite.position();
            if (bytesToWriteThisTime > data.length - bytesWrittenSoFar) {
                bytesToWriteThisTime = data.length - bytesWrittenSoFar;
            }
            dataFlags = data.length > bytesToWriteThisTime ? 32 : 0;
            this.session.payloadDataBufferForWrite.put(data, bytesWrittenSoFar, bytesToWriteThisTime);
            this.writeDataToSocketChannel(dataFlags);
        }
    }

    @Override
    void readPayloadBuffer() throws IOException {
        throw new UnsupportedOperationException("Data Byte buffers are not duplicated and accessed directly by the upper layer");
    }

    static {
        try {
            $$$methodRef$$$11 = NIONSDataChannel.class.getDeclaredConstructor(SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = NIONSDataChannel.class.getDeclaredMethod("readPayloadBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = NIONSDataChannel.class.getDeclaredMethod("writeDataToSocketChannel", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = NIONSDataChannel.class.getDeclaredMethod("readPayloadDataFromSocketChannel", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = NIONSDataChannel.class.getDeclaredMethod("initializeNetworkCompressionBuffers", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = NIONSDataChannel.class.getDeclaredMethod("getDataBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = NIONSDataChannel.class.getDeclaredMethod("isPollAndCheckRequired", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = NIONSDataChannel.class.getDeclaredMethod("writeDataToSocketChannel", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NIONSDataChannel.class.getDeclaredMethod("writeDataToSocketChannel", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NIONSDataChannel.class.getDeclaredMethod("sendEOF", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NIONSDataChannel.class.getDeclaredMethod("readDataFromSocketChannel", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NIONSDataChannel.class.getDeclaredMethod("getDataExpansionByteSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

