/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.impl;

import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import net.sf.sdedit.config.Configuration;
import net.sf.sdedit.config.ConfigurationManager;
import net.sf.sdedit.diagram.AbstractPaintDevice;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.diagram.DiagramDataProviderFactory;
import net.sf.sdedit.diagram.DiagramFactory;
import net.sf.sdedit.diagram.GraphicDevice;
import net.sf.sdedit.diagram.PaintDevice;
import net.sf.sdedit.drawable.Drawable;
import net.sf.sdedit.editor.plugin.FileActionProvider;
import net.sf.sdedit.error.DiagramError;
import net.sf.sdedit.server.Exporter;
import net.sf.sdedit.ui.ImageGraphicsDevice;
import net.sf.sdedit.ui.PanelGraphicDevice;
import net.sf.sdedit.ui.Tab;
import net.sf.sdedit.ui.components.ZoomPane;
import net.sf.sdedit.ui.components.Zoomable;
import net.sf.sdedit.ui.components.buttons.ActionManager;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.impl.DiagramInteraction;
import net.sf.sdedit.ui.impl.DiagramRenderer;
import net.sf.sdedit.ui.impl.UserInterfaceImpl;

public abstract class DiagramTab
extends Tab
implements PropertyChangeListener,
Transferable,
DiagramDataProviderFactory {
    protected static final DiagramRenderer renderer = new DiagramRenderer();
    public static final DataFlavor EMF_FLAVOR = new DataFlavor("image/emf", "Enhanced Meta File");
    private ZoomPane zoomPane = new ZoomPane();
    private Bean<? extends Configuration> configuration;
    private DiagramInteraction interaction;
    private DiagramError error;
    private Diagram diagram;
    private boolean redraw;
    private boolean refreshOnActivate = true;
    private DataFlavor flavor;

    public DiagramTab(UserInterfaceImpl ui) {
        super(ui);
        this.zoomPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JPopupMenu menu;
                if (DiagramTab.this.interaction != null && SwingUtilities.isRightMouseButton(e) && (menu = DiagramTab.this.createPopupMenu()) != null && DiagramTab.this.getDiagram() != null) {
                    menu.show((Component)e.getSource(), e.getX(), e.getY());
                    e.consume();
                    return;
                }
            }
        });
    }

    protected void setRefreshOnActivate(boolean on) {
        this.refreshOnActivate = on;
    }

    @Override
    public void activate(ActionManager actionManager, FileActionProvider faProvider) {
        super.activate(actionManager, faProvider);
        if (this.refreshOnActivate) {
            this.refresh(true);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals("explicitReturns")) {
            this.refresh(false);
        }
    }

    public synchronized DiagramError getDiagramError() {
        return this.error;
    }

    public DiagramRenderer getRenderer() {
        return renderer;
    }

    public void clear() {
    }

    public final void setInteraction(DiagramInteraction interaction) {
        this.interaction = interaction;
    }

    protected DiagramInteraction getInteraction() {
        return this.interaction;
    }

    public void setConfiguration(Bean<? extends Configuration> configuration) {
        if (this.configuration != null) {
            this.configuration.removePropertyChangeListener(this);
        }
        this.configuration = configuration;
        this.configuration.addPropertyChangeListener(this);
    }

    public Bean<? extends Configuration> getConfiguration() {
        return this.configuration;
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    protected JPopupMenu createPopupMenu() {
        List<Action> actions = this.interaction.getContextActions();
        JPopupMenu menu = null;
        if (actions != null) {
            menu = new JPopupMenu();
            for (Action action : actions) {
                menu.add(action);
            }
        }
        return menu;
    }

    @Override
    public ZoomPane getZoomPane() {
        return this.zoomPane;
    }

    public void refresh(boolean redraw) {
        this.redraw = redraw;
        renderer.renderDiagram(this);
    }

    protected PanelGraphicDevice graphic() {
        AbstractPaintDevice apd = (AbstractPaintDevice)this.diagram.getPaintDevice();
        PanelGraphicDevice pg = (PanelGraphicDevice)apd.getGraphicDevice();
        return pg;
    }

    public void displayDiagram(Diagram diagram, DiagramError error) {
        this.diagram = diagram;
        if (this.redraw || ConfigurationManager.getGlobalConfiguration().isAutoUpdate()) {
            this.getZoomPane().setViewportView(this.graphic().getPanel());
        }
        this.error = error;
        this.handleDiagramError(error);
        this.get_UI().enableComponents();
    }

    protected abstract void handleDiagramError(DiagramError var1);

    public void scrollToDrawable(Drawable drawable, boolean highlight) {
        if (highlight) {
            this.graphic().highlight(drawable);
            this.repaint();
        }
        this.getZoomPane().scrollToRectangle(drawable.getRectangle());
    }

    @Override
    public void goHome() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DiagramTab.this.getZoomPane().home();
            }
        });
    }

    public boolean isEmpty() {
        return this.diagram == null || this.diagram.getPaintDevice() == null || this.diagram.getPaintDevice().isEmpty();
    }

    @Override
    public boolean canZoom() {
        return !this.isEmpty();
    }

    @Override
    protected Zoomable<? extends JComponent> getZoomable() {
        AbstractPaintDevice ppd;
        Diagram diagram = this.getDiagram();
        if (diagram != null && !(ppd = (AbstractPaintDevice)diagram.getPaintDevice()).isEmpty()) {
            return ((PanelGraphicDevice)ppd.getGraphicDevice()).getPanel();
        }
        return null;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        if (flavor.equals(EMF_FLAVOR)) {
            return this.getTransferDataVector("emf");
        }
        return this.getTransferDataBitmap();
    }

    public abstract DiagramFactory createFactory(PaintDevice var1);

    private InputStream getTransferDataVector(String format) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Exporter exporter = Exporter.getExporter(format, "Landscape", "A0", stream);
        AbstractPaintDevice paintDevice = this.createPaintDevice(exporter);
        DiagramFactory factory = this.createFactory(paintDevice);
        try {
            factory.generateDiagram(this.getConfiguration().getDataObject());
        }
        catch (DiagramError diagramError) {
            // empty catch block
        }
        exporter.export();
        byte[] bytes = stream.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        return bais;
    }

    private Image getTransferDataBitmap() throws IOException {
        ImageGraphicsDevice ipd = new ImageGraphicsDevice(false);
        AbstractPaintDevice paintDevice = this.createPaintDevice(ipd);
        DiagramFactory factory = this.createFactory(paintDevice);
        try {
            factory.generateDiagram(this.getConfiguration().getDataObject());
        }
        catch (DiagramError diagramError) {
            // empty catch block
        }
        ipd.drawAll();
        return ipd.getImage();
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{this.flavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return Arrays.asList(this.getTransferDataFlavors()).contains(flavor);
    }

    public void copyToClipboard(DataFlavor flavor) {
        this.flavor = flavor;
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(this, null);
    }

    @Override
    public boolean canGoHome() {
        return true;
    }

    public abstract AbstractPaintDevice createPaintDevice(GraphicDevice var1);

    static {
        try {
            SystemFlavorMap sfm = (SystemFlavorMap)SystemFlavorMap.getDefaultFlavorMap();
            sfm.addUnencodedNativeForFlavor(EMF_FLAVOR, "ENHMETAFILE");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

