/*  XMMS2 - X Music Multiplexer System
 *  Copyright (C) 2003-2020 XMMS2 Team
 *
 *  PLUGINS ARE NOT CONSIDERED TO BE DERIVED WORK !!!
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 */

/* Header generated from src/ipc.xml - DO NOT EDIT ! */

#ifndef __IPC_SIGNAL_XMMS_H__
#define __IPC_SIGNAL_XMMS_H__

#include <xmmsc/xmmsc_compiler.h>

#define XMMS_IPC_PROTOCOL_VERSION 24

#define XMMS_IPC_COMMAND_FIRST 32


typedef enum {
	XMMS_IPC_OBJECT_SIGNAL,
	XMMS_IPC_OBJECT_MAIN,
	XMMS_IPC_OBJECT_PLAYLIST,
	XMMS_IPC_OBJECT_CONFIG,
	XMMS_IPC_OBJECT_PLAYBACK,
	XMMS_IPC_OBJECT_MEDIALIB,
	XMMS_IPC_OBJECT_COLLECTION,
	XMMS_IPC_OBJECT_VISUALIZATION,
	XMMS_IPC_OBJECT_MEDIAINFO_READER,
	XMMS_IPC_OBJECT_XFORM,
	XMMS_IPC_OBJECT_BINDATA,
	XMMS_IPC_OBJECT_COLL_SYNC,
	XMMS_IPC_OBJECT_COURIER,
	XMMS_IPC_OBJECT_IPC_MANAGER,
	XMMS_IPC_OBJECT_END
} xmms_ipc_object_t;

typedef enum {
	XMMS_IPC_SIGNAL_MAIN_QUIT,
	XMMS_IPC_SIGNAL_PLAYLIST_CHANGED,
	XMMS_IPC_SIGNAL_PLAYLIST_CURRENT_POS,
	XMMS_IPC_SIGNAL_PLAYLIST_LOADED,
	XMMS_IPC_SIGNAL_CONFIG_VALUE_CHANGED,
	XMMS_IPC_SIGNAL_PLAYBACK_STATUS,
	XMMS_IPC_SIGNAL_PLAYBACK_VOLUME_CHANGED,
	XMMS_IPC_SIGNAL_PLAYBACK_CURRENT_ID,
	XMMS_IPC_SIGNAL_PLAYBACK_PLAYTIME,
	XMMS_IPC_SIGNAL_MEDIALIB_ENTRY_ADDED,
	XMMS_IPC_SIGNAL_MEDIALIB_ENTRY_CHANGED,
	XMMS_IPC_SIGNAL_MEDIALIB_ENTRY_REMOVED,
	XMMS_IPC_SIGNAL_COLLECTION_CHANGED,
	XMMS_IPC_SIGNAL_MEDIAINFO_READER_STATUS,
	XMMS_IPC_SIGNAL_MEDIAINFO_READER_UNINDEXED,
	XMMS_IPC_SIGNAL_COURIER_MESSAGE,
	XMMS_IPC_SIGNAL_COURIER_READY,
	XMMS_IPC_SIGNAL_IPC_MANAGER_CLIENT_CONNECTED,
	XMMS_IPC_SIGNAL_IPC_MANAGER_CLIENT_DISCONNECTED,
	XMMS_IPC_SIGNAL_END
} xmms_ipc_signal_t;

typedef enum {
	XMMS_IPC_COMMAND_REPLY,
	XMMS_IPC_COMMAND_ERROR
} xmms_ipc_command_special_t;

typedef enum {
	XMMS_IPC_COMMAND_SIGNAL = XMMS_IPC_COMMAND_FIRST,
	XMMS_IPC_COMMAND_BROADCAST
} xmms_ipc_command_signal_t;

typedef enum {
	XMMS_C2C_REPLY_POLICY_NO_REPLY,
	XMMS_C2C_REPLY_POLICY_SINGLE_REPLY,
	XMMS_C2C_REPLY_POLICY_MULTI_REPLY
} xmms_c2c_reply_policy_t;

typedef enum {
	XMMS_COLLECTION_CHANGED_ADD,
	XMMS_COLLECTION_CHANGED_UPDATE,
	XMMS_COLLECTION_CHANGED_RENAME,
	XMMS_COLLECTION_CHANGED_REMOVE
} xmms_collection_changed_action_t;

typedef enum {
	XMMS_COLLECTION_TYPE_REFERENCE,
	XMMS_COLLECTION_TYPE_UNIVERSE,
	XMMS_COLLECTION_TYPE_UNION,
	XMMS_COLLECTION_TYPE_INTERSECTION,
	XMMS_COLLECTION_TYPE_COMPLEMENT,
	XMMS_COLLECTION_TYPE_HAS,
	XMMS_COLLECTION_TYPE_MATCH,
	XMMS_COLLECTION_TYPE_TOKEN,
	XMMS_COLLECTION_TYPE_EQUALS,
	XMMS_COLLECTION_TYPE_NOTEQUAL,
	XMMS_COLLECTION_TYPE_SMALLER,
	XMMS_COLLECTION_TYPE_SMALLEREQ,
	XMMS_COLLECTION_TYPE_GREATER,
	XMMS_COLLECTION_TYPE_GREATEREQ,
	XMMS_COLLECTION_TYPE_ORDER,
	XMMS_COLLECTION_TYPE_LIMIT,
	XMMS_COLLECTION_TYPE_MEDIASET,
	XMMS_COLLECTION_TYPE_IDLIST,
	XMMS_COLLECTION_TYPE_LAST = XMMS_COLLECTION_TYPE_IDLIST
} xmms_collection_type_t;

typedef enum {
	XMMS_LOG_LEVEL_UNKNOWN,
	XMMS_LOG_LEVEL_FATAL,
	XMMS_LOG_LEVEL_FAIL,
	XMMS_LOG_LEVEL_ERROR,
	XMMS_LOG_LEVEL_INFO,
	XMMS_LOG_LEVEL_DEBUG,
	XMMS_LOG_LEVEL_COUNT
} xmms_log_level_t;

typedef enum {
	XMMS_MEDIALIB_ENTRY_STATUS_NEW,
	XMMS_MEDIALIB_ENTRY_STATUS_OK,
	XMMS_MEDIALIB_ENTRY_STATUS_RESOLVING,
	XMMS_MEDIALIB_ENTRY_STATUS_NOT_AVAILABLE,
	XMMS_MEDIALIB_ENTRY_STATUS_REHASH
} xmms_medialib_entry_status_t;

typedef enum {
	XMMS_MEDIAINFO_READER_STATUS_IDLE,
	XMMS_MEDIAINFO_READER_STATUS_RUNNING
} xmms_mediainfo_reader_status_t;

typedef enum {
	XMMS_PLAYBACK_SEEK_CUR = 1,
	XMMS_PLAYBACK_SEEK_SET
} xmms_playback_seek_mode_t;

typedef enum {
	XMMS_PLAYBACK_STATUS_STOP,
	XMMS_PLAYBACK_STATUS_PLAY,
	XMMS_PLAYBACK_STATUS_PAUSE
} xmms_playback_status_t;

typedef enum {
	XMMS_PLAYLIST_CURRENT_ID_FORGET,
	XMMS_PLAYLIST_CURRENT_ID_KEEP,
	XMMS_PLAYLIST_CURRENT_ID_MOVE_TO_FRONT
} xmms_playlist_position_action_t;

typedef enum {
	XMMS_PLAYLIST_CHANGED_ADD,
	XMMS_PLAYLIST_CHANGED_INSERT,
	XMMS_PLAYLIST_CHANGED_SHUFFLE,
	XMMS_PLAYLIST_CHANGED_REMOVE,
	XMMS_PLAYLIST_CHANGED_CLEAR,
	XMMS_PLAYLIST_CHANGED_MOVE,
	XMMS_PLAYLIST_CHANGED_SORT,
	XMMS_PLAYLIST_CHANGED_UPDATE,
	XMMS_PLAYLIST_CHANGED_REPLACE
} xmms_playlist_changed_action_t;

typedef enum {
	XMMS_PLUGIN_TYPE_ALL,
	XMMS_PLUGIN_TYPE_OUTPUT,
	XMMS_PLUGIN_TYPE_XFORM
} xmms_plugin_type_t;

typedef enum {
	XMMS_IPC_COMMAND_MAIN_HELLO = XMMS_IPC_COMMAND_FIRST,
	XMMS_IPC_COMMAND_MAIN_QUIT,
	XMMS_IPC_COMMAND_MAIN_LIST_PLUGINS,
	XMMS_IPC_COMMAND_MAIN_STATS
} xmms_ipc_command_main_t;

typedef enum {
	XMMS_IPC_COMMAND_PLAYLIST_REPLACE = XMMS_IPC_COMMAND_FIRST,
	XMMS_IPC_COMMAND_PLAYLIST_SET_NEXT,
	XMMS_IPC_COMMAND_PLAYLIST_SET_NEXT_REL,
	XMMS_IPC_COMMAND_PLAYLIST_ADD_URL,
	XMMS_IPC_COMMAND_PLAYLIST_ADD_COLLECTION,
	XMMS_IPC_COMMAND_PLAYLIST_REMOVE_ENTRY,
	XMMS_IPC_COMMAND_PLAYLIST_MOVE_ENTRY,
	XMMS_IPC_COMMAND_PLAYLIST_LIST_ENTRIES,
	XMMS_IPC_COMMAND_PLAYLIST_CURRENT_POS,
	XMMS_IPC_COMMAND_PLAYLIST_CURRENT_ACTIVE,
	XMMS_IPC_COMMAND_PLAYLIST_INSERT_URL,
	XMMS_IPC_COMMAND_PLAYLIST_INSERT_COLLECTION,
	XMMS_IPC_COMMAND_PLAYLIST_LOAD,
	XMMS_IPC_COMMAND_PLAYLIST_RADD,
	XMMS_IPC_COMMAND_PLAYLIST_RINSERT
} xmms_ipc_command_playlist_t;

typedef enum {
	XMMS_IPC_COMMAND_CONFIG_GET_VALUE = XMMS_IPC_COMMAND_FIRST,
	XMMS_IPC_COMMAND_CONFIG_SET_VALUE,
	XMMS_IPC_COMMAND_CONFIG_REGISTER_VALUE,
	XMMS_IPC_COMMAND_CONFIG_LIST_VALUES
} xmms_ipc_command_config_t;

typedef enum {
	XMMS_IPC_COMMAND_PLAYBACK_START = XMMS_IPC_COMMAND_FIRST,
	XMMS_IPC_COMMAND_PLAYBACK_STOP,
	XMMS_IPC_COMMAND_PLAYBACK_PAUSE,
	XMMS_IPC_COMMAND_PLAYBACK_TICKLE,
	XMMS_IPC_COMMAND_PLAYBACK_PLAYTIME,
	XMMS_IPC_COMMAND_PLAYBACK_SEEK_MS,
	XMMS_IPC_COMMAND_PLAYBACK_SEEK_SAMPLES,
	XMMS_IPC_COMMAND_PLAYBACK_STATUS,
	XMMS_IPC_COMMAND_PLAYBACK_CURRENT_ID,
	XMMS_IPC_COMMAND_PLAYBACK_VOLUME_SET,
	XMMS_IPC_COMMAND_PLAYBACK_VOLUME_GET
} xmms_ipc_command_playback_t;

typedef enum {
	XMMS_IPC_COMMAND_MEDIALIB_GET_INFO = XMMS_IPC_COMMAND_FIRST,
	XMMS_IPC_COMMAND_MEDIALIB_IMPORT_PATH,
	XMMS_IPC_COMMAND_MEDIALIB_REHASH,
	XMMS_IPC_COMMAND_MEDIALIB_GET_ID,
	XMMS_IPC_COMMAND_MEDIALIB_REMOVE_ENTRY,
	XMMS_IPC_COMMAND_MEDIALIB_SET_PROPERTY_STRING,
	XMMS_IPC_COMMAND_MEDIALIB_SET_PROPERTY_INT,
	XMMS_IPC_COMMAND_MEDIALIB_REMOVE_PROPERTY,
	XMMS_IPC_COMMAND_MEDIALIB_MOVE_ENTRY,
	XMMS_IPC_COMMAND_MEDIALIB_ADD_ENTRY
} xmms_ipc_command_medialib_t;

typedef enum {
	XMMS_IPC_COMMAND_COLLECTION_GET = XMMS_IPC_COMMAND_FIRST,
	XMMS_IPC_COMMAND_COLLECTION_LIST,
	XMMS_IPC_COMMAND_COLLECTION_SAVE,
	XMMS_IPC_COMMAND_COLLECTION_REMOVE,
	XMMS_IPC_COMMAND_COLLECTION_FIND,
	XMMS_IPC_COMMAND_COLLECTION_RENAME,
	XMMS_IPC_COMMAND_COLLECTION_QUERY,
	XMMS_IPC_COMMAND_COLLECTION_QUERY_INFOS,
	XMMS_IPC_COMMAND_COLLECTION_IDLIST_FROM_PLAYLIST
} xmms_ipc_command_collection_t;

typedef enum {
	XMMS_IPC_COMMAND_VISUALIZATION_QUERY_VERSION = XMMS_IPC_COMMAND_FIRST,
	XMMS_IPC_COMMAND_VISUALIZATION_REGISTER,
	XMMS_IPC_COMMAND_VISUALIZATION_INIT_SHM,
	XMMS_IPC_COMMAND_VISUALIZATION_INIT_UDP,
	XMMS_IPC_COMMAND_VISUALIZATION_SET_PROPERTY,
	XMMS_IPC_COMMAND_VISUALIZATION_SET_PROPERTIES,
	XMMS_IPC_COMMAND_VISUALIZATION_SHUTDOWN
} xmms_ipc_command_visualization_t;

typedef enum {
	XMMS_IPC_COMMAND_XFORM_BROWSE = XMMS_IPC_COMMAND_FIRST
} xmms_ipc_command_xform_t;

typedef enum {
	XMMS_IPC_COMMAND_BINDATA_RETRIEVE = XMMS_IPC_COMMAND_FIRST,
	XMMS_IPC_COMMAND_BINDATA_ADD,
	XMMS_IPC_COMMAND_BINDATA_REMOVE,
	XMMS_IPC_COMMAND_BINDATA_LIST
} xmms_ipc_command_bindata_t;

typedef enum {
	XMMS_IPC_COMMAND_COLL_SYNC_SYNC = XMMS_IPC_COMMAND_FIRST
} xmms_ipc_command_coll_sync_t;

typedef enum {
	XMMS_IPC_COMMAND_COURIER_SEND_MESSAGE = XMMS_IPC_COMMAND_FIRST,
	XMMS_IPC_COMMAND_COURIER_REPLY,
	XMMS_IPC_COMMAND_COURIER_GET_CONNECTED_CLIENTS,
	XMMS_IPC_COMMAND_COURIER_READY,
	XMMS_IPC_COMMAND_COURIER_GET_READY_CLIENTS
} xmms_ipc_command_courier_t;


#include <xmmsc/xmmsc_idnumbers_extra.h>

#endif /* __IPC_SIGNAL_XMMS_H__ */
