/*
 * Decompiled with CFR 0.152.
 */
package javax.print.attribute.standard;

import javax.print.attribute.Attribute;
import javax.print.attribute.SetOfIntegerSyntax;
import javax.print.attribute.SupportedValuesAttribute;

public final class NumberUpSupported
extends SetOfIntegerSyntax
implements SupportedValuesAttribute {
    private static final long serialVersionUID = -1041573395759141805L;

    public NumberUpSupported(int[][] members) {
        super(members);
        if (members == null) {
            throw new NullPointerException("members is null");
        }
        int[][] myMembers = this.getMembers();
        int n = myMembers.length;
        if (n == 0) {
            throw new IllegalArgumentException("members is zero-length");
        }
        for (int i = 0; i < n; ++i) {
            if (myMembers[i][0] >= 1) continue;
            throw new IllegalArgumentException("Number up value must be > 0");
        }
    }

    public NumberUpSupported(int member) {
        super(member);
        if (member < 1) {
            throw new IllegalArgumentException("Number up value must be > 0");
        }
    }

    public NumberUpSupported(int lowerBound, int upperBound) {
        super(lowerBound, upperBound);
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException("Null range specified");
        }
        if (lowerBound < 1) {
            throw new IllegalArgumentException("Number up value must be > 0");
        }
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && object instanceof NumberUpSupported;
    }

    @Override
    public final Class<? extends Attribute> getCategory() {
        return NumberUpSupported.class;
    }

    @Override
    public final String getName() {
        return "number-up-supported";
    }
}

