/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.digester;

import org.apache.tomcat.util.digester.ArrayStack;
import org.apache.tomcat.util.digester.ObjectCreationFactory;
import org.apache.tomcat.util.digester.Rule;
import org.xml.sax.Attributes;

public class FactoryCreateRule
extends Rule {
    private boolean ignoreCreateExceptions;
    private ArrayStack<Boolean> exceptionIgnoredStack;
    protected ObjectCreationFactory creationFactory = null;

    public FactoryCreateRule(ObjectCreationFactory objectCreationFactory, boolean bl) {
        this.creationFactory = objectCreationFactory;
        this.ignoreCreateExceptions = bl;
    }

    @Override
    public void begin(String string, String string2, Attributes attributes) throws Exception {
        if (this.ignoreCreateExceptions) {
            if (this.exceptionIgnoredStack == null) {
                this.exceptionIgnoredStack = new ArrayStack();
            }
            try {
                Object object = this.creationFactory.createObject(attributes);
                if (this.digester.log.isDebugEnabled()) {
                    this.digester.log.debug((Object)("[FactoryCreateRule]{" + this.digester.match + "} New " + object.getClass().getName()));
                }
                this.digester.push(object);
                this.exceptionIgnoredStack.push(Boolean.FALSE);
            }
            catch (Exception exception) {
                if (this.digester.log.isInfoEnabled()) {
                    this.digester.log.info((Object)("[FactoryCreateRule] Create exception ignored: " + (exception.getMessage() == null ? exception.getClass().getName() : exception.getMessage())));
                    if (this.digester.log.isDebugEnabled()) {
                        this.digester.log.debug((Object)"[FactoryCreateRule] Ignored exception:", (Throwable)exception);
                    }
                }
                this.exceptionIgnoredStack.push(Boolean.TRUE);
            }
        } else {
            Object object = this.creationFactory.createObject(attributes);
            if (this.digester.log.isDebugEnabled()) {
                this.digester.log.debug((Object)("[FactoryCreateRule]{" + this.digester.match + "} New " + object.getClass().getName()));
            }
            this.digester.push(object);
        }
    }

    @Override
    public void end(String string, String string2) throws Exception {
        if (this.ignoreCreateExceptions && this.exceptionIgnoredStack != null && !this.exceptionIgnoredStack.empty() && this.exceptionIgnoredStack.pop().booleanValue()) {
            if (this.digester.log.isTraceEnabled()) {
                this.digester.log.trace((Object)"[FactoryCreateRule] No creation so no push so no pop");
            }
            return;
        }
        Object object = this.digester.pop();
        if (this.digester.log.isDebugEnabled()) {
            this.digester.log.debug((Object)("[FactoryCreateRule]{" + this.digester.match + "} Pop " + object.getClass().getName()));
        }
    }

    @Override
    public void finish() throws Exception {
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("FactoryCreateRule[");
        if (this.creationFactory != null) {
            stringBuilder.append("creationFactory=");
            stringBuilder.append(this.creationFactory);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

