/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.jdk9.model.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.consumer.RecordedClass;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedStackTrace;
import jdk.jfr.consumer.RecordedThread;
import org.graalvm.visualvm.jfr.jdk9.model.impl.DisplayableSupport;
import org.graalvm.visualvm.jfr.jdk9.model.impl.JFRJDK9Class;
import org.graalvm.visualvm.jfr.jdk9.model.impl.JFRJDK9StackTrace;
import org.graalvm.visualvm.jfr.jdk9.model.impl.JFRJDK9Thread;
import org.graalvm.visualvm.jfr.model.JFRClass;
import org.graalvm.visualvm.jfr.model.JFREvent;
import org.graalvm.visualvm.jfr.model.JFRPropertyNotAvailableException;
import org.graalvm.visualvm.jfr.model.JFRStackTrace;
import org.graalvm.visualvm.jfr.model.JFRThread;

public class JFRJDK9Event
extends JFREvent {
    protected final RecordedEvent event;

    public JFRJDK9Event(RecordedEvent event, long id) {
        super(id);
        this.event = event;
    }

    public Instant getInstant(String key) throws JFRPropertyNotAvailableException {
        switch (key) {
            case "eventTime": 
            case "startTime": {
                return this.event.getStartTime();
            }
            case "endTime": {
                return this.event.getEndTime();
            }
        }
        Object instant = this.getValue(key);
        if (instant instanceof Instant) {
            return (Instant)instant;
        }
        if (instant == null) {
            return null;
        }
        if (instant instanceof Number) {
            return Instant.ofEpochMilli(((Number)instant).longValue());
        }
        throw new JFRPropertyNotAvailableException("No instant value available: " + key);
    }

    public Duration getDuration(String key) throws JFRPropertyNotAvailableException {
        if ("eventDuration".equals(key)) {
            return this.event.getDuration();
        }
        Object duration = this.getValue(key);
        if (duration instanceof Duration) {
            return (Duration)duration;
        }
        if (duration == null) {
            return null;
        }
        if (duration instanceof Number) {
            return Duration.ofMillis(((Number)duration).longValue());
        }
        throw new JFRPropertyNotAvailableException("No duration value available: " + key);
    }

    public JFRClass getClass(String key) throws JFRPropertyNotAvailableException {
        Object rclass = this.getValue(key);
        if (rclass == null) {
            return null;
        }
        if (rclass instanceof RecordedClass) {
            return new JFRJDK9Class((RecordedClass)rclass);
        }
        throw new JFRPropertyNotAvailableException("No class value available: " + key);
    }

    public JFRThread getThread(String key) throws JFRPropertyNotAvailableException {
        if ("eventThread".equals(key)) {
            RecordedThread thread = this.event.getThread();
            return thread == null ? null : new JFRJDK9Thread(thread);
        }
        Object thread = this.getValue(key);
        if (thread instanceof RecordedThread) {
            return new JFRJDK9Thread((RecordedThread)thread);
        }
        if (thread == null) {
            return null;
        }
        throw new JFRPropertyNotAvailableException("No thread value available: " + key);
    }

    public JFRStackTrace getStackTrace(String key) throws JFRPropertyNotAvailableException {
        if ("eventStackTrace".equals(key)) {
            RecordedStackTrace stackTrace = this.event.getStackTrace();
            return stackTrace == null ? null : new JFRJDK9StackTrace(stackTrace);
        }
        Object stackTrace = this.getValue(key);
        if (stackTrace instanceof RecordedStackTrace) {
            return new JFRJDK9StackTrace((RecordedStackTrace)stackTrace);
        }
        if (stackTrace == null) {
            return null;
        }
        throw new JFRPropertyNotAvailableException("No stacktrace value available: " + key);
    }

    public Object getValue(String key) throws JFRPropertyNotAvailableException {
        try {
            return this.event.getValue(key);
        }
        catch (IllegalArgumentException e) {
            throw new JFRPropertyNotAvailableException((Throwable)e);
        }
    }

    public List<Comparable> getDisplayableValues(boolean includeExperimental) {
        ArrayList<Comparable> values = new ArrayList<Comparable>();
        Iterator<ValueDescriptor> descriptors = DisplayableSupport.displayableValueDescriptors(this.event.getEventType(), includeExperimental);
        while (descriptors.hasNext()) {
            values.add(DisplayableSupport.getDisplayValue(this, descriptors.next()));
        }
        return values;
    }

    public int hashCode() {
        return this.event.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof JFRJDK9Event ? this.event.equals(((JFRJDK9Event)((Object)o)).event) : false;
    }

    public String toString() {
        return this.event.toString();
    }
}

