/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results.threads;

import java.util.Hashtable;
import org.graalvm.visualvm.lib.jfluid.client.MonitoredData;
import org.graalvm.visualvm.lib.jfluid.results.DataManager;
import org.graalvm.visualvm.lib.jfluid.results.threads.ThreadData;

public class ThreadsDataManager
extends DataManager {
    private Hashtable idToIndex = new Hashtable(30);
    private ThreadData[] threadData;
    private boolean supportsSleepingState = true;
    private boolean threadsMonitoringEnabled = true;
    private long endTime;
    private long startTime;

    public ThreadsDataManager() {
        this.reset();
    }

    public synchronized long getEndTime() {
        return this.endTime;
    }

    public synchronized long getStartTime() {
        return this.startTime;
    }

    public synchronized void setSupportsSleepingStateMonitoring(boolean supportsSleepingState) {
        this.supportsSleepingState = supportsSleepingState;
    }

    public synchronized String getThreadClassName(int index) {
        return this.threadData[index].getClassName();
    }

    public synchronized ThreadData getThreadData(int index) {
        return this.threadData[index];
    }

    public synchronized String getThreadName(int index) {
        return this.threadData[index].getName();
    }

    public synchronized int getThreadsCount() {
        return this.threadData.length;
    }

    public synchronized void setThreadsMonitoringEnabled(boolean enabled) {
        if (this.threadsMonitoringEnabled == enabled) {
            return;
        }
        this.threadsMonitoringEnabled = enabled;
        if (!this.threadsMonitoringEnabled) {
            for (ThreadData threadData1 : this.threadData) {
                threadData1.clearStates();
            }
        }
    }

    public synchronized boolean hasData() {
        return this.getThreadsCount() != 0;
    }

    public synchronized void processData(MonitoredData monitoredData) {
        int max = this.threadData.length;
        int newThreadsNum = monitoredData.getNNewThreads();
        if (newThreadsNum > 0) {
            this.addNewThreads(monitoredData.getNewThreadNames(), monitoredData.getNewThreadClassNames());
            int[] newIds = monitoredData.getNewThreadIds();
            for (int i = 0; i < newThreadsNum; ++i) {
                this.idToIndex.put(newIds[i], i + max);
            }
        }
        if (this.threadsMonitoringEnabled) {
            if (monitoredData.getThreadsDataMode() == 2) {
                int[] exThreadIds = monitoredData.getExplicitThreadIds();
                long[] exTimestamps = monitoredData.getExplicitStateTimestamps();
                byte[] exStates = monitoredData.getExplicitThreadStates();
                if (exTimestamps.length == 0) {
                    return;
                }
                if (this.startTime == 0L) {
                    this.startTime = exTimestamps[0];
                }
                for (int i = 0; i < exThreadIds.length; ++i) {
                    Integer intIndex = (Integer)this.idToIndex.get(exThreadIds[i]);
                    int index = intIndex;
                    ThreadData tData = this.threadData[index];
                    tData.add(exTimestamps[i], exStates[i]);
                }
                this.endTime = exTimestamps[exTimestamps.length - 1];
                this.fireDataChanged();
            } else if (monitoredData.getThreadsDataMode() == 1) {
                int[] threadIds = monitoredData.getThreadIds();
                long[] timestamps = monitoredData.getStateTimestamps();
                byte[][] states = monitoredData.getThreadStates();
                int nThreads = monitoredData.getNThreads();
                int nStates = monitoredData.getNThreadStates();
                if (nStates == 0 || nThreads == 0) {
                    return;
                }
                if (this.startTime == 0L) {
                    this.startTime = monitoredData.getStateTimestamps()[0];
                }
                for (int threadIdx = 0; threadIdx < nThreads; ++threadIdx) {
                    Integer intIndex = (Integer)this.idToIndex.get(threadIds[threadIdx]);
                    int index = intIndex;
                    byte[] threadStates = states[threadIdx];
                    ThreadData tData = this.threadData[index];
                    for (int stampIdx = 0; stampIdx < nStates; ++stampIdx) {
                        long timeStamp = timestamps[stampIdx];
                        byte state = threadStates[stampIdx];
                        byte lastState = tData.getLastState();
                        if (lastState != 127 && lastState == state) continue;
                        tData.add(timeStamp, state);
                    }
                }
                this.endTime = timestamps[nStates - 1];
                this.fireDataChanged();
            }
        }
    }

    public synchronized void reset() {
        this.startTime = 0L;
        this.endTime = 0L;
        this.threadData = new ThreadData[0];
        this.idToIndex.clear();
        this.fireDataReset();
    }

    public synchronized void resetStates() {
        if (this.threadData != null) {
            this.startTime = 0L;
            this.endTime = 0L;
            for (ThreadData data : this.threadData) {
                data.clearStates();
            }
            this.fireDataReset();
        }
    }

    public synchronized boolean supportsSleepingStateMonitoring() {
        return this.supportsSleepingState;
    }

    private void addNewThreads(String[] newNames, String[] newClassNames) {
        int newSize = newNames.length + this.threadData.length;
        ThreadData[] tmpData = new ThreadData[newSize];
        if (this.threadData.length > 0) {
            System.arraycopy(this.threadData, 0, tmpData, 0, this.threadData.length);
        }
        int i = this.threadData.length;
        int idx = 0;
        while (i < newSize) {
            tmpData[i] = new ThreadData(newNames[idx], newClassNames[idx]);
            ++i;
            ++idx;
        }
        this.threadData = tmpData;
    }
}

