"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.normaliseHREF = exports.joinURL = exports.extractURLPath = void 0;
var url_parse_1 = __importDefault(require("url-parse"));
var url_join_1 = __importDefault(require("url-join"));
var path_1 = require("./path");
function extractURLPath(fullURL) {
    var url = new url_parse_1.default(fullURL);
    var urlPath = url.pathname;
    if (urlPath.length <= 0) {
        urlPath = "/";
    }
    return (0, path_1.normalisePath)(urlPath);
}
exports.extractURLPath = extractURLPath;
function joinURL() {
    var parts = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        parts[_i] = arguments[_i];
    }
    return (0, url_join_1.default)(parts.reduce(function (output, nextPart, partIndex) {
        if (partIndex === 0 ||
            nextPart !== "/" ||
            (nextPart === "/" && output[output.length - 1] !== "/")) {
            output.push(nextPart);
        }
        return output;
    }, []));
}
exports.joinURL = joinURL;
function normaliseHREF(href) {
    var normalisedHref = href.replace(/^https?:\/\/[^\/]+/, "");
    return normalisedHref;
}
exports.normaliseHREF = normaliseHREF;
