/* bluez-persona-store.c generated by valac 0.56.3, the Vala compiler
 * generated from bluez-persona-store.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *          Arun Raghavan <arun.raghavan@collabora.co.uk>
 *          Jeremy Whiting <jeremy.whiting@collabora.com>
 *          Simon McVittie <simon.mcvittie@collabora.co.uk>
 *          Gustavo Padovan <gustavo.padovan@collabora.co.uk>
 *          Matthieu Bouron <matthieu.bouron@collabora.com>
 *          Philip Withnall <philip.withnall@collabora.co.uk>
 *
 * Based on kf-persona-store.vala by:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include "bluez.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include "folks/folks.h"
#include <libebook-contacts/libebook-contacts.h>
#include <glib/gi18n-lib.h>
#include "folks-internal.h"
#include <math.h>
#include <float.h>
#include <errno.h>

#define FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE__TIMEOUT_MIN ((guint) 4)
#define FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE__TIMEOUT_BASE ((guint) 2)
#define FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE__TIMEOUT_MAX ((guint) (5 * 60))
#define FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE__MAX_CONSECUTIVE_FAILURES ((guint) 3)

enum  {
	FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_0_PROPERTY,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_TYPE_ID_PROPERTY,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_CAN_ADD_PERSONAS_PROPERTY,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_CAN_ALIAS_PERSONAS_PROPERTY,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_CAN_GROUP_PERSONAS_PROPERTY,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_CAN_REMOVE_PERSONAS_PROPERTY,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_IS_PREPARED_PROPERTY,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_IS_QUIESCENT_PROPERTY,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES_PROPERTY,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_PERSONAS_PROPERTY,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_DISPLAY_NAME_PROPERTY,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_OBJECT_PATH_PROPERTY,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_NUM_PROPERTIES
};
static GParamSpec* folks_backends_blue_z_persona_store_properties[FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define __vala_EVCardAttribute_free0(var) ((var == NULL) ? NULL : (var = (_vala_EVCardAttribute_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FolksBackendsBlueZPersonaStoreUpdateContactsFromFileData FolksBackendsBlueZPersonaStoreUpdateContactsFromFileData;
typedef struct _FolksBackendsBlueZPersonaStoreSetConnectionStateData FolksBackendsBlueZPersonaStoreSetConnectionStateData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _FolksBackendsBlueZPersonaStoreNewObexSessionData FolksBackendsBlueZPersonaStoreNewObexSessionData;
typedef struct _FolksBackendsBlueZPersonaStoreRemoveObexSessionData FolksBackendsBlueZPersonaStoreRemoveObexSessionData;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
typedef struct _FolksBackendsBlueZPersonaStorePerformObexTransferData FolksBackendsBlueZPersonaStorePerformObexTransferData;
typedef struct _FolksBackendsBlueZPersonaStoreUpdateContactsData FolksBackendsBlueZPersonaStoreUpdateContactsData;
typedef struct _Block5Data Block5Data;
typedef struct _FolksBackendsBlueZPersonaStorePrepareData FolksBackendsBlueZPersonaStorePrepareData;
typedef struct _FolksBackendsBlueZPersonaStoreRemovePersonaData FolksBackendsBlueZPersonaStoreRemovePersonaData;
typedef struct _FolksBackendsBlueZPersonaStoreAddPersonaFromDetailsData FolksBackendsBlueZPersonaStoreAddPersonaFromDetailsData;

struct _FolksBackendsBlueZPersonaStorePrivate {
	GeeHashMap* _personas;
	GeeMap* _personas_ro;
	gboolean _is_prepared;
	gboolean _prepare_pending;
	gboolean _is_quiescent;
	orgbluezobexClient* _obex_client;
	gchar* _object_path;
	orgbluezDevice* _device;
	gchar* _display_name;
	GCancellable* _update_contacts_cancellable;
	guint _update_contacts_id;
	gboolean _photos_up_to_date;
	guint _update_contacts_n;
	guint _update_contacts_failures;
};

struct _FolksBackendsBlueZPersonaStoreUpdateContactsFromFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksBackendsBlueZPersonaStore* self;
	GFile* file;
	GeeHashSet* added_personas;
	GeeHashSet* _tmp0_;
	GeeHashSet* removed_personas;
	GeeHashSet* _tmp1_;
	gboolean photos_up_to_date;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GeeHashSet* _tmp4_;
	GeeHashMap* _tmp5_;
	GeeCollection* _tmp6_;
	GeeCollection* _tmp7_;
	GeeCollection* _tmp8_;
	GFileInputStream* _tmp9_;
	GFileInputStream* _tmp10_;
	GDataInputStream* dis;
	GDataInputStream* _tmp11_;
	guint i;
	gchar* line;
	GString* vcard;
	GString* _tmp12_;
	GString* vcard_without_photo;
	GString* _tmp13_;
	gchar* _tmp14_;
	GDataInputStream* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	gboolean _tmp19_;
	GString* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GString* _tmp24_;
	const gchar* _tmp25_;
	GString* _tmp26_;
	gboolean _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	GString* _tmp30_;
	const gchar* _tmp31_;
	GString* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gboolean _tmp36_;
	EVCard* card;
	GString* _tmp37_;
	const gchar* _tmp38_;
	EVCard* _tmp39_;
	gboolean is_user;
	gboolean iid_is_checksum;
	gchar* iid;
	EVCardAttribute* attribute;
	EVCard* _tmp40_;
	EVCardAttribute* _tmp41_;
	EVCardAttribute* _tmp42_;
	EVCardAttribute* _tmp43_;
	EVCardAttribute* _tmp44_;
	GString* _tmp45_;
	GString* _tmp46_;
	const gchar* _tmp47_;
	gchar* _tmp48_;
	GString* _tmp49_;
	const gchar* _tmp50_;
	gchar* _tmp51_;
	FolksBackendsBlueZPersona* persona;
	GeeHashMap* _tmp52_;
	const gchar* _tmp53_;
	gpointer _tmp54_;
	FolksBackendsBlueZPersona* _tmp55_;
	GString* _tmp56_;
	const gchar* _tmp57_;
	EVCard* _tmp58_;
	const gchar* _tmp59_;
	FolksBackendsBlueZPersona* _tmp60_;
	gboolean _tmp61_;
	GString* _tmp62_;
	GString* _tmp63_;
	FolksBackendsBlueZPersona* _tmp64_;
	EVCard* _tmp65_;
	GeeHashSet* _tmp66_;
	FolksBackendsBlueZPersona* _tmp67_;
	GeeHashSet* _tmp68_;
	FolksBackendsBlueZPersona* _tmp69_;
	guint _tmp70_;
	GString* _tmp71_;
	GString* _tmp72_;
	GError* e1;
	GError* _tmp73_;
	const gchar* _tmp74_;
	GError* _tmp75_;
	GeeHashSet* _tmp76_;
	gint _tmp77_;
	gint _tmp78_;
	GeeHashSet* _tmp79_;
	gint _tmp80_;
	gint _tmp81_;
	GeeIterator* _p_it;
	GeeHashSet* _tmp82_;
	GeeIterator* _tmp83_;
	GeeIterator* _tmp84_;
	FolksBackendsBlueZPersona* p;
	GeeIterator* _tmp85_;
	gpointer _tmp86_;
	GeeHashMap* _tmp87_;
	FolksBackendsBlueZPersona* _tmp88_;
	const gchar* _tmp89_;
	const gchar* _tmp90_;
	FolksBackendsBlueZPersona* _tmp91_;
	GeeIterator* _vala1__p_it;
	GeeHashSet* _tmp92_;
	GeeIterator* _tmp93_;
	GeeIterator* _tmp94_;
	FolksBackendsBlueZPersona* _vala1_p;
	GeeIterator* _tmp95_;
	gpointer _tmp96_;
	GeeHashMap* _tmp97_;
	FolksBackendsBlueZPersona* _tmp98_;
	const gchar* _tmp99_;
	const gchar* _tmp100_;
	gboolean _tmp101_;
	GeeHashSet* _tmp102_;
	gboolean _tmp103_;
	gboolean _tmp104_;
	GeeHashSet* _tmp105_;
	gboolean _tmp106_;
	gboolean _tmp107_;
	GeeHashSet* _tmp108_;
	GeeHashSet* _tmp109_;
	GError* _inner_error0_;
};

struct _FolksBackendsBlueZPersonaStoreSetConnectionStateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksBackendsBlueZPersonaStore* self;
	gboolean connected;
	orgbluezDevice* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	orgbluezDevice* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	orgbluezDevice* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	orgbluezDevice* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GError* _inner_error0_;
};

struct _FolksBackendsBlueZPersonaStoreNewObexSessionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksBackendsBlueZPersonaStore* self;
	orgbluezobexPhonebookAccess* obex_pbap;
	char* result;
	GHashTable* args;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	gchar* _tmp2_;
	GVariant* _tmp3_;
	char* session_path;
	orgbluezobexClient* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GHashTable* _tmp7_;
	char* _tmp8_;
	const char* _tmp9_;
	orgbluezobexPhonebookAccess* _tmp10_;
	const char* _tmp11_;
	orgbluezobexPhonebookAccess* _tmp12_;
	orgbluezobexPhonebookAccess* _tmp13_;
	orgbluezobexPhonebookAccess* _tmp14_;
	GError* _inner_error0_;
};

struct _FolksBackendsBlueZPersonaStoreRemoveObexSessionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksBackendsBlueZPersonaStore* self;
	char* session_path;
	orgbluezobexClient* _tmp0_;
	GError* ie;
	gboolean _tmp1_;
	GError* _tmp2_;
	GError* _tmp3_;
	gboolean _tmp4_;
	GError* _tmp5_;
	GError* _tmp6_;
	const gchar* _tmp7_;
	GError* _tmp8_;
	const gchar* _tmp9_;
	GError* de;
	GError* _tmp10_;
	const gchar* _tmp11_;
	GError* _inner_error0_;
};

struct _Block2Data {
	int _ref_count_;
	FolksBackendsBlueZPersonaStore* self;
	gpointer _async_data_;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	gboolean has_yielded;
	gchar* transfer_status;
};

struct _Block4Data {
	int _ref_count_;
	Block2Data * _data2_;
	GFile* file;
};

struct _FolksBackendsBlueZPersonaStorePerformObexTransferData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksBackendsBlueZPersonaStore* self;
	gchar* path;
	GCancellable* cancellable;
	Block2Data* _data2_;
	orgbluezobexTransfer* transfer;
	Block3Data* _data3_;
	orgbluezobexTransfer* _tmp0_;
	orgbluezobexTransfer* _tmp1_;
	orgbluezobexTransfer* _tmp2_;
	GDBusProxy* transfer_proxy;
	orgbluezobexTransfer* _tmp3_;
	GDBusProxy* _tmp4_;
	gulong signal_id;
	gulong cancellable_id;
	orgbluezobexTransfer* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GDBusProxy* _tmp8_;
	gulong _tmp9_;
	gboolean _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GDBusProxy* _tmp13_;
	const gchar* _tmp14_;
	gchar* filename;
	orgbluezobexTransfer* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	orgbluezobexTransfer* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	GError* _tmp24_;
	GError* _tmp25_;
	GFile* file;
	const gchar* _tmp26_;
	GFile* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	GFile* _tmp32_;
	const gchar* _tmp33_;
	orgbluezobexTransfer* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	const gchar* _tmp38_;
	GError* _tmp39_;
	GError* _tmp40_;
	GError* _inner_error1_;
	gboolean _tmp41_;
	orgbluezobexTransfer* _tmp42_;
	orgbluezobexTransfer* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	Block4Data* _data4_;
	orgbluezobexTransfer* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	GFile* _tmp51_;
	GFile* _tmp52_;
	GFile* _tmp53_;
	GError* _inner_error0_;
};

struct _FolksBackendsBlueZPersonaStoreUpdateContactsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksBackendsBlueZPersonaStore* self;
	gboolean download_photos;
	char* session_path;
	orgbluezobexPhonebookAccess* obex_pbap;
	gboolean success;
	GCancellable* _tmp0_;
	const char* _tmp1_;
	const char* _tmp2_;
	guint _tmp3_;
	gboolean _tmp4_;
	gboolean new_download_photos;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* path;
	GHashTable* props;
	GCancellable* _tmp9_;
	char* _tmp10_;
	orgbluezobexPhonebookAccess* _tmp11_;
	char* _tmp12_;
	char* _tmp13_;
	GError* e1;
	gboolean _tmp14_;
	GError* _tmp15_;
	GError* _tmp16_;
	const gchar* _tmp17_;
	orgbluezDevice* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GError* _tmp22_;
	GError* _tmp23_;
	orgbluezDevice* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GError* _tmp28_;
	const gchar* _tmp29_;
	GError* _tmp30_;
	GError* _tmp31_;
	orgbluezobexPhonebookAccess* _tmp32_;
	GHashTable* phonebook_filter;
	GHashTable* _tmp33_;
	GHashTable* _tmp34_;
	gchar* _tmp35_;
	GVariant* _tmp36_;
	GHashTable* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar** _tmp47_;
	gchar** _tmp48_;
	gint _tmp48__length1;
	GVariant* _tmp49_;
	GHashTable* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar** _tmp59_;
	gchar** _tmp60_;
	gint _tmp60__length1;
	GVariant* _tmp61_;
	orgbluezobexPhonebookAccess* _tmp62_;
	GHashTable* _tmp63_;
	gchar* _tmp64_;
	GHashTable* _tmp65_;
	GError* e2;
	orgbluezDevice* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	GError* _tmp70_;
	const gchar* _tmp71_;
	GError* _tmp72_;
	GError* _tmp73_;
	const gchar* _tmp74_;
	GCancellable* _tmp75_;
	GError* e3;
	GError* _tmp76_;
	GError* _tmp77_;
	GError* _tmp78_;
	const gchar* _tmp79_;
	GError* _tmp80_;
	const gchar* _tmp81_;
	GError* _tmp82_;
	GError* e4;
	GError* _tmp83_;
	GError* _tmp84_;
	GError* e5;
	GError* _tmp85_;
	GError* _tmp86_;
	GError* _inner_error1_;
	const char* _tmp87_;
	const char* _tmp88_;
	guint _tmp89_;
	gboolean _vala1__tmp4_;
	gboolean _vala1_new_download_photos;
	const gchar* _tmp90_;
	const gchar* _tmp91_;
	GError* _inner_error0_;
};

struct _Block5Data {
	int _ref_count_;
	FolksBackendsBlueZPersonaStore* self;
	gboolean download_photos;
};

struct _FolksBackendsBlueZPersonaStorePrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksBackendsBlueZPersonaStore* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	orgbluezDevice* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GError* _tmp7_;
	GError* _tmp8_;
	GError* _inner_error1_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	GError* _inner_error0_;
};

struct _FolksBackendsBlueZPersonaStoreRemovePersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksBackendsBlueZPersonaStore* self;
	FolksPersona* persona;
	GError* _tmp0_;
	GError* _inner_error0_;
};

struct _FolksBackendsBlueZPersonaStoreAddPersonaFromDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksBackendsBlueZPersonaStore* self;
	GHashTable* details;
	FolksPersona* result;
	GError* _tmp0_;
	GError* _inner_error0_;
};

static gint FolksBackendsBlueZPersonaStore_private_offset;
static gpointer folks_backends_blue_z_persona_store_parent_class = NULL;
static gchar** folks_backends_blue_z_persona_store__always_writeable_properties;
static gint folks_backends_blue_z_persona_store__always_writeable_properties_length1;
static gchar** folks_backends_blue_z_persona_store__always_writeable_properties = NULL;
static gint folks_backends_blue_z_persona_store__always_writeable_properties_length1 = 0;
static gint _folks_backends_blue_z_persona_store__always_writeable_properties_size_ = 0;

VALA_EXTERN void folks_backends_blue_z_persona_store_set_is_trusted (FolksBackendsBlueZPersonaStore* self,
                                                         gboolean trusted);
static void _folks_backends_blue_z_persona_store_update_contacts_from_file_data_free (gpointer _data);
static void _folks_backends_blue_z_persona_store_update_contacts_from_file (FolksBackendsBlueZPersonaStore* self,
                                                                     GFile* file,
                                                                     GAsyncReadyCallback _callback_,
                                                                     gpointer _user_data_);
static void _folks_backends_blue_z_persona_store_update_contacts_from_file_finish (FolksBackendsBlueZPersonaStore* self,
                                                                            GAsyncResult* _res_,
                                                                            GError** error);
static gboolean _folks_backends_blue_z_persona_store_update_contacts_from_file_co (FolksBackendsBlueZPersonaStoreUpdateContactsFromFileData* _data_);
static void _folks_backends_blue_z_persona_store_update_contacts_from_file_ready (GObject* source_object,
                                                                           GAsyncResult* _res_,
                                                                           gpointer _user_data_);
static EVCardAttribute* _vala_EVCardAttribute_copy (EVCardAttribute* self);
VALA_EXTERN gboolean folks_backends_blue_z_persona_update_from_vcard (FolksBackendsBlueZPersona* self,
                                                          EVCard* card);
static void _vala_EVCardAttribute_free (EVCardAttribute* self);
VALA_EXTERN void folks_backends_blue_z_persona_store_set_alias (FolksBackendsBlueZPersonaStore* self,
                                                    const gchar* alias);
static void folks_backends_blue_z_persona_store_set_connection_state_data_free (gpointer _data);
VALA_EXTERN void folks_backends_blue_z_persona_store_set_connection_state (FolksBackendsBlueZPersonaStore* self,
                                                               gboolean connected,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_);
VALA_EXTERN void folks_backends_blue_z_persona_store_set_connection_state_finish (FolksBackendsBlueZPersonaStore* self,
                                                                      GAsyncResult* _res_,
                                                                      GError** error);
static gboolean folks_backends_blue_z_persona_store_set_connection_state_co (FolksBackendsBlueZPersonaStoreSetConnectionStateData* _data_);
static void _folks_backends_blue_z_persona_store_update_contacts (FolksBackendsBlueZPersonaStore* self,
                                                           gboolean download_photos,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_);
static void _folks_backends_blue_z_persona_store_update_contacts_finish (FolksBackendsBlueZPersonaStore* self,
                                                                  GAsyncResult* _res_,
                                                                  GError** error);
static void folks_backends_blue_z_persona_store_set_connection_state_ready (GObject* source_object,
                                                                     GAsyncResult* _res_,
                                                                     gpointer _user_data_);
VALA_EXTERN void folks_backends_blue_z_persona_store_cancel_updates (FolksBackendsBlueZPersonaStore* self);
static void _folks_backends_blue_z_persona_store_new_obex_session_data_free (gpointer _data);
static void _folks_backends_blue_z_persona_store_new_obex_session (FolksBackendsBlueZPersonaStore* self,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_);
static char* _folks_backends_blue_z_persona_store_new_obex_session_finish (FolksBackendsBlueZPersonaStore* self,
                                                                    GAsyncResult* _res_,
                                                                    orgbluezobexPhonebookAccess** obex_pbap,
                                                                    GError** error);
static gboolean _folks_backends_blue_z_persona_store_new_obex_session_co (FolksBackendsBlueZPersonaStoreNewObexSessionData* _data_);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static GVariant* _variant_new1 (const gchar* value);
static void _folks_backends_blue_z_persona_store_new_obex_session_ready (GObject* source_object,
                                                                  GAsyncResult* _res_,
                                                                  gpointer _user_data_);
static void _folks_backends_blue_z_persona_store_remove_obex_session_data_free (gpointer _data);
static void _folks_backends_blue_z_persona_store_remove_obex_session (FolksBackendsBlueZPersonaStore* self,
                                                               const char* session_path,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_);
static void _folks_backends_blue_z_persona_store_remove_obex_session_finish (FolksBackendsBlueZPersonaStore* self,
                                                                      GAsyncResult* _res_);
static gboolean _folks_backends_blue_z_persona_store_remove_obex_session_co (FolksBackendsBlueZPersonaStoreRemoveObexSessionData* _data_);
static void _folks_backends_blue_z_persona_store_remove_obex_session_ready (GObject* source_object,
                                                                     GAsyncResult* _res_,
                                                                     gpointer _user_data_);
static void _folks_backends_blue_z_persona_store_perform_obex_transfer_data_free (gpointer _data);
static void _folks_backends_blue_z_persona_store_perform_obex_transfer (FolksBackendsBlueZPersonaStore* self,
                                                                 const gchar* path,
                                                                 GCancellable* cancellable,
                                                                 GAsyncReadyCallback _callback_,
                                                                 gpointer _user_data_);
static void _folks_backends_blue_z_persona_store_perform_obex_transfer_finish (FolksBackendsBlueZPersonaStore* self,
                                                                        GAsyncResult* _res_,
                                                                        GError** error);
static gboolean _folks_backends_blue_z_persona_store_perform_obex_transfer_co (FolksBackendsBlueZPersonaStorePerformObexTransferData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void _folks_backends_blue_z_persona_store_perform_obex_transfer_ready (GObject* source_object,
                                                                       GAsyncResult* _res_,
                                                                       gpointer _user_data_);
static void ____lambda4_ (Block3Data* _data3_);
static void _____lambda4__gfunc (gconstpointer data,
                          gpointer self);
static void ___lambda5_ (Block3Data* _data3_,
                  GVariant* changed,
                  gchar** invalidated);
static void ____lambda5__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                     GVariant* changed_properties,
                                                     gchar** invalidated_properties,
                                                     gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void ____lambda6_ (Block4Data* _data4_,
                   GObject* o,
                   GAsyncResult* r);
static void _____lambda6__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void _folks_backends_blue_z_persona_store_update_contacts_data_free (gpointer _data);
static gboolean _folks_backends_blue_z_persona_store_update_contacts_co (FolksBackendsBlueZPersonaStoreUpdateContactsData* _data_);
static void _folks_backends_blue_z_persona_store_schedule_update_contacts (FolksBackendsBlueZPersonaStore* self,
                                                                    gboolean download_photos);
static void _folks_backends_blue_z_persona_store_update_contacts_ready (GObject* source_object,
                                                                 GAsyncResult* _res_,
                                                                 gpointer _user_data_);
static GVariant* _variant_new2 (const gchar* value);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean __lambda7_ (Block5Data* _data5_);
static void __lambda8_ (FolksBackendsBlueZPersonaStore* self,
                 GObject* o,
                 GAsyncResult* r);
static void ___lambda8__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static gboolean ___lambda7__gsource_func (gpointer self);
static void folks_backends_blue_z_persona_store_real_prepare_data_free (gpointer _data);
static void folks_backends_blue_z_persona_store_real_prepare (FolksPersonaStore* base,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static gboolean folks_backends_blue_z_persona_store_real_prepare_co (FolksBackendsBlueZPersonaStorePrepareData* _data_);
static void folks_backends_blue_z_persona_store_prepare_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_);
static void folks_backends_blue_z_persona_store_real_remove_persona_data_free (gpointer _data);
static void folks_backends_blue_z_persona_store_real_remove_persona (FolksPersonaStore* base,
                                                              FolksPersona* persona,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_);
static gboolean folks_backends_blue_z_persona_store_real_remove_persona_co (FolksBackendsBlueZPersonaStoreRemovePersonaData* _data_);
static void folks_backends_blue_z_persona_store_real_add_persona_from_details_data_free (gpointer _data);
static void folks_backends_blue_z_persona_store_real_add_persona_from_details (FolksPersonaStore* base,
                                                                        GHashTable* details,
                                                                        GAsyncReadyCallback _callback_,
                                                                        gpointer _user_data_);
static gboolean folks_backends_blue_z_persona_store_real_add_persona_from_details_co (FolksBackendsBlueZPersonaStoreAddPersonaFromDetailsData* _data_);
static GObject * folks_backends_blue_z_persona_store_constructor (GType type,
                                                           guint n_construct_properties,
                                                           GObjectConstructParam * construct_properties);
static void folks_backends_blue_z_persona_store_finalize (GObject * obj);
static GType folks_backends_blue_z_persona_store_get_type_once (void);
static void _vala_folks_backends_blue_z_persona_store_get_property (GObject * object,
                                                             guint property_id,
                                                             GValue * value,
                                                             GParamSpec * pspec);
static void _vala_folks_backends_blue_z_persona_store_set_property (GObject * object,
                                                             guint property_id,
                                                             const GValue * value,
                                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
folks_backends_blue_z_persona_store_get_instance_private (FolksBackendsBlueZPersonaStore* self)
{
	return G_STRUCT_MEMBER_P (self, FolksBackendsBlueZPersonaStore_private_offset);
}

/**
   * Create a new PersonaStore.
   *
   * Create a new persona store to expose the {@link Persona}s provided by the
   * device with the given Bluetooth address.
   *
   * @param device the D-Bus object for the Bluetooth device.
   * @param object_path the D-Bus path of the object for the Bluetooth device
   * @param obex_client the D-Bus obex client object.
   *
   * @since 0.9.6
   */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FolksBackendsBlueZPersonaStore*
folks_backends_blue_z_persona_store_construct (GType object_type,
                                               orgbluezDevice* device,
                                               const gchar* object_path,
                                               orgbluezobexClient* obex_client)
{
	FolksBackendsBlueZPersonaStore * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	orgbluezDevice* _tmp6_;
	orgbluezobexClient* _tmp7_;
	orgbluezDevice* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	g_return_val_if_fail (device != NULL, NULL);
	g_return_val_if_fail (object_path != NULL, NULL);
	g_return_val_if_fail (obex_client != NULL, NULL);
	_tmp0_ = org_bluez_device_get_address (device);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = org_bluez_device_get_alias (device);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	self = (FolksBackendsBlueZPersonaStore*) g_object_new (object_type, "id", _tmp2_, "object-path", object_path, "display-name", _tmp5_, NULL);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	_tmp6_ = _g_object_ref0 (device);
	_g_object_unref0 (self->priv->_device);
	self->priv->_device = _tmp6_;
	_tmp7_ = _g_object_ref0 (obex_client);
	_g_object_unref0 (self->priv->_obex_client);
	self->priv->_obex_client = _tmp7_;
	_tmp8_ = self->priv->_device;
	_tmp9_ = org_bluez_device_get_trusted (_tmp8_);
	_tmp10_ = _tmp9_;
	folks_backends_blue_z_persona_store_set_is_trusted (self, _tmp10_);
	return self;
}

FolksBackendsBlueZPersonaStore*
folks_backends_blue_z_persona_store_new (orgbluezDevice* device,
                                         const gchar* object_path,
                                         orgbluezobexClient* obex_client)
{
	return folks_backends_blue_z_persona_store_construct (FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA_STORE, device, object_path, obex_client);
}

static void
_folks_backends_blue_z_persona_store_update_contacts_from_file_data_free (gpointer _data)
{
	FolksBackendsBlueZPersonaStoreUpdateContactsFromFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsBlueZPersonaStoreUpdateContactsFromFileData, _data_);
}

static void
_folks_backends_blue_z_persona_store_update_contacts_from_file (FolksBackendsBlueZPersonaStore* self,
                                                                GFile* file,
                                                                GAsyncReadyCallback _callback_,
                                                                gpointer _user_data_)
{
	FolksBackendsBlueZPersonaStoreUpdateContactsFromFileData* _data_;
	FolksBackendsBlueZPersonaStore* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_data_ = g_slice_new0 (FolksBackendsBlueZPersonaStoreUpdateContactsFromFileData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, _folks_backends_blue_z_persona_store_update_contacts_from_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	_folks_backends_blue_z_persona_store_update_contacts_from_file_co (_data_);
}

static void
_folks_backends_blue_z_persona_store_update_contacts_from_file_finish (FolksBackendsBlueZPersonaStore* self,
                                                                       GAsyncResult* _res_,
                                                                       GError** error)
{
	FolksBackendsBlueZPersonaStoreUpdateContactsFromFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Load contacts from a file and update the persona store.
   *
   * Load contacts from a file identified by its {@link File} and update
   * the persona store accordingly. Contacts are stored in the file as a
   * sequence of vCards, separated by blank lines.
   *
   * If a contact already exists in the store, its properties will be updated
   * from the vCard; otherwise it will be added as a new contact to the store.
   * Contacts which are in the store and not in the vCard will be removed from
   * the store.
   *
   * If this throws an error, it guarantees to leave the store’s internal state
   * unchanged, but may change the state of {@link Persona}s in the store.
   *
   * @param file the file where the contacts are stored
   * @throws IOError if there was an error communicating with D-Bus
   * @throws Error if the given file couldn’t be read
   *
   * @since 0.9.6
   */
static void
_folks_backends_blue_z_persona_store_update_contacts_from_file_ready (GObject* source_object,
                                                                      GAsyncResult* _res_,
                                                                      gpointer _user_data_)
{
	FolksBackendsBlueZPersonaStoreUpdateContactsFromFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_folks_backends_blue_z_persona_store_update_contacts_from_file_co (_data_);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static EVCardAttribute*
_vala_EVCardAttribute_copy (EVCardAttribute* self)
{
	return g_boxed_copy (e_vcard_attribute_get_type (), self);
}

static gpointer
__vala_EVCardAttribute_copy0 (gpointer self)
{
	return self ? _vala_EVCardAttribute_copy (self) : NULL;
}

static void
_vala_EVCardAttribute_free (EVCardAttribute* self)
{
	g_boxed_free (e_vcard_attribute_get_type (), self);
}

static gboolean
_folks_backends_blue_z_persona_store_update_contacts_from_file_co (FolksBackendsBlueZPersonaStoreUpdateContactsFromFileData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_hash_set_new (FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->added_personas = _data_->_tmp0_;
	_data_->_tmp1_ = gee_hash_set_new (FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->removed_personas = _data_->_tmp1_;
	_data_->photos_up_to_date = TRUE;
	_data_->_tmp2_ = g_file_get_path (_data_->file);
	_data_->_tmp3_ = _data_->_tmp2_;
	g_debug ("bluez-persona-store.vala:279: Parsing contacts from file ‘%s’.", _data_->_tmp3_);
	_g_free0 (_data_->_tmp3_);
	_data_->_tmp4_ = _data_->removed_personas;
	_data_->_tmp5_ = _data_->self->priv->_personas;
	_data_->_tmp6_ = gee_abstract_map_get_values ((GeeAbstractMap*) _data_->_tmp5_);
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp8_ = _data_->_tmp7_;
	gee_collection_add_all ((GeeCollection*) _data_->_tmp4_, _data_->_tmp8_);
	_g_object_unref0 (_data_->_tmp8_);
	{
		_data_->_tmp10_ = g_file_read (_data_->file, NULL, &_data_->_inner_error0_);
		_data_->_tmp9_ = _data_->_tmp10_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp11_ = g_data_input_stream_new ((GInputStream*) _data_->_tmp9_);
		_data_->dis = _data_->_tmp11_;
		_data_->i = (guint) 0;
		_data_->line = NULL;
		_data_->_tmp12_ = g_string_new ("");
		_data_->vcard = _data_->_tmp12_;
		_data_->_tmp13_ = g_string_new ("");
		_data_->vcard_without_photo = _data_->_tmp13_;
		while (TRUE) {
			_data_->_tmp15_ = _data_->dis;
			_data_->_state_ = 1;
			g_data_input_stream_read_line_async (_data_->_tmp15_, G_PRIORITY_DEFAULT, NULL, _folks_backends_blue_z_persona_store_update_contacts_from_file_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp16_ = g_data_input_stream_read_line_finish (_data_->_tmp15_, _data_->_res_, NULL, &_data_->_inner_error0_);
			_data_->_tmp14_ = _data_->_tmp16_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_string_free0 (_data_->vcard_without_photo);
				_g_string_free0 (_data_->vcard);
				_g_free0 (_data_->line);
				_g_object_unref0 (_data_->dis);
				_g_object_unref0 (_data_->_tmp9_);
				goto __catch0_g_error;
			}
			_data_->_tmp17_ = _data_->_tmp14_;
			_data_->_tmp14_ = NULL;
			_g_free0 (_data_->line);
			_data_->line = _data_->_tmp17_;
			_data_->_tmp18_ = _data_->line;
			if (!(_data_->_tmp18_ != NULL)) {
				_g_free0 (_data_->_tmp14_);
				break;
			}
			_data_->_tmp20_ = _data_->vcard;
			if (_data_->_tmp20_->len == ((gssize) 0)) {
				_data_->_tmp21_ = _data_->line;
				_data_->_tmp22_ = string_strip (_data_->_tmp21_);
				_data_->_tmp23_ = _data_->_tmp22_;
				_data_->_tmp19_ = g_strcmp0 (_data_->_tmp23_, "") == 0;
				_g_free0 (_data_->_tmp23_);
			} else {
				_data_->_tmp19_ = FALSE;
			}
			if (_data_->_tmp19_) {
				_g_free0 (_data_->_tmp14_);
				continue;
			}
			_data_->_tmp24_ = _data_->vcard;
			_data_->_tmp25_ = _data_->line;
			g_string_append (_data_->_tmp24_, _data_->_tmp25_);
			_data_->_tmp26_ = _data_->vcard;
			g_string_append_c (_data_->_tmp26_, '\n');
			_data_->_tmp28_ = _data_->line;
			if (!g_str_has_prefix (_data_->_tmp28_, "PHOTO:")) {
				_data_->_tmp29_ = _data_->line;
				_data_->_tmp27_ = !g_str_has_prefix (_data_->_tmp29_, "PHOTO;");
			} else {
				_data_->_tmp27_ = FALSE;
			}
			if (_data_->_tmp27_) {
				_data_->_tmp30_ = _data_->vcard_without_photo;
				_data_->_tmp31_ = _data_->line;
				g_string_append (_data_->_tmp30_, _data_->_tmp31_);
				_data_->_tmp32_ = _data_->vcard_without_photo;
				g_string_append_c (_data_->_tmp32_, '\n');
			}
			_data_->_tmp33_ = _data_->line;
			_data_->_tmp34_ = string_strip (_data_->_tmp33_);
			_data_->_tmp35_ = _data_->_tmp34_;
			_data_->_tmp36_ = g_strcmp0 (_data_->_tmp35_, "END:VCARD") == 0;
			_g_free0 (_data_->_tmp35_);
			if (_data_->_tmp36_) {
				_data_->_tmp37_ = _data_->vcard;
				_data_->_tmp38_ = _data_->_tmp37_->str;
				_data_->_tmp39_ = e_vcard_new_from_string (_data_->_tmp38_);
				_data_->card = _data_->_tmp39_;
				_data_->is_user = _data_->i == ((guint) 0);
				_data_->iid_is_checksum = FALSE;
				_data_->_tmp40_ = _data_->card;
				_data_->_tmp41_ = e_vcard_get_attribute (_data_->_tmp40_, "UID");
				_data_->_tmp42_ = __vala_EVCardAttribute_copy0 (_data_->_tmp41_);
				_data_->attribute = _data_->_tmp42_;
				_data_->_tmp43_ = _data_->attribute;
				if (_data_->_tmp43_ != NULL) {
					_data_->_tmp44_ = _data_->attribute;
					_data_->_tmp45_ = e_vcard_attribute_get_value_decoded (_data_->_tmp44_);
					_data_->_tmp46_ = _data_->_tmp45_;
					_data_->_tmp47_ = _data_->_tmp46_->str;
					_data_->_tmp48_ = g_strdup (_data_->_tmp47_);
					_g_free0 (_data_->iid);
					_data_->iid = _data_->_tmp48_;
					_g_string_free0 (_data_->_tmp46_);
				} else {
					_data_->_tmp49_ = _data_->vcard_without_photo;
					_data_->_tmp50_ = _data_->_tmp49_->str;
					_data_->_tmp51_ = g_compute_checksum_for_string (G_CHECKSUM_SHA1, _data_->_tmp50_, (gsize) -1);
					_g_free0 (_data_->iid);
					_data_->iid = _data_->_tmp51_;
					_data_->iid_is_checksum = TRUE;
				}
				_data_->_tmp52_ = _data_->self->priv->_personas;
				_data_->_tmp53_ = _data_->iid;
				_data_->_tmp54_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp52_, _data_->_tmp53_);
				_data_->persona = (FolksBackendsBlueZPersona*) _data_->_tmp54_;
				_data_->_tmp55_ = _data_->persona;
				if (_data_->_tmp55_ == NULL) {
					_data_->_tmp56_ = _data_->vcard;
					_data_->_tmp57_ = _data_->_tmp56_->str;
					_data_->_tmp58_ = _data_->card;
					_data_->_tmp59_ = _data_->iid;
					_data_->_tmp60_ = folks_backends_blue_z_persona_new (_data_->_tmp57_, _data_->_tmp58_, (FolksPersonaStore*) _data_->self, _data_->is_user, _data_->_tmp59_);
					_g_object_unref0 (_data_->persona);
					_data_->persona = _data_->_tmp60_;
					_data_->photos_up_to_date = FALSE;
				} else {
					if (_data_->iid_is_checksum == FALSE) {
						_data_->_tmp61_ = TRUE;
					} else {
						_data_->_tmp62_ = _data_->vcard_without_photo;
						_data_->_tmp63_ = _data_->vcard;
						_data_->_tmp61_ = _data_->_tmp62_->len != _data_->_tmp63_->len;
					}
					if (_data_->_tmp61_) {
						_data_->_tmp64_ = _data_->persona;
						_data_->_tmp65_ = _data_->card;
						if (folks_backends_blue_z_persona_update_from_vcard (_data_->_tmp64_, _data_->_tmp65_) == TRUE) {
							_data_->photos_up_to_date = FALSE;
						}
					}
				}
				_data_->_tmp66_ = _data_->removed_personas;
				_data_->_tmp67_ = _data_->persona;
				if (gee_abstract_collection_remove ((GeeAbstractCollection*) _data_->_tmp66_, _data_->_tmp67_) == FALSE) {
					_data_->_tmp68_ = _data_->added_personas;
					_data_->_tmp69_ = _data_->persona;
					gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp68_, _data_->_tmp69_);
				}
				_data_->_tmp70_ = _data_->i;
				_data_->i = _data_->_tmp70_ + 1;
				_data_->_tmp71_ = _data_->vcard;
				g_string_erase (_data_->_tmp71_, (gssize) 0, (gssize) -1);
				_data_->_tmp72_ = _data_->vcard_without_photo;
				g_string_erase (_data_->_tmp72_, (gssize) 0, (gssize) -1);
				_g_object_unref0 (_data_->persona);
				__vala_EVCardAttribute_free0 (_data_->attribute);
				_g_free0 (_data_->iid);
				_g_object_unref0 (_data_->card);
			}
			_g_free0 (_data_->_tmp14_);
		}
		_g_string_free0 (_data_->vcard_without_photo);
		_g_string_free0 (_data_->vcard);
		_g_free0 (_data_->line);
		_g_object_unref0 (_data_->dis);
		_g_object_unref0 (_data_->_tmp9_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e1 = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp73_ = _data_->e1;
		_data_->_tmp74_ = _data_->_tmp73_->message;
		_data_->_tmp75_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, _ ("Error reading the transferred address book file: %s"), _data_->_tmp74_);
		_data_->_inner_error0_ = _data_->_tmp75_;
		_g_error_free0 (_data_->e1);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == G_IO_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->removed_personas);
			_g_object_unref0 (_data_->added_personas);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->removed_personas);
			_g_object_unref0 (_data_->added_personas);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp76_ = _data_->added_personas;
	_data_->_tmp77_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp76_);
	_data_->_tmp78_ = _data_->_tmp77_;
	_data_->_tmp79_ = _data_->removed_personas;
	_data_->_tmp80_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp79_);
	_data_->_tmp81_ = _data_->_tmp80_;
	g_debug ("Finished parsing personas; now updating store state with %u " "added personas and %u removed personas.", _data_->_tmp78_, _data_->_tmp81_);
	{
		_data_->_tmp82_ = _data_->added_personas;
		_data_->_tmp83_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _data_->_tmp82_);
		_data_->_p_it = _data_->_tmp83_;
		while (TRUE) {
			_data_->_tmp84_ = _data_->_p_it;
			if (!gee_iterator_next (_data_->_tmp84_)) {
				break;
			}
			_data_->_tmp85_ = _data_->_p_it;
			_data_->_tmp86_ = gee_iterator_get (_data_->_tmp85_);
			_data_->p = (FolksBackendsBlueZPersona*) _data_->_tmp86_;
			_data_->_tmp87_ = _data_->self->priv->_personas;
			_data_->_tmp88_ = _data_->p;
			_data_->_tmp89_ = folks_persona_get_iid ((FolksPersona*) _data_->_tmp88_);
			_data_->_tmp90_ = _data_->_tmp89_;
			_data_->_tmp91_ = _data_->p;
			gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp87_, _data_->_tmp90_, _data_->_tmp91_);
			_g_object_unref0 (_data_->p);
		}
		_g_object_unref0 (_data_->_p_it);
	}
	{
		_data_->_tmp92_ = _data_->removed_personas;
		_data_->_tmp93_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _data_->_tmp92_);
		_data_->_vala1__p_it = _data_->_tmp93_;
		while (TRUE) {
			_data_->_tmp94_ = _data_->_vala1__p_it;
			if (!gee_iterator_next (_data_->_tmp94_)) {
				break;
			}
			_data_->_tmp95_ = _data_->_vala1__p_it;
			_data_->_tmp96_ = gee_iterator_get (_data_->_tmp95_);
			_data_->_vala1_p = (FolksBackendsBlueZPersona*) _data_->_tmp96_;
			_data_->_tmp97_ = _data_->self->priv->_personas;
			_data_->_tmp98_ = _data_->_vala1_p;
			_data_->_tmp99_ = folks_persona_get_iid ((FolksPersona*) _data_->_tmp98_);
			_data_->_tmp100_ = _data_->_tmp99_;
			gee_abstract_map_unset ((GeeAbstractMap*) _data_->_tmp97_, _data_->_tmp100_, NULL);
			_g_object_unref0 (_data_->_vala1_p);
		}
		_g_object_unref0 (_data_->_vala1__p_it);
	}
	_data_->self->priv->_photos_up_to_date = _data_->photos_up_to_date;
	_data_->_tmp102_ = _data_->added_personas;
	_data_->_tmp103_ = gee_collection_get_is_empty ((GeeCollection*) _data_->_tmp102_);
	_data_->_tmp104_ = _data_->_tmp103_;
	if (_data_->_tmp104_ == FALSE) {
		_data_->_tmp101_ = TRUE;
	} else {
		_data_->_tmp105_ = _data_->removed_personas;
		_data_->_tmp106_ = gee_collection_get_is_empty ((GeeCollection*) _data_->_tmp105_);
		_data_->_tmp107_ = _data_->_tmp106_;
		_data_->_tmp101_ = _data_->_tmp107_ == FALSE;
	}
	if (_data_->_tmp101_) {
		_data_->_tmp108_ = _data_->added_personas;
		_data_->_tmp109_ = _data_->removed_personas;
		_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) _data_->self, (GeeSet*) _data_->_tmp108_, (GeeSet*) _data_->_tmp109_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	}
	_g_object_unref0 (_data_->removed_personas);
	_g_object_unref0 (_data_->added_personas);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
   * Set the persona store's alias.
   *
   * This will be called in response to a property change sent to the Backend.
   *
   * @param alias the device’s new alias
   *
   * @since 0.9.6
   */
void
folks_backends_blue_z_persona_store_set_alias (FolksBackendsBlueZPersonaStore* self,
                                               const gchar* alias)
{
	const gchar* _tmp0_;
	orgbluezDevice* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (alias != NULL);
	_tmp0_ = self->priv->_display_name;
	_tmp1_ = self->priv->_device;
	_tmp2_ = org_bluez_device_get_address (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	g_debug ("bluez-persona-store.vala:420: Device ‘%s’ (%s) changed alias to ‘%s’.", _tmp0_, _tmp4_, alias);
	_g_free0 (_tmp4_);
	_tmp5_ = g_strdup (alias);
	_g_free0 (self->priv->_display_name);
	self->priv->_display_name = _tmp5_;
	g_object_notify ((GObject*) self, "display-name");
}

/**
   * Set the persona store's trust level.
   *
   * This will be called in response to a property change sent to the Backend.
   *
   * Default to partial trust. BlueZ persona UIDs are built from a SHA1
   * of the contact’s vCard, which we believe can’t be maliciously edited
   * to corrupt linking.
   *
   * The trust for each device is manually set by the user in the BlueZ
   * interface on the computer.
   *
   * @param trusted ``true`` if the user trusts the device, ``false`` otherwise
   *
   * @since 0.9.6
   */
void
folks_backends_blue_z_persona_store_set_is_trusted (FolksBackendsBlueZPersonaStore* self,
                                                    gboolean trusted)
{
	const gchar* _tmp0_ = NULL;
	orgbluezDevice* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	orgbluezDevice* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	FolksPersonaStoreTrust _tmp9_ = 0;
	g_return_if_fail (self != NULL);
	if (trusted) {
		_tmp0_ = "trusted";
	} else {
		_tmp0_ = "untrusted";
	}
	_tmp1_ = self->priv->_device;
	_tmp2_ = org_bluez_device_get_alias (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->_device;
	_tmp6_ = org_bluez_device_get_address (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	g_debug ("bluez-persona-store.vala:445: Device ‘%s’ (%s) marked as %s.", _tmp4_, _tmp8_, _tmp0_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp4_);
	if (trusted) {
		_tmp9_ = FOLKS_PERSONA_STORE_TRUST_FULL;
	} else {
		_tmp9_ = FOLKS_PERSONA_STORE_TRUST_PARTIAL;
	}
	folks_persona_store_set_trust_level ((FolksPersonaStore*) self, _tmp9_);
}

static void
folks_backends_blue_z_persona_store_set_connection_state_data_free (gpointer _data)
{
	FolksBackendsBlueZPersonaStoreSetConnectionStateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsBlueZPersonaStoreSetConnectionStateData, _data_);
}

void
folks_backends_blue_z_persona_store_set_connection_state (FolksBackendsBlueZPersonaStore* self,
                                                          gboolean connected,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_)
{
	FolksBackendsBlueZPersonaStoreSetConnectionStateData* _data_;
	FolksBackendsBlueZPersonaStore* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FolksBackendsBlueZPersonaStoreSetConnectionStateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_backends_blue_z_persona_store_set_connection_state_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->connected = connected;
	folks_backends_blue_z_persona_store_set_connection_state_co (_data_);
}

void
folks_backends_blue_z_persona_store_set_connection_state_finish (FolksBackendsBlueZPersonaStore* self,
                                                                 GAsyncResult* _res_,
                                                                 GError** error)
{
	FolksBackendsBlueZPersonaStoreSetConnectionStateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Set the persona store's connection state.
   *
   * This will be called in response to a property change sent to the Backend.
   *
   * If this throws an error, it guarantees to leave the store’s internal state
   * unchanged.
   *
   * @param connected ``true`` if the device is now connected, ``false``
   * otherwise
   *
   * @throws IOError if the operation was cancelled
   * (see {@link _update_contacts})
   * @throws PersonaStoreError if the contacts couldn’t be updated
   * (see {@link _update_contacts})
   *
   * @since 0.9.6
   */
static void
folks_backends_blue_z_persona_store_set_connection_state_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_)
{
	FolksBackendsBlueZPersonaStoreSetConnectionStateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_backends_blue_z_persona_store_set_connection_state_co (_data_);
}

static gboolean
folks_backends_blue_z_persona_store_set_connection_state_co (FolksBackendsBlueZPersonaStoreSetConnectionStateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->connected == TRUE) {
		_data_->_tmp0_ = _data_->self->priv->_device;
		_data_->_tmp1_ = org_bluez_device_get_alias (_data_->_tmp0_);
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = _data_->self->priv->_device;
		_data_->_tmp5_ = org_bluez_device_get_address (_data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = _data_->_tmp6_;
		g_debug ("bluez-persona-store.vala:475: Device ‘%s’ (%s) is connected.", _data_->_tmp3_, _data_->_tmp7_);
		_g_free0 (_data_->_tmp7_);
		_g_free0 (_data_->_tmp3_);
		_data_->_state_ = 1;
		_folks_backends_blue_z_persona_store_update_contacts (_data_->self, FALSE, folks_backends_blue_z_persona_store_set_connection_state_ready, _data_);
		return FALSE;
		_state_1:
		_folks_backends_blue_z_persona_store_update_contacts_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if ((_data_->_inner_error0_->domain == G_IO_ERROR) || (_data_->_inner_error0_->domain == FOLKS_PERSONA_STORE_ERROR)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	} else {
		_data_->_tmp8_ = _data_->self->priv->_device;
		_data_->_tmp9_ = org_bluez_device_get_alias (_data_->_tmp8_);
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_tmp12_ = _data_->self->priv->_device;
		_data_->_tmp13_ = org_bluez_device_get_address (_data_->_tmp12_);
		_data_->_tmp14_ = _data_->_tmp13_;
		_data_->_tmp15_ = _data_->_tmp14_;
		g_debug ("bluez-persona-store.vala:482: Device ‘%s’ (%s) is disconnected.", _data_->_tmp11_, _data_->_tmp15_);
		_g_free0 (_data_->_tmp15_);
		_g_free0 (_data_->_tmp11_);
		folks_backends_blue_z_persona_store_cancel_updates (_data_->self);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_folks_backends_blue_z_persona_store_new_obex_session_data_free (gpointer _data)
{
	FolksBackendsBlueZPersonaStoreNewObexSessionData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsBlueZPersonaStoreNewObexSessionData, _data_);
}

static void
_folks_backends_blue_z_persona_store_new_obex_session (FolksBackendsBlueZPersonaStore* self,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_)
{
	FolksBackendsBlueZPersonaStoreNewObexSessionData* _data_;
	FolksBackendsBlueZPersonaStore* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FolksBackendsBlueZPersonaStoreNewObexSessionData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, _folks_backends_blue_z_persona_store_new_obex_session_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_folks_backends_blue_z_persona_store_new_obex_session_co (_data_);
}

static char*
_folks_backends_blue_z_persona_store_new_obex_session_finish (FolksBackendsBlueZPersonaStore* self,
                                                              GAsyncResult* _res_,
                                                              orgbluezobexPhonebookAccess** obex_pbap,
                                                              GError** error)
{
	char* result;
	FolksBackendsBlueZPersonaStoreNewObexSessionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	if (obex_pbap) {
		*obex_pbap = _data_->obex_pbap;
	} else {
		_g_object_unref0 (_data_->obex_pbap);
	}
	_data_->obex_pbap = NULL;
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
   * Create a new obex session for this Persona store.
   *
   * Create a new obex session for this Persona store if no previous session
   * already exists.
   *
   * @param obex_pbap return location for an OBEX PBAP proxy object
   * @returns the path of the OBEX session D-Bus object
   * @throws IOError if it can't connect to D-Bus
   * @throws DBusError if it can't create a new OBEX session
   *
   * @since 0.9.6
   */
static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static GVariant*
_variant_new1 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
_folks_backends_blue_z_persona_store_new_obex_session_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_)
{
	FolksBackendsBlueZPersonaStoreNewObexSessionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_folks_backends_blue_z_persona_store_new_obex_session_co (_data_);
}

static gboolean
_folks_backends_blue_z_persona_store_new_obex_session_co (FolksBackendsBlueZPersonaStoreNewObexSessionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("bluez-persona-store.vala:507: Creating a new OBEX session.");
	_data_->_tmp0_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
	_data_->args = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->args;
	_data_->_tmp2_ = g_strdup ("Target");
	_data_->_tmp3_ = _variant_new1 ("PBAP");
	g_hash_table_insert (_data_->_tmp1_, _data_->_tmp2_, _data_->_tmp3_);
	_data_->_tmp4_ = _data_->self->priv->_obex_client;
	_data_->_tmp5_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = _data_->args;
	_data_->_state_ = 1;
	org_bluez_obex_client_create_session (_data_->_tmp4_, _data_->_tmp6_, _data_->_tmp7_, _folks_backends_blue_z_persona_store_new_obex_session_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp8_ = org_bluez_obex_client_create_session_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
	_data_->session_path = _data_->_tmp8_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if ((_data_->_inner_error0_->domain == G_DBUS_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_hash_table_unref0 (_data_->args);
			_g_object_unref0 (_data_->obex_pbap);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_hash_table_unref0 (_data_->args);
			_g_object_unref0 (_data_->obex_pbap);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp9_ = _data_->session_path;
	g_debug ("bluez-persona-store.vala:514:     Got OBEX session path: %s", (const gchar*) _data_->_tmp9_);
	_data_->_tmp11_ = _data_->session_path;
	_data_->_state_ = 2;
	g_async_initable_new_async (ORG_BLUEZ_OBEX_TYPE_PHONEBOOK_ACCESS_PROXY, 0, NULL, _folks_backends_blue_z_persona_store_new_obex_session_ready, _data_, "g-flags", 0, "g-name", "org.bluez.obex", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", (const gchar*) _data_->_tmp11_, "g-interface-name", "org.bluez.obex.PhonebookAccess1", NULL);
	return FALSE;
	_state_2:
	_data_->_tmp12_ = (orgbluezobexPhonebookAccess*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp10_ = (orgbluezobexPhonebookAccess*) _data_->_tmp12_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if ((_data_->_inner_error0_->domain == G_DBUS_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->session_path);
			_g_hash_table_unref0 (_data_->args);
			_g_object_unref0 (_data_->obex_pbap);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_free0 (_data_->session_path);
			_g_hash_table_unref0 (_data_->args);
			_g_object_unref0 (_data_->obex_pbap);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp13_ = _data_->_tmp10_;
	_data_->_tmp10_ = NULL;
	_g_object_unref0 (_data_->obex_pbap);
	_data_->obex_pbap = _data_->_tmp13_;
	_data_->_tmp14_ = _data_->obex_pbap;
	g_debug ("bluez-persona-store.vala:519:     Got OBEX PBAP proxy: %p", _data_->_tmp14_);
	_data_->result = _data_->session_path;
	_g_object_unref0 (_data_->_tmp10_);
	_g_hash_table_unref0 (_data_->args);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_folks_backends_blue_z_persona_store_remove_obex_session_data_free (gpointer _data)
{
	FolksBackendsBlueZPersonaStoreRemoveObexSessionData* _data_;
	_data_ = _data;
	_g_free0 (_data_->session_path);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsBlueZPersonaStoreRemoveObexSessionData, _data_);
}

static void
_folks_backends_blue_z_persona_store_remove_obex_session (FolksBackendsBlueZPersonaStore* self,
                                                          const char* session_path,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_)
{
	FolksBackendsBlueZPersonaStoreRemoveObexSessionData* _data_;
	FolksBackendsBlueZPersonaStore* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (session_path != NULL);
	_data_ = g_slice_new0 (FolksBackendsBlueZPersonaStoreRemoveObexSessionData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, _folks_backends_blue_z_persona_store_remove_obex_session_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (session_path);
	_g_free0 (_data_->session_path);
	_data_->session_path = _tmp1_;
	_folks_backends_blue_z_persona_store_remove_obex_session_co (_data_);
}

static void
_folks_backends_blue_z_persona_store_remove_obex_session_finish (FolksBackendsBlueZPersonaStore* self,
                                                                 GAsyncResult* _res_)
{
	FolksBackendsBlueZPersonaStoreRemoveObexSessionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
   * Remove the specified OBEX session from this persona store.
   *
   * Remove the specified OBEX session for this persona store and discard its
   * transfer.
   *
   * @param session_path the path of the OBEX session D-Bus object to remove
   *
   * @since 0.9.6
   */
static void
_folks_backends_blue_z_persona_store_remove_obex_session_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_)
{
	FolksBackendsBlueZPersonaStoreRemoveObexSessionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_folks_backends_blue_z_persona_store_remove_obex_session_co (_data_);
}

static gboolean
_folks_backends_blue_z_persona_store_remove_obex_session_co (FolksBackendsBlueZPersonaStoreRemoveObexSessionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_obex_client;
		_data_->_state_ = 1;
		org_bluez_obex_client_remove_session (_data_->_tmp0_, _data_->session_path, _folks_backends_blue_z_persona_store_remove_obex_session_ready, _data_);
		return FALSE;
		_state_1:
		org_bluez_obex_client_remove_session_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			if (_data_->_inner_error0_->domain == G_DBUS_ERROR) {
				goto __catch0_g_dbus_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		_data_->ie = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp2_ = _data_->ie;
		if (g_error_matches (_data_->_tmp2_, G_IO_ERROR, G_IO_ERROR_CLOSED)) {
			_data_->_tmp1_ = TRUE;
		} else {
			_data_->_tmp3_ = _data_->ie;
			_data_->_tmp1_ = g_error_matches (_data_->_tmp3_, G_IO_ERROR, G_IO_ERROR_CANCELLED);
		}
		if (_data_->_tmp1_) {
			_g_error_free0 (_data_->ie);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp5_ = _data_->ie;
		if (g_error_matches (_data_->_tmp5_, G_IO_ERROR, G_IO_ERROR_DBUS_ERROR)) {
			_data_->_tmp6_ = _data_->ie;
			_data_->_tmp7_ = _data_->_tmp6_->message;
			_data_->_tmp4_ = g_str_has_prefix (_data_->_tmp7_, "GDBus.Error:org.freedesktop.DBus." "Python.dbus.exceptions.DBusException: " "('org.freedesktop.DBus.Mock.NameError'");
		} else {
			_data_->_tmp4_ = FALSE;
		}
		if (_data_->_tmp4_) {
			_g_error_free0 (_data_->ie);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp8_ = _data_->ie;
		_data_->_tmp9_ = _data_->_tmp8_->message;
		g_warning ("bluez-persona-store.vala:555: Couldn’t remove OBEX session ‘%s’: %s", (const gchar*) _data_->session_path, _data_->_tmp9_);
		_g_error_free0 (_data_->ie);
	}
	goto __finally0;
	__catch0_g_dbus_error:
	{
		_data_->de = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp10_ = _data_->de;
		_data_->_tmp11_ = _data_->_tmp10_->message;
		g_warning ("bluez-persona-store.vala:560: Couldn’t remove OBEX session ‘%s’: %s", (const gchar*) _data_->session_path, _data_->_tmp11_);
		_g_error_free0 (_data_->de);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_folks_backends_blue_z_persona_store_perform_obex_transfer_data_free (gpointer _data)
{
	FolksBackendsBlueZPersonaStorePerformObexTransferData* _data_;
	_data_ = _data;
	_g_free0 (_data_->path);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsBlueZPersonaStorePerformObexTransferData, _data_);
}

static void
_folks_backends_blue_z_persona_store_perform_obex_transfer (FolksBackendsBlueZPersonaStore* self,
                                                            const gchar* path,
                                                            GCancellable* cancellable,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_)
{
	FolksBackendsBlueZPersonaStorePerformObexTransferData* _data_;
	FolksBackendsBlueZPersonaStore* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_data_ = g_slice_new0 (FolksBackendsBlueZPersonaStorePerformObexTransferData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, _folks_backends_blue_z_persona_store_perform_obex_transfer_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (path);
	_g_free0 (_data_->path);
	_data_->path = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	_folks_backends_blue_z_persona_store_perform_obex_transfer_co (_data_);
}

static void
_folks_backends_blue_z_persona_store_perform_obex_transfer_finish (FolksBackendsBlueZPersonaStore* self,
                                                                   GAsyncResult* _res_,
                                                                   GError** error)
{
	FolksBackendsBlueZPersonaStorePerformObexTransferData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Watch an OBEX transfer identified by its D-Bus path.
   *
   * This only returns once the transfer is complete (or has failed) and the
   * transfer object has been destroyed.
   *
   * If this throws an error, it guarantees to leave the store’s internal state
   * unchanged.
   *
   * @param path the D-Bus transfer object path to watch.
   * @param cancellable an optional {@link Cancellable} object to cancel the
   * transfer
   *
   * @throws IOError if the operation was cancelled, or if another failure
   * occurred (unavoidable; valac generates invalid C if we try to handle
   * IOError internally here)
   * @throws PersonaStoreError if the transfer failed
   *
   * @since 0.9.6
   */
static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		FolksBackendsBlueZPersonaStore* self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		FolksBackendsBlueZPersonaStore* self;
		self = _data3_->_data2_->self;
		_g_free0 (_data3_->transfer_status);
		block2_data_unref (_data3_->_data2_);
		_data3_->_data2_ = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}

static void
_folks_backends_blue_z_persona_store_perform_obex_transfer_ready (GObject* source_object,
                                                                  GAsyncResult* _res_,
                                                                  gpointer _user_data_)
{
	FolksBackendsBlueZPersonaStorePerformObexTransferData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_folks_backends_blue_z_persona_store_perform_obex_transfer_co (_data_);
}

static void
____lambda4_ (Block3Data* _data3_)
{
	Block2Data* _data2_;
	FolksBackendsBlueZPersonaStore* self;
	gchar* _tmp0_;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	_tmp0_ = g_strdup ("error");
	_g_free0 (_data3_->transfer_status);
	_data3_->transfer_status = _tmp0_;
	if (_data3_->has_yielded == TRUE) {
		_folks_backends_blue_z_persona_store_perform_obex_transfer_co (_data2_->_async_data_);
	}
}

static void
_____lambda4__gfunc (gconstpointer data,
                     gpointer self)
{
	____lambda4_ (self);
}

static void
___lambda5_ (Block3Data* _data3_,
             GVariant* changed,
             gchar** invalidated)
{
	Block2Data* _data2_;
	FolksBackendsBlueZPersonaStore* self;
	GVariant* property = NULL;
	const GVariantType* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	gchar* status = NULL;
	GVariant* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	g_return_if_fail (changed != NULL);
	_tmp0_ = G_VARIANT_TYPE_STRING;
	_tmp1_ = g_variant_lookup_value (changed, "Status", _tmp0_);
	property = _tmp1_;
	_tmp2_ = property;
	if (_tmp2_ == NULL) {
		_g_variant_unref0 (property);
		return;
	}
	_tmp3_ = property;
	_tmp4_ = g_variant_get_string (_tmp3_, NULL);
	_tmp5_ = g_strdup (_tmp4_);
	status = _tmp5_;
	_tmp6_ = status;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 (_data3_->transfer_status);
	_data3_->transfer_status = _tmp7_;
	_tmp9_ = status;
	if (g_strcmp0 (_tmp9_, "complete") == 0) {
		_tmp8_ = TRUE;
	} else {
		const gchar* _tmp10_;
		_tmp10_ = status;
		_tmp8_ = g_strcmp0 (_tmp10_, "error") == 0;
	}
	if (_tmp8_) {
		if (_data3_->has_yielded == TRUE) {
			_folks_backends_blue_z_persona_store_perform_obex_transfer_co (_data2_->_async_data_);
		}
	} else {
		gboolean _tmp11_ = FALSE;
		const gchar* _tmp12_;
		_tmp12_ = status;
		if (g_strcmp0 (_tmp12_, "queued") == 0) {
			_tmp11_ = TRUE;
		} else {
			const gchar* _tmp13_;
			_tmp13_ = status;
			_tmp11_ = g_strcmp0 (_tmp13_, "active") == 0;
		}
		if (_tmp11_) {
		} else {
			const gchar* _tmp14_;
			_tmp14_ = status;
			g_warning ("bluez-persona-store.vala:647: Unknown OBEX transfer status ‘%s’.", _tmp14_);
		}
	}
	_g_free0 (status);
	_g_variant_unref0 (property);
}

static void
____lambda5__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                GVariant* changed_properties,
                                                gchar** invalidated_properties,
                                                gpointer self)
{
	___lambda5_ (self, changed_properties, invalidated_properties);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		FolksBackendsBlueZPersonaStore* self;
		self = _data4_->_data2_->self;
		_g_object_unref0 (_data4_->file);
		block2_data_unref (_data4_->_data2_);
		_data4_->_data2_ = NULL;
		g_slice_free (Block4Data, _data4_);
	}
}

static void
____lambda6_ (Block4Data* _data4_,
              GObject* o,
              GAsyncResult* r)
{
	Block2Data* _data2_;
	FolksBackendsBlueZPersonaStore* self;
	GError* _inner_error0_ = NULL;
	_data2_ = _data4_->_data2_;
	self = _data2_->self;
	g_return_if_fail (r != NULL);
	{
		GFile* _tmp0_;
		_tmp0_ = _data4_->file;
		g_file_delete_finish (_tmp0_, r, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_____lambda6__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	____lambda6_ (self, source_object, res);
	block4_data_unref (self);
}

static gboolean
_folks_backends_blue_z_persona_store_perform_obex_transfer_co (FolksBackendsBlueZPersonaStorePerformObexTransferData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data2_ = g_slice_new0 (Block2Data);
	_data_->_data2_->_ref_count_ = 1;
	_data_->_data2_->self = g_object_ref (_data_->self);
	_data_->_data2_->_async_data_ = _data_;
	_data_->transfer = NULL;
	{
		_data_->_data3_ = g_slice_new0 (Block3Data);
		_data_->_data3_->_ref_count_ = 1;
		_data_->_data3_->_data2_ = block2_data_ref (_data_->_data2_);
		if (_data_->cancellable != NULL) {
			g_cancellable_set_error_if_cancelled (_data_->cancellable, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				block3_data_unref (_data_->_data3_);
				_data_->_data3_ = NULL;
				goto __finally0;
			}
		}
		_data_->_state_ = 1;
		g_async_initable_new_async (ORG_BLUEZ_OBEX_TYPE_TRANSFER_PROXY, 0, NULL, _folks_backends_blue_z_persona_store_perform_obex_transfer_ready, _data_, "g-flags", 0, "g-name", "org.bluez.obex", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _data_->path, "g-interface-name", "org.bluez.obex.Transfer1", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = (orgbluezobexTransfer*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = (orgbluezobexTransfer*) _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			block3_data_unref (_data_->_data3_);
			_data_->_data3_ = NULL;
			goto __finally0;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->transfer);
		_data_->transfer = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->transfer;
		_data_->_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, g_dbus_proxy_get_type (), GDBusProxy));
		_data_->transfer_proxy = _data_->_tmp4_;
		_data_->_data3_->has_yielded = FALSE;
		_data_->_data3_->transfer_status = NULL;
		_data_->cancellable_id = (gulong) 0;
		_data_->_tmp5_ = _data_->transfer;
		_data_->_tmp6_ = org_bluez_obex_transfer_get_status (_data_->_tmp5_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_g_free0 (_data_->_data3_->transfer_status);
		_data_->_data3_->transfer_status = _data_->_tmp7_;
		if (_data_->cancellable != NULL) {
			_data_->cancellable_id = g_cancellable_connect (_data_->cancellable, (GCallback) _____lambda4__gfunc, block3_data_ref (_data_->_data3_), block3_data_unref);
		}
		_data_->_tmp8_ = _data_->transfer_proxy;
		_data_->_tmp9_ = g_signal_connect_data (_data_->_tmp8_, "g-properties-changed", (GCallback) ____lambda5__g_dbus_proxy_g_properties_changed, block3_data_ref (_data_->_data3_), (GClosureNotify) block3_data_unref, 0);
		_data_->signal_id = _data_->_tmp9_;
		_data_->_tmp11_ = _data_->_data3_->transfer_status;
		if (g_strcmp0 (_data_->_tmp11_, "complete") != 0) {
			_data_->_tmp12_ = _data_->_data3_->transfer_status;
			_data_->_tmp10_ = g_strcmp0 (_data_->_tmp12_, "error") != 0;
		} else {
			_data_->_tmp10_ = FALSE;
		}
		if (_data_->_tmp10_) {
			_data_->_data3_->has_yielded = TRUE;
			_data_->_state_ = 2;
			return FALSE;
			_state_2:
			;
		}
		_data_->_tmp13_ = _data_->transfer_proxy;
		g_signal_handler_disconnect ((GObject*) _data_->_tmp13_, _data_->signal_id);
		if (_data_->cancellable_id != ((gulong) 0)) {
			g_cancellable_disconnect (_data_->cancellable, _data_->cancellable_id);
		}
		_data_->_tmp14_ = _data_->_data3_->transfer_status;
		if (g_strcmp0 (_data_->_tmp14_, "complete") == 0) {
			_data_->_tmp15_ = _data_->transfer;
			_data_->_tmp16_ = org_bluez_obex_transfer_get_filename (_data_->_tmp15_);
			_data_->_tmp17_ = _data_->_tmp16_;
			_data_->filename = _data_->_tmp17_;
			_data_->_tmp18_ = _data_->filename;
			if (_data_->_tmp18_ == NULL) {
				_data_->_tmp19_ = _data_->transfer;
				_data_->_tmp20_ = org_bluez_obex_transfer_get_name (_data_->_tmp19_);
				_data_->_tmp21_ = _data_->_tmp20_;
				_data_->_tmp22_ = _data_->_tmp21_;
				_data_->_tmp23_ = _data_->self->priv->_display_name;
				_data_->_tmp24_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE, _ ("Error during transfer of the address book ‘%s’ from " "Bluetooth device ‘%s’."), _data_->_tmp22_, _data_->_tmp23_);
				_data_->_tmp25_ = _data_->_tmp24_;
				_g_free0 (_data_->_tmp22_);
				_data_->_inner_error0_ = _data_->_tmp25_;
				_g_free0 (_data_->filename);
				_g_object_unref0 (_data_->transfer_proxy);
				_g_object_unref0 (_data_->_tmp0_);
				block3_data_unref (_data_->_data3_);
				_data_->_data3_ = NULL;
				goto __finally0;
			}
			_data_->_tmp26_ = _data_->filename;
			_data_->_tmp27_ = g_file_new_for_path ((const gchar*) _data_->_tmp26_);
			_data_->file = _data_->_tmp27_;
			_data_->_tmp28_ = _data_->self->priv->_display_name;
			_data_->_tmp29_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
			_data_->_tmp30_ = _data_->_tmp29_;
			_data_->_tmp31_ = _data_->filename;
			g_debug ("bluez-persona-store.vala:683: vCard’s filename for device ‘%s’ (%s): %" \
"s", _data_->_tmp28_, _data_->_tmp30_, (const gchar*) _data_->_tmp31_);
			_data_->_tmp32_ = _data_->file;
			_data_->_state_ = 3;
			_folks_backends_blue_z_persona_store_update_contacts_from_file (_data_->self, _data_->_tmp32_, _folks_backends_blue_z_persona_store_perform_obex_transfer_ready, _data_);
			return FALSE;
			_state_3:
			_folks_backends_blue_z_persona_store_update_contacts_from_file_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->file);
				_g_free0 (_data_->filename);
				_g_object_unref0 (_data_->transfer_proxy);
				_g_object_unref0 (_data_->_tmp0_);
				block3_data_unref (_data_->_data3_);
				_data_->_data3_ = NULL;
				goto __finally0;
			}
			_g_object_unref0 (_data_->file);
			_g_free0 (_data_->filename);
		} else {
			_data_->_tmp33_ = _data_->_data3_->transfer_status;
			if (g_strcmp0 (_data_->_tmp33_, "error") == 0) {
				if (_data_->cancellable != NULL) {
					g_cancellable_set_error_if_cancelled (_data_->cancellable, &_data_->_inner_error0_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						_g_object_unref0 (_data_->transfer_proxy);
						_g_object_unref0 (_data_->_tmp0_);
						block3_data_unref (_data_->_data3_);
						_data_->_data3_ = NULL;
						goto __finally0;
					}
				}
				_data_->_tmp34_ = _data_->transfer;
				_data_->_tmp35_ = org_bluez_obex_transfer_get_name (_data_->_tmp34_);
				_data_->_tmp36_ = _data_->_tmp35_;
				_data_->_tmp37_ = _data_->_tmp36_;
				_data_->_tmp38_ = _data_->self->priv->_display_name;
				_data_->_tmp39_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE, _ ("Error during transfer of the address book ‘%s’ from Bluetooth device ‘" \
"%s’."), _data_->_tmp37_, _data_->_tmp38_);
				_data_->_tmp40_ = _data_->_tmp39_;
				_g_free0 (_data_->_tmp37_);
				_data_->_inner_error0_ = _data_->_tmp40_;
				_g_object_unref0 (_data_->transfer_proxy);
				_g_object_unref0 (_data_->_tmp0_);
				block3_data_unref (_data_->_data3_);
				_data_->_data3_ = NULL;
				goto __finally0;
			} else {
				g_assert_not_reached ();
			}
		}
		_g_object_unref0 (_data_->transfer_proxy);
		_g_object_unref0 (_data_->_tmp0_);
		block3_data_unref (_data_->_data3_);
		_data_->_data3_ = NULL;
	}
	__finally0:
	{
		_data_->_tmp42_ = _data_->transfer;
		if (_data_->_tmp42_ != NULL) {
			_data_->_tmp43_ = _data_->transfer;
			_data_->_tmp44_ = org_bluez_obex_transfer_get_filename (_data_->_tmp43_);
			_data_->_tmp45_ = _data_->_tmp44_;
			_data_->_tmp46_ = _data_->_tmp45_;
			_data_->_tmp41_ = _data_->_tmp46_ != NULL;
			_g_free0 (_data_->_tmp46_);
		} else {
			_data_->_tmp41_ = FALSE;
		}
		if (_data_->_tmp41_) {
			_data_->_data4_ = g_slice_new0 (Block4Data);
			_data_->_data4_->_ref_count_ = 1;
			_data_->_data4_->_data2_ = block2_data_ref (_data_->_data2_);
			_data_->_tmp47_ = _data_->transfer;
			_data_->_tmp48_ = org_bluez_obex_transfer_get_filename (_data_->_tmp47_);
			_data_->_tmp49_ = _data_->_tmp48_;
			_data_->_tmp50_ = _data_->_tmp49_;
			_data_->_tmp51_ = g_file_new_for_path (_data_->_tmp50_);
			_data_->_tmp52_ = _data_->_tmp51_;
			_g_free0 (_data_->_tmp50_);
			_data_->_data4_->file = _data_->_tmp52_;
			_data_->_tmp53_ = _data_->_data4_->file;
			g_file_delete_async (_data_->_tmp53_, G_PRIORITY_DEFAULT, NULL, _____lambda6__gasync_ready_callback, block4_data_ref (_data_->_data4_));
			block4_data_unref (_data_->_data4_);
			_data_->_data4_ = NULL;
		}
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if ((_data_->_inner_error0_->domain == G_IO_ERROR) || (_data_->_inner_error0_->domain == FOLKS_PERSONA_STORE_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->transfer);
			block2_data_unref (_data_->_data2_);
			_data_->_data2_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->transfer);
			block2_data_unref (_data_->_data2_);
			_data_->_data2_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->transfer);
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_folks_backends_blue_z_persona_store_update_contacts_data_free (gpointer _data)
{
	FolksBackendsBlueZPersonaStoreUpdateContactsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsBlueZPersonaStoreUpdateContactsData, _data_);
}

static void
_folks_backends_blue_z_persona_store_update_contacts (FolksBackendsBlueZPersonaStore* self,
                                                      gboolean download_photos,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_)
{
	FolksBackendsBlueZPersonaStoreUpdateContactsData* _data_;
	FolksBackendsBlueZPersonaStore* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FolksBackendsBlueZPersonaStoreUpdateContactsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, _folks_backends_blue_z_persona_store_update_contacts_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->download_photos = download_photos;
	_folks_backends_blue_z_persona_store_update_contacts_co (_data_);
}

static void
_folks_backends_blue_z_persona_store_update_contacts_finish (FolksBackendsBlueZPersonaStore* self,
                                                             GAsyncResult* _res_,
                                                             GError** error)
{
	FolksBackendsBlueZPersonaStoreUpdateContactsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Update contacts from this persona store.
   *
   * Update contacts from this persona store by initiating a new OBEX
   * transfer, unless one is already in progress. If a transfer is already in
   * progress, leave it running and return immediately.
   *
   * If this throws an error, it guarantees to leave the store’s internal state
   * unchanged, apart from scheduling a new update operation to happen in the
   * future. This will always happen, regardless of success or failure.
   *
   * @param download_photos whether to download photos
   * @throws IOError if the operation was cancelled
   * @throws PersonaStoreError if the contacts couldn’t be downloaded from the
   * device
   *
   * @since 0.9.6
   */
static void
_folks_backends_blue_z_persona_store_update_contacts_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_)
{
	FolksBackendsBlueZPersonaStoreUpdateContactsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_folks_backends_blue_z_persona_store_update_contacts_co (_data_);
}

static GVariant*
_variant_new2 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
_folks_backends_blue_z_persona_store_update_contacts_co (FolksBackendsBlueZPersonaStoreUpdateContactsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->session_path = NULL;
	_data_->obex_pbap = NULL;
	_data_->success = TRUE;
	{
		_data_->_tmp0_ = _data_->self->priv->_update_contacts_cancellable;
		if (_data_->_tmp0_ != NULL) {
			g_debug ("bluez-persona-store.vala:763: Not updating contacts due to ongoing upd" \
"ate operation.");
			{
				_data_->_tmp1_ = _data_->session_path;
				if (_data_->_tmp1_ != NULL) {
					_data_->_tmp2_ = _data_->session_path;
					_folks_backends_blue_z_persona_store_remove_obex_session (_data_->self, _data_->_tmp2_, NULL, NULL);
				}
				_g_object_unref0 (_data_->obex_pbap);
				_data_->obex_pbap = NULL;
				_g_object_unref0 (_data_->self->priv->_update_contacts_cancellable);
				_data_->self->priv->_update_contacts_cancellable = NULL;
				if (_data_->success == TRUE) {
					_data_->self->priv->_update_contacts_failures = (guint) 0;
				} else {
					_data_->_tmp3_ = _data_->self->priv->_update_contacts_failures;
					_data_->self->priv->_update_contacts_failures = _data_->_tmp3_ + 1;
				}
				if (_data_->success == TRUE) {
					_data_->_tmp4_ = _data_->self->priv->_photos_up_to_date == FALSE;
				} else {
					_data_->_tmp4_ = FALSE;
				}
				_data_->new_download_photos = _data_->_tmp4_;
				_folks_backends_blue_z_persona_store_schedule_update_contacts (_data_->self, _data_->new_download_photos);
				_data_->_tmp5_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
				_data_->_tmp6_ = _data_->_tmp5_;
				folks_internal_profiling_end ("updating BlueZ.PersonaStore (ID: %s) " "contacts", _data_->_tmp6_, NULL);
			}
			_g_object_unref0 (_data_->obex_pbap);
			_g_free0 (_data_->session_path);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp7_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
		_data_->_tmp8_ = _data_->_tmp7_;
		folks_internal_profiling_start ("updating BlueZ.PersonaStore (ID: %s) " "contacts", _data_->_tmp8_, NULL);
		g_debug ("bluez-persona-store.vala:770: Updating contacts.");
		_data_->_tmp9_ = g_cancellable_new ();
		_g_object_unref0 (_data_->self->priv->_update_contacts_cancellable);
		_data_->self->priv->_update_contacts_cancellable = _data_->_tmp9_;
		{
			_data_->_tmp11_ = NULL;
			_data_->_state_ = 1;
			_folks_backends_blue_z_persona_store_new_obex_session (_data_->self, _folks_backends_blue_z_persona_store_update_contacts_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp12_ = _folks_backends_blue_z_persona_store_new_obex_session_finish (_data_->self, _data_->_res_, &_data_->_tmp11_, &_data_->_inner_error0_);
			_g_object_unref0 (_data_->obex_pbap);
			_data_->obex_pbap = _data_->_tmp11_;
			_data_->_tmp10_ = _data_->_tmp12_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_data_->_tmp13_ = _data_->_tmp10_;
			_data_->_tmp10_ = NULL;
			_g_free0 (_data_->session_path);
			_data_->session_path = _data_->_tmp13_;
			_g_free0 (_data_->_tmp10_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->e1 = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp15_ = _data_->e1;
			if (g_error_matches (_data_->_tmp15_, G_IO_ERROR, G_IO_ERROR_DBUS_ERROR)) {
				_data_->_tmp16_ = _data_->e1;
				_data_->_tmp17_ = _data_->_tmp16_->message;
				_data_->_tmp14_ = g_str_has_suffix (_data_->_tmp17_, "OBEX Connect failed with 0x43");
			} else {
				_data_->_tmp14_ = FALSE;
			}
			if (_data_->_tmp14_) {
				_data_->_tmp18_ = _data_->self->priv->_device;
				_data_->_tmp19_ = org_bluez_device_get_alias (_data_->_tmp18_);
				_data_->_tmp20_ = _data_->_tmp19_;
				_data_->_tmp21_ = _data_->_tmp20_;
				_data_->_tmp22_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_PERMISSION_DENIED, _ ("Permission to access the address book on Bluetooth device ‘%s’ was den" \
"ied by the user."), _data_->_tmp21_);
				_data_->_tmp23_ = _data_->_tmp22_;
				_g_free0 (_data_->_tmp21_);
				_data_->_inner_error0_ = _data_->_tmp23_;
				_g_error_free0 (_data_->e1);
				goto __finally1;
			}
			_data_->_tmp24_ = _data_->self->priv->_device;
			_data_->_tmp25_ = org_bluez_device_get_alias (_data_->_tmp24_);
			_data_->_tmp26_ = _data_->_tmp25_;
			_data_->_tmp27_ = _data_->_tmp26_;
			_data_->_tmp28_ = _data_->e1;
			_data_->_tmp29_ = _data_->_tmp28_->message;
			_data_->_tmp30_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE, _ ("An OBEX address book transfer from device ‘%s’ could not be started: %" \
"s"), _data_->_tmp27_, _data_->_tmp29_);
			_data_->_tmp31_ = _data_->_tmp30_;
			_g_free0 (_data_->_tmp27_);
			_data_->_inner_error0_ = _data_->_tmp31_;
			_g_error_free0 (_data_->e1);
			goto __finally1;
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_hash_table_unref0 (_data_->props);
			_g_free0 (_data_->path);
			if (_data_->_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			if (_data_->_inner_error0_->domain == FOLKS_PERSONA_STORE_ERROR) {
				goto __catch0_folks_persona_store_error;
			}
			_g_object_unref0 (_data_->obex_pbap);
			_g_free0 (_data_->session_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		{
			_data_->_tmp32_ = _data_->obex_pbap;
			org_bluez_obex_phonebook_access_select (_data_->_tmp32_, "int", "PB", &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
			_data_->_tmp33_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
			_data_->phonebook_filter = _data_->_tmp33_;
			_data_->_tmp34_ = _data_->phonebook_filter;
			_data_->_tmp35_ = g_strdup ("Format");
			_data_->_tmp36_ = _variant_new2 ("Vcard30");
			g_hash_table_insert (_data_->_tmp34_, _data_->_tmp35_, _data_->_tmp36_);
			if (_data_->download_photos == TRUE) {
				_data_->_tmp37_ = _data_->phonebook_filter;
				_data_->_tmp38_ = g_strdup ("Fields");
				_data_->_tmp39_ = g_strdup ("UID");
				_data_->_tmp40_ = g_strdup ("N");
				_data_->_tmp41_ = g_strdup ("FN");
				_data_->_tmp42_ = g_strdup ("NICKNAME");
				_data_->_tmp43_ = g_strdup ("TEL");
				_data_->_tmp44_ = g_strdup ("URL");
				_data_->_tmp45_ = g_strdup ("EMAIL");
				_data_->_tmp46_ = g_strdup ("PHOTO");
				_data_->_tmp47_ = g_new0 (gchar*, 8 + 1);
				_data_->_tmp47_[0] = _data_->_tmp39_;
				_data_->_tmp47_[1] = _data_->_tmp40_;
				_data_->_tmp47_[2] = _data_->_tmp41_;
				_data_->_tmp47_[3] = _data_->_tmp42_;
				_data_->_tmp47_[4] = _data_->_tmp43_;
				_data_->_tmp47_[5] = _data_->_tmp44_;
				_data_->_tmp47_[6] = _data_->_tmp45_;
				_data_->_tmp47_[7] = _data_->_tmp46_;
				_data_->_tmp48_ = _data_->_tmp47_;
				_data_->_tmp48__length1 = 8;
				_data_->_tmp49_ = g_variant_new_strv (_data_->_tmp48_, 8);
				g_variant_ref_sink (_data_->_tmp49_);
				g_hash_table_insert (_data_->_tmp37_, _data_->_tmp38_, _data_->_tmp49_);
				_data_->_tmp48_ = (_vala_array_free (_data_->_tmp48_, _data_->_tmp48__length1, (GDestroyNotify) g_free), NULL);
			} else {
				_data_->_tmp50_ = _data_->phonebook_filter;
				_data_->_tmp51_ = g_strdup ("Fields");
				_data_->_tmp52_ = g_strdup ("UID");
				_data_->_tmp53_ = g_strdup ("N");
				_data_->_tmp54_ = g_strdup ("FN");
				_data_->_tmp55_ = g_strdup ("NICKNAME");
				_data_->_tmp56_ = g_strdup ("TEL");
				_data_->_tmp57_ = g_strdup ("URL");
				_data_->_tmp58_ = g_strdup ("EMAIL");
				_data_->_tmp59_ = g_new0 (gchar*, 7 + 1);
				_data_->_tmp59_[0] = _data_->_tmp52_;
				_data_->_tmp59_[1] = _data_->_tmp53_;
				_data_->_tmp59_[2] = _data_->_tmp54_;
				_data_->_tmp59_[3] = _data_->_tmp55_;
				_data_->_tmp59_[4] = _data_->_tmp56_;
				_data_->_tmp59_[5] = _data_->_tmp57_;
				_data_->_tmp59_[6] = _data_->_tmp58_;
				_data_->_tmp60_ = _data_->_tmp59_;
				_data_->_tmp60__length1 = 7;
				_data_->_tmp61_ = g_variant_new_strv (_data_->_tmp60_, 7);
				g_variant_ref_sink (_data_->_tmp61_);
				g_hash_table_insert (_data_->_tmp50_, _data_->_tmp51_, _data_->_tmp61_);
				_data_->_tmp60_ = (_vala_array_free (_data_->_tmp60_, _data_->_tmp60__length1, (GDestroyNotify) g_free), NULL);
			}
			_data_->_tmp62_ = _data_->obex_pbap;
			_data_->_tmp63_ = _data_->phonebook_filter;
			_data_->_tmp64_ = NULL;
			_data_->_tmp65_ = NULL;
			org_bluez_obex_phonebook_access_pull_all (_data_->_tmp62_, "", _data_->_tmp63_, &_data_->_tmp64_, &_data_->_tmp65_, &_data_->_inner_error0_);
			_g_free0 (_data_->path);
			_data_->path = _data_->_tmp64_;
			_g_hash_table_unref0 (_data_->props);
			_data_->props = _data_->_tmp65_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_hash_table_unref0 (_data_->phonebook_filter);
				goto __catch2_g_error;
			}
			_g_hash_table_unref0 (_data_->phonebook_filter);
		}
		goto __finally2;
		__catch2_g_error:
		{
			_data_->e2 = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp66_ = _data_->self->priv->_device;
			_data_->_tmp67_ = org_bluez_device_get_alias (_data_->_tmp66_);
			_data_->_tmp68_ = _data_->_tmp67_;
			_data_->_tmp69_ = _data_->_tmp68_;
			_data_->_tmp70_ = _data_->e2;
			_data_->_tmp71_ = _data_->_tmp70_->message;
			_data_->_tmp72_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE, _ ("The OBEX address book transfer from device ‘%s’ failed: %s"), _data_->_tmp69_, _data_->_tmp71_);
			_data_->_tmp73_ = _data_->_tmp72_;
			_g_free0 (_data_->_tmp69_);
			_data_->_inner_error0_ = _data_->_tmp73_;
			_g_error_free0 (_data_->e2);
			goto __finally2;
		}
		__finally2:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_hash_table_unref0 (_data_->props);
			_g_free0 (_data_->path);
			if (_data_->_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			if (_data_->_inner_error0_->domain == FOLKS_PERSONA_STORE_ERROR) {
				goto __catch0_folks_persona_store_error;
			}
			_g_object_unref0 (_data_->obex_pbap);
			_g_free0 (_data_->session_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		{
			_data_->_tmp74_ = _data_->path;
			_data_->_tmp75_ = _data_->self->priv->_update_contacts_cancellable;
			_data_->_state_ = 2;
			_folks_backends_blue_z_persona_store_perform_obex_transfer (_data_->self, _data_->_tmp74_, _data_->_tmp75_, _folks_backends_blue_z_persona_store_update_contacts_ready, _data_);
			return FALSE;
			_state_2:
			_folks_backends_blue_z_persona_store_perform_obex_transfer_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (_data_->_inner_error0_->domain == G_IO_ERROR) {
					goto __catch3_g_io_error;
				}
				goto __finally3;
			}
		}
		goto __finally3;
		__catch3_g_io_error:
		{
			_data_->e3 = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp76_ = _data_->e3;
			if (g_error_matches (_data_->_tmp76_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				_data_->_tmp77_ = _data_->e3;
				_data_->_tmp78_ = _g_error_copy0 (_data_->_tmp77_);
				_data_->_inner_error0_ = _data_->_tmp78_;
				_g_error_free0 (_data_->e3);
				goto __finally3;
			}
			_data_->_tmp79_ = _data_->self->priv->_display_name;
			_data_->_tmp80_ = _data_->e3;
			_data_->_tmp81_ = _data_->_tmp80_->message;
			_data_->_tmp82_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE, _ ("Error during transfer of the address book from Bluetooth device ‘%s’: " \
"%s"), _data_->_tmp79_, _data_->_tmp81_);
			_data_->_inner_error0_ = _data_->_tmp82_;
			_g_error_free0 (_data_->e3);
			goto __finally3;
		}
		__finally3:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_hash_table_unref0 (_data_->props);
			_g_free0 (_data_->path);
			if (_data_->_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			if (_data_->_inner_error0_->domain == FOLKS_PERSONA_STORE_ERROR) {
				goto __catch0_folks_persona_store_error;
			}
			_g_object_unref0 (_data_->obex_pbap);
			_g_free0 (_data_->session_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_hash_table_unref0 (_data_->props);
		_g_free0 (_data_->path);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		_data_->e4 = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->success = FALSE;
		_data_->_tmp83_ = _data_->e4;
		_data_->_tmp84_ = _g_error_copy0 (_data_->_tmp83_);
		_data_->_inner_error0_ = _data_->_tmp84_;
		_g_error_free0 (_data_->e4);
		goto __finally0;
	}
	goto __finally0;
	__catch0_folks_persona_store_error:
	{
		_data_->e5 = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->success = FALSE;
		_data_->_tmp85_ = _data_->e5;
		_data_->_tmp86_ = _g_error_copy0 (_data_->_tmp85_);
		_data_->_inner_error0_ = _data_->_tmp86_;
		_g_error_free0 (_data_->e5);
		goto __finally0;
	}
	__finally0:
	{
		_data_->_tmp87_ = _data_->session_path;
		if (_data_->_tmp87_ != NULL) {
			_data_->_tmp88_ = _data_->session_path;
			_folks_backends_blue_z_persona_store_remove_obex_session (_data_->self, _data_->_tmp88_, NULL, NULL);
		}
		_g_object_unref0 (_data_->obex_pbap);
		_data_->obex_pbap = NULL;
		_g_object_unref0 (_data_->self->priv->_update_contacts_cancellable);
		_data_->self->priv->_update_contacts_cancellable = NULL;
		if (_data_->success == TRUE) {
			_data_->self->priv->_update_contacts_failures = (guint) 0;
		} else {
			_data_->_tmp89_ = _data_->self->priv->_update_contacts_failures;
			_data_->self->priv->_update_contacts_failures = _data_->_tmp89_ + 1;
		}
		if (_data_->success == TRUE) {
			_data_->_vala1__tmp4_ = _data_->self->priv->_photos_up_to_date == FALSE;
		} else {
			_data_->_vala1__tmp4_ = FALSE;
		}
		_data_->_vala1_new_download_photos = _data_->_vala1__tmp4_;
		_folks_backends_blue_z_persona_store_schedule_update_contacts (_data_->self, _data_->_vala1_new_download_photos);
		_data_->_tmp90_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
		_data_->_tmp91_ = _data_->_tmp90_;
		folks_internal_profiling_end ("updating BlueZ.PersonaStore (ID: %s) " "contacts", _data_->_tmp91_, NULL);
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if ((_data_->_inner_error0_->domain == G_IO_ERROR) || (_data_->_inner_error0_->domain == FOLKS_PERSONA_STORE_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->obex_pbap);
			_g_free0 (_data_->session_path);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->obex_pbap);
			_g_free0 (_data_->session_path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->obex_pbap);
	_g_free0 (_data_->session_path);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
   * Schedule the next call to {@link _update_contacts}.
   *
   * This calculates a suitable timeout value and schedules the next timeout
   * for updating the contacts.
   *
   * The update scheme is as follows:
   *  1. Download the contacts (without photos) as soon as connected to the
   *     phone.
   *  2. Schedule a second download attempt for a few seconds after the first
   *     one completes. If the first one completes successfully, this second
   *     download will include photos; otherwise, it won’t.
   *  3. Schedule subsequent download attempts for exponentially increasing
   *     timeouts, up to a maximum timeout (at which point the timeouts enter a
   *     linear region and repeat indefinitely). Subsequent download attempts
   *     will include photos only if they have not been successfully downloaded
   *     already, or if the previous download attempt caused other property
   *     changes in a persona (indicating that the address book has been edited
   *     on the phone).
   *  4. If updates fail a certain number of consecutive times, give up
   *     completely and leave the persona store in a prepared but empty
   *     quiescent state. Update attempts will only restart if the phone is then
   *     disconnected and reconnected.
   *
   * The rationale for this design is to:
   *  A. Allow for the user accidentally denying the first connection request on
   *     the phone, or not noticing it and it timing out. Attempting a second
   *     download after a timeout gives them an opportunity to fix the problem.
   *  B. If the user explicitly denies the connection request on the phone, the
   *     phone should remember this and automatically deny all future connection
   *     attempts until the consecutive failure limit is reached. The user
   *     shouldn’t be pestered to accept again.
   *  C. Watch for changes in the user’s address book and update the persona
   *     store accordingly. Unfortunately this has to be done by polling, since
   *     neither PBAP not OBEX itself support push notifications.
   *
   * @param download_photos whether to download photos
   *
   * @since 0.9.7
   */
static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		FolksBackendsBlueZPersonaStore* self;
		self = _data5_->self;
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static gboolean
uint64_try_parse (const gchar* str,
                  guint64* _result_,
                  const gchar** unparsed,
                  guint _base)
{
	guint64 _vala__result_ = 0ULL;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	guint64 _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = g_ascii_strtoull (str, &_tmp0_, _base);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		gboolean _tmp5_ = FALSE;
		_vala_unparsed = "";
		if (errno != ERANGE) {
			_tmp5_ = errno != EINVAL;
		} else {
			_tmp5_ = FALSE;
		}
		result = _tmp5_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp6_;
		_tmp6_ = endptr;
		_vala_unparsed = (const gchar*) _tmp6_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static void
__lambda8_ (FolksBackendsBlueZPersonaStore* self,
            GObject* o,
            GAsyncResult* r)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (r != NULL);
	{
		_folks_backends_blue_z_persona_store_update_contacts_finish (self, r, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e4 = NULL;
		GError* _tmp0_;
		GError* _tmp1_;
		e4 = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e4;
		if (g_error_matches (_tmp0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			_g_error_free0 (e4);
			return;
		}
		_tmp1_ = e4;
		if (g_error_matches (_tmp1_, FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE)) {
			GError* _tmp2_;
			const gchar* _tmp3_;
			_tmp2_ = e4;
			_tmp3_ = _tmp2_->message;
			g_debug ("Not updating persona store from BlueZ due to " "store being offline: %s", _tmp3_);
		} else {
			GError* _tmp4_;
			const gchar* _tmp5_;
			_tmp4_ = e4;
			_tmp5_ = _tmp4_->message;
			g_warning ("bluez-persona-store.vala:998: Error updating persona store from BlueZ:" \
" %s", _tmp5_);
		}
		_g_error_free0 (e4);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda8__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda8_ ((FolksBackendsBlueZPersonaStore*) self, source_object, res);
	g_object_unref (self);
}

static gboolean
__lambda7_ (Block5Data* _data5_)
{
	FolksBackendsBlueZPersonaStore* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean result;
	self = _data5_->self;
	_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp1_ = _tmp0_;
	g_debug ("bluez-persona-store.vala:973: Scheduled update firing for BlueZ store " \
"‘%s’.", _tmp1_);
	self->priv->_update_contacts_id = (guint) 0;
	_folks_backends_blue_z_persona_store_update_contacts (self, _data5_->download_photos, ___lambda8__gasync_ready_callback, g_object_ref (self));
	result = FALSE;
	return result;
}

static gboolean
___lambda7__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda7_ (self);
	return result;
}

static void
_folks_backends_blue_z_persona_store_schedule_update_contacts (FolksBackendsBlueZPersonaStore* self,
                                                               gboolean download_photos)
{
	Block5Data* _data5_;
	guint timeout = 0U;
	guint _tmp0_;
	gchar* divisor_str = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	GSourceFunc fn = NULL;
	gpointer fn_target;
	GDestroyNotify fn_target_destroy_notify;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_data5_->download_photos = download_photos;
	if (self->priv->_update_contacts_id != ((guint) 0)) {
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return;
	}
	if (self->priv->_update_contacts_failures >= FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE__MAX_CONSECUTIVE_FAILURES) {
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return;
	}
	timeout = MIN (FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE__TIMEOUT_MIN + ((guint) pow ((gdouble) FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE__TIMEOUT_BASE, (gdouble) self->priv->_update_contacts_n)), FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE__TIMEOUT_MAX);
	_tmp0_ = self->priv->_update_contacts_n;
	self->priv->_update_contacts_n = _tmp0_ + 1;
	timeout *= (guint) 1000;
	_tmp1_ = g_getenv ("FOLKS_BLUEZ_TIMEOUT_DIVISOR");
	_tmp2_ = g_strdup (_tmp1_);
	divisor_str = _tmp2_;
	_tmp3_ = divisor_str;
	if (_tmp3_ != NULL) {
		guint64 divisor = 0ULL;
		const gchar* _tmp4_;
		guint64 _tmp5_ = 0ULL;
		gboolean _tmp6_;
		_tmp4_ = divisor_str;
		_tmp6_ = uint64_try_parse (_tmp4_, &_tmp5_, NULL, (guint) 0);
		divisor = _tmp5_;
		if (_tmp6_ == TRUE) {
			timeout /= (guint) divisor;
		}
	}
	fn = ___lambda7__gsource_func;
	fn_target = block5_data_ref (_data5_);
	fn_target_destroy_notify = block5_data_unref;
	if ((timeout % 1000) == ((guint) 0)) {
		GSourceFunc _tmp7_;
		gpointer _tmp7__target;
		GDestroyNotify _tmp7__target_destroy_notify;
		_tmp7_ = fn;
		_tmp7__target = fn_target;
		_tmp7__target_destroy_notify = fn_target_destroy_notify;
		fn = NULL;
		fn_target = NULL;
		fn_target_destroy_notify = NULL;
		self->priv->_update_contacts_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, timeout / 1000, _tmp7_, _tmp7__target, _tmp7__target_destroy_notify);
	} else {
		GSourceFunc _tmp8_;
		gpointer _tmp8__target;
		GDestroyNotify _tmp8__target_destroy_notify;
		_tmp8_ = fn;
		_tmp8__target = fn_target;
		_tmp8__target_destroy_notify = fn_target_destroy_notify;
		fn = NULL;
		fn_target = NULL;
		fn_target_destroy_notify = NULL;
		self->priv->_update_contacts_id = g_timeout_add_full (G_PRIORITY_DEFAULT, timeout, _tmp8_, _tmp8__target, _tmp8__target_destroy_notify);
	}
	(fn_target_destroy_notify == NULL) ? NULL : (fn_target_destroy_notify (fn_target), NULL);
	fn = NULL;
	fn_target = NULL;
	fn_target_destroy_notify = NULL;
	_g_free0 (divisor_str);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

/**
   * Cancel ongoing and scheduled updates from the device.
   *
   * This doesn't remove the store, but does cancel all ongoing updates and
   * future scheduled updates, in preparation for removing the store. This is
   * necessary to avoid the store maintaining a reference to itself (through the
   * closure for the next scheduled update) and thus never being finalised.
   *
   * @since 0.9.7
   */
void
folks_backends_blue_z_persona_store_cancel_updates (FolksBackendsBlueZPersonaStore* self)
{
	GCancellable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_update_contacts_cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->_update_contacts_cancellable;
		g_cancellable_cancel (_tmp1_);
	}
	if (self->priv->_update_contacts_id != ((guint) 0)) {
		g_source_remove (self->priv->_update_contacts_id);
		self->priv->_update_contacts_id = (guint) 0;
	}
}

static void
folks_backends_blue_z_persona_store_real_prepare_data_free (gpointer _data)
{
	FolksBackendsBlueZPersonaStorePrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsBlueZPersonaStorePrepareData, _data_);
}

static void
folks_backends_blue_z_persona_store_real_prepare (FolksPersonaStore* base,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	FolksBackendsBlueZPersonaStore * self;
	FolksBackendsBlueZPersonaStorePrepareData* _data_;
	FolksBackendsBlueZPersonaStore* _tmp0_;
	self = (FolksBackendsBlueZPersonaStore*) base;
	_data_ = g_slice_new0 (FolksBackendsBlueZPersonaStorePrepareData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_backends_blue_z_persona_store_real_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backends_blue_z_persona_store_real_prepare_co (_data_);
}

static void
folks_backends_blue_z_persona_store_prepare_finish (FolksPersonaStore* base,
                                                    GAsyncResult* _res_,
                                                    GError** error)
{
	FolksBackendsBlueZPersonaStorePrepareData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * {@inheritDoc}
   *
   * @since 0.9.6
   */
static void
folks_backends_blue_z_persona_store_prepare_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_)
{
	FolksBackendsBlueZPersonaStorePrepareData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_backends_blue_z_persona_store_real_prepare_co (_data_);
}

static gboolean
folks_backends_blue_z_persona_store_real_prepare_co (FolksBackendsBlueZPersonaStorePrepareData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	folks_internal_profiling_start ("preparing BlueZ.PersonaStore (ID: %s)", _data_->_tmp1_, NULL);
	if (_data_->self->priv->_is_prepared) {
		_data_->_tmp2_ = TRUE;
	} else {
		_data_->_tmp2_ = _data_->self->priv->_prepare_pending;
	}
	if (_data_->_tmp2_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->self->priv->_prepare_pending = TRUE;
		{
			_data_->_state_ = 1;
			_folks_backends_blue_z_persona_store_update_contacts (_data_->self, FALSE, folks_backends_blue_z_persona_store_prepare_ready, _data_);
			return FALSE;
			_state_1:
			_folks_backends_blue_z_persona_store_update_contacts_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (_data_->_inner_error0_->domain == G_IO_ERROR) {
					goto __catch1_g_io_error;
				}
				goto __finally1;
			}
		}
		goto __finally1;
		__catch1_g_io_error:
		{
			g_clear_error (&_data_->_inner_error0_);
			_data_->_tmp3_ = _data_->self->priv->_device;
			_data_->_tmp4_ = org_bluez_device_get_alias (_data_->_tmp3_);
			_data_->_tmp5_ = _data_->_tmp4_;
			_data_->_tmp6_ = _data_->_tmp5_;
			_data_->_tmp7_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE, _ ("Bluetooth device ‘%s’ disappeared during address book transfer."), _data_->_tmp6_);
			_data_->_tmp8_ = _data_->_tmp7_;
			_g_free0 (_data_->_tmp6_);
			_data_->_inner_error0_ = _data_->_tmp8_;
			goto __finally1;
		}
		__finally1:
		{
			_data_->self->priv->_is_prepared = TRUE;
			g_object_notify ((GObject*) _data_->self, "is-prepared");
			_data_->self->priv->_is_quiescent = TRUE;
			g_object_notify ((GObject*) _data_->self, "is-quiescent");
		}
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __finally0;
		}
	}
	__finally0:
	{
		_data_->self->priv->_prepare_pending = FALSE;
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp9_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp10_ = _data_->_tmp9_;
	folks_internal_profiling_end ("preparing BlueZ.PersonaStore (ID: %s)", _data_->_tmp10_, NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
folks_backends_blue_z_persona_store_real_remove_persona_data_free (gpointer _data)
{
	FolksBackendsBlueZPersonaStoreRemovePersonaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsBlueZPersonaStoreRemovePersonaData, _data_);
}

static void
folks_backends_blue_z_persona_store_real_remove_persona (FolksPersonaStore* base,
                                                         FolksPersona* persona,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_)
{
	FolksBackendsBlueZPersonaStore * self;
	FolksBackendsBlueZPersonaStoreRemovePersonaData* _data_;
	FolksBackendsBlueZPersonaStore* _tmp0_;
	FolksPersona* _tmp1_;
	g_return_if_fail (persona != NULL);
	self = (FolksBackendsBlueZPersonaStore*) base;
	_data_ = g_slice_new0 (FolksBackendsBlueZPersonaStoreRemovePersonaData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_backends_blue_z_persona_store_real_remove_persona_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (persona);
	_g_object_unref0 (_data_->persona);
	_data_->persona = _tmp1_;
	folks_backends_blue_z_persona_store_real_remove_persona_co (_data_);
}

static void
folks_backends_blue_z_persona_store_remove_persona_finish (FolksPersonaStore* base,
                                                           GAsyncResult* _res_,
                                                           GError** error)
{
	FolksBackendsBlueZPersonaStoreRemovePersonaData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Remove a {@link Persona} from the PersonaStore.
   *
   * See {@link Folks.PersonaStore.remove_persona}.
   *
   * @param persona the {@link Persona} to remove
   * @throws Folks.PersonaStoreError.READ_ONLY every time since the
   * BlueZ backend is read-only.
   *
   * @since 0.9.6
   */
static gboolean
folks_backends_blue_z_persona_store_real_remove_persona_co (FolksBackendsBlueZPersonaStoreRemovePersonaData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_READ_ONLY, "Personas cannot be removed from this store.");
	_data_->_inner_error0_ = _data_->_tmp0_;
	if (_data_->_inner_error0_->domain == FOLKS_PERSONA_STORE_ERROR) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
folks_backends_blue_z_persona_store_real_add_persona_from_details_data_free (gpointer _data)
{
	FolksBackendsBlueZPersonaStoreAddPersonaFromDetailsData* _data_;
	_data_ = _data;
	_g_hash_table_unref0 (_data_->details);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsBlueZPersonaStoreAddPersonaFromDetailsData, _data_);
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static void
folks_backends_blue_z_persona_store_real_add_persona_from_details (FolksPersonaStore* base,
                                                                   GHashTable* details,
                                                                   GAsyncReadyCallback _callback_,
                                                                   gpointer _user_data_)
{
	FolksBackendsBlueZPersonaStore * self;
	FolksBackendsBlueZPersonaStoreAddPersonaFromDetailsData* _data_;
	FolksBackendsBlueZPersonaStore* _tmp0_;
	GHashTable* _tmp1_;
	g_return_if_fail (details != NULL);
	self = (FolksBackendsBlueZPersonaStore*) base;
	_data_ = g_slice_new0 (FolksBackendsBlueZPersonaStoreAddPersonaFromDetailsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_backends_blue_z_persona_store_real_add_persona_from_details_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_hash_table_ref0 (details);
	_g_hash_table_unref0 (_data_->details);
	_data_->details = _tmp1_;
	folks_backends_blue_z_persona_store_real_add_persona_from_details_co (_data_);
}

static FolksPersona*
folks_backends_blue_z_persona_store_add_persona_from_details_finish (FolksPersonaStore* base,
                                                                     GAsyncResult* _res_,
                                                                     GError** error)
{
	FolksPersona* result;
	FolksBackendsBlueZPersonaStoreAddPersonaFromDetailsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
   * Add a new {@link Persona} to the PersonaStore.
   *
   * See {@link Folks.PersonaStore.add_persona_from_details}.
   *
   * @param details a map of keys to values giving the persona’s initial details
   * @throws Folks.PersonaStoreError.READ_ONLY every time since the
   * BlueZ backend is read-only.
   *
   * @since 0.9.6
   */
static gboolean
folks_backends_blue_z_persona_store_real_add_persona_from_details_co (FolksBackendsBlueZPersonaStoreAddPersonaFromDetailsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_READ_ONLY, "Personas cannot be added to this store.");
	_data_->_inner_error0_ = _data_->_tmp0_;
	if (_data_->_inner_error0_->domain == FOLKS_PERSONA_STORE_ERROR) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

static const gchar*
folks_backends_blue_z_persona_store_real_get_type_id (FolksPersonaStore* base)
{
	const gchar* result;
	FolksBackendsBlueZPersonaStore* self;
	self = (FolksBackendsBlueZPersonaStore*) base;
	result = BACKEND_NAME;
	return result;
}

static FolksMaybeBool
folks_backends_blue_z_persona_store_real_get_can_add_personas (FolksPersonaStore* base)
{
	FolksMaybeBool result;
	FolksBackendsBlueZPersonaStore* self;
	self = (FolksBackendsBlueZPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}

static FolksMaybeBool
folks_backends_blue_z_persona_store_real_get_can_alias_personas (FolksPersonaStore* base)
{
	FolksMaybeBool result;
	FolksBackendsBlueZPersonaStore* self;
	self = (FolksBackendsBlueZPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}

static FolksMaybeBool
folks_backends_blue_z_persona_store_real_get_can_group_personas (FolksPersonaStore* base)
{
	FolksMaybeBool result;
	FolksBackendsBlueZPersonaStore* self;
	self = (FolksBackendsBlueZPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}

static FolksMaybeBool
folks_backends_blue_z_persona_store_real_get_can_remove_personas (FolksPersonaStore* base)
{
	FolksMaybeBool result;
	FolksBackendsBlueZPersonaStore* self;
	self = (FolksBackendsBlueZPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}

static gboolean
folks_backends_blue_z_persona_store_real_get_is_prepared (FolksPersonaStore* base)
{
	gboolean result;
	FolksBackendsBlueZPersonaStore* self;
	self = (FolksBackendsBlueZPersonaStore*) base;
	result = self->priv->_is_prepared;
	return result;
}

static gboolean
folks_backends_blue_z_persona_store_real_get_is_quiescent (FolksPersonaStore* base)
{
	gboolean result;
	FolksBackendsBlueZPersonaStore* self;
	self = (FolksBackendsBlueZPersonaStore*) base;
	result = self->priv->_is_quiescent;
	return result;
}

static gchar**
folks_backends_blue_z_persona_store_real_get_always_writeable_properties (FolksPersonaStore* base,
                                                                          gint* result_length1)
{
	gchar** result;
	FolksBackendsBlueZPersonaStore* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	self = (FolksBackendsBlueZPersonaStore*) base;
	_tmp0_ = folks_backends_blue_z_persona_store__always_writeable_properties;
	_tmp0__length1 = folks_backends_blue_z_persona_store__always_writeable_properties_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static GeeMap*
folks_backends_blue_z_persona_store_real_get_personas (FolksPersonaStore* base)
{
	GeeMap* result;
	FolksBackendsBlueZPersonaStore* self;
	GeeMap* _tmp0_;
	self = (FolksBackendsBlueZPersonaStore*) base;
	_tmp0_ = self->priv->_personas_ro;
	result = _tmp0_;
	return result;
}

const gchar*
folks_backends_blue_z_persona_store_get_display_name (FolksBackendsBlueZPersonaStore* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_name;
	result = _tmp0_;
	return result;
}

static void
folks_backends_blue_z_persona_store_set_display_name (FolksBackendsBlueZPersonaStore* self,
                                                      const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_display_name);
	self->priv->_display_name = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, folks_backends_blue_z_persona_store_properties[FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_DISPLAY_NAME_PROPERTY]);
}

const gchar*
folks_backends_blue_z_persona_store_get_object_path (FolksBackendsBlueZPersonaStore* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_object_path;
	result = _tmp0_;
	return result;
}

static void
folks_backends_blue_z_persona_store_set_object_path (FolksBackendsBlueZPersonaStore* self,
                                                     const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_object_path);
	self->priv->_object_path = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, folks_backends_blue_z_persona_store_properties[FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_OBJECT_PATH_PROPERTY]);
}

static GObject *
folks_backends_blue_z_persona_store_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FolksBackendsBlueZPersonaStore * self;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	parent_class = G_OBJECT_CLASS (folks_backends_blue_z_persona_store_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA_STORE, FolksBackendsBlueZPersonaStore);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_personas);
	self->priv->_personas = _tmp0_;
	_tmp1_ = self->priv->_personas;
	_tmp2_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->_personas_ro);
	self->priv->_personas_ro = _tmp3_;
	return obj;
}

static void
folks_backends_blue_z_persona_store_class_init (FolksBackendsBlueZPersonaStoreClass * klass,
                                                gpointer klass_data)
{
	gchar** _tmp0_;
	folks_backends_blue_z_persona_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksBackendsBlueZPersonaStore_private_offset);
	((FolksPersonaStoreClass *) klass)->prepare = (void (*) (FolksPersonaStore*, GAsyncReadyCallback, gpointer)) folks_backends_blue_z_persona_store_real_prepare;
	((FolksPersonaStoreClass *) klass)->prepare_finish = (void (*) (FolksPersonaStore*, GAsyncResult*, GError**)) folks_backends_blue_z_persona_store_prepare_finish;
	((FolksPersonaStoreClass *) klass)->remove_persona = (void (*) (FolksPersonaStore*, FolksPersona*, GAsyncReadyCallback, gpointer)) folks_backends_blue_z_persona_store_real_remove_persona;
	((FolksPersonaStoreClass *) klass)->remove_persona_finish = (void (*) (FolksPersonaStore*, GAsyncResult*, GError**)) folks_backends_blue_z_persona_store_remove_persona_finish;
	((FolksPersonaStoreClass *) klass)->add_persona_from_details = (void (*) (FolksPersonaStore*, GHashTable*, GAsyncReadyCallback, gpointer)) folks_backends_blue_z_persona_store_real_add_persona_from_details;
	((FolksPersonaStoreClass *) klass)->add_persona_from_details_finish = (FolksPersona* (*) (FolksPersonaStore*, GAsyncResult*, GError**)) folks_backends_blue_z_persona_store_add_persona_from_details_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_type_id = folks_backends_blue_z_persona_store_real_get_type_id;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_add_personas = folks_backends_blue_z_persona_store_real_get_can_add_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_alias_personas = folks_backends_blue_z_persona_store_real_get_can_alias_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_group_personas = folks_backends_blue_z_persona_store_real_get_can_group_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_remove_personas = folks_backends_blue_z_persona_store_real_get_can_remove_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_prepared = folks_backends_blue_z_persona_store_real_get_is_prepared;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_quiescent = folks_backends_blue_z_persona_store_real_get_is_quiescent;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_always_writeable_properties = folks_backends_blue_z_persona_store_real_get_always_writeable_properties;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_personas = folks_backends_blue_z_persona_store_real_get_personas;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backends_blue_z_persona_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_backends_blue_z_persona_store_set_property;
	G_OBJECT_CLASS (klass)->constructor = folks_backends_blue_z_persona_store_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_backends_blue_z_persona_store_finalize;
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_TYPE_ID_PROPERTY, folks_backends_blue_z_persona_store_properties[FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_TYPE_ID_PROPERTY] = g_param_spec_string ("type-id", "type-id", "type-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can add {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_add_personas}.
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_CAN_ADD_PERSONAS_PROPERTY, folks_backends_blue_z_persona_store_properties[FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_CAN_ADD_PERSONAS_PROPERTY] = g_param_spec_enum ("can-add-personas", "can-add-personas", "can-add-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can set the alias of {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_alias_personas}.
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_CAN_ALIAS_PERSONAS_PROPERTY, folks_backends_blue_z_persona_store_properties[FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_CAN_ALIAS_PERSONAS_PROPERTY] = g_param_spec_enum ("can-alias-personas", "can-alias-personas", "can-alias-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can set the groups of {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_group_personas}.
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_CAN_GROUP_PERSONAS_PROPERTY, folks_backends_blue_z_persona_store_properties[FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_CAN_GROUP_PERSONAS_PROPERTY] = g_param_spec_enum ("can-group-personas", "can-group-personas", "can-group-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can remove {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_remove_personas}.
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_CAN_REMOVE_PERSONAS_PROPERTY, folks_backends_blue_z_persona_store_properties[FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_CAN_REMOVE_PERSONAS_PROPERTY] = g_param_spec_enum ("can-remove-personas", "can-remove-personas", "can-remove-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore has been prepared.
	   *
	   * See {@link Folks.PersonaStore.is_prepared}.
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_IS_PREPARED_PROPERTY, folks_backends_blue_z_persona_store_properties[FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_IS_PREPARED_PROPERTY] = g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore has reached a quiescent state.
	   *
	   * See {@link Folks.PersonaStore.is_quiescent}.
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_IS_QUIESCENT_PROPERTY, folks_backends_blue_z_persona_store_properties[FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_IS_QUIESCENT_PROPERTY] = g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES_PROPERTY, folks_backends_blue_z_persona_store_properties[FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES_PROPERTY] = g_param_spec_boxed ("always-writeable-properties", "always-writeable-properties", "always-writeable-properties", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_PERSONAS_PROPERTY, folks_backends_blue_z_persona_store_properties[FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_PERSONAS_PROPERTY] = g_param_spec_object ("personas", "personas", "personas", GEE_TYPE_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_DISPLAY_NAME_PROPERTY, folks_backends_blue_z_persona_store_properties[FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * Path of the D-Bus object backing this {@link PersonaStore}.
	   *
	   * This is the path of the BlueZ device object on D-Bus which provides the
	   * contacts in this store.
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_OBJECT_PATH_PROPERTY, folks_backends_blue_z_persona_store_properties[FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_OBJECT_PATH_PROPERTY] = g_param_spec_string ("object-path", "object-path", "object-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	folks_backends_blue_z_persona_store__always_writeable_properties = _tmp0_;
	folks_backends_blue_z_persona_store__always_writeable_properties_length1 = 0;
}

static void
folks_backends_blue_z_persona_store_instance_init (FolksBackendsBlueZPersonaStore * self,
                                                   gpointer klass)
{
	self->priv = folks_backends_blue_z_persona_store_get_instance_private (self);
	self->priv->_is_prepared = FALSE;
	self->priv->_prepare_pending = FALSE;
	self->priv->_is_quiescent = FALSE;
	self->priv->_update_contacts_cancellable = NULL;
	self->priv->_update_contacts_id = (guint) 0;
	self->priv->_photos_up_to_date = TRUE;
	self->priv->_update_contacts_n = (guint) 0;
	self->priv->_update_contacts_failures = (guint) 0;
}

static void
folks_backends_blue_z_persona_store_finalize (GObject * obj)
{
	FolksBackendsBlueZPersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA_STORE, FolksBackendsBlueZPersonaStore);
	_g_object_unref0 (self->priv->_personas);
	_g_object_unref0 (self->priv->_personas_ro);
	_g_object_unref0 (self->priv->_obex_client);
	_g_free0 (self->priv->_object_path);
	_g_object_unref0 (self->priv->_device);
	_g_free0 (self->priv->_display_name);
	_g_object_unref0 (self->priv->_update_contacts_cancellable);
	G_OBJECT_CLASS (folks_backends_blue_z_persona_store_parent_class)->finalize (obj);
}

/**
 * A persona store which is associated with a single BlueZ PBAP server (i.e.
 * one {@link PersonaStore} per device). It will create a {@link Persona} for
 * each contact on the device.
 *
 * Since large contact lists can take a long time to download in full (on the
 * order of 1s per 10 contacts), contacts are downloaded in two phases:
 * # Phase 1 downloads all non-PHOTO data. This is very fast (on the order of
 * 1s per 400 contacts)
 * # Phase 2 downloads all PHOTO data for those contacts. This is slow, but
 * happens later, in the background.
 *
 * Subsequent download attempts happen on an exponentially increasing interval,
 * up to a limit (once this limit is reached, updates occur on a regular
 * interval; the linear region). Download attempts repeat indefinitely unless a
 * certain number of consecutive attempts end in failure. See the documentation
 * for {@link _schedule_update_contacts} for details.
 *
 * @since 0.9.6
 */
static GType
folks_backends_blue_z_persona_store_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsBlueZPersonaStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_blue_z_persona_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsBlueZPersonaStore), 0, (GInstanceInitFunc) folks_backends_blue_z_persona_store_instance_init, NULL };
	GType folks_backends_blue_z_persona_store_type_id;
	folks_backends_blue_z_persona_store_type_id = g_type_register_static (FOLKS_TYPE_PERSONA_STORE, "FolksBackendsBlueZPersonaStore", &g_define_type_info, 0);
	FolksBackendsBlueZPersonaStore_private_offset = g_type_add_instance_private (folks_backends_blue_z_persona_store_type_id, sizeof (FolksBackendsBlueZPersonaStorePrivate));
	return folks_backends_blue_z_persona_store_type_id;
}

GType
folks_backends_blue_z_persona_store_get_type (void)
{
	static volatile gsize folks_backends_blue_z_persona_store_type_id__once = 0;
	if (g_once_init_enter (&folks_backends_blue_z_persona_store_type_id__once)) {
		GType folks_backends_blue_z_persona_store_type_id;
		folks_backends_blue_z_persona_store_type_id = folks_backends_blue_z_persona_store_get_type_once ();
		g_once_init_leave (&folks_backends_blue_z_persona_store_type_id__once, folks_backends_blue_z_persona_store_type_id);
	}
	return folks_backends_blue_z_persona_store_type_id__once;
}

static void
_vala_folks_backends_blue_z_persona_store_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec)
{
	FolksBackendsBlueZPersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA_STORE, FolksBackendsBlueZPersonaStore);
	switch (property_id) {
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_TYPE_ID_PROPERTY:
		g_value_set_string (value, folks_persona_store_get_type_id ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_CAN_ADD_PERSONAS_PROPERTY:
		g_value_set_enum (value, folks_persona_store_get_can_add_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_CAN_ALIAS_PERSONAS_PROPERTY:
		g_value_set_enum (value, folks_persona_store_get_can_alias_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_CAN_GROUP_PERSONAS_PROPERTY:
		g_value_set_enum (value, folks_persona_store_get_can_group_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_CAN_REMOVE_PERSONAS_PROPERTY:
		g_value_set_enum (value, folks_persona_store_get_can_remove_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_IS_PREPARED_PROPERTY:
		g_value_set_boolean (value, folks_persona_store_get_is_prepared ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_IS_QUIESCENT_PROPERTY:
		g_value_set_boolean (value, folks_persona_store_get_is_quiescent ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, folks_persona_store_get_always_writeable_properties ((FolksPersonaStore*) self, &length));
		}
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_PERSONAS_PROPERTY:
		g_value_set_object (value, folks_persona_store_get_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_DISPLAY_NAME_PROPERTY:
		g_value_set_string (value, folks_backends_blue_z_persona_store_get_display_name (self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_OBJECT_PATH_PROPERTY:
		g_value_set_string (value, folks_backends_blue_z_persona_store_get_object_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_folks_backends_blue_z_persona_store_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec)
{
	FolksBackendsBlueZPersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA_STORE, FolksBackendsBlueZPersonaStore);
	switch (property_id) {
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_DISPLAY_NAME_PROPERTY:
		folks_backends_blue_z_persona_store_set_display_name (self, g_value_get_string (value));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_OBJECT_PATH_PROPERTY:
		folks_backends_blue_z_persona_store_set_object_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

