/* ofono-persona-store.c generated by valac 0.56.3, the Vala compiler
 * generated from ofono-persona-store.vala, do not modify */

/*
 * Copyright (C) 2012 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *          Jeremy Whiting <jeremy.whiting@collabora.co.uk>
 *
 * Based on kf-persona-store.vala by:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include "ofono.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "folks/folks.h"
#include <gio/gio.h>
#include "folks-internal.h"

enum  {
	FOLKS_BACKENDS_OFONO_PERSONA_STORE_0_PROPERTY,
	FOLKS_BACKENDS_OFONO_PERSONA_STORE_TYPE_ID_PROPERTY,
	FOLKS_BACKENDS_OFONO_PERSONA_STORE_CAN_ADD_PERSONAS_PROPERTY,
	FOLKS_BACKENDS_OFONO_PERSONA_STORE_CAN_ALIAS_PERSONAS_PROPERTY,
	FOLKS_BACKENDS_OFONO_PERSONA_STORE_CAN_GROUP_PERSONAS_PROPERTY,
	FOLKS_BACKENDS_OFONO_PERSONA_STORE_CAN_REMOVE_PERSONAS_PROPERTY,
	FOLKS_BACKENDS_OFONO_PERSONA_STORE_IS_PREPARED_PROPERTY,
	FOLKS_BACKENDS_OFONO_PERSONA_STORE_IS_QUIESCENT_PROPERTY,
	FOLKS_BACKENDS_OFONO_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES_PROPERTY,
	FOLKS_BACKENDS_OFONO_PERSONA_STORE_PERSONAS_PROPERTY,
	FOLKS_BACKENDS_OFONO_PERSONA_STORE_NUM_PROPERTIES
};
static GParamSpec* folks_backends_ofono_persona_store_properties[FOLKS_BACKENDS_OFONO_PERSONA_STORE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FolksBackendsOfonoPersonaStorePrepareData FolksBackendsOfonoPersonaStorePrepareData;
typedef struct _FolksBackendsOfonoPersonaStoreRemovePersonaData FolksBackendsOfonoPersonaStoreRemovePersonaData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _FolksBackendsOfonoPersonaStoreAddPersonaFromDetailsData FolksBackendsOfonoPersonaStoreAddPersonaFromDetailsData;

struct _FolksBackendsOfonoPersonaStorePrivate {
	GeeHashMap* _personas;
	GeeMap* _personas_ro;
	gboolean _is_prepared;
	gboolean _prepare_pending;
	gboolean _is_quiescent;
	char* _path;
	orgofonoPhonebook* _ofono_phonebook;
};

struct _FolksBackendsOfonoPersonaStorePrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksBackendsOfonoPersonaStore* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	orgofonoPhonebook* _tmp3_;
	const char* _tmp4_;
	orgofonoPhonebook* _tmp5_;
	orgofonoPhonebook* _tmp6_;
	orgofonoSimManager* sim_manager;
	const char* _tmp7_;
	orgofonoSimManager* _tmp8_;
	orgofonoSimManager* _tmp9_;
	gchar* all_vcards;
	orgofonoPhonebook* _tmp10_;
	gchar* _tmp11_;
	gchar** vcards;
	const gchar* _tmp12_;
	gint _tmp13_;
	gchar** _tmp14_;
	gint vcards_length1;
	gint _vcards_size_;
	GeeHashSet* added_personas;
	GeeHashSet* _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar** vcard_collection;
	gint vcard_collection_length1;
	gint _vcard_collection_size_;
	gint vcard_it;
	gchar* _tmp17_;
	gchar* vcard;
	FolksBackendsOfonoPersona* persona;
	const gchar* _tmp18_;
	FolksBackendsOfonoPersona* _tmp19_;
	GeeHashMap* _tmp20_;
	FolksBackendsOfonoPersona* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	FolksBackendsOfonoPersona* _tmp24_;
	GeeHashSet* _tmp25_;
	FolksBackendsOfonoPersona* _tmp26_;
	GeeHashMap* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	GeeHashSet* _tmp30_;
	GError* e;
	GError* _tmp31_;
	const gchar* _tmp32_;
	GError* _vala1_e;
	GError* _tmp33_;
	const gchar* _tmp34_;
	GError* _inner_error1_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	GError* _inner_error0_;
};

struct _FolksBackendsOfonoPersonaStoreRemovePersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksBackendsOfonoPersonaStore* self;
	FolksPersona* persona;
	GError* _tmp0_;
	GError* _inner_error0_;
};

struct _FolksBackendsOfonoPersonaStoreAddPersonaFromDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksBackendsOfonoPersonaStore* self;
	GHashTable* details;
	FolksPersona* result;
	GError* _tmp0_;
	GError* _inner_error0_;
};

static gint FolksBackendsOfonoPersonaStore_private_offset;
static gpointer folks_backends_ofono_persona_store_parent_class = NULL;
static gchar** folks_backends_ofono_persona_store__always_writeable_properties;
static gint folks_backends_ofono_persona_store__always_writeable_properties_length1;
static gchar** folks_backends_ofono_persona_store__always_writeable_properties = NULL;
static gint folks_backends_ofono_persona_store__always_writeable_properties_length1 = 0;
static gint _folks_backends_ofono_persona_store__always_writeable_properties_size_ = 0;

static void _folks_backends_ofono_persona_store_property_changed (FolksBackendsOfonoPersonaStore* self,
                                                           const gchar* property,
                                                           GVariant* value);
static void _folks_backends_ofono_persona_store_remove_self (FolksBackendsOfonoPersonaStore* self);
static gchar** _folks_backends_ofono_persona_store_split_all_vcards (FolksBackendsOfonoPersonaStore* self,
                                                              const gchar* all_vcards,
                                                              gint* result_length1);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void folks_backends_ofono_persona_store_real_prepare_data_free (gpointer _data);
static void folks_backends_ofono_persona_store_real_prepare (FolksPersonaStore* base,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static gboolean folks_backends_ofono_persona_store_real_prepare_co (FolksBackendsOfonoPersonaStorePrepareData* _data_);
static void folks_backends_ofono_persona_store_prepare_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static void __folks_backends_ofono_persona_store_property_changed_org_ofono_sim_manager_property_changed (orgofonoSimManager* _sender,
                                                                                                   const gchar* property,
                                                                                                   GVariant* value,
                                                                                                   gpointer self);
static void folks_backends_ofono_persona_store_real_remove_persona_data_free (gpointer _data);
static void folks_backends_ofono_persona_store_real_remove_persona (FolksPersonaStore* base,
                                                             FolksPersona* persona,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
static gboolean folks_backends_ofono_persona_store_real_remove_persona_co (FolksBackendsOfonoPersonaStoreRemovePersonaData* _data_);
static void folks_backends_ofono_persona_store_real_add_persona_from_details_data_free (gpointer _data);
static void folks_backends_ofono_persona_store_real_add_persona_from_details (FolksPersonaStore* base,
                                                                       GHashTable* details,
                                                                       GAsyncReadyCallback _callback_,
                                                                       gpointer _user_data_);
static gboolean folks_backends_ofono_persona_store_real_add_persona_from_details_co (FolksBackendsOfonoPersonaStoreAddPersonaFromDetailsData* _data_);
static void folks_backends_ofono_persona_store_finalize (GObject * obj);
static GType folks_backends_ofono_persona_store_get_type_once (void);
static void _vala_folks_backends_ofono_persona_store_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
folks_backends_ofono_persona_store_get_instance_private (FolksBackendsOfonoPersonaStore* self)
{
	return G_STRUCT_MEMBER_P (self, FolksBackendsOfonoPersonaStore_private_offset);
}

/**
   * Create a new PersonaStore.
   *
   * Create a new persona store to expose the {@link Persona}s provided by the
   * modem with the given address.
   *
   * @param path the D-Bus object path of this modem
   * @param alias the name this modem should display to users
   *
   * @since 0.9.0
   */
FolksBackendsOfonoPersonaStore*
folks_backends_ofono_persona_store_construct (GType object_type,
                                              const char* path,
                                              const gchar* alias)
{
	FolksBackendsOfonoPersonaStore * self = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	char* _tmp4_;
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (alias != NULL, NULL);
	self = (FolksBackendsOfonoPersonaStore*) g_object_new (object_type, "id", path, "display-name", alias, NULL);
	folks_persona_store_set_trust_level ((FolksPersonaStore*) self, FOLKS_PERSONA_STORE_TRUST_FULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, FOLKS_BACKENDS_OFONO_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_personas);
	self->priv->_personas = _tmp0_;
	_tmp1_ = self->priv->_personas;
	_tmp2_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->_personas_ro);
	self->priv->_personas_ro = _tmp3_;
	_tmp4_ = g_strdup (path);
	_g_free0 (self->priv->_path);
	self->priv->_path = _tmp4_;
	return self;
}

FolksBackendsOfonoPersonaStore*
folks_backends_ofono_persona_store_new (const char* path,
                                        const gchar* alias)
{
	return folks_backends_ofono_persona_store_construct (FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE, path, alias);
}

static void
_folks_backends_ofono_persona_store_property_changed (FolksBackendsOfonoPersonaStore* self,
                                                      const gchar* property,
                                                      GVariant* value)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (property != NULL);
	g_return_if_fail (value != NULL);
	if (g_strcmp0 (property, "Present") == 0) {
		_tmp0_ = g_variant_get_boolean (value) == FALSE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		_folks_backends_ofono_persona_store_remove_self (self);
	}
}

static void
_folks_backends_ofono_persona_store_remove_self (FolksBackendsOfonoPersonaStore* self)
{
	GeeHashSet* removed_personas = NULL;
	GeeHashSet* _tmp0_;
	GeeMapIterator* iter = NULL;
	GeeHashMap* _tmp1_;
	GeeMapIterator* _tmp2_;
	GeeHashSet* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_set_new (FOLKS_BACKENDS_OFONO_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	removed_personas = _tmp0_;
	_tmp1_ = self->priv->_personas;
	_tmp2_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp1_);
	iter = _tmp2_;
	while (TRUE) {
		GeeMapIterator* _tmp3_;
		GeeHashSet* _tmp4_;
		GeeMapIterator* _tmp5_;
		gpointer _tmp6_;
		FolksBackendsOfonoPersona* _tmp7_;
		_tmp3_ = iter;
		if (!(gee_map_iterator_next (_tmp3_) == TRUE)) {
			break;
		}
		_tmp4_ = removed_personas;
		_tmp5_ = iter;
		_tmp6_ = gee_map_iterator_get_value (_tmp5_);
		_tmp7_ = (FolksBackendsOfonoPersona*) _tmp6_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp7_);
		_g_object_unref0 (_tmp7_);
	}
	_tmp8_ = removed_personas;
	_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, NULL, (GeeSet*) _tmp8_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	g_signal_emit_by_name ((FolksPersonaStore*) self, "removed");
	_g_object_unref0 (iter);
	_g_object_unref0 (removed_personas);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
_folks_backends_ofono_persona_store_split_all_vcards (FolksBackendsOfonoPersonaStore* self,
                                                      const gchar* all_vcards,
                                                      gint* result_length1)
{
	gchar** lines = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint lines_length1;
	gint _lines_size_;
	gchar** vcards = NULL;
	gchar** _tmp2_;
	gint vcards_length1;
	gint _vcards_size_;
	gchar* vcard = NULL;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp23_;
	gint _tmp23__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (all_vcards != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (all_vcards, "\n", 0);
	lines = _tmp1_;
	lines_length1 = _vala_array_length (_tmp0_);
	_lines_size_ = lines_length1;
	_tmp2_ = g_new0 (gchar*, 0 + 1);
	vcards = _tmp2_;
	vcards_length1 = 0;
	_vcards_size_ = vcards_length1;
	_tmp3_ = g_strdup ("");
	vcard = _tmp3_;
	_tmp4_ = lines;
	_tmp4__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp4_;
		line_collection_length1 = _tmp4__length1;
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp5_;
			gchar* line = NULL;
			_tmp5_ = g_strdup (line_collection[line_it]);
			line = _tmp5_;
			{
				gboolean _tmp6_ = FALSE;
				const gchar* _tmp7_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gboolean _tmp19_;
				_tmp7_ = vcard;
				if (g_strcmp0 (_tmp7_, "") == 0) {
					const gchar* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					_tmp8_ = line;
					_tmp9_ = string_strip (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp6_ = g_strcmp0 (_tmp10_, "") == 0;
					_g_free0 (_tmp10_);
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					_g_free0 (line);
					continue;
				}
				_tmp11_ = vcard;
				_tmp12_ = line;
				_tmp13_ = g_strconcat (_tmp11_, _tmp12_, NULL);
				_g_free0 (vcard);
				vcard = _tmp13_;
				_tmp14_ = vcard;
				_tmp15_ = g_strconcat (_tmp14_, "\n", NULL);
				_g_free0 (vcard);
				vcard = _tmp15_;
				_tmp16_ = line;
				_tmp17_ = string_strip (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = g_strcmp0 (_tmp18_, "END:VCARD") == 0;
				_g_free0 (_tmp18_);
				if (_tmp19_) {
					const gchar* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					_tmp20_ = vcard;
					_tmp21_ = g_strdup (_tmp20_);
					_vala_array_add2 (&vcards, &vcards_length1, &_vcards_size_, _tmp21_);
					_tmp22_ = g_strdup ("");
					_g_free0 (vcard);
					vcard = _tmp22_;
				}
				_g_free0 (line);
			}
		}
	}
	_tmp23_ = vcards;
	_tmp23__length1 = vcards_length1;
	if (result_length1) {
		*result_length1 = _tmp23__length1;
	}
	result = _tmp23_;
	_g_free0 (vcard);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
folks_backends_ofono_persona_store_real_prepare_data_free (gpointer _data)
{
	FolksBackendsOfonoPersonaStorePrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsOfonoPersonaStorePrepareData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
folks_backends_ofono_persona_store_real_prepare (FolksPersonaStore* base,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	FolksBackendsOfonoPersonaStore * self;
	FolksBackendsOfonoPersonaStorePrepareData* _data_;
	FolksBackendsOfonoPersonaStore* _tmp0_;
	self = (FolksBackendsOfonoPersonaStore*) base;
	_data_ = g_slice_new0 (FolksBackendsOfonoPersonaStorePrepareData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_backends_ofono_persona_store_real_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backends_ofono_persona_store_real_prepare_co (_data_);
}

static void
folks_backends_ofono_persona_store_prepare_finish (FolksPersonaStore* base,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	FolksBackendsOfonoPersonaStorePrepareData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * {@inheritDoc}
   */
static void
folks_backends_ofono_persona_store_prepare_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	FolksBackendsOfonoPersonaStorePrepareData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_backends_ofono_persona_store_real_prepare_co (_data_);
}

static void
__folks_backends_ofono_persona_store_property_changed_org_ofono_sim_manager_property_changed (orgofonoSimManager* _sender,
                                                                                              const gchar* property,
                                                                                              GVariant* value,
                                                                                              gpointer self)
{
	_folks_backends_ofono_persona_store_property_changed ((FolksBackendsOfonoPersonaStore*) self, property, value);
}

static gboolean
folks_backends_ofono_persona_store_real_prepare_co (FolksBackendsOfonoPersonaStorePrepareData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	folks_internal_profiling_start ("preparing Ofono.PersonaStore (ID: %s)", _data_->_tmp1_, NULL);
	if (_data_->self->priv->_is_prepared) {
		_data_->_tmp2_ = TRUE;
	} else {
		_data_->_tmp2_ = _data_->self->priv->_prepare_pending;
	}
	if (_data_->_tmp2_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->self->priv->_prepare_pending = TRUE;
		_data_->_tmp4_ = _data_->self->priv->_path;
		_data_->_state_ = 1;
		g_async_initable_new_async (ORG_OFONO_TYPE_PHONEBOOK_PROXY, 0, NULL, folks_backends_ofono_persona_store_prepare_ready, _data_, "g-flags", 0, "g-name", "org.ofono", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", (const gchar*) _data_->_tmp4_, "g-interface-name", "org.ofono.Phonebook", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp5_ = (orgofonoPhonebook*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp3_ = (orgofonoPhonebook*) _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == G_DBUS_ERROR) {
				goto __catch0_g_dbus_error;
			}
			if (_data_->_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp6_ = _data_->_tmp3_;
		_data_->_tmp3_ = NULL;
		_g_object_unref0 (_data_->self->priv->_ofono_phonebook);
		_data_->self->priv->_ofono_phonebook = _data_->_tmp6_;
		_data_->_tmp7_ = _data_->self->priv->_path;
		_data_->_state_ = 2;
		g_async_initable_new_async (ORG_OFONO_TYPE_SIM_MANAGER_PROXY, 0, NULL, folks_backends_ofono_persona_store_prepare_ready, _data_, "g-flags", 0, "g-name", "org.ofono", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", (const gchar*) _data_->_tmp7_, "g-interface-name", "org.ofono.SimManager", NULL);
		return FALSE;
		_state_2:
		_data_->_tmp8_ = (orgofonoSimManager*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->sim_manager = (orgofonoSimManager*) _data_->_tmp8_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->_tmp3_);
			if (_data_->_inner_error0_->domain == G_DBUS_ERROR) {
				goto __catch0_g_dbus_error;
			}
			if (_data_->_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp9_ = _data_->sim_manager;
		g_signal_connect_object (_data_->_tmp9_, "property-changed", (GCallback) __folks_backends_ofono_persona_store_property_changed_org_ofono_sim_manager_property_changed, _data_->self, 0);
		_data_->_tmp10_ = _data_->self->priv->_ofono_phonebook;
		_data_->_tmp11_ = org_ofono_phonebook_Import (_data_->_tmp10_, &_data_->_inner_error0_);
		_data_->all_vcards = _data_->_tmp11_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->sim_manager);
			_g_object_unref0 (_data_->_tmp3_);
			if (_data_->_inner_error0_->domain == G_DBUS_ERROR) {
				goto __catch0_g_dbus_error;
			}
			if (_data_->_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp12_ = _data_->all_vcards;
		_data_->_tmp13_ = 0;
		_data_->_tmp14_ = _folks_backends_ofono_persona_store_split_all_vcards (_data_->self, _data_->_tmp12_, &_data_->_tmp13_);
		_data_->vcards = _data_->_tmp14_;
		_data_->vcards_length1 = _data_->_tmp13_;
		_data_->_vcards_size_ = _data_->vcards_length1;
		_data_->_tmp15_ = gee_hash_set_new (FOLKS_BACKENDS_OFONO_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
		_data_->added_personas = _data_->_tmp15_;
		_data_->_tmp16_ = _data_->vcards;
		_data_->_tmp16__length1 = _data_->vcards_length1;
		{
			_data_->vcard_collection_length1 = 0;
			_data_->_vcard_collection_size_ = 0;
			_data_->vcard_collection = _data_->_tmp16_;
			_data_->vcard_collection_length1 = _data_->_tmp16__length1;
			for (_data_->vcard_it = 0; _data_->vcard_it < _data_->vcard_collection_length1; _data_->vcard_it = _data_->vcard_it + 1) {
				_data_->_tmp17_ = g_strdup (_data_->vcard_collection[_data_->vcard_it]);
				_data_->vcard = _data_->_tmp17_;
				{
					_data_->_tmp18_ = _data_->vcard;
					_data_->_tmp19_ = folks_backends_ofono_persona_new (_data_->_tmp18_, (FolksPersonaStore*) _data_->self);
					_data_->persona = _data_->_tmp19_;
					_data_->_tmp20_ = _data_->self->priv->_personas;
					_data_->_tmp21_ = _data_->persona;
					_data_->_tmp22_ = folks_persona_get_iid ((FolksPersona*) _data_->_tmp21_);
					_data_->_tmp23_ = _data_->_tmp22_;
					_data_->_tmp24_ = _data_->persona;
					gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp20_, _data_->_tmp23_, _data_->_tmp24_);
					_data_->_tmp25_ = _data_->added_personas;
					_data_->_tmp26_ = _data_->persona;
					gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp25_, _data_->_tmp26_);
					_g_object_unref0 (_data_->persona);
					_g_free0 (_data_->vcard);
				}
			}
		}
		_data_->_tmp27_ = _data_->self->priv->_personas;
		_data_->_tmp28_ = gee_abstract_map_get_size ((GeeAbstractMap*) _data_->_tmp27_);
		_data_->_tmp29_ = _data_->_tmp28_;
		if (_data_->_tmp29_ > 0) {
			_data_->_tmp30_ = _data_->added_personas;
			_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) _data_->self, (GeeSet*) _data_->_tmp30_, NULL, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
		}
		_g_object_unref0 (_data_->added_personas);
		_data_->vcards = (_vala_array_free (_data_->vcards, _data_->vcards_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data_->all_vcards);
		_g_object_unref0 (_data_->sim_manager);
		_g_object_unref0 (_data_->_tmp3_);
	}
	goto __finally0;
	__catch0_g_dbus_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp31_ = _data_->e;
		_data_->_tmp32_ = _data_->_tmp31_->message;
		g_warning ("ofono-persona-store.vala:235: DBus Error has occurred when fetching of" \
"ono phonebook, %s", _data_->_tmp32_);
		_folks_backends_ofono_persona_store_remove_self (_data_->self);
		_g_error_free0 (_data_->e);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		_data_->_vala1_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp33_ = _data_->_vala1_e;
		_data_->_tmp34_ = _data_->_tmp33_->message;
		g_warning ("ofono-persona-store.vala:240: IO Error has occurred when fetching ofon" \
"o phonebook, %s", _data_->_tmp34_);
		_folks_backends_ofono_persona_store_remove_self (_data_->self);
		_g_error_free0 (_data_->_vala1_e);
	}
	__finally0:
	{
		_data_->self->priv->_is_prepared = TRUE;
		g_object_notify ((GObject*) _data_->self, "is-prepared");
		_data_->self->priv->_is_quiescent = TRUE;
		g_object_notify ((GObject*) _data_->self, "is-quiescent");
		_data_->self->priv->_prepare_pending = FALSE;
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if ((_data_->_inner_error0_->domain == G_IO_ERROR) || (_data_->_inner_error0_->domain == G_DBUS_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp35_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp36_ = _data_->_tmp35_;
	folks_internal_profiling_end ("preparing Ofono.PersonaStore (ID: %s)", _data_->_tmp36_, NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
folks_backends_ofono_persona_store_real_remove_persona_data_free (gpointer _data)
{
	FolksBackendsOfonoPersonaStoreRemovePersonaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsOfonoPersonaStoreRemovePersonaData, _data_);
}

static void
folks_backends_ofono_persona_store_real_remove_persona (FolksPersonaStore* base,
                                                        FolksPersona* persona,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	FolksBackendsOfonoPersonaStore * self;
	FolksBackendsOfonoPersonaStoreRemovePersonaData* _data_;
	FolksBackendsOfonoPersonaStore* _tmp0_;
	FolksPersona* _tmp1_;
	g_return_if_fail (persona != NULL);
	self = (FolksBackendsOfonoPersonaStore*) base;
	_data_ = g_slice_new0 (FolksBackendsOfonoPersonaStoreRemovePersonaData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_backends_ofono_persona_store_real_remove_persona_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (persona);
	_g_object_unref0 (_data_->persona);
	_data_->persona = _tmp1_;
	folks_backends_ofono_persona_store_real_remove_persona_co (_data_);
}

static void
folks_backends_ofono_persona_store_remove_persona_finish (FolksPersonaStore* base,
                                                          GAsyncResult* _res_,
                                                          GError** error)
{
	FolksBackendsOfonoPersonaStoreRemovePersonaData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Remove a {@link Persona} from the PersonaStore.
   *
   * See {@link Folks.PersonaStore.remove_persona}.
   *
   * @throws Folks.PersonaStoreError.READ_ONLY every time since the
   * Ofono backend is read-only.
   *
   * @param persona the {@link Persona} to remove.
   *
   * @since 0.9.0
   */
static gboolean
folks_backends_ofono_persona_store_real_remove_persona_co (FolksBackendsOfonoPersonaStoreRemovePersonaData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_READ_ONLY, "Personas cannot be removed from this store.");
	_data_->_inner_error0_ = _data_->_tmp0_;
	if (_data_->_inner_error0_->domain == FOLKS_PERSONA_STORE_ERROR) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
folks_backends_ofono_persona_store_real_add_persona_from_details_data_free (gpointer _data)
{
	FolksBackendsOfonoPersonaStoreAddPersonaFromDetailsData* _data_;
	_data_ = _data;
	_g_hash_table_unref0 (_data_->details);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsOfonoPersonaStoreAddPersonaFromDetailsData, _data_);
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static void
folks_backends_ofono_persona_store_real_add_persona_from_details (FolksPersonaStore* base,
                                                                  GHashTable* details,
                                                                  GAsyncReadyCallback _callback_,
                                                                  gpointer _user_data_)
{
	FolksBackendsOfonoPersonaStore * self;
	FolksBackendsOfonoPersonaStoreAddPersonaFromDetailsData* _data_;
	FolksBackendsOfonoPersonaStore* _tmp0_;
	GHashTable* _tmp1_;
	g_return_if_fail (details != NULL);
	self = (FolksBackendsOfonoPersonaStore*) base;
	_data_ = g_slice_new0 (FolksBackendsOfonoPersonaStoreAddPersonaFromDetailsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_backends_ofono_persona_store_real_add_persona_from_details_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_hash_table_ref0 (details);
	_g_hash_table_unref0 (_data_->details);
	_data_->details = _tmp1_;
	folks_backends_ofono_persona_store_real_add_persona_from_details_co (_data_);
}

static FolksPersona*
folks_backends_ofono_persona_store_add_persona_from_details_finish (FolksPersonaStore* base,
                                                                    GAsyncResult* _res_,
                                                                    GError** error)
{
	FolksPersona* result;
	FolksBackendsOfonoPersonaStoreAddPersonaFromDetailsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
   * Add a new {@link Persona} to the PersonaStore.
   *
   * See {@link Folks.PersonaStore.add_persona_from_details}.
   *
   * @throws Folks.PersonaStoreError.READ_ONLY every time since the
   * Ofono backend is read-only.
   *
   * @param details the details of the {@link Persona} to add.
   *
   * @since 0.9.0
   */
static gboolean
folks_backends_ofono_persona_store_real_add_persona_from_details_co (FolksBackendsOfonoPersonaStoreAddPersonaFromDetailsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_READ_ONLY, "Personas cannot be added to this store.");
	_data_->_inner_error0_ = _data_->_tmp0_;
	if (_data_->_inner_error0_->domain == FOLKS_PERSONA_STORE_ERROR) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

static const gchar*
folks_backends_ofono_persona_store_real_get_type_id (FolksPersonaStore* base)
{
	const gchar* result;
	FolksBackendsOfonoPersonaStore* self;
	self = (FolksBackendsOfonoPersonaStore*) base;
	result = BACKEND_NAME;
	return result;
}

static FolksMaybeBool
folks_backends_ofono_persona_store_real_get_can_add_personas (FolksPersonaStore* base)
{
	FolksMaybeBool result;
	FolksBackendsOfonoPersonaStore* self;
	self = (FolksBackendsOfonoPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}

static FolksMaybeBool
folks_backends_ofono_persona_store_real_get_can_alias_personas (FolksPersonaStore* base)
{
	FolksMaybeBool result;
	FolksBackendsOfonoPersonaStore* self;
	self = (FolksBackendsOfonoPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}

static FolksMaybeBool
folks_backends_ofono_persona_store_real_get_can_group_personas (FolksPersonaStore* base)
{
	FolksMaybeBool result;
	FolksBackendsOfonoPersonaStore* self;
	self = (FolksBackendsOfonoPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}

static FolksMaybeBool
folks_backends_ofono_persona_store_real_get_can_remove_personas (FolksPersonaStore* base)
{
	FolksMaybeBool result;
	FolksBackendsOfonoPersonaStore* self;
	self = (FolksBackendsOfonoPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}

static gboolean
folks_backends_ofono_persona_store_real_get_is_prepared (FolksPersonaStore* base)
{
	gboolean result;
	FolksBackendsOfonoPersonaStore* self;
	self = (FolksBackendsOfonoPersonaStore*) base;
	result = self->priv->_is_prepared;
	return result;
}

static gboolean
folks_backends_ofono_persona_store_real_get_is_quiescent (FolksPersonaStore* base)
{
	gboolean result;
	FolksBackendsOfonoPersonaStore* self;
	self = (FolksBackendsOfonoPersonaStore*) base;
	result = self->priv->_is_quiescent;
	return result;
}

static gchar**
folks_backends_ofono_persona_store_real_get_always_writeable_properties (FolksPersonaStore* base,
                                                                         gint* result_length1)
{
	gchar** result;
	FolksBackendsOfonoPersonaStore* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	self = (FolksBackendsOfonoPersonaStore*) base;
	_tmp0_ = folks_backends_ofono_persona_store__always_writeable_properties;
	_tmp0__length1 = folks_backends_ofono_persona_store__always_writeable_properties_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static GeeMap*
folks_backends_ofono_persona_store_real_get_personas (FolksPersonaStore* base)
{
	GeeMap* result;
	FolksBackendsOfonoPersonaStore* self;
	GeeMap* _tmp0_;
	self = (FolksBackendsOfonoPersonaStore*) base;
	_tmp0_ = self->priv->_personas_ro;
	result = _tmp0_;
	return result;
}

static void
folks_backends_ofono_persona_store_class_init (FolksBackendsOfonoPersonaStoreClass * klass,
                                               gpointer klass_data)
{
	gchar** _tmp0_;
	folks_backends_ofono_persona_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksBackendsOfonoPersonaStore_private_offset);
	((FolksPersonaStoreClass *) klass)->prepare = (void (*) (FolksPersonaStore*, GAsyncReadyCallback, gpointer)) folks_backends_ofono_persona_store_real_prepare;
	((FolksPersonaStoreClass *) klass)->prepare_finish = (void (*) (FolksPersonaStore*, GAsyncResult*, GError**)) folks_backends_ofono_persona_store_prepare_finish;
	((FolksPersonaStoreClass *) klass)->remove_persona = (void (*) (FolksPersonaStore*, FolksPersona*, GAsyncReadyCallback, gpointer)) folks_backends_ofono_persona_store_real_remove_persona;
	((FolksPersonaStoreClass *) klass)->remove_persona_finish = (void (*) (FolksPersonaStore*, GAsyncResult*, GError**)) folks_backends_ofono_persona_store_remove_persona_finish;
	((FolksPersonaStoreClass *) klass)->add_persona_from_details = (void (*) (FolksPersonaStore*, GHashTable*, GAsyncReadyCallback, gpointer)) folks_backends_ofono_persona_store_real_add_persona_from_details;
	((FolksPersonaStoreClass *) klass)->add_persona_from_details_finish = (FolksPersona* (*) (FolksPersonaStore*, GAsyncResult*, GError**)) folks_backends_ofono_persona_store_add_persona_from_details_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_type_id = folks_backends_ofono_persona_store_real_get_type_id;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_add_personas = folks_backends_ofono_persona_store_real_get_can_add_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_alias_personas = folks_backends_ofono_persona_store_real_get_can_alias_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_group_personas = folks_backends_ofono_persona_store_real_get_can_group_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_remove_personas = folks_backends_ofono_persona_store_real_get_can_remove_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_prepared = folks_backends_ofono_persona_store_real_get_is_prepared;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_quiescent = folks_backends_ofono_persona_store_real_get_is_quiescent;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_always_writeable_properties = folks_backends_ofono_persona_store_real_get_always_writeable_properties;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_personas = folks_backends_ofono_persona_store_real_get_personas;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backends_ofono_persona_store_get_property;
	G_OBJECT_CLASS (klass)->finalize = folks_backends_ofono_persona_store_finalize;
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_STORE_TYPE_ID_PROPERTY, folks_backends_ofono_persona_store_properties[FOLKS_BACKENDS_OFONO_PERSONA_STORE_TYPE_ID_PROPERTY] = g_param_spec_string ("type-id", "type-id", "type-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_STORE_CAN_ADD_PERSONAS_PROPERTY, folks_backends_ofono_persona_store_properties[FOLKS_BACKENDS_OFONO_PERSONA_STORE_CAN_ADD_PERSONAS_PROPERTY] = g_param_spec_enum ("can-add-personas", "can-add-personas", "can-add-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_STORE_CAN_ALIAS_PERSONAS_PROPERTY, folks_backends_ofono_persona_store_properties[FOLKS_BACKENDS_OFONO_PERSONA_STORE_CAN_ALIAS_PERSONAS_PROPERTY] = g_param_spec_enum ("can-alias-personas", "can-alias-personas", "can-alias-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_STORE_CAN_GROUP_PERSONAS_PROPERTY, folks_backends_ofono_persona_store_properties[FOLKS_BACKENDS_OFONO_PERSONA_STORE_CAN_GROUP_PERSONAS_PROPERTY] = g_param_spec_enum ("can-group-personas", "can-group-personas", "can-group-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_STORE_CAN_REMOVE_PERSONAS_PROPERTY, folks_backends_ofono_persona_store_properties[FOLKS_BACKENDS_OFONO_PERSONA_STORE_CAN_REMOVE_PERSONAS_PROPERTY] = g_param_spec_enum ("can-remove-personas", "can-remove-personas", "can-remove-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_STORE_IS_PREPARED_PROPERTY, folks_backends_ofono_persona_store_properties[FOLKS_BACKENDS_OFONO_PERSONA_STORE_IS_PREPARED_PROPERTY] = g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_STORE_IS_QUIESCENT_PROPERTY, folks_backends_ofono_persona_store_properties[FOLKS_BACKENDS_OFONO_PERSONA_STORE_IS_QUIESCENT_PROPERTY] = g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES_PROPERTY, folks_backends_ofono_persona_store_properties[FOLKS_BACKENDS_OFONO_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES_PROPERTY] = g_param_spec_boxed ("always-writeable-properties", "always-writeable-properties", "always-writeable-properties", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_STORE_PERSONAS_PROPERTY, folks_backends_ofono_persona_store_properties[FOLKS_BACKENDS_OFONO_PERSONA_STORE_PERSONAS_PROPERTY] = g_param_spec_object ("personas", "personas", "personas", GEE_TYPE_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	folks_backends_ofono_persona_store__always_writeable_properties = _tmp0_;
	folks_backends_ofono_persona_store__always_writeable_properties_length1 = 0;
}

static void
folks_backends_ofono_persona_store_instance_init (FolksBackendsOfonoPersonaStore * self,
                                                  gpointer klass)
{
	self->priv = folks_backends_ofono_persona_store_get_instance_private (self);
	self->priv->_is_prepared = FALSE;
	self->priv->_prepare_pending = FALSE;
	self->priv->_is_quiescent = FALSE;
	self->priv->_path = NULL;
	self->priv->_ofono_phonebook = NULL;
}

static void
folks_backends_ofono_persona_store_finalize (GObject * obj)
{
	FolksBackendsOfonoPersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE, FolksBackendsOfonoPersonaStore);
	_g_object_unref0 (self->priv->_personas);
	_g_object_unref0 (self->priv->_personas_ro);
	_g_free0 (self->priv->_path);
	_g_object_unref0 (self->priv->_ofono_phonebook);
	G_OBJECT_CLASS (folks_backends_ofono_persona_store_parent_class)->finalize (obj);
}

/**
 * A persona store which is associated with a single Ofono device. It will
 * create a {@link Persona} for each contact on the SIM card phonebook.
 *
 * @since 0.9.0
 */
static GType
folks_backends_ofono_persona_store_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsOfonoPersonaStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_ofono_persona_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsOfonoPersonaStore), 0, (GInstanceInitFunc) folks_backends_ofono_persona_store_instance_init, NULL };
	GType folks_backends_ofono_persona_store_type_id;
	folks_backends_ofono_persona_store_type_id = g_type_register_static (FOLKS_TYPE_PERSONA_STORE, "FolksBackendsOfonoPersonaStore", &g_define_type_info, 0);
	FolksBackendsOfonoPersonaStore_private_offset = g_type_add_instance_private (folks_backends_ofono_persona_store_type_id, sizeof (FolksBackendsOfonoPersonaStorePrivate));
	return folks_backends_ofono_persona_store_type_id;
}

GType
folks_backends_ofono_persona_store_get_type (void)
{
	static volatile gsize folks_backends_ofono_persona_store_type_id__once = 0;
	if (g_once_init_enter (&folks_backends_ofono_persona_store_type_id__once)) {
		GType folks_backends_ofono_persona_store_type_id;
		folks_backends_ofono_persona_store_type_id = folks_backends_ofono_persona_store_get_type_once ();
		g_once_init_leave (&folks_backends_ofono_persona_store_type_id__once, folks_backends_ofono_persona_store_type_id);
	}
	return folks_backends_ofono_persona_store_type_id__once;
}

static void
_vala_folks_backends_ofono_persona_store_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec)
{
	FolksBackendsOfonoPersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE, FolksBackendsOfonoPersonaStore);
	switch (property_id) {
		case FOLKS_BACKENDS_OFONO_PERSONA_STORE_TYPE_ID_PROPERTY:
		g_value_set_string (value, folks_persona_store_get_type_id ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_STORE_CAN_ADD_PERSONAS_PROPERTY:
		g_value_set_enum (value, folks_persona_store_get_can_add_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_STORE_CAN_ALIAS_PERSONAS_PROPERTY:
		g_value_set_enum (value, folks_persona_store_get_can_alias_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_STORE_CAN_GROUP_PERSONAS_PROPERTY:
		g_value_set_enum (value, folks_persona_store_get_can_group_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_STORE_CAN_REMOVE_PERSONAS_PROPERTY:
		g_value_set_enum (value, folks_persona_store_get_can_remove_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_STORE_IS_PREPARED_PROPERTY:
		g_value_set_boolean (value, folks_persona_store_get_is_prepared ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_STORE_IS_QUIESCENT_PROPERTY:
		g_value_set_boolean (value, folks_persona_store_get_is_quiescent ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, folks_persona_store_get_always_writeable_properties ((FolksPersonaStore*) self, &length));
		}
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_STORE_PERSONAS_PROPERTY:
		g_value_set_object (value, folks_persona_store_get_personas ((FolksPersonaStore*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

