/* preferences-dialog.c generated by valac 0.56.3, the Vala compiler
 * generated from preferences-dialog.vala, do not modify */

/*
 * Copyright (C) 2009-2017 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>,
 *         Eduard Gotwig <g@ox.io>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <handy.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>

#define DEFAULT_TEXT_DPI 150
#define DEFAULT_PHOTO_DPI 300
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PREFERENCES_DIALOG (preferences_dialog_get_type ())
#define PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialog))
#define PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))
#define IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES_DIALOG))
#define IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES_DIALOG))
#define PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))

typedef struct _PreferencesDialog PreferencesDialog;
typedef struct _PreferencesDialogClass PreferencesDialogClass;
typedef struct _PreferencesDialogPrivate PreferencesDialogPrivate;
enum  {
	PREFERENCES_DIALOG_0_PROPERTY,
	PREFERENCES_DIALOG_NUM_PROPERTIES
};
static GParamSpec* preferences_dialog_properties[PREFERENCES_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block6Data Block6Data;
typedef enum  {
	SCAN_SIDE_FRONT,
	SCAN_SIDE_BACK,
	SCAN_SIDE_BOTH
} ScanSide;

#define TYPE_SCAN_SIDE (scan_side_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

struct _PreferencesDialog {
	HdyPreferencesWindow parent_instance;
	PreferencesDialogPrivate * priv;
};

struct _PreferencesDialogClass {
	HdyPreferencesWindowClass parent_class;
};

struct _PreferencesDialogPrivate {
	GSettings* settings;
	GtkComboBox* text_dpi_combo;
	GtkComboBox* photo_dpi_combo;
	GtkComboBox* paper_size_combo;
	GtkScale* brightness_scale;
	GtkScale* contrast_scale;
	GtkRadioButton* page_delay_0s_button;
	GtkRadioButton* page_delay_3s_button;
	GtkRadioButton* page_delay_6s_button;
	GtkRadioButton* page_delay_10s_button;
	GtkRadioButton* page_delay_15s_button;
	GtkListStore* text_dpi_model;
	GtkListStore* photo_dpi_model;
	GtkRadioButton* front_side_button;
	GtkRadioButton* back_side_button;
	GtkRadioButton* both_side_button;
	GtkListStore* paper_size_model;
	GtkAdjustment* brightness_adjustment;
	GtkAdjustment* contrast_adjustment;
	GtkSwitch* postproc_enable_switch;
	GtkEntry* postproc_script_entry;
	GtkEntry* postproc_args_entry;
	GtkSwitch* postproc_keep_original_switch;
};

struct _Block6Data {
	int _ref_count_;
	PreferencesDialog* self;
	GSettings* settings;
};

static gint PreferencesDialog_private_offset;
static gpointer preferences_dialog_parent_class = NULL;

VALA_EXTERN GType preferences_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PreferencesDialog, g_object_unref)
VALA_EXTERN PreferencesDialog* preferences_dialog_new (GSettings* settings);
VALA_EXTERN PreferencesDialog* preferences_dialog_construct (GType object_type,
                                                 GSettings* settings);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void preferences_dialog_set_dpi_combo (PreferencesDialog* self,
                                       GtkComboBox* combo,
                                       gint default_dpi,
                                       gint current_dpi);
static void __lambda4_ (Block6Data* _data6_);
VALA_EXTERN gint preferences_dialog_get_text_dpi (PreferencesDialog* self);
static void ___lambda4__gtk_combo_box_changed (GtkComboBox* _sender,
                                        gpointer self);
static void __lambda5_ (Block6Data* _data6_);
VALA_EXTERN gint preferences_dialog_get_photo_dpi (PreferencesDialog* self);
static void ___lambda5__gtk_combo_box_changed (GtkComboBox* _sender,
                                        gpointer self);
VALA_EXTERN GType scan_side_get_type (void) G_GNUC_CONST ;
static void preferences_dialog_set_page_side (PreferencesDialog* self,
                                       ScanSide page_side);
static void __lambda6_ (Block6Data* _data6_,
                 GtkToggleButton* button);
static void ___lambda6__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                            gpointer self);
static void __lambda7_ (Block6Data* _data6_,
                 GtkToggleButton* button);
static void ___lambda7__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                            gpointer self);
static void __lambda8_ (Block6Data* _data6_,
                 GtkToggleButton* button);
static void ___lambda8__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                            gpointer self);
static void __lambda9_ (Block6Data* _data6_);
VALA_EXTERN gint preferences_dialog_get_brightness (PreferencesDialog* self);
static void ___lambda9__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                               gpointer self);
static void __lambda10_ (Block6Data* _data6_);
VALA_EXTERN gint preferences_dialog_get_contrast (PreferencesDialog* self);
static void ___lambda10__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                gpointer self);
VALA_EXTERN void preferences_dialog_set_paper_size (PreferencesDialog* self,
                                        gint width,
                                        gint height);
static void __lambda11_ (Block6Data* _data6_);
VALA_EXTERN gboolean preferences_dialog_get_paper_size (PreferencesDialog* self,
                                            gint* width,
                                            gint* height);
static void ___lambda11__gtk_combo_box_changed (GtkComboBox* _sender,
                                         gpointer self);
VALA_EXTERN void preferences_dialog_set_page_delay (PreferencesDialog* self,
                                        gint page_delay);
static void __lambda12_ (Block6Data* _data6_,
                  GtkToggleButton* button);
static void ___lambda12__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                             gpointer self);
static void __lambda13_ (Block6Data* _data6_,
                  GtkToggleButton* button);
static void ___lambda13__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                             gpointer self);
static void __lambda14_ (Block6Data* _data6_,
                  GtkToggleButton* button);
static void ___lambda14__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                             gpointer self);
static void __lambda15_ (Block6Data* _data6_,
                  GtkToggleButton* button);
static void ___lambda15__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                             gpointer self);
static void __lambda16_ (Block6Data* _data6_,
                  GtkToggleButton* button);
static void ___lambda16__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                             gpointer self);
static void preferences_dialog_toggle_postproc_visibility (PreferencesDialog* self,
                                                    gboolean enabled);
static gboolean __lambda17_ (Block6Data* _data6_,
                      gboolean is_active);
static gboolean ___lambda17__gtk_switch_state_set (GtkSwitch* _sender,
                                            gboolean state,
                                            gpointer self);
static void __lambda18_ (Block6Data* _data6_);
static void ___lambda18__gtk_editable_changed (GtkEditable* _sender,
                                        gpointer self);
static void __lambda19_ (Block6Data* _data6_);
static void ___lambda19__gtk_editable_changed (GtkEditable* _sender,
                                        gpointer self);
static gboolean __lambda20_ (Block6Data* _data6_,
                      gboolean is_active);
static gboolean ___lambda20__gtk_switch_state_set (GtkSwitch* _sender,
                                            gboolean state,
                                            gpointer self);
VALA_EXTERN ScanSide preferences_dialog_get_page_side (PreferencesDialog* self);
VALA_EXTERN void preferences_dialog_set_brightness (PreferencesDialog* self,
                                        gint brightness);
VALA_EXTERN void preferences_dialog_set_contrast (PreferencesDialog* self,
                                      gint contrast);
VALA_EXTERN gint preferences_dialog_get_page_delay (PreferencesDialog* self);
static void preferences_dialog_finalize (GObject * obj);
static GType preferences_dialog_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
preferences_dialog_get_instance_private (PreferencesDialog* self)
{
	return G_STRUCT_MEMBER_P (self, PreferencesDialog_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		PreferencesDialog* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->settings);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
__lambda4_ (Block6Data* _data6_)
{
	PreferencesDialog* self;
	self = _data6_->self;
	g_settings_set_int (_data6_->settings, "text-dpi", preferences_dialog_get_text_dpi (self));
}

static void
___lambda4__gtk_combo_box_changed (GtkComboBox* _sender,
                                   gpointer self)
{
	__lambda4_ (self);
}

static void
__lambda5_ (Block6Data* _data6_)
{
	PreferencesDialog* self;
	self = _data6_->self;
	g_settings_set_int (_data6_->settings, "photo-dpi", preferences_dialog_get_photo_dpi (self));
}

static void
___lambda5__gtk_combo_box_changed (GtkComboBox* _sender,
                                   gpointer self)
{
	__lambda5_ (self);
}

static void
__lambda6_ (Block6Data* _data6_,
            GtkToggleButton* button)
{
	PreferencesDialog* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data6_->self;
	g_return_if_fail (button != NULL);
	_tmp0_ = gtk_toggle_button_get_active (button);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		g_settings_set_enum (_data6_->settings, "page-side", (gint) SCAN_SIDE_FRONT);
	}
}

static void
___lambda6__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                       gpointer self)
{
	__lambda6_ (self, _sender);
}

static void
__lambda7_ (Block6Data* _data6_,
            GtkToggleButton* button)
{
	PreferencesDialog* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data6_->self;
	g_return_if_fail (button != NULL);
	_tmp0_ = gtk_toggle_button_get_active (button);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		g_settings_set_enum (_data6_->settings, "page-side", (gint) SCAN_SIDE_BACK);
	}
}

static void
___lambda7__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                       gpointer self)
{
	__lambda7_ (self, _sender);
}

static void
__lambda8_ (Block6Data* _data6_,
            GtkToggleButton* button)
{
	PreferencesDialog* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data6_->self;
	g_return_if_fail (button != NULL);
	_tmp0_ = gtk_toggle_button_get_active (button);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		g_settings_set_enum (_data6_->settings, "page-side", (gint) SCAN_SIDE_BOTH);
	}
}

static void
___lambda8__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                       gpointer self)
{
	__lambda8_ (self, _sender);
}

static void
__lambda9_ (Block6Data* _data6_)
{
	PreferencesDialog* self;
	self = _data6_->self;
	g_settings_set_int (_data6_->settings, "brightness", preferences_dialog_get_brightness (self));
}

static void
___lambda9__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                          gpointer self)
{
	__lambda9_ (self);
}

static void
__lambda10_ (Block6Data* _data6_)
{
	PreferencesDialog* self;
	self = _data6_->self;
	g_settings_set_int (_data6_->settings, "contrast", preferences_dialog_get_contrast (self));
}

static void
___lambda10__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                           gpointer self)
{
	__lambda10_ (self);
}

static void
__lambda11_ (Block6Data* _data6_)
{
	PreferencesDialog* self;
	gint w = 0;
	gint h = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	self = _data6_->self;
	preferences_dialog_get_paper_size (self, &_tmp0_, &_tmp1_);
	w = _tmp0_;
	h = _tmp1_;
	g_settings_set_int (_data6_->settings, "paper-width", w);
	g_settings_set_int (_data6_->settings, "paper-height", h);
}

static void
___lambda11__gtk_combo_box_changed (GtkComboBox* _sender,
                                    gpointer self)
{
	__lambda11_ (self);
}

static void
__lambda12_ (Block6Data* _data6_,
             GtkToggleButton* button)
{
	PreferencesDialog* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data6_->self;
	g_return_if_fail (button != NULL);
	_tmp0_ = gtk_toggle_button_get_active (button);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		g_settings_set_int (_data6_->settings, "page-delay", 0);
	}
}

static void
___lambda12__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                        gpointer self)
{
	__lambda12_ (self, _sender);
}

static void
__lambda13_ (Block6Data* _data6_,
             GtkToggleButton* button)
{
	PreferencesDialog* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data6_->self;
	g_return_if_fail (button != NULL);
	_tmp0_ = gtk_toggle_button_get_active (button);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		g_settings_set_int (_data6_->settings, "page-delay", 3000);
	}
}

static void
___lambda13__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                        gpointer self)
{
	__lambda13_ (self, _sender);
}

static void
__lambda14_ (Block6Data* _data6_,
             GtkToggleButton* button)
{
	PreferencesDialog* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data6_->self;
	g_return_if_fail (button != NULL);
	_tmp0_ = gtk_toggle_button_get_active (button);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		g_settings_set_int (_data6_->settings, "page-delay", 6000);
	}
}

static void
___lambda14__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                        gpointer self)
{
	__lambda14_ (self, _sender);
}

static void
__lambda15_ (Block6Data* _data6_,
             GtkToggleButton* button)
{
	PreferencesDialog* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data6_->self;
	g_return_if_fail (button != NULL);
	_tmp0_ = gtk_toggle_button_get_active (button);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		g_settings_set_int (_data6_->settings, "page-delay", 10000);
	}
}

static void
___lambda15__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                        gpointer self)
{
	__lambda15_ (self, _sender);
}

static void
__lambda16_ (Block6Data* _data6_,
             GtkToggleButton* button)
{
	PreferencesDialog* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data6_->self;
	g_return_if_fail (button != NULL);
	_tmp0_ = gtk_toggle_button_get_active (button);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		g_settings_set_int (_data6_->settings, "page-delay", 15000);
	}
}

static void
___lambda16__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                        gpointer self)
{
	__lambda16_ (self, _sender);
}

static gboolean
__lambda17_ (Block6Data* _data6_,
             gboolean is_active)
{
	PreferencesDialog* self;
	gboolean result;
	self = _data6_->self;
	preferences_dialog_toggle_postproc_visibility (self, is_active);
	g_settings_set_boolean (_data6_->settings, "postproc-enabled", is_active);
	result = TRUE;
	return result;
}

static gboolean
___lambda17__gtk_switch_state_set (GtkSwitch* _sender,
                                   gboolean state,
                                   gpointer self)
{
	gboolean result;
	result = __lambda17_ (self, state);
	return result;
}

static void
__lambda18_ (Block6Data* _data6_)
{
	PreferencesDialog* self;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	self = _data6_->self;
	_tmp0_ = self->priv->postproc_script_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	g_settings_set_string (_data6_->settings, "postproc-script", _tmp1_);
}

static void
___lambda18__gtk_editable_changed (GtkEditable* _sender,
                                   gpointer self)
{
	__lambda18_ (self);
}

static void
__lambda19_ (Block6Data* _data6_)
{
	PreferencesDialog* self;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	self = _data6_->self;
	_tmp0_ = self->priv->postproc_args_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	g_settings_set_string (_data6_->settings, "postproc-arguments", _tmp1_);
}

static void
___lambda19__gtk_editable_changed (GtkEditable* _sender,
                                   gpointer self)
{
	__lambda19_ (self);
}

static gboolean
__lambda20_ (Block6Data* _data6_,
             gboolean is_active)
{
	PreferencesDialog* self;
	gboolean result;
	self = _data6_->self;
	g_settings_set_boolean (_data6_->settings, "postproc-keep-original", is_active);
	result = TRUE;
	return result;
}

static gboolean
___lambda20__gtk_switch_state_set (GtkSwitch* _sender,
                                   gboolean state,
                                   gpointer self)
{
	gboolean result;
	result = __lambda20_ (self, state);
	return result;
}

PreferencesDialog*
preferences_dialog_construct (GType object_type,
                              GSettings* settings)
{
	PreferencesDialog * self = NULL;
	Block6Data* _data6_;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_ = {0};
	GtkListStore* _tmp4_;
	GtkTreeIter _tmp5_;
	GtkListStore* _tmp6_;
	GtkTreeIter _tmp7_ = {0};
	GtkListStore* _tmp8_;
	GtkTreeIter _tmp9_;
	GtkListStore* _tmp10_;
	GtkTreeIter _tmp11_ = {0};
	GtkListStore* _tmp12_;
	GtkTreeIter _tmp13_;
	GtkListStore* _tmp14_;
	GtkTreeIter _tmp15_ = {0};
	GtkListStore* _tmp16_;
	GtkTreeIter _tmp17_;
	GtkListStore* _tmp18_;
	GtkTreeIter _tmp19_ = {0};
	GtkListStore* _tmp20_;
	GtkTreeIter _tmp21_;
	GtkListStore* _tmp22_;
	GtkTreeIter _tmp23_ = {0};
	GtkListStore* _tmp24_;
	GtkTreeIter _tmp25_;
	GtkListStore* _tmp26_;
	GtkTreeIter _tmp27_ = {0};
	GtkListStore* _tmp28_;
	GtkTreeIter _tmp29_;
	GtkListStore* _tmp30_;
	GtkTreeIter _tmp31_ = {0};
	GtkListStore* _tmp32_;
	GtkTreeIter _tmp33_;
	gint dpi = 0;
	GtkComboBox* _tmp34_;
	GtkComboBox* _tmp35_;
	GtkComboBox* _tmp36_;
	GtkComboBox* _tmp37_;
	GtkRadioButton* _tmp38_;
	GtkRadioButton* _tmp39_;
	GtkRadioButton* _tmp40_;
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp41_;
	GtkComboBox* _tmp42_;
	GtkComboBox* _tmp43_;
	gdouble lower = 0.0;
	GtkAdjustment* _tmp44_;
	gdouble _tmp45_;
	gdouble _tmp46_;
	gchar* darker_label = NULL;
	gchar* _tmp47_;
	gdouble upper = 0.0;
	GtkAdjustment* _tmp48_;
	gdouble _tmp49_;
	gdouble _tmp50_;
	gchar* lighter_label = NULL;
	gchar* _tmp51_;
	GtkScale* _tmp52_;
	GtkScale* _tmp53_;
	GtkScale* _tmp54_;
	GtkAdjustment* _tmp55_;
	GtkAdjustment* _tmp56_;
	GtkAdjustment* _tmp57_;
	gdouble _tmp58_;
	gdouble _tmp59_;
	gchar* less_label = NULL;
	gchar* _tmp60_;
	GtkAdjustment* _tmp61_;
	gdouble _tmp62_;
	gdouble _tmp63_;
	gchar* more_label = NULL;
	gchar* _tmp64_;
	GtkScale* _tmp65_;
	GtkScale* _tmp66_;
	GtkScale* _tmp67_;
	GtkAdjustment* _tmp68_;
	GtkAdjustment* _tmp69_;
	gint paper_width = 0;
	gint paper_height = 0;
	GtkComboBox* _tmp70_;
	GtkRadioButton* _tmp71_;
	GtkRadioButton* _tmp72_;
	GtkRadioButton* _tmp73_;
	GtkRadioButton* _tmp74_;
	GtkRadioButton* _tmp75_;
	gboolean postproc_enabled = FALSE;
	GtkSwitch* _tmp76_;
	GtkSwitch* _tmp77_;
	gchar* postproc_script = NULL;
	gchar* _tmp78_;
	GtkEntry* _tmp79_;
	GtkEntry* _tmp80_;
	gchar* postproc_arguments = NULL;
	gchar* _tmp81_;
	GtkEntry* _tmp82_;
	GtkEntry* _tmp83_;
	gboolean postproc_keep_original = FALSE;
	GtkSwitch* _tmp84_;
	GtkSwitch* _tmp85_;
	g_return_val_if_fail (settings != NULL, NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (_data6_->settings);
	_data6_->settings = _tmp0_;
	self = (PreferencesDialog*) g_object_new (object_type, NULL);
	_data6_->self = g_object_ref (self);
	_tmp1_ = _g_object_ref0 (_data6_->settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	_tmp2_ = self->priv->paper_size_model;
	gtk_list_store_append (_tmp2_, &_tmp3_);
	iter = _tmp3_;
	_tmp4_ = self->priv->paper_size_model;
	_tmp5_ = iter;
	gtk_list_store_set (_tmp4_, &_tmp5_, 0, 0, 1, 0, 2, _ ("Automatic"), -1, -1);
	_tmp6_ = self->priv->paper_size_model;
	gtk_list_store_append (_tmp6_, &_tmp7_);
	iter = _tmp7_;
	_tmp8_ = self->priv->paper_size_model;
	_tmp9_ = iter;
	gtk_list_store_set (_tmp8_, &_tmp9_, 0, 1050, 1, 1480, 2, "A6", -1, -1);
	_tmp10_ = self->priv->paper_size_model;
	gtk_list_store_append (_tmp10_, &_tmp11_);
	iter = _tmp11_;
	_tmp12_ = self->priv->paper_size_model;
	_tmp13_ = iter;
	gtk_list_store_set (_tmp12_, &_tmp13_, 0, 1480, 1, 2100, 2, "A5", -1, -1);
	_tmp14_ = self->priv->paper_size_model;
	gtk_list_store_append (_tmp14_, &_tmp15_);
	iter = _tmp15_;
	_tmp16_ = self->priv->paper_size_model;
	_tmp17_ = iter;
	gtk_list_store_set (_tmp16_, &_tmp17_, 0, 2100, 1, 2970, 2, "A4", -1, -1);
	_tmp18_ = self->priv->paper_size_model;
	gtk_list_store_append (_tmp18_, &_tmp19_);
	iter = _tmp19_;
	_tmp20_ = self->priv->paper_size_model;
	_tmp21_ = iter;
	gtk_list_store_set (_tmp20_, &_tmp21_, 0, 2970, 1, 4200, 2, "A3", -1, -1);
	_tmp22_ = self->priv->paper_size_model;
	gtk_list_store_append (_tmp22_, &_tmp23_);
	iter = _tmp23_;
	_tmp24_ = self->priv->paper_size_model;
	_tmp25_ = iter;
	gtk_list_store_set (_tmp24_, &_tmp25_, 0, 2159, 1, 2794, 2, "Letter", -1, -1);
	_tmp26_ = self->priv->paper_size_model;
	gtk_list_store_append (_tmp26_, &_tmp27_);
	iter = _tmp27_;
	_tmp28_ = self->priv->paper_size_model;
	_tmp29_ = iter;
	gtk_list_store_set (_tmp28_, &_tmp29_, 0, 2159, 1, 3556, 2, "Legal", -1, -1);
	_tmp30_ = self->priv->paper_size_model;
	gtk_list_store_append (_tmp30_, &_tmp31_);
	iter = _tmp31_;
	_tmp32_ = self->priv->paper_size_model;
	_tmp33_ = iter;
	gtk_list_store_set (_tmp32_, &_tmp33_, 0, 1016, 1, 1524, 2, "4×6", -1, -1);
	dpi = g_settings_get_int (_data6_->settings, "text-dpi");
	if (dpi <= 0) {
		dpi = DEFAULT_TEXT_DPI;
	}
	_tmp34_ = self->priv->text_dpi_combo;
	preferences_dialog_set_dpi_combo (self, _tmp34_, DEFAULT_TEXT_DPI, dpi);
	_tmp35_ = self->priv->text_dpi_combo;
	g_signal_connect_data (_tmp35_, "changed", (GCallback) ___lambda4__gtk_combo_box_changed, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	dpi = g_settings_get_int (_data6_->settings, "photo-dpi");
	if (dpi <= 0) {
		dpi = DEFAULT_PHOTO_DPI;
	}
	_tmp36_ = self->priv->photo_dpi_combo;
	preferences_dialog_set_dpi_combo (self, _tmp36_, DEFAULT_PHOTO_DPI, dpi);
	_tmp37_ = self->priv->photo_dpi_combo;
	g_signal_connect_data (_tmp37_, "changed", (GCallback) ___lambda5__gtk_combo_box_changed, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	preferences_dialog_set_page_side (self, (ScanSide) g_settings_get_enum (_data6_->settings, "page-side"));
	_tmp38_ = self->priv->front_side_button;
	g_signal_connect_data ((GtkToggleButton*) _tmp38_, "toggled", (GCallback) ___lambda6__gtk_toggle_button_toggled, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp39_ = self->priv->back_side_button;
	g_signal_connect_data ((GtkToggleButton*) _tmp39_, "toggled", (GCallback) ___lambda7__gtk_toggle_button_toggled, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp40_ = self->priv->both_side_button;
	g_signal_connect_data ((GtkToggleButton*) _tmp40_, "toggled", (GCallback) ___lambda8__gtk_toggle_button_toggled, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp41_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp41_);
	renderer = _tmp41_;
	_tmp42_ = self->priv->paper_size_combo;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp42_, (GtkCellRenderer*) renderer, TRUE);
	_tmp43_ = self->priv->paper_size_combo;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp43_, (GtkCellRenderer*) renderer, "text", 2);
	_tmp44_ = self->priv->brightness_adjustment;
	_tmp45_ = gtk_adjustment_get_lower (_tmp44_);
	_tmp46_ = _tmp45_;
	lower = _tmp46_;
	_tmp47_ = g_strdup_printf ("<small>%s</small>", _ ("Darker"));
	darker_label = _tmp47_;
	_tmp48_ = self->priv->brightness_adjustment;
	_tmp49_ = gtk_adjustment_get_upper (_tmp48_);
	_tmp50_ = _tmp49_;
	upper = _tmp50_;
	_tmp51_ = g_strdup_printf ("<small>%s</small>", _ ("Lighter"));
	lighter_label = _tmp51_;
	_tmp52_ = self->priv->brightness_scale;
	gtk_scale_add_mark (_tmp52_, lower, GTK_POS_BOTTOM, darker_label);
	_tmp53_ = self->priv->brightness_scale;
	gtk_scale_add_mark (_tmp53_, (gdouble) 0, GTK_POS_BOTTOM, NULL);
	_tmp54_ = self->priv->brightness_scale;
	gtk_scale_add_mark (_tmp54_, upper, GTK_POS_BOTTOM, lighter_label);
	_tmp55_ = self->priv->brightness_adjustment;
	gtk_adjustment_set_value (_tmp55_, (gdouble) g_settings_get_int (_data6_->settings, "brightness"));
	_tmp56_ = self->priv->brightness_adjustment;
	g_signal_connect_data (_tmp56_, "value-changed", (GCallback) ___lambda9__gtk_adjustment_value_changed, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp57_ = self->priv->contrast_adjustment;
	_tmp58_ = gtk_adjustment_get_lower (_tmp57_);
	_tmp59_ = _tmp58_;
	lower = _tmp59_;
	_tmp60_ = g_strdup_printf ("<small>%s</small>", _ ("Less"));
	less_label = _tmp60_;
	_tmp61_ = self->priv->contrast_adjustment;
	_tmp62_ = gtk_adjustment_get_upper (_tmp61_);
	_tmp63_ = _tmp62_;
	upper = _tmp63_;
	_tmp64_ = g_strdup_printf ("<small>%s</small>", _ ("More"));
	more_label = _tmp64_;
	_tmp65_ = self->priv->contrast_scale;
	gtk_scale_add_mark (_tmp65_, lower, GTK_POS_BOTTOM, less_label);
	_tmp66_ = self->priv->contrast_scale;
	gtk_scale_add_mark (_tmp66_, (gdouble) 0, GTK_POS_BOTTOM, NULL);
	_tmp67_ = self->priv->contrast_scale;
	gtk_scale_add_mark (_tmp67_, upper, GTK_POS_BOTTOM, more_label);
	_tmp68_ = self->priv->contrast_adjustment;
	gtk_adjustment_set_value (_tmp68_, (gdouble) g_settings_get_int (_data6_->settings, "contrast"));
	_tmp69_ = self->priv->contrast_adjustment;
	g_signal_connect_data (_tmp69_, "value-changed", (GCallback) ___lambda10__gtk_adjustment_value_changed, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	paper_width = g_settings_get_int (_data6_->settings, "paper-width");
	paper_height = g_settings_get_int (_data6_->settings, "paper-height");
	preferences_dialog_set_paper_size (self, paper_width, paper_height);
	_tmp70_ = self->priv->paper_size_combo;
	g_signal_connect_data (_tmp70_, "changed", (GCallback) ___lambda11__gtk_combo_box_changed, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	preferences_dialog_set_page_delay (self, g_settings_get_int (_data6_->settings, "page-delay"));
	_tmp71_ = self->priv->page_delay_0s_button;
	g_signal_connect_data ((GtkToggleButton*) _tmp71_, "toggled", (GCallback) ___lambda12__gtk_toggle_button_toggled, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp72_ = self->priv->page_delay_3s_button;
	g_signal_connect_data ((GtkToggleButton*) _tmp72_, "toggled", (GCallback) ___lambda13__gtk_toggle_button_toggled, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp73_ = self->priv->page_delay_6s_button;
	g_signal_connect_data ((GtkToggleButton*) _tmp73_, "toggled", (GCallback) ___lambda14__gtk_toggle_button_toggled, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp74_ = self->priv->page_delay_10s_button;
	g_signal_connect_data ((GtkToggleButton*) _tmp74_, "toggled", (GCallback) ___lambda15__gtk_toggle_button_toggled, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp75_ = self->priv->page_delay_15s_button;
	g_signal_connect_data ((GtkToggleButton*) _tmp75_, "toggled", (GCallback) ___lambda16__gtk_toggle_button_toggled, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	postproc_enabled = g_settings_get_boolean (_data6_->settings, "postproc-enabled");
	_tmp76_ = self->priv->postproc_enable_switch;
	gtk_switch_set_state (_tmp76_, postproc_enabled);
	preferences_dialog_toggle_postproc_visibility (self, postproc_enabled);
	_tmp77_ = self->priv->postproc_enable_switch;
	g_signal_connect_data (_tmp77_, "state-set", (GCallback) ___lambda17__gtk_switch_state_set, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp78_ = g_settings_get_string (_data6_->settings, "postproc-script");
	postproc_script = _tmp78_;
	_tmp79_ = self->priv->postproc_script_entry;
	gtk_entry_set_text (_tmp79_, postproc_script);
	_tmp80_ = self->priv->postproc_script_entry;
	g_signal_connect_data ((GtkEditable*) _tmp80_, "changed", (GCallback) ___lambda18__gtk_editable_changed, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp81_ = g_settings_get_string (_data6_->settings, "postproc-arguments");
	postproc_arguments = _tmp81_;
	_tmp82_ = self->priv->postproc_args_entry;
	gtk_entry_set_text (_tmp82_, postproc_arguments);
	_tmp83_ = self->priv->postproc_args_entry;
	g_signal_connect_data ((GtkEditable*) _tmp83_, "changed", (GCallback) ___lambda19__gtk_editable_changed, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	postproc_keep_original = g_settings_get_boolean (_data6_->settings, "postproc-keep-original");
	_tmp84_ = self->priv->postproc_keep_original_switch;
	gtk_switch_set_state (_tmp84_, postproc_keep_original);
	_tmp85_ = self->priv->postproc_keep_original_switch;
	g_signal_connect_data (_tmp85_, "state-set", (GCallback) ___lambda20__gtk_switch_state_set, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_g_free0 (postproc_arguments);
	_g_free0 (postproc_script);
	_g_free0 (more_label);
	_g_free0 (less_label);
	_g_free0 (lighter_label);
	_g_free0 (darker_label);
	_g_object_unref0 (renderer);
	block6_data_unref (_data6_);
	_data6_ = NULL;
	return self;
}

PreferencesDialog*
preferences_dialog_new (GSettings* settings)
{
	return preferences_dialog_construct (TYPE_PREFERENCES_DIALOG, settings);
}

static void
preferences_dialog_toggle_postproc_visibility (PreferencesDialog* self,
                                               gboolean enabled)
{
	GtkEntry* _tmp0_;
	GtkContainer* _tmp1_;
	GtkContainer* _tmp2_;
	GtkContainer* _tmp3_;
	GtkContainer* _tmp4_;
	GtkEntry* _tmp5_;
	GtkContainer* _tmp6_;
	GtkContainer* _tmp7_;
	GtkContainer* _tmp8_;
	GtkContainer* _tmp9_;
	GtkSwitch* _tmp10_;
	GtkContainer* _tmp11_;
	GtkContainer* _tmp12_;
	GtkContainer* _tmp13_;
	GtkContainer* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->postproc_script_entry;
	_tmp1_ = gtk_widget_get_parent ((GtkWidget*) _tmp0_);
	_tmp2_ = gtk_widget_get_parent ((GtkWidget*) _tmp1_);
	_tmp3_ = gtk_widget_get_parent ((GtkWidget*) _tmp2_);
	_tmp4_ = gtk_widget_get_parent ((GtkWidget*) _tmp3_);
	gtk_widget_set_visible ((GtkWidget*) _tmp4_, enabled);
	_tmp5_ = self->priv->postproc_args_entry;
	_tmp6_ = gtk_widget_get_parent ((GtkWidget*) _tmp5_);
	_tmp7_ = gtk_widget_get_parent ((GtkWidget*) _tmp6_);
	_tmp8_ = gtk_widget_get_parent ((GtkWidget*) _tmp7_);
	_tmp9_ = gtk_widget_get_parent ((GtkWidget*) _tmp8_);
	gtk_widget_set_visible ((GtkWidget*) _tmp9_, enabled);
	_tmp10_ = self->priv->postproc_keep_original_switch;
	_tmp11_ = gtk_widget_get_parent ((GtkWidget*) _tmp10_);
	_tmp12_ = gtk_widget_get_parent ((GtkWidget*) _tmp11_);
	_tmp13_ = gtk_widget_get_parent ((GtkWidget*) _tmp12_);
	_tmp14_ = gtk_widget_get_parent ((GtkWidget*) _tmp13_);
	gtk_widget_set_visible ((GtkWidget*) _tmp14_, enabled);
}

static void
preferences_dialog_set_page_side (PreferencesDialog* self,
                                  ScanSide page_side)
{
	g_return_if_fail (self != NULL);
	switch (page_side) {
		case SCAN_SIDE_FRONT:
		{
			GtkRadioButton* _tmp0_;
			_tmp0_ = self->priv->front_side_button;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, TRUE);
			break;
		}
		case SCAN_SIDE_BACK:
		{
			GtkRadioButton* _tmp1_;
			_tmp1_ = self->priv->back_side_button;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp1_, TRUE);
			break;
		}
		default:
		case SCAN_SIDE_BOTH:
		{
			GtkRadioButton* _tmp2_;
			_tmp2_ = self->priv->both_side_button;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp2_, TRUE);
			break;
		}
	}
}

ScanSide
preferences_dialog_get_page_side (PreferencesDialog* self)
{
	GtkRadioButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ScanSide result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->front_side_button;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		result = SCAN_SIDE_FRONT;
		return result;
	} else {
		GtkRadioButton* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = self->priv->back_side_button;
		_tmp4_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			result = SCAN_SIDE_BACK;
			return result;
		} else {
			result = SCAN_SIDE_BOTH;
			return result;
		}
	}
}

void
preferences_dialog_set_paper_size (PreferencesDialog* self,
                                   gint width,
                                   gint height)
{
	GtkTreeIter iter = {0};
	gboolean have_iter = FALSE;
	g_return_if_fail (self != NULL);
	{
		GtkListStore* _tmp0_;
		GtkTreeIter _tmp1_ = {0};
		gboolean _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp0_ = self->priv->paper_size_model;
		_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
		iter = _tmp1_;
		have_iter = _tmp2_;
		_tmp3_ = TRUE;
		while (TRUE) {
			gint w = 0;
			gint h = 0;
			GtkListStore* _tmp6_;
			GtkTreeIter _tmp7_;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gboolean _tmp10_ = FALSE;
			if (!_tmp3_) {
				GtkListStore* _tmp4_;
				gboolean _tmp5_;
				_tmp4_ = self->priv->paper_size_model;
				_tmp5_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp4_, &iter);
				have_iter = _tmp5_;
			}
			_tmp3_ = FALSE;
			if (!have_iter) {
				break;
			}
			_tmp6_ = self->priv->paper_size_model;
			_tmp7_ = iter;
			gtk_tree_model_get ((GtkTreeModel*) _tmp6_, &_tmp7_, 0, &_tmp8_, 1, &_tmp9_, -1, -1);
			w = _tmp8_;
			h = _tmp9_;
			if (w == width) {
				_tmp10_ = h == height;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				break;
			}
		}
	}
	if (!have_iter) {
		GtkListStore* _tmp11_;
		GtkTreeIter _tmp12_ = {0};
		gboolean _tmp13_;
		_tmp11_ = self->priv->paper_size_model;
		_tmp13_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp11_, &_tmp12_);
		iter = _tmp12_;
		have_iter = _tmp13_;
	}
	if (have_iter) {
		GtkComboBox* _tmp14_;
		GtkTreeIter _tmp15_;
		_tmp14_ = self->priv->paper_size_combo;
		_tmp15_ = iter;
		gtk_combo_box_set_active_iter (_tmp14_, &_tmp15_);
	}
}

gint
preferences_dialog_get_text_dpi (PreferencesDialog* self)
{
	GtkTreeIter iter = {0};
	gint dpi = 0;
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	dpi = DEFAULT_TEXT_DPI;
	_tmp0_ = self->priv->text_dpi_combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		GtkListStore* _tmp3_;
		GtkTreeIter _tmp4_;
		gint _tmp5_ = 0;
		_tmp3_ = self->priv->text_dpi_model;
		_tmp4_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &_tmp5_, -1, -1);
		dpi = _tmp5_;
	}
	result = dpi;
	return result;
}

gint
preferences_dialog_get_photo_dpi (PreferencesDialog* self)
{
	GtkTreeIter iter = {0};
	gint dpi = 0;
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	dpi = DEFAULT_PHOTO_DPI;
	_tmp0_ = self->priv->photo_dpi_combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		GtkListStore* _tmp3_;
		GtkTreeIter _tmp4_;
		gint _tmp5_ = 0;
		_tmp3_ = self->priv->photo_dpi_model;
		_tmp4_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &_tmp5_, -1, -1);
		dpi = _tmp5_;
	}
	result = dpi;
	return result;
}

gboolean
preferences_dialog_get_paper_size (PreferencesDialog* self,
                                   gint* width,
                                   gint* height)
{
	gint _vala_width = 0;
	gint _vala_height = 0;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_height = 0;
	_vala_width = _vala_height;
	_tmp0_ = self->priv->paper_size_combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		GtkListStore* _tmp3_;
		GtkTreeIter _tmp4_;
		_tmp3_ = self->priv->paper_size_model;
		_tmp4_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &_vala_width, 1, &_vala_height, -1, -1);
		result = TRUE;
		if (width) {
			*width = _vala_width;
		}
		if (height) {
			*height = _vala_height;
		}
		return result;
	}
	result = FALSE;
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
	return result;
}

gint
preferences_dialog_get_brightness (PreferencesDialog* self)
{
	GtkAdjustment* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->brightness_adjustment;
	_tmp1_ = gtk_adjustment_get_value (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (gint) _tmp2_;
	return result;
}

void
preferences_dialog_set_brightness (PreferencesDialog* self,
                                   gint brightness)
{
	GtkAdjustment* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->brightness_adjustment;
	gtk_adjustment_set_value (_tmp0_, (gdouble) brightness);
}

gint
preferences_dialog_get_contrast (PreferencesDialog* self)
{
	GtkAdjustment* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->contrast_adjustment;
	_tmp1_ = gtk_adjustment_get_value (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (gint) _tmp2_;
	return result;
}

void
preferences_dialog_set_contrast (PreferencesDialog* self,
                                 gint contrast)
{
	GtkAdjustment* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->contrast_adjustment;
	gtk_adjustment_set_value (_tmp0_, (gdouble) contrast);
}

gint
preferences_dialog_get_page_delay (PreferencesDialog* self)
{
	GtkRadioButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->page_delay_15s_button;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		result = 15000;
		return result;
	} else {
		GtkRadioButton* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = self->priv->page_delay_10s_button;
		_tmp4_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			result = 10000;
			return result;
		} else {
			GtkRadioButton* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
			_tmp6_ = self->priv->page_delay_6s_button;
			_tmp7_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp6_);
			_tmp8_ = _tmp7_;
			if (_tmp8_) {
				result = 6000;
				return result;
			} else {
				GtkRadioButton* _tmp9_;
				gboolean _tmp10_;
				gboolean _tmp11_;
				_tmp9_ = self->priv->page_delay_3s_button;
				_tmp10_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp9_);
				_tmp11_ = _tmp10_;
				if (_tmp11_) {
					result = 3000;
					return result;
				} else {
					result = 0;
					return result;
				}
			}
		}
	}
}

void
preferences_dialog_set_page_delay (PreferencesDialog* self,
                                   gint page_delay)
{
	g_return_if_fail (self != NULL);
	if (page_delay >= 15000) {
		GtkRadioButton* _tmp0_;
		_tmp0_ = self->priv->page_delay_15s_button;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, TRUE);
	} else {
		if (page_delay >= 10000) {
			GtkRadioButton* _tmp1_;
			_tmp1_ = self->priv->page_delay_10s_button;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp1_, TRUE);
		} else {
			if (page_delay >= 6000) {
				GtkRadioButton* _tmp2_;
				_tmp2_ = self->priv->page_delay_6s_button;
				gtk_toggle_button_set_active ((GtkToggleButton*) _tmp2_, TRUE);
			} else {
				if (page_delay >= 3000) {
					GtkRadioButton* _tmp3_;
					_tmp3_ = self->priv->page_delay_3s_button;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp3_, TRUE);
				} else {
					GtkRadioButton* _tmp4_;
					_tmp4_ = self->priv->page_delay_0s_button;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp4_, TRUE);
				}
			}
		}
	}
}

static void
preferences_dialog_set_dpi_combo (PreferencesDialog* self,
                                  GtkComboBox* combo,
                                  gint default_dpi,
                                  gint current_dpi)
{
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp0_;
	GtkCellRendererText* _tmp1_;
	GtkCellRendererText* _tmp2_;
	GtkListStore* model = NULL;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkListStore* _tmp5_;
	gint* scan_resolutions = NULL;
	gint* _tmp6_;
	gint scan_resolutions_length1;
	gint _scan_resolutions_size_;
	gint* _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp0_);
	renderer = _tmp0_;
	_tmp1_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) combo, (GtkCellRenderer*) _tmp1_, TRUE);
	_tmp2_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) combo, (GtkCellRenderer*) _tmp2_, "text", 1);
	_tmp3_ = gtk_combo_box_get_model (combo);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_list_store_get_type ()) ? ((GtkListStore*) _tmp4_) : NULL);
	model = _tmp5_;
	_tmp6_ = g_new0 (gint, 7);
	_tmp6_[0] = 75;
	_tmp6_[1] = 150;
	_tmp6_[2] = 200;
	_tmp6_[3] = 300;
	_tmp6_[4] = 600;
	_tmp6_[5] = 1200;
	_tmp6_[6] = 2400;
	scan_resolutions = _tmp6_;
	scan_resolutions_length1 = 7;
	_scan_resolutions_size_ = scan_resolutions_length1;
	_tmp7_ = scan_resolutions;
	_tmp7__length1 = scan_resolutions_length1;
	{
		gint* dpi_collection = NULL;
		gint dpi_collection_length1 = 0;
		gint _dpi_collection_size_ = 0;
		gint dpi_it = 0;
		dpi_collection = _tmp7_;
		dpi_collection_length1 = _tmp7__length1;
		for (dpi_it = 0; dpi_it < dpi_collection_length1; dpi_it = dpi_it + 1) {
			gint dpi = 0;
			dpi = dpi_collection[dpi_it];
			{
				gchar* label = NULL;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp12_;
				GtkTreeIter _tmp13_ = {0};
				GtkListStore* _tmp14_;
				GtkTreeIter _tmp15_;
				const gchar* _tmp16_;
				if (dpi == default_dpi) {
					gchar* _tmp8_;
					_tmp8_ = g_strdup_printf (_ ("%d dpi (default)"), dpi);
					_g_free0 (label);
					label = _tmp8_;
				} else {
					if (dpi == 75) {
						gchar* _tmp9_;
						_tmp9_ = g_strdup_printf (_ ("%d dpi (draft)"), dpi);
						_g_free0 (label);
						label = _tmp9_;
					} else {
						if (dpi == 1200) {
							gchar* _tmp10_;
							_tmp10_ = g_strdup_printf (_ ("%d dpi (high resolution)"), dpi);
							_g_free0 (label);
							label = _tmp10_;
						} else {
							gchar* _tmp11_;
							_tmp11_ = g_strdup_printf (_ ("%d dpi"), dpi);
							_g_free0 (label);
							label = _tmp11_;
						}
					}
				}
				_tmp12_ = model;
				gtk_list_store_append (_tmp12_, &_tmp13_);
				iter = _tmp13_;
				_tmp14_ = model;
				_tmp15_ = iter;
				_tmp16_ = label;
				gtk_list_store_set (_tmp14_, &_tmp15_, 0, dpi, 1, _tmp16_, -1, -1);
				if (dpi == current_dpi) {
					GtkTreeIter _tmp17_;
					_tmp17_ = iter;
					gtk_combo_box_set_active_iter (combo, &_tmp17_);
				}
				_g_free0 (label);
			}
		}
	}
	scan_resolutions = (g_free (scan_resolutions), NULL);
	_g_object_unref0 (model);
	_g_object_unref0 (renderer);
}

static void
preferences_dialog_class_init (PreferencesDialogClass * klass,
                               gpointer klass_data)
{
	preferences_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PreferencesDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = preferences_dialog_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/SimpleScan/ui/preferences-dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "text_dpi_combo", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, text_dpi_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "photo_dpi_combo", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, photo_dpi_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "paper_size_combo", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, paper_size_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "brightness_scale", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, brightness_scale));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contrast_scale", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, contrast_scale));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "page_delay_0s_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, page_delay_0s_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "page_delay_3s_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, page_delay_3s_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "page_delay_6s_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, page_delay_6s_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "page_delay_10s_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, page_delay_10s_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "page_delay_15s_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, page_delay_15s_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "text_dpi_model", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, text_dpi_model));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "photo_dpi_model", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, photo_dpi_model));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "front_side_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, front_side_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "back_side_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, back_side_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "both_side_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, both_side_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "paper_size_model", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, paper_size_model));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "brightness_adjustment", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, brightness_adjustment));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contrast_adjustment", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, contrast_adjustment));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "postproc_enable_switch", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, postproc_enable_switch));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "postproc_script_entry", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, postproc_script_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "postproc_args_entry", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, postproc_args_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "postproc_keep_original_switch", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, postproc_keep_original_switch));
}

static void
preferences_dialog_instance_init (PreferencesDialog * self,
                                  gpointer klass)
{
	self->priv = preferences_dialog_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
preferences_dialog_finalize (GObject * obj)
{
	PreferencesDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PREFERENCES_DIALOG, PreferencesDialog);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (preferences_dialog_parent_class)->finalize (obj);
}

static GType
preferences_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PreferencesDialog), 0, (GInstanceInitFunc) preferences_dialog_instance_init, NULL };
	GType preferences_dialog_type_id;
	preferences_dialog_type_id = g_type_register_static (hdy_preferences_window_get_type (), "PreferencesDialog", &g_define_type_info, 0);
	PreferencesDialog_private_offset = g_type_add_instance_private (preferences_dialog_type_id, sizeof (PreferencesDialogPrivate));
	return preferences_dialog_type_id;
}

GType
preferences_dialog_get_type (void)
{
	static volatile gsize preferences_dialog_type_id__once = 0;
	if (g_once_init_enter (&preferences_dialog_type_id__once)) {
		GType preferences_dialog_type_id;
		preferences_dialog_type_id = preferences_dialog_get_type_once ();
		g_once_init_leave (&preferences_dialog_type_id__once, preferences_dialog_type_id);
	}
	return preferences_dialog_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

