/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import java.util.Collection;
import org.eclipse.jdt.internal.compiler.util.CharArrayHashMap;
import org.eclipse.jdt.internal.compiler.util.CharArrayMap;
import org.eclipse.jdt.internal.compiler.util.CharArrayMapper;

public class CharDelegateMap<P>
implements CharArrayMapper<P> {
    private static final int SMAL_BIG_THRESHOLD = 5;
    CharArrayMap<P> smallDelegate;
    CharArrayHashMap<P> bigDelegate;

    public CharDelegateMap() {
        this(0);
    }

    private CharArrayMapper<P> getDelegate() {
        return this.smallDelegate == null ? this.bigDelegate : this.smallDelegate;
    }

    public CharDelegateMap(int n) {
        if (n > 5) {
            this.bigDelegate = new CharArrayHashMap(n);
        } else {
            this.smallDelegate = new CharArrayMap(n);
        }
    }

    @Override
    public Collection<P> values() {
        return this.getDelegate().values();
    }

    @Override
    public boolean containsKey(char[] cArray) {
        return this.getDelegate().containsKey(cArray);
    }

    @Override
    public P get(char[] cArray) {
        if (this.smallDelegate != null) {
            return this.smallDelegate.get(cArray);
        }
        return this.bigDelegate.get(cArray);
    }

    @Override
    public P put(char[] cArray, P p) {
        if (this.smallDelegate != null) {
            P p2 = this.smallDelegate.put(cArray, p);
            if (this.smallDelegate.size() > 5) {
                this.toBigMap();
            }
            return p2;
        }
        return this.bigDelegate.put(cArray, p);
    }

    private void toBigMap() {
        this.bigDelegate = new CharArrayHashMap(this.smallDelegate.size());
        this.smallDelegate.transferTo(this.bigDelegate);
        this.smallDelegate = null;
    }

    @Override
    public int size() {
        return this.getDelegate().size();
    }

    public String toString() {
        return CharArrayMapper.toString(this);
    }

    @Override
    public Collection<char[]> keys() {
        return this.getDelegate().keys();
    }
}

