/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.spnego;

import java.io.IOException;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.spnego.SpNegoToken;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

public class NegTokenTarg
extends SpNegoToken {
    private int negResult = 0;
    private Oid supportedMech = null;
    private byte[] responseToken = null;
    private byte[] mechListMIC = null;

    NegTokenTarg(int n, Oid oid, byte[] byArray, byte[] byArray2) {
        super(1);
        this.negResult = n;
        this.supportedMech = oid;
        this.responseToken = byArray;
        this.mechListMIC = byArray2;
    }

    public NegTokenTarg(byte[] byArray) throws GSSException {
        super(1);
        this.parseToken(byArray);
    }

    @Override
    final byte[] encode() throws GSSException {
        try {
            DerOutputStream derOutputStream;
            DerOutputStream derOutputStream2 = new DerOutputStream();
            DerOutputStream derOutputStream3 = new DerOutputStream();
            derOutputStream3.putEnumerated(this.negResult);
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream3);
            if (this.supportedMech != null) {
                derOutputStream = new DerOutputStream();
                byte[] byArray = this.supportedMech.getDER();
                derOutputStream.write(byArray);
                derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream);
            }
            if (this.responseToken != null) {
                derOutputStream = new DerOutputStream();
                derOutputStream.putOctetString(this.responseToken);
                derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)2), derOutputStream);
            }
            if (this.mechListMIC != null) {
                if (DEBUG) {
                    System.out.println("SpNegoToken NegTokenTarg: sending MechListMIC");
                }
                derOutputStream = new DerOutputStream();
                derOutputStream.putOctetString(this.mechListMIC);
                derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)3), derOutputStream);
            } else if (GSSUtil.useMSInterop() && this.responseToken != null) {
                if (DEBUG) {
                    System.out.println("SpNegoToken NegTokenTarg: sending additional token for MS Interop");
                }
                derOutputStream = new DerOutputStream();
                derOutputStream.putOctetString(this.responseToken);
                derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)3), derOutputStream);
            }
            derOutputStream = new DerOutputStream();
            derOutputStream.write((byte)48, derOutputStream2);
            return derOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new GSSException(10, -1, "Invalid SPNEGO NegTokenTarg token : " + iOException.getMessage());
        }
    }

    private void parseToken(byte[] byArray) throws GSSException {
        try {
            DerValue derValue = new DerValue(byArray);
            if (!derValue.isContextSpecific((byte)1)) {
                throw new IOException("SPNEGO NegoTokenTarg : did not have the right token type");
            }
            DerValue derValue2 = derValue.data.getDerValue();
            if (derValue2.tag != 48) {
                throw new IOException("SPNEGO NegoTokenTarg : did not have the Sequence tag");
            }
            int n = -1;
            while (derValue2.data.available() > 0) {
                DerValue derValue3 = derValue2.data.getDerValue();
                if (derValue3.isContextSpecific((byte)0)) {
                    n = NegTokenTarg.checkNextField(n, 0);
                    this.negResult = derValue3.data.getEnumerated();
                    if (!DEBUG) continue;
                    System.out.println("SpNegoToken NegTokenTarg: negotiated result = " + NegTokenTarg.getNegoResultString(this.negResult));
                    continue;
                }
                if (derValue3.isContextSpecific((byte)1)) {
                    n = NegTokenTarg.checkNextField(n, 1);
                    ObjectIdentifier objectIdentifier = derValue3.data.getOID();
                    this.supportedMech = new Oid(objectIdentifier.toString());
                    if (!DEBUG) continue;
                    System.out.println("SpNegoToken NegTokenTarg: supported mechanism = " + this.supportedMech);
                    continue;
                }
                if (derValue3.isContextSpecific((byte)2)) {
                    n = NegTokenTarg.checkNextField(n, 2);
                    this.responseToken = derValue3.data.getOctetString();
                    continue;
                }
                if (!derValue3.isContextSpecific((byte)3)) continue;
                n = NegTokenTarg.checkNextField(n, 3);
                if (GSSUtil.useMSInterop()) continue;
                this.mechListMIC = derValue3.data.getOctetString();
                if (!DEBUG) continue;
                System.out.println("SpNegoToken NegTokenTarg: MechListMIC Token = " + NegTokenTarg.getHexBytes(this.mechListMIC));
            }
        }
        catch (IOException iOException) {
            throw new GSSException(10, -1, "Invalid SPNEGO NegTokenTarg token : " + iOException.getMessage());
        }
    }

    int getNegotiatedResult() {
        return this.negResult;
    }

    public Oid getSupportedMech() {
        return this.supportedMech;
    }

    byte[] getResponseToken() {
        return this.responseToken;
    }

    byte[] getMechListMIC() {
        return this.mechListMIC;
    }
}

