
#ifndef KHOLIDAYS_EXPORT_H
#define KHOLIDAYS_EXPORT_H

#ifdef KHOLIDAYS_STATIC_DEFINE
#  define KHOLIDAYS_EXPORT
#  define KHOLIDAYS_NO_EXPORT
#else
#  ifndef KHOLIDAYS_EXPORT
#    ifdef KF5Holidays_EXPORTS
        /* We are building this library */
#      define KHOLIDAYS_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KHOLIDAYS_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KHOLIDAYS_NO_EXPORT
#    define KHOLIDAYS_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KHOLIDAYS_DECL_DEPRECATED
#  define KHOLIDAYS_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KHOLIDAYS_DECL_DEPRECATED_EXPORT
#  define KHOLIDAYS_DECL_DEPRECATED_EXPORT KHOLIDAYS_EXPORT KHOLIDAYS_DECL_DEPRECATED
#endif

#ifndef KHOLIDAYS_DECL_DEPRECATED_NO_EXPORT
#  define KHOLIDAYS_DECL_DEPRECATED_NO_EXPORT KHOLIDAYS_NO_EXPORT KHOLIDAYS_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KHOLIDAYS_NO_DEPRECATED
#    define KHOLIDAYS_NO_DEPRECATED
#  endif
#endif

#define KHOLIDAYS_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KHOLIDAYS_NO_DEPRECATED) && !defined(KHOLIDAYS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KHOLIDAYS_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KHOLIDAYS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KHOLIDAYS_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KHOLIDAYS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KHOLIDAYS_NO_DEPRECATED_WARNINGS) && !defined(KHOLIDAYS_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KHOLIDAYS_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KHOLIDAYS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KHOLIDAYS_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KHOLIDAYS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KHOLIDAYS_NO_DEPRECATED)
#  undef KHOLIDAYS_DEPRECATED
#  define KHOLIDAYS_DEPRECATED_EXPORT KHOLIDAYS_EXPORT
#  define KHOLIDAYS_DEPRECATED_NO_EXPORT KHOLIDAYS_NO_EXPORT
#elif defined(KHOLIDAYS_NO_DEPRECATED_WARNINGS)
#  define KHOLIDAYS_DEPRECATED
#  define KHOLIDAYS_DEPRECATED_EXPORT KHOLIDAYS_EXPORT
#  define KHOLIDAYS_DEPRECATED_NO_EXPORT KHOLIDAYS_NO_EXPORT
#else
#  define KHOLIDAYS_DEPRECATED KHOLIDAYS_DECL_DEPRECATED
#  define KHOLIDAYS_DEPRECATED_EXPORT KHOLIDAYS_DECL_DEPRECATED_EXPORT
#  define KHOLIDAYS_DEPRECATED_NO_EXPORT KHOLIDAYS_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KHOLIDAYS_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KHOLIDAYS_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KHOLIDAYS_NO_DEPRECATED
#  define KHOLIDAYS_DISABLE_DEPRECATED_BEFORE_AND_AT 0x56600
#endif
#ifdef KHOLIDAYS_NO_DEPRECATED_WARNINGS
#  define KHOLIDAYS_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KHOLIDAYS_DEPRECATED_WARNINGS_SINCE
#  ifdef KHOLIDAYS_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KHOLIDAYS_DEPRECATED_WARNINGS_SINCE KHOLIDAYS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KHOLIDAYS_DEPRECATED_WARNINGS_SINCE 0x56600
#  endif
#endif

#ifndef KHOLIDAYS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KHOLIDAYS_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KHOLIDAYS_DEPRECATED
#  define KHOLIDAYS_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KHOLIDAYS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KHOLIDAYS_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KHOLIDAYS_DEPRECATED_WARNINGS_SINCE >= 0x55f00
#  define KHOLIDAYS_DEPRECATED_VERSION_5_95(text) KHOLIDAYS_DECL_DEPRECATED_TEXT(text)
#else
#  define KHOLIDAYS_DEPRECATED_VERSION_5_95(text)
#endif
#define KHOLIDAYS_DEPRECATED_VERSION_5(minor, text)      KHOLIDAYS_DEPRECATED_VERSION_5_##minor(text)
#define KHOLIDAYS_DEPRECATED_VERSION(major, minor, text) KHOLIDAYS_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KHOLIDAYS_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KHOLIDAYS_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KHOLIDAYS_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KHOLIDAYS_DEPRECATED_VERSION(major, minor, text)
#  define KHOLIDAYS_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KHOLIDAYS_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KHOLIDAYS_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KHOLIDAYS_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KHOLIDAYS_EXPORT_H */


#ifndef ECM_GENERATEEXPORTHEADER_KHOLIDAYS_EXPORT_H
#define ECM_GENERATEEXPORTHEADER_KHOLIDAYS_EXPORT_H


#define KHOLIDAYS_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KHOLIDAYS_NO_DEPRECATED) && !defined(KHOLIDAYS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KHOLIDAYS_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KHOLIDAYS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KHOLIDAYS_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KHOLIDAYS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KHOLIDAYS_NO_DEPRECATED_WARNINGS) && !defined(KHOLIDAYS_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KHOLIDAYS_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KHOLIDAYS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KHOLIDAYS_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KHOLIDAYS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KHOLIDAYS_NO_DEPRECATED)
#  undef KHOLIDAYS_DEPRECATED
#  define KHOLIDAYS_DEPRECATED_EXPORT KHOLIDAYS_EXPORT
#  define KHOLIDAYS_DEPRECATED_NO_EXPORT KHOLIDAYS_NO_EXPORT
#elif defined(KHOLIDAYS_NO_DEPRECATED_WARNINGS)
#  define KHOLIDAYS_DEPRECATED
#  define KHOLIDAYS_DEPRECATED_EXPORT KHOLIDAYS_EXPORT
#  define KHOLIDAYS_DEPRECATED_NO_EXPORT KHOLIDAYS_NO_EXPORT
#else
#  define KHOLIDAYS_DEPRECATED KHOLIDAYS_DECL_DEPRECATED
#  define KHOLIDAYS_DEPRECATED_EXPORT KHOLIDAYS_DECL_DEPRECATED_EXPORT
#  define KHOLIDAYS_DEPRECATED_NO_EXPORT KHOLIDAYS_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KHOLIDAYS_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KHOLIDAYS_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KHOLIDAYS_NO_DEPRECATED
#  define KHOLIDAYS_DISABLE_DEPRECATED_BEFORE_AND_AT 0x56600
#endif
#ifdef KHOLIDAYS_NO_DEPRECATED_WARNINGS
#  define KHOLIDAYS_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KHOLIDAYS_DEPRECATED_WARNINGS_SINCE
#  ifdef KHOLIDAYS_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KHOLIDAYS_DEPRECATED_WARNINGS_SINCE KHOLIDAYS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KHOLIDAYS_DEPRECATED_WARNINGS_SINCE 0x56600
#  endif
#endif

#ifndef KHOLIDAYS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KHOLIDAYS_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KHOLIDAYS_DEPRECATED
#  define KHOLIDAYS_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KHOLIDAYS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KHOLIDAYS_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KHOLIDAYS_DEPRECATED_WARNINGS_SINCE >= 0x55f00
#  define KHOLIDAYS_DEPRECATED_VERSION_5_95(text) KHOLIDAYS_DECL_DEPRECATED_TEXT(text)
#else
#  define KHOLIDAYS_DEPRECATED_VERSION_5_95(text)
#endif
#define KHOLIDAYS_DEPRECATED_VERSION_5(minor, text)      KHOLIDAYS_DEPRECATED_VERSION_5_##minor(text)
#define KHOLIDAYS_DEPRECATED_VERSION(major, minor, text) KHOLIDAYS_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KHOLIDAYS_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KHOLIDAYS_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KHOLIDAYS_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KHOLIDAYS_DEPRECATED_VERSION(major, minor, text)
#  define KHOLIDAYS_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KHOLIDAYS_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KHOLIDAYS_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KHOLIDAYS_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif


#endif /* ECM_GENERATEEXPORTHEADER_KHOLIDAYS_EXPORT_H */
