/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.storeconfig;

import java.io.PrintWriter;
import org.apache.catalina.Manager;
import org.apache.catalina.SessionIdGenerator;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.storeconfig.StoreDescription;
import org.apache.catalina.storeconfig.StoreFactoryBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class ManagerSF
extends StoreFactoryBase {
    private static Log log = LogFactory.getLog(ManagerSF.class);

    @Override
    public void store(PrintWriter printWriter, int n, Object object) throws Exception {
        StoreDescription storeDescription = this.getRegistry().findDescription(object.getClass());
        if (storeDescription != null) {
            if (object instanceof StandardManager) {
                StandardManager standardManager = (StandardManager)object;
                if (!this.isDefaultManager(standardManager)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("factory.storeTag", new Object[]{storeDescription.getTag(), object}));
                    }
                    super.store(printWriter, n, object);
                }
            } else {
                super.store(printWriter, n, object);
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)sm.getString("factory.storeNoDescriptor", new Object[]{object.getClass()}));
        }
    }

    protected boolean isDefaultManager(StandardManager standardManager) {
        return "SESSIONS.ser".equals(standardManager.getPathname()) && standardManager.getMaxActiveSessions() == -1;
    }

    @Override
    public void storeChildren(PrintWriter printWriter, int n, Object object, StoreDescription storeDescription) throws Exception {
        Manager manager;
        SessionIdGenerator sessionIdGenerator;
        if (object instanceof Manager && (sessionIdGenerator = (manager = (Manager)object).getSessionIdGenerator()) != null) {
            this.storeElement(printWriter, n, sessionIdGenerator);
        }
    }
}

