/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotWritableException;
import jakarta.el.Util;
import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;

public class ResourceBundleELResolver
extends ELResolver {
    @Override
    public Object getValue(ELContext eLContext, Object object, Object object2) {
        Objects.requireNonNull(eLContext);
        if (object instanceof ResourceBundle) {
            eLContext.setPropertyResolved(object, object2);
            if (object2 != null) {
                try {
                    return ((ResourceBundle)object).getObject(object2.toString());
                }
                catch (MissingResourceException missingResourceException) {
                    return "???" + object2.toString() + "???";
                }
            }
        }
        return null;
    }

    @Override
    public Class<?> getType(ELContext eLContext, Object object, Object object2) {
        Objects.requireNonNull(eLContext);
        if (object instanceof ResourceBundle) {
            eLContext.setPropertyResolved(object, object2);
        }
        return null;
    }

    @Override
    public void setValue(ELContext eLContext, Object object, Object object2, Object object3) {
        Objects.requireNonNull(eLContext);
        if (object instanceof ResourceBundle) {
            eLContext.setPropertyResolved(object, object2);
            throw new PropertyNotWritableException(Util.message(eLContext, "resolverNotWritable", object.getClass().getName()));
        }
    }

    @Override
    public boolean isReadOnly(ELContext eLContext, Object object, Object object2) {
        Objects.requireNonNull(eLContext);
        if (object instanceof ResourceBundle) {
            eLContext.setPropertyResolved(object, object2);
            return true;
        }
        return false;
    }

    @Override
    @Deprecated(forRemoval=true, since="EL 5.0")
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext eLContext, Object object) {
        if (object instanceof ResourceBundle) {
            ArrayList<FeatureDescriptor> arrayList = new ArrayList<FeatureDescriptor>();
            Enumeration<String> enumeration = ((ResourceBundle)object).getKeys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                FeatureDescriptor featureDescriptor = new FeatureDescriptor();
                featureDescriptor.setDisplayName(string);
                featureDescriptor.setShortDescription("");
                featureDescriptor.setExpert(false);
                featureDescriptor.setHidden(false);
                featureDescriptor.setName(string);
                featureDescriptor.setPreferred(true);
                featureDescriptor.setValue("resolvableAtDesignTime", Boolean.TRUE);
                featureDescriptor.setValue("type", String.class);
                arrayList.add(featureDescriptor);
            }
            return arrayList.iterator();
        }
        return null;
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext eLContext, Object object) {
        if (object instanceof ResourceBundle) {
            return String.class;
        }
        return null;
    }
}

