/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import org.apache.catalina.startup.Bootstrap;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public final class ClassLoaderFactory {
    private static final Log log = LogFactory.getLog(ClassLoaderFactory.class);

    public static ClassLoader createClassLoader(File[] fileArray, File[] fileArray2, final ClassLoader classLoader) throws Exception {
        Object object;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating new class loader");
        }
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        if (fileArray != null) {
            for (Serializable serializable : fileArray) {
                if (!((File)serializable).canRead()) continue;
                File file = new File(((File)serializable).getCanonicalPath() + File.separator);
                object = file.toURI().toURL();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  Including directory " + object));
                }
                linkedHashSet.add(object);
            }
        }
        if (fileArray2 != null) {
            for (Serializable serializable : fileArray2) {
                if (!((File)serializable).isDirectory() || !((File)serializable).canRead() || (object = ((File)serializable).list()) == null) continue;
                for (String string : object) {
                    String string2 = string.toLowerCase(Locale.ENGLISH);
                    if (!string2.endsWith(".jar")) continue;
                    File file = new File((File)serializable, string);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("  Including jar file " + file.getAbsolutePath()));
                    }
                    URL uRL = file.toURI().toURL();
                    linkedHashSet.add(uRL);
                }
            }
        }
        Serializable[] serializableArray = linkedHashSet.toArray(new URL[0]);
        return AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>((URL[])serializableArray){
            final /* synthetic */ URL[] val$array;
            {
                this.val$array = uRLArray;
            }

            @Override
            public URLClassLoader run() {
                if (classLoader == null) {
                    return new URLClassLoader(this.val$array);
                }
                return new URLClassLoader(this.val$array, classLoader);
            }
        });
    }

    public static ClassLoader createClassLoader(List<Repository> list, final ClassLoader classLoader) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating new class loader");
        }
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        if (list != null) {
            for (Repository repository : list) {
                String[] stringArray;
                Serializable serializable;
                if (repository.getType() == RepositoryType.URL) {
                    serializable = ClassLoaderFactory.buildClassLoaderUrl(repository.getLocation());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("  Including URL " + serializable));
                    }
                    linkedHashSet.add(serializable);
                    continue;
                }
                if (repository.getType() == RepositoryType.DIR) {
                    serializable = new File(repository.getLocation());
                    if (!ClassLoaderFactory.validateFile((File)(serializable = ((File)serializable).getCanonicalFile()), RepositoryType.DIR)) continue;
                    stringArray = ClassLoaderFactory.buildClassLoaderUrl((File)serializable);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("  Including directory " + stringArray));
                    }
                    linkedHashSet.add(stringArray);
                    continue;
                }
                if (repository.getType() == RepositoryType.JAR) {
                    serializable = new File(repository.getLocation());
                    if (!ClassLoaderFactory.validateFile((File)(serializable = ((File)serializable).getCanonicalFile()), RepositoryType.JAR)) continue;
                    stringArray = ClassLoaderFactory.buildClassLoaderUrl((File)serializable);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("  Including jar file " + stringArray));
                    }
                    linkedHashSet.add(stringArray);
                    continue;
                }
                if (repository.getType() != RepositoryType.GLOB) continue;
                serializable = new File(repository.getLocation());
                if (!ClassLoaderFactory.validateFile((File)(serializable = ((File)serializable).getCanonicalFile()), RepositoryType.GLOB)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  Including directory glob " + ((File)serializable).getAbsolutePath()));
                }
                if ((stringArray = ((File)serializable).list()) == null) continue;
                for (String string : stringArray) {
                    String string2 = string.toLowerCase(Locale.ENGLISH);
                    if (!string2.endsWith(".jar")) continue;
                    File file = new File((File)serializable, string);
                    if (!ClassLoaderFactory.validateFile(file = file.getCanonicalFile(), RepositoryType.JAR)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("    Including glob jar file " + file.getAbsolutePath()));
                    }
                    URL uRL = ClassLoaderFactory.buildClassLoaderUrl(file);
                    linkedHashSet.add(uRL);
                }
            }
        }
        final URL[] uRLArray = linkedHashSet.toArray(new URL[0]);
        if (log.isDebugEnabled()) {
            for (int i = 0; i < uRLArray.length; ++i) {
                log.debug((Object)("  location " + i + " is " + uRLArray[i]));
            }
        }
        return AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                if (classLoader == null) {
                    return new URLClassLoader(uRLArray);
                }
                return new URLClassLoader(uRLArray, classLoader);
            }
        });
    }

    private static boolean validateFile(File file, RepositoryType repositoryType) throws IOException {
        if (RepositoryType.DIR == repositoryType || RepositoryType.GLOB == repositoryType) {
            if (!file.isDirectory() || !file.canRead()) {
                String string = "Problem with directory [" + file + "], exists: [" + file.exists() + "], isDirectory: [" + file.isDirectory() + "], canRead: [" + file.canRead() + "]";
                File file2 = new File(Bootstrap.getCatalinaHome());
                file2 = file2.getCanonicalFile();
                File file3 = new File(Bootstrap.getCatalinaBase());
                file3 = file3.getCanonicalFile();
                File file4 = new File(file3, "lib");
                if (!file2.getPath().equals(file3.getPath()) && file.getPath().equals(file4.getPath()) && !file.exists()) {
                    log.debug((Object)string);
                } else {
                    log.warn((Object)string);
                }
                return false;
            }
        } else if (RepositoryType.JAR == repositoryType && !file.canRead()) {
            log.warn((Object)("Problem with JAR file [" + file + "], exists: [" + file.exists() + "], canRead: [" + file.canRead() + "]"));
            return false;
        }
        return true;
    }

    private static URL buildClassLoaderUrl(String string) throws MalformedURLException, URISyntaxException {
        String string2 = string.replaceAll("!/", "%21/");
        return new URI(string2).toURL();
    }

    private static URL buildClassLoaderUrl(File file) throws MalformedURLException, URISyntaxException {
        String string = file.toURI().toString();
        string = string.replaceAll("!/", "%21/");
        return new URI(string).toURL();
    }

    public static class Repository {
        private final String location;
        private final RepositoryType type;

        public Repository(String string, RepositoryType repositoryType) {
            this.location = string;
            this.type = repositoryType;
        }

        public String getLocation() {
            return this.location;
        }

        public RepositoryType getType() {
            return this.type;
        }
    }

    public static enum RepositoryType {
        DIR,
        GLOB,
        JAR,
        URL;

    }
}

