/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;

public class Utf8Encoder
extends CharsetEncoder {
    public Utf8Encoder() {
        super(StandardCharsets.UTF_8, 1.1f, 4.0f);
    }

    @Override
    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (charBuffer.hasArray() && byteBuffer.hasArray()) {
            return this.encodeHasArray(charBuffer, byteBuffer);
        }
        return this.encodeNotHasArray(charBuffer, byteBuffer);
    }

    private CoderResult encodeHasArray(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        int n2 = charBuffer.position();
        int n3 = charBuffer.limit();
        int n4 = n2;
        byte[] byArray = byteBuffer.array();
        char[] cArray = charBuffer.array();
        int n5 = byteBuffer.position();
        int n6 = charBuffer.remaining();
        for (n4 = n2; n4 < n2 + n6; ++n4) {
            int n7 = cArray[n4] & 0xFFFF;
            if (n7 <= 127) {
                if (n < 1) {
                    charBuffer.position(n4);
                    byteBuffer.position(n5);
                    return CoderResult.OVERFLOW;
                }
                byArray[n5++] = (byte)(n7 & 0xFF);
                --n;
            } else if (n7 <= 2047) {
                if (n < 2) {
                    charBuffer.position(n4);
                    byteBuffer.position(n5);
                    return CoderResult.OVERFLOW;
                }
                byArray[n5++] = (byte)(192 + (n7 >> 6 & 0x1F));
                byArray[n5++] = (byte)(128 + (n7 & 0x3F));
                n -= 2;
            } else if (n7 >= 55296 && n7 <= 57343) {
                if (n3 <= n4 + 1) {
                    charBuffer.position(n4);
                    byteBuffer.position(n5);
                    return CoderResult.UNDERFLOW;
                }
                if (n < 4) {
                    charBuffer.position(n4);
                    byteBuffer.position(n5);
                    return CoderResult.OVERFLOW;
                }
                if (n7 >= 56320) {
                    charBuffer.position(n4);
                    byteBuffer.position(n5);
                    return CoderResult.malformedForLength(1);
                }
                int n8 = cArray[n4 + 1] & 0xFFFF;
                if (n8 < 56320) {
                    charBuffer.position(n4);
                    byteBuffer.position(n5);
                    return CoderResult.malformedForLength(1);
                }
                int n9 = (n7 << 10) + n8 + -56613888;
                byArray[n5++] = (byte)(240 + (n9 >> 18 & 7));
                byArray[n5++] = (byte)(128 + (n9 >> 12 & 0x3F));
                byArray[n5++] = (byte)(128 + (n9 >> 6 & 0x3F));
                byArray[n5++] = (byte)(128 + (n9 & 0x3F));
                n -= 4;
                ++n4;
            } else {
                if (n < 3) {
                    charBuffer.position(n4);
                    byteBuffer.position(n5);
                    return CoderResult.OVERFLOW;
                }
                byArray[n5++] = (byte)(224 + (n7 >> 12 & 0xF));
                byArray[n5++] = (byte)(128 + (n7 >> 6 & 0x3F));
                byArray[n5++] = (byte)(128 + (n7 & 0x3F));
                n -= 3;
            }
            if (n != 0) continue;
            charBuffer.position(n4 + 1);
            byteBuffer.position(n5);
            if (n4 + 1 == n3) {
                return CoderResult.UNDERFLOW;
            }
            return CoderResult.OVERFLOW;
        }
        if (n6 != 0) {
            charBuffer.position(n4);
            byteBuffer.position(n5);
        }
        return CoderResult.UNDERFLOW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeNotHasArray(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n;
        int n2 = byteBuffer.remaining();
        int n3 = charBuffer.limit();
        try {
            for (n = charBuffer.position(); n < n3; ++n) {
                if (n2 == 0) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                int n4 = charBuffer.get() & 0xFFFF;
                if (n4 <= 127) {
                    if (n2 < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    byteBuffer.put((byte)n4);
                    --n2;
                    continue;
                }
                if (n4 <= 2047) {
                    if (n2 < 2) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    byteBuffer.put((byte)(192 + (n4 >> 6 & 0x1F)));
                    byteBuffer.put((byte)(128 + (n4 & 0x3F)));
                    n2 -= 2;
                    continue;
                }
                if (n4 >= 55296 && n4 <= 57343) {
                    if (n3 <= n + 1) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    if (n2 < 4) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    if (n4 >= 56320) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    int n5 = charBuffer.get() & 0xFFFF;
                    if (n5 < 56320) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    int n6 = (n4 << 10) + n5 + -56613888;
                    byteBuffer.put((byte)(240 + (n6 >> 18 & 7)));
                    byteBuffer.put((byte)(128 + (n6 >> 12 & 0x3F)));
                    byteBuffer.put((byte)(128 + (n6 >> 6 & 0x3F)));
                    byteBuffer.put((byte)(128 + (n6 & 0x3F)));
                    n2 -= 4;
                    ++n;
                    continue;
                }
                if (n2 < 3) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                byteBuffer.put((byte)(224 + (n4 >> 12 & 0xF)));
                byteBuffer.put((byte)(128 + (n4 >> 6 & 0x3F)));
                byteBuffer.put((byte)(128 + (n4 & 0x3F)));
                n2 -= 3;
            }
        }
        finally {
            charBuffer.position(n);
        }
        return CoderResult.UNDERFLOW;
    }
}

