/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.truffle.TruffleType;
import org.graalvm.visualvm.heapviewer.truffle.swing.EditableHistoryCombo;
import org.graalvm.visualvm.heapviewer.truffle.ui.Bundle;
import org.graalvm.visualvm.heapviewer.ui.TreeTableView;
import org.graalvm.visualvm.lib.jfluid.filters.GenericFilter;
import org.graalvm.visualvm.lib.jfluid.filters.TextFilter;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.profiler.api.ActionsSupport;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.components.CloseButton;
import org.graalvm.visualvm.lib.ui.results.ColoredFilter;
import org.graalvm.visualvm.lib.ui.results.PackageColorer;
import org.graalvm.visualvm.lib.ui.swing.InvisibleToolbar;
import org.graalvm.visualvm.lib.ui.swing.PopupButton;

final class FilterUtils {
    private static final String FILTER_ACTION_KEY = "filter-action-key";
    private static final String FILTER_CHANGED = "filter-changed";

    public static boolean filter(TreeTableView view, final GenericFilter textFilter, RowFilter excludesFilter) {
        if (textFilter.isAll()) {
            view.setViewFilter(null);
            return false;
        }
        view.setViewFilter(new HeapViewerNodeFilter(){

            public boolean passes(HeapViewerNode node, Heap heap) {
                String typeName = (String)HeapViewerNode.getValue((HeapViewerNode)node, TruffleType.TYPE_NAME, (Heap)heap);
                return typeName == null ? true : textFilter.passes(typeName);
            }
        });
        return true;
    }

    public static JComponent createFilterPanel(TreeTableView view) {
        return FilterUtils.createFilterPanel(view, null);
    }

    public static JComponent createFilterPanel(TreeTableView view, RowFilter excludesFilter) {
        return FilterUtils.createFilterPanel(view, excludesFilter, null);
    }

    public static JComponent createFilterPanel(final TreeTableView view, final RowFilter excludesFilter, Component[] options) {
        InvisibleToolbar toolbar = new InvisibleToolbar();
        if (UIUtils.isWindowsModernLookAndFeel()) {
            toolbar.setBorder(BorderFactory.createEmptyBorder(2, 2, 1, 2));
        } else if (!UIUtils.isNimbusLookAndFeel() && !UIUtils.isAquaLookAndFeel()) {
            toolbar.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        }
        toolbar.add(Box.createHorizontalStrut(6));
        toolbar.add(new JLabel(Bundle.TruffleFilterUtils_TypeFilter()));
        toolbar.add(Box.createHorizontalStrut(3));
        final EditableHistoryCombo combo = new EditableHistoryCombo();
        final JTextComponent textC = combo.getTextComponent();
        JPanel comboContainer = new JPanel(new BorderLayout());
        comboContainer.add((Component)combo, "Center");
        comboContainer.setMinimumSize(combo.getMinimumSize());
        comboContainer.setPreferredSize(combo.getPreferredSize());
        comboContainer.setMaximumSize(combo.getMaximumSize());
        toolbar.add(comboContainer);
        if (PackageColorer.hasRegisteredColors()) {
            toolbar.add((Component)new PopupButton(){
                {
                    this.setToolTipText(Bundle.TruffleFilterUtils_InsertFilter());
                }

                protected void populatePopup(JPopupMenu popup) {
                    for (final ColoredFilter color : PackageColorer.getRegisteredColors()) {
                        if (color.getValue().trim().isEmpty()) continue;
                        Icon icon = color.getColor() == null ? null : color.getIcon(12, 12);
                        popup.add(new JMenuItem(color.getName(), icon){

                            @Override
                            protected void fireActionPerformed(ActionEvent event) {
                                String current = FilterUtils.getFilterString(combo);
                                if (current == null) {
                                    current = "";
                                }
                                if (!current.isEmpty()) {
                                    current = current + " ";
                                }
                                current = current + color.getValue();
                                textC.setText(current);
                                combo.requestFocusInWindow();
                            }
                        });
                    }
                }
            });
        }
        toolbar.add(Box.createHorizontalStrut(5));
        KeyStroke escKey = KeyStroke.getKeyStroke(27, 0);
        KeyStroke filterKey = KeyStroke.getKeyStroke(10, 0);
        final TextFilter activeFilter = new TextFilter(){

            protected void handleInvalidFilter(String invalidValue, RuntimeException e) {
                ProfilerDialogs.displayError((String)Bundle.TruffleFilterUtils_InvalidRegexp(invalidValue));
            }
        };
        final TextFilter currentFilter = new TextFilter();
        final JButton filter = new JButton(Bundle.TruffleFilterUtils_ActionFilter(), Icons.getIcon((String)"GeneralIcons.Filter")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                final 4 _this = this;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        activeFilter.copyFrom(currentFilter);
                        if (FilterUtils.filter(view, (GenericFilter)activeFilter, excludesFilter)) {
                            combo.addItem(activeFilter.getValue());
                        }
                        this.putClientProperty(FilterUtils.FILTER_CHANGED, null);
                        FilterUtils.updateFilterButton(_this, currentFilter, activeFilter);
                    }
                });
            }
        };
        String filterAccelerator = ActionsSupport.keyAcceleratorString((KeyStroke)filterKey);
        filter.setToolTipText(Bundle.TruffleFilterUtils_FilterResults(filterAccelerator));
        filter.putClientProperty("JComponent.sizeVariant", "regular");
        AbstractAction filterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (filter.isEnabled()) {
                            filter.doClick();
                            combo.requestFocusInWindow();
                        }
                    }
                });
            }
        };
        FilterUtils.installAction(filter, filterAction, filterKey, FILTER_ACTION_KEY);
        toolbar.add(filter);
        FilterUtils.updateFilterButton(filter, currentFilter, activeFilter);
        toolbar.add(Box.createHorizontalStrut(2));
        toolbar.addSeparator();
        toolbar.add(Box.createHorizontalStrut(1));
        final JToggleButton matchCase = new JToggleButton(Icons.getIcon((String)"GeneralIcons.MatchCase")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                if (this.isEnabled()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            currentFilter.setCaseSensitive(this.isSelected());
                            FilterUtils.updateFilterButton(filter, currentFilter, activeFilter);
                        }
                    });
                }
            }
        };
        matchCase.setToolTipText(Bundle.TruffleFilterUtils_MatchCase());
        FilterUtils.installAction(matchCase, filterAction, filterKey, FILTER_ACTION_KEY);
        FilterType filterType = new FilterType(Icons.getIcon((String)"GeneralIcons.FilterContains")){

            protected void populatePopup(JPopupMenu popup) {
                popup.add(new JMenuItem(Bundle.TruffleFilterUtils_FilterContains(), Icons.getIcon((String)"GeneralIcons.FilterContains")){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        this.filterImpl(10, this.getIcon(), this.getText());
                    }
                });
                popup.add(new JMenuItem(Bundle.TruffleFilterUtils_FilterNotContains(), Icons.getIcon((String)"GeneralIcons.FilterNotContains")){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        this.filterImpl(20, this.getIcon(), this.getText());
                    }
                });
                popup.add(new JMenuItem(Bundle.TruffleFilterUtils_FilterRegExp(), Icons.getIcon((String)"GeneralIcons.FilterRegExp")){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        this.filterImpl(30, this.getIcon(), this.getText());
                    }
                });
            }

            @Override
            protected void filterImpl(final int type, final Icon icon, final String name) {
                if (type == 30) {
                    matchCase.setEnabled(false);
                    matchCase.setSelected(false);
                } else if (!matchCase.isEnabled()) {
                    matchCase.setSelected(currentFilter.isCaseSensitive());
                    matchCase.setEnabled(true);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.setIcon(icon);
                        this.setToolTipText(Bundle.TruffleFilterUtils_FilterType(name));
                        currentFilter.setType(type);
                        FilterUtils.updateFilterButton(filter, currentFilter, activeFilter);
                    }
                });
            }
        };
        filterType.setToolTipText(Bundle.TruffleFilterUtils_FilterType(Bundle.TruffleFilterUtils_FilterContains()));
        FilterUtils.installAction((JComponent)((Object)filterType), filterAction, filterKey, FILTER_ACTION_KEY);
        toolbar.add((Component)((Object)filterType));
        toolbar.add(matchCase);
        if (options != null) {
            for (Component option : options) {
                toolbar.add(option);
            }
        }
        toolbar.add(Box.createHorizontalStrut(2));
        combo.setOnTextChangeHandler(new Runnable(){

            @Override
            public void run() {
                currentFilter.setValue(FilterUtils.getFilterString(combo));
                FilterUtils.updateFilterButton(filter, currentFilter, activeFilter);
            }
        });
        final JPanel panel = new JPanel(new BorderLayout()){

            @Override
            public void setVisible(boolean visible) {
                super.setVisible(visible);
                if (!visible) {
                    view.getComponent().requestFocusInWindow();
                }
            }

            @Override
            public boolean requestFocusInWindow() {
                if (textC != null) {
                    textC.selectAll();
                }
                return combo.requestFocusInWindow();
            }
        };
        panel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("controlShadow")));
        panel.add((Component)toolbar, "Center");
        final Runnable hider = new Runnable(){

            @Override
            public void run() {
                boolean wasAll = activeFilter.isAll();
                activeFilter.setValue("");
                FilterUtils.updateFilterButton(filter, currentFilter, activeFilter);
                if (!wasAll) {
                    FilterUtils.filter(view, (GenericFilter)activeFilter, excludesFilter);
                }
                panel.setVisible(false);
            }
        };
        JButton closeButton = CloseButton.create((Runnable)hider);
        closeButton.setFocusable(true);
        String escAccelerator = ActionsSupport.keyAcceleratorString((KeyStroke)escKey);
        closeButton.setToolTipText(Bundle.TruffleFilterUtils_Close(escAccelerator));
        panel.add((Component)closeButton, "East");
        String HIDE = "hide-action";
        InputMap map = panel.getInputMap(1);
        AbstractAction hiderAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                hider.run();
            }
        };
        panel.getActionMap().put(HIDE, hiderAction);
        map.put(escKey, HIDE);
        if (textC != null) {
            map = textC.getInputMap();
            AbstractAction _filterAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (combo.isPopupVisible()) {
                        combo.hidePopup();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (filter.isEnabled()) {
                                filter.doClick();
                            }
                        }
                    });
                }
            };
            textC.getActionMap().put(FILTER_ACTION_KEY, _filterAction);
            map.put(filterKey, FILTER_ACTION_KEY);
        }
        panel.putClientProperty("SET_FILTER_CHANGED", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                filter.putClientProperty(FilterUtils.FILTER_CHANGED, Boolean.TRUE);
                FilterUtils.updateFilterButton(filter, currentFilter, activeFilter);
            }
        });
        panel.putClientProperty("FILTER_STRING", textC);
        panel.putClientProperty("FILTER_TYPE", (Object)filterType);
        panel.putClientProperty("FILTER_ACTION", filterAction);
        return panel;
    }

    private static void installAction(JComponent comp, Action action, KeyStroke keyStroke, String actionKey) {
        comp.getActionMap().put(actionKey, action);
        comp.getInputMap().put(keyStroke, actionKey);
    }

    private static String getFilterString(EditableHistoryCombo combo) {
        String filter = combo.getText();
        return filter == null ? null : filter.trim();
    }

    private static void updateFilterButton(JButton button, TextFilter currentFilter, TextFilter activeFilter) {
        if (Boolean.TRUE.equals(button.getClientProperty(FILTER_CHANGED))) {
            button.setEnabled(true);
        } else {
            button.setEnabled(!currentFilter.equals((Object)activeFilter));
        }
    }

    private FilterUtils() {
    }

    private static abstract class Filter
    extends RowFilter {
        private Filter() {
        }

        public boolean equals(Object o) {
            return o instanceof Filter;
        }

        public int hashCode() {
            return Integer.MAX_VALUE;
        }
    }

    private static abstract class FilterType
    extends PopupButton {
        FilterType(Icon icon) {
            super(icon);
        }

        protected abstract void filterImpl(int var1, Icon var2, String var3);
    }
}

