/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.instrumentation;

import org.graalvm.visualvm.lib.jfluid.ProfilerEngineSettings;
import org.graalvm.visualvm.lib.jfluid.classfile.DynamicClassInfo;
import org.graalvm.visualvm.lib.jfluid.global.ProfilingSessionStatus;
import org.graalvm.visualvm.lib.jfluid.instrumentation.RecursiveMethodInstrumentor;
import org.graalvm.visualvm.lib.jfluid.instrumentation.RootMethods;
import org.graalvm.visualvm.lib.jfluid.utils.Wildcards;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.RootClassLoadedCommand;

public class RecursiveMethodInstrumentor3
extends RecursiveMethodInstrumentor {
    private boolean noExplicitRootsSpecified = false;
    private boolean mainMethodInstrumented = false;

    public RecursiveMethodInstrumentor3(ProfilingSessionStatus status, ProfilerEngineSettings settings) {
        super(status, settings);
    }

    @Override
    public Object[] getMethodsToInstrumentUponClassLoad(String className, int classLoaderId, boolean threadInCallGraph) {
        boolean normallyFilteredOut;
        DynamicClassInfo clazz;
        boolean DEBUG = false;
        if (DEBUG) {
            System.out.println("*** MS2: instr. upon CL: " + className);
        }
        if ((clazz = RecursiveMethodInstrumentor3.javaClassForName(className = className.replace('.', '/').intern(), classLoaderId)) == null) {
            return null;
        }
        if (DEBUG) {
            System.out.println("*** MS2: instr. upon CL 2: " + clazz.getNameAndLoader());
        }
        clazz.setLoaded(true);
        this.addToSubclassList(clazz, clazz);
        if (clazz.isInterface()) {
            return null;
        }
        this.initInstrMethodData();
        boolean isRootClass = false;
        int rootIdxForAll = -1;
        this.markProfilingPonitForInstrumentation(clazz);
        isRootClass = this.tryInstrumentSpawnedThreads(clazz);
        if (this.noExplicitRootsSpecified && !this.mainMethodInstrumented && this.tryMainMethodInstrumentation(clazz)) {
            isRootClass = true;
            if (!clazz.getName().startsWith("sun/launcher/Launcher")) {
                this.mainMethodInstrumented = true;
            }
        }
        if (!isRootClass) {
            for (int rIdx = 0; rIdx < this.rootMethods.classNames.length; ++rIdx) {
                String rootClassName = this.rootMethods.classNames[rIdx];
                if (this.rootMethods.classesWildcard[rIdx]) {
                    if (!Wildcards.matchesWildcard(rootClassName, className)) continue;
                    isRootClass = true;
                    break;
                }
                if (!className.equals(rootClassName)) continue;
                isRootClass = true;
                break;
            }
        }
        boolean bl = normallyFilteredOut = !this.instrFilter.passes(className);
        if (!isRootClass && normallyFilteredOut) {
            return this.createInstrumentedMethodPack();
        }
        for (int rIdx = 0; rIdx < this.rootMethods.classNames.length; ++rIdx) {
            String rootClassName = this.rootMethods.classNames[rIdx];
            boolean isMatch = false;
            if (this.rootMethods.classesWildcard[rIdx]) {
                if (Wildcards.matchesWildcard(rootClassName, className)) {
                    isMatch = true;
                }
            } else if (className.equals(rootClassName)) {
                isMatch = true;
            }
            if (!isMatch) continue;
            if (Wildcards.isPackageWildcard(rootClassName) || Wildcards.isMethodWildcard(this.rootMethods.methodNames[rIdx])) {
                if (this.rootMethods.markerMethods[rIdx]) {
                    this.markAllMethodsMarker(clazz);
                    continue;
                }
                this.markAllMethodsRoot(clazz);
                continue;
            }
            this.markMethod(clazz, rIdx);
            this.checkAndMarkMethodForInstrumentation(clazz, this.rootMethods.methodNames[rIdx], this.rootMethods.methodSignatures[rIdx]);
        }
        if (!normallyFilteredOut || clazz.getAllMethodsMarkers() || clazz.getAllMethodsRoots()) {
            this.checkAndMarkAllMethodsForInstrumentation(clazz);
        }
        return this.createInstrumentedMethodPack();
    }

    @Override
    public Object[] getMethodsToInstrumentUponMethodInvocation(String className, int classLoaderId, String methodName, String methodSignature) {
        throw new IllegalStateException("Class " + className + " method " + methodName);
    }

    @Override
    public Object[] getMethodsToInstrumentUponReflectInvoke(String className, int classLoaderId, String methodName, String methodSignature) {
        return null;
    }

    @Override
    protected void findAndMarkOverridingMethodsReachable(DynamicClassInfo superClass, DynamicClassInfo subClass) {
    }

    @Override
    protected void processInvoke(DynamicClassInfo clazz, boolean virtualCall, int index) {
    }

    @Override
    protected boolean tryInstrumentSpawnedThreads(DynamicClassInfo clazz) {
        if ((this.instrumentSpawnedThreads || this.noExplicitRootsSpecified) && clazz.implementsInterface("java/lang/Runnable") && clazz.getName() != "java/lang/Thread") {
            boolean res = this.markMethodRoot(clazz, "run", "()V");
            this.checkAndMarkMethodForInstrumentation(clazz, "run", "()V");
            return res;
        }
        return false;
    }

    protected boolean tryMainMethodInstrumentation(DynamicClassInfo clazz) {
        int idx = clazz.getMethodIndex("main", "([Ljava/lang/String;)V");
        if (idx == -1) {
            return false;
        }
        if (!clazz.isMethodStatic(idx) || !clazz.isMethodPublic(idx)) {
            return false;
        }
        this.markMethodRoot(clazz, "main", "([Ljava/lang/String;)V");
        this.checkAndMarkMethodForInstrumentation(clazz, idx);
        return true;
    }

    @Override
    Object[] getInitialMethodsToInstrument(RootClassLoadedCommand rootLoaded, RootMethods roots) {
        DynamicClassInfo[] loadedClassInfos = this.preGetInitialMethodsToInstrument(rootLoaded);
        this.rootMethods = roots;
        this.checkForNoRootsSpecified(roots);
        for (DynamicClassInfo loadedClassInfo : loadedClassInfos) {
            if (loadedClassInfo == null) continue;
            this.markProfilingPonitForInstrumentation(loadedClassInfo);
            this.tryInstrumentSpawnedThreads(loadedClassInfo);
            for (int rIdx = 0; rIdx < this.rootMethods.classNames.length; ++rIdx) {
                String rootClassName = this.rootMethods.classNames[rIdx];
                boolean isMatch = false;
                if (this.rootMethods.classesWildcard[rIdx]) {
                    if (Wildcards.matchesWildcard(rootClassName, loadedClassInfo.getName())) {
                        isMatch = true;
                    }
                } else if (loadedClassInfo.getName().equals(rootClassName)) {
                    isMatch = true;
                }
                if (!isMatch) continue;
                if (Wildcards.isPackageWildcard(rootClassName) || Wildcards.isMethodWildcard(this.rootMethods.methodNames[rIdx])) {
                    if (this.rootMethods.markerMethods[rIdx]) {
                        this.markAllMethodsMarker(loadedClassInfo);
                        continue;
                    }
                    this.markAllMethodsRoot(loadedClassInfo);
                    continue;
                }
                this.markMethod(loadedClassInfo, rIdx);
                this.checkAndMarkMethodForInstrumentation(loadedClassInfo, this.rootMethods.methodNames[rIdx], this.rootMethods.methodSignatures[rIdx]);
            }
            this.checkAndMarkAllMethodsForInstrumentation(loadedClassInfo);
        }
        this.checkAndMarkMethodForInstrumentation(RecursiveMethodInstrumentor3.javaClassForName("java/lang/ClassLoader", 0), "loadClass", "(Ljava/lang/String;)Ljava/lang/Class;");
        return this.createInstrumentedMethodPack();
    }

    private void checkAndMarkAllMethodsForInstrumentation(DynamicClassInfo clazz) {
        if (clazz.isInterface()) {
            return;
        }
        String[] methods = clazz.getMethodNames();
        for (int i = 0; i < methods.length; ++i) {
            this.checkAndMarkMethodForInstrumentation(clazz, i);
        }
    }

    private void checkAndMarkMethodForInstrumentation(DynamicClassInfo clazz, String methodName, String methodSignature) {
        if (clazz == null) {
            return;
        }
        int idx = clazz.getMethodIndex(methodName, methodSignature);
        if (idx == -1) {
            return;
        }
        this.checkAndMarkMethodForInstrumentation(clazz, idx);
    }

    private void checkAndMarkMethodForInstrumentation(DynamicClassInfo clazz, int idx) {
        String className = clazz.getName();
        if (!clazz.isMethodReachable(idx)) {
            clazz.setMethodReachable(idx);
            if (clazz.isMethodNative(idx) || clazz.isMethodAbstract(idx) || !clazz.isMethodRoot(idx) && !clazz.isMethodMarker(idx) && !this.instrFilter.passes(className) || className == "java/lang/Object") {
                clazz.setMethodUnscannable(idx);
            } else if (clazz.getMethodName(idx) == "<init>" && !this.status.canInstrumentConstructor && clazz.getMajorVersion() > 50) {
                clazz.setMethodUnscannable(idx);
            } else {
                byte[] bytecode = clazz.getMethodBytecode(idx);
                if (this.dontInstrumentEmptyMethods && RecursiveMethodInstrumentor3.isEmptyMethod(bytecode) || this.dontScanGetterSetterMethods && RecursiveMethodInstrumentor3.isGetterSetterMethod(bytecode)) {
                    clazz.setMethodUnscannable(idx);
                } else {
                    clazz.setMethodLeaf(idx);
                }
            }
            if (!clazz.isMethodUnscannable(idx)) {
                this.markClassAndMethodForInstrumentation(clazz, idx);
            }
        }
    }

    private void checkForNoRootsSpecified(RootMethods roots) {
        int rootCount;
        this.noExplicitRootsSpecified = true;
        if (roots != null && roots.classNames.length != 0 && (rootCount = roots.markerMethods.length) > 0) {
            for (int i = 0; i < rootCount; ++i) {
                if (roots.markerMethods[i]) continue;
                this.noExplicitRootsSpecified = false;
                break;
            }
        }
    }

    private DynamicClassInfo[] preGetInitialMethodsToInstrument(RootClassLoadedCommand rootLoaded) {
        this.reflectInvokeInstrumented = true;
        RecursiveMethodInstrumentor3.resetLoadedClassData();
        RecursiveMethodInstrumentor3.storeClassFileBytesForCustomLoaderClasses(rootLoaded);
        this.initInstrMethodData();
        String[] loadedClasses = rootLoaded.getAllLoadedClassNames();
        int[] loadedClassLoaderIds = rootLoaded.getAllLoadedClassLoaderIds();
        DynamicClassInfo[] loadedClassInfos = new DynamicClassInfo[loadedClasses.length];
        for (int i = 0; i < loadedClasses.length; ++i) {
            DynamicClassInfo clazz = RecursiveMethodInstrumentor3.javaClassForName(loadedClasses[i], loadedClassLoaderIds[i]);
            if (clazz == null) continue;
            clazz.setLoaded(true);
            this.addToSubclassList(clazz, clazz);
            loadedClassInfos[i] = clazz;
        }
        return loadedClassInfos;
    }
}

