/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.search.SearchRoot;
import org.netbeans.api.search.provider.SearchInfo;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.modules.search.BasicSearchCriteria;
import org.netbeans.modules.search.BasicSearchProvider;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.ResultDisplayer;
import org.netbeans.modules.search.matcher.AbstractMatcher;
import org.netbeans.modules.search.ui.UiUtils;
import org.netbeans.spi.search.SearchScopeDefinition;
import org.netbeans.spi.search.provider.SearchComposition;
import org.netbeans.spi.search.provider.SearchProvider;
import org.netbeans.spi.search.provider.SearchResultsDisplayer;
import org.openide.filesystems.FileObject;

public class BasicComposition
extends SearchComposition<MatchingObject.Def> {
    private SearchInfo searchInfo;
    private AbstractMatcher matcher;
    private SearchResultsDisplayer<MatchingObject.Def> displayer = null;
    private BasicSearchCriteria basicSearchCriteria;
    private SearchProvider.Presenter presenter;
    private String scopeDisplayName;
    AtomicBoolean terminated = new AtomicBoolean(false);

    public BasicComposition(SearchInfo searchInfo, AbstractMatcher abstractMatcher, BasicSearchCriteria basicSearchCriteria, String string) {
        this.searchInfo = searchInfo;
        this.matcher = abstractMatcher;
        this.basicSearchCriteria = basicSearchCriteria;
        this.scopeDisplayName = string;
        this.presenter = BasicSearchProvider.createBasicPresenter(basicSearchCriteria.isSearchAndReplace(), basicSearchCriteria.getSearchPattern(), basicSearchCriteria.getReplaceExpr(), basicSearchCriteria.isPreserveCase(), basicSearchCriteria.getSearcherOptions(), basicSearchCriteria.isUseIgnoreList(), "last", new LastScopeDefinition(searchInfo, string));
    }

    @Override
    public void start(SearchListener searchListener) {
        Iterable<FileObject> iterable = this.searchInfo.getFilesToSearch(this.basicSearchCriteria.getSearcherOptions(), searchListener, this.terminated);
        for (FileObject fileObject : iterable) {
            MatchingObject.Def def = this.matcher.check(fileObject, searchListener);
            if (def != null) {
                this.getSearchResultsDisplayer().addMatchingObject(def);
            }
            if (!this.terminated.get()) continue;
            break;
        }
    }

    @Override
    public void terminate() {
        this.terminated.set(true);
        this.matcher.terminate();
    }

    @Override
    public boolean isTerminated() {
        return this.terminated.get();
    }

    @Override
    public synchronized SearchResultsDisplayer<MatchingObject.Def> getSearchResultsDisplayer() {
        if (this.displayer == null) {
            this.displayer = new ResultDisplayer(this.basicSearchCriteria, this);
        }
        return this.displayer;
    }

    public SearchResultsDisplayer<MatchingObject.Def> getDisplayer() {
        return this.displayer;
    }

    public List<FileObject> getRootFiles() {
        LinkedList<FileObject> linkedList = new LinkedList<FileObject>();
        List<SearchRoot> list = this.searchInfo.getSearchRoots();
        if (list == null) {
            return Collections.emptyList();
        }
        for (SearchRoot searchRoot : list) {
            linkedList.add(searchRoot.getFileObject());
        }
        return linkedList;
    }

    public SearchProvider.Presenter getSearchProviderPresenter() {
        return this.presenter;
    }

    public BasicSearchCriteria getBasicSearchCriteria() {
        return this.basicSearchCriteria;
    }

    public SearchInfo getSearchInfo() {
        return this.searchInfo;
    }

    public AbstractMatcher getMatcher() {
        return this.matcher;
    }

    public String getScopeDisplayName() {
        return this.scopeDisplayName;
    }

    private static class LastScopeDefinition
    extends SearchScopeDefinition {
        private static final String PREFIX = UiUtils.getText("LBL_ScopeLastName");
        private SearchInfo searchInfo;
        private String lastScopeDisplayName;

        public LastScopeDefinition(SearchInfo searchInfo, String string) {
            this.searchInfo = searchInfo;
            this.lastScopeDisplayName = this.normalizeTitle(string);
        }

        @Override
        public String getTypeId() {
            return "last";
        }

        @Override
        public String getDisplayName() {
            return PREFIX + (this.lastScopeDisplayName == null ? "" : ": " + this.lastScopeDisplayName);
        }

        @Override
        public boolean isApplicable() {
            return true;
        }

        @Override
        public SearchInfo getSearchInfo() {
            return this.searchInfo;
        }

        @Override
        public int getPriority() {
            return 0;
        }

        @Override
        public void clean() {
        }

        private String normalizeTitle(String string) {
            if (string == null || string.equals(PREFIX)) {
                return null;
            }
            if (string.startsWith(PREFIX + ": ")) {
                return string.substring(PREFIX.length() + 2);
            }
            return string;
        }
    }
}

